<?php
// -------------------------------------------------------------------------------------------------- //
// --------------- Follow call and do the recovery procedure in case something went wrong ----------- //
// -------------------------------------------------------------------------------------------------- //
ini_set('display_errors', 'On');
 

// import
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/debug.php";
require_once dirname(__FILE__) . "/../../../includes/config.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../waybill_order/waybill_order_core.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";


//init objetcs
$tenderCore = new TenderCore();
$waybillOrderCore = new WaybillOrderCore();
$taskQueuesCore = new TaskQueuesCore();


// get the params from POST
$waybill_order_id = $_GET['waybill_order_id'];

try{

    // check the call_center system to ask for the waybill_order_id
    $url = Config::$call_center_base_url . "/callDetailsByRemoteId/$waybill_order_id";
    $result = callAPI("GET",$url,false);
    $result = json_decode($result);

    // check the status of the call, and take the appropriate action
    switch ($result->status) {

        // the call is (pending on call center queue) but the waybill_order is "جار الاتصال",
        // that means the CC system re-inserted the record after a failed attempt but it did not update the waybill_order status
        // the action here is to change waybill_order status from "PENDING" > "WAITING"
        case 'NEW':
            $waybillOrderCore->changeStatus($waybill_order_id,"WAITING",0);
            break;

        // the call is still in progress, sleep again and retry the call
        case 'LOCKED':

            // get the call timeout from the slot
            $url = Config::$call_center_base_url . "/getSlotDetails";
            $slotResult = callAPI("GET",$url,false);
            $slotResult = json_decode($slotResult);
            $slots = json_decode(($slotResult[0][0]->slots));
            $follow_call_timeout = 120;
            foreach ($slots as $slotObj) {
                if($slotObj->id = $result->slot_id){
                    $follow_call_timeout = $slotObj->slotDetails->call_timeout;
                }
            }

            // repush the follow task
            $taskQueuesCore->addFollowCallTask($waybill_order_id, ['delay_seconds' => $follow_call_timeout, "name" => $waybill_order_id . "_follow_" . rand(0,10000)]);
            break;

        // the call is complete, take its result and process it
        case 'COMPLETE':case 'FAILED':
            $callDetails = json_decode($result->call_details);
            foreach ($callDetails->call_back_functions as $call_back) {
                if(property_exists($call_back,"processPhoneCallResult")){
                    $processPhoneCallUrl = $call_back->processPhoneCallResult;
                }
            }
            $callActivities = json_decode($result->activities);
            $callResult = $callActivities->result;
            $url = $processPhoneCallUrl . "&id=$waybill_order_id&result=$callResult";
            $result = callAPI("GET",$url,false);

            break;

        // the call does not exist on call center system, the push it again
        default:
            $tenderCore->createCallTicket($waybill_order_id);
            break;
    }

}

catch(Exception $e){

}