<?php
// ---------------------------------------------------------------- //
// --------------- create waybill orders for companies ------------ //
// ---------------------------------------------------------------- //
ini_set('display_errors', 'On');

$starttime = microtime(true);

// import
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../waybill_order/waybill_order_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../social/social_core.php";
require_once dirname(__FILE__) . "/../../tender_company/tender_company_core.php";
require_once dirname(__FILE__) . "/../../assign_cargo/assign_cargo_core.php";
require_once (dirname(__FILE__). "/../../cargo/cargo_core.php");
require_once (dirname(__FILE__). "/../../company/trucking_company/trucking_company_core.php");

//init objetcs
$waybillOrderCore = new WaybillOrderCore();
$tenderCore = new TenderCore();
$socialCore = new SocialCore();
$tenderCompanyCore = new TenderCompanyCore();
$assignCargoCore = new AssignCargoCore();
$cargoCore = new CargoCore();
$truckingCompanyCore = new TruckingCompanyCore();
 
// get the params from POST
$all_orders = json_decode('[{"id":"4373","count":"75","questionnaire":"الرجاء تحديد الوجهات المطلوبة : صوامع الجويدة / الرجاء تحديد مواقع التحميل المطلوبة : نوع المقطورة : الكل / "},{"id":"4374","count":"45","questionnaire":"الرجاء تحديد الوجهات المطلوبة : صوامع الرصيفة / الرجاء تحديد مواقع التحميل المطلوبة : نوع المقطورة : الكل / "},{"id":"4375","count":"45","questionnaire":"الرجاء تحديد الوجهات المطلوبة : مطحنة جنوب عمان / الرجاء تحديد مواقع التحميل المطلوبة : نوع المقطورة : الكل / "},{"id":"4376","count":"30","questionnaire":"الرجاء تحديد الوجهات المطلوبة : مطحنة الدقيق الاردنية / الرجاء تحديد مواقع التحميل المطلوبة : نوع المقطورة : قلاب / "}]');
$tender_company_id = 111;

// loop on the assign result      
foreach ($all_orders as $orderObj) {            

    $tenderOrderBean = $tenderCore->getTenderOrderBasic($orderObj->id,0);
    $tenderBean = $tenderCore->getTenderBasic($tenderOrderBean->tender_id,0);
    $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany([['key'=>'id','val' =>$tender_company_id]],1,0,0) ;
    $tenderCompanyBean = $tenderCompaniesReuslt->data[0];

    for ($i=0; $i < 7; $i++) {

        // create waybill order bean
        $waybillOrderBean = new stdClass();
        $waybillOrderBean->tender_order_id = $orderObj->id;
        $waybillOrderBean->cargo_id = $tenderOrderBean->cargo[0];
        $waybillOrderBean->queue_id = null;
        $waybillOrderBean->truck_owner_id = null;
        $waybillOrderBean->create_date = DBConnection::getSystemDate();
        $waybillOrderBean->status = "NEW";
        // Fill tc_details in waybill order
        $tc_details = new stdClass();
        $tc_details->tn = null;
        $tc_details->q_id = null;
        $tc_details->trn = null;
        $tc_details->truck_id = null;
        $tc_details->driver_nn = null;
        $tc_details->tender_id = $tenderOrderBean->tender_id;
        $tc_details->contact_nn = null;
        $tc_details->queue_name = null;
        $tc_details->driver_name = null;
        $tc_details->tender_name = $tenderBean->tender_name;
        $tc_details->contact_name = $tenderCompanyBean->name;
        $tc_details->driver_phone = null;
        $tc_details->contact_phone = null;
        $tc_details->tc_company_id = $tenderCompanyBean->trucking_company_id;
        $tc_details->truck_owner_id = null;
        $tc_details->truck_owner_nn = null;
        $tc_details->truck_owner_name = null;
        $tc_details->truck_owner_phone = null;
        $tc_details->trucking_company_id = $tenderCompanyBean->trucking_company_id;
        $tc_details->trucking_company_name = $tenderCompanyBean->name;
        $tc_details->extra_note = $tenderOrderBean->order_notes->extra_note;
        $waybillOrderBean->tc_details = $tc_details;

        $waybillOrderResult = DBConnection::insertDB("waybill_order",$waybillOrderBean,0);
    }
 
}

 