<?php
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../notes/add_notes_core.php";
require_once dirname(__FILE__) . "/../../queue/queue_core.php";

    ini_set('display_errors', 'On');

 
    // init objects
    $waybillCore = new WaybillCore();
    $addNoteCore = new Add_notes_core();
    $queueCore = new QueueCore();

    // init user params
    $remarks = "السبب : اغلاق المستند بسبب مرور أكثر من 12 ساعة على التحميل";

    $sql = "SELECT 
    w.id
    FROM
    waybill_view w
    WHERE   
        w.tender_id  in (3,13)        
        AND w.status IN ('ONROAD','ARRIVED')
        AND EXISTS( SELECT 
            id
        FROM
            activity a
        WHERE
            w.id = a.waybill_id
                AND a.action_code = 'CHANGE_STATUS'
                AND a.object_code = 'WAYBILL'
                AND a.object_status_code = 'PENDING'
                AND a.object_new_status_code = 'ONROAD'
                AND a.activity_date <= (NOW() - INTERVAL 12 HOUR))
    order by update_date";

    $result = DBConnection::runDatabaseQuery($sql);

foreach ($result as $wbl) {
    
    $waybill_id = $wbl->id;
 
    // get waybill bean 
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
    if($waybillBean->status == "CLOSED" || $waybillBean->status == "COMPLETE"){
        die;
    }

    // change waybill status
    $waybillCore->changeStatus($waybill_id, 'CLOSED', 0 ) ;

    // add remarks to activity
    $revokeReason = $remarks;
    $addNoteCore->addNotes('waybill', $waybill_id, $revokeReason , 0);

    // add note to waybill document
    $waybillJson = $waybillBean->document;
    $waybillJson->closedReason = new stdClass();

    $waybillJson->closedReason->reason = $revokeReason;
    $waybillJson->closedReason->remarks = '';
    $waybillBean->document = $waybillJson;
    $waybillCore->updateWaybill($waybillBean,$waybill_id,0);
    $waybillCore->logActivity($waybill_id," إغلاق المستند ","السبب : ".$revokeReason ,"CLOSED_WAYBILL",0);

    //activate the other queues if the truck has more than one
    $q_id = $waybillJson->integeration_details->queue->q_id;
    if($q_id){
        $queuesToActivateSearchFilter = [
            ['key'=>'truck_id','val' =>$waybillBean->truck_id],
            ['key'=>'status','val' =>'HELD'],
            ['key'=>'tender_id','val' =>[$waybillBean->tender_id],'op' => 'not in']
        ]; 
        $queuesToActivate = $queueCore->searchQueue($queuesToActivateSearchFilter,1000,0,0)->data;
        
        // iterate and change status to HELD for each queue
        foreach($queuesToActivate as $queue){
            $queueCore->changeStatus($queue->id,'ACTIVE',0);
            $queueCore->logActivity($queue->id, "فك تجميد الدور",
                "تم فك تجميد الدور", "activate_queue", 0);
        }
    }
 

}

