<?php
// ------------------------------------------------------------------------------------------------ //
// --------------- create new waybill order then send the required notification to user ----------- //
// ------------------------------------------------------------------------------------------------ //
ini_set('display_errors', 'On');

$starttime = microtime(true);

// import
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/debug.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
require_once dirname(__FILE__) . "/../../waybill_order/waybill_order_core.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";
require_once dirname(__FILE__) . "/../../social/social_core.php";
require_once dirname(__FILE__) . "/../../queue/queue_core.php";
require_once dirname(__FILE__) . "/../../user/user_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once (dirname(__FILE__). "/../../notes/add_notes_core.php");
require_once (dirname(__FILE__). "/../../outgoing_integration/poll.php");

//init objetcs
$waybillOrderCore = new WaybillOrderCore();
$taskQueuesCore = new TaskQueuesCore();
$queueCore = new QueueCore();
$userCore = new UserCore();
$tenderCore = new TenderCore();
$pollIntegration = new Poll;

// for testing
if(!isset($_POST['order_id'])){
    $_POST = $_GET;
}


// get the params from POST
// $order_id = $_POST['order_id'];
// $cargo_id = $_POST['cargo_id'];
// $truck_owner_id = $_POST['truck_owner_id'];
// $queue_id = $_POST['queue_id'];
// $tender_id = $_POST['tender_id'];

$order_id = 10114;
$cargo_id = 2010000002;
$truck_owner_id = 410013;
$queue_id = 466895;
$tender_id = 12;

// get the queue info
$queueSearchFilter = [['key'=>'id','val' => $queue_id]];
$queueTruckResult = $queueCore->searchQueue($queueSearchFilter,1,0,0) ;
$tn = $queueTruckResult->data[0]->tn;

try{
    DBConnection::startTransaction();
        // create waybill order
        $waybillOrderResult = $waybillOrderCore->createWaybillOrder($order_id,$cargo_id,$truck_owner_id,$queue_id,0);

        // change queue record status to WAITING
        $queueCore->changeStatus($queue_id,'WAITING',0); // By System
        $waybill_order_id = $waybillOrderResult[0]['@id'];

    DBConnection::commitTransaction();
}

catch(Exception $e){
    DBConnection::rollBackTransaction();
    $errorMessage = $e->getMessage();
    $substr1 = "SQLSTATE[10000]: <<Unknown error>>: 100 No Authority!";
    $substr2 = "PDOException: SQLSTATE[23000]: Integrity constraint violation: 1062 Duplicate entry";

    // if the error message contains one of the sub strings, skip the send
    if (strpos($errorMessage, $substr1) !== false) {}
    else if (strpos($errorMessage, $substr2) !== false) {}

    die;
}
  
// inform user in case notification is enabled in the manifest for this project
$tenderManifestJSON = $tenderCore->getTenderManifest($tender_id,0);
if($tenderManifestJSON['enableSendNotification']){
    try{

        // get the involved parties of the waybill order
        $contact_user_id = $waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
        if(!$contact_user_id || $contact_user_id == ""){

            $contact_user_id = $waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
            if(!$contact_user_id || $contact_user_id == ""){

                $wall_message = "لم يتمكن النظام من  الإتصال مع الشاحنة رقم $tn بسبب عدم تحديد جهة اتصال";
                $notification_message = "لم يتمكن النظام من  الإتصال مع الشاحنة رقم $tn بسبب عدم تحديد جهة اتصال";

                $socialCore = new SocialCore();
                $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '477'); // TODO: Fix this to CC supervisor
            }
        }

        // get user mobile version
        try{
            if($contact_user_id){
                $mobileVersion = $userCore->getUserMobileVersion($contact_user_id);
            }
            else{
                throw new Exception("Error Processing Request", 1);
            }
        }catch(Exception $e){
            $mobileVersion = "0";
        }

        // ---------------------------------------------------------------------------------------------------- //
        // create poll for the user if it has mobile version 51 , or send notification if it has less than 50
        // or push to call center if user does not have mobile app
        // ---------------------------------------------------------------------------------------------------- //
        $searchFilter = [['key'=>'id','val' => $waybill_order_id]];
        $waybillOrdersQry = $waybillOrderCore->searchWaybillOrder($searchFilter,1,0,0);
        $waybillOrder = $waybillOrdersQry->data[0];        
        $waybillOrderBean = $waybillOrderCore->getWaybillOrderBasic($waybill_order_id , 0);
        $mobileVersion = intval($mobileVersion);

        $addNoteCore = new Add_notes_core();
        $addNoteCore->addNotes('waybill_order', $waybill_order_id, 'تم انشاء استبيان لأمر الحركة' , 0);
        $order_notes = json_decode($waybillOrder->order_notes);
        
        // create new poll for user
        $tender_id = $waybillOrderBean->tc_details->tender_id;
        if($tender_id == 12){

            // get tender order destination
            $tenderOrderBean = $tenderCore->getTenderOrderBasic($order_id , 0);

            $questionnaire =$tenderOrderBean->questionnaire;
            if($questionnaire[0]){
                $order_destination = getLocationName($questionnaire[0]->val);
            }

            // in case the truck has PENDING queue on tender 11 , add note to the message
            $queueSearchFilter = [['key'=>'truck_id','val' => $truck_id],
                                    ['key'=>'tender_id','val' => 11],
                                    ['key'=>'status','val' => 'PENDING']];
            $queueTruckResult = $queueCore->searchQueue($queueSearchFilter,1,0,0) ;
 
            $info_message =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn 
            على الحمل : $waybillOrder->cargo_name 
            الوجهة: $order_destination
            تاريخ التحميل: " . $tenderOrderBean->order_date;

            if($queueTruckResult->found_rows > 0){
                $info_message .= "( في حال رفض أمر الحركة سيتم الغاء دور النفط الخام للشاحنة )";
            }

            $call_back_method = "processWaybillOrder_fuel";

        }else{
            $info_message =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn على الحمل 
            $waybillOrder->cargo_name 
            مع $waybillOrder->trucking_company_name";

            $call_back_method = "processWaybillOrder";
        }

        if($order_notes->accept_waybill_order_sms){
            $info_message .= " - " . $order_notes->accept_waybill_order_sms;
        }
        if($order_notes->extra_note){
            $info_message .= " - " . $order_notes->extra_note;
        }
        $poll = [];
        $poll['details'] = [];
   

        // questions 1
        $question1_label =  $info_message;
        if($order_notes->accept_waybill_order_sms){
            $question1_label .= " - " . $order_notes->accept_waybill_order_sms;
        }
        if($order_notes->extra_note){
            $question1_label .= " - " . $order_notes->extra_note;
        }
        $question = [];
        $question['question_id'] = "0";
        $question['validation'] = ["method" => "none"];
        $question['question_lable'] = $question1_label;
        $question['question_type'] = "SINGLE";  // SINGLE , MULTIPLE, FREE_TEXT
        $answers = [["caption"=>"الموافقة" , "value" => 1 , "theme" => "primary" , "next_question" => null] ,
                    ["caption"=>"رفض أمر الحركة" , "value" => 0 , "theme" => "outline", "next_question" => null] ];
        $question['answers'] = $answers;
        $poll['details']['questions'][] = $question;
        
        // attributes
        $poll['details']['attributes'] = [];
        $poll['details']['attributes']['title'] = 'أمر حركة للشاحنة رقم ' . $waybillOrder->tn;
        $poll['details']['attributes']['is_dismissible'] = false;
        $poll['details']['attributes']['expiry_date'] = date('Y-m-d H:i:s', strtotime("+900 minutes", strtotime(DBConnection::getSystemDate())));
        $poll['details']['attributes']['can_change_answer'] = false;
        $poll['details']['attributes']['max_retries'] = "1";
        $poll['details']['attributes']['description'] = "أمر حركة";
        $poll['details']['attributes']['communication_channel_code'] = "FCM";
        $poll['details']['attributes']['callback'] = [
                                                        ["type"=> "answer" ,
                                                        "url" => "https://api.minagate.com/waybill_order" ,
                                                        "data"=> ["waybill_order_id"=>$waybill_order_id , "method" => $call_back_method]]
                                                    ];
        $poll['details']['attributes']['notification_title'] = "لديك أمر حركة بحاجة للموافقة";
        $poll['details']['attributes']['priority'] = "1";
        $poll['details']['attributes']['scenario'] = "waybillOrderScenario";
        $poll['details']['attributes']['type'] = "notice";         // تلبيغ
        
        // recipients
        $userBean = $userCore->getUserBasic($contact_user_id , 0);        

        $poll['recipients'] = [];
        $rec = [];
        $rec['user_id'] = $userBean->id;

        // if user mobile version supports poll, send FCM poll , then SMS
        if ($mobileVersion >= 55){
            $rec['communication_channels'] = [
                ['channel' => 'FCM' , 'details' => ['fcm_registration_id'=>$userBean->notification_token] , 'status' => 'ACTIVE', 'priority'=> 1]
                ,
                ['channel' => 'SMS' , 'details' => ['phone_number'=>$userBean->phone] , 'status' => 'ACTIVE', 'priority'=> 2]
            ];

            $addNoteCore->addNotes('waybill_order', $waybill_order_id,  'تم ارسال تنبيه للإجابة على التطبيق' , 0 );

        }else{
            // send SMS only
            $rec['communication_channels'] = [
                ['channel' => 'SMS' , 'details' => ['phone_number'=>$userBean->phone] , 'status' => 'ACTIVE', 'priority'=> 1]
            ];

            //in case he does not, send his phone number to Call Center System
            $ticketResponse = $tenderCore->createCallTicket($waybill_order_id);
            $addNoteCore->addNotes('waybill_order', $waybill_order_id,  'تم ارسال استبيان أمر الحركة عبر SMS' . ' وانشاء معاملة اتصال رقم : ' . $ticketResponse['id'] , 0);

            // write the ticket_id in waybill_order
            $tc_details = $waybillOrderBean->tc_details;
            $tc_details->ticket_id = $ticketResponse['id'];
            $waybillOrderBean->tc_details = $tc_details;
            $waybillOrderCore->updateWaybillOrder($waybillOrderBean,$waybill_order_id,0);
        }

        $bind_params = [];
        $bind_params['_$_TN_$_'] = $waybillOrder->tn;
        $rec['bind_params'] = json_encode($bind_params);
        $poll['recipients'][] = $rec;

        // create poll
        $poll_id = $pollIntegration->createPoll($poll);
        
        // publish poll
        $pollIntegration->publishPoll($poll_id);

        // write the poll_id in waybill_order        
        $tc_details = $waybillOrderBean->tc_details;
        $tc_details->poll_id = $poll_id;
        $waybillOrderBean->tc_details = $tc_details;
        $waybillOrderCore->updateWaybillOrder($waybillOrderBean,$waybill_order_id,0);

        // send notification to user
        // $waybillOrderCore->sendWaybillOrderNotification($userBean->id, $waybill_order_id, 'set_notification');

        }

    catch(Exception $e){
        $socialCore = new SocialCore();
        $wall_message = $e->getMessage();
        $notification_message = $e->getMessage();
        //$socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');

        throw $e;
    }
}

