<?php
// ---------------------------------------------------------------- //
// --------------- create waybill orders for companies ------------ //
// ---------------------------------------------------------------- //
ini_set('display_errors', 'On');

$starttime = microtime(true);

// import
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../waybill_order/waybill_order_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../social/social_core.php";
require_once dirname(__FILE__) . "/../../tender_company/tender_company_core.php";
require_once dirname(__FILE__) . "/../../assign_cargo/assign_cargo_core.php";
require_once (dirname(__FILE__). "/../../cargo/cargo_core.php");
require_once (dirname(__FILE__). "/../../company/trucking_company/trucking_company_core.php");

//init objetcs
$waybillOrderCore = new WaybillOrderCore();
$tenderCore = new TenderCore();
$socialCore = new SocialCore();
$tenderCompanyCore = new TenderCompanyCore();
$assignCargoCore = new AssignCargoCore();
$cargoCore = new CargoCore();
$truckingCompanyCore = new TruckingCompanyCore();

// get the params from POST
$all_orders = json_decode($_POST['orders']);
$is_last_task = $_POST['is_last_task'];
$tender_company_id = $_POST['tender_company_id'];
$assign_cargo_id = $_POST['assign_cargo_id'];


// loop on the assign result      
foreach ($all_orders as $orderObj) {            

    $tenderOrderBean = $tenderCore->getTenderOrderBasic($orderObj->order,0); 
    $tenderBean = $tenderCore->getTenderBasic($tenderOrderBean->tender_id,0);
    $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany([['key'=>'id','val' =>$tender_company_id]],1,0,0) ;
    $tenderCompanyBean = $tenderCompaniesReuslt->data[0];
        
    for ($i=0; $i < $orderObj->quota; $i++) {                     

        // create waybill order bean
        $waybillOrderBean = new stdClass();
        $waybillOrderBean->tender_order_id = $orderObj->order;
        $waybillOrderBean->cargo_id = $tenderOrderBean->cargo[0];
        $waybillOrderBean->queue_id = null;
        $waybillOrderBean->truck_owner_id = null;
        $waybillOrderBean->create_date = DBConnection::getSystemDate();
        $waybillOrderBean->status = "NEW";
        // Fill tc_details in waybill order
        $tc_details = new stdClass();
        $tc_details->tn = null;
        $tc_details->q_id = null;
        $tc_details->trn = null;
        $tc_details->truck_id = null;
        $tc_details->driver_nn = null;
        $tc_details->tender_id = $tenderOrderBean->tender_id;
        $tc_details->contact_nn = null;
        $tc_details->queue_name = null;
        $tc_details->driver_name = null;
        $tc_details->tender_name = $tenderBean->tender_name;
        $tc_details->contact_name = $tenderCompanyBean->name;
        $tc_details->driver_phone = null;
        $tc_details->contact_phone = null;
        $tc_details->tc_company_id = $tenderCompanyBean->trucking_company_id;
        $tc_details->truck_owner_id = null;
        $tc_details->truck_owner_nn = null;
        $tc_details->truck_owner_name = null;
        $tc_details->truck_owner_phone = null;
        $tc_details->trucking_company_id = $tenderCompanyBean->trucking_company_id;
        $tc_details->trucking_company_name = $tenderCompanyBean->name;
        $tc_details->extra_note = $tenderOrderBean->order_notes->extra_note;
        $waybillOrderBean->tc_details = $tc_details;

        $waybillOrderResult = DBConnection::insertDB("waybill_order",$waybillOrderBean,0);
    }

    try{
        // send mobile notification to company TC_MANAGGERS
        $cargoName = $cargoCore->getCargoBasic($tenderOrderBean->cargo[0], 0)->name;
        $title =  "حصة $cargoName للشركة";
        $message =  "تم تفعيل حصة $cargoName للشركة بعدد $orderObj->quota, الرجاء تثبيت المعلومات";
        $truckingCompanyCore->informComapanyEmployee($tenderCompanyBean->trucking_company_id , $title , $message);
    }catch(Exception $e){
        $socialCore = new SocialCore();    
        $wall_message = "Error Sending notification to TC";
        $notification_message = $wall_message;
        $supervisor_id = 2;
        $socialCore->informSupervisor('Error Sending notification to TC', $wall_message, $notification_message, $supervisor_id);
    }
}



// if the task is the last one, 
// 1- write assign_to = "indevisual" in the tender order
// 2- inform supervisor
if($is_last_task){
    
    $assignCargoBean = $assignCargoCore->getAssignCargoBasic($assign_cargo_id,0);
    $orders = $assignCargoBean->details->orders;
    $auto_assign_for_indivisual = $assignCargoBean->details->auto_assign_for_indivisual;

    // loop on the orders
    foreach ($orders as $order) {    
        $tenderOrderBean = $tenderCore->getTenderOrderBasic($order->id,0);
        $order_notes = json_decode($tenderOrderBean->order_notes);
        $order_notes->assign_mode = "indivisual";
        $updateBean = new stdClass();
        $updateBean->id = $tenderOrderBean->id;
        $updateBean->order_notes = $order_notes;
        //DBConnection::updateDB("tender_order",$updateBean,0);
    }

    // change assign_cargo to PENDING: جاهز لتوزيع الأفراد
    $assignCargoCore->changeStatus($assign_cargo_id , "PENDING" , 0);
    
    // inform super visor
    $socialCore = new SocialCore();    
    $wall_message = "تم الإنتهاء من توزيع طلبية الشركات رقم " . $assign_cargo_id;
    $notification_message = $wall_message;
    $socialCore->informSupervisor('انتهاء طلبية الشركات', $wall_message, $notification_message, $supervisor_id);

    if($auto_assign_for_indivisual){
        // TODO , continue the indivisual distribution
    }
}
