<?php
// ------------------------------------------------------------------------------------------ //
// --------------- complete the voucher after validate trx from zain cash server ------------ //
// ------------------------------------------------------------------------------------------ //
ini_set('display_errors', 'On');

// import 
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/zain_cash.php";
require_once dirname(__FILE__) . "/../../voucher/voucher_core.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";

//init objetcs
$zain_cash = new Zain_Cash();
$voucherCore = new VoucherCore();
$taskQueuesCore = new TaskQueuesCore();
$waybillCore = new WaybillCore();
$tenderCore = new TenderCore();

// get params from request
$ref_id = 2921299966902;
$voucher_id = 2040018226;
$trial = 28;

// get the wallet_id of the voucher
$voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);

if($voucherBean->trx_template->ref_code == "WAYBILL_COMPLETE"){
    $waybill_id = $voucherBean->trx_template->ref_id;
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
    $tender_id = $waybillBean->tender_id;
    $man = $tenderCore->getTenderManifest($tender_id, 0);
    $wallet_id = $man['freight']['payment_method']['wallet_id'];
}else{
    // get wallet_id from voucher
    $wallet_id = $voucherBean->trx_template->payment->wallet_id;
    if(!$wallet_id){
        $wallet_id = 'crude_oil';
    }
}

// call zain cash system to inquire this ref_id
$currentDate = DBConnection::getSystemDate();
$fromTime = date('Y-m-d',strtotime($voucherBean->create_date. "-1 days" )) . " 00:00:00";
$toTime = date('Y-m-d',strtotime($currentDate. "+1 days")). " 00:00:00";

$transactions = $zain_cash->getTransactions($wallet_id,$fromTime,$toTime,null,$ref_id,'complete_voucher',0);

try{
    // if the trx is found
    if(sizeof($transactions['RESULT']) > 0 ){
        foreach ($transactions['RESULT'] as $trx) {

            if($trx['Status'] == 'Accepted'){
                
                // write integration details
                $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];
                $new_act = new stdClass();
                $new_act->code = "تمت عملية تأكيد الدفع من قبل البنك المركزي";
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;

                $integration_details->payment = new stdClass();
                $integration_details->payment->ref_id = $trx['TransactionReference'];
                $integration_details->payment->transaction_date = $trx['TransactionDate'];
                try{
                    if(array_key_exists("Wallet_id" , $trx) && $trx['Wallet_id']){
                        $integration_details->payment->wallet_id = $trx['Wallet_id'];
                    }else{
                        $integration_details->payment->wallet_id = $wallet_id;
                    }
                }catch(Exception $e){
                    $integration_details->payment->wallet_id = $wallet_id;
                }

                $voucherBean->integration_details = $integration_details;
                
                $voucherCore->updateVoucherInfo($voucherBean , $voucher_id, 0);
 

                // change voucher to complete
                $voucherCore->completeVoucher($voucherBean->id,0);

            }else if($trx['Status'] == 'Rejected'){
                
                // write integration details
                $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];
                $new_act = new stdClass();
                $new_act->code = "تم رفض الحركة من قبل البنك المركزي";
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;
                $voucherBean->integration_details = $integration_details;
                $voucherCore->updateVoucherInfo($voucherBean , $voucher_id, 0);

                 // change voucher to PENDING
                 $voucherCore->changeStatus($voucher_id,'INCOMPLETE',0);

            }else{
                throw new Exception("Invalid Status in ZC System - " . $trx['Status']);
            }           
        }
    }
    // if the trx is not found, retry after 5 minutes
    else{
        throw new Exception("Trx not found on ZC System");
    }
}
catch (Exception $e){

    // retry after 5 minutes
    $trial ++;
    $errorMessage = $e->getMessage();
    $taskQueuesCore->createCompleteZainCashTask($voucher_id , $ref_id , $trial , 300 , $errorMessage);
}

