<?php
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../notes/add_notes_core.php";
require_once dirname(__FILE__) . "/../../queue/queue_core.php";

ini_set('display_errors', 'On');

// init objects
$waybillCore = new WaybillCore();
$addNoteCore = new Add_notes_core();
$queueCore = new QueueCore();

// init user params
$waybill_id = $_POST["id"];
$remarks = $_POST["remarks"];

// get waybill bean 
$waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
if ($waybillBean->status == "CLOSED" || $waybillBean->status == "COMPLETE" || $waybillBean->status == "REVOKED" ) {
    die;
}

// change waybill status
$waybillCore->changeStatus($waybill_id, 'CLOSED', 0);

// add remarks to activity
$revokeReason = $remarks;
$addNoteCore->addNotes('waybill', $waybill_id, $revokeReason, 0);

// add note to waybill document
$waybillJson = $waybillBean->document;
$waybillJson->closedReason = new stdClass();

$waybillJson->closedReason->reason = $revokeReason;
$waybillJson->closedReason->remarks = '';
$waybillBean->document = $waybillJson;
$waybillCore->updateWaybill($waybillBean, $waybill_id, 0);
$waybillCore->logActivity($waybill_id, " إغلاق المستند ", "السبب : " . $revokeReason, "CLOSED_WAYBILL", 0);

//activate the other queues if the truck has more than one
$q_id = $waybillJson->integeration_details->queue->q_id;
if ($q_id) {
    $queuesToActivateSearchFilter = [
        ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
        ['key' => 'status', 'val' => 'HELD']
    ];
    $queuesToActivate = $queueCore->searchQueue($queuesToActivateSearchFilter, 1000, 0, 0)->data;

    // iterate and change status to HELD for each queue
    foreach ($queuesToActivate as $queue) {
        $queueCore->changeStatus($queue->id, 'ACTIVE', 0);
        $queueCore->logActivity(
            $queue->id,
            "فك تجميد الدور",
            "تم فك تجميد الدور",
            "activate_queue",
            0
        );
    }
}
