<?php
// ------------------------------------------------------------------------------------------ //
// --------------- complete the voucher after validate trx from zain cash server ------------ //
// ------------------------------------------------------------------------------------------ //
ini_set('display_errors', 'On');

// import 
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/zain_cash.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/poll.php";
require_once dirname(__FILE__) . "/../../voucher/voucher_core.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../user/user_core.php";
require_once dirname(__FILE__) . "/../../notification/notification_core.php";

//init objetcs
$zain_cash = new Zain_Cash();
$pollIntegration = new Poll();
$userCore = new UserCore();
$notificationCore = new NotificationCore();
$taskQueuesCore = new TaskQueuesCore();

// get params from request
$ref_id = $_POST['ref_id'];
$phone = $_POST['phone'];
$trial = $_POST['trial'];
$poll_id = $_POST['poll_id'];
$wallet_id = "crude_oil";

// call zain cash system to inquire this ref_id
$currentDate = DBConnection::getSystemDate();
$fromTime = date('Y-m-d',strtotime($currentDate. "-3 days" )) . " 00:00:00";
$toTime = date('Y-m-d',strtotime($currentDate. "+1 days")). " 00:00:00";

try{
    if(!$ref_id){
        throw new Exception("no ref ID");
    }
$transactions = $zain_cash->getTransactions($wallet_id,$fromTime,$toTime,null,$ref_id,"check user wallet",0);

    // if the trx is found
    if(sizeof($transactions['RESULT']) > 0 ){
        foreach ($transactions['RESULT'] as $trx) {
            if($trx['Status'] == 'Accepted'){

                // update wallet record status
                $status = 'ACTIVE';
                $zain_cash->updateUserWallet($ref_id,$status);

                if($poll_id){
                    // get user bean
                    $searchFilter = [['key'=>'phone','val' =>convertToInternational($phone)]];
                    $userInfo = $userCore->searchUser($searchFilter,1,0,0);

                    // get voucher amount
                    $user_id = $userInfo->data[0]->id;
                    $db_query = "select amount from temp_tips_values where user_id  = " . $user_id;
                    $amountResult = DBConnection::runDatabaseQuery($db_query)[0];

                    // check if user does not have recipients record in the poll , then create a record
                    $recipients =[];
                    $rec['user_id'] = $user_id;
                    $bind_params = [];
                    $bind_params['_$_AMOUNT_$_'] = $amountResult->amount;
                    $bind_params['_$_MOBILE_$_'] = $phone;
                    $rec['bind_params'] = json_encode($bind_params);
                    $rec['communication_channels'] = [
                        ['channel' => 'FCM' , 'details' => ['fcm_registration_id'=> $userInfo->data[0]->notification_token] , 'status' => 'ACTIVE', 'priority'=> 1],
                        ['channel' => 'SMS' , 'details' => ['phone_number'=> $userInfo->data[0]->notification_token->phone] , 'status' => 'ACTIVE', 'priority'=> 2]
                    ];
                    $recipients[] = $rec;

                    $pollIntegration->appendRecipientToPoll($poll_id,$recipients);

                    // send notification to user
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = 1;
                    $payload->message =  "لديك استبيان جديد بحاجة للمتابعة";
                    $notificationCore->sendDataMessage($userInfo->data[0]->id,$payload);
                }
            }else{
                throw new Exception("Invalid Status in ZC System - " . $trx['Status']);
            }
        }
    }
    // if the trx is not found, retry after 5 minutes
    else{
        throw new Exception("Trx not found on ZC System");
    }
}
catch (Exception $e){ 

    // retry after 5 minutes if the trials is less than 5
    if($trial < 3 && $ref_id){
        $trial ++;
        $errorMessage = $e->getMessage();
        $phone = str_replace("+","",$phone);
        $taskQueuesCore->createCheckUserWalletTask($ref_id , $phone , $poll_id , $trial , 200 , $errorMessage);
    }else{
        // update wallet record status
        $status = 'INACTIVE';
        $notes = "مرفوضة من البنك المركزي";
        $zain_cash->updateUserWallet($ref_id,$status,$notes);
    }
    
}

