
<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once dirname(__FILE__) . "/../../tender_claim/tender_claim_core.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";


$tenderClaimCore = new TenderClaimCore();
$waybillCore = new WaybillCore();
$waybill_id = $_POST['waybill_id'];
$approved_tender_claim_item_id = $_POST['tender_claim_item_id'];
$user_id = 0;



try {
    // get the origianl waybill
    $item = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
    $originalWaybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);
    //update status of item and tagreesh
    // log jv trx for item
    $paymentCore = new PaymentCore();
    $jv_id = $paymentCore->logPaClaimItemTrx($item->id,$originalWaybillBean->tender_id);

    $item->status = "APPROVED";
    $item->details->jv_id = $jv_id;
    DBConnection::updateDB("tender_claim_item", $item, $user_id);
    
} catch (Exception $e) {

    DBConnection::rollBackTransaction();

    $item = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
    $item->details->fail_in_log_trx_messsage = $e->getMessage();
    DBConnection::updateDB("tender_claim_item", $item, 0);
    
    $taskQueuesCore = new TaskQueuesCore();
    $taskQueuesCore->createFailureLogTenderClaimARItemTrx(
        $tender_claim_id,
        $waybill_id,
        $approved_tender_claim_item_id
    );
}
