
<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once dirname(__FILE__) . "/../../tender_claim/tender_claim_core.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
$tenderClaimCore = new TenderClaimCore();
$waybillCore = new WaybillCore();
// $tender_claim_id = $_POST['tender_claim_id'];
// $waybill_id = $_POST['waybill_id'];
// $claim_loading_weight = $_POST['claim_loading_weight'];
// $claim_loading_date = $_POST['claim_loading_date'];
// $claim_discharge_weight = $_POST['claim_discharge_weight'];
// $claim_discharge_date = $_POST['claim_discharge_date'];
// $discharge_weight = $_POST['discharge_weight'];
// $approved_tender_claim_item_id = $_POST['tender_claim_item_id'];
// $is_last_task = $_POST['is_last_task'];
// $user_id = 0;

$tender_claim_id = 2091009567;
$waybill_id =  340520;
$claim_loading_weight = 35180;
$claim_loading_date = '2021-08-16';
$claim_discharge_weight = 'claim_discharge_weight';
$claim_discharge_date = '2021-08-17';
$discharge_weight = null;
$approved_tender_claim_item_id = 187891;
$is_last_task = TRUE;
$user_id = 0;


try {
    // get the origianl waybill
    $item = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
    $originalWaybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);

    $originalLoadingWeight = $originalWaybillBean->document->cargo[0]->weights->loading->net_weight;
    $originalDischargeWeight = $originalWaybillBean->document->cargo[0]->weights->discharge->net_weight;
    $originalDestinationId = $originalWaybillBean->document->negotiable_instructios->route->destination->id;
    $originalCargoId = $originalWaybillBean->document->cargo[0]->cargo_id;
    // save the new loading weights in case it is changed, and update the freight node
    if (!$originalLoadingWeight || $originalLoadingWeight != $claim_loading_weight) {
        // update the weight in waybill
        $waybillJson = $originalWaybillBean->document;
        $waybillJson->cargo[0]->weights->loading->time_stamp = $claim_loading_date;
        $waybillJson->cargo[0]->weights->loading->net_weight = $claim_loading_weight;
        $originalWaybillBean->document = $waybillJson;
        $waybillCore->updateWeight($originalWaybillBean, $user_id);

        // add remarks on waybill to tell the user that the weight has been changed
        if (!$originalLoadingWeight) $originalLoadingWeight = "-";
        $message = 'تم تغير وزن التحميل من ' . $originalLoadingWeight . ' الى ' . $claim_loading_weight .
            ' بناءً على المطالبة رقم ' . $tender_claim_id;
        $waybillCore->logActivity($waybill_id, "إضافة شروحات", $message, "ADD_NOTES", $user_id);
    }
    // save the new discharge weights in case it is changed, and update the freight node
    if (!$originalDischargeWeight || $originalDischargeWeight != $claim_discharge_weight) {

        // update the weight and time in waybill
        $waybillJson = $originalWaybillBean->document;
        $waybillJson->cargo[0]->weights->discharge->net_weight = $claim_discharge_weight;
        $waybillJson->cargo[0]->weights->discharge->time_stamp = $claim_discharge_date;

        $originalWaybillBean->document = $waybillJson;
        $waybillCore->updateWeight($originalWaybillBean, $user_id);

        // add remarks on waybill to tell the user that the weight has been changed
        if (!$originalDischargeWeight) $originalDischargeWeight = "-";
        $message = 'تم تغير وزن التفريغ من ' . $originalDischargeWeight . ' الى ' . $discharge_weight .
            ' بناءً على المطالبة رقم ' . $tender_claim_id;
        $waybillCore->logActivity($waybill_id, "إضافة شروحات", $message, "ADD_NOTES", $user_id);
    }
    if (!$originalDestinationId || $originalDestinationId != $item->details->claim_destination_id) {
        // update the weight and time in waybill
        $originalWaybillBean->document->negotiable_instructios->route->destination->id = $item->details->claim_destination_id;
        // add remarks on waybill to tell the user that the weight has been changed
        if (!$originalDischargeWeight) $originalDischargeWeight = "-";
        $message = 'تم تغير الوجهة الى' . $item->details->claim_destination_name . ' بناءً على المطالبة رقم ' . $tender_claim_id;
        $waybillCore->logActivity($waybill_id, "إضافة شروحات", $message, "ADD_NOTES", $user_id);
    }
    if (!$originalCargoId || $originalCargoId != $item->details->cargo_id || $originalCargoId != $item->details->claim_cargo_id) {
        $originalWaybillBean->document->cargo[0]->cargo_id = $item->details->claim_cargo_id ? $item->details->claim_cargo_id : $item->details->cargo_id;

        // add remarks on waybill to tell the user that the weight has been changed
        if (!$originalDischargeWeight) $originalDischargeWeight = "-";
        $message = 'تم تغير الحمولة الى' . $item->details->claim_cargo_name ? $item->details->claim_cargo_name : $item->details->cargo_name . ' بناءً على المطالبة رقم ' . $tender_claim_id;
        $waybillCore->logActivity($waybill_id, "إضافة شروحات", $message, "ADD_NOTES", $user_id);
    }


    $originalWaybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);
    $waybillJson = $originalWaybillBean->document;
    $waybillJson->cargo[0]->weights->discharge->time_stamp = $claim_discharge_date;
    $waybillJson->cargo[0]->weights->loading->time_stamp = $claim_loading_date;
    $originalWaybillBean->document = $waybillJson;
    $waybillCore->updateWeight($originalWaybillBean, $user_id);

    // get fresh copy of waybill
    $originalWaybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);

    // if exists AR claim for the item
    // check if there is AR claim item with this waybill
    // search for waybill in pending items
    $filter = [
        ['key' => 'waybill_id', 'val' => $waybill_id],
        ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
        ['key' => 'status', 'val' => 'ACTIVE']
    ];
    $tenderClaimItems = $tenderClaimCore->searchTenderClaimItems($filter, 1, 0, $user_id, ' order by id desc ');

    if ($tenderClaimItems->found_rows > 0) {
        //update status of item and tagreesh
        $item = $tenderClaimItems->data[0];
        // log jv trx for item
        $paymentCore = new PaymentCore();
        if ($originalWaybillBean->tender_id == 13) {
            $jv_id = $paymentCore->logARTenderClaimItemTrx($item->id, $approved_tender_claim_item_id, $originalWaybillBean->tender_id);
        } else if ($originalWaybillBean->tender_id == 3) {
            $jv_id = $paymentCore->logARTenderClaimItemTrxForVessels($item->id, $originalWaybillBean->tender_id);
        }

        $item->status = "APPROVED";
        DBConnection::updateDB("tender_claim_item", $item, $user_id);
        $approved_item = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
        $approved_item->details->jv_id = $jv_id;
        DBConnection::updateDB("tender_claim_item", $approved_item, 0);

        if ($is_last_task) {
            $tenderClaimBean = $tenderClaimCore->getTenderClaimBasic($tender_claim_id, 0);
            $tenderClaimBean->claim_details->isProcessingTenderClaim = false;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);
        }
    }
} catch (Exception $e) {


    DBConnection::rollBackTransaction();
 
    $item = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
    $item->details->fail_in_log_trx_messsage = $e->getMessage();
    DBConnection::updateDB("tender_claim_item", $item, 0);

    $taskQueuesCore = new TaskQueuesCore();
    // $taskQueuesCore->createFailureLogTenderClaimItemTrx(
    //     $tender_claim_id,
    //     $waybill_id,
    //     $claim_loading_weight,
    //     $claim_loading_date,
    //     $claim_discharge_weight,
    //     $claim_discharge_date,
    //     $discharge_weight,
    //     $approved_tender_claim_item_id,
    //     $is_last_task,
    //     $e->getMessage()
    // );
}
