<?php
header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset', 'UTF-8');

// import required classes
require_once(dirname(__FILE__) . "/social_core.php");
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../DBR/dbr_core.php");

require_once(dirname(__FILE__) . "/../../includes/Jormall_sms_gateway.php");



class Social_interface extends API
{

    private $_request = array();
    private $_socialCore;
    private $_notification_core;
    private $_userCore;
    private $_taskQueuesCore;
    private $_dbr;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_socialCore = new SocialCore();
        $this->_notification_core = new NotificationCore();
        $this->_userCore = new UserCore();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_dbr = new DBR_Core();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // --------------------------------------------------------------- //
    // --------------------- get wall entries  ----------------------- //
    // --------------------------------------------------------------- //
    function getWallEntries()
    {

        if (!$this->_request->offset) {
            $this->_request->offset = 0;
        }
        if (!$this->_request->limit) {
            $this->_request->limit = 20;
        }

        $result  = $this->_socialCore->searchWallEntries($this->_request->offset, $this->_request->limit, $_SESSION['user_id']);

        $app_version = $this->_userCore->getUserMobileVersion($_SESSION['u_id']);
        //if($app_version >= 79){
        foreach ($result as &$entry) {
            $reply = json_decode($entry['replys']);
            $reply[0]->msg = nl2br($reply[0]->msg);
            $msg = '<span style="font-size:13px">' . $reply[0]->msg . "</span>";
            $reply[0]->msg = $msg;
            $entry['replys'] = json_encode($reply, JSON_UNESCAPED_UNICODE);
        }
        //}
        parent::response($result);
    }


    // ------------------------------------------------------------------------------------- //
    // -------------------------- create new Post ------------------------------------------ //
    // ------------------------------------------------------------------------------------- //
    function createPost()
    {

        $jormall_SMS_Gateway = new Jormall_SMS_Gateway();

        // get user input 
        $channel = $this->_request->channel;
        $title = $this->_request->title;
        $msg = $this->_request->msg;
        $body_image = $this->_request->body_image;
        $sendToMe = $this->_request->sendToMe;
        $recipients = $this->_request->recipients;

        // validate the logged in user is minagate operation only
        $isMinagateOperation = false;

        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'MINAGATE_OPERATION') {
                $isMinagateOperation = true;
            }
        }
        if (!$isMinagateOperation) {
            throw new Exception('This feature is for Minagate Operations only');
        }

        // prepare message data
        $sender_id = 266770;
        $sender_name =  "شركة مدارج للخدمات اللوجستية ";

        // create post body
        $body = $this->_socialCore->createPostBody(
            $title,
            $msg,
            $body_image,
            $sender_id,
            $sender_name
        );


        // if the user choosed to send to himself
        if ($sendToMe) {
            $sender_user_id = $_SESSION['u_id'];
            // create task to send message
            $this->_taskQueuesCore->createPostOnWallTask($sender_user_id, $body, $this->_request->title, true);
        }

        // send notification for group of recipients
        if ($recipients == 'grouped') {

            $searchRecipientFilter = $this->_request->filter;
            if (!$searchRecipientFilter) {
                throw new Exception("INVALID FILTER");
            }
            $tender_id = $searchRecipientFilter->tender_id;

            // search for Recipients
            if ($channel == "minagateApp") {
                $result  = $this->_socialCore->searchRecipients($tender_id);
                // create task for each user
                foreach ($result as $rec) {
                    $user_id = $rec->id;
                    $this->_taskQueuesCore->createPostOnWallTask($user_id, $body, $this->_request->title, true);
                }
                // send copy to the sender
                $this->_taskQueuesCore->createPostOnWallTask($_SESSION['u_id'], $body, $this->_request->title, true);
            } elseif ($channel == "sms") {
                // git phone numbers based on tender id
                $result  = $this->_socialCore->searchRecipients($tender_id, $channel);

                //format phone numbers list
                foreach ($result as $key => &$value) {
                    $value = $value->phone;
                }
                // send sms messages
                foreach (array_chunk($result, 100) as $key => $phones) {
                    $response = $jormall_SMS_Gateway->sendBulkMessage($phones, $this->_request->msg);
                }
            }

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['RESPONSE'] = $response;
            $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
            parent::response($Result);
        }

        // send notification for all recipients
        else if ($recipients == 'broadcast') {

            // create post on all users wall
            $post_id  = $this->_socialCore->createPost($sender_id, $this->_request->recipients, $body);
            $notification_title = $this->_request->title;
            $notification_msg = "يرجى العلم انه تم ارسال تنويه جديد يمكن متابعته من خلال التطبيق";

            $this->_notification_core->broadcastNotification($notification_title, $notification_msg);

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
            parent::response($Result);
        }

        // send message to single user
        else if ($recipients == 'single') {
            $notification_title = $this->_request->title;
            $user_id = $this->_request->user_id;

            if ($channel == "minagateApp") {
                // create task to send message
                $this->_taskQueuesCore->createPostOnWallTask($user_id, $body, $this->_request->title, true);
            } elseif ($channel == "sms") {
                // git phone numbers based on user id
                $sql2 = "SELECT
                        u.id , phone
                    FROM
                        user_view u
                    where id = ? ";
                $result = DBConnection::runBindDatabaseQuery($sql2, [$user_id]);
                // send sms to single user
                $jormall_SMS_Gateway->sendMessage($result[0]->phone, $this->_request->msg);
            }


            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
            parent::response($Result);
        } else if ($this->_request->recipients == 'phonesList') {

            $phonsList = $this->_request->phons;
            foreach ($phonsList as $key => &$value) {
                if (gettype($value) != "string") {
                    $value = $value->Phones_num;
                }
                $value = convertToInternational($value);
            }

            if ($channel == "minagateApp") {
                $phonsList = implode(",", $phonsList);
                $getAccIdsQry = "SELECT id FROM waybill.user WHERE phone IN (" . $phonsList . ")";

                $result = DBConnection::runBindDatabaseQuery($getAccIdsQry, []);

                // create task for each user
                foreach ($result as $value) {
                    $user_id = $value->id;
                    //$this->_taskQueuesCore->createPostOnWallTask($user_id, $body, $this->_request->title, true);
                    $this->_socialCore->createPost($sender_id, $user_id, $body);
                }
                // send copy to the sender
                // $this->_taskQueuesCore->createPostOnWallTask($_SESSION['u_id'], $body, $this->_request->title, true);

            } elseif ($channel == "sms") {
                foreach (array_chunk($phonsList, 100) as $key => $phones) {
                    $response = $jormall_SMS_Gateway->sendBulkMessage($phones, $this->_request->msg);
                }
            }

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['response'] = $response;
            $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
            parent::response($Result);
        }

        // in case recipients is invalid
        else {
            throw new Exception('لم يتمكن النظام من ارسال الرسالة');
        }
    }

    // ---------------------------------------------------------------------------- //
    // -------------------------- update read / delivered / action  --------------- //
    // -------------------------- ids(comma seperated) , action ------------------------------------- //
    // ---------------------------------------------------------------------------- //
    function updatePostDate()
    {

        // convert ids to array
        $ids_arr = explode(",", $this->_request->ids);

        foreach ($ids_arr as $post_id) {

            // get the entry bean
            $result  = $this->_socialCore->getWallEntry($post_id, $_SESSION['user_id']);
            if ($result[0]) {

                // get the replys
                $replys = json_decode($result[0]->replys);

                // get the first reply
                $replys = $replys[0];

                // update dates in first reply only if its null - cant update date if its already exist
                if ($this->_request->action == 'read_date') {
                    if ($replys->read_date != null) {
                        continue;
                    }
                    $replys->read_date = DBConnection::getSystemDate();
                }
                if ($this->_request->action == 'action_date') {
                    if ($replys->action_date != null) {
                        continue;
                    }
                    $replys->action_date = DBConnection::getSystemDate();
                }
                if ($this->_request->action == 'delivery_date') {
                    if ($replys->delivery_date != null) {
                        continue;
                    }
                    $replys->delivery_date = DBConnection::getSystemDate();
                }

                // store in DB
                $replys = json_encode($replys, JSON_UNESCAPED_UNICODE);
                $this->_socialCore->updatePostDate($post_id, $replys);
            }
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------------ //
    // -------------------------- pin certain post  --------------- //
    // ------------------------------------------------------------ //
    function pinPost()
    {

        $result  = $this->_socialCore->getWallEntry($this->_request->id, $_SESSION['user_id']);

        if ($result[0]) {

            $this->_socialCore->pinPost($this->_request->id, $this->_request->pin_number);

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SOCIAL.SUCCESS_OPERATION";
            parent::response($Result);
        } else {
            throw new Exception('SOCIAL.FAILED_OPERATION');
        }
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------- Search for Recipients in order to send messages to --------------- //
    // ------------------- Params: filter --------------------------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function searchRecipients()
    {

        // parse input params
        $searchRecipientFilter = json_decode($this->_request->filter);
        $tender_id = $searchRecipientFilter->tender_id;

        // search for Recipients
        $result  = $this->_socialCore->searchRecipients($tender_id);

        $countResult = [];
        $resultObject = new stdClass();
        $resultObject->cnt = sizeof($result);
        $countResult[] = $resultObject;
        parent::response($countResult);
    }


    public function generateDriverWagePost()
    {
        // get inputs
        $result = $this->_request->result;
        $reason = $this->_request->reason;

        $wn = $this->_request->wn;
        $phone = $this->_request->phone;
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $driver_wage = $this->_request->driver_wage;
        $driver_name = $this->_request->driver_name;
        $recipient_user_id = $this->_request->recipient_user_id;


        //in case the result is success
        switch (strtoupper($result)) {
            case 'SUCCESS':
                // post on user wall
                $body = "تم تحويل مبلغ $driver_wage دينار على محفظتك الالكترونية ,\n";
                $body .= " وذلك بدل أجور عن رحلتك على الشاحنة رقم $tn \n";
                $body .= " رقم المستند: $wn";
                break;

            case 'FAIL':
                $body = "لم يتمكن النظام من تحويل مبلغ أجور السائق الى محفظتك الالكترونية بسبب رفض الحركة من البنك المركزي $reason ,\n";
                $body .= " الرجاء مراجعة مزود الخدمة خاصتك لحل المشكلة ";
                break;
        }

        $sender_id = 266770;
        $sender_name = "شركة مدارج للخدمات اللوجستية ";
        $writeOnWall = true;
        $title = "خدمة أجور السائق";
        $msg = $body;
        $body = $this->_socialCore->createPostBody($title, $msg, null, $sender_id, $sender_name);
        $this->_taskQueuesCore->createPostOnWallTask($recipient_user_id, $body, $title, $writeOnWall);
    }


    public function generateDownpaymentPost()
    {

        // get inputs
        $result = $this->_request->result;
        $reason = $this->_request->reason;

        $phone = $this->_request->phone;
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $driver_wage = $this->_request->driver_wage;
        $driver_name = $this->_request->driver_name;
        $recipient_user_id = $this->_request->recipient_user_id;

        // calculate DBR
        $dbr =  $this->_dbr->calculateWaybillDBR($tn, $tender_id);

        //in case the result is success
        switch (strtoupper($result)) {
            case 'SUCCESS':
                // post on user wall
                $body = $this->generateDownpaymentSucsessBody($phone, $tn, $driver_wage, $driver_name, $dbr);
                $legal_body = $this->generateDownpaymentLegalPost($tn, $recipient_user_id, $dbr);

                break;
            case 'FAIL':
                $body = $this->generatefailedBody($reason);
                break;
            case 'REJECTED':
                $body = $this->generateRejectBody();
                break;
        }

        $sender_id = 266770;
        $sender_name = "شركة مدارج للخدمات اللوجستية ";
        $writeOnWall = true;
        $title = "خدمة الدفعة المقدمة";
        $msg = $body;
        $body = $this->_socialCore->createPostBody($title, $msg, null, $sender_id, $sender_name);
        $this->_taskQueuesCore->createPostOnWallTask($recipient_user_id, $body, $title, $writeOnWall);

        if ($legal_body) {
            $sender_id = 266770;
            $sender_name = "شركة مدارج للخدمات اللوجستة / الدائرة القانونية ";
            $writeOnWall = true;
            $title = "تعهد";
            $msg = $body;
            $body = $this->_socialCore->createPostBody($title, $msg, null, $sender_id, $sender_name);
            $this->_taskQueuesCore->createPostOnWallTask($recipient_user_id, $body, $title, $writeOnWall);
        }
    }


    // -------------------------------------------------------------------------------------------------------- //
    // ------------- Generate post on user wall when the downpayment claim is done succesfully  --------------- //    
    // -------------------------------------------------------------------------------------------------------- //
    private function generateDownpaymentSucsessBody($phone, $tn, $driver_wage, $driver_name, $dpr)
    {

        if (gettype($dpr) == "array") {
            $dpr = (object)$dpr;
        }

        $body = '';
        if ($dpr && $phone && $tn) {
            $body .= "تم تحويل مبلغ $dpr->dbr_value دينار على محفطتك المثبتة على رقم الهاتف  $phone كدفعة مقدمة عن رحلتك للشاحنة رقم $tn , ";
        }
        if ($driver_wage && $driver_name) {
            $body .= "وتم اقتطاع $driver_wage دينار بدل اجور للسائق $driver_name \n";
            $body .= "وتم تحويلها الى محفظته الالكترونية   \n\n";
        }

        if ($dpr) {
            $dprDtalies = '';
            $dprDtalies .= "تم احتساب مبلغ الدفعة المقدمة بناء على رحلات الشاحنة خلال اخر 6 شهور سابقة وحسب التفاصيل التالية   \n";
            $dprDtalies .= "عدد الرحلات  $dpr->number_of_wayblls  \n";
            $dprDtalies .= "اقل وزن تفريغ " . intval($dpr->discharge_weight) / 1000 . " طن  \n";
            $dprDtalies .= "اعلى خسارة وزن $dpr->loss_in_kg كغم  \n";
            $dprDtalies .= "سعر الطن المحتسب $dpr->wage_per_ton  \n\n";
            $body .= $dprDtalies;
            $advice = '';
            if ($dpr->TPM < 1) {
                $advice .= "** تستطيع القيام برحلات اكثر لزيادة قيمة الدفعة المقدمة \n\n";
                $body .= $advice;
            }
            if ($dpr->late_factor < 1) {
                $late_factor_advice = "";
                $late_factor_advice .= "** تستطيع زيادة قيمة الدفعة المقدمة عن طريق تسليم الوصل القادم لمكتب مدارج في الزرقاء بشكل اسرع \n\n";
                $body .= $late_factor_advice;
            }
        }
        return $body;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------- Generate post on user wall to show some legal information  --------------- //
    // ---------------------------------------------------------------------------------------- //
    private function generateDownpaymentLegalPost($tn, $recipient_id, $dpr)
    {

        if (gettype($dpr) == "array") {
            $dpr = (object)$dpr;
        }
        $recipient_name = $this->_userCore->getUserBasic($recipient_id, 0)->name;

        $body = "السيد :" . $recipient_name . " المحترم، تحية طيبة،، \n";
        $body .= "تم تحويل مبلغ " .  $dpr->dbr_value  . " دينار إلى محفظتك الإلكترونية كدفعة مقدمة عن رحلة الشاحنة  " . $tn . "\n";
        $body .= "وعليه فأنت تتعهد بتحمل كامل المسؤولية القانونية لتسليم وصل التحميل لمكتب مدارج في الزرقاء بأسرع وقت ممكن " . "\n";
        $body .= " حيث سيتم استكمال باقي مستحقات الرحلة." . "\n";

        $body .= "شكرا لك، ونتمنى العمل معك في رحلاتك القادمة." . "\n";
        $body .= "إدارة شركة مدارج للخدمات اللوجستية";

        return $body;
    }

    // -------------------------------------------------------------------------------------------------------- //
    // ------------- Generate post on user wall when the downpayment claim is failed by JCB   --------------- //    
    // -------------------------------------------------------------------------------------------------------- //
    private function generatefailedBody($reason)
    {
        $body = '';
        if ($reason) {
            $body .= "لم يتمكن النظام من تحويل مبلغ الدفعة المقدمة الى محفظتك الالكترونية السبب: $reason ,\n";
            $body .= " الرجاء مراجعة مزود الخدمة خاصتك لحل المشكلة ";
        }
        return $body;
    }

    // -------------------------------------------------------------------------------------------------------- //
    // ------------- Generate post on user wall when the user reject the service from the poll ---------------- //    
    // -------------------------------------------------------------------------------------------------------- //
    private function generateRejectBody()
    {
        $body = 'تستطيع مراجعة مكتب مدارج بعد عملية التفريغ لصرف الوصل , ونتمنى العمل معك في المرات القادمة';
        return $body;
    }


    public function testSendWebsocket()
    {
        //get the user UUID
        $user_id = $this->_request->user_id;
        $userCore = new UserCore();
        $userHB = $userCore->getUserHeartBeatObject($user_id);
        $UUID = $userHB->UUID;

        $details = new stdClass();
        $details->id = rand(1,1000);
        $details->message =  $this->_request->message;


        //send websocket
        $socialCore = new SocialCore();
        $socialCore->sendWebSocket($UUID, "ASSIGN_CALL", $details);
    }
}

$social_interface = new Social_interface();
