<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/company/company_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");

class SocialCore
{

    protected static $db;
    private $_notification_core;
    private $_company_core;
    private $_userCore;

    public function __construct()
    {

        /*for local development connection (DEV)*/
        $host = '34.134.70.8';
        $db   = 'social';
        $user = 'system';
        $pass = '35DcDw9M7B2nD3f';
        $charset = 'utf8mb4';
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        $dsn = "mysql:host=$host;port=3306;dbname=$db;charset=$charset";
        self::$db = new PDO($dsn, $user, $pass, $options);
    }

    // --------------------------------------------------------------------------------------------- //
    // --------------------- get the wall entries for a certain user ------------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function searchWallEntries($offset, $limit, $user_id)
    {

        $u_id = DBConnection::getUserIdFromSession($user_id);

        // get the basic wall entries       
        $db_query = "SELECT " .
            "wall.id AS id ,
                    wall.user_id AS user_id ,
                    wall.company_id AS company_id ,
                    wall.role AS role ,
                    wall.location_id AS location_id ,
                    wall.post_id as post_id ,
                    CAST(wall.replys AS CHAR CHARSET UTF8) AS replys ,
                    CAST(wall.social AS CHAR CHARSET UTF8)   AS social ,
                    CAST(wall.action  AS CHAR CHARSET UTF8)   AS action ,
                    wall.pinned AS pinned ,
                    wall.muted AS muted
            FROM social.wall WHERE user_id ="  . $u_id .
            " ORDER BY id DESC " .
            ' limit ' . $limit . ' offset ' . $offset;



        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
        $tempResult = $stmt->fetchAll();

        // loop on all entries to fetch extra data
        $result = array();
        foreach ($tempResult as $t) {

            try {
                $temp['id'] = $t['id'];
                $temp['post_id'] = $t['post_id'];
                $temp['action'] = $t['action'];
                $temp['pinned'] = $t['pinned'];
                $temp['muted'] = $t['muted'];

                $replysArr = json_decode($t['replys']);
                foreach ($replysArr as &$replyObj) {
                    // TODO get the icon of each reply
                    $replyObj->icon = "http://www.minagate.com/assets/images/logo.png";
                }
                $t['replys'] = json_encode($replysArr, JSON_UNESCAPED_UNICODE);

                if ($t['social']) {
                    $socialArr = json_decode($t['social']);
                    foreach ($socialArr as &$socialObj) {
                        // TODO get the icon of each social action
                        $socialObj->icon = "http://www.minagate.com/assets/images/logo.png";
                    }
                    $t['social'] = json_encode($socialArr, JSON_UNESCAPED_UNICODE);
                } else {
                    $t['social'] = null;
                }


                $temp['social'] = $t['social'];
                $temp['replys'] = $t['replys'];

                array_push($result, $temp);
            } catch (Exception $e) {
                // DO nothing, since the message is somehow corrupted so dont show it
            }
        }

        return $result;
    }


    // --------------------------------------------------------------------------------------------- //
    // --------------------- get the wall entries for a certain user ------------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function getWallEntry($wall_entry_id, $user_id)
    {

        // get the basic wall entries
        $db_query = 'SELECT  ' .
            '* ' .
            'FROM ' .
            'social.wall ' .
            ' WHERE ' .
            'user_id = :user_id' .
            ' and id = :id  limit 1 ';

        $db_query = "SELECT " .
            "wall.id AS id ,
            wall.user_id AS user_id ,
            wall.company_id AS company_id ,
            wall.role AS role ,
            wall.location_id AS location_id ,
            wall.post_id as post_id ,
            CAST(wall.replys AS CHAR CHARSET UTF8) AS replys ,
            CAST(wall.social AS CHAR CHARSET UTF8)   AS social ,
            CAST(wall.action  AS CHAR CHARSET UTF8)   AS action ,
            wall.pinned AS pinned ,
            wall.muted AS muted
            FROM social.wall WHERE   user_id = :user_id  and id = :id  limit 1 ";


        $stmt = self::$db->prepare($db_query);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
        $stmt->bindParam(':id', $wall_entry_id, PDO::PARAM_STR);

        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result;
    }


    // --------------------------------------------------------------------------------------------- //
    // --------------------------- Create Wall Entry for a certain user ---------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function createWallEntry($user_id, $title, $msg, $body_image = null)
    {

        try {

            // get post id
            $post_id_query = " SELECT ID+1 as id FROM social.post order by id desc limit 1";
            $postResult = DBConnection::runBindDatabaseQuery($post_id_query, null);
            $post_id = $postResult[0]->id;

            // create new post
            $sender_id = 266770;
            $sender_name =  "شركة مدارج للخدمات اللوجستية ";
            $post_query = " INSERT INTO `social`.`post` (`id`, `status`, `sender_id`) VALUES (?,?,?);";
            $param = [$post_id, 'ACTIVE', $sender_id];
            DBConnection::runBindDatabaseQuery($post_query, $param);

            // create post body
            $body = $this->createPostBody($title, $msg, $body_image, $sender_id, $sender_name);
            $bodyObj = json_decode($body);
            $bodyArr[] = $bodyObj;
            $replys = json_encode($bodyArr, JSON_UNESCAPED_UNICODE);

            // insert into wall table
            $sqlQuery = " INSERT INTO social.wall (`user_id`, `post_id`, `replys`, `social`, `pinned`, `muted`)  VALUES (?,?,?,?,?,?)";
            $param = [$user_id, $post_id, $replys, null, null, null];
            DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        } catch (Exception $e) {
            //throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // --------------------- save a new entry for a certain user --------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createPost($sender_id, $recipients, $replys)
    {

        // create new post entry
        $db_query1 = " SELECT ID+1 as id FROM social.post order by id desc limit 1";
        $stmt = self::$db->prepare($db_query1);
        $stmt->execute();
        $postResult = $stmt->fetchAll();

        $post_id = $postResult[0]['id'];

        $db_query = "INSERT INTO `social`.`post` (`id`, `status`, `sender_id`) VALUES ($post_id , 'ACTIVE', $sender_id);";

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();

        // remove special character in replays
        $replys = str_replace("\\", "\\\\", $replys);


        if ($recipients == 'broadcast') {

            $db_query = " SELECT
                            id
                        FROM
                            waybill.user u
                        WHERE
                            u.notification_token IS NOT NULL
                            AND u.notification_token != ''
                            AND u.status = 'ACTIVE'";

            $stmt = self::$db->prepare($db_query);
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);



            // loop on all recipients
            foreach ($result as $recipient) {

                // insert into wall table
                $db_query = "INSERT INTO social.wall (`user_id`, `post_id`, `replys`, `social`, `pinned`, `muted`) " .
                    " VALUES ($recipient->id, $post_id, '[$replys]' , null , null , null)";

                $stmt = self::$db->prepare($db_query);
                $stmt->execute();
            }
        } else {
            // insert in receipent wall
            $db_query = "INSERT INTO social.wall (`user_id`, `post_id`, `replys`, `social`, `pinned`, `muted`) " .
                " VALUES ($recipients, $post_id, '[$replys]' , null , null , null)";
            $stmt = self::$db->prepare($db_query);
            $stmt->execute();
        }
        return $post_id;
    }

    // --------------------------------------------------------------------------------------------- //
    // ------------------------ generate json object for notification body ------------------------- //
    //     {
    //       "msg": "text",
    //       "title": "text",
    //       "action": json,
    //       "read_date": text,
    //       "sender_id": int,
    //       "body_image": text,
    //       "action_date": text,
    //       "create_date": text,
    //       "sender_name": text
    //       "delivery_date": text
    //   ]
    // --------------------------------------------------------------------------------------------- //
    public function createPostBody($title, $msg, $body_image, $sender_id, $sender_name)
    {
        $body = new stdClass();
        $body->title = $title;
        $body->msg = $msg;
        $body->body_image = $body_image;

        $body->action = null; // TODO

        $body->sender_id = $sender_id;
        $body->sender_name = $sender_name;

        $body->create_date = DBConnection::getSystemDate();
        $body->read_date = null;
        $body->action_date = null;
        $body->delivery_date = null;

        return json_encode($body, JSON_UNESCAPED_UNICODE);
    }


    // ------------------------------------------------------------------------------------------ //
    // --------------------- update post date (read, delivered, action)-------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function updatePostDate($id, $replysJSON)
    {

        $db_query = "UPDATE social.wall set replys = '[$replysJSON]' where id = $id";

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
    }

    // ------------------------------------------------------------------------------ //
    // --------------------- pin certain post for the user -------------------------- //
    // ------------------------------------------------------------------------------ //
    public function pinPost($id, $pin_number)
    {

        if ($pin_number == -1) {
            $db_query = "UPDATE social.wall set pinned = null where id = $id";
        } else {
            $db_query = "UPDATE social.wall set pinned = $pin_number where id = $id";
        }

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
    }


    // ------------------------------------------------------------------------------ //
    // -------------------- Send message via websocket ------------------------------ //
    // ------------------------------------------------------------------------------ //
    public function sendWebSocket($uuid, $msg_type, $data)
    {

        $data_string = urlencode(json_encode($data, JSON_UNESCAPED_UNICODE));

        $url = "http://misc.minagate.com:3000/sendJson?id=" . $uuid . "&type=" . $msg_type . "&data=" . $data_string . "";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

        $result = curl_exec($curl);
        curl_close($curl);
    }


    // ------------------------------------------------------------------------------ //
    // -----------Send notification to operation manager and post on his wall-------- //
    // ------------------------------------------------------------------------------ //
    public function informSupervisor($wall_message_title, $wall_message_body, $notification_message, $operation_manager_id = null)
    {
        $notificationCore = new NotificationCore();

        $sender_id = 266770;
        $sender_name =  "شركة مدارج للخدمات اللوجستية ";
        if ($operation_manager_id == null)
            $operation_manager_id = 2;

        // create a post on operation manager wall
        $body = $this->createPostBody($wall_message_title, $wall_message_body, null,  $sender_id,  $sender_name);
        $post_id  = $this->createPost($sender_id, $operation_manager_id, $body);

        // send notification
        $payload = new stdClass();
        $payload->type = "set_notification";
        $payload->id = rand(1, 1000);
        $payload->title = $notification_message;
        $payload->message = $notification_message;
        $notificationCore->sendDataMessage($operation_manager_id, $payload);
    }

    // ------------------------------------------------------------------------------ //
    // -----------Send notification to certain user and post on his wall-------- //
    // ------------------------------------------------------------------------------ //
    public function informUser($wall_message_title, $wall_message_body, $notification_title, $notification_message, $user_id)
    {
        $notificationCore = new NotificationCore();

        $sender_id = 266770;
        $sender_name =  "شركة مدارج للخدمات اللوجستية ";

        // create a post on user wall
        if ($wall_message_title) {
            $body = $this->createPostBody($wall_message_title, $wall_message_body, null,  $sender_id,  $sender_name);
            $this->createPost($sender_id, $user_id, $body);
        }

        // send notification
        $payload = new stdClass();
        $payload->type = "set_notification";
        $payload->id = rand(1, 1000);
        $payload->title = $notification_title;
        $payload->message = $notification_message;
        $notificationCore->sendDataMessage($user_id, $payload);
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------- Search for Recipients in order to send messages to ----------- //
    // ---------------------------------------------------------------------------------- //
    public function searchRecipients($tender_id ,$channel = "app")
    {
        $param = [];
        // if it is broadcast message
        if (!$tender_id) {
            $sql = "SELECT
                       count(u.id) cnt
                    FROM
                        waybill.user u
                    WHERE
                        u.status = 'ACTIVE'";
        } else {
            $sql = "SELECT
                        distinct(u.id)
            FROM
                user_view u,
                        queue q
                    WHERE
                            u.status = 'ACTIVE'
                                    AND q.rank is not null
                                    AND q.driver_id = u.driver_id  ";
            if ($tender_id) {
                $sql .= "AND q.tender_id = ?";
                $param[] = $tender_id;
            }

            $sql .= " UNION SELECT DISTINCT
                                (u.id)
                            FROM
                                user_view u,
                                queue q
                    WHERE
                    u.status = 'ACTIVE'
                    AND q.rank IS NOT NULL
                    AND q.truck_owner_id = u.truck_owner_id ";
            if ($tender_id) {
                $sql .= "AND q.tender_id = ?";
                $param[] = $tender_id;
            }

            $sql .= " UNION SELECT DISTINCT
                                (u.id)
                            FROM
                                user_view u,
                                company_employee ce,
                                tender_company_view c
                            WHERE
                                    u.status = 'ACTIVE'
                                    AND ce.user_id = u.id
                                    AND ce.company_id = c.company_id ";
            if ($tender_id) {
                $sql .= "AND c.tender_id = ? ";
                $param[] = $tender_id;
            }

            // any other user wants to see announcment (ex: Omar, fadi , Hamzah)
            $sql .= " UNION SELECT
                                u.id
                            FROM
                                user_view u
                            WHERE
                                id in (402 , 475, 2)";

            // for fuel and crude oil announcment , append the following users
            // حمدان المنصوري, عبدالله الصرايرة
            if ($tender_id == 11 || $tender_id == 12) {
                $sql .= " UNION SELECT
                                    u.id
                                FROM
                                    user_view u
                                WHERE
                                    id in (13152 , 10739)";
            }

  
            // run the query
            $result = DBConnection::runBindDatabaseQuery($sql, $param);

            // in case the chhanel is app
            if ($channel == "app") {

                $user_id = [];
                foreach ($result as $user) {
                    $user_id[] = $user->id;
                }

                $sql2 = "SELECT DISTINCT
                            u.id , notification_token
                        FROM
                            user_view u
                        where id in (" . implode(",", $user_id) . ")
                        and notification_token is not null
                        and notification_token != ''
                        order by id  ";

                $result = DBConnection::runBindDatabaseQuery($sql2, []);
                return $result;
            } else if ($channel == "sms") {
                $user_id = [];
                foreach ($result as $user) {
                    $user_id[] = $user->id;
                }

                $sql2 = "SELECT DISTINCT
                            u.id , phone
                        FROM
                            user_view u
                        where id in (" . implode(",", $user_id) . ")
                        order by id  ";

                $result = DBConnection::runBindDatabaseQuery($sql2, []);
                return $result;
            }
        }
    }
}
