<?php

require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/service_agent_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../gateway/gateWay_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_draft/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/policy/policy_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/container.php";

class Service_agent_interface  extends API
{

    // the request of each call
    private $_request = array();
    private $_serviceAgentCore;
    private $_waybillDraft;
    private $_cargoCore;
    private $_policyCore;
    private $_waybillCore;

    private $_con;
    private $_fps;
    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();

        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        // init the ServiceAgentCore object
        $this->_serviceAgentCore = new ServiceAgentCore();
        $this->_waybillDraft = new WaybillDraftCore();
        $this->_cargoCore = new CargoCore();
        $this->_policyCore = new Policy_Core();
        $this->_waybillCore = new WaybillCore();
        $this->_fps  = new FPS();
        $this->_con = new Container();
        // process the incoming request
        $this->processRequest();
    }


    // call the correnponding method based on what the request call
    private function processRequest()
    {
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int)method_exists($this, $func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found', 404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // -------------------------------------------------------------- //
    // --------------------- get ServiceAgent info------------------------- //
    // -------------------------------------------------------------- //
    public function getServiceAgent()
    {
        $ServiceAgentBean = json_decode($this->_serviceAgentCore->getServiceAgent($this->_request->id, $_SESSION['user_id']));
        //return Success reponse
        parent::response($ServiceAgentBean);
    }

    private function prepareFilter()
    {
        $paymentAgentFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($value) {
                    if ($key == 'name') {
                        $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                        array_push($paymentAgentFilter, $tempArr);
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value];
                        array_push($paymentAgentFilter, $tempArr);
                    }
                }
            }
        }
        return $paymentAgentFilter;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for ServiceAgents using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchServiceAgents()
    {
        // call the core search
        $searchFilter = $this->prepareFilter();

        $ServiceAgents_qry = $this->_serviceAgentCore->searchServiceAgents(
            $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        parent::response($ServiceAgents_qry);
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for ServiceAgents using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderServiceAgents()
    {

        // call the core search
        $searchFilter = $this->prepareFilter();

        $ServiceAgents_qry = $this->_serviceAgentCore->searchTenderServiceAgents(
            $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        foreach ($ServiceAgents_qry->data as &$service_agent) {
            $service_agent->services = json_decode($service_agent->services);
        }

        parent::response($ServiceAgents_qry);
    }


    // ------------------------------------------------------------------------------------------------ //
    // ------------------- get a list of requested services which can be asked from sa agent ---------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchForRequestedServices()
    {
        $availableServices = [["code" => "CONTAINER_INSPECTION", "label" => "معاينة حاوية"]];
        parent::response($availableServices);
    }



    // ------------------------------------------------------------------------------------- //
    // ---------------- get a list of insurance agent services ona  a certain tender  ------- //
    // -------------------------------------------------------------------------------------- //
    public function searchInsuranceAgent()
    {

        // todo
        // dummy data to be replaced
        $result = [
            ["name" => "شركة تامين 1", "id" => 1],
            ["name" => "شركة تامين 2", "id" => 2],
            ["name" => "شركة تامين 3", "id" => 3],
            ["name" => "شركة تامين 4", "id" => 4],
            ["name" => "شركة تامين 5", "id" => 5],
            ["name" => "شركة تامين 6", "id" => 6]
        ];
        parent::response($result);
    }



    // --------------------------------------------------------------------------------------- //
    // ----------------- get a list of service agent services ona  acertain tender  ---------- //
    // --------------------------------------------------------------------------------------- //
    public function getServiceAgentsServices()
    {

        // call the core search
        $searchFilter = $this->prepareFilter();

        $tenderServices = $this->_waybillCore->searchWaybillServices($searchFilter, 100, 0, $_SESSION['user_id']);

        $services = [];
        foreach ($tenderServices->data as $service) {
            $serviceObj = new stdClass();
            $serviceObj->code = strtoupper($service->name);
            $serviceObj->price = $service->price;
            $serviceObj->id = $service->id;
            $serviceObj->title = $service->caption;
            if (strtoupper($service->name) == 'CONTAINER_BOND') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/bond_delivery_new.png";
                $serviceObj->sub_title = "تسليم السائق البون مع المعاملة الجمركي";
            }
            if (strtoupper($service->name) == 'MERCHANT_SEAL') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/merchant_seal_new.png";
                $serviceObj->sub_title = "تسليم السائق رصاصة التاجر على الحاوية";
            }
            if (strtoupper($service->name) == 'SHIPPING_LINE_SEAL') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/shipping_line_seal_new.png";
                $serviceObj->sub_title = "تسليم السائق رصاصة على الحاوية مع الخط الملاحي";
            }
            if (strtoupper($service->name) == 'DANGER_STICKERS') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/danger_sticker_new.jpg";
                $serviceObj->sub_title = "تسليم السائق مجموعة من ملصقات الخطورة";
            }
            if (strtoupper($service->name) == 'CONTAINER_INSURANCE') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/container_insurance_new.png";
                $serviceObj->sub_title = "طلب تأمين على جسم الحاوية";
            }
            if (strtoupper($service->name) == 'SUBMIT_CONTAINER_PERMIT') {
                $serviceObj->image_url = "https://storage.googleapis.com/waybill-project.appspot.com/submit_waybill_new.png";
                $serviceObj->sub_title = "تقديم وثيقة نقل على نظام هيئة النقل";
            }

            $services[] = $serviceObj;
        }

        parent::response($services);
    }


    // ------------------------------------------------------------------------ //
    // ---------------------- create Container Service ------------------------ //
    // ------------------------------------------------------------------------ //
    public function createContainerMerchantSealService()
    {

        // get user params
        $data = $this->_request->data;
        $cashBox_account = $data->source_account;
        $source_account_id  = explode('-', $cashBox_account)[0];
        $source_account_sub_id = explode('-', $cashBox_account)[1];

        // get sourceAccountBean
        $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id . "-" . $source_account_sub_id, $_SESSION["user_id"]);

        // get service details
        $companyServiceData = new stdClass();
        $companyServiceData->code = "MERCH_SEAL";
        $serviceBean = $this->_con->getCompanyServiceByCode($companyServiceData, $_SESSION['user_id']);
        $service_amount = json_decode($serviceBean['data'][0]['details'])->amount;

        // validation
        if (!$data->container_Number) {
            throw new Exception("الرجاء التاكد من ادخال رقم الحاوية ");
        }

        // if the source account is cash
        if (strtoupper($sourceAccountBean['type'] == "CASH")) {
            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->filter = ["account_id" => $source_account_id, "sub_id" => $source_account_sub_id];
            $cashBoxLogBean->limit = 1;
            $cashBoxLogBean->offset = 0;
            $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);
            if (
                $cashBoxResult && $cashBoxResult != "[]" && sizeof($cashBoxResult) &&
                isset($cashBoxResult[0]['status']) && $cashBoxResult[0]['status'] == "NEW"
            ) {
                // allow to continue
            } else {
                // ******************* DANGER: for testing ONLY ****************************
                throw new Exception("لا تستطيع المتابعة ، الصندوق مغلق");
            }

            $amount = $service_amount;
            $trx_notes = " بدل تسليم رصاص تاجر للحاوية رقم " . $data->container_Number . " رصاصة رقم " . $data->Seal_num;
            // create the new trx
            $this->generateAndCreateVoucher(3, 0, $cashBox_account, $trx_notes, $amount);
        } else {

            $trx_notes = "تسليم رصاص تاجر للحاوية رقم " .  $data->container_Number . " رقم الرصاصة: " . $data->seal_number;
            $revinue_account = "500005-12002";

            // create the new trx
            $trx = [];
            $ledger_account_id = $source_account_id;
            $temp = new stdClass();
            $temp->amount =  $service_amount;
            $temp->account = $source_account_id . "-" . $source_account_sub_id;
            $temp->op = 'D';
            $temp->notes =  $trx_notes;
            $trx[] = $temp;

            $temp2 = new stdClass();
            $temp2->amount =  $service_amount;
            $temp2->account = $revinue_account;
            $temp2->op = 'C';
            $temp2->notes =  $trx_notes;
            $trx[] = $temp2;
            $data = new stdClass();
            $data->ledger_account_id = $ledger_account_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks =  $trx_notes;
            $data->trx = $trx;

            $this->_fps->createTrx($data, $_SESSION['user_id']);

            parent::response("تمت العملية بنجاح ");
        }
    }


    // ----------------------------------------------------------- //
    // --------------- Create Danger Sticker --------------------- //
    // ----------------------------------------------------------- //
    public function createDangerStickerService()
    {

        // get user params
        $data = $this->_request->data;
        $cashBox_account = $data->source_account;
        $source_account_id  = explode('-', $cashBox_account)[0];
        $source_account_sub_id = explode('-', $cashBox_account)[1];

        // get sourceAccountBean
        $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id . "-" . $source_account_sub_id, $_SESSION["user_id"]);

        // get service details
        $service_amount = 0;
        $note = "";

        // validation
        if (!$data->ca_id) {
            throw new Exception("الرجاء التاكد من ادخال المخلص ");
        }

        // calculate service amount
        foreach ($data->danger_stickers as $sticker) {
            $service_amount += $sticker->payment_amount;
            $note .= $sticker->note . "-";
        }
        if ($service_amount == 0) {
            throw new Exception("مبلغ الخدمة غير صحيح");
        }

        $caFilter = [['key' => 'id', 'val' => $data->ca_id]];
        $clearingAgent = $this->_clearingAgentCore->searchClearingAgent($caFilter, 100000, 0, 0);
        $ca_name = $clearingAgent->data[0]->name;

        // if the source account is cash
        if (strtoupper($sourceAccountBean['type'] == "CASH")) {
            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->filter = ["account_id" => $source_account_id, "sub_id" => $source_account_sub_id];
            $cashBoxLogBean->limit = 1;
            $cashBoxLogBean->offset = 0;
            $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);
            if (
                $cashBoxResult && $cashBoxResult != "[]" && sizeof($cashBoxResult) &&
                isset($cashBoxResult[0]['status']) && $cashBoxResult[0]['status'] == "NEW"
            ) {
                // allow to continue
            } else {
                // ******************* DANGER: for testing ONLY ****************************
                throw new Exception("لا تستطيع المتابعة ، الصندوق مغلق");
            }

            // create the new trx
            $amount = $service_amount;
            $trx_notes = "تسليم ملصقات خطورة للحاوية: " .  $data->container_number . " - المخلص: " . $ca_name . "- ملاحظات: " . $note;
            $voucher_id = $this->generateAndCreateVoucher(5, 0, $cashBox_account, $trx_notes, $amount);

            parent::response($voucher_id);

        } else {

            $trx_notes = "تسليم رصاص تاجر للحاوية رقم " .  $data->container_number . " رقم الرصاصة: " . $data->seal_number;
            $revinue_account = "500005-12002";

            // create the new trx
            $trx = [];
            $ledger_account_id = $source_account_id;
            $temp = new stdClass();
            $temp->amount =  $service_amount;
            $temp->account = $source_account_id . "-" . $source_account_sub_id;
            $temp->op = 'D';
            $temp->notes =  $trx_notes;
            $trx[] = $temp;

            $temp2 = new stdClass();
            $temp2->amount =  $service_amount;
            $temp2->account = $revinue_account;
            $temp2->op = 'C';
            $temp2->notes =  $trx_notes;
            $trx[] = $temp2;
            $data = new stdClass();
            $data->ledger_account_id = $ledger_account_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks =  $trx_notes;
            $data->trx = $trx;

            $this->_fps->createTrx($data, $_SESSION['user_id']);

            parent::response("تمت العملية بنجاح ");
        }

      
        
    }


    // ------------------------------------------------------------------------ //
    // ---------------------- create Container Service ------------------------ //
    // ------------------------------------------------------------------------ //
    public function createContainerService()
    {

        // get user params
        $data = $this->_request;
        $seals = $data->added_seals;
        $product = sizeof($seals);
        $cashBox_account = $data->source_account;
        $source_account_id  = explode('-', $cashBox_account)[0];
        $source_account_sub_id = explode('-', $cashBox_account)[1];
        $reservation = $data->reservation;

        // get sourceAccountBean
        $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id . "-" . $source_account_sub_id, $_SESSION["user_id"]);

        // get service details
        $companyServiceData = new stdClass();
        $companyServiceData->code = "SL_SEAL";
        $serviceBean = $this->_con->getCompanyServiceByCode($companyServiceData, $_SESSION['user_id']);
        $service_amount = json_decode($serviceBean['data'][0]['details'])->amount * $product;

        // validation
        if (!$seals[0]) {
            throw new Exception("الرجاء التاكد من ادخال رقم الحاوية ");
        }

        $note = "";
        foreach ($seals as $value) {
            $note .= $value->cid . "-" . $value->seal_number . ". ";
        }
        $note .= "رقم الحجز :" . $reservation;

        // if the source account is cash
        if (strtoupper($sourceAccountBean['type'] == "CASH")) {
            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->filter = ["account_id" => $source_account_id, "sub_id" => $source_account_sub_id];
            $cashBoxLogBean->limit = 1;
            $cashBoxLogBean->offset = 0;
            $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);
            if (
                $cashBoxResult && $cashBoxResult != "[]" && sizeof($cashBoxResult) &&
                isset($cashBoxResult[0]['status']) && $cashBoxResult[0]['status'] == "NEW"
            ) {
                // allow to continue
            } else {
                // ******************* DANGER: for testing ONLY ****************************
                throw new Exception("لا تستطيع المتابعة ، الصندوق مغلق");
            }

            $amount = $service_amount;
            $trx_notes  = "تم تسليم رصاص وكيل بحري حسب التفاصيل الاتية " . $note;

            // create the new trx
            $this->generateAndCreateVoucher(4, 0, $cashBox_account, $trx_notes, $amount, true);
        } else {

            $trx_notes = "تسليم رصاص وكيل للحاوية رقم " .  $data->container_Number . " رقم الرصاصة: " . $data->seal_number;
            $revinue_account = "500005-12003";

            // create the new trx
            $trx = [];
            $ledger_account_id = $source_account_id;
            $temp = new stdClass();
            $temp->amount =  $service_amount;
            $temp->account = $source_account_id . "-" . $source_account_sub_id;
            $temp->op = 'D';
            $temp->notes =  $trx_notes;
            $trx[] = $temp;

            $temp2 = new stdClass();
            $temp2->amount =  $service_amount;
            $temp2->account = $revinue_account;
            $temp2->op = 'C';
            $temp2->notes =  $trx_notes;
            $trx[] = $temp2;
            $data = new stdClass();
            $data->ledger_account_id = $ledger_account_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks =  $trx_notes;
            $data->trx = $trx;

            $this->_fps->createTrx($data, $_SESSION['user_id']);

            parent::response("تمت العملية بنجاح ");
        }
    }

    // ---------------------------------------------------------- //
    // ------------------- Dashboard ---------------------------- //
    // ---------------------------------------------------------- //
    public function getContainerByStatusDashboard()
    {

        //  filter for cargo containers created today
        $createDateFrom = date("Y-m-d", strtotime(DBConnection::getSystemDate()));
        $filter = [
            ['key' => 'create_date', 'val' => $createDateFrom, 'op' => 'date greater than'],
        ];
        $cargoPolicy_qry = $this->_cargoCore->searchCargoContainer(
            $filter,
            500,
            $this->_request->offset,
            $_SESSION['user_id']
        );
        $result = new stdClass();
        $result->details = [[0, 'منجزة'], [0, 'جديد']];

        foreach ($cargoPolicy_qry->data as $cargo) {
            if ($cargo->status == 'APPROVED') {
                $result->details[0][0]++;
            } else {
                $result->details[1][0]++;
            }
        }

        parent::response($result);
    }

    public function getwaybillDraftByServiceDashboard()
    {
        try {
            $waybillDraftCore = new WaybillDraftCore();

            $createDateFrom = date("Y-m-d", strtotime("-7 days", strtotime(DBConnection::getSystemDate())));
            $filter = ['date_from' => $createDateFrom];

            $wds = $waybillDraftCore->searchWaybillDraft($filter, '21', 1000, 0);

            $result = new stdClass();
            $result->details = [
                [0, 'تسليم بون'],
                [0, 'تسليم رصاص التاجر'],
                [0, 'تسليم رصاص الوكيل البحري'],
                [0, 'صرف ملصقات خطورة'],
                [0, 'تأمين جسم الحاوية']
            ];

            foreach ($wds as $wd) {
                $doc = json_decode($wd->document);
                $services = $doc->services;
                if ($services) {
                    foreach ($services as $s) {
                        if ($s->service_id) {
                            foreach ($result->details as &$d) {
                                if ($d[1] == $s->service_name) {
                                    $d[0] = $d[0] + 1;
                                }
                            }
                        }
                    }
                }
            }

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getCashFlowDashboard()
    {
        // search Vouchers
        $voucherCore = new VoucherCore();

        $today  = date("Y-m-d") . " 23:59:59";
        $dateBefore = date('Y-m-d', strtotime('-7 days', strtotime($today))) . " 00:00:00";

        $days = array();

        for ($i = 0; $i <= 7; $i++) {
            $days[date('Y-m-d', strtotime('-' . $i . 'days', strtotime(date("Y-m-d"))))] = 0;
        }

        $voucherFilter = [
            ['key' => 'trx_template', 'val' => '"WAYBILL_SERVICE"', 'op' => 'json unquote', 'node' => '$.payment.name'],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
            ['key' => 'create_date', 'val' => $dateBefore, 'op' => 'greater than'],
            ['key' => 'create_date', 'val' => $today, 'op' => 'less than'],
        ];

        $voucherResult = $voucherCore->searchVouchers($voucherFilter, 10000, 0, $_SESSION['user_id'], ' order by create_date desc ');

        foreach ($voucherResult->data as $voucher) {
            $voucherDate = date('Y-m-d', strtotime('0 day', strtotime($voucher->create_date)));
            $days[$voucherDate] += $voucher->amount;
        }

        $result = [];
        $result[] = ['التاريخ', 'اليوم', 'قبل أسبوع'];

        foreach ($days as $k => $v) {
            $temp = [$k, $v, $days[date('Y-m-d', strtotime('-7 days', strtotime($k)))]];
            $result[] = $temp;
        }

        parent::response($result);
    }


    // ------------------------------------------------------------------------- //
    // ------------------ Get a list of requested services --------------------- //
    // ------------------------------------------------------------------------- //
    public function getRequstedServices()
    {
        $result = [];
        $service1 = new stdClass();
        $service1->label = "معاينة حاوية";
        $service1->value = "CONTAINER_INSPECTION";
        $result[] = $service1;
        parent::response($result);
    }

    public function generateAndCreateVoucher($id,  $target, $source, $notes, $amount, $is_sl_Seal = null)
    {
        $trxData = new stdClass();
        $trxData->id = $id;
        $trxData->source = $source;
        $trxData->amount = $amount;
        $trxData->target = $target;
        $trxData->notes = $notes;
        $trxData->is_sl_Seal = $is_sl_Seal;
        $template = $this->_fps->generateVoucherTrx($trxData, $_SESSION['user_id']);
        $voucherData = new stdClass();
        $voucherData->amount  = $trxData->amount;
        $voucherData->source_account_id = explode('-', $trxData->source)[0];
        $voucherData->source_sub_id = explode('-', $trxData->source)[1];
        $voucherData->details = new stdClass();
        $voucherData->voucher_type_code = 'RECEIPT';
        $voucherData->payment_method_code = 'CASH';
        $voucherData->jv_template = $template;

        $voucherData->notes = $notes;
        $voucherData->due_date = null;
        $voucherData->integration_details = null;


        $fields = new stdClass();
        $fields->voucherData = $voucherData;
        $fields->proccess_flag = true;
        $voucher_id = $this->_fps->insertVoucher($fields, $_SESSION['user_id']);

        $result = new stdClass();
        $result->voucher_id = $voucher_id;
        parent::response($result);
    }

    public function updateWaybillDraftDoc()
    {
        $filter  = $this->_request->filter;

        $waybillDraftCore = new WaybillDraftCore();
        $wds = $waybillDraftCore->searchWaybillDraft($filter, 21, 1, 0);
        $waybillDraft_id = $wds[0]->id;
        $document = json_decode($wds[0]->document);
        $document->carrier[0]->driver->nn = $this->_request->driver_nn;
        $document->carrier[0]->driver->name = $this->_request->driver_name;
        $document->carrier[0]->driver->phone = $this->_request->driver_phone;
        $document->carrier[0]->truck->tn = $this->_request->tn;
        $document->carrier[0]->trailer->tn = $this->_request->trn;
        $this->_waybillDraft->updateWaybillDraft(json_encode($document), $waybillDraft_id); // 13319
        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result);
    }
}

$service_agent_interface = new Service_agent_interface();
