<?php
/**
 * Created by Mahdi.
 * User: Mahdi Hamdan
 * Date: 12/30/2018
 * Time: 13:40 AM
 */

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");


class ServiceAgentCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  service agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getserviceAgent($id, $user_id)
    { // IMPORTANT: user_id is the user who search not the user we are looking for.

        $serviceAgentInfo = DBConnection::getObjectBean("sa", $id, $user_id);
        if ($serviceAgentInfo == null) {
            throw new Exception("service_AGENT.NOT_EXIST", 0);
        }
        return $serviceAgentInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------get  service agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getserviceAgentBasic($id, $user_id)
    {
        $serviceAgentInfo = DBConnection::getBasicObjectBean("sa", $id, $user_id);
        if ($serviceAgentInfo == null) {
            throw new Exception("service_AGENT.NOT_EXIST", 0);
        }
        return $serviceAgentInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  service agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderserviceAgent($filter,$limit,$offset,$user_id)
    {
        $searchserviceAgentResult = DBConnection::searchDB("tender_sa", $filter, $limit, $offset, $user_id);
        if(sizeof($searchserviceAgentResult->data) > 0){
            return $searchserviceAgentResult;
        }else{
            throw new Exception("service_AGENT.NOT_EXIST", 0);
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  service agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderServiceAgents($filter,$limit,$offset,$user_id)
    {
        $searchserviceAgentResult = DBConnection::searchDB("tender_sa", $filter, $limit, $offset, $user_id);
        if(sizeof($searchserviceAgentResult->data) > 0){
            return $searchserviceAgentResult;
        }else{
            throw new Exception("service_AGENT.NOT_EXIST", 0);
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  service agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getTenderserviceAgent($searchFilter, $limit, $offset, $user_id)
    {
        $searchserviceAgentResult = DBConnection::searchDB("sa", $searchFilter, $limit, $offset, $user_id);
        return $searchserviceAgentResult;

    }

    // -------------------------------------------------------------------------- //
    // -------------------search for service agent using any search filter ---------- //
    // -------------------------------------------------------------------------- //
    public function searchserviceAgents($searchFilter, $limit, $offset, $user_id){

        $searchserviceAgentResult = DBConnection::searchDB("sa", $searchFilter, $limit, $offset, $user_id);
        return $searchserviceAgentResult;
    }

    
 
}