<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/route_wage_core.php");

class Route_wage_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_routeWageCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception('No Session!');
        }

        // init the object
        $this->_routeWageCore = new RouteWageCore();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ----------------------------------------------------------------------------- //
    // --------------------- get bean for certain route wage ----------------------- //
    // ----------------------------------------------------------------------------- //
    public function getRouteWage()
    {

        $routeWageBean = $this->_routeWageCore->getBasicRouteWage($this->_request->id, $_SESSION['user_id']);
        if ($routeWageBean->advance_filter && $routeWageBean->tender_id = 3) {
            foreach ($routeWageBean->advance_filter as $f) {
                if ($f->type == 'trucking_company_id' && $f->op == 'in') {
                    $routeWageBean->individual = true;
                }
            }
        }
        parent::response($routeWageBean);
    }


    // --------------------------------------------------------------------------- //
    // ------------------------ Prepare Search Filter ---------------------------- //
    // --------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $routeWageFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key' => $key, 'val' => $value];
                array_push($routeWageFilter, $tempArr);
            }
        }

        return $routeWageFilter;
    }

    // ----------------------------------------------------------------------- //
    // --------------------- get list of route wages ------------------------- //
    // ----------------------------------------------------------------------- //
    public function searchRouteWage()
    {

        $routeWageFilter = $this->prepareFilter();

        $routeWageReuslt = $this->_routeWageCore->searchRouteWage(
            $routeWageFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //return  response
        parent::response($routeWageReuslt);
    }


    // ----------------------------------------------------------------------- //
    // --------------------- get list of route wages ------------------------- //
    // ----------------------------------------------------------------------- //
    public function searchPriceLessRouteWage()
    {
        $locationCore = new LocationCore();
        $tender_id = $this->_request->tender_id;

        $query = "SELECT
            distinct(destination_id),
            month(create_date) create_date ,
            document->>'$.cargo[0].cargo.id' as cargo_id,
            document->>'$.cargo[0].cargo.name' as cargo_name
        FROM
            waybill w
        WHERE
            tender_id IN (?)
            AND status NOT IN ('inactive' , 'revoked', 'complete', 'rejected')
            and w.create_date > '2021-01-01'
            AND NOT EXISTS( SELECT  id FROM tender_claim_item WHERE waybill_id = w.id AND status != 'INACTIVE')";
        $param = [$tender_id];
        $destinationsResult = DBConnection::runBindDatabaseQuery($query, $param);
        $result = [];


        // loop over distinct destinations and cargo
        foreach ($destinationsResult as $destObj) {

            // prepare data for route wage search
            $start_date =  date('Y-m-01', strtotime('2021-' . str_pad($destObj->create_date, 2, '0', STR_PAD_LEFT) . '-01'));
            $end_date =  date('Y-m-t', strtotime('2021-' . str_pad($destObj->create_date, 2, '0', STR_PAD_LEFT) . '-01'));
            $cargo_id = $destObj->cargo_id;
            $destination_id = $destObj->destination_id;

            // search for route wage using the previous data
            $filter =  [
                ['key' => "destination_id", 'val' => $destination_id],
                ['key' => "cargo_id", 'val' => $cargo_id],
                ['key' => "start_date", 'val' => $start_date, 'op' => '>'],
                ['key' => "start_date", 'val' => $end_date, 'op' => '<'],
                ['key' => "status", 'val' => "ACTIVE"],
            ];
            $routeWageResult = $this->_routeWageCore->searchRouteWage($filter, 1, 0, $_SESSION['user_id']);

            // if the no route wage is found, append it to result
            if ($routeWageResult->found_rows == 0) {
                $temp = new stdClass();
                $temp->name = getLocationName($destObj->destination_id);
                $temp->cargo_name = $destObj->cargo_name;
                $temp->route_wage_interval = $start_date . " لغاية " . $end_date;
                $result[] = $temp;
            }
        }



        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result, 200);
    }






    // --------------------------------------------------------------------------- //
    // -------------------- create new route wage -------------------------------- //
    // --------------------------------------------------------------------------- //
    public function createRouteWage()
    {

        $routeWageBean = $this->_request;

        $id = $this->_routeWageCore->createRouteWage($routeWageBean, $_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('ROUTE_WAGE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->_routeWageCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESS_CREATE";
        $Result['ID'] = $id;
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------ //
    // -------------------- change route wage status -------------------- //
    // ------------------------------------------------------------------ //
    public function changeStatus()
    {

        // change route wage status
        $this->_routeWageCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------ //
    // --------------------- update route wage info --------------------------- //
    // ------------------------------------------------------------------------ //
    public function updateInfo()
    {

        $routeWageBean = $this->_request;
        if ($routeWageBean->tender_id == 3) {
            if ($routeWageBean->individual) {
                $routeWageBean->advance_filter = [["type" => "trucking_company_id", "rules" => [395], "op" => "in"]];
            } else {
                $routeWageBean->advance_filter = [["type" => "trucking_company_id", "rules" => [395], "op" => "not in"]];
            }
        }
        $this->_routeWageCore->updateInfo($routeWageBean, $this->_request->id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------ //
    // --------------------- update route wage info --------------------------- //
    // ------------------------------------------------------------------------ //
    public function createBulkRouteWages()
    {
       
        $route_wages = $this->_request->route_wages;
        $start_date = $this->_request->start_date;
        $end_date = $this->_request->end_date;
        $origin_id = $this->_request->origin_id;
        $tender_id = $this->_request->tender_id;
        $cargo_id = $this->_request->cargo_id;
        $tolerance_percentage = $this->_request->tolerance_percentage;
        $loss_fine_per_kg = $this->_request->loss_fine_per_kg;
        $locationCore = new LocationCore();
        $cargoCore = new CargoCore();

        if (!$locationCore->getLocationBasic($origin_id, 0)) {
            throw new Exception("موقع تحميل غير صحيح");
        }

        if (!$tender_id) {
            throw new Exception("الرجاء اختيار المشروع");
        }

        if (!$cargo_id) {
            throw new Exception("الرجاء اختيار نوع الحمل");
        }

        $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);
        $deductions = $cargoBean->waybill_template->negotiable_instructios->freight->deductions;
        $route_wages = [$route_wages[0]];

        try {

            DBConnection::startTransaction();
            foreach ($route_wages as $wage) {

                $temp = new stdClass();
                $des = $locationCore->getLocationBasic($wage->destination_id, 0);
                if (!$des) {
                    throw new Exception("موقع تفريغ غير صحيح");
                }

                if (!is_numeric($wage->payable)) {
                    throw new Exception("الرجاء التأكد من السعر للوجهة $des->name");
                }

                dump($wage->receivable);die;
                
                if (is_numeric($wage->receivable) && $wage->receivable > 3 && $wage->receivable < 30) {

                    $temp->origin_id = $origin_id;
                    $temp->destination_id = $wage->destination_id;
                    $temp->tender_id = $tender_id;
                    $temp->start_date = $start_date;
                    $temp->end_date = $end_date;
                    $temp->plan = 'PER_TON';
                    $temp->cargo_id = $cargo_id;
                    $temp->minimum_weight = 1;
                    $temp->wage_per_ton = $wage->receivable;
                    $temp->tolerance_percentage = $tolerance_percentage;
                    $temp->loss_fine_per_kg = $loss_fine_per_kg;
                    $temp->deductions = $deductions;
                    $temp->type = 'receivable';

                    $wage1 = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);
                    $this->_routeWageCore->changeStatus($wage1, 'ACTIVE', $_SESSION['user_id']);
                    if ($tender_id == 3) {
                        unset($temp->individual);
                        unset($temp->type);
                        $temp->type = 'payable';
                        $wage3 = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);
                        $this->_routeWageCore->changeStatus($wage3, 'ACTIVE', $_SESSION['user_id']);
                    }
                }
                unset($temp->type);

                echo 1 ;die;

                if (is_numeric($wage->payable) && $wage->payable > 3 && $wage->payable < 30) {
                    $temp->wage_per_ton = $wage->payable;
                    $temp->type = 'payable';

                    // create individual wage
                    if ($tender_id == 3) {
                        $temp->individual = true;
                    }

                    if ($tender_id == 13) {
                        $temp->deductions = null;
                    }
 
                    $wage2 = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);
                    $this->_routeWageCore->changeStatus($wage2, 'ACTIVE', $_SESSION['user_id']);

                    if ($tender_id == 3) {
                        unset($temp->type);
                        $temp->type = 'receivable';
                        $wage3 = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);
                        $this->_routeWageCore->changeStatus($wage3, 'ACTIVE', $_SESSION['user_id']);
                    }
                }
            }
            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESSFUL_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }
}

$route_wage_interface = new Route_wage_interface();
