<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");


class RouteWageCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ---------------------------------------------------------------------------- //
    // -------------------Create route wage bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------- //
    public function getRouteWage($id, $user_id)
    {
        $routeWageInfo = DBConnection::getObjectBean("route_wage", $id, $user_id);
        return $routeWageInfo;
    }
    // ------------------------------------------------------------------------------------------------------ //
    // -------------------Create basic(without activities) route wage bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function getBasicRouteWage($id, $user_id)
    {
        $routeWageInfo = DBConnection::getBasicObjectBean("route_wage", $id, $user_id);
        return $routeWageInfo;
    }

    // ---------------------------------------------------------------------------- //
    // -------------------search for route wage using any search filter ----------- //
    // ---------------------------------------------------------------------------- //
    public function searchRouteWage($searchFilter, $limit, $offset, $user_id)
    {

        if (!$limit) {
            $limit = 1000;
        }

        $routeWageResult = DBConnection::searchDB("route_wage", $searchFilter, $limit, $offset, $user_id, " order by id desc ");
        return $routeWageResult;
    }

    // ------------------------------------------------------------------ //
    // ------------------- create new route wage ------------------------ //
    // ------------------------------------------------------------------ //
    public function createRouteWage($routeWageBean,  $user_id)
    {
        $cargoCore = new CargoCore();

        if (!$routeWageBean->type && $routeWageBean->tender_id != 12 && $routeWageBean->tender_id != 13 && $routeWageBean->tender_id != 3) {
            $routeWageBean->type = 'receivable';
        }

        if (!$routeWageBean->type) {
            throw new Exception("نوع التسعيرة غير محدد");
        }

        if ($routeWageBean->tender_id == 3) {
            if ($routeWageBean->individual) {
                $routeWageBean->advance_filter = [["type" => "trucking_company_id", "rules" => [395], "op" => "in"]];
            } else {
                $routeWageBean->advance_filter = [["type" => "trucking_company_id", "rules" => [395], "op" => "not in"]];
            }
        }

        $cargoBean = $cargoCore->getCargoBasic($routeWageBean->cargo_id, 0);
        if ($routeWageBean->tender_id != 13) {
            $routeWageBean->deductions = $cargoBean->waybill_template->negotiable_instructios->freight->deductions;
        }

        $routeWageResult = DBConnection::insertDB("route_wage", $routeWageBean, $user_id);
        $routeWage_id =  $routeWageResult[0]['@id'];
        return $routeWage_id;
    }

    // ---------------------------------------------------------------------- //
    // ----------------- Validate the new route wage ------------------------ //
    // ---------------------------------------------------------------------- //
    public function validateRouteWageForCreate($routeWageBean)
    {

        // validate if the bean has complete info
        if (
            !$routeWageBean->origin_id || !$routeWageBean->destination_id || !$routeWageBean->tender_id || !$routeWageBean->cargo_id
            || !$routeWageBean->start_date || !$routeWageBean->end_date || !$routeWageBean->type
        ) {

            throw new Exception("Invalid Route Wage");
        }

        // validate if the new route wage dates overlap with any other active wage for the same location
        $db_query = "select id from route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and cargo_id = ?
                     and start_date >= ? and start_date <= ?
                     and status = 'ACTIVE'
                     and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id, $routeWageBean->cargo_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);

        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }

        $db_query = "select id from route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and cargo_id = ?
                     and end_date >= ? and end_date <= ?
                     and status = 'ACTIVE'
                    and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id, $routeWageBean->cargo_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);
        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }
        $db_query = "select id from route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and cargo_id = ?
                     and start_date <= ? and end_date >= ?
                     and status = 'ACTIVE'
                    and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id, $routeWageBean->cargo_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);
        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }
    }


    // ------------------------------------------------------------------ //
    // -------------------- change route wage status -------------------- //
    // ------------------------------------------------------------------ //
    public function changeStatus($route_wage_id, $new_status, $user_id)
    {

        $updateStruct = new stdClass();
        $updateStruct->id = $route_wage_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("route_wage", $updateStruct, $user_id);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update route wage info in DB-------------------- //
    // ---------------------------------------------------------------------- //
    function updateInfo($routeWageBean, $route_wage_id, $updated_by)
    {

        // fill update struct and set the target user id
        $routeWageBean->id = $route_wage_id;

        // remove any sensative data


        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("route_wage", $route_wage_id, $updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if (compareObject($routeWageBean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $routeWageBean = mapBeanToDBBean($routeWageBean, $DB_Bean);

            // fill update struct and set the target user id
            DBConnection::updateDB("route_wage", $routeWageBean, $updated_by);
        }
    }

    // ----------------------------------------------------------------------------------------------------------- //
    // --------------------- Check if wage is defined for certain destination on a certain cargo ----------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    function searchWageForFreight(
        $tender_id,
        $origin_id,
        $destination_id,
        $cargo_id,
        $loading_date,
        $type,
        $throw = true,
        $waybillBean = null,
        $pa_id = null
    ) {

        if (!$tender_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, مشروع غير محدد");
        }
        if (!$origin_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, موقع تحميل غير محدد");
        }
        if (!$destination_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, وجهة غير محددة");
        }
        if (!$cargo_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, الحمولة غير محددة");
        }
        if (!$loading_date) {
            throw new Exception("خطأ في البحث عن التسعيرة, تاريخ التحميل غير محدد");
        }
        if (!$type) {
            throw new Exception("خطأ في البحث عن التسعيرة, نمط التسعيرة غير محدد");
        }

        // init
        $route_wage_type = "route_wage";
        $routeWageInfo = new stdClass();
        $routeWageInfo->found_rows = 0;
 

        // in case the calcukate freight is for waybillBean and the status of the waybill is COMPLETE
        // that means , WAYBILL_COMPLETE voucher has been created for it and the route wage that is used
        // for the tagreesh is either "route_wage" , or "pa_route_wage"
        // the system must use the same type of route wage
        if ($waybillBean && $waybillBean->status == "COMPLETE") {
            $fps = new FPS();
            $filter = [
                'voucher_type_code' => 'WAYBILL_COMPLETE',
                'status' => 'COMPLETE',
                'voucher_waybill_id' => $waybillBean->id,
            ];
            $data = new stdClass();
            $data->filter = json_encode($filter);
            $voucherResult = $fps->searchVouchers($data, 0);
            if ($voucherResult['found_rows'] > 0) {
                $details = json_decode($voucherResult['data'][0]['details']);
                $route_wage_type = $details->route_wage_type?$details->route_wage_type:$route_wage_type;
                $route_wage_pa_id = $details->pa_id;
            }
        }

        if ($route_wage_type == "route_wage") {
            // search for Route Wage
            $SearchFilter = [
                ['key' => 'destination_id', 'val' => $destination_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'cargo_id', 'val' => $cargo_id],
                ['key' => 'start_date', 'val' => $loading_date, 'op' => 'less than'],
                ['key' => 'end_date', 'val' => $loading_date, 'op' => 'greater than'],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'type', 'val' => $type],
                ['key' => 'origin_id', 'val' => $origin_id],
            ];
 
            $routeWageInfo = $this->searchRouteWage($SearchFilter, 10000, 0, 0);

            if ($routeWageInfo->found_rows == 0) {
                $locationCore = new LocationCore();
                $childLocation = $locationCore->getLocationBasic($origin_id, 0);
                array_pop($SearchFilter);
                array_push($SearchFilter, ['key' => 'origin_id', 'val' => $childLocation->parent_id]);

                $routeWageInfo = $this->searchRouteWage($SearchFilter, 10000, 0, 0);
            }
            if ($routeWageInfo->found_rows > 0) {
                $routeWageInfo->data[0]->route_wage_type = "route_wage";
            }
        }

        // in case no route wage is found, check if the pa has its own wages
        if (($routeWageInfo->found_rows == 0 || $route_wage_type == "pa_route_wage") && $pa_id) {
            $PaRouteWage = new PaRouteWageCore();
            $routeWageInfo = $PaRouteWage->searchPaRouteWageForFreight(
                $waybillBean->tender_id,
                $pa_id,
                $origin_id,
                $destination_id,
                $loading_date,
                $cargo_id,
                false,
                0
            );

            if ($routeWageInfo->found_rows > 0) {
                $routeWageInfo->data[0]->route_wage_type = "pa_route_wage";
            } else if ($route_wage_pa_id){
                $routeWageInfo = $PaRouteWage->searchPaRouteWageForFreight(
                    $waybillBean->tender_id,
                    $route_wage_pa_id,
                    $origin_id,
                    $destination_id,
                    $loading_date,
                    $cargo_id,
                    false,
                    0
                );
            }
        }


        // validate the found result
        if ($routeWageInfo->found_rows == 0 && $throw) {
            throw new Exception("لا يوجد تسعيرة");
        }

        if ($routeWageInfo->found_rows > 1 && $waybillBean) {
            return $this->routeWageFilter($routeWageInfo->data, $waybillBean, $throw);
        }

        if ($routeWageInfo->found_rows > 1 && $throw) {
            //throw new Exception("لا يمكن تحديد التسعيرة المناسبة");
        }

        return $routeWageInfo->data[0];
    }



    // ----------------------------------------------------------------------------------------------------------- //
    // --------------------- filter the route wages with waybill info -------------------------- ----------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    private function routeWageFilter($routeWages, $waybillBean, $throw)
    {

        foreach ($routeWages as $routeWage) {
            $filters = json_decode($routeWage->advance_filter);

            if ($filters) {
                $matched = false;
                foreach ($filters as $f) {
                    $matched = false;
                    if ($f->type == "trucking_company_id") {
                        if ($waybillBean->trucking_company_id) {
                            switch ($f->op) {
                                case "not in":
                                    if (!array_search($waybillBean->trucking_company_id, $f->rules) && array_search($waybillBean->trucking_company_id, $f->rules) !== 0) {
                                        $matched = true;
                                    }
                                    break;
                                case "in":
                                    if (array_search($waybillBean->trucking_company_id, $f->rules) > -1) {
                                        $matched = true;
                                    }
                                    break;
                            }
                        }
                    }
                }
                if ($matched) {
                    return $routeWage;
                }
            }
        }

        if ($throw) {
            throw new Exception("لا يمكن تحديد التسعيرة المناسبة");
        }

        return null;
    }
}
