
<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once dirname(__FILE__) . "/../tender/tender_core.php";
require_once dirname(__FILE__) . "/../queue/queue_core.php";
require_once(dirname(__FILE__) . "/../outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/customer_care.php");
require_once dirname(__FILE__) . "/../tender_company/tender_company_core.php";
require_once dirname(__FILE__) . "/../company/clearing_agent/clearing_agent_core.php";
require_once dirname(__FILE__) . "/../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../cargo/cargo_core.php";
require_once dirname(__FILE__) . "/../truck/truck_core.php";
require_once dirname(__FILE__) . "/../user/user_core.php";
require_once dirname(__FILE__) . "/../voucher/voucher_core.php";
require_once dirname(__FILE__) . "/../tender_claim/tender_claim_core.php";
require_once dirname(__FILE__) . "/../registration/registration_core.php";
require_once(dirname(__FILE__) . "/../service_agent/service_agent_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../../includes/Poll_DBConnection.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/../vessel_visit/vessel_visit_core.php");

class Report_interface extends API
{

    // privtae params
    private $_request = array();
    private $_tenderCore;
    private $_queueCore;
    private $_zain_cash;
    private $_jo_petrol;
    private $_tenderCompanyCore;
    private $_waybillCore;
    private $_cargoCore;
    private $_waybillOrderCore;
    private $_pollIntegration;
    private $_truckCore;
    private $_customerCare;
    private $_userCore;
    private $_voucherCore;
    private $_accountCore;
    private $_tenderClaimCore;
    private $_con;
    private $_fps;
    private $_clearingAgentCore;
    private $_truckingCompanyCore;
    private $_companyEmployeeCore;
    private $_vesselCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception('No Session!');
        }

        // init the object
        $this->_tenderCore = new TenderCore();
        $this->_queueCore = new QueueCore();
        $this->_zain_cash = new Zain_cash();
        $this->_jo_petrol = new Jo_petrol();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_waybillCore = new WaybillCore();
        $this->_cargoCore = new CargoCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_pollIntegration = new Poll();
        $this->_truckCore = new TruckCore();
        $this->_customerCare = new CustomerCare();
        $this->_userCore = new UserCore();
        $this->_voucherCore = new VoucherCore();
        $this->_accountCore = new AccountCore();
        $this->_tenderClaimCore = new TenderClaimCore();
        $this->_ServiceAgentCore = new ServiceAgentCore();
        $this->_fps = new FPS();
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_con = new Container();
        $this->_companyEmployeeCore =  new CompanyEmployeeCore();
        $this->_vesselCore =  new VesselVisitCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // -------------------------------------------------------------- //
    // --------------------- get list of waybills ------------------- //
    // -------------------------------------------------------------- //
    public function searchTruckingComoanyWaybillsReport()
    {

        $tender_id =  $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        // $this->hasAuthToViewReport($tender_id,'waybills_report');

        if (!$this->_request->preparefilter) {
            $waybillFilter = $this->prepareWaybillFilter($tender_id);
        } else {
            $waybillFilter = [];
            foreach (json_decode($this->_request->filter) as &$filter) {
                array_push($waybillFilter, ["key" => $filter->key, "val" => $filter->val, "op" => $filter->op]);
            }
        }

        // search for waybills
        $waybillResult = $this->_waybillCore->searchWaybills(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            " order by id "
        );

        $waybill_ids =  [];
        foreach ($waybillResult->data as &$waybill_data) {
            $waybill_ids[] = $waybill_data->id;
            $waybill_data->status =  Captions::getCaption("WAYBILL.STATUS." .  $waybill_data->status);
        }

        // search for voucher for the waybills
        $searchFilter = [
            ['key' => "status", 'val' => "COMPLETE"],
            ['key' => 'trx_template', 'val' => $waybill_ids, 'op' => 'json in', 'node' => '$.ref_id'],
            ['key' => 'trx_template', 'val' => "'WAYBILL_COMPLETE'", 'op' => 'json unquote', 'node' => '$.ref_code']
        ];

        $vouchers = $this->_voucherCore->searchVouchers($searchFilter, 10000, 0, 0);


        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillResult->data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);

            $waybill_data->bond_id = $doc->notes->bond->id;
            $waybill_data->server_date = $currentTime;
            $waybill_data->trn = $doc->carrier[0]->trailer->tn;
            if ($doc->carrier[0]->trailer->minor_tt == 201)
                $waybill_data->trailer_minor_tt = "قلاب";
            if ($doc->carrier[0]->trailer->minor_tt == 203)
                $waybill_data->trailer_minor_tt = "تريلا";

            $waybill_data->tc = $doc->carrier[0]->tc->name;
            $waybill_data->driver_name = $doc->carrier[0]->driver->name;
            $waybill_data->driver_nn = $doc->carrier[0]->driver->nn;
            $waybill_data->driver_phone = $doc->carrier[0]->driver->phone;
            $waybill_data->nationality_number = 1;
            $waybill_data->cargo = $doc->cargo[0]->name;
            $waybill_data->destination_name = $doc->negotiable_instructios->route->destination->name;
            $waybill_data->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $waybill_data->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $waybill_data->first_trip_destination = $doc->first_trip->destination;
            $waybill_data->first_trip_ct = $doc->first_trip->ct;
            $waybill_data->owner_name = $doc->carrier[0]->truck_owner->name;
            $waybill_data->owner_phone = $doc->carrier[0]->truck_owner->phone;
            $waybill_data->origin = $doc->negotiable_instructios->route->origin->name;
            $waybill_data->loading_date = $doc->cargo[0]->weights->loading->time_stamp;
            $waybill_data->discharge_date = $doc->cargo[0]->weights->discharge->time_stamp;
            $waybill_data->entry_point_id = $doc->integeration_details->queue->entry_point_id;
            $waybill_data->truck_owner_name = $doc->carrier[0]->truck_owner->name;

            if ($doc->freight && $doc->freight->amount) {
                $waybill_data->base_amount = $doc->freight->amount->base_amount ?  $doc->freight->amount->base_amount : "-";
                $waybill_data->net_amount = $doc->freight->amount->net_amount ? $doc->freight->amount->net_amount : "-";
                $waybill_data->total_deductions = $doc->freight->amount->total_deductions ? $doc->freight->amount->total_deductions : "-";
                $waybill_data->total_advance_payment = $doc->freight->amount->total_advance_payment ? $doc->freight->amount->total_advance_payment : "-";
                $waybill_data->total_fines = $doc->freight->amount->total_fines ? $doc->freight->amount->total_fines : "-";
            }
            unset($waybill_data->document);
            unset($waybill_data->search_index);

            $waybill_data->voucher_amount = "0";
            foreach ($vouchers->data as $v) {
                $trx_template = json_decode($v->trx_template);
                if ($trx_template->ref_id == $waybill_data->id) {
                    $waybill_data->voucher_amount = $trx_template->amount;
                }
            }

            // inject the voucher
        }

        //return Success response
        parent::response($waybillResult);
    }




    // -------------------------------------------------------------- //
    // --------------------- get list of waybills ------------------- //
    // -------------------------------------------------------------- //
    public function searchWaybills()
    {

        $tender_id =  $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        // $this->hasAuthToViewReport($tender_id,'waybills_report');

        $orderBy = " id";
        if (!$this->_request->preparefilter) {
            $waybillFilter = $this->prepareWaybillFilter($tender_id);
        } else {
            $waybillFilter = [];
            foreach (json_decode($this->_request->filter) as &$filter) {
                array_push($waybillFilter, ["key" => $filter->key, "val" => $filter->val, "op" => $filter->op]);
            }
        }

        foreach ($waybillFilter as $filter) {
            if ($filter['key'] == "loading_date") {
                $orderBy = " loading_date";
            } else if ($filter['key'] == "create_date") {
                $orderBy = " create_date";
            } else if ($filter['key'] == "discharge_date") {
                $orderBy = " discharge_date";
            }
        }

        $waybillResult = $this->_waybillCore->searchWaybills(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            " order by $orderBy "
        );


        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillResult->data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);
            $services_names = [];
            $services_prices_sum = 0;
            if (isset($doc->service_list) && count($doc->service_list))
                foreach ($doc->service_list as $service) {
                    if ($service->status && $service->status != 'INACTIVE') {
                        // do nothing
                    } else {
                        $services_names[] = $service->service_name;
                        $services_prices_sum += (int)$service->service_price;
                    }
                }
            $waybill_data->bond_id = $doc->notes->bond->id;
            $waybill_data->server_date = $currentTime;
            $waybill_data->trn = $doc->carrier[0]->trailer->tn;
            if ($doc->carrier[0]->trailer->minor_tt == 201)
                $waybill_data->trailer_minor_tt = "قلاب";
            if ($doc->carrier[0]->trailer->minor_tt == 203)
                $waybill_data->trailer_minor_tt = "تريلا";

            $waybill_data->tc = $doc->carrier[0]->tc->name;
            $waybill_data->driver_name = $doc->carrier[0]->driver->name;
            $waybill_data->driver_nn = $doc->carrier[0]->driver->nn;
            $waybill_data->driver_phone = $doc->carrier[0]->driver->phone;
            $waybill_data->nationality_number = 1;
            $waybill_data->cargo = $doc->cargo[0]->name;
            $waybill_data->destination_name = $doc->negotiable_instructios->route->destination->name;
            $waybill_data->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $waybill_data->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $waybill_data->first_trip = $doc->first_trip->destination ? getLocationName($doc->first_trip->destination) : "";
            $waybill_data->first_trip_destination = $doc->first_trip->destination;
            $waybill_data->first_trip_ct = $doc->first_trip->ct;
            $waybill_data->owner_name = $doc->carrier[0]->truck_owner->name;
            $waybill_data->owner_phone = $doc->carrier[0]->truck_owner->phone;
            $waybill_data->origin = $doc->negotiable_instructios->route->origin->name;
            $waybill_data->loading_date = $doc->cargo[0]->weights->loading->time_stamp;
            $waybill_data->discharge_date = $doc->cargo[0]->weights->discharge->time_stamp;
            $waybill_data->services_names = implode(', ', $services_names);
            $waybill_data->services_price_sum = $services_prices_sum > 0 ? $services_prices_sum : '';
            $waybill_data->entry_point_id = $doc->integeration_details->queue->entry_point_id;

            if ($doc->freight && $doc->freight->amount) {
                $waybill_data->base_amount = $doc->freight->amount->base_amount ?  $doc->freight->amount->base_amount : "-";
                $waybill_data->net_amount = $doc->freight->amount->net_amount ? $doc->freight->amount->net_amount : "-";
                $waybill_data->total_deductions = $doc->freight->amount->total_deductions ? $doc->freight->amount->total_deductions : "-";
                $waybill_data->total_advance_payment = $doc->freight->amount->total_advance_payment ? $doc->freight->amount->total_advance_payment : "-";
                $waybill_data->total_fines = $doc->freight->amount->total_fines ? $doc->freight->amount->total_fines : "-";
            }


            unset($waybill_data->document);
            unset($waybill_data->search_index);
        }

        //return Success response
        parent::response($waybillResult);
    }

    // -------------------------------------------------------------- //
    // --------------------- prepare filter ------------------- //
    // -------------------------------------------------------------- //

    private function prepareWaybillFilter($tender_id)
    {
        $waybillFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                if ($key == 'create_date') {
                    $tempArr = ['key' => "DATE($key)", 'val' => $value];
                } else if ($key == 'document') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == 'cargo_id') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json unquote', 'node' => '$.cargo[0].cargo_id'];
                } else if ($key == 'policy_num') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.nfldnm'];
                } else if ($key == 'create_date_from') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'create_date_to') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'loading_date_from') {
                    $tempArr = ['key' => 'loading_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'loading_date_to') {
                    $tempArr = ['key' => 'loading_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'discharge_date_from') {
                    $tempArr = ['key' => 'discharge_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'discharge_date_to') {
                    $tempArr = ['key' => 'discharge_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'created_by') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json', 'node' => '$.external_service.created_by'];
                } else if ($key == 'loading_date') {
                    $tempArr = ['key' => 'loading_date', 'op' => $value];
                } else if ($key == 'order_create_date_from') {
                    $tender_order_ids = $this->_tenderCore->getOrdersForCertainDate($tender_id, $value);
                    $tempArr = ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in'];
                    array_push($waybillFilter, $tempArr);
                    $tempArr = ['key' => 'document', 'val' => $tender_order_ids, 'op' => 'json in', 'node' => '$.order.id'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($waybillFilter, $tempArr);
            }
        }
        return $waybillFilter;
    }

    // ------------------------------------------------------------------------------------------------------ //
    // ------------------- make sure each report request is allowed for user -------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function hasAuthToViewReport($tender_id, $report_name)
    {
        $user_roles1 = explode(",", $_SESSION['USER_ROLES']);
        $user_roles2 = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);

        $user_roles = array_merge($user_roles1, $user_roles2);

        // get all tender report        
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $reports = $man['reports'];
        // loop on report and user role to find a match
        $allowedToViewReport = false;
        foreach ($reports as $report) {
            if ($report['template'] == $report_name) {
                foreach ($user_roles as $userRole) {
                    foreach ($report['roles'] as $allowedRole) {
                        if ($allowedRole == $userRole) {
                            $allowedToViewReport = true;
                            break;
                        }
                    }
                }
            }
        }
        if (!$allowedToViewReport) {
            throw new Exception("لا يوجد لديك صلاحية لمشاهدة التقرير");
        }
    }


    // ------------------------------------------------------------------------------------------------------------- //
    // ------------------ search for queue trucks based on certain filter, used to generate report  ---------------- //
    // ------------------ params: tener_id ,q_id, rank, trail_minor_tt, status} ------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------- //
    public function searchQueueReportTrucks()
    {

        // prepare params
        $tender_id =  $this->_request->tender_id;
        $q_id =  $this->_request->q_id;
        $rank =  $this->_request->rank;
        $status =  $this->_request->status ? explode(",", $this->_request->status) : DBConnection::getActiveStatus('queue');
        if (!$rank) $rank = 500;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'queue_report');

        // run database query
        $queueFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'q_id', 'val' => $q_id],
            ['key' => 'rank', 'val' => $rank, 'op' => 'less than'],
            ['key' => 'status', 'val' => $status, 'op' => 'in']
        ];
        if ($this->_request->trail_minor_tt != "ALL") {
            $trail_minor_tt = [$this->_request->trail_minor_tt];
            $queueFilter[] = ['key' => 'trail_minor_tt', 'val' => $trail_minor_tt, 'op' => 'in'];
        }

        $queueResult = $this->_queueCore->searchQueue($queueFilter, 10000, 0, $_SESSION['user_id']);

        parent::response($queueResult);
    }


    // ------------------------------------------------------------------------------------ //
    // --------------------- search trucks order based on  ------------------- //
    // ------------------------------------------------------------------------------------ //
    public function searchHamzehOilWellOrderReport()
    {
        try {

            if (gettype($this->_request->list_of_tns)  == "string") {
                $list_of_tns = json_decode($this->_request->list_of_tns, true);
            } else {
                $list_of_tns = $this->_request->list_of_tns;
            }
            $QueueFilter = [
                ['key' => 'rank', 'op' => 'is not null'],
                ['key' => 'tender_id', 'val' => 12],
                ['key' => 'tn', 'val' => $list_of_tns, 'op' => 'in']
            ];
            $queueSearchResult = $this->_queueCore->searchQueue($QueueFilter, 10000, 0,  0);


            $queueOrderRes = [];
            foreach ($queueSearchResult->data as  $value) {
                $obj  = new stdClass();
                $obj->tn = $value->tn;
                $obj->contact_name = $value->contact_name;
                $obj->contact_phone = $value->contact_phone;
                $obj->rank = $value->rank;

                $queueOrderRes[] = $obj;
            }
            parent::response($queueOrderRes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a transactions on zain cash for certain period ------------------------------------------ //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getZainCashTransactions()
    {
        $tender_id = $this->_request->tender_id;
        $fromTime = $this->_request->from_time;
        $toTime = $this->_request->to_time;

        if (!$tender_id) throw new Exception("tender_id is required");
        if (!$fromTime) throw new Exception("from_time is required");
        if (!$toTime) throw new Exception("to_time is required");
        $toTime = date_format(date_create($toTime), "Y-m-d 23:59:59");

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'zain_cash_report');

        // call zain cash system to get trx
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $wallet_id = $man['freight']['payment_method']['wallet_id'];

        $resul = $this->_zain_cash->getTransactions($wallet_id, $fromTime, $toTime, null, null, "getZainCashTransactions report", $_SESSION['u_id']);
        if ($_SESSION['u_id' == 2]) {
            dump($resul);
            die;
        }

        if ($resul['RESULT'] && $resul['RESULT'][0] == null) {
            $resul['RESULT'] = [];
        }

        // remove any trx if it is not Accepted or cash out
        foreach ($resul['RESULT'] as $key => $trx) {
            if ($trx['Status'] != "Accepted") {
                unset($resul['RESULT'][$key]);
            }
            if ($trx['DestinationMSISDN'] == "ZainCO" && $trx['Description'] == "Cash Out") {
                unset($resul['RESULT'][$key]);
            }
            if ($trx['TransactionAmount'] == "0.001" || $trx['TransactionAmount'] == "-0.001") {
                unset($resul['RESULT'][$key]);
            }
        }
        $data = [];

        foreach ($resul['RESULT'] as $trx) {
            $data[] = $trx;
        }
        $resul['RESULT'] = $data;

        // call zain cash system to get available balance
        $balance = $this->_zain_cash->getBalance($wallet_id);
        $resul['balance'] = $balance['RESULT']['Balance'];

        // return result
        parent::response($resul);
    }

    // ----------------------------------------------------------------------------------------------- //
    // ------------------- get jo petrol waybills ------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getJoPetrolWaybills()
    {

        $tender_id = $this->_request->tender_id;
        $status = $this->_request->status;

        if (!$tender_id) throw new Exception("tender_id is required");
        if (!$status) $status = "'0'";

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'JO_PETROL_report');

        // call Jo_Petrol system to get data
        $waybills = $this->_jo_petrol->fetchWaybills($status);
        parent::response($waybills);
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------------------- get tender orders stats for today orders ------------------------ //
    // ----------------------------------------------------------------------------------------- //
    public function searchJoPetrolPolicy()
    {

        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $tender_id = $this->_request->tender_id;
        if (!$date_from || !$date_to || !$tender_id) {
            throw new Exception("missing required parametrs (date_from, date_to, tender_id)");
        }
        try {

            //validate role code if it has the ownership to view this report
            $this->hasAuthToViewReport($tender_id, 'jo_petrol_policy_number_report');

            // get todays orders
            $bills = DBConnection::searchJoPetrolPolicy($date_from, $date_to, $tender_id);

            // response with result
            parent::response($bills);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------------- //
    // --------------------- get list of waybills for each trucking company -------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchTruckingCompanyWaybills()
    {

        // get input params
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;
        $order_date_from = $this->_request->order_date_from;
        $order_date_to = $this->_request->order_date_to;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'trucking_company_waybills');

        // search for trucking company on a certain tender
        $tenderCompanyFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1000, 0, $_SESSION['user_id']);

        // prepare search filter
        $total = [];
        $trucking_company_ids = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            $result = [];
            $result['id'] = $tenderCompany->trucking_company_id;
            $result['name'] = $tenderCompany->name;
            $result['create_date'] = $create_date_from;
            $result['waybills'] = [];
            $total[$tenderCompany->trucking_company_id] = $result;
            $trucking_company_ids[] = $tenderCompany->trucking_company_id;
        }

        $waybillFilter = [
            ['key' => 'trucking_company_id', 'val' => $trucking_company_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];

        if ($create_date_from) {
            $waybillFilter[] = ['key' => 'create_date', 'val' => $create_date_from, 'op' => 'date greater than'];
        }
        if ($create_date_to) {
            $waybillFilter[] = ['key' => 'create_date', 'val' => $create_date_to, 'op' => 'date less than'];
        }

        if ($order_date_from) {
            // search for all orders in the given date
            $tenderSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'order_date', 'val' => $order_date_from, 'op' => 'date greater than'],
                ['key' => 'order_date', 'val' => $order_date_to, 'op' => 'date less than']
            ];
            $orderResult = $this->_tenderCore->searchTenderOrder($tenderSearchFilter, 1, 0, 0);
            $order_ids = [];
            foreach ($orderResult->data as $order) {
                $order_ids[] = $order->id;
            }
            $waybillFilter[] = ['key' => 'document', 'val' => $order_ids, 'op' => 'json in', 'node' => '$.order.id'];
        }

        // search for waybills
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $_SESSION['user_id']);

        // loop on the waybills to sort them
        foreach ($waybillResult->data as $waybill) {

            $wbl = new stdClass();
            $wbl->wn = $waybill->wn;
            $wbl->tn = json_decode($waybill->document)->carrier[0]->truck->tn;
            $wbl->trn = json_decode($waybill->document)->carrier[0]->trailer->tn;
            $wbl->driver_name = json_decode($waybill->document)->carrier[0]->driver->name;
            $wbl->driver_nn = json_decode($waybill->document)->carrier[0]->driver->nn;
            $wbl->driver_phone = json_decode($waybill->document)->carrier[0]->driver->phone;
            $wbl->serial = json_decode($waybill->document)->integeration_details->queue->serial;
            $wbl->new_serial = json_decode($waybill->document)->integeration_details->queue->new_serial;
            $wbl->notes = "";
            $total[$waybill->trucking_company_id]['waybills'][] = $wbl;
        }

        foreach ($total as $index => $t) {
            if (empty($t['waybills'])) {
                unset($total[$index]);
            }
        }

        parent::response($total);
    }



    // ----------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of beneficiary_accounts ----------------------------------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    public function getBeneficiaryAccounts()
    {

        $tender_id = $this->_request->tender_id;

        try {
            //validate role code if it has the ownership to view this report
            $this->hasAuthToViewReport($tender_id, 'beneficiary_account');

            // get the beneficiary accounts of tender
            $result = DBConnection::getBeneficiaryAccounts($tender_id);

            // return response
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------- //
    // ------------------------ get grains comopany share ------------------------- //
    // ---------------------------------------------------------------------------- //
    public function getGrainsCompanyShare()
    {

        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'grains_share_report');

        $data = DBConnection::getGrainsCompanyShare($tender_id, $q_id);

        usort($data, array('Report_interface', 'grainsCompanyShareComparator'));

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }

    //Comparator function used for comparator
    public static function grainsCompanyShareComparator($a, $b)
    {
        return strcmp($b->residual, $a->residual);
    }


    // ----------------------------------------------------------------------------------------- //
    // ----------------------- get Tender Trucks Destination ----------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getTenderTrucksDestination()
    {
        $tender_id =  $this->_request->tender_id;
        $tn =  $this->_request->tn;
        $destinations =  $this->_request->destination;
        $q_id =  $this->_request->q_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'tender_truck_destination_report');

        if ($destinations) {
            $destinations = explode(",", $destinations);
        }

        $data = DBConnection::getTenderTrucksDestination($tender_id, $tn, $destinations, $q_id);

        foreach ($data as &$truck) {
            $truck->questionnaire = json_encode(json_decode($truck->questionnaire)[0]->val);
        }

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------------- get waybills that are late for loading --------------------------------------------------------- //
    // ------------------- Params: create_date_from, create_date_to , loading_date_from , loading_date_to  ---------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function getLateWaybillsForLoading()
    {

        // parse incoming params       
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;
        $loading_date_from = $this->_request->loading_date_from;
        $loading_date_to = $this->_request->loading_date_to;
        $tender_id = $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'late_trucks_for_loading_report');

        $sqlQuery = " select 
                    w.wn,
                    w.tn,
                    JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].trailer.tn')) trn,
                    JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].tc.name')) tc,
                    JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].driver.name')) driver_name,
                    JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].driver.phone')) phone,
                    wo.create_date , w.loading_date 
                    
                    from waybill_view w , waybill_order_view wo
                     where wo.create_date > ? and wo.create_date < ?
                     and w.tender_id = ? and
                     w.loading_date > ? and w.loading_date < ?
                     and wo.status = 'CLOSED'
                     and w.truck_id = wo.truck_id
                    ";

        $param = [$create_date_from, $create_date_to, $tender_id, $loading_date_from, $loading_date_to];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // return result
        $Result = [];
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }


    // ----------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- get a summary of approved and closed waybill orders for certain date grouped by trail minor tt------------------- //
    // ----------------------------------------------------------------------------------------------------------------------------------- //
    public function searchApprovedWaybillOrderByMinorTT()
    {

        // parse filter data
        $tender_id = $this->_request->tender_id;
        $create_date = $this->_request->create_date;
        $cargo_id = $this->_request->cargo_id;
        $end_date = date('Y-m-d', strtotime($create_date . ' + 1 days'));
        $param = [];

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'approved_waybill_order_report');

        // run query
        $sqlQuery = "SELECT 
                        COUNT(w.id) cnt,
                        w.cargo_name,
                        w.cargo_id,
                        tender_order.order_date,
                        CASE
                            WHEN w.status = 'CLOSED' THEN 'مكتمل'
                            WHEN w.status = 'APPROVED' THEN 'موافق عليه'
                        END AS status,
                        (SELECT CASE
                                WHEN t.minor_tt = 201 THEN 'قلاب'
                                WHEN t.minor_tt = 203 THEN 'تريلا'
                                WHEN t.minor_tt = 9 THEN 'تريلا'
                                END
                            FROM truck t
                            WHERE w.trn = tn AND status = 'ACTIVE') AS tt
                    FROM
                        waybill_order_view w , tender_order
                    WHERE
                            w.tender_order_id = tender_order.id
                            and w.status in ('APPROVED','CLOSED')
                            AND w.tender_id = $tender_id ";

        if ($create_date && $end_date) {
            $sqlQuery .= "and w.create_date > ?
                          and w.create_date < ? ";

            $param[] = $create_date;
            $param[] = $end_date;
        }

        if ($cargo_id) {
            $sqlQuery .= "and w.cargo_id = ? ";
            $param[] = $cargo_id;
        }

        $sqlQuery .= "GROUP BY w.cargo_name , w.cargo_id , order_date , status , tt";

        if (sizeof($param) == 0) {
            return;
        }

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }


    // ----------------------------------------------------------------------------------------- //
    // ----------------------- get tender orders stats for today orders ------------------------ //
    // ----------------------------------------------------------------------------------------- //
    public function getTodayTenderOrderDetails()
    {

        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;
        $order_date = $this->_request->order_date;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'today_tender_order_report');

        // get the tender_company of the tender and the indivesual company id
        $tenderCompanyFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1000, 0, 0);
        $indivisualTenderCompanyIds = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            $service_list = json_decode($tenderCompany->service_list);
            foreach ($service_list as $service) {
                if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {
                    $indivisualTenderCompanyIds[] = $tenderCompany->id;
                }
            }
        }

        // get the tender code
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $tender_code = $man['tender_code'];

        try {

            // get todays orders
            $orders = DBConnection::getTodayTenderOrderDetails($tender_id, $q_id, $order_date);
            foreach ($orders as &$order) {

                // get individual share
                $sqlQuery = "select * from tender_order_company where  tender_order_id = ? and tender_company_id in (?) ";
                $param = [$order->tender_order_id, implode($indivisualTenderCompanyIds)];
                $individual_share = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $order->individual_share = $individual_share[0]->share;

                // get number of approved and closed waybill orders on this tender_order
                $waybillOrderFilter = [
                    ['key' => 'tender_order_id', 'val' => $order->tender_order_id],
                    ['key' => 'status', 'val' => ['APPROVED', 'CLOSED'], 'op' => 'in']
                ];
                $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0, 0);
                $order->approved_waybill_orders = $waybillOrderSearchResult->found_rows;

                // parse tender questionarre
                if ($tender_code == "GRAINS") {
                    $destination_id = json_decode($order->questionnaire)[0]->val;
                    $destination = getLocationName($destination_id);
                    $order->destination = $destination;

                    $origin_id = json_decode($order->questionnaire)[1]->val;
                    $origin = getLocationName($origin_id);
                    $order->origin = $origin;

                    $minor_tt = json_decode($order->questionnaire)[2]->val;
                    if ($minor_tt == "201")
                        $order->minor_tt = "قلاب";
                    if ($minor_tt == "201")
                        $order->minor_tt = "تريلا";
                    if ($minor_tt == "*")
                        $order->minor_tt = "جميع الأنماط";
                }

                // get number of pending trucks less than max queue id
                $queueFilter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'q_id', 'val' => $order->q_id],
                    ['key' => 'id', 'val' => $order->latest_queue_id, 'op' => 'less than'],
                    ['key' => 'status', 'val' => "PENDING"]
                ];
                $queueResult = $this->_queueCore->searchQueue($queueFilter, 10000, 0, 0);

                //filter above result based on tender_truck questionarre if truck accept to go to destionation
                $truck_ids = [];
                foreach ($queueResult->data as $queue) {
                    $truck_ids[] = $queue->truck_id;
                }
                $tenderTruckFilter = [
                    ['key' => 'truck_id', 'val' => $truck_ids, 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in'],
                    ['key' => 'tender_id', 'val' => $tender_id]
                ];
                $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1000, 0, 0);
                $pending_trucks = 0;
                foreach ($tenderTruck_qry->data as $tenderTruck) {
                    $questionnaire = json_decode($tenderTruck->questionnaire);
                    if ($tender_code == "GRAINS") {
                        if (in_array($destination_id, $questionnaire[0]->val)) {
                            $pending_trucks++;
                        }
                    }
                }
                $order->pending_trucks = $pending_trucks;
            }

            // get tha maximum serial for each order
            parent::response($orders);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- Get a report of all waybill orders that were revoked because they exceeded the allowed time to come ---------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function getRevokedWaybillOrdersReport()
    {
        // parse filter data
        $tender_id = $this->_request->tender_id;
        $revoke_date_from = $this->_request->revoke_date_from;
        $revoke_date_to = $this->_request->revoke_date_to;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'revoked_waybill_order_report');

        // get data for indivisuals
        $sqlQuery = "SELECT
                        w.id,
                        w.tn,
                        w.trn,
                        w.cargo_name,
                        w.queue_name,
                        w.contact_name,
                        w.contact_phone,
                        w.trucking_company_name,
                        TIMESTAMPDIFF(HOUR, w.order_date,a.activity_date) diff
                    FROM
                        waybill_order_view w,
                        activity a
                    WHERE
                        a.notes = 'إرجاع الشاحنة على الدور بسبب انقضاء المهلة الزمنية'
                            AND a.waybill_order_id = w.id
                            AND w.tender_id = ?
                            AND a.activity_date >= ?
                            AND a.activity_date < ?";
        $param = [$tender_id, $revoke_date_from, $revoke_date_to];
        $individual_data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // get data for companies
        $sqlQuery = "SELECT 
                        count(w.id) cnt , w.trucking_company_name
                    FROM
                        waybill_order_view w , activity a
                    WHERE
                        w.tender_id = ? AND w.status = 'CLOSED'
                            AND w.queue_id IS NULL
                            and w.waybill_id is null
                            and a.waybill_order_id = w.id
                            and a.action_code = 'CHANGE_STATUS'
                            and a.object_new_status_code = 'CLOSED'
                            AND a.activity_date >= ?
                            AND a.activity_date < ?
                    group by trucking_company_name
                    order by cnt desc";
        $param = [$tender_id, $revoke_date_from, $revoke_date_to];
        $company_data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->individual_data = $individual_data;
        $result->company_data = $company_data;
        $result->found_rows = sizeof($individual_data);
        parent::response($result, 200);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of complete waybills with financial data  --------------------------- //
    // ------------------ param: tender_id, trucking_company_id, loading_date_from, loading_date_to ------ //
    // --------------------------------------------------------------------------------------------------- //
    public function getRevokedWaybillsReport()
    {

        //parse inputs
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'revoked_waybill_report');

        // get list of revoked waybills
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'in'],
            ['key' => 'create_date', 'val' => $create_date_from, 'op' => 'greater than'],
            ['key' => 'create_date', 'val' => $create_date_to, 'op' => 'less than']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // prepare data
        $result = [];
        foreach ($waybillResult->data as $waybill_data) {
            $data = new stdClass();
            $doc = json_decode($waybill_data->document);

            // waybill info
            $data->wn = $waybill_data->wn;
            $data->tn = $waybill_data->tn;
            $data->trn = $doc->carrier[0]->trailer->tn;
            $data->destination = $doc->negotiable_instructios->route->destination->name;
            $data->cargo_name = $doc->cargo[0]->cargo->name;
            $data->owner_name = $doc->carrier[0]->truck_owner->name;

            // activity info
            $waybillBean = $this->_waybillCore->getWaybill($waybill_data->id, $_SESSION['user_id']);
            $waybillBean = json_decode($waybillBean);

            foreach ($waybillBean->activity as $activity) {
                if ($activity->action_code == 'ADD_NOTE' && ($activity->object_status_code == 'REVOKED' || $activity->object_status_code == 'INACTIVE')) {
                    $data->revoke_reason = $activity->notes;
                    $data->revoke_date = date('Y-m-d H:i', strtotime($activity->activity_date));
                    $data->revoke_by = $activity->u_id;
                }
            }

            $result[] = $data;
        }

        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------------- //
    // -------------------- Get report data for held queue during certaion time --------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function getHeldQueueReports()
    {

        // parse filter data
        $tender_id = $this->_request->tender_id;
        $held_date_from = $this->_request->held_date_from;
        $held_date_to = $this->_request->held_date_to;

        $waybill_start_date = date('Y-m-d', strtotime($held_date_from));
        $waybill_end_date = date('Y-m-d', strtotime($held_date_to));

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'held_queue_report');

        // run query
        $sqlQuery = "SELECT
                       q.tn,
                       q.trn,
                       q.contact_name,
                       q.contact_phone,
                       q.status,
                       q.rank,
                       a.activity_date,
                       (select max(wn) from waybill where tender_id=7 and truck_id = q.truck_id and create_date >= ? and create_date < ?) wn
                   FROM
                       queue_view q,
                       activity a
                   WHERE
                       q.tender_id = ? AND a.queue_id = q.id
                           AND a.object_new_status_code = 'HELD'
                           AND a.action_code = 'CHANGE_STATUS'
                           AND a.activity_date >= ?
                           AND a.activity_date < ?
                           order by a.activity_date
                           ";

        $param = [$waybill_start_date, $waybill_end_date, $tender_id, $held_date_from, $held_date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------ Get the stats report for a certain tender order --------------------- //
    //------------------- This report measure by whom each waybill_order was approved --------- //
    // ------------------ and calculate some useful info of how tender order was procces ------ //
    // ---------------------------------------------------------------------------------------- //
    public function getTenderOrderStatsReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'tender_order_report');

        // run query to get raw data
        $sqlQuery = " SELECT
                    COUNT(id) cnt,
                    CASE
                        WHEN user = 'mobile' THEN 'التطبيق'
                        WHEN user = 'cc' THEN 'الاتصال الالي'
                        ELSE 'موظفي الإتصال'
                    END AS done_by
                    FROM
                        waybill.waybill_order_01_report w
                    WHERE
                        tender_order_id = ?
                        AND w.result_status = 'APPROVED'
                    GROUP BY CASE
                        WHEN user = 'mobile' THEN 'التطبيق'
                        WHEN user = 'cc' THEN 'الاتصال الالي'
                        ELSE 'موظفي الإتصال'
                        END";

        $param = [$tender_order_id];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // get the tenderOrder info
        $ordersFilter = [['key' => 'id', 'val' => $tender_order_id]];
        $orderResult = $this->_tenderCore->searchTenderOrder($ordersFilter, 1, 0, $_SESSION['user_id']);
        $tenderOrderBean = $orderResult->data[0];
        $tenderOrderActivity =  json_decode($this->_tenderCore->getTenderOrder($tender_order_id, $_SESSION['user_id']))->activity;

        // calculate the lifetime of the tender order
        $end_time = DBConnection::getSystemDate();
        foreach ($tenderOrderActivity as $activity) {
            if ($activity->object_status_code == "ACTIVE" && $activity->object_new_status_code == "PENDING") {
                $start_time = $activity->activity_date;
            }
            if ($activity->object_status_code == "PENDING" && $activity->object_new_status_code == "CLOSED") {
                $end_time = $activity->activity_date;
            }
        }
        $start_time = date_create(date($start_time));
        $end_time   = date_create(date($end_time));
        $tenderOrderLifeTime = date_diff($end_time, $start_time);

        // calculate number of waybill orders by status in this tender order
        $waybillOrderFilter = [['key' => 'tender_order_id', 'val' => $tender_order_id]];
        $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0,  $_SESSION['user_id']);

        $approved_count = 0;

        $total_approved_waybill_discharge_weight = 0;
        $closed_count = 0;
        $revoked_count = 0;
        $new_count = 0;
        $waiting_count = 0;
        foreach ($waybillOrderSearchResult->data as $waybillOrder) {
            if ($waybillOrder->status == 'APPROVED') $approved_count++;
            else if ($waybillOrder->status == 'NEW') $new_count++;
            else if ($waybillOrder->status == 'WAITING' || $waybillOrder->status == 'PENDING') $waiting_count++;
            elseif ($waybillOrder->status == 'CLOSED') {
                $closed_count++;
                $total_approved_waybill_discharge_weight += json_decode($waybillOrder->document)->cargo[0]->weights->loading->net_weight;
            } elseif ($waybillOrder->status == 'REVOKED') {
                $revoked_count++;
            }
        }


        // calculate percentage of approval
        foreach ($data as &$row) {
            $row->perc = round(($row->cnt / ($approved_count + $closed_count)) * 100, 1) . "%";
            $row->cnt = intval($row->cnt);
        }

        // format data
        $result = new stdClass();
        $result->approval = $data;
        $result->info = new stdClass();
        $result->info->queue_name = $tenderOrderBean->queue_name;
        $result->info->cargo_name = $tenderOrderBean->cargo_sample_name;
        $result->info->status = $tenderOrderBean->status;
        $result->info->trucks = $tenderOrderBean->trucks;
        $result->info->approved_count = $approved_count;
        $result->info->closed_count = $closed_count;
        $result->info->revoked_count = $revoked_count;
        $result->info->new_count = $new_count;
        $result->info->waiting_count = $waiting_count;

        $result->info->total_approved_waybill_discharge_weight = $total_approved_waybill_discharge_weight;
        if ($tenderOrderLifeTime->i < 10) {
            $result->info->duration = $dateDiff = $tenderOrderLifeTime->h . ":0" . $tenderOrderLifeTime->i;
        } else {
            $result->info->duration = $dateDiff = $tenderOrderLifeTime->h . ":" . $tenderOrderLifeTime->i;
        }
        $result->info->complete_perc = round((($approved_count + $closed_count) / $tenderOrderBean->trucks) * 100, 1) . "%";

        parent::response($result, 200);
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------ Get the stats report for a certain tender order --------------------- //
    //------------------- This report measure by whom each waybill_order was revoked --------- //
    // ------------------ and calculate some useful info of how tender order was procces ------ //
    // ---------------------------------------------------------------------------------------- //
    public function getTenderOrderRevokedStatsReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'tender_order_report');

        // run query to get raw data
        $sqlQuery = "SELECT
                COUNT(id) cnt,
                        CASE
                    WHEN user = 'mobile' THEN 'التطبيق'
                    WHEN user = 'cc' THEN 'الاتصال الالي'
                    ELSE 'موظفي الإتصال'
                        END AS done_by
                    FROM
                    waybill.waybill_order_01_report w
                    WHERE
                    tender_order_id = ?
                    AND w.result_status = 'REVOKED'
                GROUP BY CASE
                    WHEN user = 'mobile' THEN 'التطبيق'
                    WHEN user = 'cc' THEN 'الاتصال الالي'
                    ELSE 'موظفي الإتصال'
                    END";

        $param = [$tender_order_id];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        foreach ($data as &$row) {
            $row->cnt = intval($row->cnt);
        }

        $result = new stdClass();
        $result->revoked = $data;

        parent::response($result, 200);
    }
    // ---------------------------------------------------------------------------------------- //
    // ------------------ Get the stats report for a certain tender order --------------------- //
    //--------------- This report measure by whom each waybill_order ticket was approved ------ //
    // ---------------- and calculate some useful info of how tender order was processed ------ //
    // ---------------------------------------------------------------------------------------- //

    public function getEmployeeStatsForWaybillOrderTickets()
    {
        $tenderOrderId = $this->_request->tender_order_id;
        // Validate
        if (!$tenderOrderId) throw new Exception("tender_order_id is required");
        if (!is_numeric($tenderOrderId)) throw new Exception("tender_order_id should be numeric, but got [" . gettype($tenderOrderId) . "]");

        $result = [];

        // Query to get all ticket ids
        $qry = 'select tc_details->>"$.ticket_id" ticket_id from waybill_order
        where  tender_order_id = ? and tc_details->>"$.ticket_id" is not null;';
        $ticketsIds = DBConnection::runBindDatabaseQuery($qry, [$tenderOrderId]);
        if (empty($ticketsIds)) {
            parent::response($result, 200);
            die;
        }
        $ticketIdsPluck = [];
        foreach ($ticketsIds as $ticketId) {
            $ticketIdsPluck[] = $ticketId->ticket_id;
        }
        // Get statistics from ticketing system (CC)
        $ticketStats = $this->_customerCare->getTicketsUsersStats($ticketIdsPluck);
        //Get completed status tickets statistics (Filter on element.status=="COMPLETED")
        // then append user name to the statistics
        foreach ($ticketStats as $stat) {
            if (strtoupper($stat['status']) == "COMPLETED") {
                // die(json_encode([$stat['user_id'], $_SESSION['u_id']]));
                $name = $this->_userCore->getUserBasic($stat['user_id'], 0)->name;
                $stat['name'] = $name;
                $result[] = $stat;
            }
        }

        parent::response($result, 200);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------------ Get the stats report for a certain tender order ----------------------------- //
    //------------------- This report measure the performance of each employee on call center --------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getTenderOrderPerformanceStatsReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'tender_order_report');


        // run query to get raw data
        $sqlQuery = "SELECT
                e.name,
                result_status as statusCode,
                COUNT(w.id) cnt
                    FROM
                waybill.waybill_order_01_report w , employee e
                    WHERE
                tender_order_id = ?
                    AND w.result_status IN ('APPROVED' , 'REVOKED')
                    AND user NOT IN ('mobile' , 'cc')
                    and w.user = e.id
            GROUP BY user , result_status";

        $param = [$tender_order_id];
        $searchQueryResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);



        $result = [];
        $names = [];
        foreach ($searchQueryResult as $record) {
            if (!in_array($record->name, $names)) {
                $names[] = $record->name;
            }
        }

        foreach ($names as $name) {
            $obj = new stdClass();
            $obj->name = $name;
            foreach ($searchQueryResult as $record) {
                if ($record->name == $name) {
                    if ($record->statusCode == 'APPROVED') $obj->approved = intval($record->cnt);
                    if ($record->statusCode == 'REVOKED') $obj->revoked = intval($record->cnt);
                }
            }

            if (!$obj->approved) $obj->approved = 0;
            if (!$obj->revoked) $obj->revoked = 0;
            $result[] = $obj;
        }

        parent::response($result, 200);
    }


    private function findInArray($value, $arr, $key = 'name')
    {
        foreach ($arr as $temp) {
            if ($temp->$key == $value) {
                return 1;
            }
        }
        return 0;
    }


    // -------------------------------------------------------------------------------------------------- //
    // -------------------------------- Get Tender share list for report -------------------------------- //
    // -------------------------------- param: tender_id , snapshot_date -------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getTenderShares()
    {

        // parse incoming data
        $tender_id = $this->_request->tender_id;
        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'tender_shares_report');

        // get the shareholders
        $searchQueryResult = $this->_tenderCore->getTenderShares($tender_id);

        // parse result
        $result = [];
        foreach ($searchQueryResult as $accountInfo) {
            $share = new stdClass();
            $share->share_holder_name = $accountInfo->name;
            $share->account_id = $accountInfo->acc;
            $share->amount = $accountInfo->amount;
            $result[] = $share;
        }
        parent::response($result);
    }

    // --------------------------------------------------------------------------------------- //
    // ------------------- get the number of waybills per destination ------------------------ //
    // ------------------- Params: cargo_id, destination_id-------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function getWaybillByDestination()
    {

        // parse params
        $cargo_ids = explode(",", $this->_request->cargo_id);
        $origin_id = (int)$this->_request->origin_id;
        $destination_id = (int)$this->_request->destination_id;
        $tender_id = $this->_request->tender_id;
        $date_type = $this->_request->date_type;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        if (!$tender_id) {
            //throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'destination_stats_report');


        if (getType($date_type) == "string") {
            $date_type = json_decode($date_type)->value;
        } else {
            $date_type = $date_type->value;
        }

        // search database
        $waybillFilter = [];
        if ($cargo_ids && sizeof($cargo_ids) > 0 && $cargo_ids[0] != "") {
            $cargo_ids = explode(",", $this->_request->cargo_id);
            $waybillFilter[] = ['key' => 'document', 'val' => $cargo_ids, 'op' => 'json in', 'node' => '$.cargo[0].cargo_id'];
        }

        switch ($date_type) {
            case 'order_date':
                $sqlQuery = "select t.id from tender_order_view t , activity a
                             where t.id = a.tender_order_id and a.action_code = 'CREATE'
                             and t.status not in ('REVOKED','INACTIVE')
                             and t.tender_id = ?
                             and a.activity_date >= ?";
                $param = [$tender_id, $date_from];
                if ($date_to) {
                    $sqlQuery .= " and a.activity_date < ? ";
                    $param[] =  [$date_to];
                }
                $orderResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

                $order_ids = [];
                foreach ($orderResult as $order) {
                    $order_ids[] = $order->id;
                }
                $waybillFilter[] = ['key' => 'order_id', 'val' => $order_ids, 'op' => 'in'];
                break;
            case 'loading_date':
            case 'loding_date':
                if ($date_from) $waybillFilter[] = ['key' => 'loading_date', 'val' => $date_from, 'op' => 'date greater than'];
                if ($date_to) $waybillFilter[] = ['key' => 'loading_date', 'val' => $date_to, 'op' => 'date less than'];
                break;
            case 'discharge_date':
                if ($date_from) $waybillFilter[] = ['key' => 'discharge_date', 'val' => $date_from, 'op' => 'date greater than'];
                if ($date_to) $waybillFilter[] = ['key' => 'discharge_date', 'val' => $date_to, 'op' => 'date less than'];
                break;
            case 'create_date':
                if ($date_from) $waybillFilter[] = ['key' => 'create_date', 'val' => $date_from, 'op' => 'date greater than'];
                if ($date_to) $waybillFilter[] = ['key' => 'create_date', 'val' => $date_to, 'op' => 'date less than'];
                break;
        }

        if ($destination_id)
            $waybillFilter[] = ['key' => 'destination_id', 'val' => $destination_id];
        if ($origin_id)
            $waybillFilter[] = ['key' => 'origin_id', 'val' => $origin_id];


        $waybillFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
        $waybillFilter[] = ['key' => 'create_date', 'val' => date('Y-m-d', strtotime('-1 years')), 'op' => 'date greater than'];
        $waybillFilter[] = ['key' => 'status', 'val' => ['REVOKED', 'REJECTED', 'INACTIVE'], 'op' => 'not in'];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // loop on result and start sorting
        $data = [];
        foreach ($waybillResult->data as $wbl) {
            // get the location_name
            $doc = json_decode($wbl->document);
            $location_name = $doc->negotiable_instructios->route->destination->name;

            // if the location is new in the final result, insert it with 0 counts
            if (!$data[$location_name]) {
                $temp = new stdClass();
                $temp->location_name = $location_name;
                $temp->destination_id = $wbl->destination_id;
                $temp->total_waybill = 0;
                $temp->numberOfLoadedWaybill = 0;
                $temp->loading_weight = 0;
                $temp->numberOfDischargedWaybill = 0;
                $temp->discharge_weight = 0;

                // $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($doc->order->id,0);
                // $order_notes = json_decode($tenderOrderBean->order_notes);
                // $temp->remarks = $order_notes->extra_note;               
                $data[$location_name] = $temp;
            }

            // count the waybill into the total
            $data[$location_name]->total_waybill++;

            // if the waybill is loaded then increase the loaded waybill count
            if ($doc->cargo[0]->weights->loading->net_weight && (int)$doc->cargo[0]->weights->loading->net_weight > 0) {
                $data[$location_name]->numberOfLoadedWaybill++;
            }
            // if the waybill is discharged then increase the loaded waybill count
            if ($doc->cargo[0]->weights->discharge->net_weight && (int)$doc->cargo[0]->weights->discharge->net_weight > 0) {
                $data[$location_name]->numberOfDischargedWaybill++;
            }

            // add the loaded weight intoo the result
            $data[$location_name]->loading_weight += (int)$doc->cargo[0]->weights->loading->net_weight;
            $data[$location_name]->discharge_weight += (int)$doc->cargo[0]->weights->discharge->net_weight;
        }

        //sort the array by total_waybill
        $sorted_data = array_values($data);
        usort($sorted_data, array('Report_interface', 'comparator'));

        // get cargo info
        $cargoSearchFilter = [['key' => 'id', 'val' => $cargo_ids, 'op' => 'in']];
        $searchCargoResult = $this->_cargoCore->searchCargo($cargoSearchFilter, 1, 0, $_SESSION['user_id']);

        foreach ($searchCargoResult->data as &$cargoRow) {

            $tc_searchFilter = [
                ['key' => 'id', 'val' => $cargoRow->trucking_company_id],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, 0);

            $cargoRow->trucking_company_name = $tc_qry->data[0]->name;
        }

        // format data
        $result = new stdClass();
        $result->data = $sorted_data;
        $result->cargo_info =  $searchCargoResult->data[0];
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }

    // Comparator function used for comparator
    public static function comparator($object1, $object2)
    {
        return $object1->total_waybill < $object2->total_waybill;
    }


    // --------------------------------------------------------------------------------------------------------------------------------------------- //
    // -------------------- Get stats data for trucks on queue like (max waybill date, number of waybill orders after last waybill) ---------------- //
    // --------------------------------------------------------------------------------------------------------------------------------------------- //
    public function getQueueStatsReport()
    {

        // get params
        $tender_id = $this->_request->tender_id;
        $last_wbl = $this->_request->last_wbl;
        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'queue_history_report');

        // prepare search filter
        $queueFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'last_wbl', 'val' => $last_wbl, 'op' => 'less than']
        ];

        $queueInfo = DBConnection::searchReport("queue", "04", $queueFilter, 20000, 0, $_SESSION['user_id']);
        // return result
        parent::response($queueInfo, 200);
    }


    // -------------------------------------------------------------------------------------------- //
    // ----------------- Get a report of all trucks that finished all the delays options ---------- //
    // -------------------------------------------------------------------------------------------- //
    public function getNoMoreDelaysTrucksReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;
        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        if (!$tender_order_id) {
            throw new Exception("tender_order_id is required");
        }

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'no_more_delays_report');

        // prepare sql
        $sqlQuery = "SELECT 
                        q.tn,
                        w.trn,
                        CASE q.trail_minor_tt
                            WHEN 201 THEN 'قلاب'
                            WHEN 203 THEN 'تريلا'
                        END AS trail_minor_tt,
                        q.rank,
                        w.truck_owner_phone,
                        w.truck_owner_name
                    FROM
                        waybill_order_view w,
                        queue_view q
                    WHERE
                        w.tender_order_id = $tender_order_id
                            AND w.queue_id = q.id
                            AND w.status in ('WAITING')
                            AND q.total_delay = 8";

        $param = [];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }

    // ----------------------------------------------------------------------------------------------- //
    // ------------------- Get Vessel Loading performance report ------------------------------------- //
    //-------------------- Params: tender_id, [cargo_id] --------------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getVesselLoadingPerformanceByDate()
    {

        // parse incoming params
        $tender_id = $this->_request->tender_id;
        $cargo_ids = explode(",", $this->_request->cargo_ids);
        $cargo_ids[] = 0;
        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'loading_performance_report');


        // search for waybill for the requested cargos
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'loading_date', 'op' => 'is not null'],
            ['key' => 'document', 'val' => $cargo_ids, 'op' => 'json in', 'node' => '$.cargo[0].cargo_id']
        ];

        // search for waybills
        $order_by = " order by loading_date ";
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 100000, 0, $_SESSION['user_id'], $order_by);

        $result = [];
        foreach ($waybillResult->data as $wbl) {
            $result[date("d-m-Y", strtotime($wbl->loading_date))]++;
        }

        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of late truck, these trucks have loading weight and no discharge weight ---------------- //
    // ------------------ and late for certain period of time --------------------------------------------------------------- //
    // ------------------ param: tender_id, late_hours , destination_id---------------------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------- //
    public function getLateWaybills()
    {

        // search for ONROAD waybills
        $tender_id = $this->_request->tender_id;
        $destination_id = $this->_request->destination_id;
        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'grains_late_trucks_report');

        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'destination_id', 'val' => $destination_id],
            ['key' => 'status', 'val' => 'ONROAD']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // loop on each waybill and calculate time elapsed since loading
        $currentTime = DBConnection::getSystemDate();
        $currentTime = date_create($currentTime);

        $result = [];
        foreach ($waybillResult->data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);
            $loadingTime = $doc->cargo[0]->weights->loading->time_stamp;
            $loadingTime = date_create($loadingTime);
            $dateDiff = date_diff($loadingTime, $currentTime);
            $elapsedTime = $dateDiff->h + ($dateDiff->d * 24);

            // if elapsedTime > requested late_hours, push it to result array
            if ($elapsedTime > $this->_request->late_hours) {
                if ($dateDiff->d > 0) {
                    $waybill_data->elapsedTime = $dateDiff->d . " يوم و " . $dateDiff->h . " ساعة";
                } else {
                    $waybill_data->elapsedTime = $dateDiff->h . " ساعة";
                }

                $waybill_data->trn = $doc->carrier[0]->trailer->tn;
                $waybill_data->cargo_name = $doc->cargo[0]->cargo->name;
                $waybill_data->origin = $doc->negotiable_instructios->route->origin->name;
                $waybill_data->destination = $doc->negotiable_instructios->route->destination->name;
                $result[] = $waybill_data;
            }
        }

        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of blacklist trucks on certain tender  ------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getBlackListReport()
    {

        $tender_id = $this->_request->tender_id;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'black_list_report');

        // prepare filter
        $blackListFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
        if ($date_from) {
            $blackListFilter[] = ['key' => 'activity_date', 'val' => $date_from, 'op' => 'date greater than'];
        }
        if ($date_to) {
            $blackListFilter[] = ['key' => 'activity_date', 'val' => $date_to, 'op' => 'date less than'];
        }

        // call database report
        $blackListResult = DBConnection::searchReport("tender_truck", "01", $blackListFilter, 20000, 0, $_SESSION['user_id']);

        // return result
        $Result = [];
        $Result['data'] = $blackListResult->data;
        $Result['found_rows'] = $blackListResult->found_rows;
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------- //
    // ------------------- get summary report fpr external waybills services ----------------- //
    // ------------------- Params: tender_id, create_date_from, create_date_to---------------- //
    // --------------------------------------------------------------------------------------- //
    public function getExternalWaybillServiceSummary()
    {

        // parse incoming params
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'external_waybills_services');

        $sqlQuery = " SELECT
                        JSON_UNQUOTE(JSON_EXTRACT(document,'$.external_service.waybill_service_id')) service_id,
                        JSON_UNQUOTE(JSON_EXTRACT(document,'$.external_service.waybill_service_price')) waybill_service_price,
                        COUNT(id) cnt,
                        sum(JSON_EXTRACT(document,'$.external_service.waybill_service_price')) as amount
                    FROM
                        waybill w
                    WHERE
                        tender_id = ?
                            AND status NOT IN ('INACTIVE' , 'REVOKED')
                            AND JSON_EXTRACT(document,'$.external_service.waybill_service_id') IS NOT NULL
                            AND create_date >= ?
                            AND create_date < ?
                    GROUP BY service_id,waybill_service_price
                    ";

        $param = [$tender_id, $create_date_from, $create_date_to];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // loop on result and inject service name
        foreach ($result as &$service) {
            $service_name = "EXTERNAL_WAYBILL.SERVICE." . $service->service_id;

            switch ($service_name) {
                case 'EXTERNAL_WAYBILL.SERVICE.1':
                    $service->service_name = "تصاريح الفوسفات تفريغ";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.2':
                    $service->service_name = "تصاريح الإقتطاعات الخارجية تحميل";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.3':
                    $service->service_name = "تصاريح الإقتطاعات الخارجية + الفوسفات";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.4':
                    $service->service_name = "تصاريح الإقتطاعات الخارجية تحميل و تفريغ";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.5':
                    $service->service_name = "تصاريح الجسر العربي (ترانزيت) مصر ذهاب و عودة";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.6':
                    $service->service_name = "تصاريح الجسر العربي (ترانزيت) مصر ذهاب";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.7':
                    $service->service_name = "ذمم بوتاس";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.8':
                    $service->service_name = "تبويش + ترانزيت";
                    break;
                case 'EXTERNAL_WAYBILL.SERVICE.9':
                    $service->service_name = "بدل إلغاء تصاريح بواخر";
                    break;
                default:
                    $service->service_name = $service_name;
                    break;
            }
        }

        // return result
        $Result = [];
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------------------------------- //
    // --------------------- get a list of waybills on a certain tender claim on the remote server "JO_Petrol" ----------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function searchClaimOnRemoteServer()
    {
        $claim_number = $this->_request->claim_number;

        $data = $this->_jo_petrol->QueryOnClaimNumber($claim_number);

        foreach ($data as &$r) {
            if ($r->sea_water_confirmation == "1")
                $r->discharge_weight  += $r->sea_water;

            if ($r->discharge_weight > $r->loading_weight) {
                $r->discharge_weight = $r->loading_weight;
            }
        }

        // return result
        $result = [];
        $result['data'] = $data;
        parent::response($result);
    }


    // --------------------------------------------------------------------------------------- //
    // ------------------- get summary report fpr external waybills services ----------------- //
    // ------------------- Params: tender_id, create_date_from, create_date_to---------------- //
    // --------------------------------------------------------------------------------------- //
    public function getLoadingAndDischargeReport()
    {

        // parse incoming params
        $tender_id = $this->_request->tender_id;
        $loading_date_from = $this->_request->loading_date_from;
        $loading_date_to = $this->_request->loading_date_to;

        $extra_filter = $this->_request->extra_filter;

        if (!$tender_id) {
            throw new Exception("tender_id is required");
        }
        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'loading_discharge_report');

        // call database query
        $reportInfo = DBConnection::getLoadingAndDischargeReport($tender_id, $loading_date_from, $loading_date_to, $extra_filter);
        foreach ($reportInfo as &$data) {
            $data = json_decode(json_encode($data, JSON_UNESCAPED_UNICODE), true);
            foreach ($data as $key => &$value) {
                if (!$value || $value == "null") {
                    $value = "-";
                }
            }
        }

        // return result
        $Result = [];
        $Result['data'] = $reportInfo;
        $Result['found_rows'] = sizeof($reportInfo);
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a transactions on zain cash for certain period for acountant report ------------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function getZainCashTransactionsForAcountant_beta()
    {
        $tender_id = $this->_request->tender_id;
        $fromTime = $this->_request->from_time;
        $toTime = $this->_request->to_time;

        if (!$tender_id) throw new Exception("tender_id is required");
        if (!$fromTime) throw new Exception("from_time is required");
        if (!$toTime) throw new Exception("to_time is required");

        $toTime = date('Y-m-d', strtotime($toTime . "+1 days"));
        $toTime = date_format(date_create($toTime), "Y-m-d");
        $fromTime = date_format(date_create($fromTime), "Y-m-d");

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'zain_cash_accountant_report_beta');

        // call zain cash system to get trx
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $wallet_id = $man['freight']['payment_method']['wallet_id'];

        $resul = $this->_zain_cash->getCorpSOATrx($wallet_id, $fromTime, $toTime, null, null, $_SESSION['u_id']);

        // call zain cash system to get available balance
        $balance = $this->_zain_cash->getBalance($wallet_id);
        $trxResult = [];

        foreach ($resul['RESULT'] as &$trx) {
            $trx['Transaction_ref'] = $trx['Reference'];
            $trxResult[] = $trx;
        }

        $trxResult = array_reverse($trxResult, true);
        $array = json_decode(json_encode($trxResult), true);
        $data = [];
        foreach ($array as $value) {
            $data[] = $value;
        }
        $data = array_reverse($data);

        $Result = [];
        $Result['raw'] = $resul;
        $Result['data'] = $data;
        $Result['balance'] = $balance['RESULT']['Balance'];
        $Result['found_rows'] = sizeof($trxResult);
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a transactions on zain cash for certain period for acountant report ------------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function getZainCashTransactionsForAcountant()
    {
        $tender_id = $this->_request->tender_id;
        $fromTime = $this->_request->from_time;
        $toTime = $this->_request->to_time;

        if (!$tender_id) throw new Exception("tender_id is required");
        if (!$fromTime) throw new Exception("from_time is required");
        if (!$toTime) throw new Exception("to_time is required");
        $toTime = date_format(date_create($toTime), "Y-m-d 23:59:59");

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'zain_cash_accountant_report');

        // call zain cash system to get trx
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $wallet_id = $man['freight']['payment_method']['wallet_id'];

        $resul = $this->_zain_cash->getTransactions($wallet_id, $fromTime, $toTime, null, null, "getZainCashTransactionsForAcountant report", $_SESSION['u_id']);
        if ($resul['RESULT'] && $resul['RESULT'][0] == null) {
            $resul['RESULT'] = [];
        }

        // call zain cash system to get available balance
        $balance = $this->_zain_cash->getBalance($wallet_id);
        $trxResult = [];

        foreach ($resul['RESULT'] as $trx) {
            if ($trx['Status'] == "Accepted") {

                if ($_SESSION['u_id'] != 2) {
                    if ($trx['TransactionAmount'] == "0.001" || $trx['TransactionAmount'] == "-0.001") {
                        unset($resul['RESULT'][$key]);
                    }
                }

                $trxObj = [];
                $trxObj['TransactionDate'] = $trx['TransactionDate'];
                $trxObj['DestinationMSISDN'] = $trx['DestinationMSISDN'];

                if ($trx['Description'] == 'Salaries') {
                    $trxObj['Credit'] = abs($trx['TransactionAmount']);
                    $trxObj['Debit'] = 0;
                }
                if ($trx['DestinationMSISDN'] == "ZainCO" && $trx['Description'] == "Cash Out") {
                    $trxObj['Credit'] = 0;
                    $trxObj['Debit'] = abs($trx['TransactionAmount']);
                }
                $trxObj['TransactionReference'] = $trx['TransactionReference'];
                $trxObj['Comment'] = $trx['Comment'];

                $trxResult[] = $trxObj;
            }
        }

        $Result = [];
        $Result['data'] = $trxResult;
        $Result['balance'] = $balance['RESULT']['Balance'];
        $Result['found_rows'] = sizeof($trxResult);
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------------------- //
    // ---------------------- get history of orders for the last 20 days ------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getOrdersArchive()
    {
        // $tender_id = $this->_request->tender_id;
        $tender_id = 11;
        if ($_SESSION['u_id'] == 2 || $_SESSION['u_id'] == 475 || $_SESSION['u_id'] == 420) {
            echo $this->getOrdersArchive_v2($tender_id, 1, 20);
        } else {

            // search for last 20 orders
            $tenderOrderFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['REVOKED', 'INACTIVE'], 'op' => 'not in']
            ];
            $orderResult = $this->_tenderCore->searchTenderOrder($tenderOrderFilter, 20, 0, 0, ' order by order_date desc ');

            // group the result by dates
            $html = [];
            foreach ($orderResult->data as $order) {
                $html[$order->order_date] += $order->trucks;
            }


            $content = '
            <html>

            <head>
                <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
                <meta charset="utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

                <!-- Bootstrap CSS -->
                <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
                    integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
            </head>

            <body>
                            <div class="form-group row col-sm-12 d-flex justify-content-center" style="background-color:rgb(151, 198, 103) ; margin:0; color: white; font-weight:bold">
                        <div class="col" align="center">
                                        <label class="col-sm-12 col-xs-12 col-md-12 col-form-label"> ارشيف طلبيات النفط الخام لأخر 20 طلبية </label>
                        </div>
                </div>';

            $content .= '
                <form>
                    <div class="form-group row col-sm-12 d-flex justify-content-center" style="border-bottom: 1px #eee solid; margin:2px">
                                    <div class="col" align="center">
                                        <label class="col-sm-7 col-xs-7 col-md-7 col-form-label" style="font-weight:bold"> العدد </label>
                        </div>
                                    <div class="col" align="center">
                                        <label class="col-sm-5 col-xs-5 col-md-5 col-form-label" style="font-weight:bold"> التاريخ</label>
                        </div>
                    </div>
                ';
            $index = 0;
            foreach ($html as $key => $value) {
                $index++;
                if ($index % 2) {
                    $bg = 'background-color:#f7f7f7';
                } else {
                    $bg = 'background-color:#fff';
                }
                $content .= '<div class="form-group row col-sm-12 d-flex justify-content-center" style="border-bottom: 1px #eee solid; margin:2px ; ' . $bg . '">';
                $content .= '<div class="col" align="center">';
                $content .= '<label class="col-sm-7 col-xs-7 col-md-7 col-form-label">' . $value . '</label>';
                $content .= '</div>';
                $content .= '<div class="col" align="center">';
                $content .= '<label class="col-sm-7 col-xs-7 col-md-7 col-form-label">' . $key . '</label>';
                $content .= '</div>';
                $content .= '</div>';
            }

            $content .= '</form>
                            </div>
                            <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
                                integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN"
                                crossorigin="anonymous"></script>
                            <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"
                                integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q"
                                crossorigin="anonymous"></script>
                            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"
                                integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl"
                                crossorigin="anonymous"></script>
                        </body>
                    </html>
                    ';

            $content = str_replace("\n", "", $content);
            $content = stripslashes($content);
            echo $content;
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // ---------------------- get history of orders for the last 20 days ------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getOrdersArchive_v2($tender_id, $q_id, $duration)
    {
        // search for last 20 orders
        $tenderOrderFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['REVOKED', 'INACTIVE'], 'op' => 'not in']
        ];
        $orderResult = $this->_tenderCore->searchTenderOrder($tenderOrderFilter, $duration, 0, 0, ' order by order_date desc ');

        // the NEW added trucks on queue
        $newQueueTrucks = $this->_queueCore->getNewTrucksOnQueue($tender_id, $q_id, $duration * 2);

        // group the result by dates
        $html = [];
        foreach ($orderResult->data as $order) {
            $html[$order->order_date] += $order->trucks;
        }

        $html2 = [];
        foreach ($newQueueTrucks as $newQueue) {
            $html2[$newQueue->create_date] = $newQueue->cnt;
        }

        $content = '
            <html>
                <head>
                    <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
                    <meta charset="utf-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

                    <!-- Bootstrap CSS -->
                    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
                        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
                </head>

                <body>
                    <div class="form-group row col-sm-12 flex justify-content-center" style="background-color:rgb(151, 198, 103) ; margin:0; color: white; font-weight:bold">
                        <div class="col" align="center">
                            <label class="col-sm-12 col-xs-12 col-md-12 col-form-label"> ارشيف طلبيات النفط الخام لأخر 20 طلبية </label>
                        </div>
                    </div>';
        $content .= '
                    <form>
                        <div  style="border-bottom: 1px #eee solid; margin:2px; display:flex">
                            <div class="col-sm-3 col-xs-3 col-md-3" align="center">
                                <label class="col-form-label" style="font-weight:bold"> الجديد </label>
                            </div>
                            <div class="col-sm-3 col-xs-3 col-md-3" align="center">
                                <label class="col-form-label" style="font-weight:bold"> العدد </label>
                            </div>
                            <div class="col-sm-6 col-xs-6 col-md-6" align="center">
                                <label class="col-form-label" style="font-weight:bold"> التاريخ</label>
                            </div>
                        </div>
                    ';

        $index = 0;
        foreach ($html as $key => $value) {
            $index++;
            if ($index % 2) {
                $bg = 'background-color:#f7f7f7';
            } else {
                $bg = 'background-color:#fff';
            }
            $content .= '<div   style="border-bottom: 1px #eee solid; margin:2px ; ' . $bg . '; display:flex">';

            $found = false;
            foreach ($html2 as $key2 => $value2) {
                if ($key2 == $key) {
                    $content .= '<div class="col-sm-3 col-xs-3 col-md-3" align="center">';
                    $content .= '<label class="col-form-label">' . $value2 . '</label>';
                    $content .= '</div>';
                    $found = true;
                    break;
                }
            }
            if (!$found) {
                $content .= '<div class="col-sm-3 col-xs-3 col-md-3" align="center">';
                $content .= '<label class="col-form-label"> - </label>';
                $content .= '</div>';
            }

            $content .= '<div class="col-sm-3 col-xs-3 col-md-3" align="center">';
            $content .= '<label class="col-form-label">' . $value . '</label>';
            $content .= '</div>';
            $content .= '<div class="col-sm-6 col-xs-6 col-md-6" align="center">';
            $content .= '<label class="col-form-label">' . $key . '</label>';
            $content .= '</div>';
            $content .= '</div>';
        }

        $content .= '</form>
                                </div>
                                <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
                                    integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN"
                                    crossorigin="anonymous"></script>
                                <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"
                                    integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q"
                                    crossorigin="anonymous"></script>
                                <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"
                                    integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl"
                                    crossorigin="anonymous"></script>
                            </body>
                        </html>
            ';

        $content = str_replace("\n", "", $content);
        $content = stripslashes($content);
        return $content;
    }

    // ------------------------------------------------------------------------------------------- //
    // ---------------------- get history of orders for the last 20 days ------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getPollArchive()
    {

        // search for user polls
        $pollFilter = '{"status": "EXPIRED"}';
        $pollReuslt = $this->_pollIntegration->getUserPolls($pollFilter, 100, 0, $_SESSION['u_id']);


        // render HTML content
        $content = '
            <html>

            <head>
                <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
                <meta charset="utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
                <!-- Bootstrap CSS -->
                <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
                    integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
            </head>
            
            <body>
                <div class="form-group row col-sm-12 d-flex justify-content-center" style="background-color:rgb(151, 198, 103) ; margin:0; color: white; font-weight:bold">
                    <div class="col" align="center">
                        <label class="col-sm-12 col-xs-12 col-md-12 col-form-label"> الإستبيانات </label>
                    </div>
                </div>';


        $index = 0;
        foreach ($pollReuslt as $poll) {
            $content .= '<div class="form-group row col-sm-12 d-flex justify-content-center" style="border-bottom: 1px #eee solid; margin:2px ; ' . $bg . '">';
            $content .= '<div class="col" align="center">';
            $content .= '<label class="col-sm-7 col-xs-7 col-md-7 col-form-label">' . $poll['details']['attributes']['title'] . '</label>';
            $content .= '</div>';
            $content .= '</div>';
        }

        $content .= '</form>
                        </div>
                        <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
                            integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN"
                            crossorigin="anonymous"></script>
                        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"
                            integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q"
                            crossorigin="anonymous"></script>
                        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"
                            integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl"
                            crossorigin="anonymous"></script>

                    </body>
                </html>
                    ';

        $content = str_replace("\n", "", $content);
        $content = stripslashes($content);
        echo $content;
    }

    // ------------------------------------------------------------------------------------------- //
    // ---------------------- get late trucks ------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getLateTrucks()
    {
        $tender_id = $this->_request->tender_id;

        // search forlate trucks in tender
        try {
            $result = DBConnection::getlateTrucks($tender_id);

            $Result = [];
            $Result['data'] = $result;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------- //
    // ------------------ search user wallet database  -------------- //
    // -------------------------------------------------------------- //
    public function searchUserWallet()
    {

        $tender_id = $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'user_wallet_report');

        $phone = $this->_request->phone;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;
        $create_date_to = date_format(date_create($create_date_to), "Y-m-d 23:59:59");

        $walletResult = $this->_zain_cash->searchUserWallet($phone, $create_date_from, $create_date_to);

        parent::response($walletResult);
    }

    // -------------------------------------------------------------- //
    // --------------------- get list of waybills ------------------- //
    // -------------------------------------------------------------- //
    public function searchWaybillsForInvoice()
    {
        // parent::response( $this->_request);die;
        $tender_id =  $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'invoice_report');

        if (!$this->_request->preparefilter) {
            $waybillFilter = $this->prepareWaybillFilter($tender_id);
        } else {
            $waybillFilter = [];
            foreach (json_decode($this->_request->filter) as &$filter) {
                array_push($waybillFilter, ["key" => $filter->key, "val" => $filter->val, "op" => $filter->op]);
            }
        }

        $waybillResult = $this->_waybillCore->searchWaybills(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // cargos
        $cargos = array();

        foreach ($waybillResult->data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);
            //get cargos list
            $cargo_id = $doc->cargo[0]->cargo_id;
            if ($cargos[$cargo_id]) {
                // if cargo already added increment by one number of waybills
                $cargos[$cargo_id]->waybills_count++;
            } else {
                $cargos[$cargo_id] = new stdClass();
                $cargos[$cargo_id]->cargo_company_owner_id = $doc->cargo[0]->consigner->cargo_owner->id;
                $cargos[$cargo_id]->cargo_company_owner_name = $doc->cargo[0]->consigner->cargo_owner->name;
                $cargos[$cargo_id]->waybills_count = 1;
                $cargos[$cargo_id]->cargo_id = $cargo_id;
                $cargos[$cargo_id]->cargo_name = $doc->cargo[0]->cargo->name;
            }
        }

        //return Success response
        $result['data'] = $cargos;
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------- //
    // ------------------ get historical info on how the truck moved in queue -------------- //
    // ------------------------------------------------------------------------------------- //
    public function getTruckQueueHistory()
    {

        $tender_id = $this->_request->tender_id;
        $tn = $this->_request->tn;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        if ($tender_id == 11 || $tender_id == 13 || $tender_id == 3) {
            $q_id = 1;
        }


        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'queuehistory_report');

        // get truck id
        $truck_filter = [['key' => 'tn', 'val' => $tn], ['key' => 'status', 'val' => 'ACTIVE']];
        $truck = $this->_truckCore->searchTrucks($truck_filter, 1, 0, $_SESSION['user_id']);

        if ($truck->found_rows == 0) {
            throw new Exception('رقم الشاحنة غير صحيح أو أنها غير فعالة');
        }

        // get the queues for a truck
        $sqlQuery = "
            SELECT 
                    v.id,
                    v.trn,
                    v.rank,
                    v.serial,
                    v.driver_name,
                    CAST(q.activity AS CHAR CHARSET UTF8) AS activity,
                    q.status,
                    date(q.create_date)  as create_date
            FROM
                    queue q
                    INNER JOIN
                    queue_view  v
                    ON
                    q.id = v.id
            WHERE
                    q.truck_id = ? AND
                    q.tender_id = ?";

        $param = [$truck->data[0]->id, $tender_id];
        if ($date_from) {
            $sqlQuery .= " and q.create_date >= ?";
            $param[] = $date_from;
        }
        if ($date_to) {
            $sqlQuery .= " and q.create_date <= ?";
            $param[] = $date_to;
        }
        if ($q_id) {
            $sqlQuery .= " and q.q_id = ?";
            $param[] = $q_id;
        }
        $sqlQuery .= " ORDER BY q.id DESC;";
        $queues = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // collect all queue_ids
        $queue_ids = [];
        foreach ($queues as &$queue) {
            $queue_ids[] = $queue->id;
        }

        // get the activites for all queue
        $queueSql = "
            SELECT
                queue_id,
                u_id,
                activity_date,
                action_code,
                object_status_code,
                object_new_status_code,
                notes
            FROM
                activity
            WHERE
                queue_id in (" . implode(",", $queue_ids) . ")
                AND action_code in ('CHANGE_STATUS','ADD_NOTE')
                ORDER BY id DESC limit 1000";

        $queue_param = [];
        $activityResult = DBConnection::runBindDatabaseQuery($queueSql, $queue_param);

        // loop on all queues to sort the activities
        foreach ($queues as &$queue) {
            if (gettype($queue->activity) == "string") {
                $queue->activity = json_decode($queue->activity);
            }

            $new_activity = [];
            foreach ($activityResult as &$record) {
                if ($record->queue_id == $queue->id) {
                    switch ($record->action_code) {
                        case 'CREATE':
                            $record->activity_details = 'اضافة على الدور';
                            $record->activity_icon = "create";
                            $record->activity_title = "إنشاء دور";
                            break;

                        case 'CHANGE_STATUS':
                            if ($record->object_new_status_code == 'INACTIVE') {
                                $record->activity_details = 'حذف عن الدور';
                                $record->activity_icon = "delete";
                                $record->activity_title = "حذف دور";
                            }
                            if ($record->object_new_status_code == 'CLOSED') {
                                $record->activity_details = 'تأكيد وصول وانشاء مستند';
                                $record->activity_icon = "create";
                                $record->activity_title = "إنشاء مستند";
                            }
                            if ($record->object_new_status_code == 'APPROVED') {
                                $record->activity_details = 'قبول أمر الحركة';
                                $record->activity_icon = "check";
                                $record->activity_title = "قبول أمر الحركة";
                            }
                            if ($record->object_new_status_code == 'PENDING') {
                                $record->activity_details = 'تأجيل دور';
                                $record->activity_icon = "HELD";
                                $record->activity_title = "تأجيل دور";
                            }
                            if ($record->object_new_status_code == 'ACTIVE' && $record->object_status_code == 'PENDING') {
                                $record->activity_details = 'فك تأجيل دور';
                                $record->activity_icon = "activate_queue";
                                $record->activity_title = "فك تأجيل دور";
                            }
                            if ($record->object_new_status_code == 'ACTIVE' && $record->object_status_code == 'HELD') {
                                $record->activity_details = 'فك تجميد دور';
                                $record->activity_icon = "activate_queue";
                                $record->activity_title = "فك تجميد دور";
                            }
                            if ($record->object_new_status_code == 'CLOSED' && $record->object_status_code == 'ACTIVE') {
                                $record->activity_details = 'انشاء مستند شحن وخروج من الدور';
                                $record->activity_icon = "activate_queue";
                                $record->activity_title = "انشاء مستند";
                            }
                            if ($record->object_new_status_code == 'HELD' && $record->object_status_code == 'ACTIVE') {
                                $record->activity_details = 'تجميد دور';
                                $record->activity_icon = "held_queue";
                                $record->activity_title = " تجميد دور";
                            }
                            break;
                        case 'ADD_NOTE':
                            $record->action_code = 'اضافة ملاحظات';
                            $record->activity_icon = "add_note";
                            $record->activity_title = "اضافة ملاحظات";
                            break;
                    }
                    // add activities to queue
                    $queue->activity[] = $record;
                }
            }
        }

        parent::response($queues);
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ get historical info on how the truck moved in queue -------------- //
    // ------------------------------------------------------------------------------------- //
    public function getCheckReport()
    {

        $tender_id = $this->_request->tender_id;
        $trucking_company_id = $this->_request->trucking_company_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'check_report');
        $param = [];

        $sqlQuery = " SELECT 
                        w.wn,
                        w.create_date,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.carrier[0].truck.tn'))  as tn,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.carrier[0].trailer.tn')) trn,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.carrier[0].driver.name')) as driver_name,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.carrier[0].tc.id')) as tc_id,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.carrier[0].tc.name')) as tc_name,
                        v.create_date voucher_create_date,
                        JSON_UNQUOTE(JSON_EXTRACT(v.integration_details,'$.payment.ref_id')) check_num,
                        JSON_UNQUOTE(JSON_EXTRACT(v.trx_template,'$.amount')) amount
                    FROM
                        voucher v,
                        waybill_view w
                    WHERE
                        JSON_UNQUOTE(JSON_EXTRACT(v.trx_template, '$.ref_id')) = w.id
                        and v.status = 'COMPLETE'
                        and v.payment_method = 'CHECK' ";
        if ($create_date_from) {
            $sqlQuery .= " and w.create_date >= ? ";
            $param[] = $create_date_from;
        }
        if ($create_date_to) {
            $sqlQuery .= " and w.create_date < ? ";
            $param[] = $create_date_to;
        }
        if ($trucking_company_id) {
            $sqlQuery .= " and w.trucking_company_id = ? ";
            $param[] = $trucking_company_id;
        }

        $sqlQuery .= " order by 8 ";
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------- //
    // ------------------ get indivisual waybills report for ابناء الطفيلة -------------- //
    // ---------------------------------------------------------------------------------- //
    public function getIndivisualWaybillReport()
    {

        $tender_id = $this->_request->tender_id;
        $status = $this->_request->status;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'indivisual_waybill_report');
        $param = [];

        $sqlQuery = " SELECT
                        JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].truck.tn')) AS tn,
                        JSON_UNQUOTE(JSON_EXTRACT(w.document, '$.carrier[0].trailer.tn')) AS trn,
                        ifnull(loading_date,'-') as loading_date,
                        CASE
                            when (JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.cargo[0].weights.loading.net_weight'))) = 'null' then '-'
                            ELSE (JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.cargo[0].weights.loading.net_weight')))
                        END as loading_weight,
                        ifnull(discharge_date,'-') as discharge_date,
                        CASE
                            when (JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.cargo[0].weights.discharge.net_weight'))) = 'null' then '-'
                            ELSE (JSON_UNQUOTE(JSON_EXTRACT(w.document,'$.cargo[0].weights.discharge.net_weight')))
                        END as discharge_weight,
                        status
                    FROM
                        waybill_view w
                    WHERE
                        tender_id = ?
                            AND w.create_date > CURDATE() - interval  5 day
                            AND w.trucking_company_id = 359 ";

        $param[] = $tender_id;
        if ($create_date_from) {
            $sqlQuery .= " and w.create_date >= ? ";
            $param[] = $create_date_from;
        }
        if ($create_date_to) {
            $sqlQuery .= " and w.create_date < ? ";
            $param[] = $create_date_to;
        }
        if ($status) {
            $sqlQuery .= " and w.status = ? ";
            $param[] = $status;
        }

        $sqlQuery .= " order by tn ";
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        foreach ($data as &$row) {
            switch ($row->status) {
                case 'NEW':
                    $row->status = "جديد";
                    break;
                case 'APPROVED':
                    $row->status = "تمت الموافقة";
                    break;
                case 'ACTIVE':
                    $row->status = "فعال";
                    break;
                case 'PENDING':
                    $row->status = "قيد التجميل";
                    break;
                case 'ONROAD':
                    $row->status = "على الطريق";
                    break;
                case 'ARRIVED':
                    $row->status = "وصلت";
                    break;
                case 'CLOSED':
                    $row->status = "تم التسليم";
                    break;
                case 'COMPLETE':
                    $row->status = "مكتمل";
                    break;
                default:
                    break;
            }
        }

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }



    // ------------------------------------------------------------------------------------- //
    // ------------------ get historical info on how the truck moved in queue -------------- //
    // ------------------------------------------------------------------------------------- //
    public function searchWaybillDrafts()
    {

        $create_date_from = $this->_request->date_from;
        $create_date_to = $this->_request->date_to;
        $status = $this->_request->status;
        $limit = $this->_request->limit;
        $date_type = $this->_request->type;
        $tender_id = $this->_request->tender_id;

        if (!$create_date_from) {
            throw new Exception('create_date_from is required');
        }


        //validate role code if it has the ownership to view this report
        $param = [];

        $sqlQuery = " SELECT
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        status,
                        create_date,
                        update_by
                    FROM
                    waybill_draft
                    WHERE 
                    tender_id = ? and ";
        $param[] = $tender_id;

        switch ($date_type) {
            case 'create_date':
                $sqlQuery .= " create_date >= ? ";
                break;
            case 'loading_date':
                $sqlQuery .= " JSON_UNQUOTE(JSON_EXTRACT(document, '$.cargo[0].weights.loading.time_stamp')) >= ? ";
                break;
            case 'discharge_date':
                $sqlQuery .= " JSON_UNQUOTE(JSON_EXTRACT(document, '$.cargo[0].weights.discharge.time_stamp')) >= ? ";
                break;
        }
        $param[] = $create_date_from;

        if ($status) {
            $status = explode(',', $status);
            $sqlQuery .= " and status in('" . implode("','", $status) . "')";
        }

        $sqlQuery .= " and status not in('REJECTED')";

        if ($create_date_to) {

            $parsed_date_arr = date_parse($create_date_to);
            $filtered_date_arr = array_filter($parsed_date_arr);
            if (!array_key_exists('hour', $filtered_date_arr))
                $create_date_to = $create_date_to . ' 23:59:59';


            switch ($date_type) {
                case 'create_date':
                    $sqlQuery .= " and create_date < ? ";
                    break;
                case 'loading_date':
                    $sqlQuery .= " and JSON_UNQUOTE(JSON_EXTRACT(document, '$.cargo[0].weights.loading.time_stamp')) < ? ";
                    break;
                case 'discharge_date':
                    $sqlQuery .= " and JSON_UNQUOTE(JSON_EXTRACT(document, '$.cargo[0].weights.discharge.time_stamp')) < ? ";
                    break;
            }
            $param[] = $create_date_to;
        }


        if ($limit) {
            $sqlQuery .= " limit $limit ";
        }

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $currentTime = DBConnection::getSystemDate();
        $waybill_id = [];
        foreach ($data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);
            $waybill_data->bond_number = $waybill_data->bond_number;
            $waybill_data->server_date = $currentTime;
            $waybill_data->trn = $waybill_data->trn;
            $waybill_data->driver_name = $waybill_data->driver_name;
            $waybill_data->driver_nn = $waybill_data->driver_nn;
            $waybill_data->driver_phone = $waybill_data->driver_phone;
            $waybill_data->cargo = $doc->cargo[0]->name;
            $waybill_data->destination_name = $doc->negotiable_instructios->route->destination->name;
            $waybill_data->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $waybill_data->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $waybill_data->origin = $doc->negotiable_instructios->route->origin->name;
            $waybill_data->loading_date = $doc->cargo[0]->weights->loading->time_stamp;
            $waybill_data->discharge_date = $doc->cargo[0]->weights->discharge->time_stamp;
            $waybill_data->net_amount = $doc->freight->amount->net_amount;
            $waybill_data->container = $doc->cargo[0]->container;
            $waybill_data->secContainerNumber = $doc->cargo[0]->secContainerNumber;
            $waybill_data->clearing_agent = $doc->cargo[0]->clearing_agent;
            $waybill_data->operation_type = $doc->operation_type->code;
            $waybill_data->cargo_type = $doc->cargo[0]->cargo_type;
            $waybill_id[] = $waybill_data->id;
            unset($waybill_data->document);
        }


        // 18 : Injaz , inject voucher_ids
        if ($tender_id == 18 && $waybill_id && sizeof($waybill_id) > 0) {
            $query = "select id , trx_template->>'$.waybill_draft_ref_id' draft_id
                      from voucher_view where trx_template->>'$.waybill_draft_ref_id' in (" . implode(",", $waybill_id) . ")";
            $param = [];
            $vouchers = DBConnection::runBindDatabaseQuery($query, $param);
            foreach ($data as &$waybill_data) {
                foreach ($vouchers as $v) {
                    if ($waybill_data->id == $v->draft_id) {
                        $waybill_data->voucher_id = $v->id;
                    }
                }
            }
        }


        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ get historical info on how the truck moved in queue -------------- //
    // ------------------------------------------------------------------------------------- //
    public function searchWaybillDraftsVouchers()
    {

        $account_id = $this->_request->account_id;
        $create_date = $this->_request->create_date;
        if (!$account_id) {
            throw new Exception('account_id is required');
        }

        if (!$create_date) {
            throw new Exception('create_date is required');
        }

        try {

            // if the id in the format X,X , then replace , with -
            if (strpos($account_id, ',') == true) {
                $account_id = str_replace(",", "-", $account_id);
            }

            //format date
            $date = new DateTime($create_date);
            $start_date = $date->format('Y-m-d H:i:s');
            $end_date = $date->modify('+1 day')->format('Y-m-d H:i:s');

            //get account
            $accountBean = $this->_accountCore->getAccountBasic($account_id, $_SESSION['user_id']);
            $searchStatFilter = [
                ['key' => 'id', 'val' => $accountBean->id],
                ['key' => 'sub_id', 'val' => $accountBean->sub_id],
                ['key' => 'trx_date', 'val' => $start_date, 'op' => 'date greater than'],
                ['key' => 'trx_date', 'val' => $end_date, 'op' => 'date less than']
            ];

            // search DB
            $trx_query = $this->_accountCore->getAccountStatement($searchStatFilter, 10000, $_SESSION['user_id']);

            $starting_balance = 0;
            // inject the starting balance into account bean
            if ($trx_query->found_rows > 0) {
                $starting_balance = $trx_query->data[0]->past_balance;
            }

            $searchFilter = [
                ['key' => "create_date", 'val' => $start_date, 'op' => 'date greater than'],
                ['key' => "create_date", 'val' => $end_date, 'op' => 'date less than'],
                ['key' => 'trx_template', 'val' => '"' . $account_id . '"', 'op' => 'json unquote', 'node' => '$.from_account']
            ];

            //query
            $query = $this->_voucherCore->searchVouchers($searchFilter, 10000, 0, $_SESSION['user_id']);
            $total = 0;
            $waybill_draft_ids = [];
            if (sizeof($query->data) > 0) {
                foreach ($query->data as &$voucher) {
                    $total += $voucher->amount;

                    $trx_template = json_decode($voucher->trx_template);
                    $waybill_draft_ids[] = $trx_template->waybill_draft_ref_id;
                    unset($voucher->trx_template);
                    $voucher->waybill_draft_ref_id = $trx_template->waybill_draft_ref_id;
                }
            }

            $waybilldraftQry = "SELECT
                                id,
                                bond_number,
                                tn,
                                trn,
                                driver_phone,
                                driver_nn,
                                driver_name,
                                CAST(`document` AS CHAR CHARSET UTF8) AS document,
                                status,
                                create_date,
                                update_by
                            FROM
                            waybill_draft
                            WHERE id in (" . join($waybill_draft_ids, ",") . ")";
            $waybillDraft = DBConnection::runBindDatabaseQuery($waybilldraftQry, []);
            // inject extra info
            foreach ($query->data as $row) {
                foreach ($waybillDraft as $draft) {
                    if ($draft->id == $row->waybill_draft_ref_id) {
                        $row->tn = $draft->tn;
                        $row->bond_number = $draft->bond_number;
                        $doc = json_decode($draft->document);
                        $row->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                    }
                }
                if (!$row->tn) $row->tn = '-';
                if (!$row->bond_number) $row->bond_number = '-';
                if (!$row->loading_weight) $row->loading_weight = '-';
            }

            $Result = [];
            $Result['data'] = $query->data;
            $Result['total_amount'] =  $total;
            $Result['found_rows'] = sizeof($query->data);
            $Result['starting_balance'] = $starting_balance;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ---------------------------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of late truck, these trucks have loading weight and no discharge weight ---------------- //
    // ------------------ and late for certain period of time --------------------------------------------------------------- //
    // ------------------ param: tender_id, late_hours , destination_id---------------------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------- //
    public function searchTenderTruckReport()
    {

        // search for ONROAD waybills
        $tender_id = $this->_request->tender_id;
        $status = $this->_request->status;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $limit = $this->_request->limit;

        if (!$status) {
            throw new Exception('status is required');
        }

        if (!$tender_id) {
            throw new Exception('tender_id is required');
        }


        // $this->hasAuthToViewReport($tender_id,'jo_petrol_policy_number_report');

        $sqlQuery = "select t.id,t.tender_id,t.q_id,t.status,a.activity_date,a.object_new_status_code,a.notes,c.tn
                    from tender_truck t,activity a, truck c
                    where t.id = a.tender_truck_id
                    and t.truck_id = c.id
                    and
                    t.status = ?
                    and
                    t.status = a.object_new_status_code
                    and t.tender_id = ?";

        $param = [$status, $tender_id];

        if ($date_from) {
            $sqlQuery .= " and t.update_date >= ?";
            $param[] = $date_from;
        }

        if ($date_to) {
            $sqlQuery .= " and t.update_date < ?";
            $param[] = $date_to;
        }

        if ($limit) {
            $sqlQuery .= " limit ? ;";
            $param[] = $limit;
        }


        $tenderTruckResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        parent::response($tenderTruckResult);
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------ get a list of tender claims Summary for certain tender ---------------- //    
    // ------------------------------------------------------------------------------------------ //
    public function searchTenderClaimsSummary()
    {

        // input params
        $tender_id = $this->_request->tender_id;
        $filter = $this->_request->filter;
        if ($filter) {
            $filter = json_decode($filter);
        }

        $sqlQuery = "SELECT 
                        t1.claim_details->>'$.company_name' company_name,
                        t1.claim_details->>'$.ref' ref_number,
                        t1.activation_date,
                    COUNT(t3.id) cnt,
                        max(t3.details->>'$.cargo_name') cargo_name,
                        SUM(t3.details->>'$.claim_loading_weight') total_loading_weight,
                        round((SUM(t3.details->>'$.claim_loading_weight') / 1000) * 0.035,3) as fees
                FROM
                    tender_claim_view t1,
                    tender_company t2,
                        tender_claim_item t3
                WHERE
                        t1.status != 'INACTIVE' AND t2.tender_id = ?
                        AND t1.tender_company_id = t2.id
                        AND t3.tender_claim_id = t1.id
                            AND t3.status != 'INACTIVE' ";
        $param[] = $tender_id;

        // inject the filters
        if ($filter->date_type && $filter->date_type == "active_claim") {
            $sqlQuery .= "AND t1.activation_date >= ? ";
            $sqlQuery .= "AND t1.activation_date < ? ";
            $param[] = $filter->from_date;
            $param[] = $filter->to_date;
        }
        if ($filter->date_type && $filter->date_type == "create_claim") {
            $sqlQuery .= "AND t1.create_date >= ? ";
            $sqlQuery .= "AND t1.create_date < ? ";
            $param[] = $filter->from_date;
            $param[] = $filter->to_date;
        }
        if ($filter->tender_company && $filter->tender_company != "") {
            $sqlQuery .= "AND t1.tender_company_id = ? ";
            $param[] = $filter->tender_company;
        }

        $sqlQuery .= " GROUP BY company_name,ref_number,activation_date
                order by company_name , ref_number";

        $tenderClaimSummary = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        foreach ($tenderClaimSummary as &$data) {
            $data->fees = number_format((float)$data->fees, 3, '.', '');
        }
        $result = [];
        $result['data'] = $tenderClaimSummary;
        $result['found_rows'] = sizeof($tenderClaimSummary);

        parent::response($result);
    }



    // ------------------------------------------------------------------------------------------ //
    // ------------------ cargos-Destination Changes Report ------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function cargosDestinationChangesReport()
    {

        // input params
        $tender_id = $this->_request->tender_id;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        if (!$date_from) {
            throw new Exception('date from is required');
        }

        if (!$date_to) {
            throw new Exception('date to is required');
        }


        $sql_destination_query = "
        select
        json_length(json_search(document,'all','change_route',NULL,'$.activities[*].activity_icon')) destination_changes_count,
        json_length(json_search(document,'all','CHANGE_CARGO',NULL,'$.activities[*].activity_icon')) cargo_changes_count,
        json_unquote(json_extract(document,'$.activities')) activities,id waybill_id
        from waybill_view w
        where
        update_date between $date_from and $date_to
        and json_length(json_search(document,'all','change_route',NULL,'$.activities[*].activity_icon'))>=1 or
            json_length(json_search(document,'all','CHANGE_CARGO',NULL,'$.activities[*].activity_icon'))>=1
        and tender_id = $tender_id
        ";

        $result_destination_qry = DBConnection::runBindDatabaseQuery($sql_destination_query, []);

        if (sizeof($result_destination_qry) > 0) {
            foreach ($result_destination_qry as &$waybill) {
                $waybill->activities = json_decode($waybill->activities);
            }
        }

        $Result['data'] = $result_destination_qry;
        $Result['found_rows'] = sizeof($result_destination_qry);
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------ get a list of tender claims Summary for certain tender ---------------- //    
    // ------------------------------------------------------------------------------------------ //
    public function searchOrderStatics_1()
    {

        // input params
        $order_id = $this->_request->order_id;

        $sqlQuery = "SELECT                          
                        COUNT(id) cnt,
                        CASE
                            WHEN queue_id IS NULL THEN 'company'
                            WHEN queue_id IS NOT NULL THEN 'indivsual'
                        END AS type
                    FROM
                        waybill_order_view
                    WHERE
                        tender_order_id IN (?)
                        AND status NOT IN ('REVOKED')
                    GROUP BY type ";

        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$order_id]);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------ get a list of tender claims Summary for certain tender ---------------- //    
    // ------------------------------------------------------------------------------------------ //
    public function searchOrderStatics_2()
    {

        // input params
        $order_id = $this->_request->order_id;

        $sqlQuery = "SELECT 
                        COUNT(w.id), t.minor_tt
                    FROM
                        waybill_order_view w,
                        truck t
                    WHERE
                        w.tender_order_id IN (?)
                            AND w.trn = t.tn
                            AND t.status = 'ACTIVE'
                            AND w.status NOT IN ('REVOKED')
                    GROUP BY t.minor_tt";

        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$order_id]);
        parent::response($result);
    }


    // ----------------------------------------------------------------------------- //
    // ------------------ get certain zain_cash transaction details ---------------- //
    // ----------------------------------------------------------------------------- //
    public function getZainCashTransaction()
    {
        $trx_id = $this->_request->trx_id;
        $tender_id = $this->_request->tender_id;

        $man =  $this->_tenderCore->getTenderManifest($tender_id, 0);
        $wallet_id = $man['freight']['payment_method']['wallet_id'];

        $transactions = $this->_zain_cash->getTransactions($wallet_id, null, null, null, $trx_id, "getZainCashTransaction report", $_SESSION['u_id']);

        parent::response($transactions);
    }


    // ----------------------------------------------------------------------------------- //
    // ------------------ get a list of waybill orders according to rank  ---------------- //    
    // ----------------------------------------------------------------------------------- //
    public function searchApprovedWaybillOrderByRank()
    {

        // get user search params
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        $sqlQuery = "select w.id, w.tn ,  q.rank as t1_rank , w.trn ,  w.driver_name ,  w.driver_nn ,  w.driver_phone  , '' as rank, l.name destination
                    FROM
                        tender_order t , location l,
                        waybill_order_view w
                        left join queue_view q on ( q.tn = w.tn and q.tender_id = 11 and q.rank is not null and q.q_id != 2)
                    WHERE
                        w.tender_id = ?
                        and t.id = w.tender_order_id
                        and w.status in ('APPROVED')
                        and w.create_date >= ?
                        and w.create_date < ?
                        and t.questionnaire->>'$[0].val' = l.id
                        order by id";

        $param = [$tender_id, $create_date_from, $create_date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // inject seq
        $seq = 1;
        foreach ($data as &$row) {
            $row->rank = $seq;
            $seq++;
        }

        // format data
        $result = new stdClass();
        $result->param = $param;
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }


    // ---------------------------------------------------------------------- //
    // ----------------- Close Cash Box Report تقرير اغلاق الصندوق ----------- //
    // ---------------------------------------------------------------------- //
    public function closeCashBoxReport()
    {

        $account_id = $this->_request->account_id;
        $create_date = $this->_request->create_date;
        $from_date = $this->_request->from_date;
        $to_date = $this->_request->to_date;

        if (!$account_id) {
            throw new Exception('account_id is required');
        }
        if (!$create_date && !$from_date && !$to_date) {
            throw new Exception('date is required');
        }

        try {
            // if the id in the format X,X , then replace , with -
            if (strpos($account_id, ',') == true) {
                $account_id = str_replace(",", "-", $account_id);
            }

            if ($create_date) {
                //format date
                $date = new DateTime($create_date);
                $start_date = $date->format('Y-m-d H:i:s');
                $end_date = $date->modify('+1 day')->format('Y-m-d H:i:s');
            } else {
                $start_date = $from_date;
                $end_date = $to_date;
            }

            //get account
            $accountBean = $this->_accountCore->getAccountBasic($account_id, $_SESSION['user_id']);
            $searchStatFilter = [
                ['key' => 'id', 'val' => $accountBean->id],
                ['key' => 'sub_id', 'val' => $accountBean->sub_id],
                ['key' => 'trx_date', 'val' => $start_date, 'op' => 'date greater than'],
                ['key' => 'trx_date', 'val' => $end_date, 'op' => 'date less than']
            ];

            // search DB
            $trx_query = $this->_accountCore->getAccountStatement($searchStatFilter, 10000, $_SESSION['user_id']);


            $starting_balance = 0;
            $closing_balance = 0;
            // get the starting , closing balance
            if ($trx_query->found_rows > 0) {
                $starting_balance = $trx_query->data[0]->past_balance;
                $closing_balance = $trx_query->data[$trx_query->found_rows - 1]->current_balance;
                foreach ($trx_query->data as $trx) {
                    if ($trx->op == 'D') {
                        $trx->debit = $trx->amount;
                        $trx->credit = '-';
                    } elseif ($trx->op == 'C') {
                        $trx->debit = '-';
                        $trx->credit = $trx->amount;
                    }
                }
            }

            $Result = [];
            $Result['account_bean'] = $accountBean;
            $Result['trx'] =  $trx_query->data;
            $Result['starting_balance'] = $starting_balance;
            $Result['closing_balance'] = $closing_balance;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------- //
    // ----------------- from FPS Close Cash Box Report تقرير اغلاق الصندوق ----------- //
    // ------------------------------------------------------------------------------- //
    public function closeFpsCashBoxReport()
    {

        $account_id = $this->_request->account_id;
        $create_date = $this->_request->create_date;

        if (!$account_id) {
            throw new Exception('account_id is required');
        }
        if (!$create_date) {
            throw new Exception('date is required');
        }

        try {
            // if the id in the format X,X , then replace , with -
            if (strpos($account_id, ',') == true) {
                $account_id = str_replace(",", "-", $account_id);
            }

            //format date
            if ($create_date) {
                $date = new DateTime($create_date);
                $start_date = $date->format('Y-m-d H:i:s');
                $end_date = $date->modify('+1 day')->format('Y-m-d H:i:s');
            }

            //get account
            $accountBean = $this->_fps->getAccountBasic($account_id, $_SESSION['user_id']);

            // search FPS DB
            $searchData = new stdClass();
            $searchData->account_id = $accountBean['id'];
            $searchData->account_sub_id = $accountBean['sub_id'];
            $searchData->from_date = $start_date;
            $searchData->to_date = $end_date;
            $trx_query = $this->_fps->getAccountStatement($searchData, 10000, $_SESSION['user_id']);

            $starting_balance = 0;
            $closing_balance = 0;
            // get the starting , closing balance
            if ($trx_query['found_rows'] > 0) {
                $starting_balance = $trx_query['data'][0]->past_balance;
                $closing_balance = $trx_query['data'][$trx_query['found_rows-1']]['current_balance'];

                foreach ($trx_query['data'] as &$trx) {

                    if ($trx['op'] == 'D') {
                        $trx['debit'] = $trx['amount'];
                        $trx['credit'] = '-';
                    } elseif ($trx['op'] == 'C') {
                        $trx['debit'] = '-';
                        $trx['credit'] = $trx['amount'];
                    }
                }
            }

            $Result = [];
            $Result['account_bean'] = $accountBean;
            $Result['trx'] =  $trx_query['data'];
            $Result['starting_balance'] = $starting_balance ? $starting_balance : 0;
            $Result['closing_balance'] = $closing_balance ? $closing_balance : 0;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // ----------------- Send SMS to all drivers of approved waybill_orders ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function informApprovedWaybillOrder()
    {

        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $can_continue = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'MG_CENTRAL_OPERATION') {
                $can_continue = true;
            }
        }
        if (!$can_continue) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        // get user search params
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_from . " 23:59:59";
        $msg = $this->_request->msg;

        $sqlQuery = "select w.id, w.tn ,w.driver_phone
                    FROM
                        waybill_order_view w , tender_order t 
                    WHERE
                        w.tender_id = ?
                        and t.id = w.tender_order_id
                        and w.status in ('APPROVED')
                        and w.create_date >= ?
                        and w.create_date < ?
                        order by id";
        $param = [$tender_id, $create_date_from, $create_date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $rank = 1;
        foreach ($data as $info) {
            $message = $info->tn . "-" . $msg . ":" . $rank;
            $messageRecipient = convertToInternational($info->driver_phone);
            $result = sendSMS($messageRecipient, $message);
            $rank++;
        }

        $message = "تم ارسال رسالة نصية لدور الفيول - العدد الكلي: " . sizeOf($data);
        $result = sendSMS("0791233492", $message);
        $result = sendSMS("0797900197", $message);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
        parent::response($Result, 200);
    }


    // ------------------------------------------------------ //
    // -----------------Jo Petrol Dashboard No.1  ----------- //
    // ------------------------------------------------------ //
    public function getJoPetrolDashboard_1()
    {

        // get user input
        $tender_id = $this->_request->tender_id;
        //$this->hasAuthToViewReport($tender_id,'Jo_petrol_dashboard_1');

        // get the latest cached result
        $sqlQuery = "SELECT
                        CAST(`details` AS CHAR CHARSET UTF8) AS details,
                        create_date
                    FROM
                        waybill.jo_petrol_dashboard_1
                    ORDER BY id DESC
                    LIMIT 1 ";
        $param = [];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        $final_resut = json_decode($result[0]->details);

        $finalResult = [];
        $finalResult['details'] = $final_resut;
        $finalResult['create_date'] = $result[0]->create_date;
        parent::response($finalResult, 200);
    }

    // ------------------------------------------------------ //
    // -----------------Jo Petrol Dashboard No.1  ----------- //
    // ------------------------------------------------------ //
    public function searchVouchersPhosphateReport()
    {
        try {
            $start_date = $this->_request->start_date;
            $end_date = $this->_request->end_date;
            $tender_id = $this->_request->tender_id;
            $search_type = $this->_request->search_type;

            // validate user input
            if (!$search_type) {
                throw new Exception('type of report is required');
            }
            if (!$start_date) {
                throw new Exception('start_date is required');
            }
            if (!$end_date) {
                throw new Exception('end_date is required');
            }

            $account_ids = $this->_accountCore->getAccountAuthority($_SESSION);
            if ($account_ids) {
                $filter = [['key' => 'sub_id', 'val' => $account_ids, 'op' => 'in']];
            } else {
                $filter = null;
            }
            //get accounts the user has auth on
            $accounts = $this->_accountCore->searchAccount($filter, 1000, 0, $_SESSION['user_id']);
            if (sizeof($accounts->data) > 0) {
                $company_accounts = $this->_accountCore->searchAccount([['key' => 'id', 'val' => $accounts->data[0]->id]], 1000, 0, $_SESSION['user_id']);
            }
            $formated_accounts = [];
            $account_types = array();
            foreach ($accounts->data as $acc) {
                $formated_accounts[] = $acc->id . "-" . $acc->sub_id;
            }
            foreach ($company_accounts->data as $acc) {
                $account_types[$acc->sub_id] = $acc->tree_type;
            }
            // select the required vouchers
            $result = array();
            $searchFilter = [
                ['key' => "payment_date", 'val' => $start_date, 'op' => 'date greater than'],
                ['key' => "payment_date", 'val' => $end_date, 'op' => 'date less than'],
                ['key' => 'trx_template', 'val' => '"WAYBILL_COMPLETE"', 'op' => 'json unquote', 'node' => '$.voucher_type'],
                ['key' => 'trx_template', 'val' => $tender_id, 'op' => 'json unquote', 'node' => '$.tender_id'],
                ['key' => 'trx_template', 'val' => $formated_accounts, 'op' => 'json in', 'node' => '$.from_account'],
                ['key' => 'status', 'val' => 'COMPLETE']
            ];

            $query = $this->_voucherCore->searchVouchers($searchFilter, 10000, 0, $_SESSION['user_id'], " order by payment_date asc ");

            $waybill_draft_ids = [];
            if (sizeof($query->data) > 0) {
                $paymentCore = new PaymentCore();
                foreach ($query->data as $voucher) {
                    $trx_query = $paymentCore->getJvTrx($voucher->jv_id);
                    if (sizeof($trx_query) > 0) {
                        $trx_template = json_decode($voucher->trx_template);
                        $waybill_id = $trx_template->waybill_draft_ref_id;
                        $waybill_draft_ids[] = $waybill_id;
                        $result[$waybill_id] = new stdClass();
                        $result[$waybill_id]->voucher_id = $voucher->id;
                        $result[$waybill_id]->payment_date = $voucher->payment_date;
                        $result[$waybill_id]->box_number = $trx_template->from_account;
                        $result[$waybill_id]->box_name = $trx_template->from_account_name;
                        $result[$waybill_id]->amount = 0;
                        $result[$waybill_id]->advanced_payment = 0;

                        if ($search_type == 'claims') {
                            foreach ($trx_query as $trx) {
                                if ($account_types[$trx->sub_id] == "R") {
                                    $result[$waybill_id]->amount = $trx->amount;
                                }
                            }
                        } else if ($search_type == 'expenses') {
                            foreach ($trx_query as $trx) {
                                if ($account_types[$trx->sub_id] == "EX") {
                                    $result[$waybill_id]->amount = $trx->amount;
                                }
                            }
                        }
                    }
                }
                $ids = join(',', $waybill_draft_ids);
                $draftsQuery = "
                    select id,tn,trn,bond_number,driver_name,driver_nn,driver_phone,
                    CAST(`document` AS CHAR CHARSET UTF8) AS document

                from waybill_draft
                where id in ($ids);
                ";
                $drafts = DBConnection::runBindDatabaseQuery($draftsQuery, []);
                if (sizeof($drafts) > 0) {
                    foreach ($drafts as $draft) {
                        $id = $draft->id;
                        $result[$id]->waybill = $draft;
                    }
                }
            }


            $temp = [];
            foreach ($result as $key => $value) {
                $temp[] = $value;
            }
            $Result['found_rows'] = sizeof($temp);
            $Result['data'] = $temp;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------ //
    // -----------------Jo Petrol Dashboard No.2  ----------- //
    // ------------------------------------------------------ //
    public function getJoPetrolDashboard_2()
    {
        try {
            $tender_id = $this->_request->tender_id;

            //validate role code if it has the ownership to view this report
            //$this->hasAuthToViewReport($tender_id,'late_trucks_for_loading_report');

            $sqlQuery = "select d as date, count(*) trucks, sum(f) trips from(
                select date_format(loading_date,\"%M %Y\") d,date_format(loading_date,\"%Y%m\") d2, truck_id, count(*) f
                from waybill
                where tender_id=? and status not in('inactive','revoked')
                group by date_format(loading_date,\"%M %Y\") ,date_format(loading_date,\"%Y%m\"), truck_id) t
                group by d,d2
                order by d2";

            $param = [$tender_id];
            $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $result = [];
            $result[] = ['التاريخ', 'الشاحنات', 'الرحلات'];
            foreach ($data as $row) {
                if (!$row->date) continue;

                $temp = [];
                $temp[] = $row->date;
                $temp[] = intval($row->trucks);
                $temp[] = intval($row->trips);
                $result[] = $temp;
            }

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------ //
    // -----------------Jo Petrol Dashboard No.3  ----------- //
    // ------------------------------------------------------ //
    public function getJoPetrolDashboard_3()
    {
        try {
            $tender_id = $this->_request->tender_id;

            //validate role code if it has the ownership to view this report
            //$this->hasAuthToViewReport($tender_id,'late_trucks_for_loading_report');

            $sqlQuery = "select date_format(loading_date,\"%M %Y\") d, (CASE
                            WHEN w.truck_owner_id =410080 THEN \"indivisual\"
                            WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN \"company\"
                            ELSE \"indivisual\"
                        END) owner,date_format(loading_date,\"%M %Y\") d, count(distinct truck_id) trucks, count(*) trips
                        from waybill w
                        where w.tender_id=11 and w.status not in('inactive','revoked') #and w.truck_owner_id=410080
                        group by (CASE
                            WHEN w.truck_owner_id =410080 THEN \"indivisual\"
                            WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN \"company\"
                            ELSE \"indivisual\"
                        END),date_format(loading_date,\"%M %Y\"),date_format(loading_date,\"%Y%m\")
                        order by date_format(loading_date,\"%Y%m\"),owner";

            $param = [];
            $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $result = [];
            $result[] = ['التاريخ', 'الشركات', 'الأفراد'];

            $temp = new stdClass();
            foreach ($data as $row) {
                if (!$row->d) continue;

                if (!$temp->date) {
                    $temp->date = $row->d;
                }
                if ($row->owner == "company") {
                    $temp->company = $row->trips;
                }
                if ($row->owner == "indivisual") {
                    $temp->indivisual = $row->trips;
                }

                if ($temp->company && $temp->indivisual) {
                    $tempArr = [];
                    $tempArr[] = $temp->date;
                    $tempArr[] = intval($temp->company);
                    $tempArr[] = intval($temp->indivisual);

                    $result[] = $tempArr;
                    $temp = new stdClass();
                }
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------ //
    // -------- get AR Claims Report 1 , by date ------ //
    // ------------------------------------------------ //
    public function getAR_claim_report()
    {

        try {
            $tender_id = $this->_request->tender_id;
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;
            $pa_id = $this->_request->pa_id;

            $sqlQuery = "select 	
                            tender_claim_id as id,
                            pa_name,
                            COUNT(id) cnt,
                            ifnull(round(SUM(requested_net_amount),3),0) net_amount,
                            ifnull(round(SUM(approved_net_amount),3),0) approved_net_amount,
                            ifnull(round(SUM(approved_fines),3),0) total_fines
                        FROM
                            tender_claim_item_01_report
                        WHERE
                            tender_company_id = 197
                            and create_date >= ?
                            and create_date < ? ";
            $param = [$date_from, $date_to];

            if ($pa_id) {
                $sqlQuery .= " and pa_id = ? ";
                $param[] = $pa_id;
            }
            $sqlQuery .= "group by  tender_claim_id , pa_name";
            $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $result = [];
            $result['data'] = $data;
            $result['found_rows'] = sizeof($data);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------- Search grains waybill from ltrc and nafith and MG system------ //
    // ------------------------------------------------------------------------ //
    public function searchGrainsWaybillInfo()
    {

        try {
            $tender_id = $this->_request->tender_id;
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;

            //validate role code if it has the ownership to view this report
            $this->hasAuthToViewReport($tender_id, 'gltrc_waybill_report');

            // prepare dates
            if (!$date_from) {
                throw new Exception("date_from is required");
            }
            if (!$date_to || $date_to == "") {
                $date_to = date("Y-m-d");
            }
            $parsed_date_arr = date_parse($date_to);
            $filtered_date_arr = array_filter($parsed_date_arr);
            if (!array_key_exists('hour', $filtered_date_arr)) {
                $date_to = $date_to . ' 23:59:59';
            }

            // nafith data
            $registrationCore = new RegistrationCore();
            $nafithGrainsPermit = $registrationCore->searchNafithGrainPermitReport($date_from, $date_to);

            // MG data
            $starttime = microtime(true);
            $nafith_wns = [];
            foreach ($nafithGrainsPermit as $nafith_permit) {
                $nafith_wns[] = $nafith_permit->PN;
            }
            $waybillFilter = [];
            $waybillFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
            $waybillFilter[] = ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'];
            // $waybillFilter[] = ['key' => 'create_date', 'val' => $date_from, 'op' => 'date greater than'];
            // $waybillFilter[] = ['key' => 'create_date', 'val' => $date_to, 'op' => 'date less thsn'];
            $waybillFilter[] = ['key' => 'document', 'val' => $nafith_wns, 'op' => 'json in', 'node' => '$.nafith_wn'];
            $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id'], " order by id ");
            $endtime = microtime(true);
            $timediff = $endtime - $starttime;

            // merge the 2 set
            $data = [];
            foreach ($nafithGrainsPermit as $nafith_permit) {
                $temp = [];
                // Nafith
                $temp['nafith_wn'] = $nafith_permit->PN;
                $temp['nafith_tn'] = $nafith_permit->TN;
                $temp['nafith_trn'] = $nafith_permit->TRN;
                $temp['nafith_driver_name'] = $nafith_permit->NAME;
                $temp['nafith_driver_nn'] = $nafith_permit->NNPN;
                $temp['nafith_create_date'] = $nafith_permit->create_date;

                // Minagate
                $temp['MG_wn'] = "";
                $temp['MG_tn'] = "";
                $temp['MG_trn'] = "";
                $temp['MG_driver_name'] = "";
                $temp['MG_driver_nn'] = "";
                $temp['MG_cargo_name'] = "";
                $temp['MG_service'] = "";
                $temp['MG_create_date'] = "";

                foreach ($waybillResult->data as $minagate_waybill) {
                    $doc = json_decode($minagate_waybill->document);
                    if ($doc->nafith_wn == $nafith_permit->PN) {
                        $temp['MG_wn'] = $minagate_waybill->wn;
                        $temp['MG_tn'] = $doc->carrier[0]->truck->tn;
                        $temp['MG_trn'] = $doc->carrier[0]->trailer->tn;
                        $temp['MG_driver_name'] = $doc->carrier[0]->driver->name;
                        $temp['MG_driver_nn'] = $doc->carrier[0]->driver->nn;
                        $temp['MG_cargo_name'] = $doc->cargo[0]->cargo->name;
                        $temp['MG_service'] = $doc->service_list[0]->service_name;
                        $temp['MG_create_date'] = $minagate_waybill->create_date;
                        break;
                    }
                }
                $data[] = $temp;
            }

            $result = [];
            $result['data'] = $data;
            $result['found_rows'] = sizeof($data);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------ //
    // -------- extract trip data for excel export ------ //
    // ------------------------------------------------ //
    public function extractTruckTripData()
    {
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $tender_id = $this->_request->tender_id;
        $tn = $this->_request->tn;

        if (!$tn | !$date_from)
            throw new Exception('رقم الشاحنة والتاريج غير موجود');

        $this->hasAuthToViewReport($tender_id, 'trips_history_report');

        try {
            $query = "select
                wn,
                document->>'$.negotiable_instructios.route.destination.name' as destination,
                document->>'$.carrier[0].driver.name' as driver_name,
                document->>'$.carrier[0].driver.nn' as nn,  
                document->>'$.tender.name' as tender,  
                document->>'$.carrier[0].truck.tn' as tn,  
                document->>'$.carrier[0].trailer.tn' as trn,
                document->>'$.carrier[0].tc.name' as company,

                document->>'$.freight.amount.net_amount' as net_amount,
                document->>'$.freight.amount.total_advance_payment' as total_advance_payment,
                a.name as waybill_beneficiary_name,

                document->>'$.cargo[0].cargo.name' as cargo,
                            CASE WHEN document->>'$.cargo[0].weights.loading.net_weight' ='null' THEN null
                                ELSE document->>'$.cargo[0].weights.loading.net_weight'
                            END as loading_weight,
                            CASE WHEN document->>'$.cargo[0].weights.loading.time_stamp' ='null' THEN null
                                ELSE document->>'$.cargo[0].weights.loading.time_stamp'
                            END as loading_time_stamp,
                            CASE WHEN document->>'$.cargo[0].weights.discharge.net_weight' ='null' THEN null
                                ELSE document->>'$.cargo[0].weights.discharge.net_weight'
                            END as discharge_weight,
                            CASE WHEN document->>'$.cargo[0].weights.discharge.time_stamp' ='null' THEN null
                                ELSE document->>'$.cargo[0].weights.discharge.time_stamp'
                            END as discharge_time_stamp,
                document->>'$.activities[0].activity_date' as creation_date
                from waybill w left join tender_truck t on
                (w.truck_id = t.truck_id and w.tender_id = t.tender_id and t.status != 'INACTIVE')
                left join account_view a on (t.financial_details->>'$.waybill_beneficiary_account' = a.id)

                where document->>'$.carrier[0].truck.tn' = ?
                and w.create_date >= ?";
            $param = [$tn, $date_from];

            if ($date_to) {
                $query .= "and w.create_date < ?";
                $param[] = $date_to;
            }

            if ($tender_id) {
                $query .= "and w.tender_id = ?";
                $param[] = $tender_id;
            }

            $query .= "and w.status not in ('INACTIVE','REVOKED') order by creation_date desc;";
            $result = DBConnection::runBindDatabaseQuery($query, $param);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------ //
    // -------- get AR Claims Report 1 , by date ------ //
    // ------------------------------------------------ //
    public function getApprovedItemsReport()
    {
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $sqlQuery = "SELECT
                        tender_claim_id,
                        pa_id,
                        pa_name,
                        approved_date,
                        approved_net_amount
                    FROM
                        tender_claim_item_01_report
                    WHERE
                    create_date >= ?
                    and create_date < ?
                     AND tender_company_id = 197
                    ";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$date_from, $date_to]);
        $temp = array();
        foreach ($result as $pa) {
            if ($temp[$pa->pa_id]) {
                $temp[$pa->pa_id]['count']++;
                $temp[$pa->pa_id]['approved_net_amount'] += $pa->approved_net_amount;
            } else {
                $temp[$pa->pa_id] = ['name' => $pa->pa_name, 'count' => 1, 'approved_net_amount' => $pa->approved_net_amount];
            }
        }

        parent::response($temp);
    }


    // ------------------------------------------------ //
    // -------- extract trip data for excel export ------ //
    // ------------------------------------------------ //
    public function getServiceSummary()
    {
        try {
            $tender_id = $this->_request->tender_id;
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;

            //validate role code if it has the ownership to view this report
            $this->hasAuthToViewReport($tender_id, 'service_summary_report');

            // prepare dates
            if (!$date_from) {
                throw new Exception("date_from is required");
            }
            if (!$date_to || $date_to == "") {
                $date_to = date("Y-m-d");
            }
            $parsed_date_arr = date_parse($date_to);
            $filtered_date_arr = array_filter($parsed_date_arr);
            if (!array_key_exists('hour', $filtered_date_arr)) {
                $date_to = $date_to . ' 23:59:59';
            }

            $query = "SELECT 
                        count(w.id) cnt,
                        ifnull(w.document->>'$.service_list[0].service_id','0') service_id,
	                    ifnull(w.document->>'$.service_list[0].service_name','بدون خدمة') service_name,
                        ifnull(w.document->>'$.service_list[0].service_price',0) service_price,
                        ifnull(sum(w.document->>'$.service_list[0].service_price'),0) total_price
                    FROM
                        waybill w
                    WHERE
                        tender_id = ?
                            AND create_date >= ? ";
            $param[] = $tender_id;
            $param[] = $date_from;

            if ($date_to) {
                $query .= "AND create_date < ?";
                $param[] = $date_to;
            }

            $query .= "AND w.document->>'$.service_list[0].status' is null
                            group by service_id,service_name,service_price";

            $data = DBConnection::runBindDatabaseQuery($query, $param);

            $result = [];
            $result['data'] = $data;
            $result['found_rows'] = sizeof($data);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------ //
    // -------- extract trip data for excel export ------ //
    // ------------------------------------------------ //
    public function getJoPetrolDashboard_4()
    {
        try {
            // start the conniction
            DBConnection::getInstance();

            // diff a Group
            $group_by = "MONTHLY";

            // check for year if sent and prepering the data
            if ($this->_request->year_from) {
                $group_by = "YEARLY";
                $date_from = $this->_request->year_from . "-01-01";
                $date_to = $this->_request->year_to . "-01-01";
            } else {
                $date_from = $this->_request->date_from;
                $date_to = $this->_request->date_to;
            }

            // set the search Query
            $serchJoPetrolSqlQry = "SELECT
            id , from_date , to_date ,  CAST(details AS CHAR CHARSET UTF8) AS details
            FROM
                 jo_petrol_dashboard_2
            WHERE
               date(from_date) >= ?
               AND date(to_date) <= ?
               AND group_by = ?";

            // get the data rom db
            $serchJoPetrolQry = DBConnection::runBindDatabaseQuery($serchJoPetrolSqlQry, [$date_from, $date_to, $group_by]);

            // send the fetched data to front end
            $Result['data'] = $serchJoPetrolQry;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function getGeneralTenderReport()
    {

        $reports = [];
        $result = [];

        $report1 = new stdClass();
        $report1->caption = "الإرساليات المقدمة";
        $report1->template = "general_waybills_report";
        $report1->roles = ["OPERATION_MANAGER", "MINAGATE_OPERATION", "TC_MANAGER"];
        $reports[] = $report1;

        $report2 = new stdClass();
        $report2->caption = "اغلاق الصندوق";
        $report2->template = "fps_cash_box_report";
        $report2->roles = ["OPERATION_MANAGER", "PA_FPS_TELLER", "PA_FPS_MANAGER"];
        $reports[] = $report2;

        $report3 = new stdClass();
        $report3->caption = "الشيكات المؤجلة";
        $report3->template = "post_dated_check_report";
        $report3->roles = ["OPERATION_MANAGER", "ACCOUNTANT", "FPS_TELLER_SUPERVISOR"];
        $reports[] = $report3;

        $report4 = new stdClass();
        $report4->caption = "تقرير الشيكات المؤجلة";
        $report4->template = "post_dated_check_report";
        $report4->roles = ["ACCOUNTANT", "TELLER_SUPERVISOR", "OPERATION_MANAGER"];
        $reports[] = $report4;

        $report5 = new stdClass();
        $report5->caption = "تقرير السلف المسددة ";
        $report5->template = "downpayment_complete";
        $report5->roles = ["ACCOUNTANT", "TELLER_SUPERVISOR", "OPERATION_MANAGER"];
        $reports[] = $report5;

        $report6 = new stdClass();
        $report6->caption = "تقرير أعداد المستندات";
        $report6->template = "waybill_count_report";
        $report6->roles = ["ACCOUNTANT", "TELLER_SUPERVISOR", "OPERATION_MANAGER"];
        $reports[] = $report6;

        $result['reports'] = $reports;
        $result['tender_name'] = "كل المشاريع";
        parent::response($result);
    }

    // ------------------------------------------------ //
    // -------- extract containers data to excel report ------ //
    // ------------------------------------------------ //
    public function getContainerServicesReport()
    {
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $tender_id = $this->_request->tenderid;
        $service = $this->_request->service_name;

        if (!isset($date_from) || !isset($date_to) || !isset($tender_id))
            throw new Exception('Unfulfilled data');

        $sqlQuery = "SELECT id,tn,trn,driver_nn, driver_name,
        document->>'$.cargo[0].cargo.name' cargo_name,
        document->>'$.cargo[0].cargo.container' container,
        document->>'$.cargo[0].policy.policy_number'policy_number ,
        document->>'$.cargo[0].policy.shipping_line_id' shipping_line_id,
        document->>'$.cargo[0].policy.declaration_number' declaration_number,
        document->>'$.cargo[0].policy.customs_permit_number' customs_permit_number,
        document->>'$.cargo[0].policy.customs_loading_permit'customs_loading_permit,
        document->>'$.services' services,
        create_date
                        FROM waybill_draft WHERE tender_id = ? AND create_date BETWEEN ? AND ?
                        AND document->>'$.services[*].service_code' like '%$service%' ORDER BY ID DESC;";
        $params = [$tender_id, $date_from, $date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        parent::response($data);
    }

    public function getMerchantSealReport()
    {
        // get user input
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $tender_id = $this->_request->tender_id;

        // run DB query
        $sqlQuery = "SELECT v.id,  v.notes,  v.create_date
                         FROM voucher v
                         where v.notes like '%رصاص%' AND v.create_date > ? AND v.create_date < ?
                          ORDER BY v.ID DESC;";
        $params = [$date_from, $date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        $result = [];

        // clean data
        foreach ($data as $key => $value) {
            $temp = new stdClass();
            $split = explode("-", $value->notes);

            foreach ($split as $raw) {
                $raw = trim($raw);
                if (strpos($raw, 'حاوية') !== false) {
                    $val = explode(" ", $raw)[1];
                    $container_number = $val;
                }
                if (strpos($raw, 'حجز') !== false) {
                    $val = explode(" ", $raw)[2];
                    $reserve_number = $val;
                }
                if (strpos($raw, 'رصاص') !== false) {
                    $val = explode(" ", $raw)[1];
                    $seal_number = $val;
                }
            }

            $temp->id = $value->id;
            $temp->container_number = $container_number;
            $temp->ca_name = $split[sizeof($split) - 1];
            $temp->seal_number = $seal_number;
            $temp->reserve_number = $reserve_number;

            $result[] = $temp;
        }
        // dump($result);die;
        parent::response($result);
    }

    public function searchTenderServiceAgents()
    {

        // get user param
        $tender_id = $tender_id = $this->_request->tender_id;

        // call the core search
        $searchFilter = [];
        $searchFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
        $ServiceAgents_qry = $this->_ServiceAgentCore->searchTenderServiceAgents($searchFilter, 100, 0, $_SESSION['user_id']);

        parent::response($ServiceAgents_qry->data);
    }


    // ----------------------------------------------------------------------------- //
    // -------- Search for company trucks that has queue with indivisuals ---------- //
    // ----------------------------------------------------------------------------- //
    public function searchCompanyTrucksThatHasIndivisualQueue()
    {

        $tender_id =   $this->_request->tender_id;
        $sqlQuery = "SELECT 
                        distinct(w.tn), 
                        w.document->>'$.carrier[0].tc.name' , 
                        q.rank,
                        t.tender_company_id ,
                        tc.name,
                        t.id
                    FROM
                        waybill_view w , tender_truck_view t, queue q , tender_company_view tc
                    WHERE
                        w.tender_id = 3
                            AND w.create_date > '2021-01-01'
                            AND w.status NOT IN ('INACTIVE' , 'REVOKED')
                            and w.truck_id = t.truck_id
                            and q.truck_id = w.truck_id
                            and q.tender_id = tc.tender_id
                            and q.q_id = 1
                            and q.rank is not null
                            and tc.tender_id = ?
                            and t.tender_company_id = tc.id
                            and t.tender_company_id not in (1,189,198)
                            and t.status != 'INACTIVE'";
        $params = [$tender_id];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        parent::response($data);
    }


    // ------------------------------------------------------- //
    // -------- extract containers data to excel report ------ //
    // ------------------------------------------------------- //
    public function getDestinationsByCargo()
    {
        $tender_id = $this->_request->tender_id;
        $cargo_id_list = $this->_request->cargo_id;

        //validate role code if it has the ownership to view this report
        $this->hasAuthToViewReport($tender_id, 'cargo_destination_report');

        $sqlQuery = "
            select
            count(w.id) as cnt,
            w.destination_id as destination_id ,
            document->>'$.negotiable_instructios.route.destination.name' destination_name
            from waybill w where tender_id = ?
            and document->>'$.cargo[0].cargo.id' in (" . $cargo_id_list . ") and status not in ('INACTIVE','REVOKED')
            group by
            w.destination_id ,
            document->>'$.negotiable_instructios.route.destination.name' ";
        $params = [$tender_id];

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        parent::response($data);
    }



    // ------------------------------------------------ //
    // --------get tender trucks tht has multi load panelty ------ //
    // ------------------------------------------------ //
    public function getMultiLoadTenderTrucks()
    {
        $tender_id = $this->_request->tender_id;

        // search for pending tender truck on certain tender
        $tenderTruckFilter = [
            ['key' => 'status', 'val' => 'PENDING'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1000, 0, 0);

        // collect ids
        $tenderTruckIds = [];
        foreach ($tenderTruck_qry->data as $truck) {
            $tenderTruckIds[] = $truck->id;
        }
        $tenderTruckIds = implode(",", array_values($tenderTruckIds));

        // get all activities for the collected ids
        $activitySQL = "select tender_truck_id, notes from activity 
                        where tender_truck_id in ($tenderTruckIds)  
                        and action_code = 'ADD_NOTE'
                        and object_code = 'tender_truck'";
        $activities = DBConnection::runBindDatabaseQuery($activitySQL, []);

        $dataResult = [];
        // get if any of the previous trucks has activity remarks of multi load
        foreach ($tenderTruck_qry->data as $truck) {
            foreach ($activities as $activity) {
                if ($truck->id == $activity->tender_truck_id) {
                    if (strpos($activity->notes, 'ازدواجية') !== false) {
                        $tempTruck = new stdClass();
                        $tempTruck->tn = $truck->tn;
                        $tempTruck->trn = $truck->trn;
                        $tempTruck->owner_name = $truck->owner_name;
                        $tempTruck->notes = $activity->notes;
                        $tempTruck->update_date = $truck->update_date;
                        $dataResult[] = $tempTruck;
                        break;
                    }
                }
            }
        }

        $result = [];
        $result['data'] = $dataResult;
        $result['found_rows'] = sizeof(($dataResult));
        parent::response($result);
    }


    // ---------------------------------------------------------------------------------------- //
    // ----------------------- Get open advace payment for waybill_draft ---------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getWaybillDraftOpenAdvancePayments()
    {

        $tender_id = $this->_request->tender_id;
        $tn = $this->_request->tn;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        $sqlQuery = "select bond_number ,
                    tn , create_date,
                    document->>'$.freight.payments[0].value.amount' as amount ,
                    document->>'$.negotiable_instructios.route.origin.name' as origin_name,
                    document->>'$.negotiable_instructios.route.destination.name'  as destination_name

                    from waybill_draft 
                    where tender_id = ? 
                    and status = 'ONROAD'
                    and document->>'$.freight.payments' != '[]' ";
        $params = [$tender_id];

        if ($tn) {
            $sqlQuery .= "and tn = ?";
            $params[] = $tn;
        }
        if ($date_from) {
            $sqlQuery .= "and create_date >= ?";
            $params[] = $date_from;
        }
        if ($date_to) {
            $sqlQuery .= "and create_date < ?";
            $params[] = $date_to;
        }

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        parent::response($data);
    }

    // ---------------------------------------------------------------------------------------- //
    // ----------------------- Get NEW advace payment on FPS system  ---------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getFpsOpenAdvancePayments()
    {

        $notes = $this->_request->notes;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        // get the open (NEW) claims for bond
        $filter = [];
        $filter['reference_code'] = "BOND_NUMBER";
        $filter['status'] = "NEW";

        if ($date_from) {
            $filter['date_from'] = $date_from;
        }
        if ($date_to) {
            $filter['date_to'] = $date_to;
        }
        if ($notes) {
            $filter['notes'] = $notes;
        }

        $paClaimItemFilter = new stdClass();
        $paClaimItemFilter->filter = json_encode($filter);
        $paClaimItemFilter->pa_id = $_SESSION['pa_id'];
        $claims = $this->_fps->searchPaClaim($paClaimItemFilter, $_SESSION['user_id']);

        parent::response($claims);
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // ----------------------- Get inactive items on certain claim or within certain period  ---------------------- //
    // ------------------------------------------------------------------------------------------------------------- //
    public function getFpsDeletedClaimItem()
    {

        // get user params
        $claim_id = $this->_request->claim_id;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'PA_FPS_MANAGER') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا تستطيع المتابعة لا يوجد لديك صلاحية لمشاهدة التقرير");
        }

        // get the (deleted) claims items
        $paClaimItemFilter = new stdClass();
        $filter = [];
        if ($date_from) {
            $filter['date_from'] = $date_from;
        }
        if ($date_to) {
            $filter['date_to'] = $date_to;
        }
        if ($claim_id) {
            $filter['claim_id'] = $claim_id;
        }

        $paClaimItemFilter = new stdClass();
        $paClaimItemFilter->filter = json_encode($filter);
        $items = $this->_fps->searchInactivePaClaimItems($paClaimItemFilter, $_SESSION['pa_id']);

        if (gettype($items) == "string") {
            $items = json_decode($items);
        }

        //loop on items to make sure the user has the auth to view it
        if ($items && sizeof($items) > 0) {
            $claim_ids = [];
            foreach ($items as $item) {
                $claim_ids[] = $item['claim_id'];
            }

            // get all claim records from previous loop using session
            $paClaimFilter = new stdClass();
            $pa_claim_filter = [];
            $pa_claim_filter['claim_id_list'] = $claim_ids;
            $paClaimFilter->filter = json_encode($pa_claim_filter);
            $paClaimFilter->pa_id = $_SESSION['pa_id'];
            $allowedClaims = $this->_fps->searchPaClaim($paClaimFilter, $_SESSION['user_id']);

            if (gettype($allowedClaims) == "string") {
                $allowedClaims = json_decode($allowedClaims);
            }

            // filter out each item if it has no record in claim
            if ($allowedClaims && sizeof($allowedClaims) > 0) {
                foreach ($items as $index => $item) {
                    $keepItem = false;
                    foreach ($allowedClaims['data'] as $claim) {
                        if ($item['claim_id'] == $claim['id']) {
                            $keepItem = true;
                        }
                    }
                    if (!$keepItem) {
                        unset($items[$index]);
                    }
                }
            }
        }

        $result = [];
        $result['data'] = $items;
        $result['found_rows'] = sizeOf($items);
        parent::response($result);
    }



    // ------------------------------------------------------------------------------------------------- //
    // ----------------------- Get tender waybill statistics based on cargo type  ---------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function getCargoTypeStatiscsReport()
    {

        // get user params
        $tender_id = $this->_request->tender_id;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $cargo_type = $this->_request->cargo_type;
        $is_chart = $this->_request->is_chart;

        //get the number of years to be viewd
        $from_year = date("Y", strtotime($date_from));
        if (!$from_year) $from_year = 2018;
        $currentYear = date("Y", strtotime($date_to));
        if (!$currentYear) $currentYear = date("Y");
        $number_of_years = $currentYear - $from_year;

        // validate report auth
        // $this->hasAuthToViewReport($tender_id,'statistics_report');

        // run sql query
        $sqlQuery = " select  ct.name , count(w.id) cnt , year(w.create_date) year,
                              sum(w.document->>'$.cargo[0].weights.loading.net_weight')/1000 as weights from waybill w , ct
                      where tender_id = ?
                            and ct.id = document->>'$.cargo[0].cargo.ct_id'
                            and w.create_date >= ?
                            and w.create_date < ?
                            and w.status not in ('INACTIVE','REVOKED') ";
        $param = [$tender_id, $date_from, $date_to];
        if ($cargo_type && gettype($cargo_type) == 'array') {
            $cargo_type = implode(",", $cargo_type);
            $sqlQuery .= " and ct.id in ($cargo_type) ";
        }
        if ($cargo_type && gettype($cargo_type) == 'string') {
            $sqlQuery .= " and ct.id in ($cargo_type) ";
        }
        $sqlQuery .= "group by ct.name , year(w.create_date)";

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        // format the data
        $Result = [];
        foreach ($data as $row) {
            $temp = new stdClass();
            $temp->cnt = $row->cnt;
            $temp->year = $row->year;
            $temp->weights = $row->weights;
            $Result[$row->name][] = $temp;
        }
        $result2 = [];
        foreach ($Result as $key => $value) {
            $temp = new stdClass();
            $temp->years = $value;
            $temp->name = $key;
            $result2[] = $temp;
        }
        foreach ($result2 as &$r) {
            for ($i = $currentYear - $number_of_years; $i <= $currentYear; $i++) {
                $temp2 = new stdClass();
                $temp2->cnt = 0;
                $temp2->year = "$i";
                $temp2->weights = 0;
                $full_years[] = $temp2;
            }

            foreach ($r->years as $dbYear) {
                foreach ($full_years as $fullYear) {
                    if ($dbYear->year == $fullYear->year) {
                        $fullYear->cnt = $dbYear->cnt;
                        $fullYear->weights = $dbYear->weights;
                    }
                }
            }
            $r->years = $full_years;
            $full_years = [];
        }


        if ($is_chart) {
            // for line chart      
            $chartData = [];

            $row = ["years"];
            foreach ($result2 as $rowObject) {
                $row[] = $rowObject->name;
            }
            $chartData[] = $row;

            $row = [];
            for ($i = $currentYear - $number_of_years; $i <= $currentYear; $i++) {
                $row[] = "$i";
                $year_has_cnt = false;

                foreach ($result2 as $rowObject) {
                    foreach ($rowObject->years as $y) {
                        if ($y->year == $i) {
                            $row[] = intval($y->cnt);
                            $year_has_cnt = true;
                        }
                    }
                    if (!$year_has_cnt) {
                        $row[] = 0;
                    }
                }
                $chartData[] = $row;
                $row = [];
            }


            parent::response($chartData);
        } else {
            $result = [];
            $result['data'] = $result2;
            $result['found_rows'] = sizeOf($result2);
            parent::response($result);
        }
    }

    public function __toString()
    {
        return $this->year;
    }

    // ------------------------------------------------------------------------------------------------- //
    // ----------------------- Get tender waybill statistics based on cargo type  ---------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function getVesselsStatiscsReport()
    {

        // get user params
        $tender_id = $this->_request->tender_id;

        // validate report auth
        $this->hasAuthToViewReport($tender_id, 'statistics_report');

        // run sql query
        $sqlQuery = "SELECT 
                        COUNT(DISTINCT (c.vessel_name)) as cnt,
                        CONCAT('20', LEFT(id, 2)) as year
                    FROM
                        cargo c
                    WHERE
                        c.tender_id = ?
                        AND c.status != 'INACTIVE'
                    GROUP BY CONCAT('20', LEFT(id, 2))";

        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_id]);
        parent::response($result);
    }



    // ------------------------------------------------------------------------ //
    // ----------------------- get Ar Claims fine report ---------------------- //
    // ------------------------------------------------------------------------ //     
    public function getAR_claimFinesreport()
    {

        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;
        $tender_id = $this->_request->tender_id;
        $pa_id = $this->_request->pa_id;

        // validate report auth
        $this->hasAuthToViewReport($tender_id, 'AR_claim_fine_report');

        $sqlQuery = "select 	
                            t.pa_name,
                            count(distinct(t.id)) as claims_count,
                            count(i.id) as items_count,
                            sum(i.approved_freight->>'$.total_fines') as total_fines
                        from tender_claim_item i,
                        tender_claim_view t
                        
                        where i.tender_claim_id = t.id 
                        and i.create_date >= ?
                        and i.create_date < ?
                        and t.tender_id = ? 
                        and t.pa_id is not null
                        and i.approved_freight->>'$.total_fines' > 0
                        ";
        $param = [$date_from, $date_to, $tender_id];

        if ($pa_id) {
            $sqlQuery .= "  and t.pa_id = ? ";
            $param[] = $pa_id;
        }
        $sqlQuery .= "  group by t.pa_name having total_fines > 0";

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $result = [];
        $result['data'] = $data;
        $result['found_rows'] = sizeOf($data);
        parent::response($result);
    }


    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ----------------------------- Get diff between Jo petrol card balance and actual balances Report --------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getRemainingLimitReport()
    {
        $jppmc = new JPPMC();
        $data = $this->_request->data;

        // format and clean user data
        foreach ($data as &$row) {
            if ($row->tn && $row->tn != "") {
                $row->tn = str_replace("-", "", $row->tn);
                $row->balance = str_replace("JD", "", $row->balance);
            } else {
                $row = null;
            }
        }

        // get the full balance for all trucks (what should the balance be)
        $fullBalance = $jppmc->getDieselFullBalance();

        // get the real balance of each truck (what is really in truck card)
        $realBalance = $data;

        // find the difference
        $result = [];
        foreach ($fullBalance as $fullBalanceRow) {
            foreach ($realBalance as $realBalanceRow) {
                if ($fullBalanceRow->tn == $realBalanceRow->tn) {

                    if ($fullBalanceRow->balance != $realBalanceRow->balance) {
                        $obj = new stdClass();
                        $obj->tn = $fullBalanceRow->tn;
                        $obj->cnt = $fullBalanceRow->cnt;
                        $obj->actual_diesel = $realBalanceRow->balance;
                        $obj->diesel = $fullBalanceRow->balance;
                        $obj->difference = $fullBalanceRow->balance - $realBalanceRow->balance;
                        $result[] = $obj;
                    }
                }
            }
        }

        // search if the truck in Minagate Database and not in Jo_petrol System
        foreach ($fullBalance as $fullBalanceRow) {
            $isFound = false;
            foreach ($realBalance as $realBalanceRow) {
                if ($fullBalanceRow->tn == $realBalanceRow->tn) {
                    $isFound = true;
                    break;
                }
            }

            if (!$isFound) {
                $obj = new stdClass();
                $obj->tn = $fullBalanceRow->tn;
                $obj->cnt = $fullBalanceRow->cnt;
                $obj->actual_diesel = 0;
                $obj->diesel = $fullBalanceRow->balance;
                $obj->difference = $fullBalanceRow->balance;
                $result[] = $obj;
            }
        }


        // search if the truck in  Jo_petrol System and not in Minagate Database
        foreach ($realBalance as $realBalanceRow) {
            $isFound = false;
            foreach ($fullBalance as $fullBalanceRow) {
                if ($fullBalanceRow->tn == $realBalanceRow->tn) {
                    $isFound = true;
                    break;
                }
            }
            if (!$isFound) {
                $obj = new stdClass();
                $obj->tn = $realBalanceRow->tn;
                $obj->cnt = 0;
                $obj->actual_diesel = $realBalanceRow->balance;
                $obj->diesel = 0;
                $obj->difference = $realBalanceRow->balance;
                $result[] = $obj;
            }
        }
        // return response
        parent::response($result);
    }

    // ----------------------------------------------------------------------------------------------------------------------- //
    // ----------------------------- Get diff between sum of diesel log and actual balances Report --------------------------- //
    // ----------------------------------------------------------------------------------------------------------------------- //
    public function getRemainingLimitReport_diesl()
    {
        $jppmc = new JPPMC();
        $userInput = $this->_request->data;

        // format and clean user data , TODO yazan code here
        $data = [];
        $tn = [];
        $Total = [];
        foreach ($userInput as $value) {
            if (substr($value->tn, 0, 3) === '60-') {
                if (array_search($value->tn, $tn) === false) {
                    $tn[] = $value->tn;
                }
            }
            if (substr($value->data, 0, 5) === 'Total') {
                $total = explode(" ", $value->data);
                $total = explode("JD", $total[5]);
                $Total[] = $total[0];
            }
        }

        foreach ($tn as $key => $t) {
            $data[] = ['tn' => str_replace("-", "", $t), 'balance' => $Total[$key]];
        }


        // get the full balance for all trucks (what should the balance be)
        $fullBalance = $jppmc->getDieselFullBalance();

        // get the real balance of each truck (what is really in truck card)
        $realBalance = $data;

        // find the difference
        $result = [];
        foreach ($fullBalance as $fullBalanceRow) {
            foreach ($realBalance as $realBalanceRow) {

                if ($fullBalanceRow->tn == $realBalanceRow['tn']) {
                    if (abs($fullBalanceRow->balance - $realBalanceRow['balance']) > 0.01) {
                        $obj = new stdClass();
                        $obj->tn = $fullBalanceRow->tn;
                        $obj->cnt = $fullBalanceRow->cnt;
                        $obj->actual_diesel = $realBalanceRow['balance'];
                        $obj->diesel = $fullBalanceRow->balance;
                        $obj->difference = $fullBalanceRow->balance - $realBalanceRow['balance'];
                        $result[] = $obj;
                    }
                }
            }
        }

        // return response
        parent::response($result);
    }



    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------------- get waybills percentage on certain cargo ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function getWaybillsPercentageReport()
    {

        // parse incoming params       
        $cargo_ids = $this->_request->cargo_id;
        $tender_id = $this->_request->tender_id;

        //validate role code if it has the ownership to view this report
        // $this->hasAuthToViewReport($tender_id,'indivisual_perc_waybill_report');

        $sqlQuery = " SELECT  document->>'$.carrier[0].tc.id' tc_id  , 
                                document->>'$.carrier[0].tc.name' tc_name ,
                                count(w.id) waybill_cnt, 
                                case 
                                    when count(q1.id) = 0 then count(q2.id)
                                    else  count(q1.id) 
                                end as truck_inside_yard
                        FROM waybill w 
                            left join queue q1 on w.truck_id = q1.truck_id and q1.tender_id = 3 and q1.q_id = 3 and q1.rank is not null
                            left join queue q2 on w.truck_id = q2.truck_id and q2.tender_id = 3 and q2.q_id = 2 and q2.rank is not null
                        
                        where document->>'$.cargo[0].cargo.id' in ($cargo_ids)
                        and w.status not in ('INACTIVE','REVOKED')
                        and w.tender_id = ?
                        group by document->>'$.carrier[0].tc.id'  , document->>'$.carrier[0].tc.name'
                        order by waybill_cnt desc
                    ";

        $param = [$tender_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        //get total numbers
        $total = 0;
        foreach ($result as &$row) {
            $row->truck_out_from_yard = intval($row->waybill_cnt - $row->truck_inside_yard);
            $total += $row->truck_out_from_yard;
        }

        // return result
        $Result = [];
        $Result['total'] = $total;
        $Result['individual_perc'] = 0;
        $Result['company_perc'] = 0;

        foreach ($result as &$row) {
            if ($total > 0)
                $row->perc = number_format(doubleval($row->truck_out_from_yard / $total) * 100, 1);
            else
                $row->perc = "0";

            if ($row->tc_id == 395) {
                if ($total > 0) {
                    $Result['individual_perc'] = number_format(doubleval($row->truck_out_from_yard / $total) * 100, 1) . "%";
                    $Result['company_perc'] = number_format(100 - $Result['individual_perc'], 1) . "%";
                } else {
                    $Result['individual_perc'] = "0";
                    $Result['company_perc'] = "0";
                }
            }
        }

        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------------- get declaration summary statts ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function getWaybillswithBondDelivirySummary()
    {

        // get  user params
        $create_from = $this->_request->create_from;
        $create_to = $this->_request->create_to;
        $declaration_number = $this->_request->declaration_number;
        $ca_id = $this->_request->ca_id;


        $filter = [];
        if ($declaration_number) {
            $filter[] = ['key' => 'declaration_number', 'val' => $declaration_number];
        }
        if ($create_from) {
            $filter[] = ['key' => 'create_date', 'val' => $create_from, 'op' => 'date greater than'];
        }
        if ($create_to) {
            $filter[] = ['key' => 'create_date', 'val' => $create_to, 'op' => 'date less than'];
        }
        if ($ca_id) {
            $filter[] = ['key' => 'ca_id', 'val' => $ca_id];
        }

        $result = DBConnection::searchReport("cargo_policy", "03", $filter, 10000, 0, $_SESSION['user_id'], ' order by id desc');

        foreach ($result->data as &$row) {
            if ($row->status == "NEW") {
                $row->status = "جديد";
            } else if ($row->status == "APPROVED") {
                $row->status = "منجزة";
            }
        }

        parent::response($result);
    }

    // ----------------------------------------------------------------- //
    // ------------------- Land trip report ---------------------------- //
    // ----------------------------------------------------------------- //
    public function getLandTripReport()
    {
        // get  user params
        $date_type = $this->_request->date_type;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        $declaration_number = $this->_request->declaration_number;
        $ca_id = $this->_request->ca_id;
        $sa_status = $this->_request->sa_status;
        $tender_id = $this->_request->tender_id;
        $ca_print_service = $this->_request->ca_print_service;
        $declaration_year = $this->_request->declaration_year;

        // validate auth
        $this->hasAuthToViewReport($tender_id, 'land_trip_report');

        // include date to
        if (strpos($this->_request->date_to, ':') == false) {
            $date_to = $this->_request->date_to . " 23:59:59";
        }

        // fix time part in case it is not sent
        if ($date_type == "approved_date") {
            $approved_from = $date_from;
            $approved_to = $date_to;
        } else {
            $create_from =  $date_from;
            $create_to = $date_to;
        }

        // search for declaration
        $filter = [];
        if ($declaration_number && $declaration_number != "") {
            $filter[] = ['key' => 'declaration_number', 'val' => $declaration_number];
        }
        if ($create_from) {
            $filter[] = ['key' => 'create_date', 'val' => $create_from, 'op' => 'date greater than'];
        }
        if ($create_to) {
            $filter[] = ['key' => 'create_date', 'val' => $create_to, 'op' => 'date less than'];
        }
        if ($approved_from) {
            $filter[] = ['key' => 'approved_date', 'val' => $approved_from, 'op' => 'date greater than'];
        }
        if ($approved_to) {
            $filter[] = ['key' => 'approved_date', 'val' => $approved_to, 'op' => 'date less than'];
        }
        if ($ca_id) {
            $filter[] = ['key' => 'ca_id', 'val' => $ca_id];
        }
        if ($ca_print_service) {
            $filter[] = ['key' => 'ca_print_service', 'val' => $ca_print_service];
        }
        if ($sa_status) {
            $filter[] = ['key' => 'sa_status', 'val' => $sa_status];
        }
        if ($declaration_year) {
            $filter[] = ['key' => 'declaration_year', 'val' => $declaration_year];
        }

        // call container API
        $data = new stdClass();
        $data->filter = $filter;
        $data->limit = 100000;
        $result = $this->_con->getLandTripReport($data, $_SESSION['user_id']);

        $user_ids = [];
        foreach ($result['data'] as &$row) {
            if ($row['sa_status'] == "NEW") {
                $row['sa_status'] = "جديد";
            } else if ($row['sa_status'] == "APPROVED") {
                $row['sa_status'] = "منجزة";
            }

            if ($row['ca_print_service'] == "manual_bond") {
                $row['ca_print_service'] = "طباعة يدوية";
            } else if ($row['sa_status'] == "e-boned") {
                $row['ca_print_service'] = "طباعة الكترونية";
            }

            $user_ids[] = $row['done_by'];
        }

        // in case the session is corporate , change done_by to return employee name
        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $searchFilter = [
                ['key' => 'company_id', 'val' => $_SESSION['company_id']],
                ['key' => 'status', 'val' => 'ACTIVE']

            ];
            $employeeInfo = $this->_companyEmployeeCore->searchCompanyEmployee($searchFilter, 100, 0, 0); #17558

            foreach ($result['data'] as &$trx) {
                foreach ($employeeInfo->data as $employee) {
                    if ($trx['done_by'] == $employee->user_id) {
                        $trx['done_by'] = $employee->name;
                    }
                }
            }
        }


        parent::response($result);
    }


    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------------- getFinancialManagersReport ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function getFinancialManagersReport()
    {
        try {
            // dump($this->_request->filter);
            // die;
            $tenderSearchFilter = $this->prepareFilter();
            $tender_truck_info = DBConnection::searchReport("tender_truck", "02", $tenderSearchFilter, 20000, 0, 0);
            $Result = [];
            $Result['data'] = $tender_truck_info->data;
            $Result['found_rows'] = $tender_truck_info->found_rows;
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // ---------------------------------------------------------------------------- //
    // ------------------  prepare any json filter for search --------------------- //
    // ---------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $accountFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == 'tender_id') {
                    $tempArr = ['key' => $key, 'val' => $value];
                } else if ($key == "name" || $key == "phone") {
                    if ($value == 'is null' || $value == 'is not null') {
                        $tempArr = ['key' => $key, 'op' => $value];
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value];
                    }
                } elseif ($key == 'cargo') {
                    $tempArr = ['key' => "search_index", 'val' => $value, 'op' => 'like'];
                } else if ($key == 'date_from') {
                    $tempArr = ['key' => 'create_date', 'val' => "$value", 'op' => 'date greater than'];
                } else if ($key == 'date_to') {
                    $tempArr = ['key' => 'create_date', 'val' => "$value", 'op' => 'date less than'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($accountFilter, $tempArr);
            }
        }
        return $accountFilter;
    }



    // ------------------------------------------------------------------------------------------- //
    // ---------------------- get history of orders for the last 20 days ------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getTrucksDBR()
    {
        $tender_id = 11;
        //search for user trucks
        $filter = [['key' => 'tender_id', 'val' => $tender_id]];

        $truckResult = $this->_tenderCore->searchTenderTruck(
            $filter,
            6,
            0,
            $_SESSION['user_id']
        );
        $split = 'id="-';
        // search for DBR of each user
        $content = '
                    <html>
                        <head>
                         <title>DBR</title>
                            <meta charset="utf-8">
                            <meta name="viewport" content="width=device-width, initial-scale=1">
                            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
                            <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
                            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
                            <!-- <script src="https://cdn.jsdelivr.net/npm/xmlhttprequest@1.8.0/.jshintrc"></script> -->
                        </head>
                        <script>
                            function myFunction(tn) {
                                let c = document.getElementById("accordion").innerHTML;
                                let x = c.split(' . "'" . $split . "'" . ');
                                let arr =[];
                                for (let index = 1; index < x.length; index++) {
                                    arr.push(x[index].slice(0,7));
                                }
                                for (let index = 0; index < arr.length; index++) {
                                    if(tn == arr[index]){
                                        var y = document.getElementById("-"+tn);

                                        if (y.style.display === "none") {
                                                y.style.display = "block";
                                        } else {
                                                y.style.display = "none";
                                        }
                                    }else{
                                       let y = document.getElementById("-"+arr[index]);
                                       y.style.display = "none";
                                    }
                                }
                            }
                            </script>
                        <body  dir="rtl">
                        <div id="container">
                         ';

        $temp = '';
        $temp2 = '';
        $temp2 .= '<div id="accordion" class="panel-group">';

        foreach ($truckResult->data as $value) {

            $button = '';
            $button .= '<a
                        href="#' . $value->tn . '"
                        class="btn btn-default col-4"
                        style="margin: 1%;"
                         class="btn btn-default "
                        onclick="myFunction(' . $value->tn . ')"
                        style="margin: 1%;">' . $value->tn . '
                        </a> ';
            $temp .= $button;
        }
        $content .= $temp;

        $_dbrCore = new DBR_Core();

        foreach ($truckResult->data as $value) {
            $calculateWaybillDBR = $_dbrCore->calculateWaybillDBR($value->tn, 11);
            $number_of_wayblls = $calculateWaybillDBR["number_of_wayblls"];
            $discharge_weight = $calculateWaybillDBR["discharge_weight"] / 1000;
            $loss_in_kg = $calculateWaybillDBR["loss_in_kg"];
            $tn = $calculateWaybillDBR["tn"];

            $wage_per_ton = $calculateWaybillDBR["wage_per_ton"];
            $dbr_value = $calculateWaybillDBR["dbr_value"];
            $TPM = $calculateWaybillDBR["TPM"];
            $late_factor = $calculateWaybillDBR["late_factor"];
            $avg_complete_waybill_in_days = $calculateWaybillDBR["avg_complete_waybill_in_days"];

            $avgDays = floor($avg_complete_waybill_in_days);
            $avgHours = ($avg_complete_waybill_in_days - $avgDays) * 24;

            $avg_complete_waybill_in_days = $avgDays . "  يوم و " . $avgHours . " ساعة ";

            $late_factor_result = intval($late_factor) * 100;
            $background_color = '';
            $color = 'white';
            $wn_background_color = 'green';

            if ($number_of_wayblls >= 0 && $number_of_wayblls <= 2) {

                $wn_background_color = 'red';
            } else if ($number_of_wayblls > 2 && $number_of_wayblls <= 4) {
                $wn_background_color = '#f3d562';
                $color = 'black';
            }
            if ($number_of_wayblls > 4 && $number_of_wayblls <= 6) {

                $wn_background_color = 'green';
            }
            if ($late_factor_result >= 0 && $late_factor_result <= 25) {
                $background_color = 'red';
            } else if ($late_factor_result >= 26 && $late_factor_result <= 50) {
                $background_color = '#f3d562';
            } else if ($late_factor_result >= 51 && $late_factor_result <= 75) {
                $background_color = 'orange';
            }
            if ($late_factor_result >= 76 && $late_factor_result <= 100) {
                $background_color = 'green';
            }
            $temp2 .= "<div id=-" . $tn . " style='display: none;'>
                         <div>
                        <div id='TPM' style='width: 92%; margin: 4% auto; text-align: right;'>
                        <span  >    الحد الادني لعدد الرحلات</span>
                        <div style='width: 100%;height: 3.5vh; margin-top: 2%; background-color: " . $wn_background_color . ";text-align: center;color:" . $color . "'>6/" . $number_of_wayblls . " </div>
                            </div>
                            <div id='late_factor' style='width: 92%;margin: 4% auto; text-align: right;'>
                            <span >معدل الوقت المستغرق للتفريغ </span>
                            <div style='width: 100%;height: 3.5vh;background-color:" . $background_color . ";margin-top: 2%;color: " . $color . ";text-align: center;'>" . $avg_complete_waybill_in_days . "</div>
                            </div>
                        </div>
                        <div id='details' style='width: 85%; margin: 4% auto;'>
                        <span> التفاصيل : </span>
                        <ul style='border: solid 2px #ebebeb;'>
                                    <li style='margin-top: 1%;'>رقم الشاحنة :" . $tn . "</li>
                                    <li style='margin-top: 1%;'>عدد الرحلات :" . $number_of_wayblls . "رحلة</li>
                                    <li style='margin-top: 1%;'>اقل وزن تفريغ :" . $discharge_weight . " طن</li>
                                    <li style='margin-top: 1%;'>اعلى خسارة وزن :" . $loss_in_kg . " كغم</li>
                                    <li style='margin-top: 1%;'>سعر الطن المحتسب :" . $wage_per_ton . "دينار/طن</li>
                                    <li style='margin-top: 1%;'>مبلغ الدفعة المقدمة المتوقع :" . $dbr_value . "</li>
                        </ul>
                        </div>
                        </div>
                    ";
        }
        $temp2 .= '</div>';
        $content .= $temp2;

        $content .= '</div>
                    </body>
                    </html>';

        $content = str_replace("\n", "", $content);
        $content = stripslashes($content);
        echo $content;
    }




    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------------- get the percentage of waybills that were targeted by downpayment polls ------------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function getPollSharesFromWaybills()
    {
        try {
            $today =  $this->_request->create_date_from;
            $sqlQuery = "SELECT count(w.id) total_wbl , count(t.financial_manager_owner_id) has_poll
                FROM
                    waybill.waybill w
                LEFT JOIN
                    waybill.tender_truck t ON w.truck_id = t.truck_id
                AND
                    t.tender_id = 11
                AND
                    t.status != 'INACTIVE'
                WHERE
                        w.create_date > date(?)";
            $param = [$today];
            $pecData = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $total_wbl = $pecData[0]->total_wbl;
            $has_poll = $pecData[0]->has_poll;
            $data = [];
            $has_no_poll = $total_wbl - $has_poll;
            $arr = ["تم الارسال لهم ", intval($has_poll)];
            $data[] = $arr;
            $data[] = ["لم يتم الارسال لهم", intval($has_no_poll)];
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // --------------------------------------------------------------------- //
    // ------------------  getDownpaymentPollReactions --------------------- //
    // --------------------------------------------------------------------- //
    public function getDownpaymentPollReactions()
    {
        try {
            Poll_DBConnection::getInstance();
            $today =  $this->_request->create_date_from;
            $sqlQuery = "select  id,
                                CAST(answers AS CHAR CHARSET UTF8) AS answers,
                                CAST(activities AS CHAR CHARSET UTF8) AS activities
                                from poll.recipients r where created_at > date(?)
                        ";
            $param = [$today];
            $pecData = Poll_DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $count_answers = 0;
            $count_didnt_answer = 0;
            $count_didnt_open  = 0;
            foreach ($pecData as  $rec) {
                if ($rec->answers != null) {
                    $count_answers++;
                } else if ($rec->answers == null && $rec->activities != null) {
                    $count_didnt_answer++;
                } else if ($rec->answers == null && $rec->activities == null) {
                    $count_didnt_open++;
                }
            }
            $data = [];
            $arr = ["تم الاجابة على الاستبيان ", intval($count_answers)];
            $didnt_answer = ["لم يتم الاجابة على الاستبيان", intval($count_didnt_answer)];
            $no_open_arr = ["لم يتم مشاهدة الاستبيان", intval($count_didnt_open)];
            $data[] = $arr;
            $data[] = $didnt_answer;
            $data[] = $no_open_arr;
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }




    // ---------------------------------------------------------------------------- //
    // ------------------  getDownpaymentPollAnswerIntervales --------------------- //
    // ---------------------------------------------------------------------------- //
    public function getDownpaymentPollAnswerIntervales()
    {
        try {
            Poll_DBConnection::getInstance();
            $today =  $this->_request->create_date_from;
            $sqlQuery = "SELECT
                            r.id,
                            r.created_at,
                            r.updated_at,
                            CAST(answers AS CHAR CHARSET UTF8) AS answers
                        FROM
                            poll.recipients r ,poll.polls p
                        WHERE
                            r.created_at > date(?)
                                AND answers IS NOT NULL
                                and r.poll_id = p.id
                                and p.details->>'$.attributes.sub_type' = 'DOWNPAYMENT'
                        ";
            $param = [$today];
            $pecData = Poll_DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $withinTenMin = 0;
            $tenToSixtyMin = 0;
            $moreThanSixtyMin = 0;
            foreach ($pecData as    $recp) {
                $create_date = date_create($recp->created_at);
                $update_date = date_create($recp->updated_at);
                $days = date_diff($update_date, $create_date)->d * 24;
                $hours = (date_diff($update_date, $create_date)->h * 60) + $days;
                $mints = date_diff($update_date, $create_date)->i + $hours;
                // $hours = date_diff($update_date, $create_date);
                if ($mints > 60) {
                    $moreThanSixtyMin++;
                } else if ($mints < 60 && $mints > 10) {
                    $tenToSixtyMin++;
                } else {
                    $withinTenMin++;
                }
                $data = [];
                $arr = ["في اول 10 دقائق", "من 10 إلى 60 دقيقة ", "اكثر من 60 دقيقة "];
                $data[] = $arr;
                $data[] = [intval($withinTenMin), intval($tenToSixtyMin), intval($moreThanSixtyMin)];
            }
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------- //
    // ------------------  الموافقات حسب وقت الإجابة --------------------- //
    // ---------------------------------------------------------------------------- //
    public function getDownPaymentAnswersBasedOnTime()
    {
        try {
            Poll_DBConnection::getInstance();
            $today =  $this->_request->create_date_from;
            $sqlQuery = "SELECT
                            count(r.id) as count,
                            DATE_FORMAT(r.updated_at,'%H') as hour
                        FROM
                            poll.recipients r, poll.polls p
                        WHERE
                            r.created_at > date(?)
                            AND r.answers is not null
                            AND r.poll_id = p.id
                            AND r.answers like '%" . '"question_id"' . ": 9%'
                            AND p.details->>'$.attributes.sub_type' = 'DOWNPAYMENT'
                            group by DATE_FORMAT(r.updated_at,'%H');";
            $param = [$today];
            $pecData = Poll_DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $arr1 = [];
            $arr2 = [];
            foreach ($pecData as $rec) {
                $arr1[] = "الساعة: " . $rec->hour;
                $arr2[] = intval($rec->count);
            }
            $data = [];
            $data[] = $arr1;
            $data[] = $arr2;
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------- //
    // ------------------  الموافقات حسب تاريخ معين --------------------- //
    // ---------------------------------------------------------------------------- //
    public function getDownPaymentAcceptanceAnswers()
    {
        try {
            Poll_DBConnection::getInstance();
            $today =  $this->_request->create_date_from;
            $sqlQuery = "SELECT
                            count(r.id) as count,
                            DATE_FORMAT(r.updated_at,'%d') as day
                        FROM
                            poll.recipients r, poll.polls p
                        WHERE
                            r.created_at > date(?)
                            AND r.answers is not null
                            AND r.poll_id = p.id
                            AND r.answers like '%" . '"question_id"' . ": 9%'
                            AND p.details->>'$.attributes.sub_type' = 'DOWNPAYMENT'
                            group by DATE_FORMAT(r.updated_at,'%d');";
            $param = [$today];
            $pecData = Poll_DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $arr1 = [];
            $arr2 = [];
            foreach ($pecData as $rec) {
                $arr1[] = $rec->day;
                $arr2[] = intval($rec->count);
            }
            $data = [];
            $data[] = $arr1;
            $data[] = $arr2;
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------- //
    // ------------------  getDownpaymentPollfeedback --------------------- //
    // ---------------------------------------------------------------------------- //
    public function getDownpaymentPollfeedback()
    {
        try {
            Poll_DBConnection::getInstance();
            $today =  $this->_request->create_date_from;
            $sqlQuery = "SELECT
                            r.id,
                            CAST(answers AS CHAR CHARSET UTF8) AS answers
                        FROM
                            poll.recipients r, poll.polls p
                        WHERE
                            r.updated_at > date(?)
                            AND r.answers is not null
                            AND r.poll_id = p.id
                            AND p.details->>'$.attributes.sub_type' = 'feedback'
                            and p.status = 'ACTIVE'
                            ;";
            $param = [$today];
            $pecData = Poll_DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $ev_5 = 0;
            $ev_2_5 = 0;
            $ev_0 = 0;
            $reviewArr = [];
            foreach ($pecData as $rec) {
                $feedackQuestionId = json_decode($rec->answers)[1]->question_id;
                $evaluation = json_decode($rec->answers)[0]->value;
                if ($evaluation == 5) {
                    $ev_5++;
                } else if ($evaluation == 2.5) {
                    $ev_2_5++;
                } else {
                    $ev_0++;
                }
                if (sizeof($reviewArr) < 5 && $feedackQuestionId == 2) {
                    $reviewArr[] = $rec;
                }
            }
            $five = ["ممتاز", intval($ev_5)];
            $two = ["متوسط", intval($ev_2_5)];
            $zero = ["سيئ", intval($ev_0)];
            $data = [];
            $data[] = $five;
            $data[] = $two;
            $data[] = $zero;
            $Result = [];
            $Result['data'] = $data;
            $Result['lastFiveRecord'] = $reviewArr;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------------- //
    // -------------- Search for truck that completed a trip on Jo petrol system --------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchJoPetrolLoadsReport()
    {
        try {

            $date_from = $this->_request->date_from;
            $date_to =  $this->_request->date_to;

            if ($date_from == $date_to) {
                $date_to =  date("Y-m-d", strtotime("+1 day", strtotime($date_to)))  . " 23:59:59";
            } else {
                $date_to = date("Y-m-d", strtotime("+1 day", strtotime($date_to))) .  " 23:59:59";
            }


            $db_query = 'SELECT id,
                                CAST(`details` AS CHAR CHARSET UTF8) AS `details`
                         FROM waybill.jo_petrol_loads
                         where
                         date(created_date) >= "' . $date_from .
                '" and date(created_date) < "' . $date_to .
                '" order by id desc';

            $res = DBConnection::runDatabaseQuery($db_query);
            $data = [];
            if ($res) {
                foreach ($res as  $item) {
                    $item_details = json_decode($item->details);

                    if ($item_details) {
                        foreach ($item_details as $val) {
                            $item_number = $val->item_number;
                            $destination_number = $val->destination_number;

                            $loading_date = $this->convertToDate($val->loading_date);
                            if ($loading_date >= $date_from && $loading_date <= $date_to) {

                                $obj = new stdClass();
                                $obj->nn = $val->nn;
                                $obj->tn_only = $val->tn;
                                $obj->tn = $val->tn . " + " . $val->trn;
                                $obj->loading_date = $loading_date;
                                $obj->item_number = trim($item_number);
                                if ($destination_number == "4") {
                                    $obj->destination_number  = "بئر حمزة";
                                } else if ($destination_number == "2") {
                                    $obj->destination_number  = "نفط عراقي";
                                } else {
                                    $obj->destination_number  = $destination_number;
                                }
                                $obj->cargo_name = $this->converJoPetrolItemNumber($item_number);

                                if (substr($obj->tn, 0, 2) === "60")
                                    $data[] = $obj;
                            }
                        }
                    }
                }
            }

            // inject queue of each truck on tender 11
            $tns = [];
            foreach ($data as $record) {
                $tns[] = $record->tn_only;
            }

            $queueFilter = [
                ['key' => 'tender_id', 'val' => 11],
                ['key' => 'q_id', 'val' => 1],
                ['key' => 'rank', 'op' => 'is not null'],
                ['key' => 'tn', 'val' => $tns, 'op' => 'in']
            ];
            $queueResult = $this->_queueCore->searchQueue($queueFilter, 10000, 0, $_SESSION['user_id']);
            foreach ($data as &$record) {
                $record->rank = "-";
                foreach ($queueResult->data as $mg_record) {
                    if (trim($record->tn_only) == $mg_record->tn) {
                        $record->rank = $mg_record->rank;
                    }
                }
            }

            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------- //
    // ---- Map jo petrol items ---------- //
    // ----------------------------------- //
    private function converJoPetrolItemNumber($item_number)
    {
        $item_number = trim($item_number);
        $items = [];
        $items['10117'] = 'Gasoline Octane 90';
        $items['10118'] = 'Gasoline Octane 95';
        $items['10120'] = 'Gasoline Octane 98';
        $items['10201'] = 'Jet Fuel ( JET A-1 )';
        $items['10202'] = 'Jet Fuel (JP-8)';
        $items['10301'] = 'Kerosine';
        $items['10401'] = 'Diesel';
        $items['10402'] = 'Super Diesel';
        $items['10117'] = 'Gasoline Octane 90';
        $items['10401'] = 'Diesel';
        $items['10411'] = 'Diesel Euro 3';
        $items['11201'] = 'Liquified Petroleum Gas';
        $items['BASE OIL 230N'] = 'Base Oil 230N';
        $items['SN500']    = 'Base Oil SN500';
        $items['10501']    = 'crude oil';

        return $items[$item_number];
    }


    // ------------------------------------------------------------- //
    // ---------------- Date and time convertion ------------------- //
    // ------------------------------------------------------------- //
    private function convertToDate($jDate)
    {
        if ($jDate) {
            $Day = $jDate % 1000;
            $Day = $Day - 1;
            $Year = (($jDate - $Day + 2000000) / 1000) - 100;
            $result =  date('Y-m-d', strtotime($Year . '-1-1' . " + $Day days"));
            return $result;
        } else {
            return "";
        }
    }

    // --------------------------------------------------------------------------------------- //
    // ------------------- search for Completed Claim Report  ----------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function completedClaimReport()
    {
        try {
            $data = new stdClass();

            // inject the pa_id filter
            $allow = false;
            if ($_SESSION['type'] == "CORPORATE" && $_SESSION['pa_id'] == 2) {
                $allow = true;
                $data->filter = $this->_request->filter;
            } else if ($_SESSION['type'] == "CORPORATE") {
                if (gettype($this->_request->filter) == "string") {
                    $this->_request->filter = json_decode($this->_request->filter);
                    if ($_SESSION['pa_id'] && $_SESSION['pa_id'] != 2) {
                        $this->_request->filter->pa_id = $_SESSION['pa_id'];
                        $allow = true;
                    }
                    $this->_request->filter = json_encode($this->_request->filter);
                    $data->filter = $this->_request->filter;
                }
            } else {
                $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                foreach ($userRolesArray as $role) {
                    if ($role == 'OPERATION_MANAGER') {
                        $allow = true;
                    }
                }
            }


            if ($allow) {
                $claims = $this->_fps->searchCompletedClaimReport($data, $_SESSION['user_id']);
                parent::response($claims);
            } else {
                throw new Exception("لا تستطيع مشاهدة المطالبات");
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function truck_registration_report_as_truck_contracts()
    {
        try {
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;
            // dump($this->_request);die;
            $sqlQuery = "SELECT
                        t.tn,
                        t.trn,
                        tc.name as company_name,
                        u.name,
                        a.activity_date
                    FROM
                        tender_truck_view t,
                        activity a,
                        user u,
                        tender_company_view tc
                    WHERE
                        t.tender_id = 3
                    AND a.tender_truck_id = t.id
                    AND a.activity_date >= date(?)
                    AND a.activity_date < date(?)
                    AND a.action_code = 'CREATE'
                    and a.u_id = u.id
                    and t.tender_company_id = tc.id";
            $param = [$date_from, $date_to];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            // dump($result);die;
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    public function claim_commission_report()
    {
        try {
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;
            $tender_id = $this->_request->tender_id;

            // dump($this->_request);die;
            $sqlQuery = "SELECT t.id,
                            date( t.create_date) as create_date,
                            sum(i.requested_freight->>'$.tc_commission')as tc_commission,
                            sum(i.requested_freight->>'$.loss_in_kg')as loss_in_kg,
                            sum( i.requested_freight->>'$.total_fines')as total_fines,
                            sum(i.requested_freight->>'$.net_amount')as net_amount,
                            sum(i.requested_freight->>'$.tolerance_in_kg')as tolerance_in_kg,
                            count(i.id)as number_of_items
                            FROM waybill.tender_claim_view t
                            join
                            tender_claim_item i on (i.tender_claim_id=t.id and i.status !='INACTIVE') where
                            tender_id=? and
                            claim_details->>'$.claim_type'='waybill_claim'
                            and t.status !='INACTIVE'
                            and t.create_date>=?
                            and t.create_date <?
                            group by t.id
                            order by t.id";
            $param = [$tender_id, $date_from, $date_to];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            foreach ($result as $key => &$value) {
                $value->tc_commission = number_format(doubleval($value->tc_commission), 3, '.', '');
                $value->total_fines = number_format(doubleval($value->total_fines), 3, '.', '');
                $value->net_amount = number_format(doubleval($value->net_amount), 3, '.', '');
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }




    public function destinationWithoutRouteWageReport()
    {
        try {
            $date_from = $this->_request->date_from;
            $date_to = $this->_request->date_to;
            $tender_id = $this->_request->tender_id;

            $sqlQuery = " select
            distinct(w.document->>'$.cargo[0].cargo.name') as cargo,
            w.document->>'$.negotiable_instructios.route.origin.name' as origin,
            w.document->>'$.negotiable_instructios.route.destination.name' as destination,
            (select max(id) from route_wage r where r.cargo_id = w.document->>'$.cargo[0].cargo.id'
                                                      and r.destination_id = w.document->>'$.negotiable_instructios.route.destination.id'
                                                      and r.status = 'ACTIVE'
                                                      and r.start_date < w.create_date
                                                      and r.end_date > w.create_date
                                                      ) as r_id,
                    count(w.id) as num_of_waybills
            from waybill w
            where
            w.tender_id = ?
            and status not in ('INACTIVE','REVOKED')
            and w.create_date >= ?
            and w.create_date < ?
            group by cargo , origin , destination ,  r_id
            order by 1,2,3";

            $param = [$tender_id, $date_from, $date_to];
            $queryResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $items = [];
            foreach ($queryResult as $row) {
                if (!$row->r_id) {
                    $items[] = $row;
                }
            }

            $result = [];
            $result['data'] = $items;
            $result['found_rows'] = sizeof($items);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------- //
    // ----------------- Report to get how many declaration each ca has created ---------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getCargoPolicySubmitSummeryReport()
    {

        try {
            $create_from = $this->_request->create_from;
            $create_to = $this->_request->create_to;
            $tender_id = $this->_request->tender_id;
            $ca_id = $this->_request->ca_id;

            // validate auth
            $caFilter = [];
            $clearingAgents = $this->_clearingAgentCore->searchClearingAgent($caFilter, 1000, 0, $_SESSION['user_id']);
            $allowed_ca = [];
            foreach ($clearingAgents->data as $ca) {
                $allowed_ca[] = $ca->id;
            }
            $allowed_ca = implode(",", $allowed_ca);

            // run query

            $sqlQuery = " SELECT
                            p1.ca_id,
                            p1.ca_name,
                            COUNT(DISTINCT (p1.declaration_number)) AS declaration_number,
                            COUNT(p1.id) AS `number_of_containers`,
                            (select count(id) from cargo_policy_view p2 where p2.ca_id = p1.ca_id and status ='APPROVED'
                                                                        and p2.create_date > min(p1.create_date)
                                                                        and p2.create_date <= max(p1.create_date) ) as `number_of_submitted_containers`
                        FROM
                            cargo_policy_view p1
                        WHERE
                            policy_id IN (SELECT
                                    id
                                FROM
                                    policy
                                WHERE
                                    ca_id in ($allowed_ca) )
                        AND p1.ca_id IS NOT NULL
                        AND p1.status != 'INACTIVE'";

            if ($create_from) {
                $sqlQuery  .= " and create_date >= ?";
                $param[] = $create_from;
            }

            if ($create_to) {
                $sqlQuery  .= " and create_date < ?";
                $param[] = $create_to;
            }

            if ($ca_id) {
                $sqlQuery  .= " and ca_id = ?";
                $param[] = $ca_id;
            }
            $sqlQuery  .= " GROUP BY p1.ca_id , p1.ca_name";

            $queryResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);



            $items = [];
            foreach ($queryResult as $row) {
                if (!$row->r_id) {
                    $items[] = $row;
                }
            }

            $result = [];
            $result['data'] = $items;
            $result['found_rows'] = sizeof($items);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------------- Report to get how many declaration each ca has created ---------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getContainerCloseTripsSummaryReport()
    {
        try {
            $date_from = $this->_request->create_from;
            $date_to = $this->_request->create_to;
            $tender_id = $this->_request->tender_id;
            $shipping_line_code = $this->_request->shipping_line_code;

            // validate auth

            // search for land trips
            $userFilter = ['trip_end_from' => $date_from, 'trip_end_from' => $date_to, 'shipping_line_code' => $shipping_line_code];
            $data = new stdClass();
            $data->filter = $userFilter;
            $data->limit = 1000;
            $data->offset = 0;
            $con = new Container();
            $landTripsResult = $con->searchLandTrip($data, $_SESSION['user_id']);

            //group each land trip to shipping line
            $landTrips = [];
            foreach ($landTripsResult['data'] as $landTrip) {
                $document = json_decode($landTrip['document']);
                $landTrips[$landTrip['shipping_line_code']]['number_of_container']++;
                $landTrips[$landTrip['shipping_line_code']]['amount'] += $document->demurrage->net_amount;
                $landTrips[$landTrip['shipping_line_code']]['close_date'] = $document->destination->arrive->ts;
                $landTrips[$landTrip['shipping_line_code']]['shipping_line_name'] = $document->shipping_line->name;
            }

            $rawData = [];
            foreach ($landTrips as $object) {
                $tempRow = [];
                $tempRow['number_of_container'] = $object['number_of_container'];
                $tempRow['amount'] = $object['amount'];
                $tempRow['close_date'] = $object['close_date'];
                $tempRow['shipping_line_name'] = $object['shipping_line_name'];

                $rawData[] = $tempRow;
            }

            $result = [];
            $result['data'] = $rawData;
            $result['found_rows'] = sizeof($rawData);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of delayed checks by date ---------------------- //
    // ------------------------------------------------------------------------------- //
    public function searchPostDatedCheckReport()
    {
        // get user inouts
        $due_date_from = json_decode($this->_request->filter)->due_date_from;
        $due_date_to = json_decode($this->_request->filter)->due_date_to;

        // validate input
        if (!$due_date_from || !$due_date_to) {
            throw new Exception("التاريخ غير صحيح");
        }

        // search for vouchers
        $searchFilter = [
            ['key' => "status", 'val' => "NEW"],
            ['key' => "payment_method", 'val' => "CHECK"],
            ['key' => 'due_date', 'val' => $due_date_to, 'op' => 'less than'],
            ['key' => 'due_date', 'val' => $due_date_from, 'op' => 'greater than'],

        ];
        $vouchers = $this->_voucherCore->searchVouchers($searchFilter, 10000, 0, $_SESSION['user_id']);

        $result = [];
        $result['data'] = $vouchers->data;
        $result['found_rows'] = sizeof($vouchers->data);
        parent::response($result);
    }


    //   report name  "تقرير البيانات الجمركية"
    public function getDeclarationSummeryReport()
    {
        $data = new stdClass();
        $data->ca_id = $this->_request->ca_id;
        $data->create_from = $this->_request->create_from;
        $data->create_to = $this->_request->create_to;
        $tender_id = $this->_request->tender_id;

        // validate auth
        $this->hasAuthToViewReport($tender_id, 'declaration_summary_report');

        $response = $this->_con->getDeclarationSummeryReport($data, $_SESSION['user_id']);
        parent::response($response);
    }

    // report name  "تقرير ملخص انجاز البونات"
    public function getLandTripSummary()
    {
        $data = new stdClass();
        $data->ca_id = $this->_request->ca_id;
        $data->declaration_number = $this->_request->declaration_number;
        $data->create_from = $this->_request->create_from;
        $data->create_to = $this->_request->create_to;
        $tender_id = $this->_request->tender_id;

        // validate auth
        $this->hasAuthToViewReport($tender_id, 'land_trip_summary_report');

        $response = $this->_con->getLandTripSummary($data, $_SESSION['user_id']);

        parent::response($response);
    }

    // report name  "تقرير الحاويات الغير منجزة"
    public function getMissingDeliveryBondService()
    {
        $ca_id = $this->_request->ca_id;
        $create_from = $this->_request->create_from;
        $create_to = $this->_request->create_to;
        $tender_id = $this->_request->tender_id;

        // include date to
        if (strpos($create_to, ':') == false) {
            $create_to = $create_to . " 23:59:59";
        }


        // validate auth
        $this->hasAuthToViewReport($tender_id, 'missing_delivery_bond_service_report');

        // search for declaration
        $filter = [];
        if ($create_from) {
            $filter[] = ['key' => 'create_date', 'val' => $create_from, 'op' => 'date greater than'];
        }
        if ($create_to) {
            $filter[] = ['key' => 'create_date', 'val' => $create_to, 'op' => 'date less than'];
        }
        if ($ca_id) {
            $filter[] = ['key' => 'ca_id', 'val' => $ca_id];
        }

        // call container API
        $data = new stdClass();
        $data->filter = $filter;
        $data->limit = 1000;
        $result = $this->_con->getMissingDeliveryBondService($data, $_SESSION['user_id']);

        parent::response($result);
    }


    public function crudeOilMultiload()
    {
        $data = new stdClass();
        $tender_id = $this->_request->tender_id;

        $this->hasAuthToViewReport($tender_id, 'crude_oil_multi_load');

        $query = 'select q.rank, q.serial, q.driver_name, q.tn,p.result->>"$.PERMIT_TYPE" PERMIT_TYPE, q.create_date q_date, p.result->>"$.CREATE_DATE" p_date, w.create_date w_date
            from waybill.queue_view q
            join reg.naf_permits p
                on p.tn=q.tn
                    and q.create_date < p.result->>"$.CREATE_DATE"
                    and p.result->>"$.PERMIT_TYPE" not like "%النفط الخام%"
            left join waybill.waybill w
                on q.truck_id = w.truck_id
                    and w.create_date>q.create_date
                    and w.tender_id!=11
            where q.tender_id=11
                and q.rank is not null';
        $response =  DBConnection::runDatabaseQuery($query);

        parent::response($response);
    }


    public function searchWaybillDischargeReport()
    {

        //prepareFilter
        $filter  = $this->_request->filter;
        $filter = $this->prepareFilter($filter);
        $tender_id = $this->_request->tender_id;

        if ($filter === [] || sizeof($filter) === 0) {
            throw new Exception('الرجاء تعبئة الحقول ');
        }
        // to do
        //$this->hasAuthToViewReport($tender_id, 'waybill_discharge_report');

        $waybills =  $this->_waybillCore->searchWaybills($filter, 3000, 0, $_SESSION['user_id'], "order by id desc");

        $response = [];
        foreach ($waybills->data as $waybill) {
            $temp = new stdClass();

            $temp->id = $waybill->id;
            $temp->wn = $waybill->wn;

            $document = json_decode($waybill->document);

            if (isset($document->cargo)) {
                $temp->cargo_name            = $document->cargo[0]->cargo->name;
            }

            if (isset($document->carrier)) {
                $temp->tn                    = $document->carrier[0]->truck->tn;
                $temp->trn                   = $document->carrier[0]->trailer->tn;
                $temp->driver_name           = $document->carrier[0]->driver->name;
                $temp->driver_phone          = $document->carrier[0]->driver->phone;
            }

            if (isset($document->negotiable_instructios)) {
                $temp->destination           = $document->negotiable_instructios->route->destination->name;
            }

            if (isset($document->discharge_report)) {
                $temp->discharge_report_name = $document->discharge_report->done_by_name;
                $temp->discharge_report_date = $document->discharge_report->time_stamp;
                $temp->attachments           = $document->discharge_report->attachments;
                $temp->remarks               = $document->discharge_report->remarks;
            }

            $response[] = $temp;
        }
        parent::response($response);
    }


    public function getPrintedJCDPermitOutMG()
    {

        //prepareFilter
        $create_date_from  = $this->_request->create_date_from;
        $create_date_to  = $this->_request->create_date_to;
        $print_type  = $this->_request->print_type;

        // search in last land trip for this tn
        $data = new stdClass();
        $data->limit = 1000;
        $data->filter = [];
        $data->filter[] = ['key' => 'create_date', 'val' => $create_date_from, 'op' => 'date greater than'];
        $data->filter[] = ['key' => 'create_date', 'val' => $create_date_to, 'op' => 'date less than'];
        if ($print_type) {
            $data->filter[] = ['key' => 'print_type', 'val' => $print_type];
        }

        $data->method = "getPrintedJCDPermitOutMG";
        $end_point = '/landtrip';
        $landTripResult = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        foreach ($landTripResult['data'] as &$r) {
            if ($r['print_type'] == "e_bond") {
                $r['print_type'] = "الكتروني";
            } else {
                $r['print_type'] = "يدوي";
            }
        }

        parent::response($landTripResult);
    }

    // --------------------------------------------------------------------------------------------------------- //
    // --------------------- search for waybills to show waybill/loading/discharge/expected  ------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function searchWaybillSummaryPermit()
    {
        // parse incoming params
        $tender_id = $this->_request->tender_id;
        $cargo_ids = explode(",", $this->_request->cargo_ids);
        $cargo_ids[] = 0;

        // search for waybills
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'cargo_id', 'val' => $cargo_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in']
        ];
        $order_by = " order by loading_date ";
        $waybillResult = DBConnection::searchReport("waybill", "01", $waybillFilter, 10000, 0, $_SESSION['user_id'], $order_by);


        // collect waybill info
        $result = [];
        foreach ($waybillResult->data as $wbl) {
            $result[$wbl->cargo]["wbl"]++;
            $result[$wbl->cargo]["cargo_id"] = $wbl->cargo_id;

            if ($wbl->loading_weight && $wbl->loading_weight > 0) {
                $result[$wbl->cargo]["total_loading_weight"] += $wbl->loading_weight;
                $result[$wbl->cargo]["loading_cnt"]++;
            }

            if ($wbl->discharge_weight && $wbl->discharge_weight > 0)
                $result[$wbl->cargo]["discharge_cnt"]++;
        }



        // caclculate waybill avg weight
        foreach ($result as $cargoName => &$cargoRaw) {
            $cargoBean = $this->_cargoCore->getCargoBasic($cargoRaw["cargo_id"], 0);
            $cargoRaw['vessel_name'] =  $cargoBean->vessel_name;
            $cargoRaw['cargo_weight'] =  $cargoBean->weight_total;
            $cargoRaw['loading_percent'] =  round(($cargoRaw["total_loading_weight"] / $cargoRaw['cargo_weight']) * 100, 1) . "%";

            $cargoRaw['remaining'] =  $cargoRaw['cargo_weight'] - $cargoRaw["total_loading_weight"];
            if ($cargoRaw['remaining'] < 0) $cargoRaw['remaining'] = 0 . " طن";
            else $cargoRaw['remaining'] = ($cargoRaw['remaining'] / 1000)  . " طن";

            $cargoRaw['loading_avg'] = round(($cargoRaw['total_loading_weight'] / $cargoRaw['loading_cnt']) / 1000, 2);
            $cargoRaw['expected']  = round(($cargoRaw['cargo_weight'] / 1000) / $cargoRaw['loading_avg']);
            $cargoRaw['cargo_name']  = $cargoName;
            $cargoRaw["total_loading_weight"] = ($cargoRaw["total_loading_weight"] / 1000) . " طن ";
            $cargoRaw["loading_avg"] = $cargoRaw["loading_avg"] . " طن ";
            if (!$cargoRaw["discharge_cnt"]) $cargoRaw["discharge_cnt"] = 0;

            $cargoRaw["cargo_weight"] = $cargoRaw["cargo_weight"] . " طن ";
        }

        parent::response(array_values($result));
    }

    // $expectedWaybills = round($cargoWeight / $avgWaybillWeight);
    // default 39000
    public function getVesselLoadingCompletePercentage()
    {
        //prepareFilter
        $vessel_visit_id  = $this->_request->vessel_visit_id;

        $cargos = $this->_cargoCore->searchVessle([
            ['key' => 'vessel_visit_id', 'val' => $vessel_visit_id],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ], 500, 0, $_SESSION['user_id']);

        if ($cargos->found_rows <= 0) {
            throw new Exception('لا يوجد احمال على هذه الباخرة', 400);
        }

        $cargos_ids = array_map(function ($a) {
            return $a->id;
        }, $cargos->data);

        // first  expected waybills on the vessel
        $avgWaybillWeight = 39000;

        // calculate the avgWaybillWeight by search in waybills by cargo_ids and get the avg weight of them
        $search_filter = [
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ["ONROAD", "CLOSED", "COMPLETE", "ARRIVED"], 'op' => 'in']
        ];

        $waybills = DBConnection::searchReport('waybill', '01', $search_filter, 800, 0, $_SESSION['user_id']);
        if ($waybills->found_rows > 0) {
            $avgWaybillWeight = array_sum(array_map(function ($e) {
                return (isset($e->loading_weight) && $e->loading_weight > 0) ? $e->loading_weight : 0;
            }, $waybills->data)) / $waybills->found_rows;
        }
        $cargoWeight = array_sum(array_map(function ($ele) {
            return $ele->weight_total;
        }, $cargos->data));

        $expectedWaybills = round($cargoWeight / $avgWaybillWeight);

        $response = [];
        $response[] = ['', 0];
        $response[] = ['مستند الباخرة المتوقعة', $expectedWaybills];
        $response[] = ['المستندات المحملة  ', $waybills->found_rows];

        // search waybill order 
        $waybill_orders = $this->_waybillOrderCore->searchWaybillOrder([
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in']
        ], 1000, 0, $_SESSION['user_id']);
        $response[] = [' اوامر الحركة', $waybill_orders->found_rows];


        $waybill_orders = $this->_waybillOrderCore->searchWaybillOrder([
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ['CLOSED', 'APPROVED'], 'op' => 'in']
        ], 1000, 0, $_SESSION['user_id']);

        $response[] = [' اوامر الحركة المكتملة و الموافق عليها', $waybills->found_rows];

        $search_filter = [
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
        ];

        $waybills = DBConnection::searchReport('waybill', '01', $search_filter, 800, 0, $_SESSION['user_id']);
        $response[] = ['المستندات ', $waybills->found_rows];
        parent::response($response);
    }


    // --------------------------------------------------------------------------------------------------------- //
    // --------------------- this function to get all waybill count report by given period of time  ------------------- //
    // --------------------------------------------------------------------------------------------------------- //

    public function getWaybillCountReport()
    {
        $group_by = $this->_request->group_by;
        $start_date = $this->_request->start_date;
        $end_date = $this->_request->end_date;
        $date_format = '';

        if ($group_by == "month") {
            $date_format = '%Y-%m';
        } elseif ($group_by == "day") {
            $date_format = '%Y-%m-%d';
        } elseif ($group_by == "year") {
            $date_format = '%Y';
        }

        $sql_query = "SELECT count(id) as count , document->>'$.tender.name' as tender_name,
                        date_format(create_date, ?)  as date FROM waybill.waybill
                                WHERE status not in ('inactive','revoked')
                            and tender_id is not null
                            and document->>'$.tender.name' is not null
                            and create_date > ?
                            and create_date < ?
                            group by  document->>'$.tender.name',
                        date_format(create_date, ?) ";
        // $res = DBConnection::runDatabaseQuery($sql_query);2021-01-01

        $res = DBConnection::runBindDatabaseQuery($sql_query, [$date_format, $start_date, $end_date, $date_format]);
        parent::response($res);
    }

    public function getCumulativeVesselPerformance()
    {
        // get user input
        $vessel_visit_id  = $this->_request->vessel_visit_id;

        // get cargos on vessel
        $vessel_cargo = $this->_cargoCore->searchVessle([
            ['key' => 'vessel_visit_id', 'val' => $vessel_visit_id],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ], 500, 0, $_SESSION['user_id']);
        if ($vessel_cargo->found_rows <= 0) {
            throw new Exception('الباخرة غير صحيحة', 500);
        }

        // get how many days the vessel existed on the port
        $vesselBean = $this->_vesselCore->getVesselVisit($this->_request->vessel_visit_id, $_SESSION['user_id']);
        $startDate = new DateTime($vesselBean->ATA);
        $endDate   = new DateTime($vesselBean->ETD);
        $daysDifference = ($startDate->diff($endDate)->days);
        $vesselExistanceDays = [];
        $vesselExistanceDays[] = $vesselBean->ATA;

        for ($i = 1; $i <= $daysDifference; $i++) {
            $vesselExistanceDays[] = date('Y-m-d', strtotime($vesselBean->ATA . " + $i days"));
        }

        // expected waybills
        $avgWaybillWeight = 39000;
        $cargos_ids = array_map(function ($a) {
            return $a->id;
        }, $vessel_cargo->data);
        $search_filter = [
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ["ONROAD", "CLOSED", "COMPLETE", "ARRIVED"], 'op' => 'in']
        ];
        $waybills = DBConnection::searchReport('waybill', '01', $search_filter, 800, 0, $_SESSION['user_id']);
        if ($waybills->found_rows > 0) {
            $avgWaybillWeight = array_sum(array_map(function ($e) {
                return (isset($e->loading_weight) && $e->loading_weight > 0) ? $e->loading_weight : 0;
            }, $waybills->data)) / $waybills->found_rows;
        }
        $cargoWeight = array_sum(array_map(function ($ele) {
            return $ele->weight_total;
        }, $vessel_cargo->data));

        $expectedWaybills = round($cargoWeight / $avgWaybillWeight);

        $result = [];
        // start counting in each day (waybill_order , approved WO, waybills, loading_waybills)
        $header = [];
        $header[] = ["التاريخ", "المستندات المتوقعة", "اوامر الحركة", "اوامر الحركة المقبولة", "المستندات", "المستندات المحملة"];
        $result[] = $header;

        // get all waybills in the vesselExistanceDays
        $search_filter = [
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'create_date', 'val' => date_format(date_create($vesselBean->ATA),'Y-m-d'), 'op' => 'date greater than'],
            ['key' => 'status', 'val' => ['INACTIVE', 'REJECTED','REVOKED'], 'op' => 'not in']
        ];
        $waybills = DBConnection::searchReport('waybill', '01', $search_filter, 10000, 0, $_SESSION['user_id']);

        // get all waybill order in the vesselExistanceDays
        $waybill_orders = $this->_waybillOrderCore->searchWaybillOrder([
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'create_date', 'val' => date_format(date_create($vesselBean->ATA),'Y-m-d'), 'op' => 'date greater than'],
        ], 10000, 0, $_SESSION['user_id']);

        // start looping to sort w and wo
        foreach ($vesselExistanceDays as $d) {

            $d_endDate   = new DateTime($d);

            // expected waybills
            $temp = [];
            $temp[] = $d;
            $temp[] = $expectedWaybills;

            // search all waybill order in this day
            $allWo = [];
            foreach ($waybill_orders->data as $wo) {
                $wo_startDate = new DateTime($wo->create_date);
                if ($d_endDate >= $wo_startDate) {
                    $allWo[] = $wo;
                }
            }
            $temp[] = sizeof($allWo);

            // search approved waybill order in this day
            $app_wo = [];
            foreach ($waybill_orders->data as $awo) {
                $awo_startDate = new DateTime($wo->create_date);
                if ($d_endDate >= $awo_startDate) {
                    if ($awo->status == "CLOSED" || $awo->status = "APPROVED") {
                        $app_wo[] = $awo;
                    }
                }
            }
            $temp[] = sizeof($app_wo);

            // search all waybill in this day
            $allW = [];
            $allW2 = [];
            foreach ($waybills->data as $w) {
                $w_startDate = new DateTime($w->create_date);
                if ($d_endDate >= $w_startDate) {
                    $allW[] = $w;
                }else{
                    $allW2[] = $w;
                }
            }
            $temp[] = sizeof($allW);

            // search loaded waybill in this day
            $loaded_w = [];
            foreach ($waybills->data as $lw) {
                $lw_startDate = new DateTime($lw->loading_date);
                if ($d_endDate >= $lw_startDate && $lw->loading_weight) {
                    $loaded_w[] = $w;
                } 
            }
            $temp[] = sizeof($loaded_w);
            $result[] = $temp;
        }

        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------------------- //
    // --------------------- this function to get CA landtrip services per month  ------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function getCaMonthlyLandTripServiceReport()
    {

        $data = new stdClass();
        $data->filter = ['create_from' => $this->_request->date_from . '-' . '01' . '-' . '01', 'create_to' => $this->_request->date_from . '-' . '12' . '-' . '31' . ' 11:59:59'];
        $company_and_land_trip_services = [];
        $company_and_land_trip_services = [
            "ca_name" => "",
            "01" => '--', "02" => '--', "03" => '--', "04" => '--', "05" => '--', "06" => '--', "07" => '--', "08" => '--', "09" => '--', "10" => '--', "11" => '--', "12" => '--',
            "avg" => 0,
        ];
        $months = ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];
        foreach ($months as $month) {
            if ("2022" . $month < '202204') {
                $company_and_land_trip_services[$month] = '--';
            } else
                if (date('m') > $month) {
                $company_and_land_trip_services[$month] = 0;
            } else {
                $company_and_land_trip_services[$month] = '--';
            }
        }
        // dump($company_and_land_trip_services);die;
        $res = [];
        $reportResult = $this->_con->getCaMonthlyLandTripServiceReport($data, $_SESSION['user_id']);

        // iterate through the report
        foreach ($reportResult['data'] as &$ele) {
            $dateValue = explode("-", $ele['create_date']);
            $companyExist = false;

            // if the company exist add the current service count to the previous
            foreach ($res as &$val) {
                if ($ele['ca_name'] == $val['ca_name']) {
                    $companyExist = true;
                    if (gettype($val[$dateValue[1]]) == 'integer') {
                        $val[$dateValue[1]] += $ele['service_count'];
                    }
                }
            }

            // add company to the response if its not exist
            if (!$companyExist && $dateValue[0] . $dateValue[1] >= '202204' && $dateValue[0] . $dateValue[1] < date('Y') . date('m')) {

                $company_and_land_trip_services['ca_name'] = $ele['ca_name'];
                $company_and_land_trip_services[$dateValue[1]] = intval($ele['service_count']);
                $res[] = $company_and_land_trip_services;
            }
        }

        // calculate the averege services
        foreach ($res as &$ele) {
            $sum = 0;
            $count = 0;
            foreach ($ele as $key => $element) {

                if ((date('m') > $key) && '2022' . $key >= '202204') {
                    $sum += $element;
                    $count += 1;
                }
            }
            if ($count != 0) {
                $ele['avg'] = $sum / $count;
                $sum = 0;
                $count = 0;
            }
        }
        foreach ($res as $element) {
            asort($element);
        }
        parent::response($res);
    }
}


new Report_interface();
