<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/registration_core.php");

class Registration_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_registrationCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_registrationCore = new RegistrationCore();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- Get grains Permit from nafith system for a certain truck ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function getNafithGrainPermit(){

        $tn = $this->_request->tn;

        if(!$tn){
            throw new Exception("TN is required");            
        }        
        $nafith_info = $this->_registrationCore->getNafithGrainsPermit($tn);

        if($nafith_info){                   
            parent::response($nafith_info);
        }else{
            throw new Exception("لا توجد معلومات متوفرة");            
        }
    }

   


}


$registration_interface = new Registration_interface();

