<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/Reg_DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");


class RegistrationCore {
    
    public function __construct(){
        Reg_DBConnection::getInstance();
    }


    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- Get grains Permit from nafith system for a certain truck ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function getNafithAsezaPermit($tn){        
        $db_query = "SELECT pn,tn,
                            CAST(`result` AS CHAR CHARSET UTF8) AS result,
                            pn_date,
                            `create`
                    FROM reg.naf_permits 
                        where pn_date>now()-INTERVAL 48 HOUR 
                        and tn=? 
                        and result->>'$.CT'='GRNS' 
                        order by 1 desc 
                    limit 1";
        $params = [$tn];

        $nafith_info = Reg_DBConnection::runBindDatabaseQuery($db_query,$params);

        if(sizeof($nafith_info) > 0){

            $result = json_decode($nafith_info[0]->result);
            $result->PN_CREATE_DATE = $nafith_info[0]->pn_date;
            return $result;
        }
        
        return null;

    }

    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- update grains table in reg to connect nafith pn and MG  ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function updateGrainsRecord($id , $wn , $nafith_pn){        

        $result = ["nafith_pn" => $nafith_pn , 
                   "MG_wn" => $wn];
        
        $db_query = "update reg.grns set mg_result = ? where id = ?";
        $params = [json_encode($result) , $id];
        $nafith_info = Reg_DBConnection::runBindDatabaseQuery($db_query,$params);
       
    }


    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- search grains Permit from nafith system for a certain truck ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function searchNafithGrainPermit($filter , $limit=1){        
        $db_query = "SELECT id,
                            CAST(`result` AS CHAR CHARSET UTF8) AS result,
                            CAST(`mg_result` AS CHAR CHARSET UTF8) AS mg_result
                    FROM reg.grns 
                    where `create`>now()-INTERVAL 24 HOUR ";
                 
        foreach ($filter as $key => $f) {      
            $params = [$f['value']];               
            $db_query .= " and result->>'$." . $f['key'] ."'=? ";
        }
        
        $db_query .= "order by 1 desc limit $limit";        

        $nafith_info = Reg_DBConnection::runBindDatabaseQuery($db_query,$params);
        if(sizeof($nafith_info) > 0){
            $result = json_decode($nafith_info[0]->result);         
            return $result;
        }
        
        return null;

    }


    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- search grains Permit from nafith system for a certain truck ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function searchNafithGrainPermitReport($date_from , $date_to){        
        $db_query = "SELECT id,
                            CAST(`result` AS CHAR CHARSET UTF8) AS result,
                            CAST(`mg_result` AS CHAR CHARSET UTF8) AS mg_result,
                            `create`
                    FROM reg.grns 
                    where `create` >= ?
                    and `create` < ?
                    order by 1 desc";                 
      
        $params = [$date_from, $date_to];               
        $nafith_info = Reg_DBConnection::runBindDatabaseQuery($db_query,$params);

        $result = [];
        foreach ($nafith_info as $permit) {
            $temp = json_decode($permit->result);
            $temp->create_date = $permit->create;
            $result[] = $temp;
        }
 
        return $result;
    }


    // ------------------------------------------------------------------------------------------------------- //
    // ----------------------- get grains Permit from nafith system for a certain id ---------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function getNafithGrainsPermit($pn){        
        $db_query = "SELECT id,
                            CAST(`result` AS CHAR CHARSET UTF8) AS result
                            FROM reg.grns where id = ?";

        $nafith_info = Reg_DBConnection::runBindDatabaseQuery($db_query,[$pn]);
        if(sizeof($nafith_info) > 0){

            $result = json_decode($nafith_info[0]->result);         
            return $result;
        }
        
        return null;

    }

}