<?php
require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/queue_core.php";
require_once dirname(__FILE__) . "/../gateway/gateWay_core.php";
require_once dirname(__FILE__) . "/../truck/truck_core.php";
require_once dirname(__FILE__) . "/../user/user_core.php";
require_once dirname(__FILE__) . "/../tender/tender_core.php";
require_once dirname(__FILE__) . "/../notes/add_notes_core.php";
require_once dirname(__FILE__) . "/../taskQueues/taskQueues_core.php";
require_once dirname(__FILE__) . "/../waybill/waybill_core.php";
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/location/location_core.php");
require_once dirname(__FILE__) . "/../outgoing_integration/customer_care.php";
class Queue_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_queueCore;
    private $_gatewayCore;
    private $_truckCore;
    private $_userCore;
    private $_driverCore;
    private $_tenderCore;
    private $_taskQueuesCore;
    private $_waybillCore;
    private $_locationCore;
    private $_truckContractCore;
    private $_customerCare;
    public function __construct()
    {


        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_queueCore = new QueueCore();
        $this->_gatewayCore = new GatewayCore();
        $this->_truckCore = new TruckCore();
        $this->_userCore = new UserCore();
        $this->_driverCore = new DriverCore();
        $this->_tenderCore = new TenderCore();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_waybillCore = new WaybillCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_customerCare = new CustomerCare();
        $this->_locationCore = new LocationCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------------------- //
    // --------------------- get bean for certain truck on queue ------------------- //
    // ----------------------------------------------------------------------------- //
    public function getQueue()
    {

        // get the queue info
        $queue = $this->_queueCore->getQueue($this->_request->id, $_SESSION['user_id']);

        // merge queue info from table and view
        $queueSearchResult = $this->_queueCore->searchQueue([['key' => 'id', 'val' => $this->_request->id]], 1, 0,  $_SESSION['user_id']);
        $waybillOrderBean = new stdClass();
        $queueBean = (object) array_merge((array) json_decode($queue), (array) $queueSearchResult->data[0]);
        $queueBean->nn = $queueBean->driver_nn;

        // search for tender truck if it is pending
        $truck_id = $queueBean->truck_id;
        $tender_id = $queueBean->tender_id;
        $tenderSearchFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
        if ($tenderTruckResult->found_rows > 0) {
            $tender_truck = $tenderTruckResult->data[0];
            $queueBean->contract_status = $tender_truck->status;
        }

        if (!$queueBean->total_delay || $queueBean->total_delay == "") $queueBean->total_delay = 0;
        $queueBean->pending_trucks = $this->_queueCore->getPendingQueues($queueBean->tender_id, $queueBean->q_id, $queueBean->rank);

        if ($queueBean->tender_id == 3 && $queueBean->q_id == 2) {
            $queueBean->rankByCargo = $this->_queueCore->getQueueRankByCargos($queueBean->id, $queueBean->tender_id, $queueBean->q_id, $queueBean->rank);
        }


        $queueBean = json_encode($queueBean);
        parent::response($queueBean);
    }


    // ------------------------------------------------------------------------------------ //
    // --------------------- get list of held trucks on a certain queue ------------------- //
    // ------------------------------------------------------------------------------------ //
    public function searchHeldQueueTrucks()
    {

        $queueFilter = $this->prepareFilter();
        $queueResult = $this->_queueCore->searchQueue($queueFilter, $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);

        $date = new DateTime();
        $date->format('Y-m-d H:i:s');
        $date->sub(new DateInterval("PT" . $this->_request->held_hours . "H"));

        $sql = "SELECT
                    q.tn , max(a.activity_date) activity_date
                FROM
                    queue_view q,
                    activity a
                WHERE
                    a.queue_id = q.id AND q.status = 'HELD'
                        AND a.action_code = 'CHANGE_STATUS'
                        AND a.object_new_status_code = 'HELD'
                        and q.rank is not null
                        and a.activity_date < ?
                        group by tn";

        $params = [$date->format('Y-m-d H:i:s')];
        $heldResult = DBConnection::runBindDatabaseQuery($sql, $params);
        $tns = [];
        foreach ($heldResult as $heldRecord) {
            $tns[$heldRecord->tn] = $heldRecord->activity_date;
        }

        foreach ($queueResult->data as &$queue) {
            try {
                $queue->held_time_stamp = $tns[$queue->tn];
            } catch (Exception $e) {
            }
        }

        //return Success response
        parent::response($queueResult);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of trucks on a certain queue ------------------- //
    // ------------------------------------------------------------------------------- //
    public function searchQueueTrucks()
    {

        $queueFilter = $this->prepareFilter();

        if (!$this->_request->limit) {
            $this->_request->limit = 100;
        }

        $queueResult = $this->_queueCore->searchQueue(
            $queueFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // remove time from activation date
        $currentTime = DBConnection::getSystemDate();
        $index = 0;
        foreach ($queueResult->data as &$queue) {
            try {
                $date = date_create($queue->activation_date);
                $queue->activation_date = date_format($date, 'Y-m-d');

                $queue->server_date = $currentTime;

                if ($queue->tender_id == 13 && ($queue->q_id == 1 || $queue->q_id == 2 || $queue->q_id == 3 || $queue->q_id == 4)) {
                    unset($queueResult->data[$index]);
                }
                $index++;
            } catch (Exception $e) {
            }
        }



        $result = [];
        $result['data'] = [];
        foreach ($queueResult->data as $tempQueue) {
            array_push($result['data'], $tempQueue);
        }
        $result['found_rows'] = sizeof($result['data']);

        //return Success response
        parent::response($result);
    }


    private function prepareFilter()
    {
        $tenderFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                if ($key == "create_date_from") {
                    $tempArr = ['key' => 'activity_date', 'val' => $value, 'op' => 'greater than'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($tenderFilter, $tempArr);
            }
        };

        // if the tender list available for user not * (all tenders)
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderFilter, $temp);
        }


        // hide grains queue
        // $queueArr = [];
        // $queueArr[] = ['key' => 'tender_id', 'val' => '13'];
        // $queueArr[] = ['key' => 'q_id', 'val' => [1,2,3,4], 'op'=>'in'];
        // $queueArr[] = ['key' => 'rank','op'=>'is not null'];

        // $grainsQueue = $this->_queueCore->searchQueueTrucks($queueArr, 5000, 0, 0, ' order by id ');
        // if($grainsQueue->found_rows > 0){
        //     $ids = [];
        //     foreach ($grainsQueue->data as $q_data) {
        //         $ids[] = $q_data->id;
        //     }
        //     $temp = ['key' => 'id', 'val' => $ids, 'op' => 'not in'];
        //     array_push($tenderFilter, $temp);
        // }


        return $tenderFilter;
    }

    // ------------------------------------------------------------------------------------------------ //
    // --------------------- get list of queues as JSON format similar to WOQ search------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchQueueTrucksJSON()
    {

        if ($this->_request->filter) {
            $queueFilter = json_decode($this->_request->filter);
        } else if ($this->_request->ids) {
            $ids = explode(",", $this->_request->ids);
            $ids = implode("','", $ids);
            $queueFilter = [['key' => 'id', 'val' => [$ids], 'op' => 'in']];
        }


        // TEMP SOLUTION, DELETE IT ASAP
        $user_roles = explode(",", $_SESSION['USER_ROLES']);
        foreach ($user_roles as $role) {
            if ($role == "CLEARING_AGENT_MANAGER") {
                $tempArr = ['key' => "tender_id", 'val' => 13];
                $queueFilter[] = $tempArr;
            }
        }

        // search database
        $queueResult = $this->_queueCore->searchQueue(
            $queueFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // format the data in a way similar to JSON format in WOQ
        $data = [];
        foreach ($queueResult->data as $queue) {

            $queueObj = new stdClass();
            $queueObj->id = rand();
            $queueObj->object_code = 'QUEUE';
            $queueObj->object_id = $queue->id;
            $objectRecord = new stdClass();
            $objectRecord->id = $queue->id;
            $objectRecord->tn = $queue->tn;
            $objectRecord->trn = $queue->trn;
            $objectRecord->rank = $queue->rank;
            $objectRecord->status = $queue->status;
            $objectRecord->tc_name = $queue->trucking_company_name;
            $objectRecord->driver_nn = $queue->driver_nn;
            $objectRecord->contact_nn = $queue->contact_nn;
            $objectRecord->queue_name = $queue->queue_name;
            $objectRecord->create_date = $queue->create_date;
            $objectRecord->driver_name = $queue->driver->name;
            $objectRecord->tender_name = $queue->name;
            $objectRecord->contact_name = $queue->contact_name;
            $objectRecord->driver_phone = $queue->driver_phone;
            $objectRecord->contact_phone = $queue->contact_phone;
            $objectRecord->truck_owner_nn = $queue->truck_owner->nn; //TODO
            $objectRecord->truck_owner_name = $queue->truck_owner->name ? $queue->truck_owner->name : $queue->truck_owner_name;
            $objectRecord->truck_owner_phone = $queue->truck_owner->phone;

            $queueObj->object_record = json_encode($objectRecord, JSON_UNESCAPED_UNICODE);
            $queueObj->object_status = $queue->status;
            $queueObj->object_keys = null;
            $queueObj->create_date =  $queue->activity_date;
            $queueObj->search_text =  $queue->search_index;

            array_push($data, $queueObj);
        }

        $result['data'] = $data;
        $result['found_rows'] = $queueResult->found_rows;
        parent::response($result);
    }



    // ----------------------------------------------------------------------------------------- //
    // -------------------add new truck on queue  ---------------------------------------------- //
    // ------------------ Param: tn, queue_id, tender_id, [trn , phone_nn] --------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function addQueue()
    {

        // get the id of truck
        $searchFilter = [
            ['key' => 'tn', 'val' => $this->_request->tn],
            ['key' => 'cat', 'val' => ['TRUCK', 'TRUCK-SINGLE'], 'op' => "in"],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => "not in"]
        ];
        $truckResult = $this->_truckCore->searchTrucks($searchFilter, 1, 0, $_SESSION['user_id']);

        if ($truckResult->found_rows == 0) {
            throw new Exception("QUEUE.INVALID_TRUCK");
        }

        //get the id of trailer
        $trailer_id = null;
        if ($this->_request->trn) {
            $trnSearchFilter = [['key' => 'tn', 'val' => $this->_request->trn], ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"]];
            $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $_SESSION['user_id']);
            $trailer_id = $trailerResult->data[0]->id;
        }

        //get the id of driver if user typed nn
        if ($this->_request->phone_nn) {
            $driverBean = $this->_driverCore->driverAutoComplete($this->_request, $_SESSION['user_id']);
        }

        // insert the queue bean
        $id = $this->_queueCore->addQueue(
            $truckResult->data[0]->id,
            $driverBean->driver_id,
            $trailer_id,
            $this->_request->queue_id,
            $this->_request->tender_id,
            $_SESSION['user_id']
        );

        // check if there is auto action after create
        $autoAction = getAutoAction('QUEUE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->_queueCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "QUEUE.SUCCESS_ADD_TRUCK";
        $Result['ID'] = $id;
        parent::response($Result);
    }

    public function trailerAutoComplete()
    {

        $trnSearchFilter = [['key' => 'tn', 'val' => $this->_request->trn], ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"]];
        $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $_SESSION['user_id']);
        parent::response($trailerResult);
    }

    // ------------------------------------------------------------------------ //
    // -------------------edit truck info on a certain queue ------------------ //
    // ------------------- Param : [phone_nn,trn]
    // ------------------------------------------------------------------------ //
    public function updateQueue()
    {

        //get the id of driver if user typed nn or phone
        $driver_id = null;
        if ($this->_request->phone_nn) {
            $driverBean = $this->_driverCore->driverAutoComplete($this->_request, $_SESSION['user_id']);
            $driver_id = $driverBean->driver_id;
        }

        //get the id of trailer
        $trailer_id = null;
        if ($this->_request->trn) {
            $trnSearchFilter = [['key' => 'tn', 'val' => $this->_request->trn], ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"]];
            $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $_SESSION['user_id']);
            $trailer_id = $trailerResult->data[0]->id;
        }

        // stop the update if the user want to update the trailer in crude_oil queue
        $queueBean = $this->_queueCore->getQueueBasic($this->_request->id, $_SESSION['user_id']);
        if ($queueBean->trailer_id != $trailer_id && $queueBean->tender_id == 11) {
            if ($_SESSION['u_id'] == 2 || $_SESSION['u_id'] == 475) {
                // allow me
            } else {
                throw new Exception("لا تستطيع المتابعة ، تغير رقم المقطورة غير مسموح في دور النفط الخام");
            }
        }

        // update DB record
        $updateBean = new stdClass();
        $updateBean->id = $this->_request->id;
        $updateBean->driver_id = $driver_id;
        $updateBean->trailer_id = $trailer_id;
        $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "QUEUE.SUCCESS_UPDATE";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------- //
    // -------------------activate, deactivate or freeze the queue -------- //
    // ------------------------------------------------------------------------- //
    public function changeStatus()
    {

        // get queue result
        $queueSearchResult = $this->_queueCore->searchQueue([['key' => 'id', 'val' => $this->_request->id]], 1, 0,  $_SESSION['user_id']);

        if ($this->_request->new_status == 'PENDING') {
            // validate if user did not exceede the delay limit
            $this->_queueCore->validateDelayQueue($this->_request->id, "PENDING", $this->_request->duration, $_SESSION['user_id']);
        }

        // -------------- Send notification to operation manager ------------------//
        if ($this->_request->new_status == 'INACTIVE') {

            $this->_queueCore->logActivity(
                $this->_request->id,
                "حذف عن الدور",
                "السبب: " . $this->_request->delete_reason . " - بواسطة: " . $_SESSION['u_id'],
                "ADD_NOTES",
                0
            );

            $queueSearchResult = $this->_queueCore->searchQueue([['key' => 'id', 'val' => $this->_request->id]], 1, 0,  $_SESSION['user_id']);
            $socialCore = new SocialCore();
            $done_by = $_SESSION['u_id'];
            $tn = $queueSearchResult->data[0]->tn;
            $wall_message = "تم حذف الشاحنة $tn  عن الدور من قبل الموظف $done_by ";
            $notification_message = "تم حذف الشاحنة $tn عن الدور ";
            $socialCore->informSupervisor('حذف شاحنة عن الدور', $wall_message, $notification_message);

            // send notification to driver
            try {
                $queueBean = $queueSearchResult->data[0];
                $driver_phone = $queueBean->driver_phone;
                $queue_name = $queueBean->queue_name;
                $sms_text = "$tn- تم حذف دور الشاحنة عن " . $queue_name;
                //$result = sendSMS($driver_phone,$sms_text);
                $driverFilter = [['key' => 'id', 'val' => $queueBean->driver_id]];
                $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);

                $sender_id = 266770;
                $sender_name =  "شركة مدارج للخدمات اللوجستية ";
                $body = $socialCore->createPostBody(
                    "حذف عن الدور",
                    "تم حذف دور الشاحنة رقم $tn عن $queue_name , السبب: " . $this->_request->delete_reason,
                    null,
                    $sender_id,
                    $sender_name
                );
                $this->_taskQueuesCore->createPostOnWallTask($driver_qry->data[0]->user_id, $body, "حذف عن الدور");
            } catch (Exception $e) {
            }
        }


        // Temp Solution ,
        if ($this->_request->new_status == 'PENDING' || $this->_request->new_status == 'ACTIVE') {
            if ($queueSearchResult->data[0]->tender_id == 11) {
                $allowDelay = false;
                $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                foreach ($userRolesArray as $role) {
                    if ($role == 'OPERATION_MANAGER' || $role == 'MINAGATE_OPERATION') {
                        $allowDelay = true;
                        break;
                    }
                }
                if (!$allowDelay) {
                    throw new Exception("لا تستطيع تأجيل أو فك تأجيل دور النفط الخام من التطبيق");
                }
            }
        }

        // stop user from activating his truck in case the tender_truck is PENDING
        if ($this->_request->new_status == 'ACTIVE') {
            $queueBean = $this->_queueCore->getQueueBasic($this->_request->id, $_SESSION['user_id']);
            // search for tender truck
            $tenderSearchFilter = [
                ['key' => 'truck_id', 'val' => $queueBean->truck_id],
                ['key' => 'tender_id', 'val' => $queueBean->tender_id],
                ['key' => 'status', 'val' => 'PENDING']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
            if ($tenderTruckResult->found_rows > 0) {
                throw new Exception('لا تستطيع المتابعة تم منع السيارة لمدة 48 ساعة بسبب انقضاء المدة الزمنية للحضور');
            }
        }

        // change queue status
        $trailerResult = $this->_queueCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        // update activation time
        if ($this->_request->new_status == 'HELD') {
            if ($this->_request->duration) {
                $duration = $this->_request->duration;
            } else {
                $duration = 3;
            }

            $updateBean = new stdClass();
            $updateBean->id = $this->_request->id;
            $updateBean->activation_date = date("Y-m-d", strtotime("+ " . $duration . " day"));
            $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);

            $this->_queueCore->logActivity(
                $this->_request->id,
                "تجميد الدور",
                "تم نجميد دور الشاحنة لمدة $duration يوم",
                "held_queue",
                $_SESSION['u_id']
            );
        }

        // update activation time and total delay
        if ($this->_request->new_status == 'PENDING') {

            if ($this->_request->duration) {

                $updateBean = new stdClass();
                $updateBean->id = $this->_request->id;
                $updateBean->activation_date = date("Y-m-d", strtotime("+ " . $this->_request->duration . " day"));
                $updateBean->total_delay = $this->_request->duration;

                // validate if user did not exceede the delay limit
                $this->_queueCore->validateDelayQueue($this->_request->id, "PENDING", $this->_request->duration, $_SESSION['user_id']);

                // revoke any NEW waybill_order for the same truck
                $waybill_order = new WaybillOrderCore();
                $waybillOrderCore = new WaybillOrderCore();
                $searchFilter = [
                    ['key' => 'truck_id', 'val' => $queueSearchResult->data[0]->truck_id],
                    ['key' => 'status', 'val' => ['NEW', 'WAITING'], 'op' => 'in']
                ];
                $newWaybillOrders = $waybill_order->searchWaybillOrder($searchFilter, 1, 0, 0);
                if ($newWaybillOrders->found_rows > 0) {
                    $waybill_order_id = $newWaybillOrders->data[0]->id;
                    $waybill_order->rejectWaybillOrder($waybill_order_id, 1, "", $_SESSION['user_id']);

                    //cancel the alarm on user mobile
                    $waybillOrderCore->cancelWaybillOrderNotification($waybill_order_id);

                    // refresh waybill_order mobile screen
                    $contact_user_id = $waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
                    $waybillOrderCore->sendWaybillOrderNotification($contact_user_id, $waybill_order_id, 'check_waybill_order');

                    //log activity
                    $this->_queueCore->logActivity(
                        $this->_request->id,
                        "تأجيل الدور",
                        "تم تأجيل دور الشاحنة لمدة $duration يوم",
                        "pending_queue",
                        $_SESSION['u_id']
                    );
                } else {
                    // change status of the queue
                    $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);
                }
            } else {
                throw new Exception("لا يمكن اكمال العملية ، لم يتم تحديد ايام التأجيل");
            }
        }

        // in case the user wants to activate the truck queue
        if ($this->_request->new_status == 'ACTIVE') {
            try {
                DBConnection::startTransaction();
                //return the remaining days to the truck queue
                $this->_queueCore->returnRemainingDelayDays($this->_request->id, $_SESSION['user_id']);

                // update activation time to null
                $updateBean = new stdClass();
                $updateBean->id = $this->_request->id;
                $updateBean->activation_date = null;

                $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);

                // log activity
                $this->_queueCore->logActivity(
                    $this->_request->id,
                    "فك تأجيل الدور",
                    "تم فك تأجيل الدور",
                    "activate_queue",
                    $_SESSION['u_id']
                );

                DBConnection::commitTransaction();
            } catch (Exception $e) {
                DBConnection::rollBackTransaction();
                throw new Exception($e);
            }
        }

        if ($this->_request->new_status == 'APPROVED') {
            $this->_queueCore->logActivity(
                $this->_request->id,
                "قبول أمر الحركة",
                "تم قبول أمر الحركة",
                "approve_queue",
                $_SESSION['u_id']
            );
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "QUEUE.SUCCESS_UPDATE";
        parent::response($Result);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- get queue delay options ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getQueueDelayOptions()
    {

        if ($this->_request->queue_id && $this->_request->queue_id != 'null') {
            $options = $this->_queueCore->getQueueDelayOptions($this->_request->id, $this->_request->tender_id, $this->_request->queue_id, $_SESSION['user_id']);
        } else {
            $options = new stdClass();
        }

        parent::response($options);
    }

    // --------------------------------------------------------------------------------------- //
    // ---------------- Remove certain truck from queue, and add it again at the last -------- //
    // --------------------------------------------------------------------------------------- //
    public function re_queue()
    {

        try {
            DBConnection::startTransaction();
            // get the truck queue bean
            $queueBean = $this->_queueCore->getQueue($this->_request->id, $_SESSION['user_id']);
            $queueBean = (json_decode($queueBean));

            // save the re_queue note
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('queue', $this->_request->id, $this->_request->notes, $_SESSION['u_id']);

            // change queue status to inactive
            $this->_queueCore->changeStatus($this->_request->id, 'INACTIVE', $_SESSION['user_id']);

            // add the truck again to the queue
            $new_queue_id = $this->_queueCore->addQueue(
                $queueBean->truck_id,
                $queueBean->driver_id,
                $queueBean->trailer_id,
                $this->_request->queue_id,
                $this->_request->tender_id,
                $_SESSION['user_id']
            );

            //check if there is auto action after create
            $autoAction = getAutoAction('QUEUE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
            if ($autoAction) {
                $this->_queueCore->changeStatus($new_queue_id, $autoAction->object_new_status_code, $_SESSION['user_id']);
            }

            // save the re_queue note on the new queue
            $addNoteCore->addNotes('queue', $new_queue_id, $this->_request->notes, $_SESSION['u_id']);
            $this->_queueCore->logActivity(
                $new_queue_id,
                "اضافة ملاحظة",
                $this->_request->notes,
                "ADD_NOTES",
                $_SESSION['user_id']
            );

            DBConnection::commitTransaction();

            //return Success reponse
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "تم حذف دور الشاحنة القديم واعادتها اخر الدور";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception("لا يمكن اكمال العملية ، الرجاء المحاولة مرة أخرى");
        }
    }



    // -------------------------------------------------------------------------------- //
    // -------------------- Remove trailer from queue --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function removeQueueTrailer()
    {

        // fill new values
        $updateBean = new stdClass();
        $updateBean->id = $this->_request->id;
        $updateBean->trailer_id = null;

        DBConnection::updateDB("queue", $updateBean, $_SESSION['user_id']);
    }




    // ---------------------------------------------------------------------------------- //
    // -------------------- Render queue info to mobile --------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function renderQueueInfo()
    {
        $queue = $this->_queueCore->searchQueue(
            [['key' => 'id', 'val' => $this->_request->q_id]],
            1,
            0,
            $_SESSION['user_id']
        );
        $result = new stdClass();

        //in case the queue id is invalid, render invalid queue screen
        if ($queue->found_rows == 0) {
            $html = $this->_queueCore->renderInvaildQueue();
            $result->ERRORCODE = 500;
            $result->tabs = [
                "queue_info" => $html
            ];
        } else {

            // get the corresponding screen for each project
            $queueBean = $queue->data[0];

            // search for tender truck
            $tenderSearchFilter = [
                ['key' => 'truck_id', 'val' => $queueBean->truck_id],
                ['key' => 'tender_id', 'val' => $queueBean->tender_id],
                ['key' => 'status', 'val' => 'PENDING']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
            if ($tenderTruckResult->found_rows > 0) {
                // add the status of tender truck to queueBean
                $queueBean->contract_status_note = 'تم منع السيارة لمدة 48 ساعة بسبب انقضاء المدة الزمنية للحضور';
            } else {
                $queueBean->contract_status_note = '-';
            }


            switch ($queueBean->tender_id) {
                case 3:    // "البواخر"
                    if ($queueBean->q_id == 2) {
                        $html = $this->_queueCore->renderItihadQueue($queueBean);
                    } else {
                        $html = $this->_queueCore->renderAdelQueue($queueBean);
                    }

                    break;

                case 11:  //"النفط  
                case 12: // "الفيول 
                case 15: // "مشتقات"
                    $html = $this->_queueCore->renderJo_PetrolQueue($queueBean);
                    break;

                case 13:    // "التموين"
                    $html = $this->_queueCore->renderGrainsQueue($queueBean, $_SESSION['u_id']);
                    break;

                default:
                    $html = $this->_queueCore->renderInvaildQueue();
                    break;
            }

            $result->ERRORCODE = 0;
            $result->tabs = [
                "queuel_info" => $html
            ];
        }
        parent::response($result);
    }







    // --------------------------------------------------------------------------------------- //
    // -------------------- get the first available truck on a certain queue  ---------------- //
    // --------------------------------------------------------------------------------------- //
    public function getNextTruck()
    {

        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;

        // get the first truck on queue with status = ACTIVE' and tender truck active
        $queueResult = $this->_queueCore->getNextTruck($tender_id, $q_id);

        if ($queueResult->found_rows == 0) {
            throw new Exception("لا توجد شاحنات على الدور");
        }
        $queueInfo = $queueResult->data[0];

        // get truck info
        $truckBean = $this->_truckCore->getTruckBasic($queueInfo->truck_id, 0);
        $queueInfo->truck_photos = $truckBean->photos;
        $queueInfo->truck_axis = $truckBean->axis;
        if ($queueInfo->trailer_id) {
            $trailerBean = $this->_truckCore->getTruckBasic($queueInfo->trailer_id, 0);
            $queueInfo->trailer_photos = $trailerBean->photos;
            $queueInfo->trailer_cat = $trailerBean->cat;
            $queueInfo->trailer_axis = $trailerBean->axis;
        }

        // get trailer info
        if ($queueInfo->trailer_id) {
            $trailerBean = $this->_truckCore->getTruckBasic($queueInfo->trailer_id, 0);
            $queueInfo->trailer_photos = $trailerBean->photos;
            $queueInfo->trailer_cat = $trailerBean->cat;
            $queueInfo->trailer_axis = $trailerBean->axis;
        } else {
            $queueInfo->trailer_photos = [];
            $queueInfo->trailer_cat = "-";
            $queueInfo->trailer_axis = "-";
        }


        // get tender_truck of the queue
        $activeTenderTrucks = DBConnection::getActiveStatus('tender_truck');
        $tenderFilter = [
            ['key' => 'truck_id', 'val' => $queueInfo->truck_id],
            ['key' => 'status', 'val' => $activeTenderTrucks, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
        $truckQuestionnaire = $tenderTruck_qry->data[0]->questionnaire;

        $truckQuestionnaire = json_decode($truckQuestionnaire, true)[0]['val'];
        $truckQuestionnaire_text = "";

        if (gettype($truckQuestionnaire) == "array") {
            foreach ($truckQuestionnaire as $dest) {
                if ($dest == "*") {
                    $truckQuestionnaire_text = "كل الوجهات";
                } else {
                    $destination_name = getLocationName($dest);
                    $truckQuestionnaire_text .= $destination_name . "/";
                }
            }
        } else {
            if ($truckQuestionnaire == "*") {
                $truckQuestionnaire_text = "كل الوجهات";
            }
        }

        $queueInfo->destinations = $truckQuestionnaire_text;

        // if driver  is null
        if (!$queueInfo->driver_id) {
            $waybillFilter = [
                ["key" => "tn", "val" => $queueInfo->tn],
                ["key" => "tender_id", "val" => $queueInfo->tender_id],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, 0);
            $doc = json_decode($waybills->data[0]->document);
            $queueInfo->driver_id = $doc->carrier[0]->driver->id;
            $queueInfo->driver_name = $doc->carrier[0]->driver->name;
            $queueInfo->driver_phone = $doc->carrier[0]->driver->phone;
        }

        // get the available tender_orders
        $activeTenderTrucks = DBConnection::getActiveStatus('tender_order');
        $tenderOrderFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'q_id', 'val' => $q_id],
            ['key' => 'status', 'val' => $activeTenderTrucks, 'op' => 'in']
        ];

        $orderResult = $this->_tenderCore->searchTenderOrder($tenderOrderFilter, 100, 0,  $_SESSION['user_id']);

        // translate locationtender names
        if ($orderResult->found_rows > 0) {
            foreach ($orderResult->data as $key => &$order) {
                if ($order->waybill_count >= $order->trucks) {
                    unset($orderResult->data[$key]);
                    continue;
                }
                $questionnaire = json_decode($order->questionnaire);
                $destinationQuestion = $questionnaire[0];
                $destination_name = getLocationName($destinationQuestion->val);
                $order->destination = $destination_name;
            }
        }

   
        
        $tender_order_result = [];
        foreach ($orderResult->data as $orderObj) {
            $tender_order_result[] = $orderObj;
        }

        // return to user
        $Result = [];
        $Result['QUEUE_INFO'] = $queueInfo;
        $Result['TENDER_ORDER'] = $tender_order_result;
        parent::response($Result);
    }

    // -------------------------------------------------------------------------------------------------------- //
    // -------------------- get the first available truck on a certain queue for teminal users ---------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function getNextTruckForTerminal()
    {

        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;

        // get the first truck on queue with status = ACTIVE' and tender truck active
        $queueResult = $this->_queueCore->getNextTruck($tender_id, $q_id);

        // return to user
        parent::response($queueResult->data);
    }


    // ------------------------------------------------------------ //
    // -------------------- get available yards ---------------- //
    // ------------------------------------------------------------ //
    public function getYards()
    {
        $tenders = $this->_tenderCore
            ->searchTender([
                ['key' => 'status', 'val' => 'ACTIVE']
            ], 1000, 0, $_SESSION["user_id"])
            ->data;

        $yards = [];
        foreach ($tenders as $tender) {
            // Get tender queues
            $queues = json_decode($tender->manifest)->queues;
            foreach ($queues as $queue) {
                // Find yard queues
                if (isset($queue->type) && strtoupper($queue->type) == "YARD") {
                    $yards[] = [
                        "q_id" => $queue->id,
                        "name" => $queue->name,
                        "status" => $queue->status,
                        "tender_id" => $tender->id,
                        "permit_ticket_creation_method" => $queue->permit_ticket_creation_method
                    ];
                }
            }
        }
        parent::response($yards);
    }

    // ------------------------------------------------------------ //
    // -------------------- get trucks on the yard ---------------- //
    // ------------------------------------------------------------ //
    public function getYardTrucks()
    {
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $sort = $this->_request->sort;
        if ($sort) $sort = " order by rank " . $sort;

        if (!$this->_request->limit) {
            $this->_request->limit = 100;
        }
        if (!$this->_request->offset) {
            $this->_request->offset = 0;
        }

        // Filter on dist,origin,ticket
        $filters = [];
        $waybill_filter = [];

        if ($this->_request->filter) {
            $filters = json_decode($this->_request->filter, true);
            $_filters = json_decode($this->_request->filter, true);
            if (isset($_filters['origin_id'])) {
                unset($_filters['origin_id']);
            }
            if (isset($_filters['destination_id'])) {
                unset($_filters['destination_id']);
            }
            if (isset($_filters['has_ticket'])) {
                unset($_filters['has_ticket']);
            }
            if (isset($_filters['trail_minor_tt']) && $_filters['trail_minor_tt'] == "*") {
                unset($_filters['trail_minor_tt']);
            }
            if (isset($_filters['first_trip_type'])) {
                unset($_filters['first_trip_type']);
            }
            if (isset($_filters['first_trip_destination_id']) && $_filters['first_trip_destination_id'] != "") {
                $destinations = [];
                foreach ($_filters['first_trip_destination_id'] as $loc) {
                    $destinations[] = $loc['value'];
                }
                $waybill_filter[] = ['key' => 'document', 'val' => $destinations, 'op' => 'json in', 'node' => '$.first_trip.destination'];
                unset($_filters['first_trip_destination_id']);
            }
            if (isset($_filters['entry_point_id'])) {
                $waybill_filter[] = ['key' => 'document', 'val' => [$_filters['entry_point_id']], 'op' => 'json in', 'node' => '$.first_trip.entry_location'];
                unset($_filters['entry_point_id']);
            }
            if (isset($_filters['cargo'])) {
                $waybill_filter[] = ['key' => 'document', 'val' => $_filters['cargo'], 'op' => 'json unquote', 'node' => '$.cargo[0].cargo_id'];
                unset($_filters['cargo']);
            }
            if (isset($_filters['order_id'])) {
                $waybill_filter[] = ['key' => 'document', 'val' => $_filters['order_id'], 'op' => 'json unquote', 'node' => '$.order.id'];
                unset($_filters['order_id']);
            }
        }
        $this->_request->filter = json_encode($_filters);
        $queueFilter = $this->prepareFilter();

        // get trucks in the queue
        $tenderFilter = [
            ['key' => 'q_id', 'val' => $q_id],
            ['key' => 'rank', 'op' => 'is not null'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $trucks = $this->_queueCore->searchQueueTrucks(array_merge($tenderFilter, $queueFilter), 1000, 0, $_SESSION["user_id"], $sort)->data;

        $truckIds = [];
        foreach ($trucks as $t) {
            $truckIds[] = $t->truck_id;
        }

        // Get waybills for all trucks in the queue
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $waybill_filter[] = ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'];
        $waybill_filter[] = ['key' => 'truck_id', 'val' => $truckIds, 'op' => 'in'];
        $waybill_filter[] = ['key' => 'tender_id', 'val' => $tender_id];

        $waybills = $this->_waybillCore->searchWaybills($waybill_filter, 10000, 0, $_SESSION["user_id"])->data;

        // loop on each waybill and match it with its queueu record
        $yardTrucks = [];
        foreach ($trucks as $truck) {
            $yardTruck = $truck;

            $waybill = null;
            foreach ($waybills as $current_waybill) {
                if ($current_waybill->truck_id == $truck->truck_id) {
                    $waybill = $current_waybill;
                    break;
                }
            }

            if ($waybill) {
                $doc = json_decode($waybill->document);
                $yardTruck->wn = $waybill->wn;
                $yardTruck->destination = $doc->negotiable_instructios->route->destination;
                $yardTruck->trucking_company_name = $doc->carrier[0]->tc->name;
                $yardTruck->origin = $doc->negotiable_instructios->route->origin;
                $yardTruck->cargo = $doc->cargo[0]->cargo;
                $yardTruck->first_trip_type = $doc->first_trip->type;
                $yardTruck->entry_point_id = $doc->first_trip->entry_location;
                $yardTruck->first_trip_destination_id = $doc->first_trip->destination;
                $yardTruck->shift_id = $doc->order->shift_id;

                if($doc->order->id == "9842"){
                    $yardTruck->is_direct = true;
                }else{
                    $yardTruck->is_direct = false;
                }
                

                // see if the truck has submit ticket
                $ticket = $this->_waybillCore->searchTicketInDocument($waybill->document, "ticket_type_code", strtoupper("submit_permit_for_waybill"));
                $yardTruck->ticket_id = $ticket ? $ticket->ticket_id : null;

                // validate if the truck match required search filter
                if ($this->validateYardTruck($yardTruck, $filters)) {
                    $yardTrucks[] = $yardTruck;
                }
            }
        }

        $result = [];
        $result['data'] = $yardTrucks;
        $result['found_rows'] = sizeof($yardTrucks);
        parent::response($result);
    }


    // ---------------------------------------------------------------------------------------------- //
    // -------------------- validate if the truck match required search filter ---------------------- //
    // ---------------------------------------------------------------------------------------------- //
    private function validateYardTruck($yardTruck, $roles)
    {
        if (!$roles) return true;


        foreach ($roles as $role => $value) {
            switch (strtolower($role)) {
                case "has_ticket":
                    if ($yardTruck->ticket_id != $value) {
                        return false;
                    }
                    break;
                case "destination_id":
                    if (!$yardTruck->destination || ($yardTruck->destination->id != $value && !$this->isLocationMatch($value, $yardTruck->destination->id))) {
                        return false;
                    }
                    break;
                case "origin_id":
                    if (!$yardTruck->origin || ($yardTruck->origin->id != $value && !$this->isLocationMatch($value, $yardTruck->origin->id))) {
                        return false;
                    }
                    break;
                case "first_trip_type":
                    if (!$yardTruck->first_trip_type || ($yardTruck->first_trip_type != $value)) {
                        return false;
                    }
                    break;
                case "first_trip_destination_id":

                    $value = $value[0]['value'];
                    if (!$yardTruck->first_trip_destination_id || ($yardTruck->first_trip_destination_id != $value)) {
                        return false;
                    }
                    break;
                case "cargo":
                    if (!$yardTruck->cargo || ($yardTruck->cargo->id != $value)) {
                        return false;
                    }
                    break;
            }
        }

        return true;
    }

    // --------------------------------------------------------------------------------------- //
    // -------------------- check if the location is a child of an other  -------------------- //
    // --------------------------------------------------------------------------------------- //
    // private function isChildLocation($parentLocation, $childLocation){
    //     $siblingLocations = $this->_locationCore->searchChildLocations($parentLocation);
    //     $flat = [];

    //     array_walk_recursive($siblingLocations, function($a) use (&$flat) { $flat[] = $a; });
    //     $locationsIds = array_column($flat, "id");
    //     return in_array($childLocation, $locationsIds);
    // }


    private function isLocationMatch($location1, $location2)
    {
        for ($index = 0; $index < 7; $index += 2) {
            $location1_sub = substr($location1, $index, 2);
            $location2_sub = substr($location2, $index, 2);

            if ($location1_sub == $location2_sub) {
                continue;
            } else if ((int)$location1_sub * (int)$location2_sub == 0) {
                continue;
            } else {
                return false;
            }
        }
        return true;
    }

    // ------------------------------------------------------------ //
    // -------------------- Create yard batch  -------------------- //
    // ------------------------------------------------------------ //
    public function createBatch()
    {

        try {
            DBConnection::startTransaction();

            // get inpout params
            $queueIds = $this->_request->queue_ids;
            if (is_string($queueIds)) {
                $queueIds = json_decode($queueIds);
            }
            $questionnaire = $this->_request->questionnaire;

            // Req filters
            $tenderId = $this->_request->tender_id;
            $qId = $this->_request->q_id;
            $batchSize = $this->_request->batch_size;

            // Get the batch size
            $queueIds = array_slice($queueIds, 0, (int) $batchSize);

            // Get queues records
            $queueFilter = [['key' => 'id', 'val' => $queueIds, 'op' => 'in']];
            $queues = $this->_queueCore->searchQueue($queueFilter, 10000, 0, $_SESSION["user_id"])->data;

            //Get truck ids on queues
            $truckIds = [];
            foreach ($queues as $current_queue) {
                $truckIds[] = $current_queue->truck_id;
            }

            // Get waybills
            $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
            $waybills = $this->_waybillCore->searchWaybills([
                ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
                ['key' => 'truck_id', 'val' => $truckIds, 'op' => 'in'],
                ['key' => 'tender_id', 'val' => $tenderId],
            ], 1000, 0, $_SESSION["user_id"], ' order by id ')->data;

            //create batch details json
            $batchDetails = array_map(function ($truckId) use ($waybills, $queues) {
                $node = [];
                foreach ($waybills as $waybill) {
                    if ($truckId == $waybill->truck_id) {
                        $node["waybill_id"] = $waybill->id;
                        $node["tn"] = $waybill->tn;
                        $node["wn"] = $waybill->wn;
                        break;
                    }
                }
                foreach ($queues as $queue) {
                    if ($truckId == $queue->truck_id) {
                        $node["queue_id"] = $queue->id;
                        break;
                    }
                }
                return $node;
            }, $truckIds);

            if (sizeof($waybills) == 0) {
                throw new Exception("لا يوجد مستندات شحن للشاحنات الموجودة في الساحة");
            }
            //create batch
            $this->_queueCore->createYardBatch($tenderId, $qId, $batchDetails, $questionnaire, $_SESSION['u_id']);

            // manifest
            $man = $this->_tenderCore->getTenderManifest($tenderId, 0);
            $tender_queues = $man['queues'];
            foreach ($tender_queues as $queueObj) {
                if ($queueObj['id'] == $qId) {
                    $permit_ticket_creation_method = $queueObj['permit_ticket_creation_method'];
                }
            }

            if ($permit_ticket_creation_method == "auto" || $permit_ticket_creation_method == "manual") {
                // Create Waybill tickets in case permit_ticket_creation_method the has ticket
                if ($tenderId == 3 || $tenderId = 13) {
                    foreach ($waybills as $waybill) {
                        // Get queue id
                        $batchNode = current(array_filter($batchDetails, function ($data) use ($waybill) {
                            return $data["waybill_id"] == $waybill->id;
                        }));
                        // Create Ticket
                        $ticket = $this->_waybillCore->createPermitTicket($waybill->id, $batchNode["queue_id"]);
                    }
                }
            } else {
                // remove trucks from queue
                foreach ($queues as $queueObj) {
                    $this->_queueCore->changeStatus($queueObj->id, 'CLOSED', 0);
                }
            }


            parent::response([
                "message" => "success"
            ]);
            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------ //
    // -------------------- Search yard batch  -------------------- //
    // ------------------------------------------------------------ //
    public function searchBatches()
    {
        $batchFilters = json_decode($this->_request->filter);
        if (!$this->_request->limit) {
            $this->_request->limit = 100;
        }
        if (!$this->_request->offset) {
            $this->_request->offset = 0;
        }
        $qryResult = $this->prepareBatchFilter($batchFilters);
        $qry = $qryResult[0];
        $qryBindings = $qryResult[1];
        $selectQry = "SELECT
                        id,
                        tender_id,
                        q_id,
                        CAST(`details` AS CHAR CHARSET UTF8) AS details,
                        CAST(`questionnaire` AS CHAR CHARSET UTF8) AS questionnaire,
                        create_date,
                        status,
                        update_by
                    FROM
                        `yard_batch`
                        
                    WHERE status != 'INACTIVE' 
                        and 1=1 ";

        if ($qry) {
            $selectQry .= "and $qry ";
        }
        $selectQry .= "order by id desc  limit {$this->_request->limit} offset {$this->_request->offset} ";
        if (!$qryBindings) $qryBindings = [];
        $batches = DBConnection::runBindDatabaseQuery($selectQry, $qryBindings);

        $result = [];
        $result['data'] = $batches;
        $result['found_rows'] = sizeof($batches);

        parent::response($result);
    }
    private function prepareBatchFilter($filters)
    {
        if (!$filters) return ["", []];
        $qrySegments = [];
        $qryBindings = [];
        foreach ($filters as $filter => $value) {
            if (!$value) continue;
            switch (strtolower($filter)) {
                case "create_date_from":
                    $qrySegments[] = "create_date >= ?";
                    break;
                case "create_date_to":
                    $qrySegments[] = "create_date <= ?";
                    break;
                case "tender_id":
                    $qrySegments[] = "tender_id = ?";
                    break;
                case "q_id":
                    $qrySegments[] = "q_id = ?";
                    break;
                default:
                    $qrySegments[] = "$filter <= ?";
                    break;
            }
            $qryBindings[] = $value;
        }
        $qry = join(" AND ", $qrySegments);
        return [$qry, $qryBindings];
    }


    // ------------------------------------------------------------------------------- //
    // -------------------- Yard workflow (in-queue <-> batch)  ------------------- //
    // ------------------------------------------------------------------------------- //
    public function getYardWorkflow()
    {
        // Req filters
        $tenderId = $this->_request->tender_id;
        $qId = $this->_request->q_id;


        // in yard count
        $inQueueQry = "
                SELECT 
                TIME_FORMAT(q.create_date, '%H %p') hr, COUNT(q.id) in_count
            FROM
                queue q
            WHERE
                q.tender_id = ? AND q.q_id = ?
                    AND q.create_date > CURRENT_DATE
                GROUP BY hr
        ";
        $inResult = DBConnection::runBindDatabaseQuery($inQueueQry, [$tenderId, $qId]);

        // out yard count
        $outQueueQry = "
                SELECT
                TIME_FORMAT(y.create_date, '%H %p') hr,
                IFNULL(SUM(JSON_LENGTH(y.details)), 0) out_count
            FROM
                yard_batch y
            WHERE
                y.tender_id = ? AND y.q_id = ?
                    AND y.create_date > CURRENT_DATE
            GROUP BY hr
        ";
        $outResult = DBConnection::runBindDatabaseQuery($outQueueQry, [$tenderId, $qId]);


        $result = [];
        $result[] = [
            "الساعة",
            "دخول",
            "تفويج"
        ];

        foreach ($inResult as $in) {
            $obj = [];
            $obj[] = $in->hr;
            $obj[] = intval($in->in_count);

            // search for any out value during in houre
            foreach ($outResult as $out_hr => $out) {
                $outValue = 0;
                if ($in->hr == $out->hr) {
                    $outValue = intval($out->out_count);
                    break;
                }
            }
            $obj[] = $outValue;
            $result[] = $obj;
        }
        parent::response($result);
    }


    public function getTicketedTrucksRatio()
    {
        // Req filters
        $tenderId = $this->_request->tender_id;
        $qId = $this->_request->q_id;

        $qry = "SELECT 
                    case when w.document->>'$.integeration_details.ticket[0].ticket_id' is null 
                    then 'have_no_ticket' else 'have_ticket' end as ticket_type,
                    count(w.id) cnt
                FROM
                    queue q , waybill w
                WHERE
                    q.tender_id = ? AND q.q_id = ?
                        AND q.rank IS NOT NULL
                        and w.truck_id = q.truck_id
                        and w.tender_id = q.tender_id
                        and w.status not in ('INACTIVE','REVOKED','COMPLETED','CLOSED')
                        group by 1";
        $trucksWaybillsDocs = DBConnection::runBindDatabaseQuery($qry, [$tenderId, $qId]);


        $haveTicket = 0;
        $haveNoTicket = 0;
        foreach ($trucksWaybillsDocs as $row) {

            if ($row->ticket_type == "have_ticket") {
                $haveTicket = intval($row->cnt);
            }
            if ($row->ticket_type == "have_no_ticket") {
                $haveNoTicket = intval($row->cnt);
            }
        }

        parent::response([
            "have_ticket" => $haveTicket,
            "have_no_ticket" => $haveNoTicket
        ]);
    }



    // ------------------------------------------------------------ //
    // -------------------- change setting of queue ---------------- //
    // ------------------------------------------------------------ //
    public function changeQueueSetting()
    {
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;
        $permit_ticket_creation_method = $this->_request->permit_ticket_creation_method;
        if (!$tender_id || !$q_id) {
            throw new Exception('tender_id and q_id are required');
        }
        if (!$permit_ticket_creation_method) {
            throw new Exception('الرجاء تحديد الية التفويج');
        }

        try {
            $tenderMan = $this->_tenderCore->getTenderBasic($tender_id, $_SESSION['user_id'])->manifest;;
            $queues = $tenderMan->queues;

            foreach ($queues as &$q) {
                if ($q->id == $q_id) {

                    $q->permit_ticket_creation_method = $permit_ticket_creation_method;
                    // create tender bean
                    $tender_bean = new stdClass();
                    $tender_bean->id = $tender_id;
                    $tenderMan->queues = $queues;
                    $tender_bean->manifest = $tenderMan;
                    $tender_bean->user_id = $_SESSION['user_id'];

                    // log the change of permit_ticket_creation_method
                    $logSql = "INSERT INTO `waybill`.`yard_patch_setting_log` (`tender_id`, `q_id`, `note`, `update_by`) VALUES 
                                                                    (?,?,?,?)";
                    $logNote = "تم تغير طريقة التفويج إلى: ";
                    switch ($permit_ticket_creation_method) {
                        case 'manual':
                            $logNote .= "يدوي";
                            break;
                        case 'manual_without_ticket':
                            $logNote .= "يدوي بدون معاملة";
                            break;
                        case 'auto':
                            $logNote .= "آلي مع معاملة";
                            break;
                        case 'auto_without_ticket':
                            $logNote .= "آلي بدون معاملة";
                            break;
                    }
                    DBConnection::runBindDatabaseQuery($logSql, [$tender_id, $q_id, $logNote, $_SESSION['u_id']]);

                    // fill update struct and set the target user id
                    DBConnection::updateDB("tender", $tender_bean, $_SESSION['user_id']);
                    $Result['MESSAGE'] = 'تمت العملية بنجاح';
                    $Result['CODE'] = 0;
                    parent::response($Result);
                    die;
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------------------- //
    // -------------- Get the log of changes on queue ticket creation methods ---------------- //
    // --------------------------------------------------------------------------------------- //
    public function getQueueTicketCreationLog()
    {
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;
        $date_from = $this->_request->date_from;
        $date_to = $this->_request->date_to;

        if (!$tender_id || !$q_id) {
            throw new Exception('tender_id and q_id are required');
        }
        if (!$date_from) {
            $date_from =  date("Y-m-d");
        }

        $logSql = "select note,create_date,update_by from yard_patch_setting_log where tender_id = ? and q_id = ? and create_date >= ? ";
        $param = [$tender_id, $q_id, $date_from];

        if ($date_to) {
            $logSql .= " and create_date < ? ";
            $param[] = $date_to;
        }
        $data = DBConnection::runBindDatabaseQuery($logSql, $param);
        parent::response($data);
    }


    // ------------------------------------------------------------ //
    // -------------------- change setting of queue ---------------- //
    // ------------------------------------------------------------ //
    public function unHeldQueues()
    {

        $queues = json_decode($this->_request->ids);
        try {
            foreach ($queues as $q_id) {
                // change queue status
                $this->_queueCore->changeStatus($q_id, 'ACTIVE', $_SESSION['user_id']);
                //return the remaining days to the truck queue
                $this->_queueCore->returnRemainingDelayDays($q_id, $_SESSION['user_id']);

                // update activation time to null
                $updateBean = new stdClass();
                $updateBean->id = $q_id;
                $updateBean->activation_date = null;

                $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);

                // log activity
                $this->_queueCore->logActivity(
                    $q_id,
                    "فك تأجيل الدور",
                    "تم فك تأجيل الدور",
                    "activate_queue",
                    $_SESSION['u_id']
                );
            }

            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            $Result['CODE'] = 0;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // --------------------------------------------------------------------------------------------------- //
    // ---------------------------  كشف شاحنات الشركات في الساحة ------------------------ //
    // --------------------------------------------------------------------------------------------------- //
    public function getCompanyTruckYardReport()
    {

        // get user input
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        $sql = " SELECT 
                    count(distinct(q.truck_id)) as cnt, w.document->>'$.carrier[0].tc.name' as tc_name
                FROM
                    queue q
                        LEFT JOIN
                    waybill w ON (w.truck_id = q.truck_id
                        AND w.tender_id = q.tender_id
                        AND w.status NOT IN ('INACTIVE' , 'REVOKED', 'CLOSED', 'COMPLETE')
                        AND w.create_date > '2021-01-01')
                WHERE
                    q.tender_id = ? AND q.q_id = ?
                        AND q.rank IS NOT NULL
                        group by w.document->>'$.carrier[0].tc.name'
                        order by cnt desc";
        $reportData = DBConnection::runBindDatabaseQuery($sql, [$tender_id, $q_id]);

        $Result = [];
        $Result['data'] = $reportData;
        $Result['found_rows'] = sizeof($reportData);
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ---------------------------- get the name of last waybill for yard trucks --------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function generateLastCargoCompanyTruckExcel()
    {

        // get user input
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        $sql = "    SELECT
                    q.rank , q.tn ,
                    case
                        when q.trail_minor_tt = 201 then 'قلاب'
                        when q.trail_minor_tt = 203 then 'تريلا'
                        when q.trail_minor_tt = 303 then 'صهريج مواد نفطية'
                        when q.trail_minor_tt is null then '-'
                    end as trail_tt,
                    (select document->>'$.cargo[0].cargo.name' from waybill where tender_id = 3 and truck_id = q.truck_id order by id desc limit 1) as last_cargo,
                    (select document->>'$.cargo[0].cargo.name' from waybill where tender_id = q.tender_id and truck_id = q.truck_id order by id desc limit 1,1) as pre_last_cargo
                FROM
                    queue_view q
                WHERE
                    tender_id = ? AND q_id = ?
                        AND rank IS NOT NULL";
        $reportData = DBConnection::runBindDatabaseQuery($sql, [$tender_id, $q_id]);

        $Result = [];
        $Result['data'] = $reportData;
        $Result['found_rows'] = sizeof($reportData);
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ---------------------------- inquiry on certain services on queue --------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function inquiry()
    {

        // get user input
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;
        $service_code = $this->_request->service_code;
        $user_data = $this->_request->user_data;
        if (gettype($user_data) == "string") {
            $user_data = json_decode($user_data);
        }

        switch ($service_code) {
            case 'rank_inquiry':

                $tn = [];
                foreach ($user_data as $obj) {
                    $tn[] = $obj->tn;
                }

                // search on queue
                $filter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'q_id', 'val' => $q_id],
                    ['key' => 'rank', 'op' => 'is not null'],
                    ['key' => 'tn', 'val' => $tn, 'op' => 'in']
                ];
                $queueSearchResult = $this->_queueCore->searchQueue($filter, 10000, 0,  $_SESSION['user_id']);

                $data = [];
                foreach ($tn as $truck) {
                    $data[$truck] = '-';
                    foreach ($queueSearchResult->data as $queue) {
                        if ($queue->tn == $truck) {
                            $data[$truck] = $queue->rank;
                        }
                    }
                }
                break;
        }

        parent::response($data);
    }

    // ------------------------------------------------------------------------------------ //
    // -------------------- Generate Poll of downpayment with recipients ------------------ //
    // ------------------------------------------------------------------------------------ //
    public function generateDownPaymentPollTask()
    {

        try {
            // if session is teller_supervisor
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            $allow = false;
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                    $allow = true;
                }
            }

            $queue_id = $this->_request->queue_id;

            if ($allow) {
                $this->_taskQueuesCore->createDownpaymentPollTask($queue_id, "queue", 2);
            } else {
                throw new Exception("لا يوجد لديك صلاحية");
            }
        } catch (Exception $e) {
            // add the task to failure poll queue
            $this->_taskQueuesCore->createDownpaymentPollFailCreationTask($queue_id, $e->getMessage(), 0);
        }
    }
}

$queue_interface = new Queue_interface();
