<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/queue_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../../core/notes/add_notes_core.php");
require_once (dirname(__FILE__)."/../../core/social/social_core.php");

class Queue_integeratrion extends API{

    // the request of each call
    private $_request = array();
    private $_queueCore;
    private $_addNoteCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_queueCore = new QueueCore();
        $this->_addNoteCore = new Add_notes_core();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ---------------------------------------------------------------------------------- //
    // ---------------------- Hold the queue for a certain truck ------------------------ //
    // ---------------------- params: tn , tender_id, q_id ------------------------------ //
    // ---------------------------------------------------------------------------------- //
    public function holdQueue(){

        try{

            // parse inputs
            $tn = $this->_request->tn;
            $tender_id = $this->_request->tender_id;
            $q_id = $this->_request->q_id;

            // search for queue record
            $queueSearchFilter = [['key'=>'tn','val' =>$tn],
                                ['key'=>'q_id','val' =>$q_id],
                                ['key'=>'tender_id','val' =>$tender_id],
                                ['key'=>'status','val' => ['ACTIVE'], 'op' => 'in']];
            $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter,1,0,$_SESSION['user_id']) ;

            if($queueTruckResult->found_rows == 0){
                throw new Exception("Queue.truck.not_exists_in_correct_status");
            }

            // change status to HELD
            $queue_id = $queueTruckResult->data[0]->id;
            $this->_queueCore->changeStatus($queue_id, "HELD", $_SESSION['user_id']);

            // update the activation_date
            $updateBean = new stdClass();
            $duration = 1;
            $updateBean->id =  $queue_id ;
            $updateBean->activation_date = date("Y-m-d", strtotime("+ " . $duration . " day"));
            $this->_queueCore->updateQueue($updateBean,$_SESSION['user_id']);

            // return response
            $result = [];
            $result['ERRORCODE'] = "0";
            $result['MESSAGE'] = "QUEUE.SUCCESS_OPERATION";
            parent::response($result);

        }
        catch(Exception $e){

        }

    }


    // -------------------------------------------------------------------------------------- //
    // ---------------------- release a certain truck from the HELD status on queue --------- //
    // ---------------------- params: tn , tender_id, q_id ---------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function releaseQueue(){

        // parse inputs
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        // search for queue record
        $queueSearchFilter = [['key'=>'tn','val' =>$tn],
                              ['key'=>'q_id','val' =>$q_id],
                              ['key'=>'tender_id','val' =>$tender_id],
                              ['key'=>'status','val' => ['HELD'], 'op' => 'in']];
        $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter,1,0,$_SESSION['user_id']) ;
        if($queueTruckResult->found_rows == 0){
            throw new Exception("Queue.truck.not_exists_in_correct_status");            
        }

        // change status to HELD
        $queue_id = $queueTruckResult->data[0]->id;
        $trailerResult = $this->_queueCore->changeStatus($queue_id, "ACTIVE", $_SESSION['user_id']);     
        
        // return response
        $result = [];
        $result['ERRORCODE'] = "0";
        $result['MESSAGE'] = "QUEUE.SUCCESS_OPERATION";
        parent::response($result);
  
    }

}

new Queue_integeratrion();