<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . '/../truck_contract/truck_contract_core.php');
require_once(dirname(__FILE__) . '/../company/trucking_company/trucking_company_core.php');
require_once(dirname(__FILE__) . "/../queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");

class QueueCore
{

    private $_truckCore;
    private $_tenderCore;
    private $_truckContractCore;
    private $_driverCore;
    private $_userCore;
    public function __construct()
    {
        DBConnection::getInstance();

        $this->_truckCore = new TruckCore();
        $this->_tenderCore = new TenderCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_driverCore = new DriverCore();
        $this->_userCore = new UserCore();
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Queue bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getQueue($id, $user_id)
    {

        $queueInfo = DBConnection::getObjectBean("queue", $id, $user_id);
        return $queueInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create basic Queue bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getQueueBasic($id, $user_id)
    {

        $queueInfo = DBConnection::getBasicObjectBean("queue", $id, $user_id);
        return $queueInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for queue using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchQueue($searchFilter, $limit, $offset, $user_id, $ordeBy = null)
    {

        $searchQueueResult = DBConnection::searchDB("queue", $searchFilter, $limit, $offset, $user_id, $ordeBy);
        return $searchQueueResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------update truck info on queue   ------------------------ //
    // ------------------------------------------------------------------------ //
    public function updateQueue($queueBean, $user_id)
    {
        // (IMPORTANT : Dont update queue_id or tender_id or rank) !!!
        // ONLY Driver-ID and Trailer-ID can be updated

        // get the queue and tender id
        $DBqueueBean = $this->getQueue($queueBean->id, $user_id);
        $DBqueueBean = json_decode($DBqueueBean);
        $trailer_id_in_db = $DBqueueBean->trailer_id;
        $new_trailer_id = $queueBean->trailer_id;

        //$this->validateUpdateQueue($DBqueueBean->id, $queueBean->driver_id, $queueBean->trailer_id ,$DBqueueBean->tender_id,$DBqueueBean->q_id,$user_id);

        // fill old values
        $updateBean = new stdClass();
        $updateBean->id = $queueBean->id;
        $updateBean->driver_id = $DBqueueBean->driver_id;
        $updateBean->trailer_id = $DBqueueBean->trailer_id;
        $updateBean->truck_owner_id = $DBqueueBean->truck_owner_id;
        $updateBean->activation_date = $queueBean->activation_date;
        $updateBean->total_delay = $DBqueueBean->total_delay + $queueBean->total_delay;
        $updateBean->trailer_id = $queueBean->trailer_id;

        if ($updateBean->trailer_id == null) {
            $updateBean->trailer_id = $DBqueueBean->trailer_id;
            if ($updateBean->trailer_id == null) {

                // get the trailer from tender truck
                $tenderSearchFilter = [
                    ['key' => 'truck_id', 'val' => $DBqueueBean->truck_id],
                    ['key' => 'tender_id', 'val' => $DBqueueBean->tender_id],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                ];
                $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
                $updateBean->trailer_id = $tenderTruckResult->data[0]->trailer_id;
                if ($updateBean->trailer_id == null) {
                    if ($queueBean->q_id == 3) {
                        throw new Exception("لا تسطيع مسح رقم المقطورة");
                    }
                }
            }
        }


        // fill new values
        if ($queueBean->driver_id) {
            $updateBean->driver_id = $queueBean->driver_id;
            $new_driver = true;
        }


        DBConnection::updateDB("queue", $updateBean, $user_id);

        // log update activity to db

        $activity_details = '';
        // if there is change in trn log it
        if ($new_trailer_id && (int) $trailer_id_in_db != (int) $new_trailer_id) {

            // get the old trailer
            $trnSearchFilter = [
                ['key' => 'id', 'val' => $trailer_id_in_db]
            ];
            $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $user_id);
            $oldTrn = $trailerResult->data[0]->tn;

            // get the new trailer
            $trnSearchFilter = [
                ['key' => 'id', 'val' => $new_trailer_id]
            ];
            $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $user_id);
            $updatedTrn = $trailerResult->data[0]->tn;
            $activity_details = "تم تغيير المقطورة من $oldTrn إلى $updatedTrn ";
        }

        // if there is change in driver log it
        if ($new_driver && (int) $DBqueueBean->driver_id != (int) $queueBean->driver_id) {
            // get old driver bean
            $oldDriverFilter = [['key' => 'id', 'val' => $DBqueueBean->driver_id]];
            $oldDriverResult = $this->_driverCore->searchDriver($oldDriverFilter, 1, 0, $user_id);

            // get new driver bean
            $newDriverFilter = [['key' => 'id', 'val' => $queueBean->driver_id]];
            $newDriverResult = $this->_driverCore->searchDriver($newDriverFilter, 1, 0, $user_id);

            $oldDriver = $oldDriverResult->data[0]->name;
            $driverName = $newDriverResult->data[0]->name;

            if ($oldDriver) {
                $activity_details .= "تم تغيير السائق من $oldDriver إلى $driverName ";
            } else {
                $activity_details .= "تم تحديد السائق $driverName";
            }
        }

        if ($activity_details) {
            $this->logActivity(
                $queueBean->id,
                "تعديل معلومات",
                $activity_details,
                "update",
                $user_id
            );
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------remove truck from queue   ------------------------ //
    // ------------------------------------------------------------------------ //
    public function changeStatus($q_id, $new_status, $user_id)
    {

        try {

            if ($new_status == "HELD") {
                // $taskQueuesCore = new TaskQueuesCore();
                // $taskQueuesCore->createUnfreezeQueueTask($q_id , 48, "فك تجميد بسبب مضي أكثر من 48 ساعة");

                // $this->logActivity($q_id,
                //         "تجميد دور الشاحنة",
                //         "سيتم فك التجميد تلقائيا بعد 48 ساعة",
                //         "ADD_NOTES",
                //         $user_id);

            }

            // get the original bean from DB
            $DB_Bean = DBConnection::getBasicObjectBean("queue", $q_id, $user_id);

            $queueBean = new stdClass();
            $queueBean = mapBeanToDBBean($queueBean, $DB_Bean);

            // map all the new values into the truckBean
            $queueBean->status = $new_status;
            $queueBean->id = $q_id;

            // remove truck id
            unset($queueBean->truck_id);
            unset($queueBean->trailer_id);
            unset($queueBean->active_truck_id);

            // update the status and update the rank of the whole queue
            try {
                //DBConnection::updateQueueRank($q_id,$new_status);
            } catch (Exception $e) {
            }

            DBConnection::updateDB("queue", $queueBean, $user_id);
        } catch (Exception $e) {
            throw $e;
        }
    }

    // ----------------------------------------------------------------------- //
    // ------------------ LOG ACTIVITY FOR WAYBILL BEAN ----------------------- //
    // ----------------------------------------------------------------------- //
    public function logActivity($queueId, $activity_title, $activity_details, $activity_icon, $user_id)
    {

        // set activity node
        $activity = new stdClass();
        $activity->activity_title = $activity_title;
        $activity->activity_details = $activity_details;

        if ($user_id > 1000000) {
            $u_id = DBConnection::getUserIdFromSession($user_id);
        } else {
            $u_id = $user_id;
        }
        $activity->user_id = $u_id;

        $activity->activity_icon = $activity_icon;
        $activity->activity_date = DBConnection::getSystemDate();

        // get queue bean
        $queueBean = $this->getQueueBasic($queueId, $user_id);
        // get queue document
        if ($queueBean->activity) {
            array_push($queueBean->activity, $activity);
        } else {
            $queueBean->activity = [$activity];
        }

        DBConnection::updateDB("queue", $queueBean, $user_id);
    }

    // ---------------------------------------------------------------------------------------------- //
    // ---------- validate if user did exceede the delay limit -------------------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function validateDelayQueue($q_id, $new_status, $duration, $user_id)
    {
        // get the queue bean
        $queueBean = $this->getQueueBasic($q_id, 0);

        // get the total delay limit allowed for this queue
        $man = $this->_tenderCore->getTenderManifest($queueBean->tender_id, 0);

        foreach ($man['queues'] as $queue) {
            if ($queue['id'] == $queueBean->q_id) {
                $delayRules = $queue['delay_rules'];
            }
        }
        $totalNumberOfDelays = $delayRules['total_delays'];

        // compare the used delay to the total allowed limit
        if (($queueBean->total_delay + $duration) > $totalNumberOfDelays) {
            throw new Exception("لقد استنفذت كامل ايام التأجيل لهذا الدور، الرجاء الاتصال بقسم العمليات");
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------add new truck on queue  ----------------------------- //
    // ------------------------------------------------------------------------ //
    public function addQueue($truck_id, $driver_id, $trailer_id, $queue_id, $tender_id, $user_id)
    {

        // validate add truck to queue
        $this->validateAddQueue($truck_id, $driver_id, $trailer_id, $tender_id, $queue_id, $user_id);

        // get the truck_owner_id from truck bean
        $truckBean = $this->_truckCore->getTruckBasic($truck_id, 0);
        $truck_owner_id = $truckBean->truck_owner_id;

        // get the company_id that owns the tender
        $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
        $company_id = $tenderBean->company_id;

        // get the trucking_company_id
        if ($tender_id == 11) {
            $trucking_company_id = 71;
        } else {
            $truckingCompanyCore = new TruckingCompanyCore();
            $searchFilter = [['key' => 'company_id', 'val' => $company_id]];
            $companyInfo = $truckingCompanyCore->searchTruckingCompany($searchFilter, 1, 0, 0);
            $trucking_company_id = $companyInfo->data[0]->id;
        }

        // insert record in database
        $queueBean = new stdClass();
        $queueBean->truck_id = $truck_id;
        $queueBean->tender_id = $tender_id;
        $queueBean->q_id = $queue_id;
        $queueBean->driver_id = $driver_id;
        $queueBean->trailer_id = $trailer_id;
        $queueBean->truck_owner_id = $truck_owner_id;                       // IMPORTANT: in case the TN is changed , this must be changed !!
        $queueBean->trucking_company_id = $trucking_company_id;
        $queueBean->status = 'NEW';

        if (!$trucking_company_id) throw new Exception("QUEUE.TRUCKING_COMPANY_ID_CANT_BE_NULL", 500);

        if ($driver_id == "") unset($queueBean->driver_id);
        if ($trailer_id == "") unset($queueBean->trailer_id);

        $createQueueResult = DBConnection::insertDB("queue", $queueBean, $user_id);

        // get the created queue
        $queueBean = $this->getQueueBasic($createQueueResult[0]['@id'], $user_id);
        $serial = $queueBean->serial;

        //log the create activity into db
        $truckBean = $this->_truckCore->getTruckBasic($truck_id, 0);
        $logTn =  $truckBean->tn;

        if ($trailer_id && $trailer_id != "") {
            $trailerBean = $this->_truckCore->getTruckBasic($trailer_id, 0);
            $logTn .= "+" . $trailerBean->tn;
        }

        $this->logActivity(
            $createQueueResult[0]['@id'],
            "إنشاء دور",
            " إنشاء دور للشاحنة رقم $logTn , تسلسل $queueBean->serial",
            "create",
            $user_id
        );

        return $createQueueResult[0]['@id'];
    }



    // --------------------------------------------------------------------------------------- //
    // -------------------add update trailer or driver on queue  ----------------------------- //
    // --------------------------------------------------------------------------------------- //
    private function validateUpdateQueue($id, $driver_id, $trailer_id, $tender_id, $queue_id, $user_id)
    {
        $activeQueueStatus = DBConnection::getActiveStatus('queue');

        // validate if the trailer has already active record on this queue
        if ($trailer_id) {
            $queueSearchFilter = [
                ['key' => 'id', 'val' => [$id], 'op' => 'not in'],
                ['key' => 'trailer_id', 'val' => $trailer_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, $user_id);
            if ($queueTruckResult->found_rows > 0) {
                throw new Exception("QUEUE.TRAILER_HAS_ACTIVE_QUEUE", 500);
            }
        }

        // validate if the driver has already active record on this queue
        if ($driver_id) {
            $queueSearchFilter = [
                ['key' => 'id', 'val' => [$id], 'op' => 'not in'],
                ['key' => 'driver_id', 'val' => $driver_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, $user_id);
            if ($queueTruckResult->found_rows > 0) {
                //throw new Exception("QUEUE.DRIVER_HAS_ACTIVE_QUEUE",500);
            }
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------add new truck on queue  ----------------------------- //
    // ------------------------------------------------------------------------ //
    private function validateAddQueue($truck_id, $driver_id, $trailer_id, $tender_id, $queue_id, $user_id)
    {
        // validate truck is exist and active
        $searchFilter = [['key' => 'id', 'val' => $truck_id], ['key' => 'status', 'val' => 'ACTIVE']];
        $truckResult = $this->_truckCore->searchTrucks($searchFilter, 1, 0, 0);

        if ($truckResult->found_rows == 0) {
            throw new Exception("الشاحنة غير مسجلة");
        }

        // validate truck is exist on tender trucks and registered on tender truck on the same tender
        if ($truck_id) {
            $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);

            if ($tenderTruckResult->found_rows == 0) {
                $tender_name = $this->_tenderCore->getTenderBasic($tender_id, 0);
                throw new Exception("لا يمكن اعادة الشاحنة الى أخر الدور لأنها لا تملك عقد تشغيل فعال على مشروع $tender_name ");
            }
        }

        // validate if the truck has already active record on this queue
        if ($truck_id) {
            $activeQueueStatus = DBConnection::getActiveStatus('queue');
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {
                throw new Exception("QUEUE.TRUCK_HAS_ACTIVE_QUEUE", 500);
            }
        }

        // validate if the trailer has already active record on this queue
        if ($trailer_id) {
            $queueSearchFilter = [
                ['key' => 'trailer_id', 'val' => $trailer_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {
                //throw new Exception("QUEUE.TRAILER_HAS_ACTIVE_QUEUE",500);
            }
        }

        // validate if the driver has already active record on this queue
        if ($driver_id) {
            $queueSearchFilter = [
                ['key' => 'driver_id', 'val' => $driver_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {
                //throw new Exception("QUEUE.DRIVER_HAS_ACTIVE_QUEUE",500);
            }
        }



        // ###################################################
        // TODO: ADD company id to the search filter
        // ###################################################
        // validate if the truck is registered in a company fleet
        $companyFleetFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['JOIN', 'OWN', 'AUTH'], 'op' => 'in']
        ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($companyFleetFilter, 1, 0, 0);

        if ($contract_qry->found_rows == 0) {
            throw new Exception("لا تستطيع المتابعة ، الشاحنة لا تملك أي عقد ملكية أو وكالة", 500);
        }

        // get the trucking_company_id
        $userFleetFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['OWN', 'AUTH', 'JOIN'], 'op' => 'in']
        ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($userFleetFilter, 1, 0, 0);
        if ($contract_qry->found_rows == 0) {
            throw new Exception("لا يمكن اعادة الشاحنة على الدور بسبب عدم وجود عقد ملكية او وكالة او ائتلاف فعال للشاحنة");
        }

        // validate if the truck has truck_owner_id column
        $truckBean = $this->_truckCore->getTruckBasic($truck_id, 0);
        if (!$truckBean->truck_owner_id) {
            //throw new Exception("لا يمكن اعادة الشاحنة على الدور بسبب عدم وجود عقد ملكية او وكالة فعال للشاحنة");
        }


        // the truck is allowed to be added to either the crude_oil and fuel or the oil_derivatevis
        // so if the truck is about to be added on oil_derivatevis, make sure it is not active on crude_oil or fuel
        if ($truck_id && $tender_id == 15) {
            $activeQueueStatus = DBConnection::getActiveStatus('queue');
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => [11, 12], 'op' => 'in'],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {
                throw new Exception('لا تستطيع المتابعة , الشاحنة تملك دور فعال على مشروع النفط لخام أو الفيول');
            }
        }

        // validate if the truck already active on المشتقات tender and want to add it to curde oil
        if ($truck_id && ($tender_id == 11 || $tender_id == 12)) {
            $activeQueueStatus = DBConnection::getActiveStatus('queue');
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => 15],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {
                //throw new Exception('لا تستطيع المتابعة, الشاحنة تملك دور فعال على مشروع المشتقات النفطية');
            }
        }
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- get queue delay options ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getQueueDelayOptions($id, $tender_id, $queue_id, $user_id)
    {

        // get tender manfefist
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        // get delay rules for the selected queue
        foreach ($man['queues'] as $queue) {
            if ($queue['id'] == $queue_id) {
                $delayRules = $queue['delay_rules'];
            }
        }

        if (!$delayRules) throw new Exception("QUEUE.DELAY_RULES_NOT_DEFINED_FOR_QUEUE", 500);

        // --------------- Case: No delay is allowed for queue ------------------------
        if ($delayRules['method'] == 'none') {
            $result = new stdClass();
            $result->MESSAGE = 'التأجيل غير مسموح لهذا الدور';
            return $result;
        }

        // -------------- Case: number of days ---------------------------------------------------------------------
        // this method allow the user to delay his queue for any number of days until he reach the total delay limit
        if ($delayRules['method'] == 'number_of_days') {

            $totalNumberOfDelays = $delayRules['total_delays'];

            // get number of used delays by the truck
            $queueBean = $this->getQueue($id, $user_id);
            $queueBean = json_decode($queueBean);
            $usedDelays = $queueBean->total_delay;
            if (!$usedDelays) $usedDelays = 0;

            $delay_options = [];
            if ($usedDelays >= $totalNumberOfDelays) {
                $result = new stdClass();
                $result->MESSAGE = 'لقد استنفذت جميع محاولات التأجيل ، سيتم إلغاء دورك في حال عدم الحضور';
                return $result;
            } else {
                for ($i = 0; $i < ($totalNumberOfDelays - $usedDelays); $i++) {
                    array_push($delay_options, $delayRules['delay_options'][$i]);
                }
            }

            $result = new stdClass();
            $result->delay_options = $delay_options;
            return $result;
        }

        // ------------ Case: maximum_day -------------------------------------------------
        // this method allow user to delay queue for a total of (delay_limit) after the first delay date
        // so the system start to count days after first delay and deduct from total limit
        if ($delayRules['method'] == 'maximum_day') {

            $delayLimit = $delayRules['delay_limit'];

            // get queue activity
            $bean = $this->getQueue($id, $user_id);
            $bean = json_decode($bean);
            $activities = $bean->activity;

            // calculate first delay date
            $firstDelay = null;

            foreach ($activities as $act) {
                if ($act->action_code == 'CHANGE_STATUS' && $act->object_status_code == 'ACTIVE' && $act->object_new_status_code == 'PENDING') {
                    $firstDelay = date_create($act->activity_date);
                    break;
                }
            }
            if (!$firstDelay) {
                $firstDelay = date_create(date("Y-m-d"));
            }

            // calculate maximum delay date
            $maximumDelayDate = date_create(date("Y-m-d", strtotime("+ " . $delayLimit . " day")));

            // calculate available options
            $dateDiff = date_diff($maximumDelayDate, $firstDelay);

            $delayOptions = [];
            for ($i = 1; $i <= ($dateDiff->d) + 1; $i++) {
                if ($i <= $delayLimit) {

                    $temp = new stdClass();
                    $temp->code = $i;
                    $temp->value = 'QUEUE.DELAY_' . $i . '_DAY';
                    array_push($delayOptions, $temp);
                }
            }

            if (empty($delayOptions)) {
                $result = new stdClass();
                $result->MESSAGE = 'لقد استنفذت جميع محاولات التأجيل ، سيتم إلغاء دورك في حال عدم الحضور';
                return $result;
            } else {
                $result->delay_options = $delayOptions;
                return $result;
            }
        }

        // ------------ Case: full_delay -------------------------------------------------
        // this method allow user to delay queue only 1 time and with the full amount of total limit
        if ($delayRules['method'] == 'full_delay') {

            $totalNumberOfDelays = $delayRules['total_delays'];

            // get number of used delays by the truck
            $queueBean = $this->getQueue($id, $user_id);
            $queueBean = json_decode($queueBean);
            $usedDelays = $queueBean->total_delay;
            if (!$usedDelays) $usedDelays = 0;

            $delayOptions = [];
            if ($usedDelays >= $totalNumberOfDelays) {
                $result = new stdClass();
                $result->allow_delay_from_mobile = $delayRules['allow_delay_from_mobile'];
                $result->allow_delay_from_mobile_message = 'لقد استنفذت جميع محاولات التأجيل ، سيتم إلغاء دورك في حال عدم الحضور';
                $result->delay_timer_end_message = $delayRules['delay_timer_end_message'];
                $result->MESSAGE = 'لقد استنفذت جميع محاولات التأجيل ، سيتم إلغاء دورك في حال عدم الحضور';
                return $result;
            } else {
                array_push($delayOptions, $delayRules['delay_options'][0]);
            }

            $result = new stdClass();
            $result->delay_options = $delayOptions;
            $result->allow_delay_from_mobile = $delayRules['allow_delay_from_mobile'];
            $result->allow_delay_from_mobile_message = $delayRules['allow_delay_from_mobile_message'];
            $result->delay_timer_end_message = $delayRules['delay_timer_end_message'];
            return $result;
        }
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // ---------- Calculate the remaining days wich can be returned to the truck when activating the queue ---------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function returnRemainingDelayDays($queue_id, $user_id)
    {

        // get the queue bean
        $queueBean = DBConnection::getBasicObjectBean("queue", $queue_id, $user_id);

        // calculate the days that can be returned, (deduct the activation date from current date , return full days only)
        $activation_date = $queueBean->activation_date;

        $activation_date = new DateTime($queueBean->activation_date);
        $current_date = new DateTime(DBConnection::getSystemDate());
        $interval = $activation_date->diff($current_date);

        // update the queue bean
        $queueBean->total_delay -= $interval->d;
        if ($queueBean->total_delay < 0) $queueBean->total_delay = 0;
        unset($queueBean->active_truck_id);

        DBConnection::updateDB("queue", $queueBean, $user_id);
    }

    // --------------------------------------------------------------------------------------------------------------------------------------- //
    // ------------- Check if the destination of the waybill is from the "reserved locations" , then add it to the reserved queue ------------ //
    // --------------------------------------------------------------------------------------------------------------------------------------- //
    public function requeueOnReservedQueue($waybill_id)
    {

        // init
        $tenderCompanyCore = new TenderCompanyCore();
        $waybillCore = new WaybillCore();

        // get waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        // get waybill destination
        $destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;

        // get tender
        $tender_id = $waybillBean->document->tender->id;
        $tenderManafist = $this->_tenderCore->getTenderManifest($tender_id, 0);

        // get list of defined services for the company on a certain tender
        $trucking_company_id = $waybillBean->document->carrier[0]->tc->id;

        $service_list = $tenderCompanyCore->getTenderCompanyServices($trucking_company_id, $tender_id);
        $has_queue_service = false;
        if ($service_list) {
            foreach ($service_list as $service) {
                if ($service->code == 'DISPATCH' && isset($service->type) && $service->type == 'QUEUE') {
                    $has_queue_service = true;
                }
            }
        }

        // temp solution
        if ($trucking_company_id == 395) {
            $has_queue_service = true;
        }

        // if the company has queue service , then re queue truck on reserved queue
        if (!$has_queue_service) {
            return;
        }

        if ($tenderManafist['tender_code'] == 'GRAINS') {

            // search if location is withing reserved locations
            // القريقرة - الديسة - الريشة - المريغة - القويرة - رم - الطفيلة - مدينة الطفيلة
            $reservedLocations = [91090012, 91090013, 91090011, 91110007, 91090002, 91090014, 91120000, 91120001];
            if (array_search($destination_id, $reservedLocations)) {

                // prepare data
                $q_id = 3;
                $truck_id = $waybillBean->truck_id;
                $trailer_id = $waybillBean->trailer_id;
                $driver_id = $waybillBean->driver_id;

                // add to queue
                $addQueueId = $this->addQueue($truck_id, $driver_id, $trailer_id, $q_id, $tender_id, 0);

                // inform user about this action
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $waybillCore = new WaybillCore();
                $wallEntry = new stdClass();
                $wallEntry->title = "اضافة على الدور المحفوظ";
                $wallEntry->msg = "تمت اضافة الشاحنة رقم  : $tn  على الدور المحفوظ";
                $waybillCore->informWaybillContactPerson($waybillBean->id, $wallEntry);
            }
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render activation date  ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderActivationDate($queue)
    {
        if ($queue->status == "PENDING") {
            $html = ' <div class="form-group divStyle row">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->activity_date . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تاريخ التفعيل</label>
            </div>';
        } else {
            $html = '';
        }
        return $html;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render queue info for Adel ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderAdelQueue($queue)
    {

        $html = '<html>
    <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
<head>
<link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

    <style>
        .MinagateFont {
            font-family: DroidArabicKufiRegular;
            font-weight: lighter;
            font-style: normal;
            color: #807d7d;
            font-size: 11px;
            margin-top: 22px;
        }
        .labelStyle {
            text-align: right;
            padding-right: 25px;
        }
        .valueStyle {
            text-align: right;
            color: rgb(74, 163, 222);
        }
        .divStyle {
            padding: 4px;
            border-bottom: solid 0.5px #ccc;
        }
    </style>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
</head>
<body>
    <div class="MinagateFont">
        <form>
            <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("QUEUE.STATUS." . $queue->status) . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
            </div>' . $this->renderActivationDate($queue) . '
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->rank . '</label>
                <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : ترتيب الدور</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->serial . '</label>
                <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : التسلسل</label>
            </div>
            <div class="form-group  divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                    ' . $queue->queue_name . '</label>
                <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : اسم الدور</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                    ' . $queue->tender_name . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم المشروع</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                    ' . $queue->driver_name . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم السائق</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-md-7 col-xs-7  col-form-label valueStyle">
                    ' . $queue->driver_phone . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم هاتف السائق</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->tn . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم الشاحنة</label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->trn . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم المقطورة</label>
            </div>
            <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12">
                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                    ' . $queue->truck_owner_name . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : اسم مالك الشاحنة </label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                    ' . ($queue->total_delay ? $queue->total_delay : 0) . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عدد أيام التأجيل </label>
            </div>
            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;">
                    ' . ($this->getPendingQueues($queue->tender_id, $queue->q_id, $queue->rank)) . '</label>
                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : الشاحنات المؤجلة </label>
            </div>
        </form>
    </div>
</body>

            </html>';

        return $html;
    }


    // ---------------------------------------------------------- //
    //--------------- Render Itihad queue ----------------------- //
    // ---------------------------------------------------------- //
    public function renderItihadQueue($queue)
    {

        $html = '<html>
                <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
            <head>
            <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

                <style>
                    .MinagateFont {
                        font-family: DroidArabicKufiRegular;
                        font-weight: lighter;
                        font-style: normal;
                        color: #807d7d;
                        font-size: 11px;
                        margin-top: 22px;
                    }
                    .labelStyle {
                        text-align: right;
                        padding-right: 25px;
                    }
                    .valueStyle {
                        text-align: right;
                        color: rgb(74, 163, 222);
                    }
                    .divStyle {
                        padding: 4px;
                        border-bottom: solid 0.5px #ccc;
                    }
                </style>
            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
            </head>
            <body>
                <div class="MinagateFont">
                    <form>
                        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("QUEUE.STATUS." . $queue->status) . '</label>
                            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
                        </div>' . $this->renderActivationDate($queue) . '
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->rank . '</label>
                            <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : ترتيب الدور</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->serial . '</label>
                            <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : التسلسل</label>
                        </div>
                        <div class="form-group  divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                                ' . $queue->queue_name . '</label>
                            <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : اسم الدور</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                                ' . $queue->tender_name . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم المشروع</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                                ' . $queue->driver_name . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم السائق</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7  col-form-label valueStyle">
                                ' . $queue->driver_phone . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم هاتف السائق</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->tn . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم الشاحنة</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->trn . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم المقطورة</label>
                        </div>
                        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                                ' . $queue->truck_owner_name . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : اسم مالك الشاحنة </label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                                ' . ($queue->total_delay ? $queue->total_delay : 0) . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عدد أيام التأجيل </label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;">
                                ' . ($this->getPendingQueues($queue->tender_id, $queue->q_id, $queue->rank)) . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : الشاحنات المؤجلة </label>
                        </div>
                            <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                                <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;">
                                    ' . ($this->getQueueRankByCargos($queue->id, $queue->tender_id, $queue->q_id, $queue->rank)) . '</label>
                                <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : ترتيبك على الحمل </label>
                            </div>
                       </form>
                </div>
            </body>

</html>';

        return $html;
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------- renderGrainQueue---------------------------------- //
    // ---------------------------------------------------------------------------- //
    public function renderGrainsQueue($queue, $user_id = null)
    {


        $locationCore = new LocationCore();

        $destinationsArr = [];
        $destinations = "";
        // get destinations
        $tenderSearchFilter = [
            ['key' => 'truck_id', 'val' => $queue->truck_id],
            ['key' => 'tender_id', 'val' => $queue->tender_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);

        if ($tenderTruckResult->found_rows > 0) {
            foreach ($tenderTruckResult->data as $truck) {
                $questionnaire = json_decode($truck->questionnaire);
                foreach ($questionnaire[0]->val as $destination_id) {
                    $destinationsArr[] = $destination_id;
                }
            }

            $searchFilter = [['key' => 'id', 'val' => $destinationsArr, 'op' => 'in']];
            $locations_qry = $locationCore->searchLocation($searchFilter, 1000, 0, 0);
            foreach ($locations_qry->data as $location) {
                $destinations .= '<li class="liFont">' . $location->name . '</li>';
            }
        }
        $create_date = $queue->create_date;

        $html = '<html>
        <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
        <head>
        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

            <style>
                .MinagateFont {
                    font-family: DroidArabicKufiRegular;
                    font-weight: lighter;
                    font-style: normal;
                    color: #807d7d;
                    font-size: 11px;
                    margin-top: 22px;
                }
                .labelStyle {
                    text-align: right;
                    padding-right: 25px;
                }
                .valueStyle {
                    text-align: right;
                    color: rgb(74, 163, 222);
                }
                .divStyle {
                    padding: 4px;
                    border-bottom: solid 0.5px #ccc;
                }
            </style>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
        </head>
        <body>
            <div class="MinagateFont">
                <form>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("QUEUE.STATUS." . $queue->status) . '</label>
                        <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
                    </div>' . $this->renderActivationDate($queue) . '
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->rank . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : ترتيب الدور</label>
                    </div>
                    <div class="form-group  divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->serial . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : التسلسل</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->trn . ' + ' . $queue->tn . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم الشاحنة</label>
                    </div>
                    
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                            ' . $queue->tender_name . ' / ' . $queue->queue_name . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم المشروع</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                            ' . $queue->driver_name . ' - ' . str_replace("+", "", $queue->driver_phone) . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : السائق</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7  col-form-label valueStyle">
                            ' . $create_date . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : تاريخ الدور </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                            ' . $queue->truck_owner_name . ' - ' . str_replace("+", "", $queue->truck_owner_phone)  . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : اسم مالك الشاحنة </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" >
                            ' . $queue->total_delay . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عدد أيام التأجيل </label>
                    </div>    
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;">
                            ' . ($this->getPendingQueues($queue->tender_id, $queue->q_id, $queue->rank)) . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : الشاحنات المؤجلة </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;color:#a90329">
                        ' . $queue->contract_status_note . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عقد الشاحنة </label>
                    </div>

                    <div class="row ">
                        <div class="col-xs-12 text-center">
                            <h4 style="margin: 0;">الوجهات</h4>
                        </div>
                        <div  class="col-xs-12 padding">
                            <ol style="direction: rtl;">
                               ' . $destinations . '
                            </ol>
                        </div>
                    </div>

                </form>
            </div>
        </body>
        </html>';

        return $html;
    }



    // ---------------------------------------------------------------------------------- //
    // ------------------------- render Jo Petrol Queue --------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function renderJo_PetrolQueue($queue)
    {

        $create_date = $queue->create_date;

        if (!$queue->total_delay) {
            $queue->total_delay = "0";
        }

        // get number of pending trucks on the same queue
        $pendingSearchFilter = [
            ['key' => 'status', 'val' => ['PENDING', 'HELD'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $queue->tender_id],
            ['key' => 'rank', 'val' => $queue->rank, 'op' => "less than"],
            ['key' => 'q_id', 'val' => $queue->q_id]
        ];
        $pendingQueueSearchResult = $this->searchQueue($pendingSearchFilter, 1, 0, 0);
        $pending_trucks = $pendingQueueSearchResult->found_rows;


        $html = '<html>
        <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
        <head>
        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

            <style>
                .MinagateFont {
                    font-family: DroidArabicKufiRegular;
                    font-weight: lighter;
                    font-style: normal;
                    color: #807d7d;
                    font-size: 11px;
                    margin-top: 22px;
                }
                .labelStyle {
                    text-align: right;
                    padding-right: 25px;
                }
                .valueStyle {
                    text-align: right;
                    color: rgb(74, 163, 222);
                }
                .divStyle {
                    padding: 4px;
                    border-bottom: solid 0.5px #ccc;
                }
            </style>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
        </head>
        <body>
            <div class="MinagateFont">
                <form>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("QUEUE.STATUS." . $queue->status) . '</label>
                        <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
                    </div>' . $this->renderActivationDate($queue) . '
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->rank . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : ترتيب الدور</label>
                    </div>
                    <div class="form-group  divStyle row">
                            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $queue->serial . '</label>
                            <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : التسلسل</label>
                        </div>
                        <div class="form-group divStyle row">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $queue->trn . ' + ' . $queue->tn . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم الشاحنة</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                                ' . $queue->tender_name . ' / ' . $queue->queue_name . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : اسم المشروع</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                                ' . $queue->driver_name . ' - ' . str_replace("+", "", $queue->driver_phone) . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle"> : السائق</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7  col-form-label valueStyle">
                                ' . $create_date . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : تاريخ الدور </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                                ' . $queue->truck_owner_name . ' - ' . str_replace("+", "", $queue->truck_owner_phone)  . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : اسم مالك الشاحنة </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" >
                            ' . $queue->total_delay . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عدد أيام التأجيل </label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" >
                            ' . $pending_trucks . '</label>
                        <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : عدد الشاحنات المؤجلة </label>
                    </div>
                </form>
            </div>
        </body>
        </html>';

        return $html;
    }


    // ---------------------------------------------------------------------------------------- //
    // --------------- return pending qalab and pending trucks which is less than rank------------ //
    // ---------------------------------------------------------------------------------------- //

    public  function getPendingQueues($tender_id, $q_id, $rank)
    {

        // get number of pending trucks on the same queue (Trilla)
        $pendingSearchFilter_trilla = [
            ['key' => 'status', 'val' => ['PENDING', 'HELD'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'trail_minor_tt', 'val' => 203],
            ['key' => 'rank', 'val' => $rank, 'op' => "less than"],
            ['key' => 'q_id', 'val' => $q_id]
        ];
        $pendingQueueSearchResult = $this->searchQueue($pendingSearchFilter_trilla, 1, 0, 0);
        $pending_trucks_trilla = $pendingQueueSearchResult->found_rows;

        // get number of pending trucks on the same queue (Gallab)
        $pendingSearchFilter_gallab = [
            ['key' => 'status', 'val' => ['PENDING', 'HELD'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'trail_minor_tt', 'val' => 201],
            ['key' => 'rank', 'val' => $rank, 'op' => "less than"],
            ['key' => 'q_id', 'val' => $q_id]
        ];
        $pendingQueueSearchResult = $this->searchQueue($pendingSearchFilter_gallab, 1, 0, 0);
        $pending_trucks_gallab = $pendingQueueSearchResult->found_rows;

        return $pending_trucks_trilla . " تريلا / " . $pending_trucks_gallab . " قلاب" . " (" . (intval($pending_trucks_trilla) + intval($pending_trucks_gallab)) . ")";
    }


    // -------------------------------------------------------
    public  function getQueueRankByCargos($queue_id, $tender_id, $q_id, $rank)
    {

        // get info of the queue truck
        $sql1 = "SELECT
                    w.document->>'$.cargo[0].cargo.id' cargo_id
                FROM
                    queue_view q left join waybill w on w.truck_id = q.truck_id and w.tender_id = ? and w.status in ('NEW','APPROVED','ACTIVE')
                WHERE
                        q.id = ?";

        $result1 = DBConnection::runBindDatabaseQuery($sql1, [$tender_id, $queue_id]);

        $cargo_id = $result1[0]->cargo_id;


        // get number of trucks that has the same cargo
        $sql2 = "SELECT
                count(w.id) cnt , w.document->>'$.cargo[0].cargo.name' as cargo_name
            FROM
                queue_view q left join waybill w on w.truck_id = q.truck_id and w.tender_id = ? and w.status in ('NEW','APPROVED','ACTIVE')
            WHERE
                q.tender_id = ? AND q.q_id = ?
                    AND q.rank IS NOT NULL
                    and rank <= ?
                    and w.document->>'$.cargo[0].cargo.id' = ?
                    group by w.document->>'$.cargo[0].cargo.name'";

        $result2 = DBConnection::runBindDatabaseQuery($sql2, [$tender_id, $tender_id, $q_id, $rank, $cargo_id]);

        return  $result2[0]->cargo_name . ' هو: ' . $result2[0]->cnt;
    }

    // ------------------------------------------------------------------------------------------------ //
    // -------------- get the first truck on queue with status = ACTIVE' and tender truck active ------ //
    // ------------------------------------------------------------------------------------------------ //
    public function getNextTruck($tender_id, $q_id)
    {
        //
        $sql = "SELECT
                    q.*,
                    t.status,
                    'save_and_print' as action
                FROM
                    queue_view q,
                    tender_truck t
                WHERE
                    q.tender_id = ? AND q.q_id = ?
                        AND q.status = 'ACTIVE'
                        AND q.truck_id = t.truck_id
                        AND t.tender_id = q.tender_id
                        AND t.status = 'ACTIVE'
                ORDER BY rank
                LIMIT 1";

        $result = DBConnection::runBindDatabaseQuery($sql, [$tender_id, $q_id]);


        $queueResult = new stdClass();
        $queueResult->found_rows = sizeof($result);
        $queueResult->data = $result;

        return $queueResult;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------------- renderGrainQueue---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderInvaildQueue()
    {

        $html = '<html>
    <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >

<head>
<link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

    <style>
        .MinagateFont {
            font-family: DroidArabicKufiRegular;
            font-weight: lighter;
            font-style: normal;
            color: #807d7d;
            font-size: 11px;
            margin-top: 22px;
        }
        .labelStyle {
            text-align: right;
            padding-right: 25px;
        }
        .valueStyle {
            text-align: right;
            color: rgb(74, 163, 222);
        }
        .divStyle {
            padding: 4px;
            border-bottom: solid 0.5px #ccc;
        }
    </style>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
</head>
<body>
    <div class="MinagateFont">
    <h2 style="text-align: center">لا يمكن عرض معلومات الدور</h2>
      </div>
</html>';

        return $html;
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of trucks on a certain queue ------------------- //
    // ------------------------------------------------------------------------------- //
    public function searchQueueTrucks($queueFilter, $limit, $offset, $userId, $sort = "desc")
    {
        $queueResult = $this->searchQueue(
            $queueFilter,
            $limit,
            $offset,
            $userId,
            $sort
        );

        // remove time from activation date
        $currentTime = DBConnection::getSystemDate();
        foreach ($queueResult->data as &$queue) {
            try {
                $date = date_create($queue->activation_date);
                $queue->activation_date = date_format($date, 'Y-m-d');

                $queue->server_date = $currentTime;
            } catch (Exception $e) {
            }
        }

        return $queueResult;
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- Create yard batch --------------------------------------- //
    // ------------------------------------------------------------------------------- //
    public function createYardBatch($tenderId, $qId, $details, $questionnaire, $uId)
    {

        if (!is_string($questionnaire)) {
            $questionnaire = json_encode($questionnaire, JSON_UNESCAPED_UNICODE);
        }
        if (!is_string($details)) {
            $details = json_encode($details);
        }
        $qry = "INSERT INTO `yard_batch`
        (`tender_id`, `q_id`, `details`, `status`, `questionnaire`, `update_by`)
         VALUES (?, ?, ?, ?, ?, ?);";
        return DBConnection::runBindDatabaseQuery($qry, [$tenderId, $qId, $details, "ACTIVE", $questionnaire, $uId]);
    }


    // --------------------------------------------------------------------------------------- //
    // ----------------------- Push truck to yard -------------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function pushTruckToYard($tender_id, $yard_queue_id, $truck_id, $trailer_id, $driver_id, $waybill_id)
    {

        $waybillCore = new WaybillCore();
        $queueCore = new QueueCore();

        // validate if the waybill truck is indivisual (company waybills are not allowed to enter the yard)
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        $trucking_company_id = $waybillBean->document->carrier[0]->tc->id;

        // get permit_ticket_creation_method (طريقة التفويج)
        $permit_ticket_creation_method = "";
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $queues = $man['queues'];
        foreach ($queues as $q) {
            if ($q['id'] == $yard_queue_id) {
                $permit_ticket_creation_method = $q['permit_ticket_creation_method'];
            }
        }

        // search if the truck is already added to Itihad queue
        $activeQueueStatus = DBConnection::getActiveStatus('queue');
        $queueSearchFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'q_id', 'val' => $yard_queue_id],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
        ];
        $queueTruckResult = $this->searchQueue($queueSearchFilter, 1, 0, 0);

        // if the truck is not in itihad queue, see if must be added based on (طريقة التفويج)
        switch ($permit_ticket_creation_method) {

                // auto: add to queue and create permit ticket automatically
            case 'auto':
                if ($queueTruckResult->found_rows == 0) {
                    $truckQueueId = $queueCore->addQueue($truck_id, $driver_id, $trailer_id, $yard_queue_id, $tender_id, 0);
                }
                $waybillCore->createPermitTicket($waybill_id, $truckQueueId);
                break;

                // manual: add to queue only and leave the ticket for operation to create
            case 'manual':
                if ($queueTruckResult->found_rows == 0) {
                    $truckQueueId = $queueCore->addQueue($truck_id, $driver_id, $trailer_id, $yard_queue_id, $tender_id, 0);
                }
                break;

                // manual_without_ticket: add to queue only and leave the ticket for operation to create
            case 'manual_without_ticket':
                if ($queueTruckResult->found_rows == 0) {
                    $truckQueueId = $queueCore->addQueue($truck_id, $driver_id, $trailer_id, $yard_queue_id, $tender_id, 0);
                }
                break;

                // auto_without_ticket: dont add to queue and dont create any ticket
            case 'auto_without_ticket':
                # do nothing
                break;
        }
    }


    public function getNewTrucksOnQueue($tender_id, $q_id, $duration)
    {

        $sql1 = "select DATE_FORMAT(activity->>'$[0].activity_date','%Y-%m-%d') as create_date,
                        count(t.tn) as cnt 
         from queue q, truck t
                    where tender_id = ?
                    and q.q_id = ?
                    and activity->>'$[0].user_id' <> 0
                    and q.status != 'INACTIVE'
                    and DATE_FORMAT(activity->>'$[0].activity_date','%Y-%m-%d') >= ?
                    and q.truck_id = t.id                    
                group by DATE_FORMAT(activity->>'$[0].activity_date','%Y-%m-%d')";

        $from_date =  date("Y-m-d", strtotime("- " . $duration . " day"));
        $result1 = DBConnection::runBindDatabaseQuery($sql1, [$tender_id, $q_id, $from_date]);

        return $result1;
    }
}
