<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/assign_cargo/assign_cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../../core/woq/woq_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/container.php");


class publicAPI extends API
{

    // the request of each call
    private $_request = array();
    private $_queueCore;
    private $_tenderCompanyCore;
    private $_tenderCore;
    private $_waybillOrderCore;
    private $_assignCargoCore;
    private $_fps;
    private $_con;


    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        self::cors();

        // init the object
        $this->_queueCore = new QueueCore();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_tenderCore = new TenderCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_assignCargoCore = new AssignCargoCore();
        $this->_fps = new FPS();
        $this->_con = new Container();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    public function renderTodayOrder()
    {

        // grains
        $info1 = $this->getTodayTenderOrderDetails(13, date("Y-m-d"));
        $summary_info = $this->getTodayTenderOrderSummary(13, date("Y-m-d"));

        $html = '<div class="form-group divStyle row" style="background-color:#97c667">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white"> مشروع التموين </label>
                </div>
                <div class="grains_subtitle">
                    <label class="col-sm-6  col-md-6 col-xs-6 col-form-label labelStyle"> حصة الأفراد ' . $summary_info->total_indevedual_share . '</label>
                </div>';
        $html .= $this->renderOrders($info1->orders);

        // vessels
        $info2 = $this->getTodayTenderOrderDetails(3, date("Y-m-d"));
        $html .= '<div class="form-group divStyle row" style="background-color:#97c667">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white"> مشروع البواخر </label>
                </div>';
        $html .= $this->renderOrders($info2->orders);

        // Crude oil
        $info3 = $this->getTodayTenderOrderDetails(11, date("Y-m-d"));

        $html .= '<div class="form-group divStyle row" style="background-color:#97c667">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white"> مشروع النفط </label>
                </div>';
        $html .= $this->renderJoPetrolOrders($info3->orders);

        // Fuel oil
        $info4 = $this->getTodayTenderOrderDetails(12, date("Y-m-d"));

        $html .= '<div class="form-group divStyle row" style="background-color:#97c667">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white"> الفيول </label>
                </div>';
        $html .= $this->renderFuelOrders($info4->orders);

        $html = preg_replace('/\s+/', ' ', $html);
        echo $html;
    }

    private function renderOrders($info)
    {

        $divs = [];

        if (sizeof($info) > 0) {
            foreach ($info as $UI_order) {
                if ($UI_order->individual_share && $UI_order->individual_share > 0) {

                    if ($UI_order->individual_approved_waybill_orders > $UI_order->individual_share) {
                        $UI_order->individual_approved_waybill_orders = $UI_order->individual_share;
                    }

                    if (!$UI_order->q_id) {
                        $UI_order->q_id = 0;
                    }
                    $html .= '<div class="queue_' . $UI_order->q_id . "_" . $UI_order->tender_id . '">';

                    $html .= '
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->queue_name . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : الدور</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->destination . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : موقع التفريغ</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->minor_tt . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : النمط</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->cargo_name . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : الحمولة</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->extra_note . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : ملاحظات</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->individual_share . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : حصة الأفراد</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->serial . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تسلسل الدور	</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->create_date . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تاريخ الدور</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->individual_approved_waybill_orders . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> :عدد الشاحنات المثبتة	</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $UI_order->pending_trucks . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : عدد الشاحنات المؤجلة </label>
                        </div>
                    <div class="form-group divStyle row" style="background-color:#eee">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white">  </label>
                    </div>
                    </div>
                        ';
                }
                $UI_order = null;
            }
        } else {
            $html = '<div class="form-group divStyle row">
                <label class="col-sm-12  col-xs-12   col-md-12  col-form-label valueStyle"> لا توجد طلبيات لهذا اليوم</label>
            </div>';
        }

        return $html;
    }

    private function renderJoPetrolOrders($info)
    {

        $divs = [];
        if (sizeof($info) > 0) {
            foreach ($info as $order) {
                if ($order->individual_share && $order->individual_share > 0) {

                    $high_sql = "SELECT
                                        w.document->>'$.integeration_details.queue.serial' as serial
                                from
                                    waybill w , queue q
                                where w.tender_id = 11 and w.create_date  > CURDATE() -1
                                and w.document->>'$.integeration_details.queue.queue_id' = q.id
                                order by w.id desc
                                limit 1
                                ";
                    $high_sql_result = DBConnection::runBindDatabaseQuery($high_sql, []);
                    $highest_serial = $high_sql_result[0]->serial;

                    if (!$order->q_id) {
                        $order->q_id = 0;
                    }
                    $html .= '<div class="queue_' . $order->q_id . "_" . $order->tender_id . '">';

                    $html .= '
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->queue_name . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : الدور</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->destination . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : موقع التفريغ</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->minor_tt . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : النمط</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->individual_share . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : عدد الشاحنات</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->waybills . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : عدد الإرساليات</label>
                    </div>

                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $highest_serial . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تسلسل الدور	</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->create_date . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تاريخ الدور</label>
                    </div>
                    <div class="form-group divStyle row" style="background-color:#eee">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white">  </label>
                    </div>
                    </div>
                        ';
                }
            }
        } else {
            $html = '<div class="form-group divStyle row">
                <label class="col-sm-12  col-xs-12   col-md-12  col-form-label valueStyle"> لا توجد طلبيات لهذا اليوم</label>
            </div>';
        }

        return $html;
    }

    private function renderFuelOrders($info)
    {

        $divs = [];
        if (sizeof($info) > 0) {
            foreach ($info as $order) {
                if ($order->individual_share && $order->individual_share > 0) {

                    if (!$order->q_id) {
                        $order->q_id = 0;
                    }
                    $html .= '<div class="queue_' . $order->q_id . "_" . $order->tender_id . '">';

                    $html .= '
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->queue_name . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : الدور</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->destination . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : موقع التفريغ</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->minor_tt . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : النمط</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->individual_share . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : عدد الشاحنات</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->approved_waybill_orders . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : عدد الشاحنات المثبتة</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->serial . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تسلسل الدور	</label>
                    </div>
                    <div class="form-group divStyle row">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $order->create_date . '</label>
                        <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle"> : تاريخ الدور</label>
                    </div>
                    <div class="form-group divStyle row" style="background-color:#eee">
                    <label class="col-sm-12  col-md-12 col-xs-12 col-form-label labelStyle" style="color:white">  </label>
                    </div>
                    </div>
                        ';
                }
            }
        } else {
            $html = '<div class="form-group divStyle row">
                <label class="col-sm-12  col-xs-12   col-md-12  col-form-label valueStyle"> لا توجد طلبيات لهذا اليوم</label>
            </div>';
        }

        return $html;
    }

    private function getTodayTenderOrderSummary($tender_id, $order_date)
    {

        $assignFilter = [];
        $assignFilter[] = ['key' => 'update_date', 'val' => $order_date, 'op' => 'date greater than'];
        $assignFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
        $assignFilter[] = ['key' => 'status', 'val' => ['REVOKED', 'INACTIVE'], 'op' => 'not in'];

        $assignResult = $this->_assignCargoCore->searchAssignCargo($assignFilter, 100, 0, 0);

        $total_trucks = 0;
        $total_indevedual_share = 0;
        foreach ($assignResult->data as $assignCargo) {
            $total_trucks += json_decode($assignCargo->details)->info->total_count;
            $queueAssigned = json_decode($assignCargo->queue_assign)->approved;
            if ($queueAssigned) {
                $total_indevedual_share += sizeof($queueAssigned);
            }
        }


        $result = new stdClass();
        $result->total_trucks = $total_trucks;
        $result->total_indevedual_share = $total_indevedual_share;
        return $result;
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------------------- get tender orders stats for today orders ------------------------ //
    // ----------------------------------------------------------------------------------------- //
    private function getTodayTenderOrderDetails($tender_id, $order_date)
    {

        // get todays orders
        $orders = DBConnection::getTodayTenderOrderDetails($tender_id, $q_id, $order_date);

        $total_trucks = 0;
        $total_indevedual_share = 0;

        // get the tender code
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $tender_code = $man['tender_code'];

        // ------------------------ GRAINS --------------------------------- //
        if ($tender_code == "GRAINS") {

            // get the tender_company of the tender and the indivesual company id
            $tenderCompanyFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1000, 0, 0);
            $indivisualTenderCompanyIds = [];
            foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
                $service_list = json_decode($tenderCompany->service_list);
                foreach ($service_list as $service) {
                    if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {
                        $indivisualTenderCompanyIds[] = $tenderCompany->id;
                    }
                }
            }

            foreach ($orders as &$order) {
                // get individual share
                $sqlQuery = "select count(id) share from waybill_order where tender_order_id = ?
                             and queue_id is not null and
                             status not in  ('REVOKED')";
                $param = [$order->tender_order_id];
                $individual_share = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $order->individual_share = $individual_share[0]->share;

                if ($order->q_id == "other")
                    $order->individual_share = $order->total_trucks;

                // get number of individual approved and closed waybill orders on this tender_order
                $waybillOrderFilter = [
                    ['key' => 'tender_order_id', 'val' => $order->tender_order_id],
                    ['key' => 'queue_id', 'op' => 'is not null'],
                    ['key' => 'status', 'val' => ['APPROVED', 'CLOSED'], 'op' => 'in']
                ];
                $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0, 0);

                $order->individual_approved_waybill_orders = $waybillOrderSearchResult->found_rows;


                if ($order->q_id == "other")
                    $order->individual_approved_waybill_orders = $order->total_trucks;

                // parse tender questionarre
                if ($tender_code == "GRAINS" || $tender_code == "VESSELS") {
                    $destination_id = json_decode($order->questionnaire)[0]->val;
                    $destination = getLocationName($destination_id);
                    $order->destination = $destination;

                    $origin_id = json_decode($order->questionnaire)[1]->val;
                    $origin = getLocationName($origin_id);
                    $order->origin = $origin;

                    $minor_tt = json_decode($order->questionnaire)[2]->val;
                    if ($minor_tt == "201")
                        $order->minor_tt = "قلاب";
                    if ($minor_tt == "203")
                        $order->minor_tt = "تريلا";
                    if ($minor_tt == "*")
                        $order->minor_tt = "جميع الأنماط";
                }

                // get number of pending trucks less than max queue id
                $queueFilter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'q_id', 'val' => $order->q_id],
                    ['key' => 'id', 'val' => $order->latest_queue_id, 'op' => 'less than'],
                    ['key' => 'status', 'val' => "PENDING"]
                ];
                $queueResult = $this->_queueCore->searchQueue($queueFilter, 10000, 0, 0);

                //filter above result based on tender_truck questionarre if truck accept to go to destionation
                $truck_ids = [];
                foreach ($queueResult->data as $queue) {
                    $truck_ids[] = $queue->truck_id;
                }
                $tenderTruckFilter = [
                    ['key' => 'truck_id', 'val' => $truck_ids, 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in'],
                    ['key' => 'tender_id', 'val' => $tender_id]
                ];
                $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1000, 0, 0);
                $pending_trucks = 0;
                foreach ($tenderTruck_qry->data as $tenderTruck) {
                    $questionnaire = json_decode($tenderTruck->questionnaire);
                    if ($tender_code == "GRAINS" || $tender_code == "VESSELS") {
                        if (in_array($destination_id, $questionnaire[0]->val)) {
                            $pending_trucks++;
                        }
                    }
                }
                $order->pending_trucks = $pending_trucks;
            }
        } else if ($tender_code == "VESSELS") {

            foreach ($orders as &$order) {
                // get individual share
                $order->individual_share = $order->total_trucks;

                // get number of individual approved and closed waybill orders on this tender_order
                $waybillOrderFilter = [
                    ['key' => 'tender_order_id', 'val' => $order->tender_order_id],
                    ['key' => 'queue_id', 'op' => 'is not null'],
                    ['key' => 'status', 'val' => ['APPROVED', 'CLOSED'], 'op' => 'in']
                ];
                $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0, 0);
                $order->individual_approved_waybill_orders = $waybillOrderSearchResult->found_rows;

                // parse tender questionarre
                $destination_id = json_decode($order->questionnaire)[0]->val;
                $destination = getLocationName($destination_id);
                $order->destination = $destination;

                $origin_id = json_decode($order->questionnaire)[1]->val;
                $origin = getLocationName($origin_id);
                $order->origin = $origin;

                $minor_tt = json_decode($order->questionnaire)[2]->val;
                if ($minor_tt == "201")
                    $order->minor_tt = "قلاب";
                if ($minor_tt == "203")
                    $order->minor_tt = "تريلا";
                if ($minor_tt == "*")
                    $order->minor_tt = "جميع الأنماط";

                // get number of pending trucks less than max queue id
                $queueFilter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'q_id', 'val' => $order->q_id],
                    ['key' => 'id', 'val' => $order->latest_queue_id, 'op' => 'less than'],
                    ['key' => 'status', 'val' => "PENDING"]
                ];
                $queueResult = $this->_queueCore->searchQueue($queueFilter, 10000, 0, 0);
                $order->pending_trucks = $queueResult->found_rows;
            }
        } else if ($tender_code == "JO_PETROL_AQ") {

            // get orders
            $sqlQuery = "select * from tender_order_view where date(order_date) = ? and status = 'ACTIVE' and tender_id = ?";
            $param = [$order_date, $tender_id];
            $orders = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            foreach ($orders as $order) {
                $order->individual_share = $order->trucks;
                $order->destination = "مصفاة البترول في الزرقاء";
                $order->minor_tt = "صهريج نفط";

                // get max serial
                $sqlQuery = "select CAST(document AS CHAR CHARSET UTF8) AS document
                     from waybill where tender_id = ? and date(create_date) = ? order by id desc limit 1";
                $param = [$tender_id, $order_date];
                $waybills = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $document = $waybills[0]->document;
                $serial = json_decode($document)->integeration_details->queue->serial;

                $order->serial = $serial;

                //get queue create date
                $sqlQuery = "select create_date from queue where tender_id = ? and serial = ?";
                $param = [$tender_id, $serial];
                $queue = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $order->create_date = $queue[0]->create_date;
                $order->individual_approved_waybill_orders = "-";

                $order->waybills = $order->waybill_count;
            }
        } else if ($tender_code == "JO_PETROL_FUEL") {

            // get orders
            $sqlQuery = "SELECT
                            t.*
                        FROM
                            tender_order_view t,
                            activity a
                        WHERE
                            a.action_code = 'CREATE'
                                AND a.tender_order_id = t.id
                                AND date(a.activity_date) = ?
                                AND t.status IN ('ACTIVE' , 'PENDING', 'CLOSED')
                                AND t.tender_id = ?
                                AND t.q_id = 1";
            $param = [$order_date, $tender_id];
            $orders = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            foreach ($orders as &$order) {
                $order->individual_share = $order->trucks;
                $destination_id = json_decode($order->questionnaire)[0]->val;
                $destination = getLocationName($destination_id);
                $order->destination = $destination;
                $order->minor_tt = "صهريج نفط";

                // get max serial
                $sqlQuery = "select CAST(document AS CHAR CHARSET UTF8) AS document
                 from waybill where tender_id = ? and date(create_date) = ? order by id desc limit 1";
                $param = [$tender_id, $order_date];
                $waybills = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $document = $waybills[0]->document;
                $serial = json_decode($document)->integeration_details->queue->serial;
                $order->serial = $serial;

                $waybillOrderFilter = [
                    ['key' => 'tender_order_id', 'val' => $order->id],
                    ['key' => 'status', 'val' => ['APPROVED', 'CLOSED'], 'op' => 'in']
                ];
                $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0, 0);
                $order->approved_waybill_orders = $waybillOrderSearchResult->found_rows;

                //get queue create date
                $sqlQuery = "select create_date from queue where tender_id = ? and serial = ?";
                $param = [$tender_id, $serial];
                $queue = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                $order->create_date = $queue[0]->create_date;
                $order->individual_approved_waybill_orders = "-";
                $order->waybills = $order->waybill_count;
            }
        }

        try {
            // pack everything
            $result = new stdClass();
            $result->orders = $orders;
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public static function cors()
    {

        // Allow from any origin
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            $http_origin = $_SERVER['HTTP_ORIGIN'];
            header("Access-Control-Allow-Origin: $http_origin");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        } else {
            header("Access-Control-Allow-Origin: *");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        }

        // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }

        //echo "You have CORS!";
    }
    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //

    public function searchInquiry()
    {
        $url = Config::$minagate_waybill_base_url . "/waybill";

        $params = [
            "method" => "searchinquiry",
            "value" => $this->_request->value,
            "limit" => $this->_request->limit,
            "offset" => $this->_request->offset,
        ];

        $response = $this->curl($url, $params, 'POST');
        parent::response($response);
    }



    public function getLandTripTemplate()
    {
        $url = Config::$minagate_waybill_base_url . "container";

        $params = [
            "method" => "getLandTripTemplate",
            "value" => $this->_request->value,
        ];
        $response = $this->curl($url, $params, 'POST');
        parent::response($response);
    }

    public function getServiceOptions()
    {
        $result = [
            ["id" => "9", "label" => "بدل اصدار CRN", "group_name" => null, "is_selected" => true],
            ["id" => "0", "label" => "تسليم حاوية في الساحة اليوم", "group_name" => "delay_handel", "is_selected" => true],
            ["id" => "22", "label" => "تسليم حاوية في الساحة بعد 24 ساعة", "group_name" => "delay_handel", "is_selected" => false],
            ["id" => "23", "label" => "تسليم حاوية في الساحة بعد 48 ساعة", "group_name" => "delay_handel", "is_selected" => false],
            ["id" => "24", "label" => "تسليم حاوية في الساحة بعد 72 ساعة", "group_name" => "delay_handel", "is_selected" => false]
        ];

        parent::response($result);
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {

        $fields['device_token'] = $this->getIntegrationToken();

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            // 'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {
        return '78XMDKH3jnekqvGh';
    }

    public function getAccountAuthority()
    {
        $session_id = $this->_request->session_id;
        $sessionObj = parent::getSession($session_id);
        $sessionObj = json_decode(json_encode($sessionObj), true);
        $details = json_decode($sessionObj['details']);
        $sessionObj['type'] = $details->type;
        $sessionObj['company_employee_id'] = $details->company_employee_id;
        $accountCore = new AccountCore();
        $account_ids = $accountCore->getAccountAuthority($sessionObj);


        if ($account_ids) {
            parent::response($account_ids);
        } else {
            parent::response(["*"]);
        }
    }

    public function renderMgVoucherInfo()
    {

        // read input from params
        $hash_key =  $this->_request->voucher_id;

        // search for item and get its value
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->status = "NEW";
        $filterObj->filter->payee_reference_code = "TRUCK_OWNER";
        $filterObj->limit = 10000;
        $fps = new FPS();
        $claimsQry =  $fps->searchClaims($filterObj, $_SESSION['user_id']);

        // take the ids and then search for its claim items
        $claim_ids = [];
        foreach ($claimsQry['data'] as $claim) {
            $claim_ids[] = $claim["id"];
        }
        if (sizeOf($claim_ids) == 0) {
            return [];
        }

        // search for claim_items
        $data = new stdClass();
        $filter = new stdClass();
        $filter->claim_ids_in = $claim_ids;
        $data->filter = $filter;
        $data->limi = 1000;
        $claimItemsQry = $fps->searchClaimItems($data, 0);

        // loop on them and has each id to match it with requested private_key
        foreach ($claimItemsQry['data'] as $claimItem) {
            $hash_claim_item_id = md5($claimItem["id"]);
            // when found , extract the needed info
            $value1 = substr($hash_claim_item_id, 0, 20);
            $value2 = substr($hash_key, 0, 20);
            if ($value1 == $value2) {
                $claimResult = $claimItem;
            }
        }


        $details = json_decode($claimResult['details']);
        $details->amount = $claimResult['requested_amount'];

        $secret = $hash_key;
        $encoder = 'https://chart.googleapis.com/chart?chs=200x200&chld=M%7C0&cht=qr&chl=';
        $QR_code_url = $encoder . $secret;
        $data = new stdClass();
        $data->voucher_details = $details;
        $data->QR_code_url = $QR_code_url;
        $data->available_stations = $this->getAvailable_stations();
        parent::response($data);
    }

    public function renderAvailableStatios()
    {
        $data = new stdClass();
        $data->available_stations = $this->getAvailable_stations();
        parent::response($data);
    }

    private function getAvailable_stations()
    {
        return [
            ["name" => "الجيزة - زيزيا", "location" => "https://goo.gl/maps/DuT1nST2qwnJjrFK8", "image" => "station_1.jpeg", "image_url" => "https://storage.googleapis.com/g.minagate.com/station_1.jpeg"],
            ["name" => "القطرانة 2 - توتال", "location" => "https://g.page/qatranah-gas-oil?share", "image" => "station_2.jpeg", "image_url" => "https://storage.googleapis.com/g.minagate.com/station_2.jpeg"],
            ["name" => "الرجيب - الجويدة شارع سحاب", "location" => "https://goo.gl/maps/NRCddJZhADNBSf1Y7", "image" => "station_3.jpeg", "image_url" => "https://storage.googleapis.com/g.minagate.com/station_3.jpeg"],
            ["name" => "الهاشمية - لواء الحسينية", "location" => "https://goo.gl/maps/aLBgpAkqpuAz1mGR7", "image" => "station_4.jpeg", "image_url" => "https://storage.googleapis.com/g.minagate.com/station_4.jpg"],
            ["name" => "الحسا - توتال (قريبا)", "location" => "https://goo.gl/maps/MXhKUdjU4Sv9bDLs6", "image" => "station_5.jpeg", "image_url" => "https://storage.googleapis.com/g.minagate.com/station_5.jpg"]
        ];
    }


    public function getVoucherDetails($hashed_hey, $filter)
    {
        // parse incoming data
        $private_key = $hashed_hey;

        $data = new stdClass();
        $data->filter = $filter;
        if (gettype($data->filter) == "string") {
            $data->filter = json_decode($data->filter);
        }
        $pendingVouchers = $this->_fps->searchVouchers($data, 0);
        // loop on them and has each id to match it with requested private_key
        foreach ($pendingVouchers['data'] as $voucher) {
            $hash_voucher_id = md5($voucher["id"]);
            // when found , extract the needed info

            $value1 = substr($hash_voucher_id, 0, 20);
            $value2 = substr($private_key, 0, 20);
            if ($value1 == $value2) {
                $voucherResult = $voucher;
            }
        }

        $res = new stdClass();
        $res->voucherResult = $voucherResult;
        $res->company_id = $pendingVouchers["company_id"];

        // return result
        return $res;
    }

    // ----------------------------------------------------------------------- //
    // -------------------- get Merchant bean for company ----------------------------- //
    // ----------------------------------------------------------------------- //
    public function getMerchantCompany()
    {

        $merchant_id = $this->_request->merchant_id;

        if ($merchant_id == 2) {
            $companyBean =  new stdClass();
            $companyBean->print_header =  "ALWATANIAH FUEL STATION_GO GAS STATION";
            $companyBean->print_logo =  base64_encode(file_get_contents("https://storage.googleapis.com/waybill-system.appspot.com/print_logo_GO_print.jpg?" . rand()));
            $companyBean->color_logo =  base64_encode(file_get_contents("https://storage.googleapis.com/waybill-project.appspot.com/Go_logo.jpg"));
        }

        if ($merchant_id == 3) {
            $companyBean =  new stdClass();
            $companyBean->print_header =  "ALWATANIAH FUEL STATION_GO GAS STATION - BETA";
            $companyBean->print_logo =  base64_encode(file_get_contents("https://storage.googleapis.com/waybill-system.appspot.com/print_logo_GO_print.jpg?" . rand()));
            $companyBean->color_logo =  base64_encode(file_get_contents("https://storage.googleapis.com/waybill-system.appspot.com/Go_logo_Beta.jpg"));
        }
        parent::response($companyBean);
    }

    // ----------------------------------------------------------------------- //
    // -------------------- get Merchant bean for company ----------------------------- //
    // ----------------------------------------------------------------------- //
    public function getTruckClaims()
    {
        // get user input field
        $input = $this->_request->input;

        // if the length is 10 then the input is wn
        if (strlen($input) == 10) {
            $waybills = $this->_waybillCore->searchWaybills([['key' => 'wn', 'val' => $input]], 1, 0, 0);
            $tn = $waybills->data[0]->tn;
        } else {
            $tn = $input;
        }

        // search for any claims for the truck
        $fps = new FPS();
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->tn = $tn;
        $filterObj->filter->status = "ACTIVE";
        $claimsReuslt =  $fps->searchClaims($filterObj, 0);

        $result = [];
        $totalAmount = 0;
        foreach ($claimsReuslt['data'] as $claim) {

            // get claim items
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_id = $claim['id'];
            $items = $this->_fps->searchClaimItems($data, 0);

            foreach ($items['data'] as $item) {
                $details = json_decode($item['details']);

                $claim_date = date_format(date_create($item['create_date']), "Y-m-d");

                $result[] = [
                    'details' => $details->notes,
                    'amount' => $item['approved_amount'],
                    'date' => $claim_date
                ];

                $totalAmount += $item['approved_amount'];
            }

            if ($items['found_rows'] > 0) {
                $result[] = [
                    'details' => "صافي المبلغ",
                    'amount' => $totalAmount,
                    'date' => "",
                    'is_bold' => true
                ];
            }
        }

        parent::response($result);
    }



    // ----------------------------------------------------------------------- //
    // -------------------- get waybill info ----------------------------- //
    // ----------------------------------------------------------------------- //
    public function rendeWaybillInfo()
    {
        $waybillCore = new waybillCore();
        $woqCore = new WoqCore();

        $hash_wn = $this->_request->wn;

        $searchFilter = [];
        $searchFilter['query'] = $hash_wn;
        $searchFilter['table_names'] = "WAYBILL";
        $hashedResult = $woqCore->search($searchFilter, 1, 0, 0);

        $waybill_id = $hashedResult->data[0]->object_id;
        $filter = [
            ['key' => 'id', 'val' => $waybill_id]
        ];
        $waybills = $waybillCore->searchWaybills($filter, 1, 0, 0, ' order by id desc ');
        $waybillResult = new stdClass();

        // loop on waybills and convert each to md5 to match with waybill
        foreach ($waybills->data as &$waybill) {
            unset($waybill->search_index);
            $temp_hash_wn = md5($waybill->wn);

            // when found , extract the needed info
            if ($temp_hash_wn == $hash_wn) {
                $waybillResult = $waybill;
                break;
            }

            unset($temp_hash_wn);
            $temp_hash_wn = null;
        }

        $document = json_decode($waybillResult->document);

        $result = new stdClass();
        $result->wn = $waybillResult->wn;
        $result->tn = $waybillResult->tn;
        $result->trn = $waybillResult->trn;
        $result->driver_name = $document->carrier[0]->driver->name;
        $result->driver_phone = $document->carrier[0]->driver->phone;
        $result->driver_nn = $document->carrier[0]->driver->nn;
        $result->cargo_name = $document->cargo[0]->cargo->name;
        $result->origin_name = $document->negotiable_instructios->route->origin->name;
        $result->destination_name = $document->negotiable_instructios->route->destination->name;
        $result->tc_name = $document->carrier[0]->tc->name;
        if ($document->cargo[0]->weights->loading->time_stamp) {
            $result->loading_weight =  $document->cargo[0]->weights->loading->net_weight . " - " . date_format(date_create($document->cargo[0]->weights->loading->time_stamp), "Y-m-d");
        }
        if ($document->cargo[0]->weights->discharge->time_stamp) {
            $result->discharge_weight =  $document->cargo[0]->weights->discharge->net_weight . " - " . date_format(date_create($document->cargo[0]->weights->discharge->time_stamp), "Y-m-d");;
        }
        parent::response($result);
    }


    // ---------------------- For Full day interview ---------------------

    public function login()
    {
        $user_name = $this->_request->user_name;
        $password = $this->_request->password;

        if ($user_name == "admin" && $password == "123456") {
            parent::response("SUCCESSFUL.LOGIN");
        } else {
            throw new Exception("كلمة المرور غير صحيحة");
        }
    }

    public function searchCourses()
    {
        $result = [
            [
                "id" => 1,
                "name" => "The Complete Python Programming Course",
                "details" => "Learn A-Z everything about Python, from the basics, to advanced topics like Python GUI, Python Data Analysis, and more!",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/python.jpeg"
            ],
            [
                "id" => 2,
                "name" => "Beginning C++ Programming",
                "details" => "Obtain Modern C++ Object-Oriented Programming (OOP) and STL skills. C++14 and C++17 covered. C++20 info see below.",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/c.jpeg"
            ],
            [
                "id" => 3,
                "name" => "Microsoft Excel",
                "details" => "Excel with this A-Z Microsoft Excel Course. Microsoft Excel 2010, 2013, 2016, Excel 2019 and Microsoft/Office 365",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/excel.jpeg"
            ],
            [
                "id" => 4,
                "name" => "The Complete 2022 Web Development Bootcamp",
                "details" => "Become a Full-Stack Web Developer with just ONE course. HTML, CSS, Javascript, Node, React, MongoDB, build real projects",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/web.jpeg"
            ],
            [
                "id" => 5,
                "name" => "100 Days Of Code",
                "details" => "Learn web development from A to Z in 100 days (or at your own pace) - from basic to advanced, it's all included!",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/100.jpeg"
            ],
            [
                "id" => 6,
                "name" => "Working with React and Go",
                "details" => "Learn how to build a single page application in React, with data supplied by a Go back end REST API",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/react.jpeg"
            ],
            [
                "id" => 7,
                "name" => "Become a Web Developer from Scratch",
                "details" => "This course covers all you need to know about becoming a top skilled web developer even if you never programmed before!",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/scratch.jpeg"
            ],
            [
                "id" => 8,
                "name" => "Dart & Flutter",
                "details" => "2022 Complete Guide To Flutter Development - Build 7 Native Cross-Platform iOS and Android Apps Using Flutter.",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/dart.png"
            ],
            [
                "id" => 9,
                "name" => "Java/Apache Maven",
                "details" => "Apache Maven: Secrets of Building and Managing Java and Java Spring Projects. Learn to use the Java Build Tool.",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/java.jpeg"
            ],
            [
                "id" => 10,
                "name" => "Reactive Microservices",
                "details" => "Build highly scalable and resilient Microservices with Spring WebFlux / Reactive Stack",
                "image" => "https://storage.googleapis.com/waybill_system_config/Demo/reactive.png"
            ]
        ];
        parent::response($result);
    }

    public function getCourseDetails()
    {
        $id = $this->_request->id;

        $result = [];
        $result["1"] = [
            "id" => 1,
            "details" => "Do you want to become a programmer? Do you want to learn how to create games, automate your browser, visualize data, and much more?
            If you’re looking to learn Python for the very first time or need a quick brush-up, this is the course for you!            
            Python has rapidly become one of the most popular programming languages around the world. Compared to other languages such as Java or C++, Python consistently outranks and outperforms these languages in demand from businesses and job availability. The average Python developer makes over $100,000 - this number is only going to grow in the coming years.",
            "price" => "14.99 $",
            "instructor" => "Avinash Jain",
            "reviews" => [
                ["name" => "Armin", "rating" =>  "2", "details" => "He doesn't go in detail about his code. Just writes random code and doesn't explain things. I am already an experienced, but I'm talking from a beginner's point of view. He's literally just writing code and doesn't explain things."],
                ["name" => "Keegan B.", "rating" =>  "5", "details" => "Mic quality is bad, but the content is good"],
                ["name" => "Julian R.", "rating" =>  "1", "details" => "It is a nice course. Nevertheless, some of the content and functions need to be updated to match the current python version"]
            ]
        ];

        $result["7"] = [
            "id" => 7,
            "details" => "Become a Web Developer from Scratch is probably one of the most complete and comprehensive online courses you will ever get to see covering web development from top to bottom. In more than 30 hours of content, this course will cover all you need to know about how to become a top skilled web developer even if you never programmed before. In this course we will be covering the following subjects:
                FrontEnd Development: JavaScript, jQuery, HTML5, CSS3, Bootstrap
                BackEnd Development: PHP, MySQL (MySQLi)
                This course will give you all the insights on how the Internet works and after you've completed the course, you will have the breadth of knowledge to be able to create your own websites and apps with the latest technology.",
            "price" => "13.99 $",
            "instructor" => "Victor Bastos",
            "reviews" => [
                ["name" => "Abhinav R.", "rating" =>  "5", "details" => "THE COURSES ARE UNDERSTANDABLE AND EASY"],
                ["name" => "Andrew M.", "rating" =>  "5", "details" => "It has brought back, everything i learned a few years ago, and in a simple, very impressed"],
                ["name" => "Robert S.", "rating" =>  "1", "details" => "This so dated, the way he teaches does not help you learn the HTML feels complete thrown together and poorly prepared. DO NOT TAKE this course I bought it on the CHEAP and totally regret it. Get Angela Yu"]
            ]
        ];

        parent::response($result[$id]);
    }


    // render Boned QR info
    public function renderContainerBonedQR()
    {
        $data = new stdClass();
        $data->c = $this->_request->c;
        $landTripInformation = $this->_con->renderContainerBonedQR($data, 0);
        dump($landTripInformation);
        die;

        parent::response($landTripInformation);
    }

    public function sendWebsocket()
    {
        //get the user UUID
        $UUID = $this->_request->UUID;
       
        $details = new stdClass();
        $details->id = rand(1,1000);
        $details->message =  $this->_request->message;
        $details->progress =  $this->_request->progress;

        //send websocket
        $socialCore = new SocialCore();
        $socialCore->sendWebSocket($UUID, "MESSAAGE", $details);
    }
}

new publicAPI();
