<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../social/social_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/DBR/dbr_core.php");
require_once(dirname(__FILE__) . "/../../core/land_trip/land_trip_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");



class Poll_interface extends API
{
    private $_request = array();
    private $_pollIntegration;
    private $_userCore;
    private $_socialCore;
    private $_truckCore;
    private $_truckContractCore;
    private $_waybillCore;
    private $_taskQueuesCore;
    private $_waybillOrderCore;
    private $_notificationCore;
    private $_tenderCore;
    private $_DBRCore;
    private $_queueCore;
    private $_truckOwnerCore;
    private $_landtripCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            $msg = json_encode($_SESSION, JSON_UNESCAPED_UNICODE);
            //throw new Exception('No Session!' . $msg);
        }

        // init the object
        $this->_pollIntegration = new Poll();
        $this->_userCore = new UserCore();
        $this->_socialCore = new SocialCore();
        $this->_truckCore = new TruckCore();
        $this->_waybillCore = new WaybillCore();
        $this->_queueCore = new QueueCore();

        $this->_truckContractCore = new TruckContractCore();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_notificationCore = new NotificationCore();
        $this->_tenderCore = new TenderCore();
        $this->_DBRCore = new DBR_Core;
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_landtripCore = new LandtripCore();


        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ----------------------------------------------------------------------- //
    // --------------------- get bean for certain poll ----------------------- //
    // ----------------------------------------------------------------------- //
    public function getPoll()
    {

        $pollBean = $this->_pollIntegration->getPoll($this->_request->id);
        unset($pollBean['recipients']);

        parent::response($pollBean);
    }

    public function getPollRecipients()
    {

        $pollBean = $this->_pollIntegration->getPoll($this->_request->id);
        $pollQuestions = $pollBean['details']['questions'];

        // get user info
        $user_ids = [];
        foreach ($pollBean['recipients'] as $index => &$recipient) {
            $user_ids[] = $recipient['remote_user_id'];
        }

        if ($pollBean->type == "POLL") {
            // search for user voucher based on nn and phone and voucher type = TIPS
        }

        // search users
        $searchFilter = [['key' => 'id', 'val' => $user_ids, 'op' => 'in']];
        $userList = $this->_userCore->searchUser($searchFilter, 100000, 0, 0)->data;

        foreach ($pollBean['recipients'] as &$recipient) {
            // get user bean
            try {
                foreach ($userList as $userMG) {
                    if ($userMG->id == $recipient['remote_user_id']) {
                        $user = $userMG;
                        break;
                    }
                }

                $recipient['recipient_id'] = $recipient['id'];
                $recipient['name'] = $user->name;
                $recipient['phone'] = $user->phone;
                $recipient['nn'] = $user->nn;
                $user = null;

                // in case of TIPS polls , fill voucher and amount
                if ($pollBean['details']['attributes']['sub_type'] && $pollBean['details']['attributes']['sub_type'] == "TIPS") {
                    $voucher_id = "-";
                    $amount = "-";
                    if ($recipient['activities']) {
                        $activites = json_decode($recipient['activities']);
                        foreach ($activites as $act) {
                            if ($act->type == "VOUCHER_ID") {
                                $actObj = explode(":", $act->body);
                                $voucher_id = trim($actObj[1]);
                                $amount = trim($actObj[3]);
                            }
                        }
                    }
                    $recipient['voucher_id'] = $voucher_id;
                    $recipient['amount'] = $amount;
                }

                // get user answer as caption
                $recAnsweres = json_decode($recipient['answers']);

                if ($recAnsweres) {
                    foreach ($pollQuestions as $pollQ) {
                        $tempAnswer = new stdClass();
                        $tempAnswer->question_id = $pollQ['question_id'];
                        $tempAnswer->value = null;
                        $tempAnswer->caption = null;

                        foreach ($recAnsweres as &$answerObj) {
                            if ($pollQ['question_id'] == $answerObj->question_id) {
                                $tempAnswer->value = $answerObj->value;
                            }
                        }
                        if ($tempAnswer->value) {
                            $recipient['answer'][] = $this->convertAnswersToCaption($pollQuestions, $tempAnswer);
                        } else {
                            $recipient['answer'][] = $tempAnswer;
                        }
                    }
                }
            } catch (Exception $e) {
            }
        }

        $array = [];
        foreach ($pollBean['recipients'] as $value)
            $array[] = $value;

        $pollBean['recipients'] = $array;

        parent::response($pollBean['recipients']);
    }

    // -------------------------------------------------------------------------- //
    // ------------- convert user answeres to readable captions ----------------- //
    // -------------------------------------------------------------------------- //
    private function convertAnswersToCaption($pollQuestions, $userAnswer)
    {

        // loop on questions
        foreach ($pollQuestions as $question) {
            // if question match
            if ($question['question_id'] == $userAnswer->question_id) {
                // loop on answeres
                foreach ($question['answers'] as $answer) {

                    if ($answer['value'] == $userAnswer->value) {
                        $userAnswer->caption = $answer['caption'];
                    }

                    if (isset($userAnswer->value[0]) && $answer['value'] == $userAnswer->value[0]) {
                        $userAnswer->caption = $answer['caption'];
                    }

                    if ($userAnswer->caption == "متابعة") {
                        $userAnswer->caption = $answer['value'];
                    }

                    if (!isset($userAnswer->caption)) {
                        $userAnswer->caption = $userAnswer->value;
                    }
                }
            }
        }
        return $userAnswer;
    }


    // --------------------------------------------------------------------------- //
    // ------------------------ Prepare Search Filter ---------------------------- //
    // --------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $pollFilter = ($this->_request->filter);
        return $pollFilter;
    }


    // ----------------------------------------------------------------- //
    // --------------------- get list of polls ------------------------- //
    // ----------------------------------------------------------------- //
    public function searchPolls()
    {

        $pollFilter = $this->prepareFilter();
        if (!$pollFilter) {
            $pollFilter = "{}";
        }

        $pollReuslt = $this->_pollIntegration->searchPolls(
            $pollFilter,
            $this->_request->limit,
            $this->_request->offset
        );

        // format data
        $Results = [];

        if ($pollReuslt && !is_string($pollReuslt) && sizeof($pollReuslt) > 0) {
            foreach ($pollReuslt as $poll) {
                $result = new stdClass();
                $result->id = $poll['id'];
                $result->question = $poll['details']['questions'][0]['question_lable'];
                $result->answers = $poll['details']['questions'][0]['answers'];
                $result->question_type = $poll['details']['questions'][0]['question_type'];
                $result->attributes = $poll['details']['attributes'];
                $result->status = $poll['status'];
                $result->expiry_date = $poll['expiry_date'];
                $result->created_at = $poll['created_at'];
                $Results['data'][] = $result;
            }
        } else {
            $Results['data'] = [];
        }

        $Results['found_rows'] = sizeof($Results['data']);

        //return  response
        parent::response($Results);
    }


    // ------------------------------------------------------------------------------------- //
    // ---------------------  check for active poll for a certain user --------------------- //
    // ------------------------------------------------------------------------------------- //
    public function checkPoll()
    {

        $user_id = $_SESSION['u_id'];
        if ($user_id) {
            $pollReuslt = $this->_pollIntegration->checkPoll($user_id);
        } else {
            $pollReuslt =  "";
        }

        // inject any dynamic params 
        try {
            $recipient_bind_params = json_decode($pollReuslt['recipient']['bind_params']);
            $questions = $pollReuslt['details']['questions'];

            foreach ($questions as &$q) {
                foreach ($recipient_bind_params as $key => $value) {
                    $q['question_lable'] = str_replace($key, $value, $q['question_lable']);
                }
            }
            $pollReuslt['details']['questions'] =  $questions;
        } catch (Exception $e) {
        }

        //return  response
        parent::response($pollReuslt);
    }


    // --------------------------------------------------------------------- //
    // -------------------- create new poll -------------------------------- //
    // --------------------------------------------------------------------- //
    public function createPoll()
    {

        // get input params
        $title = $this->_request->title;
        $is_dismissible = $this->_request->is_dismissible;
        $expiry_date = $this->_request->expiry_date;
        $can_change_answer = $this->_request->can_change_answer;
        $description =  $this->_request->description;
        $priority = $this->_request->priority;
        $recipients = $this->_request->recipients;
        $communication_channel_code = $this->_request->communication_channel_code;

        // prapare params
        $poll = [];
        $poll['details'] = [];

        // questions
        $questions = $this->_request->questions;
        $next_question = 0;
        $question_id = 0;
        foreach ($questions as $q) {
            if ($next_question < sizeof($questions) - 1) {
                $next_question++;
            } else {
                $next_question = null;
            }

            $question_lable = $q->question_lable;
            $question_type = $q->question_type;
            $question_attachment_url = $q->question_attachment_url;
            foreach ($q->answers as $answer) {
                $answer->next_question = $next_question;
            }
            $answers = $q->answers;
            $bind_params = $q->bind_params;

            $question = [];
            $question['question_lable'] = $question_lable;
            $question['question_type'] = $question_type;
            $question['question_attachment_url'] = $question_attachment_url;
            $question['question_id'] = $question_id;
            $question['validation'] = ["method" => "none"];
            $question['answers'] = $answers;
            $poll['details']['questions'][] = $question;
            $question_id++;
        }

        // attributes
        $poll['details']['attributes'] = [];
        $poll['details']['attributes']['title'] = $title;
        $poll['details']['attributes']['is_dismissible'] = (bool)!$is_dismissible;
        $poll['details']['attributes']['expiry_date'] = $expiry_date;
        $poll['details']['attributes']['can_change_answer'] = (bool)$can_change_answer;
        $poll['details']['attributes']['max_retries'] = "1";
        $poll['details']['attributes']['description'] = $description;
        $poll['details']['attributes']['callback'] = [];
        $poll['details']['attributes']['notification_title'] = $title;
        $poll['details']['attributes']['priority'] = (int)$priority;
        $poll['details']['attributes']['scenario'] = "normalScenario";
        $poll['details']['attributes']['sub_type'] = "TIPS";

        if (sizeof($answers) == 1) {
            $poll['details']['attributes']['type'] = "announcement"; // تعميم
        } else {
            $poll['details']['attributes']['type'] = "poll";         // استفتاء
        }

        // recipients 
        $poll['recipients'] = [];
        if ($recipients == "broadcast") {
            $result  = $this->_socialCore->searchRecipients("broadcast");

            foreach ($result as $user) {
                $rec = [];
                $rec['user_id'] = $user->id;
                $rec['communication_channel_code'] = $communication_channel_code;
                $rec['communication_channel_details'] = [];
                $rec['communication_channel_details']['fcm_registration_id'] = $user->notification_token;
                $poll['recipients'][] = $rec;
            }
        }

        // group by tender
        if ($recipients == "group") {
            $tender_id = $this->_request->tender_id;
            $result  = $this->_socialCore->searchRecipients($tender_id);

            foreach ($result as $user) {
                $rec = [];
                $rec['user_id'] = $user->id;
                $rec['communication_channel_code'] = $communication_channel_code;
                $rec['communication_channel_details'] = [];
                $rec['communication_channel_details']['fcm_registration_id'] = $user->notification_token;
                $poll['recipients'][] = $rec;
            }
        }

        // single user
        if ($recipients == "single") {
            $user_id = $this->_request->user_id;

            // recipients
            $userBean = $this->_userCore->getUserBasic($user_id, 0);
            $rec = [];
            $rec['user_id'] = $user_id;
            $bind_params = [];
            $rec['bind_params'] = json_encode($bind_params);
            $rec['communication_channels'] = [];
            foreach ($communication_channel_code as $channel) {
                if ($channel == "FCM") {
                    $rec['communication_channels'][] = ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 1];
                } else if ($channel == "SMS") {
                    $rec['communication_channels'][] = ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2];
                }
            }

            $poll['recipients'][] = $rec;
        }

        // create poll
        $poll_id = $this->_pollIntegration->createPoll($poll);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['POLL_ID'] = $poll_id;
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // --------------------------------------------------------------------- //
    // -------------------- change poll statsus  --------------------------- //
    // --------------------------------------------------------------------- //
    public function changeStatus()
    {

        // get params
        $poll_id = $this->_request->id;
        $new_status = $this->_request->new_status;

        // delete poll
        if ($new_status == "INACTIVE") {
            $pollReuslt = $this->_pollIntegration->closePoll($poll_id);
        }

        // publish poll
        if ($new_status == "ACTIVE") {
            $pollReuslt = $this->_pollIntegration->publishPoll($poll_id);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------- //
    // -------------------- log activity to a certain recipient poll ----------------- //
    // ------------------------------------------------------------------------------- //
    public function logActivity()
    {

        // get params
        $recipient_id = $this->_request->recipient_id;
        $message = $this->_request->message;

        $this->_pollIntegration->logActivity($recipient_id, $message);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // -------------------------------------------------------------------- //
    // ---------------- answer certain poll  ------------------------------ //
    // -------------------------------------------------------------------- //
    public function answerPoll()
    {

        $poll_id = $this->_request->id;
        $answers = $this->_request->answers;
        $canOverrideUserId = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'TELLER_SUPERVISOR' || $role == 'OPERATION_MANAGER' || $role == 'CALL_CENTER') {
                $canOverrideUserId = true;
            }
        }
        if ($this->_request->integration_token == 'DmjbGCe7buyFyzcvWAUQpAH5ZJPySDJVVZwmLJfKXKkxBYvh3XMb74nWN4D5c2yb') {
            $canOverrideUserId = true;
        }

        if ($canOverrideUserId && $this->_request->user_id) {
            $user_id = $this->_request->user_id;
        } else {
            $user_id = $_SESSION['u_id'];
        }
        if (!$user_id) {
            $user_id = $_SESSION['u_id'];
        }

        $pollBean = $this->_pollIntegration->getPoll($this->_request->id);

        // get the poll recipients record for the user
        $recipients = $pollBean['recipients'];
        $activeRecipients = null;
        foreach ($recipients as $key => $recipient) {
            if ($recipient['status'] == 'ACTIVE' && $recipient['remote_user_id'] == $user_id) {
                $activeRecipients = $recipient;
                break;
            }
        }

        $pollBean = $this->_pollIntegration->getPoll($poll_id);

        $pollReuslt = $this->_pollIntegration->answerPoll($poll_id, $answers, $user_id);

        // send notification for poll of type POLL
        if ($pollBean['type'] == "POLL") {
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand();
            $payload->message =  "تم ارسال اجابتك على الاستبيان بنجاح ، شكرا";
            $this->_notificationCore->sendDataMessage($user_id, $payload);

            // in case the poll has callback integeration call it          
            $callBack = $pollBean['details']['attributes']['callback'];

            if ($callBack && $callBack[0]) {
                $callBackMethod = $callBack[0]['data']['method'];
                if ($callBackMethod == "createJoinMgPayTicket") {
                    // $answers = is_string($answers) ? json_decode($answers, true) : $answers;
                    // $liecence_photo_front = $answers[2]['value'];
                    //$tn = $answers[1]['value'];
                    // $this->_tenderCore->createJoinMgPayTicket($tn, $liecence_photo_front,//$_SESSION['user_id']);
                } elseif ($callBackMethod === 'createDischargeReport') {
                    $answers = is_string($answers) ? json_decode($answers, true) : $answers;
                    $waybill_id = json_decode($activeRecipients['bind_params'])->waybill_id;
                    if (!$waybill_id) {
                        throw new Exception("waybill_id is not defined");
                    }
                    $this->_waybillCore->createDischargeReport($waybill_id, $answers, $user_id);
                }
                elseif ($callBackMethod === 'createContainerDischargeReport') {
                    $answers = is_string($answers) ? json_decode($answers, true) : $answers;
                    $land_trip_id = json_decode($activeRecipients['bind_params'])->land_trip_id;
                    if (!$land_trip_id) {
                        throw new Exception("land_trip_id is not defined");
                    }
                    $this->_landtripCore->createContainerDischargeReport($land_trip_id, $answers, $user_id);
                }
            }
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // -------------------------------------------------------------------- //
    // ---------------- get poll dashboard ------------------------------ //
    // -------------------------------------------------------------------- //
    public function getPollDashboard()
    {

        //poll info
        $pollBean = $this->_pollIntegration->getPoll($this->_request->id);

        $questions = $pollBean['details']['questions'];
        $questionsAnswers = array();
        foreach ($questions as $question) {
            $questionsAnswers[json_encode($question['question_id'])] = $question['answers'];
        }
        $pollAnswers = $pollBean['details']['questions'][0]['answers'];
        $user_count_with_answer = 0;
        $user_count_without_answer = 0;
        $count_per_day = array();

        // get the captions of answers to use later
        foreach ($questionsAnswers as $key => $value) {
            foreach ($value as $answer) {
                $answersCaption[$key][json_encode($answer['value'])] = $answer['caption'];
            }
        }
        // get the captions of answers to use later
        foreach ($questionsAnswers as $key => $value) {
            foreach ($value as $answer) {
                $answersValue[$key][json_encode($answer['value'])] = 0;
            }
        }

        // add extra info to users answer result
        $usersResult = [];
        $user_ids = [];
        foreach ($pollBean['recipients'] as $recipient) {
            $user_ids[] = $recipient['remote_user_id'];

            $create_date_obj = date_create($recipient['updated_at']);
            $recipient['updated_at'] = date_format($create_date_obj, "m/d/Y");

            //get the count of users who have answers
            if (!$recipient['answers']) {
                $user_count_without_answer++;
            } else {
                $user_count_with_answer++;
            }

            //get count of answers per day
            if ($recipient['status'] === 'CLOSED') {
                if ($count_per_day[$recipient['updated_at']]) {
                    $count_per_day[$recipient['updated_at']]++;
                } else {
                    $count_per_day[$recipient['updated_at']] = 1;
                }
            }
        }

        $formated_count_per_day = [];
        // formating count per day
        foreach ($count_per_day as $key => $value) {
            array_push($formated_count_per_day, [$key, $value]);
        }

        usort($formated_count_per_day, array('Poll_interface', 'comparator'));

        $searchFilter = [['key' => 'id', 'val' => $user_ids, 'op' => 'in']];
        $userList = $this->_userCore->searchUser($searchFilter, 10000, 0, 0)->data;

        foreach ($pollBean['recipients'] as $recipient) {
            // get user bean
            try {
                foreach ($userList as $userMG) {
                    if ($userMG->id == $recipient['remote_user_id']);
                    $user = $userMG;
                    break;
                }
                $userAnswer = new stdClass();
                $userAnswer->name = $user->name;
                $userAnswer->phone = $user->phone;
                $userAnswer->result = [];
                if ($recipient['answers']) {
                    $theAnswer = json_decode($recipient['answers'], true);
                    foreach ($theAnswer as $obj) {
                        $q_id = $obj['question_id'];
                        $Q_value = $obj['value'];

                        if (is_array($Q_value)) {
                            $temp = [];
                            foreach ($Q_value as $item) {
                                $temp[] = $answersCaption[json_encode($q_id)][$item];
                            }
                            array_push(
                                $userAnswer->result,
                                array(
                                    "value" => join(',', $temp),
                                    "question_id" => $q_id
                                )
                            );
                        } else {
                            array_push(
                                $userAnswer->result,
                                array(
                                    "value" => $answersCaption[json_encode($q_id)][$Q_value],
                                    "question_id" => $q_id
                                )
                            );
                        }
                    }
                }
                $userAnswer->updated_at = $recipient['updated_at'];
                array_push($usersResult, $userAnswer);
            } catch (Exception $e) {
            }
        }



        // percentage for answers
        foreach ($pollBean['recipients'] as $recipient) {
            if ($recipient['answers']) {
                $theAnswer = json_decode($recipient['answers'], true);
                foreach ($theAnswer as $obj) {
                    $q_id = $obj['question_id'];
                    $Q_value = $obj['value'];

                    if (is_array($Q_value)) {
                        foreach ($Q_value as $item) {
                            $answersValue[json_encode($q_id)][$item] += 1;
                        }
                    } else {
                        $answersValue[json_encode($q_id)][$Q_value] += 1;
                    }
                }
            }
        }

        // return the count for each answer per question
        $question_percentage = [];
        foreach ($answersValue as $k => $v) {
            $percentage = [];
            foreach ($v as $item => $value) {
                if ($value > 0) {
                    $count = [$answersCaption[$k][$item], $value];
                    array_push($percentage, $count);
                }
            }
            array_push($question_percentage, array("question_id" => $k, "data" => $percentage));
        }


        //return Success reponse
        $Result['USERS'] = $usersResult;
        $Result['ANSWERS'] = $question_percentage;
        $Result['user_count_with_answer'] = [['USERS_ANSWERED_POLL', $user_count_with_answer]];
        $Result['user_count_without_answer'] = [['USERS_NOT_ANSWERED_POLL', $user_count_without_answer]];
        $Result['count_per_day'] = $formated_count_per_day;
        parent::response($Result);
    }


    //Comparator function used for comparator
    public static function comparator($object1, $object2)
    {

        $date1 = date_format(date_create($object1[0]), "Y-m-d");
        $date2 = date_format(date_create($object2[0]), "Y-m-d");

        return $date1  > $date2;
    }

    // ------------------------------------------------------------------------------------------------- //
    // -------------------- Validate if the user submitted valid poll answer --------------------------- //
    // -------------------- params: poll_id , question_id , user_answer -------------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function validatePollAnswer()
    {

        // get params
        $poll_id = $this->_request->poll_id;
        $question_id = $this->_request->question_id;
        $user_answer = trim($this->_request->user_answer);

        // get poll questions
        $pollBean = $this->_pollIntegration->getPoll($poll_id);
        $pollQuestions = $pollBean['details']['questions'];

        foreach ($pollQuestions as $question) {
            if ($question_id == $question['question_id']) {
                if ($question['validation']['object'] == "trn") {

                    $contractFilter = [
                        ['key' => 'tn', 'val' => $user_answer],
                        ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
                        ['key' => 'contract_type', 'val' => ['OWN', 'AUTH'], 'op' => "in"],
                        ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"]
                    ];
                    $trailerResult = $this->_truckContractCore->searchTruckContracts($contractFilter, 1, 0, 0);

                    if ($trailerResult->found_rows == 0) {
                        throw new Exception("رقم المقطورة غير صحيح");
                        die;
                    }
                }
            }

            if ($question['validation']['object'] == "amount") {

                $user_answer = convertArabicNumbers($user_answer);

                if (!is_numeric($user_answer) || $user_answer > 250) {
                    throw new Exception("المبلغ المطلوب غير صحيح أو أكبر من الحد الأعلى");
                    die;
                }
            }

            if ($question['validation']['object'] == "tn") {

                $user_answer = convertArabicNumbers($user_answer);

                $truckFilter = [['key' => 'tn', 'val' => $user_answer]];
                $truck_result = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
                if ($truck_result->found_rows == 0) {
                    throw new Exception("لا تستطيع المتابعة الشاحنة ليست ملكا لك");
                    die;
                }
            }
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }




    // ------------------------------------------------------------------------------------------------- //
    // -------------------- send reminder to recipients who did not finisht he poll--------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function sendPollReminder()
    {
        $taskQueuesCore = new TaskQueuesCore();

        // get params
        $poll_id = $this->_request->id;

        try {
            // get poll
            $pollBean = $this->_pollIntegration->getPoll($poll_id);
            // add user ids for recipients who did not answer the poll
            $user_ids = [];
            foreach ($pollBean['recipients'] as $recipient) {
                // if there is no answer get the user id
                if (!$recipient['answers']) {
                    $user_ids[] = $recipient['remote_user_id'];
                }
            }
            $user_ids[] = 2;

            $title = "تذكير : ما زال لديك استبيان بحاجة إلى المتابعة";
            //send notifications for users
            $writeOnWall = false;
            $refresh_app = true;

            foreach ($user_ids as $user) {
                $taskQueuesCore->createPostOnWallTask($user, $body, $title, $writeOnWall, $refresh_app);
            }

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------- //
    // -------------------- send reminder to recipients who did not finisht he poll--------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function sendPollviaSms()
    {
        $taskQueuesCore = new TaskQueuesCore();

        // get params
        $poll_id = $this->_request->id;

        try {
            // get poll
            $pollBean = $this->_pollIntegration->getPoll($poll_id);
            // add user ids for recipients who did not answer the poll
            foreach ($pollBean['recipients'] as $recipient) {
                // if there is no answer get the user id

                $keyFilter = '{"recipient_id": ' . $recipient['id'] . '}';

                $key = $this->_pollIntegration->getPageKey($keyFilter, 0);

                if (!$recipient['answers']) {

                    $route = "https://q.minagate.com/" . $page->key;
                    $message = "لديك إستبيان جديد على " . $route;

                    //send SMS


                }
            }

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------ //
    // -------------------- Generate Poll of downpayment with recipients ------------------ //
    // ------------------------------------------------------------------------------------ //
    public function generateDownPaymentPoll()
    {

        try {

            $id = $this->_request->id;          // waybill_id or queue_id
            $source = $this->_request->source;  // waybill or queue
            $token = $this->_request->token;

            if ($token && $token == "kWsZuGejX8uCPphC") {
                $this->_pollIntegration->generateDownPaymentPoll($id, $source);

                //return Success reponse
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
                parent::response($Result);
            } else {
                throw new Exception("Unauthorized Operation !!");
            }
        } catch (Exception $e) {

            throw new Exception("لم يتمكن النظام من انشاء الاستبيان" . "-" . $e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------- //
    // -------------------- ---------------------------------------------------------------------------- //
    // -------------------- get activites of poll for a recipient -------------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function getPollActivites()
    {
        // get params
        $poll_id = $this->_request->poll_id;
        $recipient_id = $this->_request->recipient_id;

        try {
            // get poll
            $pollBean = $this->_pollIntegration->getPoll($poll_id);
            // get activites
            $recipients = $pollBean['recipients'];
            foreach ($recipients as $recipient) {
                if ($recipient['id'] == $recipient_id) {
                    $activites = json_decode($recipient['activities'], true);
                    if ($activites) {
                        foreach ($activites as &$activity) {
                            $body = json_decode($activity['body']);
                            if ($body) {
                                $activity['body'] = $body;
                            }
                        }
                    }
                    break;
                }
            }

            $result = [];
            if ($activites) {
                foreach ($activites as $rawAct) {
                    $act = new stdClass();
                    $message = null;
                    $time_stamp = null;

                    if ($rawAct['type'] == "SEND_DATA_MESSAGE") {
                        switch ($rawAct['body']->data->type) {
                            case 'set_notification':
                                $message = "ارسال رسالة على التطبيق";
                                break;
                            case 'play_alarm':
                                $message = "تشغيل منبه";
                                break;
                            case 'play_ringtone':
                                $message = "تشغيل نغمة رنين";
                                break;
                            case 'cancel_alarm':
                                $message = "ايقاف المنبه";
                                break;
                            case 'check_waybill_order':
                                $message = "فتح التطبيق بشكل الي ";
                                break;
                            case 'send_SMS':
                                $message = "ارسال رسالة نصية للأجابة ";
                                break;
                        }
                        $time_stamp = $rawAct['created_at'];
                    } else if ($rawAct['type'] == "REMOTE_INFO") {
                        $message = $rawAct['body'];
                        $time_stamp = $rawAct['created_at'];
                    }
                    $act->message = $message;
                    $act->time_stamp = $time_stamp;
                    $result[] = $act;
                }
            }

            //return Success reponse
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------- //
    // -------------------- add new recipent to poll ---------------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function appendRecipientToPoll()
    {

        // get params
        $poll_id = $this->_request->poll_id;
        $user_id = $this->_request->user_id;
        $bind_params = $this->_request->bind_params;

        // get userBean
        $userBean = $this->_userCore->getUserBasic($user_id, 0);

        // check if user does not have recipients record in the poll , then create a record
        $recipients = [];
        $rec['user_id'] = $user_id;
        $rec['bind_params'] = $bind_params;
        $rec['communication_channels'] = [
            ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
            ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2]
        ];
        $recipients[] = $rec;
        $this->_pollIntegration->appendRecipientToPoll($poll_id, $recipients);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['poll_id'] = $poll_id;
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }



    // -------------------------------------------------------------------------------------- //
    // -------------------- add new recipent to poll ---------------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function appendRecipientToJoinMgPayPoll()
    {

        // get params
        $poll_id = 109647;
        $user_id = $_SESSION['u_id'];
        $bind_params = null;

        // get userBean
        $userBean = $this->_userCore->getUserBasic($user_id, 0);

        // check if user does not have recipients record in the poll , then create a record
        $recipients = [];
        $rec['user_id'] = $user_id;
        $rec['bind_params'] = $bind_params;
        $rec['communication_channels'] = [
            ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
            ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2]
        ];
        $recipients[] = $rec;
        $this->_pollIntegration->appendRecipientToPoll($poll_id, $recipients);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['poll_id'] = $poll_id;
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }



    // ------------------------------------------------------------------------------------------------- //
    // -------------------- ---------------------------------------------------------------------------- //
    // -------------------- get active  polls for a user ----------------------------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function getActivePollsForUser()
    {
        try {

            // search for user polls
            $pollFilter = '{"status": "ACTIVE"}';
            $pollReuslt_1 = $this->_pollIntegration->getActivePollsForUser($pollFilter, 100, 0,  $_SESSION['u_id']);
            if (getType($pollReuslt_1) == "string") {
                $pollReuslt_1 = json_decode($pollReuslt_1);
            }


            $pollFilter = '{"status":"CLOSED"}';
            $pollReuslt_2 = $this->_pollIntegration->getActivePollsForUser($pollFilter, 100, 0,  $_SESSION['u_id']);
            if (getType($pollReuslt_2) == "string") {
                $pollReuslt_2 = json_decode($pollReuslt_2);
            }

            if ($pollReuslt_1 && sizeof($pollReuslt_1) > 0 && $pollReuslt_2 && sizeof($pollReuslt_2) > 0) {
                $pollReuslt = array_merge($pollReuslt_1, $pollReuslt_2);
            } else if ($pollReuslt_1 && sizeof($pollReuslt_1)) {
                $pollReuslt = $pollReuslt_1;
            } else if ($pollReuslt_2 && sizeof($pollReuslt_2)) {
                $pollReuslt = $pollReuslt_2;
            }

            // inject any dynamic params
            try {
                foreach ($pollReuslt as &$poll) {
                    $recipient_bind_params = json_decode($poll['bind_params']);
                    $questions = $poll['poll']['details']['questions'];

                    foreach ($questions as &$q) {

                        foreach ($recipient_bind_params as $key => $value) {
                            $q['question_lable'] = str_replace($key, $value, $q['question_lable']);
                        }
                    }

                    $poll['poll']['details']['questions'] =  $questions;
                }
            } catch (Exception $e) {
            }

            // check if the user answers the poll for more than 48 hours dont show it
            $tempPollReuslt = [];
            foreach ($pollReuslt as $key => &$value) {
                $updated_at = date("Y-m-d h:i:s", strtotime($value["updated_at"]));
                $dateNow = DBConnection::getSystemDate();
                $dateDiff = date_diff(date_create($dateNow), date_create($updated_at));
                if ($dateDiff->d < 2) {
                    $tempPollReuslt[] = $value;
                }
            }

            // if the user did not answer the qustion don't show it
            $pollReuslt = array_reverse($pollReuslt);

            foreach ($pollReuslt as &$value) {
                $answers = json_decode($value['answers']);

                $questions = $value['poll']['details']['questions'];
                $tempPoll = [];
                if ($answers && $questions) {
                    foreach ($answers as $answer) {
                        foreach ($questions as $key => $question) {
                            if ($answer->question_id == $question["question_id"]) {
                                $tempPoll[] = $question;
                            }
                        }
                    }
                }
                $value['poll']['details']['questions'] = $tempPoll;
            }

            parent::response($pollReuslt);
        } catch (Exception $e) {
            //throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------- //
    // --------------------- get polls for certain tender order ----------------------- //
    // ------------------------------------------------------------------------------- //
    public function getPollsForTenderOrder()
    {
        try {
            $tender_order_id =  $this->_request->tender_order_id;
            // Get Polls ids
            $waybillOrders = $this->_waybillOrderCore
                ->searchWaybillOrder([
                    ["key" => "tender_order_id", "val" => $tender_order_id]
                ], 1000, 0, $_SESSION['user_id'])->data;
            $pollIds = [];
            foreach ($waybillOrders as $waybillOrder) {
                if ($waybillOrder->poll_id)
                    $pollIds[] = intval($waybillOrder->poll_id);
            }
            // Prepare filters
            $filters = new stdClass();
            $filters->poll_id = $pollIds;
            // get polls for certain date
            $pollBean = $this->_pollIntegration->getPollsForTenderOrder($filters);
            // if there is no polls return
            if ($pollBean == '[]') {
                parent::response([]);
                return;
            }

            // get polls ids, user_ids, and beans
            $poll_ids = [];
            $polls = array();
            $user_ids = [];
            foreach ($pollBean as $poll_details) {
                $polls[$poll_details['poll_id']] = $poll_details;
                $poll_ids[] = $poll_details['poll_id'];
                $user_ids[] = $poll_details['user_id'];
            }

            // search for waybill orders
            $poll_ids = implode(',', $poll_ids);
            $waybill_orders_query = "
                select 
                    w.poll_id,
                    w.id,
                    w.contact_name,
                    w.contact_phone,
                    w.tn,
                    w.status,
                    w.queue_id,
                    r.user,
                    r.dur
                from waybill_order_view as w
                    inner join waybill_order_01_report as r
                    on
                    w.id = r.id
                where
                    w.tender_order_id = $tender_order_id
            ";
            $waybill_order_list = DBConnection::runDatabaseQuery($waybill_orders_query);
            // search users HB
            $user_ids = implode(',', $user_ids);
            $sqlQuery = "select cast( hb as char charset utf8) as hb , user_id from user_hb where user_id in ($user_ids)";
            $heartBeat =  DBConnection::runDatabaseQuery($sqlQuery);
            $users_hb = array();
            foreach ($heartBeat as $user) {
                if ($user->hb !== '{}') {
                    $users_hb[$user->user_id] = json_decode($user->hb)[0];
                }
            }

            // collect data from polls and waybill_orders together
            $waybill_orders_result = [];
            foreach ($waybill_order_list  as $k =>  $waybill_order) {
                $id = $waybill_order->poll_id;
                $temp = new stdClass();
                $temp->id = $waybill_order->id;
                $temp->contact_name = ($waybill_order->contact_name != 'null' ? $waybill_order->contact_name : '');
                $temp->tn = $waybill_order->tn;
                $temp->status = $waybill_order->status;
                $temp->contact_phone = ($waybill_order->contact_phone != 'null' ? $waybill_order->contact_phone : '');
                $temp->notification_sent = ($polls[$id]['notification_sent'] ? 'نعم' : 'لا');
                $temp->sms_sent = $polls[$id]['sms_sent'] ? 'نعم' : 'لا';

                if (!$polls[$id]) {
                    $waybill_order->user = "employee";
                }
                if (in_array($waybill_order->tn, ["NULL", "null", false, null]) && in_array($waybill_order->status, ["APPROVED", "CLOSED"])) {
                    $temp->answer_method = 'عجز';
                } elseif ($waybill_order->user == 'cc') {
                    $temp->answer_method = 'اتصال الي';
                } else if ($waybill_order->user == 'mobile') {
                    if (!$waybill_order->queue_id) {
                        $temp->answer_method = "portal";
                    } elseif ($polls[$id]['answered_on_browser']) {
                        $temp->answer_method = 'sms';
                    } else {
                        $temp->answer_method = 'تطبيق';
                    }
                } else {
                    $temp->answer_method =  'موظف اتصال';
                }
                $temp->duration = $waybill_order->dur ? gmdate('H:i:s', $waybill_order->dur) : '';
                $temp->viewed_on_mobile = $polls[$id]['viewed_on_mobile'] ? 'نعم' : 'لا';
                $temp->viewed_on_browser = $polls[$id]['viewed_on_browser'] ? 'نعم' : 'لا';
                $temp->app_version = $users_hb[$polls[$id]['user_id']]->app_version;
                $temp->poll_id = $id;
                array_push($waybill_orders_result, $temp);
            }

            // return response
            parent::response($waybill_orders_result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------- //
    // -------------------- Validate if the user submitted valid poll answer --------------------------- //
    // -------------------- params: poll_id , question_id , user_answer -------------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function validateDriverWageAnswer()
    {
        // get params
        $poll_id = $this->_request->poll_id;
        $question_id = $this->_request->question_id;
        $user_answer = trim($this->_request->user_answer);
        $nonCharacterValidate = is_numeric($user_answer);
        if ($nonCharacterValidate == false) {
            throw new Exception("القيمة المدخلة غير صحيحة");
            die;
        } else {
            $user_answer = doubleval($user_answer);
        }
        // get poll questions
        $pollBean = $this->_pollIntegration->getPoll($poll_id);
        $pollQuestions = $pollBean['details']['questions'];
        foreach ($pollQuestions as $question) {
            if ($question_id == $question['question_id']) {
                $tn = $question["validation"]['tn'];
                $realDBR = $this->_DBRCore->calculateTruckDownPayment($tn, 11);
                $finalDbr = $realDBR['down_payment']['value'];
                if ($user_answer > $finalDbr) {
                    throw new Exception("القيمة المدخلة اكبر من الحد المسموح وهو " . $finalDbr);
                    die;
                }
            }
        }
        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }



    // ---------------------------------------------------------------------------------------------- //
    // ----------------- preview the recipients of downpayment poll attemp  ------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function previewBulkDownpaymentPoll()
    {
        $starting_rank =  $this->_request->starting_rank;
        $limit = $this->_request->limit;
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        // get the queue_ids
        $queueFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['HELD'], 'op' => 'not in'],
            ['key' => 'rank', 'val' => $starting_rank, 'op' => 'greater than'],
            ['key' => 'q_id', 'val' => $q_id]
        ];


        $queueResult = $this->_queueCore->searchQueue($queueFilter, $limit, 0, $_SESSION['user_id']);
        $listOfTruckId = [];
        foreach ($queueResult->data as $value) {
            $listOfTruckId[] = $value->truck_id;
        }
        $tender_truck_filter = [
            ['key' => 'truck_id', 'val' => $listOfTruckId, "op" => "in"],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'financial_manager_owner_id', 'op' => 'is not null']
        ];
        $truck_beans = $this->_tenderCore->searchTenderTruck($tender_truck_filter, $limit, 0, $_SESSION['user_id']);
        $listOfTenderTrucks = [];
        foreach ($truck_beans->data as  $value) {
            $temp = new stdClass();
            $temp->financial_manager_owner_id = $value->financial_manager_owner_id;
            $temp->truck_id = $value->truck_id;
            $listOfTenderTrucks[] = $temp;
        }
        $listOfIds = [];
        foreach ($queueResult->data as $qu) {
            foreach ($listOfTenderTrucks as  &$item) {
                if ($qu->truck_id == $item->truck_id) {
                    $item->rank = $qu->rank;
                    $listOfIds[] = $item->financial_manager_owner_id;
                }
            }
        }

        // inject truck manager name
        $truckCompanyOwnerFilter = [['key' => 'id', 'val' => $listOfIds, "op" => "in"]];
        $truckCompanyOwner_qry = $this->_truckOwnerCore->searchTruckOwner($truckCompanyOwnerFilter, $limit, 0, $_SESSION['user_id']);
        foreach ($truckCompanyOwner_qry->data as $truckOwner) {
            foreach ($listOfTenderTrucks as  &$item) {
                if ($truckOwner->id == $item->financial_manager_owner_id) {
                    $item->name = $truckOwner->name;
                }
            }
        }

        // remove queues with no manager
        $finalList = [];
        foreach ($queueResult->data as &$qu) {
            foreach ($listOfTenderTrucks as  $item) {
                if ($qu->truck_id == $item->truck_id) {
                    $qu->financial_manager_owner_name = $item->name;
                    $finalList[] = $qu;
                }
            }
        }
        //return Success reponse
        parent::response($finalList);
    }



    // ---------------------------------------------------------------------------------------------- //
    // ----------------- preview the recipients of downpayment poll attemp  ------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function generateBulkDownpaymentPollForTrucks()
    {
        try {

            // validate auth
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            $allow = false;
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                    $allow = true;
                }
            }
            if (!$allow) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }


            // loop on user trucks and start creating polls
            $tns =  implode(",", $this->_request->tns);
            $sql = "select id from queue_view where tender_id =11 and q_id=1 and rank is not null and tn in ($tns)";
            $result2 = DBConnection::runBindDatabaseQuery($sql, []);

            foreach ($result2 as $q) {
                $this->_taskQueuesCore->createDownpaymentPollTask($q->id, "queue", 2);
            }

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "POLL.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------------------ //
    // ---------------------  check for JOIN MG Pay poll for a certain user --------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function getPollForJoinMgPay()
    {

        $user_id = $_SESSION['u_id'];
        if ($user_id) {
            $pollReuslt = $this->_pollIntegration->checkPoll($user_id);
        } else {
            $pollReuslt =  "";
        }

        // inject any dynamic params 
        try {
            $recipient_bind_params = json_decode($pollReuslt['recipient']['bind_params']);
            $questions = $pollReuslt['details']['questions'];

            foreach ($questions as &$q) {
                foreach ($recipient_bind_params as $key => $value) {
                    $q['question_lable'] = str_replace($key, $value, $q['question_lable']);
                }
            }
            $pollReuslt['details']['questions'] =  $questions;
        } catch (Exception $e) {
        }

        //return  response
        parent::response($pollReuslt);
    }
}

new Poll_interface();
