<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/policy_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_draft/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php");

class Policy_Interface extends API
{
    private $_request = array();

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_request = parent::__construct();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            // throw new Exception('No Session!');
        }
        $this->Policy_Core = new Policy_Core();
        $this->_waybillDraft = new WaybillDraftCore();
        $this->_clearingAgentCore = new ClearingAgentCore();

        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    public function searchPolicies()
    {
        $searchFilter = $this->prepareFilter();
        $limit = $this->_request->limit;
        $offset = $this->_request->offset;
        $policiesResult = $this->Policy_Core->searchPolicies($searchFilter, $limit, $offset, $_SESSION['user_id'], ' order by id desc ');
        parent::response($policiesResult);
    }

    // ----------------------------------------------------- //
    // --------------- Get Policy info --------------------- //
    // ----------------------------------------------------- //
    public function getPolicyProfile()
    {
        // get policy object
        $policy_id = $this->_request->policy_id;
        $searchFilter = [['key' => 'id', 'val' => $policy_id]];
        $policiesResult = $this->Policy_Core->searchPolicies($searchFilter, 1, 0, $_SESSION['user_id']);
        $policyObject = $policiesResult->data[0];

        // get cargo_policy
        $filter = [];
        $filter[] = ['key' => 'policy_id', 'val' => $policy_id]; 
        $cargo_policy_qry = $this->Policy_Core->searchCargoPolicies($filter, 1000, 0, $_SESSION['user_id'], ' order by status desc, id ');

        $result = new stdClass();
        $result->policy = $policyObject;
        $result->cargo_policy = $cargo_policy_qry->data;
        parent::response($result);
    }

    public function addOrderService()
    {
        $policy_id = $this->_request->policy_id;
        $services = new stdClass();
        $services->code = $this->_request->value;

        $services->time = DBConnection::getSystemDate();
        $services->status = 'ACTIVE';
        $services->requsted_by = $_SESSION['u_id'];

        $filter = [];
        $filter[] = ['key' => 'id', 'val' => $policy_id];

        $cargo_policy_qry = $this->Policy_Core->searchCargoPolicies($filter, 1000, 0, $_SESSION['user_id']);

        $details = json_decode($cargo_policy_qry->data[0]->details);
        $details->requsted_services[] = $services;

        $this->Policy_Core->updateCargoPolicyDetails($policy_id, $details, 0);
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم طلب الخدمة بنجاح";
        parent::response($Result);

    }

    // -------------------------------------------------------------- //
    // --------------- Get Policy info for print -------------------- //
    // -------------------------------------------------------------- //
    public function getPolicyForPrint()
    {
        $policy_id = $this->_request->policy_id;

        // get cargo policy object
        $searchFilter = [['key' => 'policy_id', 'val' => $policy_id]];
        $searchRes = $this->Policy_Core->searchCargoPolicies($searchFilter, 1000, 0, $_SESSION['user_id']);
        $finalResult = [];
        foreach ($searchRes->data as $cargoPolicy) {
            $cargoPolicyObject = $cargoPolicy;
            $cargoPolicyObject->details = json_decode($cargoPolicyObject->details);

            // get waybill draft object
            $filter = ["cargo_ids" => $cargoPolicyObject->cargo_id];
            $waybill_draft = $this->_waybillDraft->searchWaybillDraft($filter, null, 10, 0, $_SESSION['u_id'])[0];
            $waybill_draft_doc = json_decode($waybill_draft->document);

            //get ca logo
            $ca_id = $cargoPolicyObject->ca_id;
            $clearingAgentBean = $this->_clearingAgentCore->getClearingAgentBasic($ca_id, 0);

            $photos = $clearingAgentBean->photos;
            $ca_logo = "";
            if ($photos) {
                foreach ($photos as $photo) {
                    if ($photo->type == "logo") {
                        $ca_logo = $photo->url;
                    }
                }
            }

            // format data
            $result = new stdClass();
            $result->tn = $waybill_draft_doc->carrier[0]->truck->tn;
            $result->trn = $waybill_draft_doc->carrier[0]->trailer->tn;
            $result->driver_name = $waybill_draft_doc->carrier[0]->driver->name;
            $result->driver_nn = $waybill_draft_doc->carrier[0]->driver->nn;
            $result->driver_phone = $waybill_draft_doc->carrier[0]->driver->phone;

            $result->owner_name = $cargoPolicyObject->details->owner_name;
            $result->owner_phone = $cargoPolicyObject->details->owner_phone;
            $result->ca_id = $ca_id;
            $result->ca_name = $cargoPolicyObject->ca_name;
            $result->ca_logo = $ca_logo;

            $result->status = $cargoPolicy->status;

            $result->weight = $cargoPolicyObject->details->weight_per_ton;
            $result->size = $cargoPolicyObject->size;
            $result->type = $cargoPolicyObject->size;
            $result->height = $cargoPolicyObject->height;
            $result->container = $cargoPolicyObject->container;
            $result->customs_permit_number = $cargoPolicyObject->customs_permit_number;
            $result->policy_create_date = $cargoPolicyObject->details->policy_create_date;

            $finalResult[] = $result;
        }

        parent::response($finalResult);
    }

    // -------------------------------------------------------------------- //
    // --------------- Get cargo Policy info for print -------------------- //
    // -------------------------------------------------------------------- //
    public function getCargoPolicyForPrint()
    {

        $cargo_policy_id = $this->_request->cargo_policy_id;

        // get cargo policy object
        $searchFilter = [['key' => 'id', 'val' => $cargo_policy_id]];
        $searchRes = $this->Policy_Core->searchCargoPolicies($searchFilter, 1000, 0, $_SESSION['user_id']);
        $cargoPolicyObject = $searchRes->data[0];
        $cargoPolicyObject->details = json_decode($cargoPolicyObject->details);

        // get waybill draft object
        $filter = ["cargo_ids" => $cargoPolicyObject->cargo_id];
        $waybill_draft = $this->_waybillDraft->searchWaybillDraft($filter, null, 10, 0, $_SESSION['u_id'])[0];
        $waybill_draft_doc = json_decode($waybill_draft->document);

        //get ca logo
        $ca_id = $cargoPolicyObject->ca_id;
        $clearingAgentBean = $this->_clearingAgentCore->getClearingAgentBasic($ca_id, 0);

        $photos = $clearingAgentBean->photos;
        $ca_logo = "";
        if ($photos) {
            foreach ($photos as $photo) {
                if ($photo->type == "logo") {
                    $ca_logo = $photo->url;
                }
            }
        }

        // format data
        $result = new stdClass();
        $result->tn = $waybill_draft_doc->carrier[0]->truck->tn;
        $result->driver_name = $waybill_draft_doc->carrier[0]->driver->name;
        $result->driver_nn = $waybill_draft_doc->carrier[0]->nn;
        $result->driver_phone = $waybill_draft_doc->carrier[0]->phone;

        if ($cargoPolicyObject->cargo_policy_details) {
            $cargo_policy_details = json_decode($cargoPolicyObject->cargo_policy_details);
            $result->owner_name = $cargo_policy_details->owner_name;
            $result->owner_phone = $cargo_policy_details->owner_phone;
            $result->discharge_location = $cargo_policy_details->destination_name;
        } else {
            $result->owner_name = $cargoPolicyObject->details->owner_name;
            $result->owner_phone = $cargoPolicyObject->details->owner_phone;
            $result->discharge_location = $cargoPolicyObject->details->discharge_location;
        }

        if ($clearingAgentBean->details) {
            $result->ca_info = $clearingAgentBean->details->ca_info;
        }

        $result->ca_id = $ca_id;
        $result->ca_name = $cargoPolicyObject->ca_name;
        $result->ca_logo = $ca_logo;
        $result->remarks = $cargoPolicyObject->details->remarks;

        $result->weight = $cargoPolicyObject->details->weight_per_ton;
        $result->size = $cargoPolicyObject->size;
        $result->type = $cargoPolicyObject->size;
        $result->height = $cargoPolicyObject->height;
        $result->container = $cargoPolicyObject->container;
        $result->status = $cargoPolicyObject->status;
        $result->customs_permit_number = $cargoPolicyObject->customs_permit_number;
        $result->policy_create_date = $cargoPolicyObject->details->policy_create_date;

        parent::response($result);
    }

    // ----------------------------------------------------- //
    // --------------- Get Policy info --------------------- //
    // ----------------------------------------------------- //
    public function getPolicyById()
    {
        $policy_id = $this->_request->policy_id;
        if (!$policy_id) {
            parent::exceptionHandler('Enter ID');
        }

        $policyObject = $this->Policy_Core->getPolicy($policy_id, $_SESSION['user_id']);
        parent::response($policyObject);
    }

    private function prepareFilter()
    {
        $searchFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => "LIKE"];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($searchFilter, $tempArr);
            }
        }
        return $searchFilter;
    }

    public function shippingLineLookup()
    {
        $sqlQuery = 'select * from shipping_line;';
        $param = [];
        $shipping_lines = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        parent::response($shipping_lines);
    }

    // ------------------------------------------------------------------------ //
    // ---------------------- Update Cargo Policy Details --------------------- //
    // ------------------------------------------------------------------------ //
    public function updateCargoPolicyDetails()
    {

        // get user input
        $cargo_policy_id = $this->_request->cargo_policy_id;
        $destination_name = $this->_request->destination_name;
        $owner_phone = $this->_request->owner_phone;

        // tempo solution
        $details_value = $this->_request->details_value;
        if ($details_value) {
            $destination_name = $details_value;
        }

        // get cargo policy bean
        $cargoPolicyBean = $this->Policy_Core->getCargoPolicy($cargo_policy_id, $_SESSION['user_id']);

        // parse details object
        $details = $cargoPolicyBean->details;

        if (!$details) {
            $details = new stdClass();
            $details->destination_name = "";
            $details->owner_phone = "";
        }
        $details->destination_name = $destination_name;
        $details->owner_phone = $owner_phone;

        // overwrite the details value
        $this->Policy_Core->updateCargoPolicyDetails($cargo_policy_id, $details, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم تعديل موقع التفريغ بنجاح";
        parent::response($Result);
    }
}

new Policy_Interface();
