<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");

class Policy_Core
{
    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------ //
    // --------------------------- Search for policy by filter  --------------------- //
    // ------------------------------------------------------------------------------ //
    public function searchPolicies($searchFilter, $limit, $offset, $user_id, $order_by=null)
    {
        return DBConnection::searchDB("policy", $searchFilter, $limit, $offset, $user_id, $order_by);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------------- Search for cargo policy by filter  --------------------- //
    // ------------------------------------------------------------------------------------ //
    public function searchCargoPolicies($searchFilter, $limit, $offset, $user_id, $order_by=null)
    {
        return DBConnection::searchDB("cargo_policy", $searchFilter, $limit, $offset, $user_id, $order_by);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------------- Search for cargo policy by filter  --------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getPolicy($policy_id, $user_id)
    {
        return DBConnection::getBasicObjectBean("policy", $policy_id, $user_id);
    }

    // ------------------------------------------------------------------------------ //
    // --------------------------- get cargo policy bean by id  --------------------- //
    // ------------------------------------------------------------------------------ //
    public function getCargoPolicy($cargo_policy_id, $user_id)
    {
        return DBConnection::getBasicObjectBean("cargo_policy", $cargo_policy_id, $user_id);
    }

    // --------------------------------------------------------------------- //
    // --------------------------- create new policy   --------------------- //
    // --------------------------------------------------------------------- //
    public function createPolicy($policy_bean, $user_id){
        // Create DB Record
        $createPolicyRecord = DBConnection::insertDB("policy",$policy_bean,$user_id);
        $policy_id =  $createPolicyRecord[0]['@id'];
        return $policy_id;
    }

    // ------------------------------------------------------------------------------------ //
    // -------------- create cargo policy conjuction record ------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function createCargoPolicy($policy_id, $cargo_id, $user_id){
   
        $cargoPolicyBean = new stdClass();
        $cargoPolicyBean->policy_id = $policy_id;
        $cargoPolicyBean->cargo_id = $cargo_id;
        $createCargoPolicyRecord = DBConnection::insertDB("cargo_policy",$cargoPolicyBean,$user_id);

        $cargoPolicyId =  $createCargoPolicyRecord[0]['@id'];
        return $cargoPolicyId;
    }

    // --------------------------------------------------------------------------------- //
    // --------------------------- Change Status of certain policy --------------------- //
    // --------------------------------------------------------------------------------- //
    public function changeCargoPolicyStatus($cargoPolicy_id, $new_status, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $cargoPolicy_id;
        $updateStruct->status = $new_status;
        $updateStruct->approve_date = DBConnection::getSystemDate();
        // change the status
        DBConnection::updateDB("cargo_policy", $updateStruct, $user_id);
    }

    // --------------------------------------------------------------------------------- //
    // --------------------------- Change Status of certain policy --------------------- //
    // --------------------------------------------------------------------------------- //
    public function changeStatus($policy_id, $new_status, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $policy_id;
        $updateStruct->status = $new_status;
        // change the status
        DBConnection::updateDB("policy",$updateStruct,$user_id);
    }

    // --------------------------------------------------------------------------------- //
    // --------------------------- Change Status of certain policy --------------------- //
    // --------------------------------------------------------------------------------- //
    public function updateCargoPolicyDetails($cargo_policy_id, $details, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $cargo_policy_id;
        $updateStruct->details = $details;
        
        // change the status
        DBConnection::updateDB("cargo_policy",$updateStruct,$user_id);
    }
}