<?php

require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/payment_agent_core.php");
require_once (dirname(__FILE__)."/../notes/add_notes_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../gateway/gateWay_core.php");
require_once (dirname(__FILE__)."/../account/account_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");


class payment_agent_interface  extends API{

    // the request of each call
    private $_request = array();
    private $_paymentAgentCore;
    private $_accountCore;
    private $_tenderCore;
    private $_waybillCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();

        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the PaymentAgentCore object
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_accountCore = new AccountCore();
        $this->_tenderCore = new TenderCore();
        $this->_waybillCore = new WaybillCore();


        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
            $this->$func();
    }


    // -------------------------------------------------------------- //
    // --------------------- get PaymentAgent info------------------------- //
    // -------------------------------------------------------------- //
    public function getPaymentAgent(){
        $paymentAgentBean = json_decode($this->_paymentAgentCore->getPaymentAgent($this->_request->id, $_SESSION['user_id']));
        $company_id = $paymentAgentBean->company_id;
        $searchFilter = [['key' => 'company_id', 'val' => $company_id]];
        $accountBean = $this->_accountCore->searchAccount($searchFilter, 1, 0, $_SESSION['user_id']);
        $paymentAgentBean->balance = $accountBean->data[0]->balance;
        $paymentAgentBean->minimum_balance = $accountBean->data[0]->minimum_balance;
        $paymentAgentBean->account_id = $accountBean->data[0]->id;

        //return Success reponse
        parent::response($paymentAgentBean);
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for PaymentAgents using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchPaymentAgents(){

        // call the core search
        $searchFilter = $this->prepareFilter();

        $paymentAgents_qry = $this->_paymentAgentCore->searchPaymentAgents(  $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );
        foreach ($paymentAgents_qry->data as $pa) {
            $commpany_id =$pa->company_id;
            $searchFilter = [['key'=>'company_id','val' =>$commpany_id]];
            $accountBean =$this->_accountCore->searchAccount($searchFilter,1,0,$_SESSION['user_id']);
            $pa->balance= $accountBean->data[0]->balance;
            $pa->minimum_balance= $accountBean->data[0]->minimum_balance;
            $pa->account_id= $accountBean->data[0]->id;

        }

        parent::response($paymentAgents_qry);
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for PaymentAgents using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderPaymentAgents(){

        // call the core search
        $searchFilter = $this->prepareFilter();

        $is_tender_payable = false;
        // if the session is corporate
        if($_SESSION['type'] == 'CORPORATE'){
            // if the company id is tender_payable (جهة مطالبة) see all tender agents whinin a tender
            $tender_id = 0;
            foreach ($searchFilter as $filter) {                      
                if($filter['key'] == 'tender_id'){
                    $tender_id = $filter['val'];
                }
            }                       
            $sqlQuery = " select id from tender_payable where tender_id = ? and company_id = ?";
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_id,$_SESSION['company_id']]);

            if(sizeof($result) > 0){
                $is_tender_payable = true;
            }
        }
       
        if($is_tender_payable){
            $searchFilter = [];
            $searchFilter[] = ['key' => 'tender_id', 'val' => $tender_id];
            $searchFilter[] = ['key' => 'status', 'val' => 'ACTIVE'];

            $paymentAgents_qry = $this->_paymentAgentCore->searchTenderPaymentAgents(
                $searchFilter,
                $this->_request->limit,
                $this->_request->offset,
                0
            );
        }else{
            $paymentAgents_qry = $this->_paymentAgentCore->searchTenderPaymentAgents(
                $searchFilter,
                $this->_request->limit,
                $this->_request->offset,
                $_SESSION['user_id']
            );
        }
        
        parent::response($paymentAgents_qry);
    }

    // ------------------------------------------------------------------ //
    // --------------------- create new payment Agent   ---------------- //
    // ------------------------------------------------------------------- //
    public function createPaymentAgent(){
        try {
            DBConnection::startTransaction();
            // create PA Bean
            $paymentAgentBean = new stdClass();
            $paymentAgentBean->name = $this->_request->name;
            $paymentAgentBean->company_id = $this->_request->company_id;
            $paymentAgentBean->photo = $this->_request->photo;
            $paymentAgentBean->minimum_balance = $this->_request->minimum_balance?$this->_request->minimum_balance:0;

            $accountBean = new stdClass();
            $accountBean->name = $this->_request->name;
            $accountBean->company_id = $this->_request->company_id;
            $accountBean->minimum_balance = $this->_request->minimum_balance;
            $id = $this->_paymentAgentCore->createPaymentAgent($paymentAgentBean, $_SESSION['user_id']);

            // create its account and sub accounts
            $this->_accountCore->createAccount($paymentAgentBean, "payment_agent" , 0);

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "PAYMENT_AGENT.SUCCESSFUL_OPERATION";
            $Result['ID'] = $id;
            parent::response($Result, 200);


            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    private function prepareFilter(){
        $paymentAgentFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($value){
                    if($key=='name') {
                        $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                        array_push($paymentAgentFilter,$tempArr);
                    } else {
                        $tempArr = ['key'=>$key,'val' => $value];
                        array_push($paymentAgentFilter,$tempArr);
                    }
                }
            }
        }
        return $paymentAgentFilter;
    }

    // ------------------------------------------------------------------ //
    // --------------------- update payment agent info ------------------------- //
    // ------------------------------------------------------------------ //
    public function updatePaymentAgent(){

        $paBean = $this->cleanBean($this->_request);

        $this->_paymentAgentCore->updatePaymentAgent($paBean,
                                                   $this->_request->id,
                                                   $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "PAYMENT_AGENT.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // -------------------------------------------------------------------------- //
    // --------------Clear the request and form it to be a valid pa bean --------- //
    // --------------------------------------------------------------------------- //
    private function cleanBean ($request) {

        $paBean = new stdClass();

        // prepare the photos info array
        $photos_array = [];
        $photos_info = new stdClass();
        $photos_info->type = 'logo';
        $photos_info->url = $request->logo;
        $photos_array[0]=$photos_info;

        $paBean->photo = json_decode(json_encode($photos_array)) ;

        return $paBean;
    }

    
    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate PaymentAgent Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeStatus(){

        $this->_paymentAgentCore->changeStatus(
            $this->_request->id,
            $this->_request->new_status,
            $_SESSION['user_id']
        );
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "PAYMENT_AGENT.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate PaymentAgent Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function getPaymentAgentAccounts(){

        $this->_paymentAgentCore->changeStatus(
            $this->_request->id,
            $this->_request->new_status,
                $_SESSION['user_id']
            );
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "PAYMENT_AGENT.SUCCESSFUL_OPERATION";
        parent::response($Result);
        }



    // ------------------------------------------------------------------ //
    // --------------------- create new payment Agent   ---------------- //
    // ------------------------------------------------------------------- //
    
    public function createTenderPaymentAgent()
    {
        try {

            $accountCore = new AccountCore();
            
            DBConnection::startTransaction();

            // if user does have accounts , create it
            if($this->_request->no_account){

                // get account id of the ledger owender of the project
                if($this->_request->tender_id == 3){
                    $account_id = "590000";
                    $company_id = 266770;
                }
                
                // search for the maximum AP account
                $accountFilter = [['key'=>"id",'val' => $account_id],['key'=>"type",'val' => "AP"],['key'=>"status",'val' => 'ACTIVE']];
                $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0, ' order by sub_id desc ');
                foreach ($account_qry->data as $acc) {
                    $account_id = $acc->id;
                    $account_sub_id = $acc->sub_id + 1;
                }

                // get pa bean
                $paBean = $this->_paymentAgentCore->getPaymentAgentBasic($this->_request->pa_id, $_SESSION['user_id']);

                // create sub account
                $subAccountBean = new stdClass();
                $subAccountBean->id = $account_id;
                $subAccountBean->company_id = $company_id;
                $subAccountBean->minimum_balance = 0;
                $account_name = "ذمة " . $paBean->name;
                $account_sub_id = $this->_accountCore->createSubAccount($subAccountBean, null, "AP", $account_name, $_SESSION['user_id']);
            }else{
                // if user provides the accounts, validate it
                $account_id = $this->_request->account_id;
                $account_sub_id = $this->_request->account_sub_id;
                $accountFilter = [
                    ['key' => 'id', 'val' => $account_id],
                    ['key' => 'sub_id', 'val' => $account_sub_id],
                    ['key' => 'type', 'val' => "AP"]
                ];
                $accounts = $accountCore->searchAccount($accountFilter, 1, 0, 0);
                if ($accounts->found_rows == 0) {
                    throw new Exception("رقم الحساب غير صحيح");
                }
            }

            // search for the pa
            $searchFilter = [
                    ["key" => "tender_id", "val" => $this->_request->tender_id],
                    ["key" => "pa_id", "val" => $this->_request->pa_id],
            ];
            $paymentAgents_qry = $this->_paymentAgentCore->searchTenderPaymentAgents( $searchFilter,1,0,0 );

            if ($paymentAgents_qry->found_rows > 0) {
                throw new Exception("المكتب معرف مسبقا على المشروع بعقد فعال");
            }

            // create Tender PA record
            $paymentAgentBean = new stdClass();
            $paymentAgentBean->pa_id = $this->_request->pa_id;
            $paymentAgentBean->tender_id = $this->_request->tender_id;
            $paymentAgentBean->accounts = [["AP"=>$account_id."-".$account_sub_id]];
            $paymentAgentBean->status = "ACTIVE";
            $result = DBConnection::insertDB("tender_pa", $paymentAgentBean, $_SESSION['user_id']);
            $paymentAgentBean->id = $result [0]['@id'];
            DBConnection::updateDB("tender_pa", $paymentAgentBean, $_SESSION['user_id']);

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "PAYMENT_AGENT.SUCCESSFUL_OPERATION";
            $Result['ID'] = $result[0]['@id'];
            parent::response($Result, 200);
           
            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

     // ---------------------------------------------------------- //
        // --------------- search waybill inquiry  ---------- //
        // ---------------------------------------------------------- //
        public function SearchWaybillInquiry()
        {
            try {
                $value = $this->_request->user_input;
                $result = $this->_paymentAgentCore->SearchWaybillInquiry($value, $_SESSION['user_id']);

                parent::response($result, 200);
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }


    // ------------------------------------------------------------- //
    // -------------------update for PaymentAgents  ---------- //
    // ------------------------------------------------------- //
    public function updateTenderPaymentAgents()
    {
        $fps = new FPS();

        // $sub_id = "40015";
        $sub_id = $this->_request->jv_sub_account_number;
        // $jv_amount = 4;
        $jv_amount = $this->_request->jv_amount;

        $accountFilter = new stdClass();
        $accountFilter->filter = ["type" => "ap", "sub_id" => $sub_id];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry =  $fps->searchAccount($accountFilter,  $_SESSION['user_id']);


        if ($account_qry["found_rows"] == 0) {
            // throw new Exception("رقم الحساب الفرعي غير صحيح ");
        }

        // call the core search
        $filter = [];

        $paymentAgents_qry = $this->_paymentAgentCore->searchTenderPaymentAgents(
            $filter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );


        foreach ($paymentAgents_qry->data as $tender_pa_contract) {
            $template = json_decode($tender_pa_contract->jv_template)->template;
            if ($template && sizeof($template) > 1) {
                foreach ($template as $item) {
                    if ($item->source_account) {
                        if (explode("-", $item->value[0])[1] == $sub_id) {
                            // throw new Exception("جدث خطا رقم الحساب الفرعي المدخل مدرج لمكتب صرف اخر ");
                        }
                    }
                }
            }
        }

        $searchFilter = $this->prepareFilter();

        $paymentAgents_qry = $this->_paymentAgentCore->searchTenderPaymentAgents(
            $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        $paymentAgents_template = json_decode($paymentAgents_qry->data[0]->jv_template)->template;
        foreach ($paymentAgents_template as  &$item) {
            if ($item->source_account) {
                $val = explode("-", $item->value[0])[0] . "-" . $sub_id;
                $item->value = [$val];
                $item->amount[1]->val = $jv_amount;
            }
            if (!$item->target_account && !$item->source_account) {
                $item->amount[0]->val = $jv_amount;
            }
        }

        $paymentAgents_qry->data[0]->jv_template = json_encode($paymentAgents_template, JSON_UNESCAPED_UNICODE);



        $tender_PA_bean = $paymentAgents_qry->data[0];
        $this->_paymentAgentCore->updateTenderPaymentAgent($tender_PA_bean,  $_SESSION['user_id']);

        parent::response("تمت العملية بنجاح ");
    }
}

$payment_agent_interface= new payment_agent_interface();
