<?php
/**
 * Created by Mahdi.
 * User: Mahdi Hamdan
 * Date: 12/30/2018
 * Time: 13:40 AM
 */

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../tender_claim/tender_claim_core.php");




class PaymentAgentCore
{
    private $_tenderCore;
    private $_waybillCore;

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  payment agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getPaymentAgent($id, $user_id)
    { // IMPORTANT: user_id is the user who search not the user we are looking for.

        $paymentAgentInfo = DBConnection::getObjectBean("pa", $id, $user_id);
        if ($paymentAgentInfo == null) {
            throw new Exception("PAYMENT_AGENT.NOT_EXIST", 0);
        }
        return $paymentAgentInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------get  payment agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getPaymentAgentBasic($id, $user_id)
    {
        $paymentAgentInfo = DBConnection::getBasicObjectBean("pa", $id, $user_id);
        if ($paymentAgentInfo == null) {
            throw new Exception("PAYMENT_AGENT.NOT_EXIST", 0);
        }
        return $paymentAgentInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  payment agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderPaymentAgent($filter,$limit,$offset,$user_id)
    {
        $searchPaymentAgentResult = DBConnection::searchDB("tender_pa", $filter, $limit, $offset, $user_id);
        if(sizeof($searchPaymentAgentResult->data) > 0){
            return $searchPaymentAgentResult;
        }else{
            throw new Exception("PAYMENT_AGENT.NOT_EXIST", 0);
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  payment agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderPaymentAgents($filter,$limit,$offset,$user_id)
    {
        $searchPaymentAgentResult = DBConnection::searchDB("tender_pa", $filter, $limit, $offset, $user_id);
        if(sizeof($searchPaymentAgentResult->data) > 0){
            return $searchPaymentAgentResult;
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  payment agent bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getTenderPaymentAgent($searchFilter, $limit, $offset, $user_id)
    {

        $searchPaymentAgentResult = DBConnection::searchDB("tender_pa", $searchFilter, $limit, $offset, $user_id);
        return $searchPaymentAgentResult;
    }

    // -------------------------------------------------------------------------- //
    // -------------------search for payment agent using any search filter ---------- //
    // -------------------------------------------------------------------------- //
    public function searchPaymentAgents($searchFilter, $limit, $offset, $user_id){

        $searchPaymentAgentResult = DBConnection::searchDB("pa", $searchFilter, $limit, $offset, $user_id);
        return $searchPaymentAgentResult;
    }

    // -------------------------------------------------------------------------- //
    // ------------------- Create Payment Agent   ----------- //
    // -------------------------------------------------------------------------- //
    public function createPaymentAgent($paymentAgentBean, $user_id){

        // validate if the company has already PA
        $activePaStatus = DBConnection::getActiveStatus('pa');
        $paFilter = [['key'=>'company_id','val' =>$paymentAgentBean->company_id],
                     ['key'=>'status','val' =>$activePaStatus , 'op'=>'in']
                    ];
        $paResult = $this->searchPaymentAgents($paFilter, 1, 0, $user_id);
        if($paResult->found_rows > 0){
            throw new Exception("مكتب الصرف معرف مسبقا للشركة");            
        }

        // Create DB Record
        $createCargoResult = DBConnection::insertDB("pa",$paymentAgentBean,$user_id);
        $paymentAgenntId =  $createCargoResult[0]['@id'];
        return $paymentAgenntId;
    }

    // --------------------------------------------------------------------------- //
    // ---------------------activate/ Deactivate an payment agent---------------------- //
    // --------------------------------------------------------------------------- //
    public function changeStatus($payment_agent_id, $new_status, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $payment_agent_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("pa", $updateStruct, $user_id);
    }

    // ------------------------------------------------------------------ //
    // --------------------- Update pa info in DB------------------------ //
    // ------------------------------------------------------------------ //
    function updatePaymentAgent($paBean,$pa_id, $updated_by){

        // fill update struct and set the target user id
        $paBean->id = $pa_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("pa",$pa_id,$updated_by);

        //update driver info only if the driver bean is different than DB bean
        if(compareObject($paBean,$DB_Bean) == false) {

            // map all the new values into the DB_bean
            $paBean = mapBeanToDBBean($paBean,$DB_Bean);

            //re-validate the user input
            // $this->validateForEdit($driverBean);

            // fill update struct and set the target user id
            DBConnection::updateDB("pa",$paBean,$updated_by);
        }
    }

    public function SearchWaybillInquiry($user_input, $user_id)
    {
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();
        $truckingCompanyCore = new TruckingCompanyCore();
        $tenderClaimCore = new TenderClaimCore();
        $routeWageCore = new RouteWageCore();

        $value = $user_input;
        if(strlen($value) ==  5){
            $value = "60" . $value;
        }

        // get the first 2 digits to determine user input type
        $firstTowDigits = substr(strval($value), 0, 2);

        //  tenders that has tagreesh
        $tender_ids = [13,11,12];

        // setup search filters based on user input
        if ($firstTowDigits == "60") {
            $searchFilter = [
                ['key' => "tn", 'val' => $value]
                
            ];
        } else if (strval($firstTowDigits) >= 20 && strlen($value) ==  10){
            $searchFilter = [
                ['key' => "wn", 'val' => $value]
                
            ];
        } else {
            $searchFilter = [
                ['key' => "document->>'$.nafith_wn", 'val' => $value]
            ];
        }
        $searchFilter[] = ['key' => 'tender_id', 'val' => $tender_ids, "op" => "in"];
        $searchFilter[] = ['key' => 'loading_date', "op" => "is not null"];
        $searchFilter[] = ['key' => 'status', 'val' => ["COMPLETE", "REVOKED", "INACTIVE"], "op" => "not in"];
        $searchFilter[] = ['key' => 'create_date', 'val' => '2021-01-01', "op" => "date greater than"];
                
        $waybills =  $waybillCore->searchWaybills($searchFilter, 1000, 0,  $user_id , ' order by id desc ');

        if($waybills->found_rows == 0){
            throw new Exception("لا يوجد معلومات متاحة");            
        }

        // filter out the waybill if found in tender claim items (that means it is already in claim)
        $waybill_ids = [];
        foreach ($waybills->data as $waybill) {
            $waybill_ids[] = $waybill->id;
        }
        $searchTenderClaimItemsFilter = [
            ['key' => 'waybill_id', 'val' => $waybill_ids, "op" => "in"],
            ['key' => 'status', 'val' => ["INACTIVE"], "op" => "not in"],
            ['key' => 'tender_claim_type', 'val' => "waybill_claim"]
        ];
        $tenderClaims  =   $tenderClaimCore->searchTenderClaimItems($searchTenderClaimItemsFilter, 1000, 0, $user_id);
 
        $tenderClaimIds = [];
        foreach ($tenderClaims->data as $tenderClaim) {
            $tenderClaimIds[] = $tenderClaim->waybill_id;
        }
        foreach ($waybills->data as $key => $value) {
            foreach ($tenderClaimIds as $tenderWaybillId) {
                if ($tenderWaybillId == $value->id) {
                    //unset($waybills->data[$key]);
                }
            }
        }

        // loop on each remaining waybills , and collect needed info
        $data = [];
        foreach ($waybills->data as $key => $value) {
            $TempData = new stdClass();
            $document = json_decode($value->document);
            $solaf = "";

            // get the route wage
            $waybillBean = $value;
            $routeWageFilter = [['key'=>'destination_id','val' =>$waybillBean->destination_id],
                                ['key'=>'tender_id','val' =>$waybillBean->tender_id],
                                ['key'=>'cargo_id','val' =>$document->cargo[0]->cargo_id],
                                ['key'=>'start_date','val' =>  $waybillBean->loading_date , 'op'=>'less than'],
                                ['key'=>'end_date','val' =>  $waybillBean->loading_date, 'op'=>'greater than'],
                                ['key'=>'type','val' =>  'payable'],
                                ['key'=>'status','val' => 'ACTIVE']];    
            $routeWageInfo = $routeWageCore->searchRouteWage($routeWageFilter,10,0,0);

            // calculate and render the advance payments
            if ($document->freight->payments && count($document->freight->payments) > 0) {
                foreach ($document->freight->payments as $value1) {
                 
                    if ($value1->name == "DRIVER_WAGE" ||  $value1->name == "CASH_DOWNPAYMENT" ||  $value1->name == "ADEL_DEBIT") {
                        $solaf = $solaf .
                            '<tr class="thStyle">
                               <td class="tdStyle">' . $value1->label . '</td>
                               <td class="tdStyle">' . $value1->value->amount . '</td>
                             </tr>';
                    }
                }

 
                if ($solaf == "") {
                    $advance_payment =  '<div  style=" text-align: center;"> لايوجد سلف</div>';
                } else {
                    $advance_payment =   ' <table class="table table-bordered table-hover tableStyle">
                        <tr class="" style=" text-align: center;">
                          <th class="" style=" text-align: center;">نوع السلف</th>
                          <th class="" style=" text-align: center;">القيمة</th>
                        </tr>
                        ' . $solaf . '
                      </table>';
                }
            } else {
                $advance_payment =  '<div  style=" text-align: center;"> لايوجد سلف</div>';
            }

           
 
            $template = '<!DOCTYPE html>
            <html lang="ar">
            <head>
              <meta charset="UTF-8">
              <meta http-equiv="X-UA-Compatible" content="IE=edge">
              <meta name="viewport" content="no, initial-scale=no, maximum-scale=no"/>
              <title>Document</title>
              <style>
                .MinagateFont {
                  font-family: DroidArabicKufiRegular;
                  font-weight: lighter;
                  font-style: normal;
                  color: #807d7d;
                  font-size: 30px;
                  margin: 1%;
                  padding:1%;
                }
                .labelStyle {
                  text-align: right;
                  padding-right: 25px;
                }
                .valueStyle {
                  text-align: right;
                  color: rgb(74, 163, 222);
                }
                .divStyle {
                  padding: 4px;
                  padding-bottom: 5%;
                  border-bottom: solid 0.5px #ccc;
                }
                .tableStyle {
                  width: 100%;
                  max-width: 100%;
                  margin-top: 2px;
                  margin-bottom: 2px;
                  text-align: center;
                }
                .tdStyle {
                  padding: 5px;
                  font-size: 30px;
                  text-align: center;
                }
                .thStyle {
                  text-align: center;
                  font-size: 30px;
                  font-weight: 100;
                  color: #3995d2;
                  width: 30%;
                }
              </style>
              <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
            </head>
            <body dir="rtl">
              <div class="MinagateFont">
                <form>
                  <div class="form-group divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">
                     ' . $value->tn . '
                    </label>
                    <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle">  رقم الشاحنة :</label>
                  </div>
                  <div class="form-group divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $value->wn . '</label>
                    <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle">  المستند :</label>
                  </div>
                  <div class="form-group  divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->tender->name . '</label>
                    <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle">  المشروع :</label>
                  </div>
                  <div class="form-group  divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->cargo[0]->name . '</label>
                    <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle">  الحمولة :</label>
                  </div>
                  <div class="form-group  divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->carrier[0]->driver->name . '</label>
                    <label class="col-sm-5  col-md-5 col-xs-5 col-form-label labelStyle">  السائق :</label>
                  </div>
                  <div class="form-group divStyle row">
                    <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">' . $document->cargo[0]->weights->loading->time_stamp . '</label>
                    <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle">  تاريخ التحميل :</label>
                  </div>
                  <div class="form-group divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">' . $document->negotiable_instructios->route->destination->name . '</label>
                    <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle">  موقع التفريغ :</label>
                  </div>
                  <div class="form-group divStyle row">
                    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">' . $routeWageInfo->data[0]->wage_per_ton . ' </label>
                    <label class="col-sm-5   col-md-5 col-xs-5 col-form-label labelStyle">  التسعيرة :</label>
                  </div>
                </form>
                <div class="form-group  row">
                <label class="col-sm-12  col-xs-12   col-md-12  col-form-label labelStyle" style="text-align: center;">  السلف</label>
              </div>
            ' . $advance_payment . '
              </div>
            </body>
            </html>';

            $tag = "Template";
            $TempData->$tag =  $template;
            $TempData->data = new stdClass();
            $item1 = new stdClass();
            $item1->label = $value->tn . "+" . $value->trn;
            $TempData->data->item1 = $item1;

 
            $item2 = new stdClass();
            $item2->label = $document->cargo[0]->name;
            $TempData->data->item2 = $item2;

            $item3 = new stdClass();
            $item3->label = $document->tender->name;
            $TempData->data->item3 = $item3;

            $item4 = new stdClass();
            $item4->label = $document->wn;
            $TempData->data->item4 = $item4;

            $data[] = $TempData;
        }

        return $data;
    }

  // ------------------------------------------------------------------ //
  // --------------------- Update tender pa info in DB------------------------ //
  // ------------------------------------------------------------------ //
  function updateTenderPaymentAgent($tenderPaBean, $updated_by)
  {
    DBConnection::updateDB("tender_pa", $tenderPaBean, $updated_by);
}
}
