<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/payment_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../../core/tender_claim/tender_claim_core.php");
require_once(dirname(__FILE__) . "/../../core/pa_route_wage/pa_route_wage_core.php");


class Payment_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_paymentCore;
    private $_waybillCore;
    private $_routeWageCore;
    private $_userCore;
    private $_accountCore;
    private $_tenderCore;
    private $_tenderClaimCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            // throw new Exception('No Session!');
        }

        // init the object
        $this->_paymentCore = new PaymentCore();
        $this->_waybillCore = new WaybillCore();
        $this->_routeWageCore = new RouteWageCore();
        $this->_tenderCore = new TenderCore();
        $this->_userCore = new UserCore();
        $this->_accountCore = new AccountCore();
        $this->_tenderClaimCore = new TenderClaimCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ------------------------------------------------------------------------------------------------------------- //
    // --------------- pay amount of money to an AP account -------------------------------------------------------- //
    // --------------- this procedure occures when trucking company pay the payment agent its money ---------------- //
    // --------------- or when truck_owner pay the trucking company its money -------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------- //
    public function payAccountPayableProcedure()
    {

        // prepare params
        $revinue_account_id = $this->_request->revinue_account_id;
        $ap_account_id = $this->_request->ap_account_id;
        $amount = $this->_request->amount;
        $remarks = $this->_request->remarks;

        // get the account beans
        $revinueAccountBean = $this->_accountCore->getAccountBasic($revinue_account_id, $_SESSION['user_id']);
        $apAccountBean = $this->_accountCore->getAccountBasic($ap_account_id, $_SESSION['user_id']);

        // call the core method
        $this->_paymentCore->payAccountPayableProcedure($revinueAccountBean, $apAccountBean, $amount, $remarks, $_SESSION['user_id']);

        // return result
        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'PAYMENT.SUCCESS_OPERATION';
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------------------------- //
    // --------------- pay amount of money to an AR account -------------------------------------------------------- //
    // --------------- this procedure occures when payment agent receive its money from trucking company ----------- //
    // --------------- or when trucking company received its money from truck owner  ------------------------------- //
    // ------------------------------------------------------------------------------------------------------------- //
    public function payAccountReceivableProcedure()
    {

        // prepare params
        $revinue_account_id = $this->_request->revinue_account_id;
        $ar_account_id = $this->_request->ar_account_id;
        $amount = $this->_request->amount;
        $remarks = $this->_request->remarks;

        // get the account beans
        $revinueAccountBean = $this->_accountCore->getAccountBasic($revinue_account_id, $_SESSION['user_id']);
        $arAccountBean = $this->_accountCore->getAccountBasic($ar_account_id, $_SESSION['user_id']);

        // call the core method
        $this->_paymentCore->payAccountReceivableProcedure($revinueAccountBean, $arAccountBean, $amount, $remarks, $_SESSION['user_id']);

        // return result
        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'PAYMENT.SUCCESS_OPERATION';
        parent::response($Result);
    }


    // ------------------------------------------------ //
    public function validateCalculateFreightInputs()
    {
        try {
            // check loading weights
            $res =  $this->_paymentCore->validateCalculateFreightInputs($this->_request);

            parent::response($res);
        } catch (Exception $e) {
            throw new Exception($e, 1);
        }
    }





    // ----------------------------------------------------------------------------- //
    // --------------- calculate Freight on a certain waybill ---------------------- //
    // --------------- params: waybill_id, loading_date, loading_weight ------------ //
    // ---------------         discharge_weight ------------------------------------ //
    // ----------------------------------------------------------------------------- //
    public function calculateFreight()
    {

        // prepare params
        $waybill_id = $this->_request->waybill_id ? $this->_request->waybill_id : $this->_request->id;
        $loading_date = $this->_request->loading_date ? $this->_request->loading_date : $this->_request->loading_timestamp;
        $loading_weight = $this->_request->loading_weight;
        $discharge_weight = $this->_request->discharge_weight;
        $discharge_date = $this->_request->discharge_date ? $this->_request->discharge_date : $this->_request->discharge_timestamp;
        $arrival_date = $this->_request->arrival_date;
        $gross_weight = $this->_request->gross_weight;
        $destination_id = $this->_request->destination_id;
        $cargo_id = $this->_request->cargo_id;
        $type = $this->_request->type;
        $origin_id = $this->_request->origin_id;
        $paymentAgentId = $this->_request->paymentAgentId;

        // get the waybill bean to make sure the user has the auth and the ownership to calucltae freight to this waybill
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        // try to get a refreshed weight from Jo_petrol
        if ($waybillBean->tender_id == 11 || $waybillBean->tender_id == 12) {
            // $jo_petrol_integration = new Jo_Petrol();
            // $refreshResult = $jo_petrol_integration->refreshWeights($waybill_id);
        }
 

        // get the waybill bean to get fresh copy of the bean in case the weights have been changed
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        // get the loading date from waybill in case it is not provided from user
        if (!$loading_date) {
            $loading_date  = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
        }
        if (!$loading_date) {
            throw new Exception("تاريخ التحميل للمستند غير موجود");
        }


        // get the loading weight from waybill in case it is not provided from user
        if (!$loading_weight) {
            $loading_weight  = $waybillBean->document->cargo[0]->weights->loading->net_weight;
        }
        if (!$loading_weight) {
            throw new Exception("وزن التحميل للمستند غير موجود");
        }

        // get the gross weight from waybill in case it is not provided from user
        if (!$gross_weight) {
            $gross_weight = $waybillBean->document->cargo[0]->weights->loading->gross_weight->weight;
        }

        // get the discharged weight from waybill in case it is not provided from user
        if (!$discharge_weight) {
            $discharge_weight  = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
        }


        if (!$discharge_weight) {
            throw new Exception("وزن التفريغ للمستند غير موجود");
        }

        // if the user can ovveride the existance route wage, then clear it to force re-calculating
        //if($override_route_wage){            
        try {
            // validate auth
            DBConnection::has_authority($_SESSION['u_id'], 'WAYBILL', 'OVERRIDE_ROUTE_WAGE', 'CLOSED', 'CLOSED');
            $routeWage = null;
            // $waybillBean->document->freight->deductions = null;
            // $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);
            // $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        } catch (Exception $e) {
        }
        //}

        if ($cargo_id) {
            $waybillBean->document->cargo[0]->cargo_id = $cargo_id;
        }

        if (!$destination_id) {
            $destination_id  = $waybillBean->destination_id;
        } else {
            $waybillBean->document->negotiable_instructios->route->destination->id = $destination_id;
        }

        if (!$origin_id) {
            $origin_id  = $waybillBean->origin_id;
        } else {
            $waybillBean->document->negotiable_instructios->route->origin->id = $origin_id;
        }


        $waybillBean->document->cargo[0]->weights->loading->time_stamp = $loading_date;
        $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $discharge_date;
        $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
        $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $arrival_date;

        // in case no route wage is found in waybill
        if (!$routeWage) {
            // search in routre wage table
            $routeWage = $this->_routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $origin_id,
                $destination_id,
                $waybillBean->document->cargo[0]->cargo_id,
                $loading_date,
                $type,
                false,
                $waybillBean,
                $_SESSION['pa_id']
            );
        }

        if (!$routeWage) {
            throw new Exception("لا يوجد تسعيرة معرفة لتاريخ التحميل المدخل");
        }

        $pa_id = $paymentAgentId;
        if (isset($_SESSION['pa_id']) && $_SESSION['pa_id'] && $_SESSION['pa_id'] != 2) {
            $pa_id = $_SESSION['pa_id'];
        }
        $frieght_node = $this->_paymentCore->calculateFreight($waybillBean, $discharge_weight, $loading_weight, $routeWage, $gross_weight, $pa_id);

        //return response
        parent::response($frieght_node);
    }



    // ------------------------------------------------------------------------------------------------------- //
    // -------------------- Save Freight information into the waybill ---------------------------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function saveFreight()
    {
        try {
            // prepare params
            $waybill_id = $this->_request->waybill_id;
            $cancel_axial_load_fine = $this->_request->cancel_axial_load_fine;
            $cancel_axial_load_fine_attachement = $this->_request->cancel_axial_load_fine_attachement;
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
            $extra_fine  = $this->_request->extra_fine;

            // if the user choose to cancel the fines
            // check if the tender settings allow to cancel fines
            if ($cancel_axial_load_fine) {
                $tender_id = $waybillBean->tender_id;
                $manifest = $this->_tenderCore->getTenderManifest($tender_id, 0);

                if ($manifest['allowCancelAxialLoadFine']) {
                    $attachements = [];
                    $item = new stdClass();
                    $item->code = "CANCEL_AXIAL_LOAD_FINE";
                    $item->attachment = $cancel_axial_load_fine_attachement;
                    $attachements[] = $item;
                    $waybillBean->document->freight->cancel_axial_load_fine = $attachements;

                    // update the waybill with cancel fine attachment
                    $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);
                } else {
                    throw new Exception("لا تستطيع إلغاء الغرامة على المشروع المطلوب");
                }
            }

            if ($extra_fine) {
                $tender_id = $waybillBean->tender_id;
                $manifest = $this->_tenderCore->getTenderManifest($tender_id, 0);
                $temp = [];
                $item = new stdClass();
                $item->code = "EXTRA_FINE";
                $item->value = $extra_fine;
                $temp[] = $item;
                $waybillBean->document->freight->extra_fine = $temp;
                // update the waybill with cancel fine attachment
                $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);
            }

            // save route wage into waybill
            $this->_waybillCore->savePaymentDNA($waybillBean);

            // save tagreesg info in waybill
            $this->_waybillCore->saveTagreeshData($waybillBean, $_SESSION['user_id'], $_SESSION['pa_id']);

            //return Success reponse
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------- //
    // --------------- Deposite money into Main Assets Account ------------------------------ //
    // --------------- params: amount, tender_id, target_account_id ------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function depositeAssets()
    {

        // parse params
        $amount = $this->_request->amount;
        $tender_id = $this->_request->tender_id;
        $target_account_id = $this->_request->target_account_id;

        // call the core deposite method
        $this->_paymentCore->depositeAssets($amount, $tender_id, $target_account_id, $_SESSION['user_id']);

        //return Success reponse
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }

    // ----------------------------------------------------------------------------- //
    // --------------- withdraw money from main_liability_account MLA -------------- //
    // --------------- params: amount, tender_id, user_id ----------------------- //
    // ----------------------------------------------------------------------------- //
    public function withdrawAssets()
    {

        // parse params
        $amount = $this->_request->amount;
        $tender_id = $this->_request->tender_id;
        $target_account_id = $this->_request->target_account_id;

        // call the core deposite method
        $this->_paymentCore->withdrawAssets($amount, $tender_id, $target_account_id, $_SESSION['user_id']);

        //return Success reponse
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }

    // ---------------------------------------------------------------------------------------------------- //
    // ------------------- Calculate the profit for each share holder for a certain tender  --------------- //
    // ------------------- Params: tender_id, snapshot_time------------------------------------------------ //
    // ---------------------------------------------------------------------------------------------------- //
    public function calculateProfitShare()
    {

        // validate this request

        // get input params
        $tender_id = $this->_request->tender_id;
        $snapshot_time = $this->_request->snapshot_time;

        // call core method
        $result = $this->_paymentCore->calculateProfitShare($tender_id, $snapshot_time);

        parent::response($result);
    }


    // -------------------------------------------------------------------------------- //
    // ------------------- get the balance of a certain Jo Petrol card  --------------- //
    // -------------------------------------------------------------------------------- //
    public function getJoPetrolCardBalance()
    {

        // get params
        $tn = $this->_request->tn;

        // call JO_Petrol API to get card balance
        $jo_petrol_integration = new Jo_Petrol();
        $Jo_petrol_card_balance = $jo_petrol_integration->checkCardBalance($tn);


        // get all the waybills on tender_id = 11 and not revoked or Inactive
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => 11],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
            ['key' => 'tn', 'val' => $tn]
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // loop on each waybill
        $total_diesel_amount = 0;
        foreach ($waybillResult->data as $wbl) {
            // calculate diesel amount of each waybill
            $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            $total_diesel_amount += doubleval($diesel_amount);
        }

        // return result
        $result = [];
        $result['Jo_petrol_card_balance'] = $Jo_petrol_card_balance['currentLimit'];
        $result['correct_card_balance'] = $total_diesel_amount;
        $result['number_of_waybills'] = intval($waybillResult->found_rows);

        parent::response($result);
    }


    // ----------------------------------------------------------------------------------- //
    // ------------------- Fix the diesel card balance for certain truck ----------------- //
    // ------------------- arguments: tn ------------------------------------------------- //
    // ----------------------------------------------------------------------------------- //
    public function fixDieselCardBalance()
    {

        // check authorites ( only operation managers are allowed to continue)
        $allow = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("You are not allowed to continue in this process");
        }

        // prepare obj
        $jo_petrol_integration = new Jo_Petrol();

        // get user input
        $tn = intval($this->_request->tn);
        $skip_fix_card_balance = $this->_request->skip_fix_card_balance;
        if (!$skip_fix_card_balance) {
            $skip_fix_card_balance = false;
        }

        // fix diesel
        $this->_paymentCore->fixDieselCardBalance($tn, $skip_fix_card_balance, $_SESSION['user_id']);

        //return Success reponse
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }


    //------------------------------------------------------------------------------------ //
    //----------------- Get list of payment methods ------------- //
    //------------------------------------------------------------------------------------ //
    public function getPaymentMethod()
    {

        //search accounts
        $result = [];
        $result[] = ["code" => "CHECK", "label" => "شيك"];
        $result[] = ["code" => "CASH", "label" => "كاش"];

        parent::response($result);
    }

    //------------------------------------------------------------------------------------ //
    //----------------- Get trips details to show diesel amount of each trip ------------- //
    //------------------------------------------------------------------------------------ //
    public function getJoPetrolCardTrips()
    {
        $jo_petrol_integration = new Jo_Petrol();
        $tn = $this->_request->tn;
        $_SESSION['user_id'] = 2;

        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $searchFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
            ['key' => 'tender_id', 'val' => '11']
        ];
        $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 10000, 0, $_SESSION['user_id'], ' order by wn desc ');
        $trips = [];
        $result = [];
        $dieselPreLoad = 0;
        $dieselPostLoad = 0;
        $deservingAmount = 0;

        foreach ($waybillsResult->data as $wabill) {
            $doc = json_decode($wabill->document);
            $temp = new stdClass();
            $temp->wn = $wabill->wn;
            $temp->trn = $wabill->trn;
            $temp->date = $wabill->loading_date;
            $temp->driver_name = $doc->carrier[0]->driver->name;
            foreach ($doc->freight->payments as $pay) {
                if ($pay->name == 'DEISIL_PRE_LOAD') {
                    $dieselPreLoad = $pay->value->amount;
                }
                if ($pay->name == 'DEISIL_POST_LOAD') {
                    $dieselPostLoad = $pay->value->amount;
                }
            }
            $temp->actual_amount = doubleval($dieselPreLoad) + doubleval($dieselPostLoad);

            $diesel_amount = $jo_petrol_integration->getDieselPayment($wabill->id, 'DEISIL_PRE_LOAD') +
                $jo_petrol_integration->getDieselPayment($wabill->id, 'DEISIL_POST_LOAD');

            if ($wabill->id == 305233) {
                $diesel_amount = $jo_petrol_integration->getDieselPayment($wabill->id, 'DEISIL_PRE_LOAD');
            }

            $deservingAmount = doubleval($diesel_amount);
            $temp->deserving_amount = $deservingAmount;
            array_push($result, $temp);
        }

        parent::response($result);
    }


    public function getJvTrx()
    {
        $jv_id = $this->_request->jv_id;
        $jv_trx = $this->_paymentCore->getJvTrx($jv_id);

        $result = new stdClass();
        $result->trx = $jv_trx;
        parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------- //
    // ----------------- get account statment for report "كشف الحسابات" --------------------------------- //
    // ----------------- params: tender_id, account_id, from_date, to_date, limit ----------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function undoJV()
    {
        $jv_id = $this->_request->jv_id;
        $note = $this->_request->note;

        try {
            // get all trx for this jv
            $jv_trx = $this->_paymentCore->getJvTrx($jv_id);
            // generate trx JSON by reversing each trx
            $reverse_trx = [];
            foreach ($jv_trx as $trx) {
                $temp = new stdClass();
                $temp->amount =  $trx->amount;
                $ledger_account_id =  $trx->account_id;
                $temp->account = $trx->account_id . "-" . $trx->sub_id;
                if ($trx->op == 'C') $temp->op = 'D';
                if ($trx->op == 'D') $temp->op = 'C';
                $temp->notes =  "عكس الحركة رقم " . $trx->id . "-" . $note;

                $reverse_trx[] = $temp;
            }

            // insert trx
            $jv_date = DBConnection::getSystemDate();
            $remarks = " عكس حركات  القيد رقم " . $jv_id . "-" . $note;
            $this->_paymentCore->addJV($ledger_account_id, $jv_date, $reverse_trx, $remarks, $_SESSION['u_id']);
        } catch (Exception  $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ----------------------------------------------------------------------------- //
    // --------------- calculate Freight on a certain waybill ---------------------- //
    // --------------- params: waybill_id, loading_date, loading_weight ------------ //
    // ---------------         discharge_weight ------------------------------------ //
    // ----------------------------------------------------------------------------- //
    public function calculateFreightWithoutWaybill()
    {

        // prepare params
        $pa_project_id = $this->_request->pa_project_id;
        $loading_date = $this->_request->loading_date;
        $loading_weight = $this->_request->loading_weight;
        $discharge_weight = $this->_request->discharge_weight;
        $discharge_date = $this->_request->discharge_date;
        $arrival_date = $this->_request->arrival_date;
        $gross_weight = $this->_request->gross_weight;
        $destination_id = $this->_request->destination_id;
        $origin_id = $this->_request->origin_id;
        $pa_id = $_SESSION['pa_id'];
        $ref_num = $this->_request->ref_num;
        //$bond_number = $this->_request->bond_number;

        if (!$loading_date) {
            throw new Exception("تاريخ التحميل  غير موجود");
        }

        if (!$loading_weight) {
            throw new Exception("وزن التحميل  غير موجود");
        }

        if (!$discharge_weight) {
            throw new Exception("وزن التفريغ  غير موجود");
        }

        if (!$destination_id) {
            throw new Exception("الوجهة غير موجودة");
        }

        if (!$origin_id) {
            throw new Exception("موقع التفريغ غير موجودة");
        }

        if (!$pa_id) {
            throw new Exception("مكتب الصرف  غير موجود");
        }


        $waybillBean = new stdClass();
        $waybillBean->document = new stdClass();
        $waybillBean->document->freight = null;
        $waybillBean->document->tender = new stdClass();
        $waybillBean->document->tender->id = null;
        $waybillBean->document->negotiable_instructios = new stdClass();
        $waybillBean->document->negotiable_instructios->route = new stdClass();
        $waybillBean->document->negotiable_instructios->route->destination = new stdClass();
        $waybillBean->document->negotiable_instructios->route->destination->id = $destination_id;

        // in case no route wage is saved in waybill, get the correct wage based on loading date
        $PaRouteWage = new PaRouteWageCore();
        $routeWage = $PaRouteWage->searchPaRouteWageForFreight(
            $pa_project_id,
            $pa_id,
            $origin_id,
            $destination_id,
            $loading_date,
            $_SESSION['user_id']
        );


        $frieght_node = $this->_paymentCore->calculateFreight($waybillBean, $discharge_weight, $loading_weight, $routeWage, $gross_weight);
        $paProjectReuslt = $PaRouteWage->getBasicPaProject($pa_project_id, $_SESSION['user_id']);
        if ($paProjectReuslt->details->fine_details) {
            foreach ($paProjectReuslt->details->fine_details as $fine) {
                if ($fine->type == "other_fines") {
                    $frieght_node->other_fines = $fine;
                }
            }
        }
        if ($paProjectReuslt->id == 53) {
            $frieght_node->allowed_to_override = [];
        } else {
            $frieght_node->allowed_to_override = ["late_fine"];
        }


        // in case the truck has NEW fps claim , calculate it
        $claim_advance_payment_value = $this->_paymentCore->calculateClaimAdvancePayment($ref_num, $pa_id, $_SESSION['user_id']);
        $frieght_node->amount->total_advance_payment = $frieght_node->amount->total_advance_payment + $claim_advance_payment_value;
        $frieght_node->amount->net_amount = $frieght_node->amount->net_amount - $claim_advance_payment_value;

        // calculate late fine
        $loading_date = strtotime($loading_date);
        $discharge_date = strtotime($discharge_date);
        $diff_in_hours = floor(($discharge_date - $loading_date) / (60 * 60)) + 24;

        if ($diff_in_hours > 72) {
            $lateFine = ceil(($diff_in_hours - 72) / 24) * 10;
            $frieght_node->amount->net_amount  = $frieght_node->amount->net_amount  - $lateFine;
            $frieght_node->amount->late_fine = $lateFine;
            $frieght_node->amount->late_fine_hours = ($diff_in_hours - 72);
            $frieght_node->amount->total_fines += $lateFine;
        }


        //return response
        parent::response($frieght_node);
    }
}

new Payment_interface();
