<?php

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/location/location_core.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");
require_once dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php";
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");

class PaymentCore
{

    private $_tenderCore;

    public function __construct()
    {
        DBConnection::getInstance();

        // init the object
        $this->_tenderCore = new TenderCore();
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // -------------------- caclulate freight amount to a certain waybill then generate json ---------------------- //
    //------------------------------------------------------------------------------------------------------------- //
    public function calculateFreight(
        $waybill_id,
        $discharged_weight = null,
        $loading_weight = null,
        $routeWage = null,
        $gross_weight = null,
        $pa_id = null
    ) {

        // init objects
        $tenderCore = new TenderCore;

        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }


        // get the original freight node
        $freight_node = $waybillBean->document->freight;
        if ($freight_node == null) {
            $freight_node = new stdClass();
            $freight_node->cargo_info = new stdClass();
        }

        // fill cargo_info node
        if ($discharged_weight == null) {
            $discharged_weight = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
        }

        if ($loading_weight == null) {
            $loading_weight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
        }


        $freight_node->cargo_info = (object) array("loading_weight" => $loading_weight, "discharged_weight" => $discharged_weight);

        // get the route wage which was stored in waybill freight upon loading, but use the param wage in case it is sent
        if ($routeWage == null) {
            $error_message = 'التسعيرة غير معرفة لموقع تفريغ مستند الشحن وحمولة الشاحنة';
            throw new Exception($error_message);
        }


        // if the discharged_weight is less than route wage minimum weight, update discharged_weight to be = minimum
        if ($routeWage->minimum_weight < 1000) {
            $routeWage->minimum_weight *= 1000; // convert it to KG
        }
        if ($discharged_weight < $routeWage->minimum_weight) {
            $discharged_weight = $routeWage->minimum_weight;
        }
        if ($loading_weight < $routeWage->minimum_weight) {
            $loading_weight = $routeWage->minimum_weight;
        }

        // get the efective weight to be used to calculate the base amount (loading or discharge)
        $discharged_weight_in_TON = $discharged_weight / 1000;
        $loading_weight_in_TON = $loading_weight / 1000;

        // make sure the effective_weight is stored in waybill route wage, else take it from manifest
        if (!$routeWage->effective_weight) {
            $tender_id = $waybillBean->document->tender->id;
            $manifestBean = $tenderCore->getTenderManifest($tender_id, 0);
            $routeWage->effective_weight = $manifestBean['route_wage_template']['effective_weight'];
        }
        // get tender id
        $tender_id = $waybillBean->document->tender->id;

        //if the loading weight is larger than discharge, make it equal to discharge
        if ($tender_id == 12) {
            if ($loading_weight_in_TON > $discharged_weight_in_TON) {
                $loading_weight_in_TON = $discharged_weight_in_TON;
            }
        }

        // calculate the base_amount
        switch ($routeWage->plan) {
            case 'PER_TON':
                $wage_per_ton = $routeWage->wage_per_ton;
                if ($routeWage->effective_weight == "loading_weight") {
                    $base_amount = $loading_weight_in_TON * $wage_per_ton;
                } else if ($routeWage->effective_weight == "discharge_weight") {
                    $base_amount = $discharged_weight_in_TON * $wage_per_ton;
                } else {
                    throw new Exception("effective_weight is not defined");
                }
                break;
            case 'FIXED':
                $base_amount = $routeWage->fixed_waybill_wage;
                break;
            default:
                throw new Exception("ROUTE_WAGE_PLAN_NOT_DEFINED");
                break;
        }

        $base_amount = number_format((float)$base_amount, 3, '.', '');

        $lossInfo = $this->calculateLossFine($waybillBean, $loading_weight, $discharged_weight, $routeWage);

        // in case the discharge is larger than loading
        if ($lossInfo->loss_in_kg < 0) {
            // if the diff is larger than tolerance, throw exception
            $abs_loss_in_kg = -1 * $lossInfo->loss_in_kg;
            if ($abs_loss_in_kg > $lossInfo->tolerance_in_kg) {
                throw new Exception("لا تستطيع المتابعة ، وزن التفريغ أكبر من الحد المسموح");
            }
        }
        // ------------ end the freight amount calculations ----------

        // calculate deductions
        $total_deductions = 0;
        $freight_node->deductions = $this->generateWaybillDeductionsNode(
            $waybill_id,
            $loading_weight_in_TON,
            $discharged_weight_in_TON,
            $base_amount,
            $routeWage,
            $pa_id
        );
        $deductions_array = [];


        foreach ($freight_node->deductions as $d) {
            $deductions_array[] = ['name' => $d['name'], 'value' => $d['value']['amount']];
            if ($d['name'] != "tc_commission") {
                $total_deductions += $d['value']['amount'];
            }
        }


        // ------------ end deductions calculations ----------

        // calculate advance_payments
        $tender_id = $waybillBean->document->tender->id;
        $total_advance_payment = 0;

        if ($tender_id == 11) {
            $jo_petrol_integration = new Jo_Petrol();
            $total_advance_payment = $jo_petrol_integration->getDieselPayment($waybillBean->id, 'DEISIL_PRE_LOAD') +
                $jo_petrol_integration->getDieselPayment($waybillBean->id, 'DEISIL_POST_LOAD');
        }


        $advanced_payments = $waybillBean->document->freight->payments;
        if ($advanced_payments) {
            foreach ($advanced_payments as $adv) {
                if ($tender_id == 11) {
                    if ($adv->name != "DEISIL_PRE_LOAD" && $adv->name != "DEISIL_POST_LOAD" && $adv->name != "WAYBILL_PAYMENT") {
                        $total_advance_payment += $adv->value->amount;
                    }
                } else {
                    if ($adv->name != "WAYBILL_PAYMENT" && $adv->name != "WATANIAH_DEISIL_PRE_LOAD") {
                        $total_advance_payment += $adv->value->amount;
                    }
                }
            }
        }
        // calculate any NEW or Active claims on the truck
        // in this case the waybill is about to be payed to driver
        if ($waybillBean->status != "COMPLETE" && ($pa_id == 57 || $pa_id == 58)) {

            // get the truck_owner_id from tender truck in order to search for its claims
            $MGPAY_tender = $this->_tenderCore->getMgPayTender();
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $MGPAY_tender->id],
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            if ($tenderTruckResult->found_rows > 0) {
                $financial_details = $tenderTruckResult->data[0]->financial_details;
                $financial_details = json_decode($financial_details);
                $payee_reference_value = $financial_details->truck_owner->id;

                $request = new stdClass();
                $request->filter = new stdClass();
                $request->filter->status_in = ["ACTIVE"];
                $request->filter->payee_reference_value = $payee_reference_value;
                $request->filter->payee_reference_code = "TRUCK_OWNER";
                $fps = new FPS();
                $claimsReuslt = $fps->searchClaims($request, 0);
                foreach ($claimsReuslt['data'] as $claim) {
                    $claimAmount =  $fps->getClaimAmount($claim['id'], 0);
                    $total_advance_payment += $claimAmount;
                }
            }
        } else if ($waybillBean->status == "COMPLETE" && ($pa_id == 57 || $pa_id == 58)) {
            foreach ($advanced_payments as $adv) {
                if ($adv->name == "WATANIAH_DEISIL_PRE_LOAD") {
                    $total_advance_payment += $adv->value->amount;
                }
            }

            // foreach ($freight_node->deductions as $deduct) {
            //     if($deduct['name'] == 'عمولة مكتب صرف'){
            //         $total_deductions -= $deduct['value']['amount'];
            //     }
            // }
        }


        // ------------ advanced calculations ----------


        // calculate net_amount
        $waybill_amount = $base_amount - $lossInfo->loss_fine;
        $net_amount = $base_amount - $lossInfo->loss_fine - $total_deductions - $total_advance_payment;
        $net_amount = number_format((float)$net_amount, 3, '.', '');

        // for fuel project , add axial load fine
        if ($tender_id == 12) {
            $axialFine = $this->calculateAxialLoadFine($waybillBean, $gross_weight);
            $net_amount = $net_amount - $axialFine;
            $lossInfo->total_fines += $axialFine;
        }

        // for grains project , calculate late and compensation fine
        $lossInfo->lateFine = 0;
        $compensation = 0;
 
        if ($tender_id == 13) {
            $lateFineObject = $this->calculateLateFine($waybillBean);

            $lateFine = number_format($lateFineObject->percentage * $waybill_amount, 3);

            $lateFineObject->lateFine = $lateFine;
            $net_amount = $net_amount - $lateFine;

            $lossInfo->total_fines += $lateFine;

            $compensation = $this->calculateCompensation($waybillBean);
            $net_amount = $net_amount + $compensation->amount;
        }

        //special case for tender 19 in deductions based on net amount
        if ($tender_id == 19) {
            $cash_box_id = $waybillBean->cash_box_id;
            if ($cash_box_id == "777412-30005") {
                if ($net_amount < 200) {
                    $commision = 3;
                }
                if ($net_amount >= 200) {
                    $commision = 5;
                }

                $total_deductions += $commision;
                $net_amount = $net_amount - $commision;

                $new_deduction = [];
                $new_deduction['id'] = sizeof($freight_node->deductions);
                $new_deduction['name'] = "tc_commission";
                $new_deduction['label'] = "عمولة نقل";
                $new_deduction['value'] = [];
                $new_deduction['value']['amount'] = $commision;
                $deductions_array[] = ['name' => 'tc_commission', 'value' => $commision];
                $freight_node->deductions[] = $new_deduction;
            }
        }

        if ($net_amount < 0) {
            // $msg = "خطأ في احتساب مستحقات المستند $waybillBean->wn
            //         حيث أن قيمة صافي المبلغ ستكون أقل من 0"  . "-" .
            //     "الأساسي=$base_amount , النقص=$lossInfo->loss_fine , اقتطاع=$total_deductions , سلف=$total_advance_payment";
            // if ($tender_id == 12) {
            //     $msg .= " غرامة محورية=" . $axialFine;
            // }
            // throw new Exception($msg);
            $net_amount = 0;
        }

        $locationCore = new LocationCore();
        $destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;
        $destinationBean = $locationCore->getLocationBasic($destination_id, 0);


        // calculate tips
        $tips = $freight_node->amount->tips;
        $tips_remarks = $freight_node->amount->tips_remarks;

        $freight_node->allowed_to_override = [];
        if ($tender_id == 12) {
            $freight_node->allowed_to_override = ["axial_load_fine"];
        } else if ($tender_id == 13) {
            $freight_node->allowed_to_override = ["compensation", "late_fine", "absence_fine"];
        } else if ($tender_id == 17 || $tender_id == 19) {
            $freight_node->allowed_to_override = ["late_fine"];
        }


        // fill freight amounts node
        $freight_node->amount = array(
            // loading & disharge
            "base_amount" => $base_amount,
            "net_amount" => $net_amount,
            "tips" => $tips,
            "tips_remarks" => $tips_remarks,

            // axial load fines
            "axial_load_fine" => $axialFine,

            // late fine
            "late_fine" => $lateFineObject->lateFine,
            "late_fine_hours" => $lateFineObject->diff_in_hours,
            "late_fine_percentage" => $lateFineObject->percentage,
            "other_fines" => new stdClass(),

            // compensation
            "compensation" => $compensation->amount,
            "compensation_price_per_hour" => $compensation->price,
            "compensation_hours" => $compensation->diff_in_hours,

            // loss info
            "loss_fine" => $lossInfo->loss_fine,
            "loss_in_kg" => $lossInfo->loss_in_kg,
            "affected_loss" => $lossInfo->affected_loss,
            "tolerance_in_kg" => round($lossInfo->tolerance_in_kg),
            "loss_fine_per_kg" => $lossInfo->loss_fine_per_kg,
            "minimum_weight" => $lossInfo->minimum_weight,

            //total fines
            "total_fines" => $lossInfo->total_fines,

            // deduction + advance_payments
            "total_deductions" => number_format($total_deductions, 3),
            "total_advance_payment" => $total_advance_payment,
            "deductions" => $deductions_array,

            //other info
            "destination" => $destinationBean->name,
            "destination_id" => $destinationBean->id,
            "loading_weight" => $loading_weight,
            "discharge_weight" => $discharged_weight,
            "wage_per_ton" => $wage_per_ton,
            "route_wage_type" => $routeWage->route_wage_type,
            "route_wage_id" => $routeWage->route_wage_type == "route_wage" ? $routeWage->id : null,
            "pa_route_wage_id" => $routeWage->route_wage_type == "pa_route_wage" ? $routeWage->id : null
        );

        // foreach ($deductions_array as $d) {
        //     $freight_node->amount[$d['name']] = $d['value'];
        // }
        $freight_node->amount = (object) $freight_node->amount;
        return $freight_node;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate Late load fine  ------------------------------------ //
    // ---------------------------------------------------------------------------------- //
    public function calculateTawabe($net_amount, $base_amount, $tender_id)
    {

        $tawabe = null;
        if ($tender_id == 13) {
            $percentage = 0.0015;
            $tawabe = $percentage * $net_amount;
        }

        return ['percentage' => $percentage, 'value' => $tawabe];
    }

    // -------------------------------------------------------------------------------------------- //
    // -------------------- Calculate the loss fine for a certain waybill ------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function calculateLossFine($waybill_id, $loadingWeight = null, $dischargeWeight = null, $routeWage = null)
    {

        // init objects
        $tenderCore = new TenderCore;

        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        // extract info from waybill
        if (!$routeWage) {
            $routeWage = $waybillBean->document->freight->route_wage;
        }
        if (!$loadingWeight) {
            $loadingWeight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
        }
        if (!$dischargeWeight) {
            $dischargeWeight = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
        }

        $loss_fine_per_kg = $routeWage->loss_fine_per_kg;

        // calculate the loss in kg
        $loss_in_kg = $loadingWeight - $dischargeWeight;
        if ($loss_in_kg < 0) {
            $loss_in_kg = 0;
        }

        // calculate loss tolerance in kg
        // extract the tolerance method from route_wage , then cargo , if not exist take from manifest
        try {
            $tolerance_calculation_method = $routeWage->tolerance_calculation_method;
            $tolerance_calculation = [];
            $tolerance_calculation['method'] = $tolerance_calculation_method;
        } catch (Exception $e) {
        }

        try {
            $cargoCore = new CargoCore;
            $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
            $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);
            $tolerance_calculation = $cargoBean->payment_method->tolerance_calculation->method;
        } catch (Exception $e) {
        }

        if ($waybillBean->tender_id) {
            $manifestBean = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
            $tolerance_calculation = $manifestBean['freight']['payment_method']['tolerance_calculation'];
        }


        if ($tolerance_calculation['method'] == "fixed") {
            $tolerance_in_kg = $tolerance_calculation['value'];
            if (!$tolerance_in_kg || $tolerance_in_kg == 0) {
                $tolerance_in_kg = $routeWage->tolerance_percentage;
            }
        } else if ($tolerance_calculation['method']  == "percentage") {
            $tolerance_in_kg = $loadingWeight * $routeWage->tolerance_percentage;
        } else {
            throw new Exception("tolerance calculation method does not exists");
        }

        // calculate the loss fine in case the loss is greater than loss tolerance, deducted from loss_fine_tolerance_kg
        $affected_loss = max($loss_in_kg - floor($tolerance_in_kg), 0);

        // in case the waybill has sea_water and the sea_water_confirmation is false (ماء غير مصاحب),
        // then add the sea_water to the loss_in_kg
        $tender_id = $waybillBean->document->tender->id;
        if ($tender_id == 11) {
            $sea_water = $waybillBean->document->integeration_details->jo_petrol->sea_water;
            $sea_water_confirmation = $waybillBean->document->integeration_details->jo_petrol->sea_water_confirmation;

            if ($sea_water && intval($sea_water) > 0 && !$sea_water_confirmation || ($sea_water_confirmation == "" || $sea_water_confirmation == "0")) {
                $sea_water = substr($sea_water, 0, -3);
                $affected_loss = max($loss_in_kg - $sea_water - floor($tolerance_in_kg), 0);
                $affected_loss += $sea_water;
            }
        }

        $loss_fine = $affected_loss * $loss_fine_per_kg;
        $loss_fine = number_format((float)$loss_fine, 3, '.', '');

        if ($loss_fine < 0) {
            $loss_fine = 0;
        }

        $total_fines = $loss_fine;

        // return result
        $result = new stdClass();
        $result->loading_weight = $loadingWeight;
        $result->discharged_weight = $dischargeWeight;
        $result->loss_fine = $loss_fine;
        $result->tolerance_in_kg = $tolerance_in_kg;
        $result->loss_fine_per_kg = $loss_fine_per_kg;
        $result->affected_loss = $affected_loss;
        $result->loss_in_kg = $loss_in_kg;
        $result->fine_loss_in_kg = $loss_in_kg - $tolerance_in_kg;
        $result->total_fines = $total_fines;
        $result->minimum_weight = $routeWage->minimum_weight;
        return $result;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate compensation     ----------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function calculateCompensation($waybill_id)
    {

        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        $price = 0.83;

        // get time differeance between arrival date and discharge
        $arrival_date = $waybillBean->document->cargo[0]->weights->arrival->time_stamp;
        if ($arrival_date) {

            $discharge_date = $waybillBean->document->cargo[0]->weights->discharge->time_stamp;
            $discharge_date = strtotime($discharge_date);
            $arrival_date = strtotime($arrival_date);
            // diff in hours
            $diff = ($discharge_date - $arrival_date) / (60 * 60);
            $threeshold = 48;
            $amount = 0;
            $lateAfterThreshold = 0;

            if ($diff > $threeshold) {
                $lateAfterThreshold = $diff - $threeshold;
                $amount = $lateAfterThreshold * $price;
            }
        } else {
            $amount = 0;
            $lateAfterThreshold = 0;
        }

        $result = new stdClass();
        $result->amount = $amount;
        $result->price = $price;
        $result->diff_in_hours = $lateAfterThreshold;
        return $result;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate Late load fine  ------------------------------------ //
    // ---------------------------------------------------------------------------------- //
    public function calculateLateFine($waybill_id)
    {

        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        // get time differeance between loading date and arrival_date
        $loading_date = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
        $arrival_date = $waybillBean->document->cargo[0]->weights->arrival->time_stamp;
        $loading_date = strtotime($loading_date);
        $arrival_date = strtotime($arrival_date);
        // diff in hours
        $diff = floor(($arrival_date - $loading_date) / (60 * 60));

        $threeshold = 48;
        $percentage = 0;
        $diff_in_hours = 0;
        if ($diff > $threeshold) {
            $lateAfterThreshold = $diff - $threeshold;
            $diff_in_hours = $lateAfterThreshold;
            
            $formated_loading_date    =  date_create($waybillBean->document->cargo[0]->weights->loading->time_stamp);
            $formated_now_date  = date_create("2022-03-01");
            $LoadingdateDiff = date_diff($formated_loading_date, $formated_now_date);
 
            // in case the loading data < 2022-03-01
            if ($LoadingdateDiff->d > 0 && $LoadingdateDiff->invert == 0) {

                if ($lateAfterThreshold >= 1 &&  $lateAfterThreshold <= 10) {
                    $percentage = 0.03;
                } else if ($lateAfterThreshold >= 11 &&  $lateAfterThreshold <= 20) {
                    $percentage =  0.07;
                } else if ($lateAfterThreshold >= 21 &&  $lateAfterThreshold <= 30) {
                    $percentage =  0.15;
                } else if ($lateAfterThreshold >= 31) {
                    $percentage =  0.35;
                }
            } 
            
            // in case the loading data > 2022-03-01
            else {
                if ($lateAfterThreshold >= 1 &&  $lateAfterThreshold <= 24) {
                    $percentage = 0.03;
                } else if ($lateAfterThreshold >= 25 &&  $lateAfterThreshold <= 35) {
                    $percentage =  0.05;
                } else if ($lateAfterThreshold >= 36 &&  $lateAfterThreshold <= 48) {
                    $percentage =  0.07;
                } else if ($lateAfterThreshold >= 49) {
                    $percentage =  0.15;
                }
            }
        }

        $result = new stdClass();
        $result->percentage = $percentage;
        $result->diff_in_hours = $diff_in_hours;
        return $result;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate Axial load fine ------------------------------------ //
    // ---------------------------------------------------------------------------------- //
    public function calculateAxialLoadFine($waybill_id, $gross_weight = null)
    {
        // init objects
        $tenderCore = new TenderCore;
        $truckCore = new TruckCore;
        $gateWayCore = new GateWayCore;

        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        if (!$gross_weight) {
            $gross_weight = $waybillBean->document->cargo[0]->weights->loading->gross_weight->weight;
        }
        if (!$gross_weight) {
            throw new Exception("لا تستطيع المتابعة ، الوزن القائم غير موجود");
        }

        // get truck and trailer bean
        $truckBean = $truckCore->getTruckBasic($waybillBean->truck_id, 0);
        $trailerBean = $truckCore->getTruckBasic($waybillBean->trailer_id, 0);

        // get the maximum axial weights
        $axial_limits = $gateWayCore->getResource('AXIAL_LIMITS', null);
        $axialLoad = ($trailerBean->axis . "" . $truckBean->axis);
        $maximum_loading_weight = $axial_limits[$axialLoad];

        if (!$maximum_loading_weight) {
            throw new Exception("لا تستطيع المتابعة ، الأحمال المحورية للقاطرة او للمقطورة غير صحيحة");
        }
        $maximum_loading_weight = $maximum_loading_weight * 1000;

        // if the discharge weight is larger than allowed limit , add fine (10 JOD for each extra TON or any part of it)
        $fine = 0;
        if ($gross_weight > $maximum_loading_weight) {
            $fine = ceil(($gross_weight - $maximum_loading_weight) / 1000) * 10;
        }

        return $fine;
    }


    // ------------------------------------------------------------------------------------------------------------------- //
    // ----------------- generate waybill deduction json node, then fill the dynamic calculated fields ------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function generateWaybillDeductionsNode($waybill_id, $loading_weight, $disharge_weight, $base_amount, $routeWage, $pa_id = null)
    {

        // init objects
        $waybillCore = new WaybillCore;

        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }
        $deductions = json_decode($routeWage->deductions, True);

        // caculate each deduction value
        $result = [];
        if ($deductions) {
            foreach ($deductions as $d) {

                if ($waybillBean->tender_id == 17 || $waybillBean->tender_id == 11) {
                    $applyDeduction = false;

                    if (sizeof($d['filter']) == 0) {
                        $applyDeduction = true;
                    }

                    //loop on deduction filter
                    foreach ($d['filter'] as $deductionFilter) {
                        if ($deductionFilter['type'] == "date") {
                            if ($deductionFilter['operation'] == "date between") {

                                $rule = $deductionFilter['rules'][0];
                                $loading_date = new DateTime($waybillBean->document->cargo[0]->weights->loading->time_stamp);
                                $date_from = new DateTime($rule['loading_date_from']);
                                $date_to = new DateTime($rule['loading_date_to']);
                                if ($loading_date >= $date_from && $loading_date < $date_to) {
                                    $applyDeduction = true;
                                } else {
                                    $applyDeduction = false;
                                }
                            } elseif ($deductionFilter['operation'] == "less than") {
                                $loading = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
                                $rule = $deductionFilter['rules'][0]['loading_date'][0];

                                $loading_date = date_create($loading);
                                $rule_date = date_create($rule);
                                $dateDiff = date_diff($loading_date, $rule_date);
                                if ($dateDiff->invert == 0 && ($dateDiff->d > 0 || $dateDiff->m)) {
                                    $applyDeduction = true;
                                }
                            } else if ($deductionFilter['operation'] == "greater than") {
                                $loading = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
                                $rule = $deductionFilter['rules'][0]['loading_date'][0];

                                $loading_date = date_create($loading);
                                $rule_date = date_create($rule);
                                $dateDiff = date_diff($loading_date, $rule_date);

                                // if the target_date is exactly on the limit , apply deduction
                                if ($dateDiff->d == 0 && $dateDiff->m == 0) {
                                    $applyDeduction = true;
                                } else if ($dateDiff->invert > 0) {
                                    $applyDeduction = true;
                                }
                            }
                        } elseif ($deductionFilter['type'] == "location") {
                            foreach ($deductionFilter['rules'] as $rule) {
                                foreach ($rule as $key => $value) {
                                    $locationCore = new LocationCore();
                                    foreach ($value as $v) {
                                        $childLocations = $locationCore->searchChildLocations($v);
                                        foreach ($childLocations as $child) {
                                            if ($waybillBean->$key == $child->id) {
                                                $applyDeduction = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    try {
                        $applyDeduction = true;
                        //loop on deduction filter
                        foreach ($d['filter'] as $deductionFilter) {
                            // if deduction has any filter , check if it match
                            if ($deductionFilter) {
                                //loop on filter rules
                                $applyDeduction = false;
                                foreach ($deductionFilter['rules'] as $rule) {
                                    foreach ($rule as $key => $value) {
                                        foreach ($value as $v) {
                                            // if the rule is location based, get the location herarchy
                                            if ($deductionFilter['type'] == "location") {
                                                $locationCore = new LocationCore();
                                                $childLocations = $locationCore->searchChildLocations($v);
                                                foreach ($childLocations as $child) {
                                                    if ($waybillBean->$key == $child->id) {
                                                        $applyDeduction = true;
                                                    }
                                                }
                                            }
                                            // if the rule is date based
                                            else if ($deductionFilter['type'] == "date") {

                                                $loading = $waybillBean->document->cargo[0]->weights->loading->time_stamp;

                                                if ($deductionFilter['operation'] == "less than") {
                                                    $loading_date = date_create($loading);
                                                    $rule_date = date_create($v);
                                                    $dateDiff = date_diff($loading_date, $rule_date);
                                                    if ($dateDiff->invert == 0 && ($dateDiff->d > 0 || $dateDiff->m)) {
                                                        $applyDeduction = true;
                                                    }
                                                } else if ($deductionFilter['operation'] == "greater than") {
                                                    $loading_date = date_create($loading);
                                                    $rule_date = date_create($v);
                                                    $dateDiff = date_diff($loading_date, $rule_date);

                                                    // if the target_date is exactly on the limit , apply deduction
                                                    if ($dateDiff->d == 0 && $dateDiff->m == 0) {
                                                        $applyDeduction = true;
                                                    } else if ($dateDiff->invert > 0) {
                                                        $applyDeduction = true;
                                                    }
                                                }
                                            }
                                            // if the rule is route wage type
                                            else if ($deductionFilter['type'] == "route_wage_type") {
                                                if ($routeWage->type == $v) {
                                                    $applyDeduction = true;
                                                }
                                            }
                                            // if the filter type is not location based or loading date , try to match exactly
                                            else if ($waybillBean->$key == $v) {
                                                $applyDeduction = true;
                                            }
                                        }

                                        // if one of the condition is not met , skip deduction
                                        if (!$applyDeduction) {
                                            break 3;
                                        }
                                    }
                                }
                            }
                        }
                    } catch (Exception $e) {
                        // do nothing
                    }
                }

                if (!$applyDeduction) {
                    continue;
                }

                $calculation_method = strtoupper($d['value']['method']);
                $d['time_stamp'] = DBConnection::getSystemDate();

                $due_date = strtoupper($d['due_date']);
                if ($due_date) {
                    $due_date = date('Y-m-d', strtotime('+1 month', strtotime(date('Y-m-5'))));
                    $d['due_date'] = $due_date . " " . date("12:00:00.000");
                }

                // Fixed Amount
                if ($calculation_method == 'FIXED') {
                    array_push($result, $d);
                }

                // rate from source
                else if ($calculation_method == 'RATE') {
                    $source = $d['value']['source'];
                    $amount = $d['value']['rate'] * $base_amount;
                    $amount = number_format((float)$amount, 3, '.', '');
                    $d['value']['amount'] = $amount;
                    array_push($result, $d);
                }

                //per ton
                else if ($calculation_method == 'PER_TON') {
                    $amount = $d['value']['amount'] * $disharge_weight;

                    $amount = number_format((float)$amount, 3, '.', '');
                    $d['value']['rate'] = $d['value']['amount'];
                    $d['value']['amount'] = $amount;
                    $d['value']['source'] = "base_amount";
                    array_push($result, $d);
                } else if ($calculation_method == 'PRICE_DIFF') {

                    // amount_1 = route_wage * affective_wight
                    if ($routeWage->effective_weight == "loading_weight") {
                        $amount_1 = $loading_weight * $routeWage->wage_per_ton;
                    }
                    if ($routeWage->effective_weight == "discharge_weight") {
                        $amount_1 = $disharge_weight * $routeWage->wage_per_ton;
                    }

                    // amount_2 = route_wage_without_commision * affective_wight
                    if ($routeWage->effective_weight == "loading_weight") {
                        $amount_2 = $loading_weight * $routeWage->wage_per_ton_without_commision;
                    }
                    if ($routeWage->effective_weight == "discharge_weight") {
                        $amount_2 = $disharge_weight * $routeWage->wage_per_ton_without_commision;
                    }
                    // deduction = amount_1 - amount_2
                    $amount = $amount_1 - $amount_2;
                    $amount = number_format((float)$amount, 3, '.', '');

                    $d['value']['amount_1'] = $amount_1;
                    $d['value']['amount_2'] = $amount_2;
                    $d['value']['amount'] = $amount;
                    $d['value']['source'] = "base_amount";
                    array_push($result, $d);
                }
            }
        }

        // in case the payment agent request the tagreesh, see if it has pa_commission
        if ($pa_id) {
            $paymentAgentCore = new PaymentAgentCore();
            // get tender_pa
            $tenderPaFilter = [
                ['key' => 'pa_id', 'val' => $pa_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_id', 'val' => $waybillBean->tender_id]
            ];
            $tenderPa = $paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];
            if ($tenderPa->pa_commission) {
                $pa_commission = json_decode($tenderPa->pa_commission);
                $pa_commission_deduction = json_decode(json_encode($pa_commission), TRUE);
                array_push($result, $pa_commission_deduction);
            }
        }

        return $result;
    }

    // ------------------------------------------------------------------------------------------------------------------------ //
    // ----------------- Create waybill advanced payment json node, then fill the dynamic calculated fields ------------------- //
    // ------------------------------------------------------------------------------------------------------------------------ //
    public function generateWaybillAdvancePaymentNode($waybill_id)
    {

        // init objects
        $tenderCore = new TenderCore;
        $cargoCore = new CargoCore;
        $waybillCore = new WaybillCore;

        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
        }

        // get list of advance payment in cargo
        $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);
        $advnaced_payment = $cargoBean->waybill_template->negotiable_instructios->freight->advance_payment;
        $advnaced_payment = json_decode(json_encode($advnaced_payment), True);

        // caculate each advance payment value
        $result = [];
        if ($advnaced_payment) {
            foreach ($advnaced_payment as $payment) {

                // see if the waybill has reached the time to add advance payment
                $paymentTrigger = explode(":", $payment['value']['trigger']);
                if ($paymentTrigger[0] == 'WAYBILL') {
                    if ($paymentTrigger[1] == $waybillBean->status) {

                        // start the calculation
                        $payment['time_stamp'] = DBConnection::getSystemDate();
                        $calculation_method = strtoupper($payment['value']['method']);
                        if ($calculation_method == 'FIXED') {
                            array_push($result, $payment);
                        } else if ($calculation_method == 'RATE') {
                            $source = $payment['value']['source'];
                            $amount = $payment['value']['rate'] * $waybillBean->document->freight->amount->$source;
                            $payment['value']['amount'] = $amount;
                            array_push($result, $payment);
                        }
                    }
                }
            }
        }
        return $result;
    }

    // ---------------------------------------------------------------------------------------------- //
    // ----------------- Calculate the discharge info for the operator to confirm ------------------- //
    // ----------------- Param: waybill_id , discharge_weight --------------------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function calculateDischargeFine($waybill_id, $loading_weight, $discharge_weight)
    {

        $loss_info = $this->calculateLossFine($waybill_id, $loading_weight, $discharge_weight);

        // prepare the result object
        $result = new stdClass();
        $result->loading_weight = $loss_info->loading_weight;
        $result->discharge_weight = $loss_info->discharged_weight;
        $result->net_weight = $discharge_weight - $loss_info->loading_weight;
        $result->loss_in_kg = $loss_info->loss_in_kg;
        $result->tolerance_in_kg = $loss_info->tolerance_in_kg;
        $result->total_fines = $loss_info->total_fines;
        $result->fine_loss_in_kg = $loss_info->fine_loss_in_kg;

        // in case the disharge is larger than loading
        if ($loss_info->loss_in_kg < 0) {
            if (abs($loss_info->loss_in_kg) > $loss_info->tolerance_in_kg) {
                throw new Exception('لا تستطيع المتابعة ، وزن التفريغ أكبر من الحد المسموح به');
            } else {
                $result->warning_level = 0;
            }
        } else {
            // in case the discharge is less than loading
            if ($loss_info->total_fines > 0) {
                $result->warning_level = ($loss_info->loss_in_kg / ($loss_info->tolerance_in_kg * 10)) * 100;
                $result->warning_level = number_format((float)$result->warning_level, 2, '.', '');
                if ($result->warning_level > 100) $result->warning_level = 100;
                $result->warning_level = abs(99 - $result->warning_level);   // to invert it
            } else {
                $result->warning_level = 0;
            }
        }
        return $result;
    }

    // ----------------------------------------------------------------------------------- //
    // --------------- Deposite money into main_liability_account MLA -------------------- //
    // --------------- params: target_account_id = user account id or company account id -------- //
    // ----------------------------------------------------------------------------------- //
    public function depositeAssets($amount, $tender_id, $target_account_id, $user_id)
    {
        // init objects
        $accountCore = new AccountCore();
        $trxCore = new TrxCore();
        $userCore = new UserCore();
        $tenderCore = new TenderCore();
        $MAA_account_id = 591000;

        // validate auth only sys_admin user can do this
        if ($user_id != 1 && $user_id != 2) {
            throw new Exception("You are not authorized to do this operation");
        }

        try {
            DBConnection::startTransaction();

            // get the Main Assets Account bean MAA (591000) and the tender bean
            $MAA_bean = $accountCore->getAccountBasic($MAA_account_id, 0);
            $searchFilter = [['key' => 'id', 'val' => $user_id]];
            $tender_bean = $tenderCore->getTenderBasic($tender_id, 0);
            $tenderAccounts = $tenderCore->getTenderAccounts($tender_id);

            // update minimum balance of MAA , decrease it by the amount
            $MAA_bean->minimum_balance -= $amount;
            $accountCore->updateAccount($MAA_bean, $MAA_account_id, 0);

            // trx from MAA => user account
            $from_account = $MAA_account_id;
            $to_account = $target_account_id;
            $remarks = "ايداع بمبلغ $amount دينار";
            $trx_id_1 = $trxCore->insertTrx($from_account, $to_account, $amount, $remarks, null, 0);

            // trx from user account => MLA
            $from_account = $target_account_id;
            $to_account = $tenderAccounts['main_liability_account'];
            $tender_name = $tender_bean->manifest->name;
            $remarks = "مشاركة في مشروع $tender_name بمبلغ $amount دينار";
            $trx_id_2 = $trxCore->insertTrx($from_account, $to_account, $amount, $remarks, null, 0);

            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // ----------------------------------------------------------------------------- //
    // --------------- withdraw money from main_liability_account MLA -------------- //
    // --------------- params: amount, tender_id, user_id -------------------------- //
    // ----------------------------------------------------------------------------- //
    public function withdrawAssets($amount, $tender_id, $target_account_id, $user_id)
    {

        // init objects
        $accountCore = new AccountCore();
        $trxCore = new TrxCore();
        $userCore = new UserCore();
        $tenderCore = new TenderCore();
        $MAA_account_id = 591000;

        // validate auth only sys_admin user can do this
        if ($user_id != 1 && $user_id != 2) {
            throw new Exception("You are not authorized to do this operation");
        }

        try {
            DBConnection::startTransaction();

            // get the Main Assets Account bean MAA (591000) and the tender bean
            $MAA_bean = $accountCore->getAccountBasic($MAA_account_id, 0);
            $searchFilter = [['key' => 'id', 'val' => $user_id]];
            $tender_bean = $tenderCore->getTenderBasic($tender_id, 0);
            $tenderAccounts = $tenderCore->getTenderAccounts($tender_id);

            // trx from  MLA => user account
            $from_account = $tenderAccounts['main_liability_account'];
            $to_account = $target_account_id;
            $tender_name = $tender_bean->manifest->name;
            $remarks = "انسحاب من مشروع $tender_name بمبلغ $amount دينار";
            $trx_id_2 = $trxCore->insertTrx($from_account, $to_account, $amount, $remarks, null, 0);

            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // --------------------------------------------------------------------------------------------------------- //
    // ----------------- deposite amount of money in a certain assets account (like Wallet, Cash) -------------- //
    // ----------------- also this deposite will increase the CAP account of the company ----------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function depositeAssetsBalance($capital_account_bean, $asset_account_bean, $amount, $remarks, $user_id)
    {

        // init objects
        $tagreeshUserId = 0;
        $accountCore = new AccountCore();

        // dont get the account bean if it already passed as params, else get DB bean
        if (gettype($capital_account_bean) == "object") {
            $capital_account_bean = $capital_account_bean;
        } else {
            $capital_account_bean = $accountCore->getAccountBasic($capital_account_bean, $user_id);
        }

        if (gettype($asset_account_bean) == "object") {
            $asset_account_bean = $asset_account_bean;
        } else {
            $asset_account_bean = $accountCore->getAccountBasic($asset_account_bean, $user_id);
        }

        // validate input params
        $jv_date = DBConnection::getSystemDate();
        if (!$amount) {
            throw new Exception("JV amount is undefined");
        }

        //validate if the account bean has CAP
        if ($capital_account_bean->type != "CAP" && $capital_account_bean->type != "AP" && $capital_account_bean->type != "AR") {
            throw new Exception("لا تستطيع المتابعة ، الحساب ليس حساب خصوم أو التزامات");
        }

        // ------------------------------------ JV 1 -------------------------------------------------- //
        // create jv Cr رأسمال , Dr الصندوق                                        --------------TC Ledger
        // -------------------------------------------------------------------------------------------- //
        // prepare trx json
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $capital_account_bean->id . "-" . $capital_account_bean->sub_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "ايداع رصيد - " . $remarks,
        );
        $jv_trx[] = array(
            "account" => $asset_account_bean->id . "-" . $asset_account_bean->sub_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "ايداع رصيد في حساب الصندوق - " . $remarks,
        );
        $jv1_owner_account = $capital_account_bean->id;

        $result1 = $this->addJV($jv1_owner_account, $jv_date, $jv_trx, " ايداع - " . $remarks, $tagreeshUserId);
    }

    // --------------------------------------------------------------------------------------------------------------------- //
    // -------------------- Generate Voucher Trx using tender_voucher_type_view template ----------------------------------- //
    // -------------------- Deprecated ------------------------------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------- //
    public function generateVoucherTrx($tender_id, $voucher_type_code = 'WAYBILL_COMPLETE')
    {

        // get template from tender_voucher_type
        $sql_query = "select CAST(`trx_template` AS CHAR CHARSET UTF8) AS trx_template
                      from tender_voucher_type where tender_id = ? and status='ACTIVE' and voucher_type_code = ?";
        $param = [$tender_id, $voucher_type_code];

        $result = DBConnection::runBindDatabaseQuery($sql_query, $param);
        $template = $result[0]->trx_template;
        if (gettype($template) == "string") {
            $template = json_decode($template);
        }

        return ($template->template);
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // ----------------- withdraw amount of money from a cap account ) ---------------------------------------------------- //
    // ----------------- also this withdraw will decrease certain assets account (like Wallet, Cash ----------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function withdrawAssetsBalance($capital_account_bean, $asset_account_bean, $amount, $remarks, $user_id)
    {

        // init objects
        $tagreeshUserId = 0;
        $accountCore = new AccountCore();

        // dont get the account bean if it already passed as params, else get DB bean
        if (gettype($capital_account_bean) == "object") {
            $capital_account_bean = $capital_account_bean;
        } else {
            $capital_account_bean = $accountCore->getAccountBasic($capital_account_bean, $user_id);
        }

        if (gettype($asset_account_bean) == "object") {
            $asset_account_bean = $asset_account_bean;
        } else {
            $asset_account_bean = $accountCore->getAccountBasic($asset_account_bean, $user_id);
        }

        // validate input params
        $jv_date = DBConnection::getSystemDate();
        if (!$amount) {
            throw new Exception("JV amount is undefined");
        }

        //validate if the account bean has CAP
        if ($capital_account_bean->type != "CAP") {
            throw new Exception("account has no Capital account");
        }

        // ------------------------------------ JV 1 -------------------------------------------------- //
        // create jv Dr رأسمال , Cr الصندوق                                        --------------TC Ledger
        // -------------------------------------------------------------------------------------------- //
        // prepare trx json
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $capital_account_bean->id . "-" . $capital_account_bean->sub_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => " سحب رصيد من حساب رأس المال - " . $remarks,
        );
        $jv_trx[] = array(
            "account" => $asset_account_bean->id . "-" . $asset_account_bean->sub_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => " سحب رصيد من حساب الصندوق - " . $remarks,
        );
        $jv1_owner_account = $capital_account_bean->id;

        $result1 = $this->addJV($jv1_owner_account, $jv_date, $jv_trx, "سحوبات شخصية", $tagreeshUserId);
    }


    // --------------------------------------------------------------------------------------------------------- //
    // ----------------- deposite amount of money in a certain assets account (like Wallet, Cash) -------------- //
    // ----------------- also this deposite will increase the CAP account of the company ----------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function moveBalanceBetweenAccounts($from_account_id, $to_account_id, $amount, $remarks, $user_id)
    {

        // init objects
        $tagreeshUserId = 0;
        $accountCore = new AccountCore();

        // dont get the account bean if it already passed as params, else get DB bean
        if (gettype($from_account_id) == "object") {
            $fromAccountBean = $from_account_id;
        } else {
            $fromAccountBean = $accountCore->getAccountBasic($from_account_id, 0);
        }

        // dont get the account bean if it already passed as params, else get DB bean
        if (gettype($to_account_id) == "object") {
            $toAccountBean = $to_account_id;
        } else {
            $toAccountBean = $accountCore->getAccountBasic($to_account_id, 0);
        }

        // validate input params
        $jv_date = DBConnection::getSystemDate();
        if (!$amount) {
            throw new Exception("JV amount is undefined");
        }

        // ------------------------------------ JV 1 -------------------------------------------------- //
        // create jv Cr رأسمال , Dr الصندوق                                        --------------TC Ledger
        // -------------------------------------------------------------------------------------------- //
        // prepare trx json
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $fromAccountBean->id . "-" . $fromAccountBean->sub_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "قيد تحويل رصيد - " . $remarks,
        );
        $jv_trx[] = array(
            "account" => $toAccountBean->id . "-" . $toAccountBean->sub_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "ايداع رصيد في حساب الصندوق - " . $remarks,
        );
        $jv1_owner_account = $fromAccountBean->id;

        $result1 = $this->addJV($jv1_owner_account, $jv_date, $jv_trx, "تحويل رصيد - " . $remarks, $tagreeshUserId);
    }


    // -------------------------------------------------------------------------------------- //
    // ---------------------- Call Add JV Record -------------------------------------------- //
    //-------------------------------------------------------------------------------------- //
    public function addJV($account_id, $jv_date, $trx_json, $notes, $user_id)
    {

        $trx_json = json_encode($trx_json, JSON_UNESCAPED_UNICODE);
        try {
            $result = DBConnection::call_add_jv($account_id, $jv_date, $trx_json, $notes, $user_id);
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when create new voucher ------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function createVoucherFinancialProcedure($voucher_id, $jv_date = null)
    {

        // prepare cores
        $user_id = 0; // Tagreesh user_id
        $tenderCore = new TenderCore();
        $truckingCompanyCore = new TruckingCompanyCore();
        $voucherCore = new VoucherCore();
        $accountCore = new AccountCore();
        $waybillCore = new WaybillCore();

        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }

        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);

        $jv_owner_account = "590000"; // minagate account

        // determine the consignee_AP_account
        if ($voucherBean->trx_template->ref_code == "WAYBILL_COMPLETE") {
            $waybillBean = $waybillCore->getWaybillBasic($voucherBean->trx_template->ref_id, 0);

            //get the consignee_AP_account from the manifest (حساب مستحقات المشروع)
            $manifestBean = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
            $accounts = $manifestBean['freight']['accounts'];
            foreach ($accounts as $account) {
                if ($account['code'] == "consignee_AP_account") {
                    $consignee_AP_account = $account['account'] . "-" . $account['sub_id'];
                }
            }
        } else if ($voucherBean->trx_template->ref_code == "TIPS") {
            //get the consignee_AP_account from the manifest (حساب مستحقات المشروع)
            $manifestBean = $tenderCore->getTenderManifest(11, 0);
            $accounts = $manifestBean['freight']['accounts'];
            foreach ($accounts as $account) {
                if ($account['code'] == "consignee_AP_account") {
                    $consignee_AP_account = $account['account'] . "-" . $account['sub_id'];
                }
            }
        }

        //get the needed info from the voucher
        $consignee_target_account = $voucherBean->trx_template->target_account;
        $consignee_target_account = str_replace(",", "-", $consignee_target_account);
        $net_amount = $voucherBean->trx_template->payment->value->amount;

        // create the JV
        // C مستحقات المستفيدين , D محفظة المستفيد
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $consignee_AP_account,
            "amount" => $net_amount,
            "op" => "C",
            "notes" => $voucherBean->notes
        );
        $jv_trx[] = array(
            "account" => $consignee_target_account,
            "amount" => $net_amount,
            "op" => "D",
            "notes" => $voucherBean->notes
        );
        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, $voucherBean->notes, 0);

        //TODO
        // Send notification to consignee

        return $jv_id;
    }

    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when complete certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function logARTenderClaimItemTrx($tender_claim_item_id, $approved_tender_claim_item_id, $tender_id)
    {
        try {
            // prepare cores
            $tenderClaimCore = new TenderClaimCore();
            $paymentAgentCore = new PaymentAgentCore();
            $approvedTenderClaimItem = $tenderClaimCore->getTenderClaimItem($approved_tender_claim_item_id, 0);
            $tenderClaimItem = $tenderClaimCore->getTenderClaimItem($tender_claim_item_id, 0);
            $tenderClaimBean = $tenderClaimCore->getTenderClaimBasic($tenderClaimItem->tender_claim_id, 0);
            $tenderPaFilter = [
                ['key' => 'pa_id', 'val' => $tenderClaimBean->pa_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_id', 'val' => $tender_id]
            ];
            $tenderPa = $paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];

            $tenderPaAccounts = json_decode($tenderPa->accounts);
            if (!$tenderPaAccounts) {
                throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
            }
            foreach ($tenderPaAccounts as $acc) {
                if ($acc->AP) {
                    $AP_account = $acc->AP;
                }
            }

            // validate input params
            $jv_date = DBConnection::getSystemDate();
            $jv_owner_account = "500395";
            $expense_account = "500395-60001";
            $revenue_account = "500395-50001";
            $ar_account = "500395-210184";
            $twabe_account = "500395-60002";

            /////////////////// calculation ////////////////////////////////////////////////
            $base_amount = $approvedTenderClaimItem->requested_freight->base_amount;
            $total_fines = $approvedTenderClaimItem->requested_freight->total_fines;
            $net_amount  = $tenderClaimItem->approved_freight->net_amount;
            $tawabe      = $approvedTenderClaimItem->requested_freight->tawabe;
            $compensation = $approvedTenderClaimItem->requested_freight->compensation;

            $company_net_amount = round($base_amount - $total_fines + $compensation, 3);
            $tawabe = round($tawabe, 3);

            $net_amount = round($net_amount, 3);
            //////////////////////////////////////////////////////////////////////////

            $tn = $tenderClaimItem->details->tn;
            $trn = $tenderClaimItem->details->trn;
            $driver_name = $tenderClaimItem->details->driver_name;
            $wn = $tenderClaimItem->details->wn;
            $policy_number = $tenderClaimItem->details->ref_num;

            $jv_trx = [];
            $jv_trx[] = array(
                "account" => $expense_account,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $AP_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $ar_account,
                "amount" =>   round($company_net_amount - $tawabe, 3),
                "op" => "D",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $revenue_account,
                "amount" =>   round($company_net_amount, 3),
                "op" => "C",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $twabe_account,
                "amount" =>   $tawabe,
                "op" => "D",
                "notes" => "قيد طوابع للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );

            $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - السائق $driver_name - المستند $wn - بوليصة $policy_number", 0);
            return $jv_id;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // prepare cores

    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when complete certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function logARVoucherTrx($voucher_id, $check_number = null, $jv_date = null)
    {

        // prepare cores
        $voucherCore = new VoucherCore();
        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);
        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }
        $jv_owner_account = explode("-", $voucherBean->trx_template->target_account)[0];
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $voucherBean->trx_template->target_account,
            "amount" => $voucherBean->trx_template->amount,
            "op" => "D",
            "notes" => "عن أمر صرف رقم $voucher_id - شيك رقم " . $check_number
        );
        $jv_trx[] = array(
            "account" => $voucherBean->trx_template->from_account,
            "amount" => $voucherBean->trx_template->amount,
            "op" => "C",
            "notes" => "عن أمر صرف رقم $voucher_id - شيك رقم " . $check_number
        );
        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, "عن أمر صرف رقم $voucher_id -شيك رقم  $check_number", 0);
        return $jv_id;
    }

    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when complete certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function completeVoucherFinancialProcedure($voucher_id, $jv_date = null)
    {

        // prepare cores
        $user_id = 0; // Tagreesh user_id
        $tenderCore = new TenderCore();
        $truckingCompanyCore = new TruckingCompanyCore();
        $voucherCore = new VoucherCore();
        $accountCore = new AccountCore();

        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);

        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }

        // ------------------------------- Minagate Ledger----------------------------------------------- //
        // create jv Cr مستحقات المستفيد , Dr محفظة المستفيد
        $jv_owner_account = "590000"; // minagate account

        //get the consignee_AP_account from the voucher
        $consignee_AP_account = $voucherBean->trx_template->from_account;
        $consignee_AP_account = str_replace(",", "-", $consignee_AP_account);

        //get the needed info from the voucher
        $consignee_target_account = $voucherBean->trx_template->target_account;
        $consignee_target_account = str_replace(",", "-", $consignee_target_account);

        $net_amount = $voucherBean->trx_template->payment->value->amount;
        if (!$net_amount) {
            $net_amount = $voucherBean->trx_template->payment->value;
        }


        // قبض
        if ($voucherBean->system_code == "payment_voucher") {
            // create the JV
            //  C الامانات , D الصندوق
            $jv_trx = [];
            $jv_trx[] = array(
                "account" => $consignee_AP_account,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => "صرف " . $voucherBean->notes
            );
            $jv_trx[] = array(
                "account" => $consignee_target_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => "صرف " . $voucherBean->notes
            );
        } else {
            // create the JV
            // D مستحقات المستفيدين , C محفظة المستفيد
            $jv_trx = [];
            $jv_trx[] = array(
                "account" => $consignee_AP_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => "صرف " . $voucherBean->notes
            );
            $jv_trx[] = array(
                "account" => $consignee_target_account,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => "صرف " . $voucherBean->notes
            );
        }


        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, "صرف " . $voucherBean->notes, 0);

        //TODO
        // Send notification to consignee

        return $jv_id;
    }

    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when complete certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function logReceiptVoucherTrx($voucher_id, $user_id)
    {

        // prepare cores
        $voucherCore = new VoucherCore();
        $waybillCore = new WaybillCore();

        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);
        // validate input params
        $jv_date = DBConnection::getSystemDate();

        $tender_id = $voucherBean->trx_template->tender_id;


        // ------------------------------- Minagate Ledger----------------------------------------------- //
        // create jv Cr مستحقات المستفيد , Dr محفظة المستفيد
        $jv_owner_account = "590000"; // minagate account
        $service_id = $voucherBean->trx_template->payment->service_id;

        $serviceBean = $waybillCore->getService($service_id, $user_id);
        $net_amount = $voucherBean->trx_template->amount;


        // accounts
        $cash_account = $voucherBean->trx_template->from_account;
        $revenue_account = $serviceBean->account_ids->R_account_id;
        $ap_account_id = $serviceBean->account_ids->AP_account_id;
        $ar_account_id = $serviceBean->account_ids->AR_account_id;
        // create the JV
        // D مستحقات المستفيدين , C محفظة المستفيد
        $jv_trx = [];


        if ($voucherBean->trx_template->voucher_type == 'RECEIPT_VOUCHER' && $voucherBean->trx_template->ref_code == 'WAYBILL_SERVICE') {
            $jv_trx[] = array(
                "account" => $revenue_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => $voucherBean->notes
            );
            $jv_trx[] = array(
                "account" => $cash_account,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => $voucherBean->notes
            );
        } else if ($voucherBean->trx_template->voucher_type == 'CASH_DOWNPAYMENT' && $voucherBean->trx_template->ref_code == 'WAYBILL_SERVICE') {
            $jv_trx[] = array(
                "account" => $cash_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => $voucherBean->notes
            );

            $jv_trx[] = array(
                "account" => $ap_account_id,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => $voucherBean->notes
            );

            $jv_trx[] = array(
                "account" => $ar_account_id,
                "amount" => 1,
                "op" => "D",
                "notes" => $voucherBean->notes
            );

            $jv_trx[] = array(
                "account" => $revenue_account,
                "amount" => 1,
                "op" => "C",
                "notes" => $voucherBean->notes
            );
        }

        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, $voucherBean->notes, $user_id);
        return $jv_id;
    }



    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when complete certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function logServiceVoucherTrx($voucher_id, $user_id)
    {

        // prepare cores
        $voucherCore = new VoucherCore();
        $waybillCore = new WaybillCore();

        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);
        // validate input params
        $jv_date = DBConnection::getSystemDate();


        // ------------------------------- Minagate Ledger----------------------------------------------- //
        $service_id = $voucherBean->trx_template->payment->service_id;

        $serviceBean = $waybillCore->getService($service_id, $user_id);
        if (!$serviceBean) {
            throw new Exception("خدمة غير صحيحة او غير معرفة");
        }


        foreach ($serviceBean->trx_template as $template) {
            if (array_search("*", $template->filter) > -1) {
                $jv_trx = $template->trx_template;
                $jv_owner_account =  $template->leadger_account;
                foreach ($template->trx_template as &$trx) {
                    if ($trx->account == 'USER_INPUT') {
                        if (!$voucherBean->trx_template->payment->cash_box) {
                            throw new Exception("حساب الصندوق مطلوب");
                        } else {
                            $trx->account = $voucherBean->trx_template->payment->cash_box;
                        }
                    }
                    $trx->notes = $voucherBean->notes;
                }
            }
        }


        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, $voucherBean->notes, $user_id);

        return $jv_id;
    }



    // ************************************* Old Methods (might be deleted)***************************************************

    // ----------------------------------- ---------------------------------------------------- //
    // --------------- Apply the financial jv when the complete waybill procuder -------------- //
    // --------------------------------------------------------------------------------------- //
    // public function completeWaybillFinancialProcedure( $waybillBean, $jv_date=null){

    //     // // prepare cores
    //     // $user_id = 0; // Tagreesh user_id
    //     // $tenderCore = new TenderCore();
    //     // $truckingCompanyCore = new TruckingCompanyCore();
    //     // $clearingAgentCore = new ClearingAgentCore();
    //     // $accountCore = new AccountCore();
    //     // $waybillCore = new WaybillCore();

    //     // // validate input params
    //     // if(!$jv_date){
    //     //     $jv_date = DBConnection::getSystemDate();
    //     // }else{
    //     //     // make sure the JV data is not in the future
    //     //     $today    =  date_create(date(DBConnection::getSystemDate()));
    //     //     $jv_date_Date = date_create(date($jv_date));
    //     //     $dateDiff = date_diff($jv_date_Date,$today);
    //     //     if($dateDiff->invert > 0 ){
    //     //         throw new Exception("JV date can not be in the future");
    //     //     }
    //     // }

    //     // try{
    //     //     // ------------------------------------ JV 1 -------------------------------------------------- //
    //     //     // create jv Cr مستحقات المستفيد , Dr محفظة السائق                  -------------- Minagate Ledger
    //     //     // -------------------------------------------------------------------------------------------- //
    //     //     $jv1_owner_account = "590000"; // minagate account

    //     //     //get the consignee_AP_account from the manifest
    //     //     $manifestBean = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
    //     //     $accounts = $manifestBean['freight']['accounts'];
    //     //     foreach ($accounts as $account) {
    //     //         if($account['code'] == "consignee_AP_account"){
    //     //             $consignee_AP_account = $account['account'] . "-" . $account['sub_id'];
    //     //         }
    //     //     }

    //     //     //get the consignee_target_account from the tender_truck
    //     //     $activeTenderTrucks = DBConnection::getActiveStatus('tender_truck');
    //     //     $tenderFilter = [['key'=>'truck_id','val' => $waybillBean->truck_id],
    //     //                     ['key'=>'status', 'val' => $activeTenderTrucks , 'op'=>'in'],
    //     //                     ['key'=>'tender_id','val' => $waybillBean->tender_id]];
    //     //     $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,1, 0,0);
    //     //     $financial_details = $tenderTruck_qry->data[0]->financial_details;
    //     //     if(!$financial_details){
    //     //         throw new Exception("لم يتم تعريف المعلومات المالية للشاحنة");
    //     //     }

    //     //     $consignee_target_account = json_decode($financial_details)->waybill_beneficiary_account;
    //     //     if(!$consignee_target_account){
    //     //         throw new Exception("لا يوجد حساب مستفيد معرف على عقد تشغيل الشاحنة");
    //     //     }
    //     //     $consignee_target_account = $consignee_target_account. "-0";

    //     //     // get the net_amount of waybill
    //     //     $waybill_net_amount = $waybillBean->document->freight->amount->net_amount;

    //     //     // create the JV
    //     //     $jv_trx = [];
    //     //     $jv_trx[] = array("account" => $consignee_AP_account,
    //     //                     "amount" => $waybill_net_amount,
    //     //                     "op" => "C",
    //     //                     "notes" => "مستحقات عن المستند رقم $waybillBean->wn",
    //     //                     );
    //     //     $jv_trx[] = array("account" => $consignee_target_account,
    //     //                     "amount" => $waybill_net_amount,
    //     //                     "op" => "D",
    //     //                     "notes" => " قيد عن مستحقات مستند الشحن رقم $waybillBean->wn",
    //     //                     );

    //     //     $this->addJV($jv1_owner_account, $jv_date, $jv_trx , " $waybillBean->wn مستحقات المستفيد عن  مستند الشحن ", 0);

    //     //     // // ------------------------------------ JV 2 -------------------------------------------------- //
    //     //     // // create jv Dr مطالبات المالك , Cr عوائد النقل                         ---------------  TC ledger
    //     //     // // -------------------------------------------------------------------------------------------- //
    //     //     // // get the ledger account
    //     //     // $tc_id = $waybillBean->document->carrier[0]->tc->id;
    //     //     // $truckingCompanyBean = $truckingCompanyCore->getTruckingCompanyBasic($tc_id,$user_id);

    //     //     // // get the company accounts
    //     //     // $companyAccountsFilter = [['key'=>"company_id",'val' => $truckingCompanyBean->company_id],
    //     //     //                             ['key'=>"status",'val' => 'ACTIVE']
    //     //     //                             ];
    //     //     // $accounts_qry = $accountCore->searchAccount($companyAccountsFilter, 1000, 0, $user_id);

    //     //     // // loop on them to extract accounts
    //     //     // foreach ($accounts_qry->data as $account) {
    //     //     //     if($account->type == "R"){
    //     //     //         $revenue_account = $account->id . "-" . $account->sub_id;
    //     //     //     }
    //     //     //     else if($account->type == "AR"){
    //     //     //         $ca_id = $waybillBean->ca_id;
    //     //     //         $subAccountId = 2 . str_pad($ca_id, 4 , "0" , STR_PAD_LEFT);

    //     //     //         if($account->sub_id == $subAccountId){
    //     //     //             $ar_account = $account->id . "-" . $account->sub_id;
    //     //     //         }
    //     //     //     }
    //     //     //     else if($account->type == "PLC"){
    //     //     //         $jv2_owner_account = $account->id;
    //     //     //     }
    //     //     // }

    //     //     // if(!$ar_account){
    //     //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب مطالبة لمالك البضاعة");
    //     //     // }
    //     //     // if(!$revenue_account){
    //     //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للعوائد لشركة النقل");
    //     //     // }

    //     //     // // prepare trx json
    //     //     // $waybill_base_amount = $waybillBean->document->freight->amount->base_amount;
    //     //     // $jv_trx = [];
    //     //     // $jv_trx[] = array("account" => $ar_account,
    //     //     //                 "amount" => $waybill_base_amount,
    //     //     //                 "op" => "D",
    //     //     //                 "notes" => "مطالبة مالك البضاعة عن المستند رقم $waybillBean->wn",
    //     //     //                 );
    //     //     // $jv_trx[] = array("account" => $revenue_account,
    //     //     //                 "amount" => $waybill_base_amount,
    //     //     //                 "op" => "C",
    //     //     //                 "notes" => "عوائد نقل عن المستند رقم $waybillBean->wn",
    //     //     //                 );

    //     //     // $this->addJV($jv2_owner_account, $jv_date, $jv_trx , "مطالبة مالك البضاعة", $user_id);


    //     //     // // ------------------------------------ JV 3 -------------------------------------------------- //
    //     //     // // create jv Cr مستحقات شركة النقل , Dr تكاليف صرف المستند in               ----- ca(owner) ledger
    //     //     // // -------------------------------------------------------------------------------------------- //
    //     //     // // get the ledger account
    //     //     // $ca_id = $waybillBean->ca_id;
    //     //     // $clearingAgentBean = $clearingAgentCore->getClearingAgentBasic($ca_id,$user_id);

    //     //     // // get the company accounts
    //     //     // $companyAccountsFilter = [['key'=>"company_id",'val' => $clearingAgentBean->company_id],
    //     //     //                             ['key'=>"status",'val' => 'ACTIVE']
    //     //     //                             ];
    //     //     // $ap_account_qry = $accountCore->searchAccount($companyAccountsFilter, 1000, 0, $user_id);

    //     //     // // loop on them to extract accounts
    //     //     // foreach ($ap_account_qry->data as $account) {
    //     //     //     if($account->type == "EX"){
    //     //     //         $expense_account = $account->id . "-" . $account->sub_id;
    //     //     //     }
    //     //     //     else if($account->type == "AP"){
    //     //     //         $subAccountId = 3 . str_pad($tc_id, 4 , "0" , STR_PAD_LEFT);

    //     //     //         if($account->sub_id == $subAccountId){
    //     //     //             $ap_account = $account->id . "-" . $account->sub_id;
    //     //     //         }
    //     //     //     }
    //     //     //     else if($account->type == "PLC"){
    //     //     //         $jv3_owner_account = $account->id;
    //     //     //     }
    //     //     // }

    //     //     // if(!$ap_account){
    //     //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب مستحقات لشركة النقل");
    //     //     // }
    //     //     // if(!$expense_account){
    //     //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للمصاريف في شركة التخليص");
    //     //     // }

    //     //     // // prepare trx json
    //     //     // $waybill_base_amount = $waybillBean->document->freight->amount->base_amount;
    //     //     // $jv_trx3 = [];
    //     //     // $jv_trx3[] = array("account" => $ap_account,
    //     //     //                 "amount" => $waybill_base_amount,
    //     //     //                 "op" => "C",
    //     //     //                 "notes" => "مستحقات شركة النقل عن المستند رقم $waybillBean->wn",
    //     //     //                 );
    //     //     // $jv_trx3[] = array("account" => $expense_account,
    //     //     //                 "amount" => $waybill_base_amount,
    //     //     //                 "op" => "D",
    //     //     //                 "notes" => "تكاليف عن المستند رقم $waybillBean->wn",
    //     //     //                 );
    //     //     // $this->addJV($jv3_owner_account, $jv_date, $jv_trx3 , "مستحقات شركة النقل", $user_id);

    //     //     $wallEntry = new stdClass();
    //     //     $tn = $waybillBean->document->carrier[0]->truck->tn;
    //     //     $trn = $waybillBean->document->carrier[0]->trailer->tn;
    //     //     $wn = $waybillBean->wn;
    //     //     $wallEntry->title = "احتساب المستحقات المالية";
    //     //     $wallEntry->msg = "تم احتساب المستحقات المالية للشاحنة :$tn+$trn - عن المستند رقم : $wn";
    //     //     $waybillCore->informWaybillContactPerson($waybillBean->id,$wallEntry);

    //     // }catch(Exception $e){
    //     //     throw new Exception($e->getMessage());
    //     // }
    // }


    // --------------------------------------------------------------------------------------- //
    // --------------- Apply the financial jv when the complete voucher procuder ------------- //
    // --------------------------------------------------------------------------------------- //
    // public function completeVoucherFinancialProcedure ( $waybillBean, $jv_date=null) {

    //     // // prepare cores
    //     // $user_id = 0; // Tagreesh user_id
    //     // $tenderCore = new TenderCore();
    //     // $truckingCompanyCore = new TruckingCompanyCore();
    //     // $clearingAgentCore = new ClearingAgentCore();
    //     // $accountCore = new AccountCore();
    //     // $paymentAgentCore = new PaymentAgentCore();
    //     // $waybillCore = new WaybillCore;

    //     // $waybillBean = $waybillCore->getWaybillBasic($waybillBean->id , 0);

    //     // // validate input params
    //     // if(!$jv_date){
    //     //     $jv_date = DBConnection::getSystemDate();
    //     // }else{
    //     //     // make sure the JV data is not in the future
    //     //     $today    =  date_create(date(DBConnection::getSystemDate()));
    //     //     $jv_date_Date = date_create(date($jv_date));
    //     //     $dateDiff = date_diff($jv_date_Date,$today);
    //     //     if($dateDiff->invert > 0 ){
    //     //         throw new Exception("JV date can not be in the future");
    //     //     }
    //     // }

    //     // // ------------------------------------ JV 1 -------------------------------------------------- //
    //     // // create jv Dr تكاليف صرف المستند , Cr المحفظة                   ----------- payment agent ledger
    //     // // create jv Dr طالبات شركة النقل , Cr عوائد الصرف                ----------- payment agent ledger
    //     // // -------------------------------------------------------------------------------------------- //

    //     // // get the net_amount of waybill and amount+payment_commision
    //     // $waybill_net_amount = $waybillBean->document->freight->amount->net_amount;

    //     // foreach ($waybillBean->document->freight->deductions as $d) {
    //     //     if($d->name == 'epayment_fees' || $d->name == 'e_payment_fees'){
    //     //         $epayment_fees = $d->value->amount;
    //     //     }
    //     // }
    //     // if(!$epayment_fees){
    //     //     throw new Exception("لا تستطيع المتابعة عمولة الصرف غير معرفة في المستند");
    //     // }
    //     // $waybill_net_amount_with_profit = $waybill_net_amount + $epayment_fees;

    //     // // get the AR account sub_id
    //     // $tc_id = $waybillBean->document->carrier[0]->tc->id;
    //     // $tc_name = $waybillBean->document->carrier[0]->tc->name;
    //     // $ar_sub_id = 2 . str_pad($tc_id, 4 , "0" , STR_PAD_LEFT);

    //     // // get the payment agents accounts
    //     // $paAccountFilter = [['key'=>"company_id",'val' => $waybillBean->document->freight->pa->company_id],
    //     //                     ['key'=>"status",'val' => 'ACTIVE']
    //     //                    ];

    //     // $pa_account_qry = $accountCore->searchAccount($paAccountFilter, 1000, 0, $user_id);

    //     // foreach ($pa_account_qry->data as $account) {
    //     //     if($account->type == "R"){
    //     //         $revinue_account = $account->id . "-" . $account->sub_id;
    //     //     }
    //     //     else if($account->type == "EX"){
    //     //         $expense_account = $account->id . "-" . $account->sub_id;
    //     //     }
    //     //     else if($account->type == "AR"){
    //     //         if($account->sub_id == $ar_sub_id){
    //     //             $ar_account = $account->id . "-" . $account->sub_id;
    //     //         }
    //     //     }
    //     //     else if($account->type == "PLC"){
    //     //         $jv1_owner_account = $account->id;
    //     //     }
    //     // }

    //     // $wallet_account = $waybillBean->document->freight->assets_account_id;
    //     // $wallet_account = str_replace(",","-",$wallet_account);

    //     // // validate needed accounts
    //     // if(!$revinue_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للعوائد لمكتب الصرف");
    //     // }
    //     // if(!$expense_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للتكاليف");
    //     // }
    //     // if(!$ar_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب مطالبة مع شركة $tc_name");
    //     // }
    //     // if(!$wallet_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب محفظة نقدية");
    //     // }

    //     // $jv_trx = [];
    //     // $jv_trx[] = array("account" => $expense_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "D",
    //     //                 "notes" => " تكاليف صرف عن المستند رقم $waybillBean->wn",
    //     //                 );
    //     // $jv_trx[] = array("account" => $wallet_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "C",
    //     //                 "notes" => " صرف نقدي عن المستند رقم $waybillBean->wn",
    //     //                 );
    //     // $jv_trx[] = array("account" => $ar_account,
    //     //                 "amount" => $waybill_net_amount_with_profit,
    //     //                 "op" => "D",
    //     //                 "notes" => " مطالبة شركة النقل عن المستند رقم $waybillBean->wn",
    //     //                 );
    //     // $jv_trx[] = array("account" => $revinue_account,
    //     //                 "amount" => $waybill_net_amount_with_profit,
    //     //                 "op" => "C",
    //     //                 "notes" => " عوائد صرف عن المستند رقم $waybillBean->wn",
    //     //                 );

    //     // $jv1_id = $this->addJV($jv1_owner_account, $jv_date, $jv_trx , "تسديد قيمة المستند رقم $waybillBean->wn", $user_id);
    //     // if(!$jv1_id){
    //     //     throw new Exception("Error Processing Request , jv1_id not exist");
    //     // }

    //     // // ------------------------------------ JV 2 -------------------------------------------------- //
    //     // // create jv Dr مستحقات المستفيد , Cr محفظة السائق                  -------------- Minagate Ledger
    //     // // -------------------------------------------------------------------------------------------- //
    //     // $jv2_owner_account = "590000"; // minagate account

    //     // //get the consignee_AP_account from the manifest
    //     // $manifestBean = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
    //     // $accounts = $manifestBean['freight']['accounts'];
    //     // foreach ($accounts as $account) {
    //     //     if($account['code'] == "consignee_AP_account"){
    //     //         $consignee_AP_account = $account['account'] . "-" . $account['sub_id'];
    //     //     }
    //     // }

    //     // //get the consignee_target_account from the tender_truck
    //     // $activeTenderTrucks = DBConnection::getActiveStatus('tender_truck');
    //     // $tenderFilter = [['key'=>'truck_id','val' => $waybillBean->truck_id],
    //     //                 ['key'=>'status', 'val' => $activeTenderTrucks , 'op'=>'in'],
    //     //                 ['key'=>'tender_id','val' => $waybillBean->tender_id]];
    //     // $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,1, 0,0);
    //     // $financial_details = $tenderTruck_qry->data[0]->financial_details;
    //     // if(!$financial_details){
    //     //     throw new Exception("لم يتم تعريف المعلومات المالية للشاحنة");
    //     // }
    //     // $consignee_target_account = json_decode($financial_details)->waybill_beneficiary_account . "-0";

    //     // // get the net_amount of waybill
    //     // $waybill_net_amount = $waybillBean->document->freight->amount->net_amount;

    //     // if(!$consignee_AP_account){
    //     //     throw new Exception(" لا تستطيع المتابعة ، لا يوجد حساب صرف للمسفيد على المشروع");
    //     // }
    //     // if(!$consignee_target_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للمسفيد من صرف المستند");
    //     // }

    //     // // create the JV
    //     // $jv_trx = [];
    //     // $jv_trx[] = array("account" => $consignee_AP_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "D",
    //     //                 "notes" => "صرف نقدي للمستند رقم $waybillBean->wn",
    //     //                 );
    //     // $jv_trx[] = array("account" => $consignee_target_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "C",
    //     //                 "notes" => "صرف نقدي المستند رقم $waybillBean->wn",
    //     //                 );

    //     // $jv2_id = $this->addJV($jv2_owner_account, $jv_date, $jv_trx , "صرف نقدي عن مستند الشحن رقم $waybillBean->wn ", 0);
    //     // if(!$jv2_id){
    //     //     throw new Exception("Error Processing Request , jv2_id not exist");
    //     // }

    //     // // ------------------------------------ JV 3 -------------------------------------------------- //
    //     // // create jv Cr مستحقات مكتب الصرف , Dr تكاليف صرف المستند         ------- trucking company ledger
    //     // // -------------------------------------------------------------------------------------------- //
    //     // // get the trucking company accounts
    //     // $tc_id = $waybillBean->document->carrier[0]->tc->id;
    //     // $truckingCompanyBean = $truckingCompanyCore->getTruckingCompanyBasic($tc_id,$user_id);

    //     // $tcAccountFilter = [['key'=>"company_id",'val' => $truckingCompanyBean->company_id],
    //     //                     ['key'=>"status",'val' => 'ACTIVE']
    //     //                    ];
    //     // $tc_account_qry = $accountCore->searchAccount($tcAccountFilter, 100, 0, $user_id);

    //     // // get the AP account sub_id
    //     // $paFilter = [['key'=>'company_id','val' => $waybillBean->pa_company_id],
    //     //              ['key'=>'status','val' =>['ACTIVE','NEW'], 'op'=>'in' ]
    //     //             ];
    //     // $pa_qry = $paymentAgentCore->searchPaymentAgents($paFilter, 1, 0, 0);
    //     // $pa_id = $pa_qry->data[0]->id;
    //     // $ap_sub_id = 3 . str_pad($pa_id, 4 , "0" , STR_PAD_LEFT);


    //     // foreach ($tc_account_qry->data as $account) {
    //     //     if($account->type == "EX"){
    //     //         $expense_account = $account->id . "-" . $account->sub_id;
    //     //     }
    //     //     else if($account->type == "AP"){

    //     //         if($account->sub_id == $ap_sub_id){
    //     //             $ap_account = $account->id . "-" . $account->sub_id;
    //     //         }
    //     //     }
    //     //     else if($account->type == "PLC"){
    //     //         $jv3_owner_account = $account->id;
    //     //     }
    //     // }

    //     // if(!$ap_account){
    //     //     throw new Exception(" لا تستطيع المتابعة ، لا يوجد حساب مستحقات لمكتب الصرف عند شركة النقل");
    //     // }
    //     // if(!$expense_account){
    //     //     throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب للمصاريف عند شركة النقل");
    //     // }

    //     // // create the JV
    //     // $jv_trx = [];
    //     // $jv_trx[] = array("account" => $ap_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "C",
    //     //                 "notes" => "صرف نقدي للمستند رقم $waybillBean->wn",
    //     //                 );
    //     // $jv_trx[] = array("account" => $expense_account,
    //     //                 "amount" => $waybill_net_amount,
    //     //                 "op" => "D",
    //     //                 "notes" => "صرف نقدي المستند رقم $waybillBean->wn",
    //     //                 );

    //     // $jv3_id = $this->addJV($jv3_owner_account, $jv_date, $jv_trx , "صرف نقدي عن المستند $waybillBean->wn", 0);
    //     // if(!$jv3_id){
    //     //     throw new Exception("Error Processing Request , jv3_id not exist");
    //     // }

    //     // return $jv2_id;

    // }

    // ------------------------------------------------------------------------------------------------------------- //
    // --------------- pay amount of money to an AP account -------------------------------------------------------- //
    // --------------- this procedure occures when trucking company pay the payment agent its money ---------------- //
    // --------------- or when truck_owner pay the trucking company its money ------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------- //
    public function payAccountPayableProcedure($revinueAccountBean, $apAccountBean, $amount, $remarks, $user_id, $jv_date = null)
    {

        DBConnection::startTransaction();

        $tagreeshUserId = 0;

        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }
        if (!$amount) {
            throw new Exception("JV amount is undefined");
        }

        // ------------------------------------ JV 1 -------------------------------------------------- //
        // create jv Dr مستحقات , Cr النقدية                        ---------------  truck_owner/TC ledger
        // -------------------------------------------------------------------------------------------- //
        // prepare trx json
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $apAccountBean->id . "-" . $apAccountBean->sub_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "تسديد مستحقات " . $remarks,
        );
        $jv_trx[] = array(
            "account" => $revinueAccountBean->id . "-" . $revinueAccountBean->sub_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "تسديد مستحقات " . $remarks,
        );
        $jv1_owner_account = $revinueAccountBean->id;

        $result1 = $this->addJV($jv1_owner_account, $jv_date, $jv_trx, "تسديد مستحقات", $user_id);

        DBConnection::commitTransaction();
    }

    // ------------------------------------------------------------------------------------------------------------- //
    // --------------- pay amount of money to an AR account -------------------------------------------------------- //
    // --------------- this procedure occures when payment agent receive its money from trucking company ----------- //
    // --------------- or when trucking company received its money from truck owner  ------------------------------- //
    // ------------------------------------------------------------------------------------------------------------- //
    public function payAccountReceivableProcedure($revinueAccountBean, $arAccountBean, $amount, $remarks, $user_id, $jv_date = null)
    {

        DBConnection::startTransaction();

        $tagreeshUserId = 0;

        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }
        if (!$amount) {
            throw new Exception("JV amount is undefined");
        }


        // ------------------------------------ JV 1 -------------------------------------------------- //
        // create jv Cr مطالبات , Dr النقدية                                    --------------pa/TC ledger
        // -------------------------------------------------------------------------------------------- //
        // prepare trx json
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $arAccountBean->id . "-" . $arAccountBean->sub_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "تسوية مطالبة " . $remarks,
        );
        $jv_trx[] = array(
            "account" => $revinueAccountBean->id . "-" . $revinueAccountBean->sub_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "تسوية مطالبة " . $remarks,
        );
        $jv1_owner_account = $revinueAccountBean->id;

        $result1 = $this->addJV($jv1_owner_account, $jv_date, $jv_trx, "تسوية مطالبة", $user_id);

        DBConnection::commitTransaction();
    }

    // ---------------------------------------------------------------------------------------------------- //
    // ------------------- Calculate the profit for each share holder for a certain tender  --------------- //
    // ---------------------------------------------------------------------------------------------------- //
    public function calculateProfitShare($tender_id, $snapshot_time)
    {
        // // init objects
        // $accountCore = new AccountCore();

        // // get tender shares
        // $tenderShares = $this->_tenderCore->getTenderShares($tender_id, $snapshot_time );

        // // get the total amount of tender assest
        // $totalAmount = 0;
        // foreach ($tenderShares as $share) {
        //     if($share->amount > 0){
        //         $totalAmount += $share->amount;
        //     }
        // }

        // // get tender commision account
        // $tender_accounts = $this->_tenderCore->getTenderAccounts($tender_id);

        // // get the total profit from tender trx_fees account
        // $trx_fees_account_id = $tender_accounts['fees_account'];
        // $trx_fees_account_bean = $accountCore->getAccountBasic($trx_fees_account_id,0);
        // $total_profit = $trx_fees_account_bean->balance;

        // // calculate perc of each share holder and its profit
        // foreach ($tenderShares as &$share) {
        //     $share->perc = $share->amount/$totalAmount;
        //     $share_holder_profit = round($share->perc * $total_profit,3);
        //     $share->profit = $share_holder_profit;
        //     $share->perc =  round($share->perc*100,3);
        // }

        // return $tenderShares;
    }





    // ******************************* This part is deprecated ********************************************************* //

    // ------------------------------------------------------------------------------------------------------------------ //
    // ------------------ Caclulate the amount of money to be returned to liabilty account then add trx  ---------------- //
    // ------------------ amount = reserved - (sum of all advanced payments) -------------------------------------------- //
    // ------------------ THIS METHOD IS DEPRECATED --------------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------ //
    // public function returnWaybillReserveAmount($waybill_id,$from_account,$to_account , $tender_id){

    //     // init objects
    //     $waybillCore = new WaybillCore;
    //     $trxCore = new TrxCore();
    //     $tenderCore = new TenderCore;

    //     // get the waybill bean
    //     if(gettype($waybill_id) == "object"){
    //         $waybillBean = $waybill_id;
    //     }else{
    //         $waybillBean = $waybillCore->getWaybillBasic($waybill_id,0);
    //     }
    //     // get the tender bean
    //     if(gettype($tender_id) == "object"){
    //         $tenderBean = $tender_id;
    //     }else{
    //         $tenderBean = $tenderCore->getTenderBasic($tender_id,0);
    //     }

    //     // in case the no reserve amount is set in tender
    //     $estemate_waybill_method = $tenderBean->manifest->freight->estimate_waybill_amount->method;
    //     if($estemate_waybill_method == "none"){
    //         return;
    //     }

    //     // the amount must be recorded in the waybill trx node as RESERVE trx
    //     $trx_logs = $waybillBean->document->freight->trx_logs;
    //     foreach ($trx_logs as $trx) {
    //         if(strtoupper($trx->type) == 'RESERVE'){
    //             $reserved_amount = $trx->amount;
    //         }
    //     }
    //     if($reserved_amount == null){
    //         $error_msg = "لا يمكن اتمام العملية ، لا يوجد مبلغ تأمين لمستند الشحن";
    //         throw new Exception($error_msg,555);
    //     }

    //     //then deduct all advance payment from it
    //     $payments = $waybillBean->document->freight->payments;

    //     $deductedValue = 0;
    //     foreach ($payments as $payment) {
    //         $deductedValue += (int)$payment->value->amount;
    //     }

    //     // calculate amount
    //     $amount = $reserved_amount - $deductedValue;
    //     $voucher_id = null;
    //     $trx_id = $trxCore->insertTrx($from_account,$to_account,
    //                                   $amount,
    //                                   ' اعادة مبلغ التأمين (بعد احتساب السلف) عن مستند الشحن رقم ' . $waybillBean->wn . ' - الشاحنة رقم ' . $waybillBean->document->carrier[0]->truck->tn,
    //                                   $voucher_id,0);

    //     // update the waybill document to log the trx
    //     $waybillCore->logTrx($waybillBean->id,$trx_id,'RETURN_RESERVE',$remarks,0);

    //     return $deductedValue;
    // }

    // // ------------------------------------------------------------------------------------------------ //
    // // ----------------- add transaction to reserve amount of money from main account ----------------- //
    // // ------------------ THIS METHOD IS DEPRECATED --------------------------------------------------- //
    // // ------------------------------------------------------------------------------------------------ //
    // public function reserveWaybillAmount($waybill_id, $tender_id){

    //     // init objects
    //     $tenderCore = new TenderCore;
    //     $trxCore = new TrxCore;
    //     $waybillCore = new WaybillCore;

    //     // get the tender bean
    //     if(gettype($tender_id) == "object"){
    //         $tenderBean = $tender_id;
    //     }else{
    //         $tenderBean = $tenderCore->getTenderBasic($tender_id,0);
    //     }

    //     // get the waybillBean
    //     $waybillBean = $waybillCore->getWaybillBasic($waybill_id,0);
    //     $estemate_waybill_method = $tenderBean->manifest->freight->estimate_waybill_amount->method;

    //     try{
    //         if($estemate_waybill_method == 'fixed'){
    //             $estemate_waybill_amount = $tenderBean->manifest->freight->estimate_waybill_amount->value;

    //             // get the accounts
    //             $tender_accounts = $tenderCore->getTenderAccounts($tender_id);
    //             $main_liability_account = $tender_accounts['main_liability_account'];
    //             $reserve_account = $tender_accounts['reserve_account'];

    //             // add the transaction
    //             $trxCore = new TrxCore();
    //             $voucher_id = null;
    //             $trx_id = $trxCore->insertTrx($main_liability_account,$reserve_account,
    //                                           $estemate_waybill_amount,
    //                                           'حجز مبلغ تأمين عن مستند الشحن رقم ' . $waybillBean->wn,
    //                                           $voucher_id ,0);

    //             // update the waybill document to log the trx
    //             $waybillCore->logTrx($waybill_id,$trx_id,'RESERVE',$remarks,0);
    //         }
    //         else if($estemate_waybill_method == 'none'){
    //             // do nothing
    //         }
    //         else{
    //             throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من تحديد طريقة حجز مبلغ التأمين");
    //         }
    //     }catch(Exception $e){
    //         throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من حجز مبلغ التأمين");
    //     }
    //}

    // ------------------------------------------------------------------------------------ //
    // ----------------- pay the payment agent commision ---------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function createPaymentAgentCommision($freight_node, $from_account, $to_acount, $user)
    {

        // // determine the amount of pa commission
        // foreach ($freight_node->deductions as $deduction) {;
        //     if($deduction['name'] == 'pa_fees'){
        //         $pa_commission = $deduction['value']['amount'];
        //     }
        // }

        // // create voucher (if not exist) for payment agent in order to log the revinuee at the end of the month
        // $voucherCore = new VoucherCore();
        // $filter = [['key'=>'to_account','val' => $to_acount],
        //            ['key'=>'status','val' => 'INCOMPLETE']
        //           ];
        // $waybillVouchers = $voucherCore->searchVouchers($filter, 100 , 0 , $user);

        // if($waybillVouchers->found_rows == 0){
        //     $pa_payment = (object) array();
        //     $voucher_id = $voucherCore->createVoucher($from_account, $to_acount, 0,
        //                                             "Cash" ,$pa_payment,null,
        //                                             null, null, 'عمولة صرف');

        //     // change status of new voucher to INCOMPLETE
        //     $voucherCore->changeStatus($voucher_id,'INCOMPLETE',0);
        // }

        // // log the revenuee for the payment agent in the table voucher_item
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ----------------- calculate waybill payment upon completing the waybill ------------------------------------------- //
    // ----------------- direct: the payment voucher is available immediately -------------------------------------------- //
    // ----------------- payment_amount:         $total_amount - $advance_amount + $total_deduction_amount --------------- //
    // ----------------- waybill_payment_amount: $total_amount - $advance_amount - $total_deduction_amount --------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function completeWaybillPayment_direct(
        $waybillBean,
        $payment_amount,
        $waybill_payment_amount,
        $tender_accounts,
        $freight_node,
        $extraFees
    ) {

        // init objects
        $trxCore = new TrxCore();
        $accountCore = new AccountCore();
        $voucherCore = new VoucherCore();
        $notificationCore = new NotificationCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();

        // prepare needed accounts
        $main_liability_account = $tender_accounts['main_liability_account'];
        $payment_account = $tender_accounts['payment_account'];
        $e_payment_account = $tender_accounts['e_payment_account'];
        $consignee_payment_account = $tender_accounts['consignee_payment_account'];

        // insert trx from main_liability_account -> payment_account
        $voucher_id = null;
        $trx_id_1 = $trxCore->insertTrx(
            $main_liability_account,
            $payment_account,
            $payment_amount,
            ' قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn,
            $voucher_id,
            0
        );

        // get the tender_truck object
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $waybillBean->document->tender->id],
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
        if ($tenderTruckResult->found_rows == 0) {
            throw new Exception("لا يوجد عقد تشغيل فعال للشاحنة على المشروع");
        }
        $tenderTruck = $tenderTruckResult->data[0];
        $deductions = $freight_node->deductions;

        if ($extraFees && $extraFees->extra_fees_value > 0) {
            $extraFeeNode = new stdClass();
            $extraFeeNode->id = count($deductions) + 1;
            $extraFeeNode->name = "extra_fee";
            $extraFeeNode->label = $extraFees->extra_fees_note;
            $extraFeeNode->value = new stdClass();
            $extraFeeNode->value->method = "fixed";
            $extraFeeNode->value->amount = $extraFees->extra_fees_value;
            $extraFeeNode->value->rate = NULL;
            $extraFeeNode->filter = [];
            $extraFeeNode->allow_edit = [];
            $extraFeeNode->target_account = $tender_accounts['fines_account'];
            array_push($deductions, $extraFeeNode);

            // deduct the extra fees from total amount
            $waybill_payment_amount -= $extraFees->extra_fees_value;
        }

        // ---------------------------- Fines ------------------------------------------------------- //
        if ($freight_node->amount->loss_fine > 0) {
            $extraFeeNode = new stdClass();
            $extraFeeNode->id = count($deductions) + 1;
            $extraFeeNode->name = "fines_fee";
            $extraFeeNode->label = "غرامة بدل فاقد";
            $extraFeeNode->value = new stdClass();
            $extraFeeNode->value->method = "fixed";
            $extraFeeNode->value->amount = $freight_node->amount->loss_fine;
            $extraFeeNode->value->rate = NULL;
            $extraFeeNode->filter = [];
            $extraFeeNode->allow_edit = [];
            $extraFeeNode->target_account = $tender_accounts['fines_account'];
            array_push($deductions, $extraFeeNode);
        }

        // ---------------------- Deductions ------------------------------- //
        foreach ($deductions as $deduction) {;

            // add the payment to payment section in json
            $payment = (object)$deduction;
            $payment->value = (object)$payment->value;
            $payment->time_stamp = DBConnection::getSystemDate();
            $waybillCore->addWaybillPaymentNode($waybillBean->id, $payment);

            // add trx
            $from_account = $payment_account;
            $to_account =  $deduction->target_account;
            $deduction_label = $deduction->label;
            $deductionAmount = $deduction->value->amount;
            $voucher_id = null;
            $trx_id_2 = $trxCore->insertTrx(
                $from_account,
                $to_account,
                $deductionAmount,
                $deduction_label . '  عن مستند الشحن رقم ' . $waybillBean->wn . " - الشاحنة رقم " . $waybillBean->document->carrier[0]->truck->tn,
                $voucher_id,
                0
            );

            // log the trx in waybill json
            $remarks = "";
            $waybillCore->logTrx($waybillBean->id, $trx_id_2, strtoupper($deduction->name), $remarks, 0);
        }
        $financial_details = json_decode($tenderTruck->financial_details);

        // ---------------------------- Client Payment ----------------------------------------------//
        $payment_channel = 'CASH'; // TODO

        // determine the target_account from the tender_truck
        $target_account = $financial_details->waybill_beneficiary_account;
        if (!$target_account) {
            $target_account = $accountCore->getTruckOwnerAccount($waybillBean->document->carrier[0]->truck_owner->id);
        }
        if (!$target_account) {
            throw new Exception(" لم يتمكن النظام من العثور على حساب المستفيد ");
        }

        // deposite the amount in consignee account
        $remarks =  'قيد مستحقات عن المستند ' . $waybillBean->wn .
            ' - الشاحنة : ' . $waybillBean->document->carrier[0]->truck->tn .
            ' - الحمل : ' . $waybillBean->document->cargo[0]->name .
            ' - السائق : ' . $waybillBean->document->carrier[0]->driver->name .
            ' - البون : ' . $waybillBean->document->notes->bond->id;
        $trx_id_3 = $trxCore->insertTrx(
            $payment_account,
            $target_account,
            $waybill_payment_amount,
            $remarks,
            null,
            0
        );

        // create voucher for this payment
        $value = new stdClass();
        $value->amount = $waybill_payment_amount;
        $clientPayment = (object) array(
            "name" => "WAYBILL_PAYMENT",
            "label" => 'قيد مستحقات',
            "target_account" => $consignee_payment_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "value" => $value
        );
        $voucher_id = $voucherCore->createVoucher(
            $target_account,
            $consignee_payment_account,
            $waybill_payment_amount,
            $payment_channel,
            $clientPayment,
            null,
            'WAYBILL',
            $waybillBean->id,
            $remarks,
            $waybillBean->tender_id
        );

        try {
            //send notification to user
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand(1, 1000);
            $payload->message = 'تم اصدار أمر صرف مستحقات عن مستند الشحن  ' . $waybillBean->wn . " بمبلغ " . $waybill_payment_amount . " دينار";
            $accountFilter = [['key' => "id", 'val' => $target_account], ['key' => "status", 'val' => 'ACTIVE']];
            $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
            $target_account_user_id = $account_qry->data[0]->user_id;
            $notificationCore->sendDataMessage($target_account_user_id, $payload);

            // inform owner of the truck
            $message = "تم اصدار أمر صرف $voucher_id بمبلغ صافي $waybill_payment_amount";
            $truckCore->informTruckOwner($waybillBean->truck_id, $payload->message);
        } catch (Exception $e) {
        }

        return $voucher_id;
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ----------------- calculate waybill payment upon completing the waybill ------------------------------------------- //
    // ----------------- schedule: the payment voucher is created with due_date ------------------------------------------ //
    // ----------------- payment_amount:         $total_amount - $advance_amount + $total_deduction_amount --------------- //
    // ----------------- waybill_payment_amount: $total_amount - $advance_amount - $total_deduction_amount --------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function completeWaybillPayment_schedule($waybillBean, $payment_amount, $waybill_payment_amount, $tender_accounts, $freight_node, $extraFees)
    {

        // init objects
        $trxCore = new TrxCore();
        $accountCore = new AccountCore();
        $voucherCore = new VoucherCore();
        $notificationCore = new NotificationCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();

        // prepare needed accounts
        $main_liability_account = $tender_accounts['main_liability_account'];
        $payment_account = $tender_accounts['payment_account'];
        $e_payment_account = $tender_accounts['e_payment_account'];

        // insert trx from main_liability_account -> payment_account
        $voucher_id = null;
        $trx_id_1 = $trxCore->insertTrx(
            $main_liability_account,
            $payment_account,
            $payment_amount,
            ' قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn,
            $voucher_id,
            0
        );

        // get the tender_truck object
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $waybillBean->document->tender->id],
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
        if ($tenderTruckResult->found_rows == 0) {
            throw new Exception("لا يوجد عقد تشغيل فعال للشاحنة على المشروع");
        }
        $tenderTruck = $tenderTruckResult->data[0];
        $deductions = $freight_node->deductions;
        if ($extraFees) {
            $extraFeeNode = new stdClass();
            $extraFeeNode->id = count($deductions) + 1;
            $extraFeeNode->name = "extra_fee";
            $extraFeeNode->label = $extraFees->extra_fees_note;
            $extraFeeNode->value = new stdClass();
            $extraFeeNode->value->method = "fixed";
            $extraFeeNode->value->amount = $extraFees->extra_fees_value;
            $extraFeeNode->value->rate = NULL;
            $extraFeeNode->filter = [];
            $extraFeeNode->allow_edit = [];
            $extraFeeNode->target_account = $tender_accounts['fees_account'];
            array_push($deductions, $extraFeeNode);
        }

        // ---------------------- Deductions ------------------------------- //
        foreach ($deductions as $deduction) {;

            // add the payment to payment section in json
            $payment = (object)$deduction;
            $payment->value = (object)$payment->value;
            $payment->time_stamp = DBConnection::getSystemDate();
            $waybillCore->addWaybillPaymentNode($waybillBean->id, $payment);

            // add trx
            $from_account = $payment_account;
            $to_account =  $deduction->target_account;
            $deduction_label = $deduction->label;
            $deductionAmount = $deduction->value->amount;

            $voucher_id = null;
            $trx_id_2 = $trxCore->insertTrx(
                $from_account,
                $to_account,
                $deductionAmount,
                $deduction_label . '  عن مستند الشحن رقم ' . $waybillBean->wn . " - الشاحنة رقم " . $waybillBean->document->carrier[0]->truck->tn,
                $voucher_id,
                0
            );

            // log the trx in waybill json
            $remarks = "";
            $waybillCore->logTrx($waybillBean->id, $trx_id_2, strtoupper($deduction->name), $remarks, 0);
        }

        // ----------- Add the schedule deduction fees --------------------------------------- //
        $payment_delay = $waybillBean->document->payment_delay;

        $schedule_fees = $payment_delay->deduction_value;
        $delay_value = $payment_delay->delay;
        $due_date = date("Y-m-d", strtotime("+ " . $delay_value . " day"));
        $due_date = $due_date . " " . date("12:00:00.000");

        if ($schedule_fees > 0) {

            // add the payment to payment section in json
            $payment = new stdClass();
            $payment->name = "بدل صرف مستحقات فوري";
            $payment->label = "بدل صرف مستحقات فوري";
            $payment->value = new stdClass();
            $payment->value->amount = $schedule_fees;
            $payment->time_stamp = DBConnection::getSystemDate();
            $waybillCore->addWaybillPaymentNode($waybillBean->id, $payment);

            // insert trx from main_liability_account -> payment_account
            $voucher_id = null;
            $trx_id_3_a = $trxCore->insertTrx(
                $main_liability_account,
                $payment_account,
                $schedule_fees,
                'بدل صرف مستحقات فوري عن المستند ' . $waybillBean->wn,
                $voucher_id,
                0
            );

            // add trx
            $from_account = $payment_account;
            $to_account =  $e_payment_account;
            $deduction_label = "بدل صرف مستحقات فوري";
            $deductionAmount = $schedule_fees;
            $voucher_id = null;
            $trx_id_3_b = $trxCore->insertTrx(
                $from_account,
                $to_account,
                $deductionAmount,
                $deduction_label . '  عن مستند الشحن رقم ' . $waybillBean->wn . " - الشاحنة رقم " . $waybillBean->document->carrier[0]->truck->tn,
                $voucher_id,
                0
            );

            // log the trx in waybill json
            $remarks = "";
            $waybillCore->logTrx($waybillBean->id, $trx_id_3_b, strtoupper($deduction_label), $remarks, 0);
        }

        // ---------------------------- Client Payment ----------------------------------------------//
        $payment_channel = 'ZAIN_CASH'; // TODO

        // determine the target_account from the tender_truck
        $target_account = $tender_accounts['waybill_beneficiary_account'];
        if (!$target_account) {
            $target_account = $accountCore->getTruckOwnerAccount($waybillBean->document->carrier[0]->truck_owner->id);
        }
        if (!$target_account) {
            throw new Exception(" لم يتمكن النظام من العثور على حساب المستفيد ");
        }

        // create voucher for this payment
        $value = new stdClass();
        $value->amount = $waybill_payment_amount;
        $clientPayment = (object) array(
            "name" => "WAYBILL_PAYMENT",
            "label" => 'قيد مستحقات',
            "target_account" => $target_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "value" => $value
        );

        $remarks =  'قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn .
            ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
            ' - الحمولة : ' . $waybillBean->document->cargo[0]->name;
        $voucher_id = $voucherCore->createVoucher(
            $payment_account,
            $target_account,
            $waybill_payment_amount,
            $payment_channel,
            $clientPayment,
            $due_date,
            'WAYBILL',
            $waybillBean->id,
            $remarks,
            $waybillBean->tender_id
        );

        //send notification to user
        $payload = new stdClass();
        $payload->type = "set_notification";
        $payload->id = rand(1, 1000);
        $payload->message = 'تم اصدار أمر صرف مستحقات عن مستند الشحن  ' . $waybillBean->wn . " بمبلغ " . $waybill_payment_amount . " دينار";
        $accountFilter = [['key' => "id", 'val' => $target_account], ['key' => "status", 'val' => 'ACTIVE']];
        $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
        $target_account_user_id = $account_qry->data[0]->user_id;
        $notificationCore->sendDataMessage($target_account_user_id, $payload);

        // inform owner of the truck
        $message = "تم اصدار أمر صرف $voucher_id بمبلغ صافي $waybill_payment_amount";
        $truckCore->informTruckOwner($waybillBean->truck_id, $payload->message);

        return $voucher_id;
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ----------------- calculate waybill payment upon completing the waybill ------------------------------------------- //
    // ----------------- paymentAgent: the payment is done through payment agents----------------------------------------- //
    // ----------------- payment_amount:         $total_amount - $advance_amount + $total_deduction_amount --------------- //
    // ----------------- waybill_payment_amount: $total_amount - $advance_amount - $total_deduction_amount --------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function completeWaybillPayment_paymentAgent(
        $waybillBean,
        $payment_agent_company_id,
        $payment_amount,
        $waybill_payment_amount,
        $tender_accounts,
        $freight_node,
        $extraFees,
        $man
    ) {

        // init objects
        $trxCore = new TrxCore();
        $accountCore = new AccountCore();
        $voucherCore = new VoucherCore();
        $notificationCore = new NotificationCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();

        // prepare needed accounts
        $main_liability_account = $tender_accounts['main_liability_account'];
        $payment_account = $tender_accounts['payment_account'];
        $e_payment_account = $tender_accounts['e_payment_account'];
        $payment_agent_account = $tender_accounts['payment_agent_account'];

        // get the payment agent account
        $accountFilter = [['key' => "company_id", 'val' => $payment_agent_company_id], ['key' => "status", 'val' => 'ACTIVE']];
        $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
        if ($account_qry->found_rows == 0) {
            throw new Exception(" لم يتمكن النظام من العثور على حساب مكتب الصرف ");
        }
        $payment_agent_account = $account_qry->data[0]->id;
        $payment_agent_name = $account_qry->data[0]->name;

        // pay the payment agent commision
        $this->createPaymentAgentCommision($freight_node, $main_liability_account, $payment_agent_account, 0);

        $deductions = $freight_node->deductions;
        if ($extraFees) {
            $extraFeeNode = new stdClass();
            $extraFeeNode->id = count($deductions) + 1;
            $extraFeeNode->name = "extra_fee";
            $extraFeeNode->label = $extraFees->extra_fees_note;
            $extraFeeNode->value = new stdClass();
            $extraFeeNode->value->method = "fixed";
            $extraFeeNode->value->amount = $extraFees->extra_fees_value;
            $extraFeeNode->value->rate = NULL;
            $extraFeeNode->filter = [];
            $extraFeeNode->allow_edit = [];
            $extraFeeNode->target_account = $tender_accounts['fees_account'];
            array_push($deductions, $extraFeeNode);
        }

        // ---------------------- Deductions ------------------------------- //
        foreach ($deductions as $deduction) {;

            // add the payment to payment section in json
            $payment = (object)$deduction;
            $payment->value = (object)$payment->value;
            $payment->time_stamp = DBConnection::getSystemDate();
            //$this->addWaybillPaymentNode($waybillBean->id,$payment);

            // add trx
            $from_account = $main_liability_account;
            $to_account =  $deduction['target_account'];
            $deduction_label = $deduction['label'];
            $deductionAmount = $deduction['value']['amount'];
            $voucher_id = null;
            $trx_id = $trxCore->insertTrx(
                $from_account,
                $to_account,
                $deductionAmount,
                $deduction_label . '  عن مستند الشحن رقم ' . $waybillBean->wn . " - الشاحنة رقم " . $waybillBean->document->carrier[0]->truck->tn,
                $voucher_id,
                0
            );

            // log the trx in waybill json
            //$this->logTrx($waybillBean->id,$trx_id,strtoupper($deduction['name']),$remarks,0);
        }

        // ----------- Client Payment (Waybill) ----------------------------------------------//
        $accountCore = new AccountCore();
        $waybill_payment_amount = $payment_amount;
        $payment_channel = 'CASH'; // TODO
        $waybill_payment_amount = number_format((float)$waybill_payment_amount, 3, '.', '');

        // determine the target_account from the tender_truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $waybillBean->document->tender->id],
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $tenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);

        $target_account = json_decode($tenderTruck->data[0]->financial_details)->waybill_beneficiary_account;
        if (!$target_account) {
            $target_account = $accountCore->getTruckOwnerAccount($waybillBean->document->carrier[0]->truck_owner->id);
        }
        if (!$target_account) {
            throw new Exception(" لم يتمكن النظام من العثور على حساب المستفيد ");
        }

        // create voucher for this payment
        $voucherCore = new VoucherCore();
        $value = new stdClass();
        $value->amount = $waybill_payment_amount;
        $clientPayment = (object) array(
            "name" => "WAYBILL_PAYMENT",
            "label" => 'قيد مستحقات',
            "target_account" => $target_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "value" => $value
        );

        $remarks =  'قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn .
            ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
            ' - الحمولة : ' . $waybillBean->document->cargo[0]->name .
            ' - القيمة : ' . $waybill_payment_amount;
        $voucher_id = $voucherCore->createVoucher(
            $payment_agent_account,
            $target_account,
            $waybill_payment_amount,
            $payment_channel,
            $clientPayment,
            null,
            'WAYBILL',
            $waybillBean->id,
            $remarks,
            $waybillBean->tender_id
        );


        //send notification to user
        $notificationCore = new NotificationCore();
        $payload = new stdClass();
        $payload->type = "set_notification";
        $payload->id = rand(1, 1000);
        $payload->message = 'تم اصدار أمر صرف مستحقات عن مستند الشحن  ' . $waybillBean->wn . " بمبلغ " . $waybill_payment_amount . " دينار";
        $accountFilter = [['key' => "id", 'val' => $target_account], ['key' => "status", 'val' => 'ACTIVE']];
        $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
        $target_account_user_id = $account_qry->data[0]->user_id;
        $notificationCore->sendDataMessage($target_account_user_id, $payload);

        // creater schedule voucher for payment_agent with due date after x days
        $duration = $man['dueDate'] + 1;
        $due_date = date("Y-m-d", strtotime("+ " . $duration . " day"));
        $due_date = $due_date . " " . date("12:00:00.000");
        $remarks =  'قيد تعويض مستحقات عن مستند الشحن رقم ' . $waybillBean->wn . ' يدفع لأمر مكتب الصرف: ' . $payment_agent_name;
        $PaPayment = (object) array(
            "name" => "PA_PAYMENT",
            "label" => 'قيد تعويض مستحقات',
            "target_account" => $payment_agent_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "due_date" => $due_date,
            "value" => $value
        );

        $voucher_id = $voucherCore->createVoucher(
            $main_liability_account,
            $payment_agent_account,
            $waybill_payment_amount,
            "CASH",
            $PaPayment,
            $due_date,
            'WAYBILL',
            $waybillBean->id,
            $remarks,
            $waybillBean->tender_id
        );

        // inform owner of the truck
        if ($man['INFORM_OWNER_BY_SMS'] && $man['INFORM_OWNER_BY_SMS'] == "true") {
            $message = "تم اصدار أمر صرف $voucher_id بمبلغ صافي $waybill_payment_amount" . " دينار";
            $this->_truckCore->informTruckOwner($waybillBean->truck_id, $message);
        }
        return $voucher_id;
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ----------------- calculate waybill payment upon completing the waybill ------------------------------------------- //
    // ----------------- paymentAgent: the payment is done by trucking company directly ---------------------------------- //
    // ----------------- payment_amount:         $total_amount - $advance_amount + $total_deduction_amount --------------- //
    // ----------------- waybill_payment_amount: $total_amount - $advance_amount - $total_deduction_amount --------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function completeWaybillPayment_tc($waybillBean, $payment_amount, $waybill_payment_amount, $tender_accounts, $freight_node, $extraFees)
    {

        // init objects
        $trxCore = new TrxCore();
        $accountCore = new AccountCore();
        $voucherCore = new VoucherCore();
        $notificationCore = new NotificationCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();

        // prepare needed accounts
        $main_liability_account = $tender_accounts['main_liability_account'];
        $payment_account = $tender_accounts['payment_account'];
        $e_payment_account = $tender_accounts['e_payment_account'];

        // trx from main_liability_account -> payment_account
        $voucher_id = null;
        $trx_id2 = $trxCore->insertTrx(
            $main_liability_account,
            $payment_account,
            $payment_amount,
            ' قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn,
            $voucher_id,
            0
        );

        // ----------- Client Payment (Waybill) ----------------------------------------------//
        $waybill_payment_amount = $payment_amount;
        $payment_channel = 'CASH';
        $waybill_payment_amount = number_format((float)$waybill_payment_amount, 3, '.', '');

        // determine the target_account from the tender_truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $waybillBean->document->tender->id],
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $tenderTruck = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
        $target_account = json_decode($tenderTruck->data[0]->financial_details)->waybill_beneficiary_account;
        if (!$target_account) {
            $target_account = $accountCore->getTruckOwnerAccount($waybillBean->document->carrier[0]->truck_owner->id);
        }
        if (!$target_account) {
            throw new Exception(" لم يتمكن النظام من العثور على حساب المستفيد ");
        }

        // create voucher for this payment
        $value = new stdClass();
        $value->amount = $waybill_payment_amount;
        $clientPayment = (object) array(
            "name" => "WAYBILL_PAYMENT",
            "label" => 'قيد مستحقات',
            "target_account" => $target_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "value" => $value
        );

        $remarks =  'قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn .
            ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
            ' - الحمولة : ' . $waybillBean->document->cargo[0]->name .
            ' - القيمة : ' . $waybill_payment_amount;
        $voucher_id = $voucherCore->createVoucher(
            $payment_account,
            $target_account,
            $waybill_payment_amount,
            $payment_channel,
            $clientPayment,
            null,
            'WAYBILL',
            $waybillBean->id,
            $remarks,
            $waybillBean->tender_id
        );

        return $voucher_id;
    }



    // -------------------------------------------------------------------------------------------------------- //
    // --------------------------------- WAYBILL DRAFT -------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------- //

    // ------------------------------------------------------------------------------------------ //
    // ----------------- Log trx when user process advance payment voucher ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function logWaybillAdvancePaymentTrx(
        $amount,
        $ledger_account_id,
        $cash_account_id,
        $notes,
        $user_id
    ) {
        // init objects
        $accountCore = new AccountCore();
        // get expense account id
        $companyAccountsFilter = [
            ['key' => "id", 'val' => $ledger_account_id],
            ['key' => "status", 'val' => 'ACTIVE'],
            ['key' => 'type', 'val' => 'EX']
        ];
        $expense_account_qry = $accountCore->searchAccount($companyAccountsFilter, 1, 0, 0);
        //$expense_account_id = $expense_account_qry->data[0]->id . '-' . $expense_account_qry->data[0]->sub_id;
        $advance_payment_ar_account_id = "777412-19902";
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $cash_account_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => $notes
        );
        $jv_trx[] = array(
            "account" => $advance_payment_ar_account_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => $notes
        );
        $jv_date = DBConnection::getSystemDate();
        $result1 = $this->addJV($ledger_account_id, $jv_date, $jv_trx, $notes, $user_id);

        return $result1;
    }


    // ------------------------------------------------------------------------------------------ //
    // ----------------- Log trx when user process waybill payment voucher ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function logWaybillCompletePaymentTrx(
        $amount,
        $adv,
        $deduction,
        $ledger_account_id,
        $cash_account_id,
        $claim_account_id,
        $jv_date,
        $remarks,
        $user_id
    ) {

        // init objects
        $accountCore = new AccountCore();

        // get expense account id
        $expenseAccountsFilter = [
            ['key' => "id", 'val' => $ledger_account_id],
            ['key' => "status", 'val' => 'ACTIVE'],
            ['key' => 'type', 'val' => 'EX']
        ];
        $expense_account_qry = $accountCore->searchAccount($expenseAccountsFilter, 1, 0, $user_id);
        $expense_account_id = $expense_account_qry->data[0]->id . '-' . $expense_account_qry->data[0]->sub_id;
        $expense_account_id = "777412-60001";

        // get revinue account id
        $revinueAccountsFilter = [
            ['key' => "id", 'val' => $ledger_account_id],
            ['key' => "status", 'val' => 'ACTIVE'],
            ['key' => 'type', 'val' => 'R']
        ];
        $revinue_account_qry = $accountCore->searchAccount($revinueAccountsFilter, 1, 0, $user_id);
        $revinue_account_id = $revinue_account_qry->data[0]->id . '-' . $revinue_account_qry->data[0]->sub_id;

        // get advance AR
        $advance_payment_ar_account_id = "777412-19902";

        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $cash_account_id,
            "amount" => $amount - $adv - $deduction,
            "op" => "C",
            "notes" => "صرف مستحقات عن " . $remarks
        );
        if ($adv > 0) {
            $jv_trx[] = array(
                "account" => $advance_payment_ar_account_id,
                "amount" => $adv,
                "op" => "C",
                "notes" => "سلفة شخصية عن " . $remarks
            );
        }
        $jv_trx[] = array(
            "account" => $expense_account_id,
            "amount" => $amount - $deduction,
            "op" => "D",
            "notes" => "صرف مستحقات عن " . $remarks
        );
        $jv_trx[] = array(
            "account" => $claim_account_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "مطالبة عن " . $remarks
        );
        $jv_trx[] = array(
            "account" => $revinue_account_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "ايرادات عن " . $remarks
        );

        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        }

        $result1 = $this->addJV($ledger_account_id, $jv_date, $jv_trx, $remarks, $user_id);
        return $result1;
    }


    // ------------------------------------------------------------------------------------------ //
    // ----------------- Log trx when user process waybill payment voucher ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function logInjazWaybillCompletePaymentTrx(
        $amount,
        $ledger_account_id,
        $ap_account_id,
        $cash_account_id,
        $claim_account_id,
        $revinue_account_id,
        $jv_date,
        $remarks,
        $user_id
    ) {

        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $cash_account_id,
            "amount" => $amount,
            "op" => "C",
            "notes" => "صرف مستحقات عن " . $remarks
        );
        $jv_trx[] = array(
            "account" => $ap_account_id,
            "amount" => $amount,
            "op" => "D",
            "notes" => "صرف مستحقات عن " . $remarks
        );

        $jv_trx[] = array(
            "account" => $claim_account_id,
            "amount" => 1,
            "op" => "D",
            "notes" => "مطالبة عن " . $remarks
        );
        $jv_trx[] = array(
            "account" => $revinue_account_id,
            "amount" => 1,
            "op" => "C",
            "notes" => "ايرادات عن " . $remarks
        );

        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        }

        $result1 = $this->addJV($ledger_account_id, $jv_date, $jv_trx, $remarks, $user_id);
        return $result1;
    }


    //-------------------------------------------------------------------------//
    //--------------------------- Get trx for certain jv ----------------------//
    //-------------------------------------------------------------------------//
    public function getJvTrx($jv_id, $sub_id = null)
    {

        $query = "SELECT
                    id,
                    id as trx_id,
                    account_id,
                    sub_id,
                    amount,
                    op,
                    current_balance ,
                    notes
                FROM
                    jv_trx
                    WHERE
                  jv_id = ?";
        $param = [$jv_id];
        if ($sub_id) {
            $query .= " and sub_id in ($sub_id)";
        }

        // return  $param;
        $trxResult = DBConnection::runBindDatabaseQuery($query, $param);

        return $trxResult;
    }


    // ------------------------------------------------------------------------------------------ //
    // ----------------- Log trx when user process waybill payment voucher ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function logCompleteVoucherTrx(
        $net_amount,
        $base_amount,
        $advanced_payment,
        $deduction,
        $fines,
        $ledger_account_id,
        $cash_account_id,
        $claim_account_id,
        $jv_date,
        $remarks,
        $tender_id,
        $user_id
    ) {

        $jv_trx = [];
        switch ($tender_id) {
            case "19":
                // get revinue account id
                $revinue_account_id = "777412-50002";
                // get advance AR
                $advance_payment_ar_account_id = "777412-19902";
                // get expense account id
                $expense_account_id = "777412-60003";
                break;

            case "17":
                // get expense account id
                $expense_account_id = "777412-60001";
                // get revinue account id
                $revinue_account_id = "777412-50001";
                // get advance AR
                $advance_payment_ar_account_id = "777412-19902";
                break;
        }

        // default value for payment commision
        $payment_commission = 0;
        $additional_revinue = 0;

        // if account is ذمة مكتب صرف طريق الحرير - العقبة
        if ($cash_account_id == "777412-30005") {
            if ($net_amount < 200) {
                $payment_commission = 1.5;
                $additional_revinue = 1.5;
            } else {
                $payment_commission = 3.5;
                $additional_revinue = 1.5;
            }
        }

        $jv_trx[] = $this->createTrxNode($cash_account_id, $net_amount + $payment_commission, "C", "صرف مستحقات عن " . $remarks);
        if ($advanced_payment > 0) {
            $jv_trx[] = $this->createTrxNode($advance_payment_ar_account_id, $advanced_payment, "C", "سلف شخصية عن " . $remarks);
        }
        $jv_trx[] = $this->createTrxNode($expense_account_id, $net_amount + $payment_commission + $advanced_payment, "D", "صرف مستحقات عن " . $remarks);
        $jv_trx[] = $this->createTrxNode($claim_account_id, $base_amount, "D", "مطالبة عن " . $remarks);
        $jv_trx[] = $this->createTrxNode($revinue_account_id, $base_amount, "C", "ايرادات عن " . $remarks);

        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        }

        $result1 = $this->addJV($ledger_account_id, $jv_date, $jv_trx, $remarks, $user_id);
        return $result1;
    }

    // ------------------------------------------------------------------------------------------ //
    // ----------------- create Trx node -------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function createTrxNode($account, $amount, $op, $notes)
    {
        return  array(
            "account" => $account,
            "amount" => $amount,
            "op" => $op,
            "notes" => $notes
        );
    }


    // ------------------------------------------------------------------------------------------------------------ //
    // ----------------- Log trx when Minagate payment agent approved claim from another pa  ---------------------- //
    // ------------------------------------------------------------------------------------------------------------ //
    public function logPaClaimItemTrx(
        $item_id,
        $tender_id
    ) {

        // Minagate Ledger account id
        $ledger_account_id = '590000';

        ///////////////////////////////////////////
        $tenderClaimCore = new TenderClaimCore();
        $paymentAgentCore = new PaymentAgentCore();
        $tenderClaimItem = $tenderClaimCore->getTenderClaimItem($item_id, 0);
        $tenderClaimBean = $tenderClaimCore->getTenderClaimBasic($tenderClaimItem->tender_claim_id, 0);
        $tenderPaFilter = [
            ['key' => 'pa_id', 'val' => $tenderClaimBean->pa_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderPa = $paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];

        $tenderPaAccounts = json_decode($tenderPa->accounts);
        if (!$tenderPaAccounts) {
            throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
        }
        foreach ($tenderPaAccounts as $acc) {
            if ($acc->AP) {
                $acr = explode("-", $acc->AP);
                if ($acr[0] == $ledger_account_id) {
                    $AP_account = $acc->AP;
                }
            }
        }

        if (!$AP_account) {
            throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
        }

        $freight = $tenderClaimItem->approved_freight;

        $net_amount = $freight->net_amount;
        $tender_payable_commission = floatval($tenderClaimCore->getTenderPayableCommissionAmount($tenderClaimItem->details->tender_payable_id, $tenderClaimBean->pa_id));
        $revenue_account = "590000-50007";
        $ar_account = "590000-25005";
        $remarks = "صرف مستحقات عن مستند رقم" . $tenderClaimItem->details->wn . " - شاحنة رقم " . $tenderClaimItem->details->tn . " - بوليصة رقم " . $tenderClaimItem->details->ref_num;

        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $ar_account,
            "amount" => $net_amount,
            "op" => "D",
            "notes" =>  $remarks
        );
        $jv_trx[] = array(
            "account" => $AP_account,
            "amount" => $net_amount - $tender_payable_commission,
            "op" => "C",
            "notes" =>  $remarks
        );

        $jv_trx[] = array(
            "account" => $revenue_account,
            "amount" => $tender_payable_commission,
            "op" => "C",
            "notes" => $remarks
        );

        $jv_date = DBConnection::getSystemDate();
        $result1 = $this->addJV($ledger_account_id, $jv_date, $jv_trx, $remarks, 0);
        return $result1;
    }

    // ----------------------------------------------------------------------------------------------------- //
    // ----------------- Log trx when trucking company approves claim item on vessels ---------------------- //
    // ----------------------------------------------------------------------------------------------------- //
    public function logARTenderClaimItemTrxForVessels(
        $item_id,
        $tender_id
    ) {
        try {

            // Minagate Ledger account id
            $ledger_account_id = '500395';

            // prepare cores
            $tenderClaimCore = new TenderClaimCore();
            $paymentAgentCore = new PaymentAgentCore();
            $tenderClaimItem = $tenderClaimCore->getTenderClaimItem($item_id, 0);
            $tenderClaimBean = $tenderClaimCore->getTenderClaimBasic($tenderClaimItem->tender_claim_id, 0);
            $tenderPaFilter = [
                ['key' => 'pa_id', 'val' => $tenderClaimBean->pa_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_id', 'val' => $tender_id]
            ];
            $tenderPa = $paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];

            $tenderPaAccounts = json_decode($tenderPa->accounts);
            if (!$tenderPaAccounts) {
                throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
            }

            foreach ($tenderPaAccounts as $acc) {
                if ($acc->AP) {
                    $acr = explode("-", $acc->AP);
                    if ($acr[0] == $ledger_account_id) {
                        $AP_account = $acc->AP;
                    }
                }
            }

            if (!$AP_account) {
                throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
            }

            // validate input params
            $jv_date = DBConnection::getSystemDate();
            $jv_owner_account = "500395";
            $expense_account = "500395-60003";
            $revenue_account = "500395-50004";
            $ar_account = "500395-210186";


            /////////////////// calculation ////////////////////////////////////////////////
            $net_amount  = $tenderClaimItem->approved_freight->net_amount;
            $commission   = $tenderClaimCore->getTenderPayableCommissionAmount($tenderClaimItem->details->tender_payable_id, $tenderClaimBean->pa_id);
            $commission  = round($commission, 3);
            $net_amount = round($net_amount, 3);
            //////////////////////////////////////////////////////////////////////////

            $tn = $tenderClaimItem->details->tn;
            $trn = $tenderClaimItem->details->trn;
            $driver_name = $tenderClaimItem->details->driver_name;
            $wn = $tenderClaimItem->details->wn;
            $policy_number = $tenderClaimItem->details->ref_num;

            $jv_trx = [];
            $jv_trx[] = array(
                "account" => $expense_account,
                "amount" => $net_amount,
                "op" => "D",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $AP_account,
                "amount" => $net_amount,
                "op" => "C",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $ar_account,
                "amount" =>   round($net_amount + $commission, 3),
                "op" => "D",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );
            $jv_trx[] = array(
                "account" => $revenue_account,
                "amount" =>  round($net_amount + $commission, 3),
                "op" => "C",
                "notes" => "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - المستند $wn - بوليصة $policy_number"
            );

            $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, "قيد صرف مستحقات للشاحنة $tn - المقطورة $trn - السائق $driver_name - المستند $wn - بوليصة $policy_number", 0);
            return $jv_id;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function fixDieselCardBalance($tn, $skip_fix_card_balance, $user_id)
    {

        $jo_petrol_integration = new Jo_Petrol();
        $waybillCore = new WaybillCore();

        // get all the waybills on tender_id = 11 and not revoked or Inactive
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => 11],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
            ['key' => 'tn', 'val' => $tn]
        ];
        $waybillResult = $waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);

        // loop on each waybill
        $total_diesel_amount = 0;
        foreach ($waybillResult->data as $wbl) {

            // calculate diesel amount of each waybill
            $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            $total_diesel_amount += doubleval($diesel_amount);
        }

        // get card balance and fix it
        if (!$skip_fix_card_balance) {
            $cardBalance = $jo_petrol_integration->checkCardBalance($tn);
            $cardBalance = doubleval($cardBalance['currentLimit']);
            $total_diesel_amount = doubleval($total_diesel_amount);

            if (abs($cardBalance - $total_diesel_amount) < 5) {
                throw new Exception("الشاحنة لديها رصيد كامل من الديزل");
            }

            // if the user has balance more than the correct , then remove from balance
            if ($cardBalance > $total_diesel_amount) {
                $charge_amount = -1 * ($cardBalance - $total_diesel_amount);
            }

            // if the user has less amount than the correct, add balance
            else {
                $charge_amount = $total_diesel_amount - $cardBalance;
            }

            // charge diesel card on jo petrol system
            $jo_petrol_integration->transferDeisil($tn, $charge_amount);
        }

        // start fixing waybill document if it needs a fix
        foreach ($waybillResult->data as $wbl) {
            $doc = json_decode($wbl->document);
            $freight = $doc->freight;
            $payments = $freight->payments;
            $fixed_amount = 0;

            //look for DEISIL_PRE_LOAD node and DEISIL_POST_LOAD node
            $found_pre_node = false;
            $found_post_node = false;
            foreach ($payments as &$p) {
                if ($p->name == 'DEISIL_PRE_LOAD') {
                    $found_pre_node = true;
                    $p->value = new stdClass();
                    $p->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
                    if (!$p->time_stamp) {
                        $p->time_stamp = DBConnection::getSystemDate();
                    }
                    unset($p->status);
                    $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
                }
                if ($p->name == 'DEISIL_POST_LOAD') {
                    $found_post_node = true;
                    $p->value = new stdClass();
                    $p->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
                    if (!$p->time_stamp) {
                        $p->time_stamp = DBConnection::getSystemDate();
                    }
                    unset($p->status);
                    $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
                }
            }
            $doc->freight = $freight;
            $wbl->document = $doc;
            $waybillCore->updateWaybill($wbl, $wbl->id, 0);

            // create pre and post node is case does not exist
            if (!$found_pre_node) {
                $newPayment = new stdClass();
                $newPayment->label = "DEISIL_PRE_LOAD";
                $newPayment->name = "DEISIL_PRE_LOAD";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
                $newPayment->time_stamp = DBConnection::getSystemDate();
                $waybillCore->addWaybillPaymentNode($wbl->id, $newPayment);
                $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
            }
            // create pre and post node is case does not exist
            if (!$found_post_node) {
                $newPayment = new stdClass();
                $newPayment->label = "DEISIL_POST_LOAD";
                $newPayment->name = "DEISIL_POST_LOAD";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
                $newPayment->time_stamp = DBConnection::getSystemDate();
                $waybillCore->addWaybillPaymentNode($wbl->id, $newPayment);
                $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            }


            // calculate diesel amount of each waybill
            $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            $correct_diesel_amount = doubleval($diesel_amount);

            if ($fixed_amount > $correct_diesel_amount) {
                $amount_to_log = $fixed_amount - $total_diesel_amount;

                $waybillCore->logActivity(
                    $wbl->id,
                    "شحن بطاقة الديزل",
                    "تم اصلاح رصيد بطاقة الديزل واضافة مبلغ:  " . $amount_to_log . " دينار ",
                    "check",
                    0
                );
            } else if ($fixed_amount < $correct_diesel_amount) {

                $amount_to_log = $correct_diesel_amount - $fixed_amount;
                $waybillCore->logActivity(
                    $wbl->id,
                    "سحب رصيد من بطاقة الديزل",
                    "تم اصلاح رصيد بطاقة الديزل وسحب مبلغ:  " . $amount_to_log . " دينار ",
                    "check",
                    0
                );
            }
        }
    }


    // --------------------------------------------------------------------------------------------- //
    // ------------------- Financial actions when ca certain voucher ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function completeDownPaymentVoucherProcedure($voucher_id, $jv_date = null)
    {

        // prepare cores
        $voucherCore = new VoucherCore();
        $waybillCore = new WaybillCore();
        // get beans
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);
        $waybill_id = $voucherBean->trx_template->ref_id;

        //get waybill bean
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);

        // validate input params
        if (!$jv_date) {
            $jv_date = DBConnection::getSystemDate();
        } else {
            // make sure the JV data is not in the future
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $jv_date_Date = date_create(date($jv_date));
            $dateDiff = date_diff($jv_date_Date, $today);
            if ($dateDiff->invert > 0) {
                throw new Exception("JV date can not be in the future");
            }
        }

        // build accounts
        if ($waybillBean->tender_id == 11) {
            switch ($waybillBean->trucking_company_id) {
                case "247":
                    $jv_owner_account = '590000';
                    $R_account  = '590000-50008';
                    $AP_acount  = '590000-25007';
                    $net_amount = 1;
                    break;
                default:
                    throw new Exception("invalid Procces");
            }
        } else {
            throw new Exception("مشروع غير صحيح");
        }

        // create the JV
        $jv_trx = [];
        $jv_trx[] = array(
            "account" => $AP_acount,
            "amount" => $net_amount,
            "op" => "D",
            "notes" => "مطالبة عن " . $voucherBean->notes
        );
        $jv_trx[] = array(
            "account" => $R_account,
            "amount" => $net_amount,
            "op" => "C",
            "notes" => "ايرادات عن " . $voucherBean->notes
        );

        $jv_id = $this->addJV($jv_owner_account, $jv_date, $jv_trx, $voucherBean->notes, 0);

        return $jv_id;
    }


    // ---------------------------------------------------------------------------------------------- //
    // ---------------------- Search if certain truck has advance payment claims -------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function calculateClaimAdvancePayment($bond_number, $pa_id, $user_id)
    {

        // search for advance payment claims with status NEW for the required pa and for the truck
        $fps = new FPS();
        $request = new stdClass();

        $filter = new stdClass();
        $filter->payee_reference_code = "BOND_NUMBER";
        $filter->bond_number = $bond_number;
        $filter->status = "NEW";
        $request->filter = $filter;
        $request->pa_id = $pa_id;
        $claimsReuslt =  $fps->searchPaClaim($request, $user_id);

        // loop over the vouchers to calculate any paid amount (later stage)

        // calculate the amount of
        $amount = 0;
        foreach ($claimsReuslt['data'] as $claim) {

            $claim_details = json_decode($claim['claim_details']);
            $amount += $claim_details->amount;
        }

        // return the number
        return $amount;
    }


    // ---------------------------------------------------------------------------------------------- //
    // ---------------------- Search if certain truck has advance payment claims -------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function closeClaimAdvancePayment($bond_number, $pa_id, $user_id)
    {

        // search for advance payment claims with status NEW for the required pa and for the truck
        $fps = new FPS();
        $request = new stdClass();

        $filter = new stdClass();
        $filter->payee_reference_code = "BOND_NUMBER";
        $filter->bond_number = $bond_number;
        $filter->status = "NEW";
        $request->filter = json_encode($filter);
        $request->pa_id = $pa_id;
        $claimsReuslt =  $fps->searchPaClaim($request, $user_id);

        // loop over claims
        foreach ($claimsReuslt['data'] as $claim) {
            $claim_id = ($claim['id']);

            // change status to COMPLETE
            $data = new stdClass();
            $data->claim_id = $claim_id;
            $data->new_status = "COMPLETE";
            $fps->changePaClaimStatus($data, $user_id);
        }
    }

    public function validateCalculateFreightInputs($data)
    {
        try { // check loading weights
            $res = "SUCCESS";
            if ($data->loading_weight) {
                if ($data->loading_weight > 99999) {
                    $res = "وزن التحميل المدخل اكبر من اعلى حد مسموح تحميلة ";
                } elseif ($data->loading_weight < 5000) {
                    $res =  "وزن التحميل المدخل اصغر من اقل حد مسموح تحميلة ";
                }
            }
            // check gross weights
            if ($data->gross_weight) {
                if ($data->gross_weight > 99999) {
                    $res = "وزن القائم المدخل اكبر من اعلى حد مسموح تحميلة ";
                } elseif ($data->gross_weight < 10000) {
                    $res =  "وزن القائم المدخل اصغر من اقل حد مسموح تحميلة ";
                }
            }

            // check discharge weights
            if ($data->discharge_weight) {
                if ($data->discharge_weight > 99999) {
                    $res =  "وزن التفريغ المدخل اكبر من اعلى حد مسموح تحميلة ";
                } elseif ($data->discharge_weight < 5000) {
                    $res = "وزن التفريغ المدخل اصغر من اقل حد مسموح تحميلة ";
                }
            }

            if (($data->loading_weights - $data->discharge_weight) > ($data->loading_weights * 0.03)) {
                $res =  "الفرق بين وزن التحميل و التفيغ يزيد عن الحد المسموح به ,هل انت متاكد من المتابع ";
            }

            return $res;
        } catch (Exception $e) {
            throw new Exception($e, 1);
        }
    }
}
