<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");

//require_once ('simple_html_dom.php');
class JPPMC
{

    public function __construct()
    {

        DBConnection::getInstance();
    }

    public function addTruckBalance($tn, $userName, $addValue = null)
    {
        if (!is_numeric($tn)) {
            throw new Exception("رقم الشاحنة غير صحيح.");
        } else {
            $tn = substr($tn, 0, 2) . '-' . substr($tn, 2, 10);
        }
        $c = $this->getCookies($userName);

        // First request to get list of vehicles
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "javax.faces.partial.ajax=true&javax.faces.source=sm_leftmenuform%3Asm_leftmenu&javax.faces.partial.execute=%40all&sm_leftmenuform%3Asm_leftmenu=sm_leftmenuform%3Asm_leftmenu&sm_leftmenuform%3Asm_leftmenu_menuid=0_1_0&sm_leftmenuform=sm_leftmenuform&javax.faces.ViewState=" . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        // Second two requests to filter selected vehicle
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'javax.faces.partial.ajax=true&' .
            'javax.faces.source=frmGridToolbar%3AgeneralFilter&' .
            'javax.faces.partial.execute=%40all&' .
            'frmGridToolbar%3AgeneralFilter=frmGridToolbar%3AgeneralFilter&' .
            'frmGridToolbar=frmGridToolbar&' .
            'frmGridToolbar%3AautToolbarSearch=' . $tn . '&' .
            'javax.faces.ViewState=' . $c['viewState']);

        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];


        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'java  x.faces.partial.ajax=true&' .
            'javax.faces.source=frmvehicleIdUnitPF%3AvehicleIdUnit&' .
            'javax.faces.partial.execute=frmvehicleIdUnitPF%3AvehicleIdUnit&' .
            'javax.faces.partial.render=frmvehicleIdUnitPF%3AvehicleIdUnit&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit=frmvehicleIdUnitPF%3AvehicleIdUnit&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit_filtering=true&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit_encodeFeature=true&' .
            'frmvehicleIdUnitPF=frmvehicleIdUnitPF&frmvehicleIdUnitPF%3AvehicleIdUnit_rppDD=20&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit_selection=0&' .
            'javax.faces.ViewState=' . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }


        curl_close($ch);
        if (strpos($result, '<td role="gridcell">' . $tn . '</td>') == false) {
            throw new Exception("بطاقة الشاحنة غير معرفة!");
        }

        // Third get selected truck limitation information
        // **************** TODO: First Change when click on a certain truck after search ************************
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'javax.faces.partial.ajax=true&' .
            'javax.faces.source=frmvehicleIdUnitPF%3AvehicleIdUnit%3A0%3Aj_idt447&' .
            'javax.faces.partial.execute=%40all&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit%3A0%3Aj_idt447=frmvehicleIdUnitPF%3AvehicleIdUnit%3A0%3Aj_idt447&' .
            'frmvehicleIdUnitPF=frmvehicleIdUnitPF&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit_rppDD=20&' .
            'frmvehicleIdUnitPF%3AvehicleIdUnit_selection=0&' .
            'javax.faces.ViewState=' . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        // **************** TODO: Second Change , the id of the current limit textfield ************************
        preg_match_all('/input id=\"frmCustomerLimitProcess:j_idt723\" name=\"frmCustomerLimitProcess:j_idt723\" type=\"text\" value=\"*([^\"]+)/', $result, $currentLimit);
        $currentLimit = $currentLimit[1][0];

        if (trim($currentLimit) == 'aria-required=') {
            $currentLimit = 0;
        }

        if (!is_numeric($currentLimit)) {
            throw new Exception("Error Processing Request. Initial limit must be defined", 1202);
        }
        if ($currentLimit <= .001) $currentLimit = 0;
        $currentLimit *= 1;

        // One requests to sync client state with server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/javax.faces.resource/keyfilter/keyfilter.js.xhtml?ln=primefaces&v=6.1');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: text/javascript, application/javascript, application/ecmascript, application/x-ecmascript, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        curl_close($ch);

        if (!$addValue) {
            return ["currentLimit" => $currentLimit];
        }

        $newLimit = $currentLimit + $addValue;
        if ($newLimit < 0) {
            throw new Exception("لا يوجد رصيد كافي في حساب الشاحنة. الرصيد الحالي: " . $currentLimit);
        }
        if ($newLimit == 0) {
            $newLimit = '0.001';
        }
        // Finally change balance

        // case of money limit
        // **************** TODO: 3rd Change ************************
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);


        curl_setopt($ch, CURLOPT_POSTFIELDS, "javax.faces.partial.ajax=true&" .
        "javax.faces.source=frmCustomerLimitProcess:btnSave&".
        "javax.faces.partial.execute=frmCustomerLimitProcess&".
        "javax.faces.partial.render=frmCustomerLimitProcess:pgrCustomerLimitProcess&".
        "frmCustomerLimitProcess:btnSave=frmCustomerLimitProcess:btnSave&".
        "frmCustomerLimitProcess=frmCustomerLimitProcess&".
        "frmCustomerLimitProcess:txtTemplate&".
        "frmCustomerLimitProcess:cldValidDate_input=01.01.2040&".
        "frmCustomerLimitProcess:slcLimitationType_focus&".
        "frmCustomerLimitProcess:slcLimitationType_input=161&".
        "frmCustomerLimitProcess:txtExtraLimitAmount&".
        "frmCustomerLimitProcess:sbcHoliday_input=on&".
        "frmCustomerLimitProcess:txtDescription=imported 27/12/2019&".
        "frmCustomerLimitProcess:j_idt717_input=01.01.2020 00:00:00&".
        "frmCustomerLimitProcess:j_idt720_input=01.01.2040 00:00:00&".
        "frmCustomerLimitProcess:j_idt723=". $newLimit . '&' .
        "frmCustomerLimitProcess:j_idt727_focus&".
        "frmCustomerLimitProcess:j_idt727_input=false&".
        "frmCustomerLimitProcess:j_idt735=0&".
        "frmCustomerLimitProcess:j_idt735=1&".
        "frmCustomerLimitProcess:j_idt735=2&".
        "frmCustomerLimitProcess:j_idt735=3&".
        "frmCustomerLimitProcess:j_idt735=4&".
        "frmCustomerLimitProcess:j_idt735=5&".
        "frmCustomerLimitProcess:j_idt735=6&".
        "frmCustomerLimitProcess:j_idt779_input=00:00&".
        "frmCustomerLimitProcess:j_idt780_input=00:00&".
        "frmCustomerLimitProcess:j_idt781_input=00:00&".
        "frmCustomerLimitProcess:j_idt782_input=00:00&".
        "frmCustomerLimitProcess:j_idt783_input=00:00&".
        "frmCustomerLimitProcess:j_idt784_input=00:00&".
        "frmCustomerLimitProcess:j_idt785_input=00:00&".
        "frmCustomerLimitProcess:j_idt788_input=23:59&".
        "frmCustomerLimitProcess:j_idt789_input=23:59&".
        "frmCustomerLimitProcess:j_idt790_input=23:59&".
        "frmCustomerLimitProcess:j_idt791_input=23:59&".
        "frmCustomerLimitProcess:j_idt792_input=23:59&".
        "frmCustomerLimitProcess:j_idt793_input=23:59&".
        "frmCustomerLimitProcess:j_idt794_input=23:59&".
        "javax.faces.ViewState=". $c['viewState']);


        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Origin: https://212.118.10.212';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Referer: https://212.118.10.212/customer/Stawiz';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        // Sync client with server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/javax.faces.resource/inputnumber/inputnumber.js.xhtml?ln=primefaces&v=6.1');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: text/javascript, application/javascript, application/ecmascript, application/x-ecmascript, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        curl_close($ch);

        return ["currentLimit" => $currentLimit, "addValue" => $addValue, "newLimit" => $this->addTruckBalance(str_replace('-', '', $tn), $userName)['currentLimit']];
    }

    // gets cookies from DB if available and not older than x0 minutes, else, it creates new ones and saves them to DB
    private function getCookies($userName)
    {

        $sql = "SELECT CAST(cookies AS CHAR CHARSET UTF8) cookies, create_date FROM jppmc_cookies where login=? and create_date > DATE_SUB(NOW() , INTERVAL 15 MINUTE)";
        $getCookies = DBConnection::runBindDatabaseQuery($sql, [$userName]);

        if (!$getCookies) { //if session life is older than x minutes, then renew cookies
            // gets new cookies from DB and saves them to DB with new time stamp
            $this->saveFreshCookies($userName);

            $sql = "SELECT CAST(cookies AS CHAR CHARSET UTF8) cookies, create_date FROM jppmc_cookies where login=?";
            $getCookies = DBConnection::runBindDatabaseQuery($sql, [$userName]);
            $cookies = json_decode($getCookies[0]->cookies, 1);
        } else { // just change time stamp on DB to renew session
            $cookies = json_decode($getCookies[0]->cookies, 1);
            if ($this->checkSession($cookies['cookies'])) {
                $this->refreshCookies($userName);
            } else {
                // gets new cookies from DB and saves them to DB with new time stamp
                $this->saveFreshCookies($userName);
                $sql = "SELECT CAST(cookies AS CHAR CHARSET UTF8) cookies, create_date FROM jppmc_cookies where login=?";
                $getCookies = DBConnection::runBindDatabaseQuery($sql, [$userName]);
                $cookies = json_decode($getCookies[0]->cookies, 1);
            }
        }

        return $cookies;
    }

    private function checkSession($cookie)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:71.0) Gecko/20100101 Firefox/71.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: JSESSIONID=' . $cookie;
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);
        if (strpos($result, 'This document has moved')) {
            return false;
        }
        return true;
    }
    private function saveFreshCookies($userName)
    {
        $c = json_encode($this->getFreshCookies($userName));
        $sql = "update jppmc_cookies set cookies=CAST(? AS CHAR CHARSET UTF8),create_date = now() where login=?";
        DBConnection::runBindDatabaseQuery($sql, [$c, $userName]);
    }
    private function refreshCookies($userName)
    {
        $sql = "update jppmc_cookies set create_date = now() where login=?";
        DBConnection::runBindDatabaseQuery($sql, [$userName]);
    }

    private function getFreshCookies($userName)
    {

        $sql = "SELECT login,password, CAST(cookies AS CHAR CHARSET UTF8) cookies, create_date FROM jppmc_cookies where login=?";
        $getCookies = DBConnection::runBindDatabaseQuery($sql, [$userName]);

        if (!$getCookies) {
            throw new Exception("اسم المستخدم غير معرّف", 1201);
        }
        $login = $getCookies[0]->login;
        $password = $getCookies[0]->password;

        // First request to initiate cookies with server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Login');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        preg_match_all('/Set-Cookie:\s*([^;]+)/', $result, $cookies);
        $cookies = implode('; ', $cookies[1]);
        preg_match_all('/input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"j_id1:javax.faces.ViewState:0\" value=\"*([^\"]+)/', $result, $ViewState);
        $ViewState = $ViewState[1][0];

        // Second request to login and get response perminant cookies
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Login');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "loginForm=loginForm&x=&y=&j_username=" . $login . "&j_password=" . $password . "&submitButton=&javax.faces.ViewState=" . $ViewState);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:71.0) Gecko/20100101 Firefox/71.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $cookies;
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        preg_match_all('/Set-Cookie:\s*([^;]+)/', $result, $cookies);
        $cookies = implode('; ', $cookies[1]);

        // Third request to sync ViewState with Oracle
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:71.0) Gecko/20100101 Firefox/71.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $cookies;
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);
        preg_match_all('/input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"j_id1:javax.faces.ViewState:0\" value=\"*([^\"]+)/', $result, $ViewState);
        $ViewState = $ViewState[1][0];

        return ["cookies" => $cookies, "viewState" => $ViewState];
    }


    public function fetchDieselLog()
    {

        $latest_record = $this->getLatestDate();
        $latest_date = $latest_record[0]->diesel_date;

        $date = new DateTime($latest_date);
        $date->add(new DateInterval('PT1S'));
        $latest_date_plus = $date->format("d.m.Y H:i:s");
        $c = $this->getCookies('MG5');
 
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "javax.faces.partial.ajax=true&javax.faces.source=sm_leftmenuform%3Asm_leftmenu&javax.faces.partial.execute=%40all&sm_leftmenuform%3Asm_leftmenu=sm_leftmenuform%3Asm_leftmenu&sm_leftmenuform%3Asm_leftmenu_menuid=0_0_1&sm_leftmenuform=sm_leftmenuform&javax.faces.ViewState=" . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_exec($ch);
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "javax.faces.partial.ajax=true&javax.faces.source=frmFuelReport%3AbtnFind&javax.faces.partial.execute=frmFuelReport&javax.faces.partial.render=pgrFuelReportDatatable+frmFuelReport%3AcldStartDate+frmFuelReport%3AcldEndDate&frmFuelReport%3AbtnFind=frmFuelReport%3AbtnFind&frmFuelReport=frmFuelReport&frmFuelReport%3AcldStartDate_input=" . urlencode($latest_date_plus) . "&frmFuelReport%3AcldEndDate_input=31.12.2021+23%3A59%3A59&frmFuelReport%3AslcWorkingType_focus=&frmFuelReport%3AslcReportType_focus=&frmFuelReport%3AslcReportType_input=1&javax.faces.ViewState=" . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);

        $xml = simplexml_load_string($result, 'SimpleXMLElement', LIBXML_NOCDATA) or die("Error: Cannot create object");
        $full_records_count = preg_replace("/[^0-9]/", "", get_object_vars($xml->changes->eval)[0]);
        curl_setopt($ch, CURLOPT_URL, 'https://212.118.10.212/customer/Stawiz');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "javax.faces.partial.ajax=true&javax.faces.source=frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport&javax.faces.partial.execute=frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport&javax.faces.partial.render=frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport=frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_pagination=true&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_first=0&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_rows=" . $full_records_count . "&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_skipChildren=true&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_encodeFeature=true&frmPlateBasedGeneralReportDatatable=frmPlateBasedGeneralReportDatatable&frmPlateBasedGeneralReportDatatable%3AdtbPlateBasedGeneralReport_rppDD=112&javax.faces.ViewState=" . $c['viewState']);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:74.0) Gecko/20100101 Firefox/74.0';
        $headers[] = 'Accept: application/xml, text/xml, */*; q=0.01';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Faces-Request: partial/ajax';
        $headers[] = 'X-Requested-With: XMLHttpRequest';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: ' . $c['cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
   

        if (curl_errno($ch)) {
            throw new Exception("Error Processing Request" . curl_error($ch), 1);
        }
        curl_close($ch);

        try {
            $xml = simplexml_load_string($result, 'SimpleXMLElement', LIBXML_NOCDATA);
            $feed = new DOMDocument();
            $feed->loadHTML($xml->changes->update[0]);
            $feed->saveHTML();

            $cell_index = 1;
            $cells_index_map = [
                1 => '', //date
                2 => '', //plate
                5 => '', //station
                8 => '', //unit price
                9 => '', //quantity
                10 => '', //total
            ];
            $rows = [];
            foreach ($feed->getElementsByTagName('td') as $in => $td) {
                if ($td->getAttribute('role') === 'gridcell') {
                    if (array_key_exists($cell_index, $cells_index_map))
                        if ($cell_index === 1) {
                            $date = new DateTime(str_replace('.', '-', $td->textContent));
                            $cells_index_map[$cell_index] = json_encode($date->format('Y-m-d H:i:s'));
                        } elseif ($cell_index === 2)
                            $cells_index_map[$cell_index] = str_replace('-', '', json_encode($td->textContent));
                        elseif ($cell_index === 8 || $cell_index === 9 || $cell_index === 10) {
                            $cells_index_map[$cell_index] = (float)preg_replace("/[^0-9.]/", "", json_encode($td->textContent));
                        } else
                            $cells_index_map[$cell_index] = json_encode($td->textContent);
                        $cell_index++;
                }
                if ($cell_index === 11) {
                    $rows[] = $cells_index_map;
                    $cell_index = 1;
                }                
            }
        } catch (Exception $e) {
        }

        if ($rows)
            $this->insertDieselLogData($rows);
        }

    public function insertDieselLogData($data_array)
    {
        $db_query = "INSERT INTO waybill.diesel_log(diesel_date, tn, station, unit_price, quantity, total) values ";
        $values_arr = [];
        foreach ($data_array as $row)
            $values_arr[] = ' (' . implode(',', $row) . ') ';
        $db_query .= implode(',', $values_arr);
        $res = DBConnection::runBindDatabaseQuery($db_query, []);
        return $res;
    }


    public function searchDieselLog($tn = null)
    {

        $fields = 'diesel_date,tn,station,unit_price,quantity,total';

        $db_query = "SELECT " . $fields . " FROM waybill.diesel_log";
        if ($tn)
            $db_query .= " WHERE tn = " . $tn;
        $db_query .= " ORDER BY diesel_date DESC";

        $res = DBConnection::runDatabaseQuery($db_query);
        return $res;
    }

    public function getLatestDate()
    {

        $fields = 'diesel_date';
        $db_query = "SELECT " . $fields . " FROM waybill.diesel_log";
        $db_query .= " ORDER BY diesel_date DESC limit 1";

        $res = DBConnection::runDatabaseQuery($db_query);
        return $res;
    }

    public function getDieselFullBalance()
    {
        $Q1 = 'SELECT 
                    tn,
                    COUNT(id) cnt,
                    SUM(CASE
                        WHEN status IN ("ACTIVE" , "PENDING") THEN 100
                        WHEN
                            status not IN ("ACTIVE" , "PENDING","INACTIVE","REVOKED")
                        THEN
                            (CASE DATE_FORMAT(JSON_UNQUOTE(JSON_EXTRACT(document,
                            "$.cargo[0].weights.loading.time_stamp")),"%y%m")
                                WHEN 2001 THEN 215.25
                                WHEN 2002 THEN 211.75
                                WHEN 2003 THEN 194.25
                                WHEN 2004 THEN 162.75
                                WHEN 2005 THEN 138.25
                                WHEN 2006 THEN 143.5
                                WHEN 2007 THEN 162.75
                                WHEN 2008 THEN 162.75
                                WHEN 2009 THEN 168.0
                                WHEN 2010 THEN 161.0
                                WHEN 2011 THEN 161.0
                                WHEN 2012 THEN 164.5
                                
                                WHEN 2101 THEN 175.0
                                WHEN 2102 THEN 183.75
                                WHEN 2103 THEN 194.25
                                WHEN 2104 THEN 194.25
                                WHEN 2105 THEN 194.25
                                WHEN 2106 THEN 203.0
                                ELSE 0
                            END)
                        ELSE 0
                    END) AS balance
                FROM
                    waybill_view
                WHERE
                    tender_id = 11                
                GROUP BY tn ' ;

        $fullBalance = DBConnection::runDatabaseQuery($Q1);
        return $fullBalance;
    }
}




        // // remove un-needed details in HTML
        // $tempHTML=substr($result,strpos($result,'<form id="loginForm" name="loginForm" method="post" action="/customer/Login"')-1);
        // $tempHTML=substr($tempHTML,1,strpos($tempHTML,'</form>')+6);
        // // Ignore HTML Parse errors
        // libxml_use_internal_errors(true);
        // $html = str_get_html($tempHTML);
        //$ViewState = trim($html->find('input[name=javax.faces.ViewState]')[0]->innertext);