<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../../core/company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");



class PaRouteWageInterface extends API
{
    // the request of each call
    private $_request = array();
    private $_paRouteWageCore;
    private $_fps;
    private $_truckingCompanyCore;
    private $_voucherCore;
    private $_accountCore;
    private $_paymentCore;
    private $_paymentAgentCore;
    private $_company_employee;


    public function __construct()
    {


        $this->_paymentAgentCore = new PaymentAgentCore();


        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_paRouteWageCore = new PaRouteWageCore();
        $this->_fps = new FPS();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_voucherCore = new VoucherCore();
        $this->_accountCore = new AccountCore();
        $this->_paymentCore = new PaymentCore();
        $this->_company_employee = new CompanyEmployeeCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // -------------------------------------------------------------------------------- //
    // --------------------- get bean for certain pa route wage ----------------------- //
    // -------------------------------------------------------------------------------- //
    public function getPaRouteWage()
    {
        $routeWageBean = $this->_paRouteWageCore->getBasicPaRouteWage($this->_request->id, $_SESSION['user_id']);
        parent::response($routeWageBean);
    }


    // --------------------------------------------------------------------------- //
    // ------------------------ Prepare Search Filter ---------------------------- //
    // --------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $routeWageFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key' => $key, 'val' => $value];
                array_push($routeWageFilter, $tempArr);
            }
        }

        return $routeWageFilter;
    }

    // ----------------------------------------------------------------------- //
    // --------------------- get list of route wages ------------------------- //
    // ----------------------------------------------------------------------- //
    public function searchPaRouteWage()
    {

        $routeWageFilter = $this->prepareFilter();

        $routeWageReuslt = $this->_paRouteWageCore->searchPaRouteWage(
            $routeWageFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //return  response
        parent::response($routeWageReuslt);
    }


    // --------------------------------------------------------------------------- //
    // -------------------- create new route wage -------------------------------- //
    // --------------------------------------------------------------------------- //
    public function createPaRouteWage()
    {

        try {

            DBConnection::startTransaction();
            $routeWageBean = new stdClass();

            // get user input
            $pa_id = $_SESSION['pa_id'] ? $_SESSION['pa_id'] : $this->_request->pa_id;
            $origin_id = $this->_request->origin_id;
            $destination_id = $this->_request->destination_id;
            $start_date = $this->_request->start_date;
            $end_date = $this->_request->end_date;
            $plan = $this->_request->plan;
            $minimum_weight = $this->_request->minimum_weight;
            $wage_per_ton = $this->_request->wage_per_ton;
            $type = "payable";
            $pa_project_id = $this->_request->pa_project_id;
            $tender_id = $this->_request->tender_id;
            $cargo_id = $this->_request->cargo_id;
            $tolerance_calculation_method = $this->_request->tolerance_calculation_method;
            $tolerance_percentage = $this->_request->tolerance_percentage;
            $effective_weight = $this->_request->effective_weight;
            $loss_fine_per_kg = $this->_request->loss_fine_per_kg;
            $loss_fine_tolerance_kg = $this->_request->loss_fine_tolerance_kg;

            // fill bean
            $routeWageBean->pa_id = $pa_id;
            $routeWageBean->origin_id = $origin_id;
            $routeWageBean->destination_id = $destination_id;
            $routeWageBean->start_date = $start_date;
            $routeWageBean->end_date = $end_date;
            $routeWageBean->plan = $plan;
            $routeWageBean->minimum_weight = $minimum_weight;
            $routeWageBean->wage_per_ton = $wage_per_ton;
            $routeWageBean->pa_project_id = $pa_project_id;
            $routeWageBean->tender_id = $tender_id;
            $routeWageBean->cargo_id = $cargo_id;
            $routeWageBean->type = $type;
            $routeWageBean->tolerance_percentage = $tolerance_percentage;
            $routeWageBean->loss_fine_per_kg = $loss_fine_per_kg;
            $routeWageBean->loss_fine_tolerance_kg = $loss_fine_tolerance_kg;
            $routeWageBean->tolerance_calculation_method = $tolerance_calculation_method;
            $routeWageBean->effective_weight = $effective_weight;

            //TODO: get deductions from paProject if exist, then fill it in pa_route_wage

            $paProjectBean = $this->_paRouteWageCore->getBasicPaProject($pa_project_id, $_SESSION['user_id']);
            $deductions = $paProjectBean->details->payment->deduction;

            foreach ($deductions as $index => $d) {
                $routeDeduction = new stdClass();
                $routeDeduction->id = $index;
                $routeDeduction->name = $d->deductionName;
                $routeDeduction->label = $d->deductionName;
                $routeDeduction->value = new stdClass();

                if ($d->method == "fixed") {
                    $routeDeduction->value->rate = $d->amount;
                    $routeDeduction->value->amount = $d->amount;
                    $routeDeduction->value->method = "FIXED";
                    $routeDeduction->value->source = explode(".", $d->source)[1];
                } else {
                    $routeDeduction->value->rate = $d->amount;
                    $routeDeduction->value->amount = $d->amount;
                    $routeDeduction->value->method = "RATE";
                    $routeDeduction->value->source = explode(".", $d->source)[1];
                }
                $routeWageBean->deductions[] = $routeDeduction;
            }


            // validate pa route wage to make no wage intersect with another wage
            $this->_paRouteWageCore->validatePaRouteWageForCreate($routeWageBean);
            // create pa route wage
            $id = $this->_paRouteWageCore->createPaRouteWage($routeWageBean, $_SESSION['user_id']);
            // activate pa_route wage
            $this->_paRouteWageCore->changeStatus($id, 'ACTIVE', $_SESSION['user_id']);

            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESS_CREATE";
            $Result['ID'] = $id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------ //
    // -------------------- change route wage status -------------------- //
    // ------------------------------------------------------------------ //
    public function changeStatus()
    {

        // change route wage status
        $this->_paRouteWageCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------ //
    // --------------------- update route wage info --------------------------- //
    // ------------------------------------------------------------------------ //
    public function updateInfo()
    {

        $routeWageBean = $this->_request;
        $this->_paRouteWageCore->updateInfo($routeWageBean, $this->_request->id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ROUTE_WAGE.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------------- //
    // --------------- search for all pa project for acertain payment agens --------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function searchPaProject()
    {
        $paProjectFilter = $this->prepareFilter();

        $paProjectReuslt = $this->_paRouteWageCore->searchPaProject(
            $paProjectFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //return response
        parent::response($paProjectReuslt);
    }

    //
    public function getBasicPaProject()
    {
        try {
            $paProjectId  = $this->_request->id;

            $project = $this->_paRouteWageCore->getBasicPaProject($paProjectId, $_SESSION["user_id"]);
            $project->details->tc->value = $project->details->tc->id;
            $project->details->tc->label = $project->details->tc->name;

            parent::response($project);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------- //
    // --------------- Create new project for certain pa to append route wages --------------- //
    // ----------------------------------------------------------------------------------------- //
    public function createPaProject()
    {

        try {
            DBConnection::startTransaction();
            // get user params
            $minimum_balance = $this->_request->minimum_balance;
            $maximum_balance = $this->_request->maximum_balance;
            $trucking_company_id = $this->_request->trucking_company_id;
            $project_name = $this->_request->project_name;
            $commission = $this->_request->commission;
            $cargo_type = $this->_request->cargo_type;
            $company_employee_ids = $this->_request->company_employee_ids;
            $ar_name = $this->_request->ar_name;
            $deduction = $this->_request->deduction;
            $paProjectId  = $this->_request->paProjectId;
            $img_url = $this->_request->img_url;
            $templates = $this->_request->templates;
            $reports = $this->_request->reports;


            // decode input
            if (gettype($commission) == "string") {
                $commission = json_decode($commission);
            }
            if (gettype($cargo_type) == "string") {
                $cargo_type = json_decode($cargo_type);
            }
            if (gettype($deduction) == "string") {
                $deduction = json_decode($deduction);
            }

            // validate and get trucking company name in case it is generated from existing trucking company
            if ($trucking_company_id && $trucking_company_id != "other") {
                $truckingCompanyFilter = [['key' => "id", 'val' => $trucking_company_id]];
                $truckingCompanyResult = $this->_truckingCompanyCore->searchTruckingCompany($truckingCompanyFilter, 1, 0, 0);
                if ($truckingCompanyResult->found_rows == 0) {
                    throw new Exception("جهة المطالبة غير صحيحة");
                }
                $ar_name = $truckingCompanyResult->data[0]->name;
            }

            if (!$ar_name) {
                throw new Exception("جهة المطالبة غير صحيحة");
            }

            // get the payment agent account on FPS system
            $accountFilter = new stdClass();
            $accountResult = $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);

            if ($accountResult['found_rows'] == 0) {
                throw new Exception("لا توجد لديك صلاحية للمتابعة");
            }
            $account_id = $accountResult['data'][0]['id'];


            //create new AR account
            // if (!$paProjectId) {
            //     $type = "AR";
            //     $account_name = "مطالبة " . $ar_name;
            //     $createSubAccountfields = new stdClass();
            //     $createSubAccountfields->account_id = $account_id;
            //     $createSubAccountfields->type = $type;
            //     $createSubAccountfields->account_name = $account_name;
            //     $createSubAccountfields->minimum_balance = null;
            //     $createSubAccountfields->maximum_balance = $maximum_balance;
            //     //$sub_id = $this->_fps->createSubAccount($createSubAccountfields, $_SESSION['user_id']);

            //     //add this project account to employees to be able to see
            //     $employeeSearchFilter = [['key' => 'id', 'val' => $company_employee_ids, 'op' => 'in']];
            //     $employeeInfo = $this->_company_employee->searchCompanyEmployee($employeeSearchFilter, 100, 0, $_SESSION['user_id']);

            //     foreach ($employeeInfo->data as $employee) {
            //         // if employee has access to all accounts , then skip it
            //         $account_ids = $employee->account_ids;
            //         if (!$account_ids) $account_ids = [];
            //         if ($account_ids == '["*"]') continue;

            //         // append the project account sub id to user
            //         $company_employee_id = $employee->id;
            //         $account_id = $account_id;
            //         //$this->_company_employee->saveAccountAuthForEmployee([$company_employee_id], $sub_id, $_SESSION['user_id']);
            //     }
            // }


            // create new record in pa_project
            $project = new stdClass();
            $project->pa_id = $_SESSION['pa_id'];
            $project->account_id = $account_id;
            $project->name = $project_name;

            // fill the details of the pa project (tc_details , commissions , cargo_type)
            $project->details = new stdClass();
            $project->details->tc = new stdClass();
            $project->details->tc->id = $trucking_company_id;
            $project->details->tc->name = $ar_name;
            $project->details->ct = $cargo_type;
            $project->details->payment = new stdClass();
            $project->details->payment->commissions = $commission;
            $project->details->payment->deduction = $deduction;
            $project->details->logo_details = new stdClass();
            $project->details->logo_details->img_url = $img_url;
            $project->details->templates = json_decode($templates);
            $project->details->reports = json_decode($reports);

            $sub_id = 50002;


            // fill trx
            // $trx_template_accounts = $this->_request->trx;
            // dump($trx_template_accounts);
            // die;

            // if (gettype($trx_template_accounts) == "string") {
            //     $trx_template_accounts = json_decode($trx_template_accounts);
            // }
            // // add the new CLM account
            // foreach ($trx_template_accounts as $template) {
            //     if($template->code == "WAYBILL_COMPLETE"){
            //         $dataStd = new stdClass();
            //         $dataStd->label = "مطالبة " . $ar_name;
            //         $dataStd->value = $sub_id;

            //         $CLM = new stdClass();
            //         $CLM->CLM = [$dataStd];
            //         $template->trx[] = $CLM;

            //         break;
            //     }
            // }

            // // loop over pa_project trx template and inject the account ids
            // $q = 'select   
            //         code,   
            //         name,                   
            //         CAST(`trx_templates` AS CHAR CHARSET UTF8) AS template
            //     from voucher_type where status = "ACTIVE"';
            // $result = DBConnection::runDatabaseQuery($q);
            // foreach ($result as &$r) {
            //     foreach ($trx_template_accounts as $accounts) {                    
            //         if ($r->code == $accounts->code) {

            //             // start filling the object                        
            //             $paymentObject = new stdClass();
            //             $rawTemplate = json_decode($r->template)[0];
            //             $paymentObject->code = $r->code;
            //             $paymentObject->name = $r->name;
            //             $paymentObject->trx_template = [];
            //             $paymentObject->payment_method =  $rawTemplate->payment_method;       
            //             $paymentObject->payment_method_value = "CASH";
            //             $paymentObject->amount_calculation_method = ["code"=>"TAGREESH","caption"=>"تقريش"];

            //             // fill the accounts in trx
            //             $generalTemplate = json_decode($r->template);
            //             $generalTemplate = ($generalTemplate[0]->template);         

            //             foreach ($generalTemplate as $general_template_key => $general_template_val) {                       
            //                 foreach ($accounts->trx as $a_key => $acc_trx) {     

            //                     foreach ($acc_trx as $a_key => $acco) {
            //                         if($general_template_key == $a_key){                                       
            //                             foreach ($acco as $accoObj) {
            //                                 $generalTemplate->$general_template_key->value[] = $account_id . "-" .$accoObj->value;
            //                             }                                        
            //                         }                                    
            //                     }
            //                 }
            //             }
            //             $paymentObject->template = $generalTemplate;

            //             // append this payment object to the project trx tempalte
            //             $project->trx_template[] = $paymentObject;
            //         }
            //     }
            // }

            if ($paProjectId) {
                $project->id = $paProjectId;

                $this->_paRouteWageCore->updatePaProject($project, $_SESSION["user_id"]);
            } else {
                // fill the account ids
                $project_id = $this->_paRouteWageCore->createPaRouteWageProject($project, $_SESSION['user_id']);
                // activate it
                $this->_paRouteWageCore->changePaProjectStatus($project_id, 'ACTIVE', $_SESSION['user_id']);
            }


            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "تمت العملية بنجاح ";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------- //
    // ---------------- search for a certain pa project destinations ------------------- //
    // -------------------------------------------------------------------------------- //
    public function getPaProjectDestinations()
    {
        // get user input
        $project_id = $this->_request->project_id;

        // Search for pa_route wages
        $routeWageFilter =  [['key' => "pa_project_id", 'val' => $project_id]];
        $routeWageReuslt = $this->_paRouteWageCore->searchPaRouteWage($routeWageFilter, 1000, 0, $_SESSION['user_id']);

        // group them into destinations
        $result = [];
        foreach ($routeWageReuslt->data as $wage) {
            $result[] = ["destination_id" => $wage->destination_id, "destination_name" => getLocationName($wage->destination_id)];
        }

        // return result to user
        parent::response($result);
    }

    // -------------------------------------------------------------------------------- //
    // ---------------- search for a certain pa project origins ------------------- //
    // -------------------------------------------------------------------------------- //
    public function getPaProjectOrigins()
    {
        // get user input
        $project_id = $this->_request->project_id;

        // Search for pa_route wages
        $routeWageFilter =  [['key' => "pa_project_id", 'val' => $project_id]];
        $routeWageReuslt = $this->_paRouteWageCore->searchPaRouteWage($routeWageFilter, 1000, 0, $_SESSION['user_id']);

        // group them into origin_name
        $result = [];
        $copy = [];
        foreach ($routeWageReuslt->data as $wage) {
            if (!$copy[$wage->origin_id]) {
                $copy[$wage->origin_id] = $wage->origin_id;
                $result[] = ["origin_id" => $wage->origin_id, "origin_name" => getLocationName($wage->origin_id)];
            }
        }

        // return result to user
        parent::response($result);
    }

    public function getPrintTemplates()
    {
        $result = [];
        $result['claim_item'][] = ["label" => "نموذج 1", "value" => "fps_claim_item"];
        // $result['claim_item'][] = ["label" => "نموذج 2", "value" => "pa_item_temaplte_2"];
        // $result['claim_item'][] = ["label" => "نموذج 3", "value" => "pa_item_temaplte_3"];
        // $result['claim_item'][] = ["label" => "نموذج 4", "value" => "pa_item_temaplte_4"];
        // $result['claim_item'][] = ["label" => "نموذج 5", "value" => "pa_item_temaplte_5"];

        $result["claim"][] = ["label" => "نموذج 1", "value" => "pa_claim_temaplte_1"];
        // $result["claim"][] = ["label" => "نموذج 2", "value" => "pa_claim_temaplte_2"];
        // $result["claim"][] = ["label" => "نموذج 3", "value" => "pa_claim_temaplte_3"];
        // $result["claim"][] = ["label" => "نموذج 4", "value" => "pa_claim_temaplte_4"];

        $result['payment_voucher'][] = ["label" => "نموذج صرف 1", "value" => "fps_voucher"];
        // $result['payment_voucher'][] = ["label" => "نموذج 2", "value" => "pa_payment_temaplte_2"];
        // $result['payment_voucher'][] = ["label" => "نموذج 3", "value" => "pa_payment_temaplte_3"];

        $result['receipt_voucher'][] = ["label" => "نموذج قبض 1", "value" => "fps_receipt_voucher"];
        // $result['receipt_voucher'][] = ["label" => "نموذج 2", "value" => "pa_receipt_temaplte_2"];
        parent::response($result);
    }


    public function getReportTemplates()
    {
        $result = [];

        $result[] = ["label" => "تقرير اغلاق الصندوق", "value" => "pa_close_cash_box"];
        $result[] = ["label" => "تقرير السلف المقدمة", "value" => "pa_advance_payment_report"];
        $result[] = ["label" => "تقرير الوصولات المحذوفة", "value" => "pa_deleted_claim_item_report"];
        // $result[] = ["label" => "تقرير 4", "value" => "report_4"];
        // $result[] = ["label" => "تقرير 5", "value" => "report_5"];

        parent::response($result);
    }
}

$paRouteWageInterface = new PaRouteWageInterface();
