<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");


class PaRouteWageCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ---------------------------------------------------------------------------- //
    // -------------------Create route wage bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------- //
    public function getPaRouteWage($id, $user_id)
    {
        $routeWageInfo = DBConnection::getObjectBean("pa_route_wage", $id, $user_id);
        return $routeWageInfo;
    }
    // ------------------------------------------------------------------------------------------------------ //
    // -------------------Create basic(without activities) route wage bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function getBasicPaRouteWage($id, $user_id)
    {
        $routeWageInfo = DBConnection::getBasicObjectBean("pa_route_wage", $id, $user_id);
        return $routeWageInfo;
    }

    // ------------------------------------------------------------------------------------------------------ //
    // -------------------Create basic(without activities) route wage bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function getBasicPaProject($id, $user_id)
    {
        $routeWageInfo = DBConnection::getBasicObjectBean("pa_project", $id, $user_id);
        return $routeWageInfo;
    }

    // ---------------------------------------------------------------------------- //
    // -------------------search for route wage using any search filter ----------- //
    // ---------------------------------------------------------------------------- //
    public function searchPaProject($searchFilter, $limit, $offset, $user_id)
    {

        $routeWageResult = DBConnection::searchDB("pa_project", $searchFilter, $limit, $offset, $user_id, " order by id desc ");
        return $routeWageResult;
    }

    // ---------------------------------------------------------------------------- //
    // -------------------search for route wage using any search filter ----------- //
    // ---------------------------------------------------------------------------- //
    public function searchPaRouteWage($searchFilter, $limit, $offset, $user_id)
    {

        $routeWageResult = DBConnection::searchDB("pa_route_wage", $searchFilter, $limit, $offset, $user_id, " order by id desc ");
        return $routeWageResult;
    }

    // ------------------------------------------------------------------ //
    // ------------------- create new route wage ------------------------ //
    // ------------------------------------------------------------------ //
    public function createPaRouteWage($routeWageBean,  $user_id)
    {

        $routeWageResult = DBConnection::insertDB("pa_route_wage", $routeWageBean, $user_id);
        $routeWage_id =  $routeWageResult[0]['@id'];
        return $routeWage_id;
    }


    // ---------------------------------------------------------------------- //
    // ----------------- Validate the new route wage ------------------------ //
    // ---------------------------------------------------------------------- //
    public function validatePaRouteWageForCreate($routeWageBean)
    {

        // validate if the bean has complete info
        if (
            !$routeWageBean->origin_id || !$routeWageBean->destination_id || !$routeWageBean->tender_id
            || !$routeWageBean->start_date || !$routeWageBean->end_date || !$routeWageBean->type
        ) {
            throw new Exception("Invalid Route Wage");
        }

        // validate if the new route wage dates overlap with any other active wage for the same location
        $db_query = "select id from pa_route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and start_date >= ? and start_date <= ?
                     and status in ('NEW','ACTIVE')
                     and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);

        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }

        $db_query = "select id from pa_route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and end_date >= ? and end_date <= ?
                     and status in ('NEW','ACTIVE')
                    and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);
        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }


        $db_query = "select id from pa_route_wage
                     where destination_id = ?
                     and origin_id = ?
                     and tender_id = ?
                     and start_date <= ? and end_date >= ?
                     and status in ('NEW','ACTIVE')
                    and type = ?
                    ";
        $params = [
            $routeWageBean->destination_id, $routeWageBean->origin_id, $routeWageBean->tender_id,
            $routeWageBean->start_date, $routeWageBean->end_date, $routeWageBean->type
        ];
        $result = DBConnection::runBindDatabaseQuery($db_query, $params);
        if (sizeof($result) > 0) {
            throw new Exception(" التسعيرة معرفة مسبقا لموقع التفريغ أو انها تتداخل مع وقت تسعيرة أخرى");
        }
    }


    // ------------------------------------------------------------------ //
    // -------------------- change route wage status -------------------- //
    // ------------------------------------------------------------------ //
    public function changeStatus($pa_route_wage_id, $new_status, $user_id)
    {

        $updateStruct = new stdClass();
        $updateStruct->id = $pa_route_wage_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("pa_route_wage", $updateStruct, $user_id);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update route wage info in DB-------------------- //
    // ---------------------------------------------------------------------- //
    function updateInfo($routeWageBean, $pa_route_wage_id, $updated_by)
    {

        // fill update struct and set the target user id
        $routeWageBean->id = $pa_route_wage_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("pa_route_wage", $pa_route_wage_id, $updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if (compareObject($routeWageBean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $routeWageBean = mapBeanToDBBean($routeWageBean, $DB_Bean);

            // fill update struct and set the target user id
            DBConnection::updateDB("pa_route_wage", $routeWageBean, $updated_by);
        }
    }


    // ----------------------------------------------------------------------------------------------------------- //
    // --------------------- Check if wage is defined for certain destination on a certain cargo ----------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    function searchPaRouteWageForFreight($tender_id, $pa_id, $origin_id, $destination_id, $loading_date, $cargo_id, $throw = true, $user_id)
    {

        if (!$pa_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, مكتب صرف غير محدد");
        }
        if (!$origin_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, موقع تحميل غير محدد");
        }
        if (!$destination_id) {
            throw new Exception("خطأ في البحث عن التسعيرة, وجهة غير محددة");
        }
        if (!$loading_date) {
            throw new Exception("خطأ في البحث عن التسعيرة, تاريخ التحميل غير محدد");
        }

        $SearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'destination_id', 'val' => $destination_id],
            ['key' => 'start_date', 'val' => $loading_date, 'op' => 'less than'],
            ['key' => 'end_date', 'val' => $loading_date, 'op' => 'greater than'],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'pa_id', 'val' => $pa_id],
            ['key' => 'cargo_id', 'val' => $cargo_id],
            ['key' => 'origin_id', 'val' => $origin_id],
        ];     

        $routeWageInfo = $this->searchPaRouteWage($SearchFilter, 1000, 0, $user_id);

        if ($routeWageInfo->found_rows == 0) {
            $locationCore = new LocationCore();
            $childLocation = $locationCore->getLocationBasic($origin_id, 0);
            array_pop($SearchFilter);
            array_push($SearchFilter, ['key' => 'origin_id', 'val' => $childLocation->parent_id]);
            $routeWageInfo = $this->searchPaRouteWage($SearchFilter, 1000, 0, $user_id);
        }

        if ($routeWageInfo->found_rows == 0 && $throw) {
            throw new Exception("لا يوجد تسعيرة");
        }

        if ($routeWageInfo->found_rows > 1 && $throw) {
            throw new Exception("لا يمكن تحديد التسعيرة المناسبة");
        }

        return $routeWageInfo;
    }


    // ------------------------------------------------------------------------------- //
    // -------------------------- update  pa project ---------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function updatePaProject($paProjectBean, $updated_by)
    {
        DBConnection::updateDB("pa_project", $paProjectBean, $updated_by);
    }


    // ------------------------------------------------------------------------------- //
    // ------------------- create new pa project------------------------ //
    // ------------------------------------------------------------------------------- //
    public function createPaRouteWageProject($routeWageBean, $user_id)
    {
        $routeWageResult = DBConnection::insertDB("pa_project", $routeWageBean, $user_id);
        $routeWage_id =  $routeWageResult[0]['@id'];
        return $routeWage_id;
    }

    // ------------------------------------------------------------------------------- //
    // -------------------- change status of pa project -------------------- //
    // ------------------------------------------------------------------------------- //
    public function changePaProjectStatus($liability_id, $new_status, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $liability_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("pa_project", $updateStruct, $user_id);
    }
}
