<?php

// import required classes

require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../pa_route_wage/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/../payment/payment_core.php");
require_once(dirname(__FILE__) . "/../voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");

class PaClaims_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_paRouteWageCore;
    private $_paymentCore;
    private $_voucherCore;
    private $_accountCore;

    // private $_paClaimCore;


    public function __construct()
    {
        $this->_fps = new FPS();
        $this->_paRouteWageCore = new PaRouteWageCore();
        $this->_paymentCore = new PaymentCore();
        $this->_voucherCore = new VoucherCore();
        $this->_accountCore = new AccountCore();

        // call the super constructur
        $this->_request = parent::__construct();
        // validate the session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION", 1);
        }



        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ---------------------------------------------------------------------------- //
    // ------------------  prepare any json filter for search --------------------- //
    // ---------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        // $accountFilter = [];
        // if ($this->_request->filter) {
        //     $filter = json_decode($this->_request->filter, true);
        //     foreach ($filter as $key => $value) {
        //         if ($key == 'name') {
        //             $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
        //         } else if ($key == "idWith") {
        //             $tempArr = ['key' => "id", 'val' => $value, 'op' => 'startsWith'];
        //         } else if ($key == "payment_channel") {
        //             $tempArr = ['key' => 'payment_channel', 'val' => "'$value'", 'op' => 'json unquote', 'node' => '$[0]'];
        //         } else if ($key == "user_id" || $key == "company_id") {
        //             if ($value == 'is null' || $value == 'is not null') {
        //                 $tempArr = ['key' => 'name', 'op' => 'is not null'];
        //                 array_push($accountFilter, $tempArr);
        //                 $tempArr = ['key' => $key, 'op' => $value];
        //             } else {
        //                 $tempArr = ['key' => $key, 'val' => $value];
        //             }
        //         } else {
        //             $tempArr = ['key' => $key, 'val' => $value];
        //         }
        //         array_push($accountFilter, $tempArr);
        //     }
        // }
        // return $accountFilter;
    }

    // --------------------------------------------------------------------------- //
    // --------------------- get single payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getPaClaim()
    {
        $id = $this->_request->id;
        $claimsReuslt =  $this->_fps->getPaClaim($id, $_SESSION["user_id"]);

        $claimsReuslt['create_date'] =  date_format(date_create($claimsReuslt['create_date']), "Y-m-d") . " " .
            date_format(date_create($claimsReuslt['create_date']), "H:i");


        parent::response($claimsReuslt);
    }

    // --------------------------------------------------------------------------- //
    // --------------------- get single pa project info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getPaProject()
    {
        $id = $this->_request->id;
        $paProjectBean = $this->_paRouteWageCore->getBasicPaProject($id, $_SESSION['user_id']);

        parent::response($paProjectBean);
    }



    // --------------------------------------------------------------------------- //
    // --------------------- get single payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchPaClaim()
    {
        try {
            $request = $this->_request;
            $request->pa_id = $_SESSION['pa_id'];
            $claimsReuslt =  $this->_fps->searchPaClaim($request, $_SESSION["user_id"]);

            //inject filter to clean data by ledger_account_id
            $accountFilter = new stdClass();
            $accountData =  $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);

            if ($accountData['found_rows'] == 0) {
                throw new Exception("لا تستطيع مشاهدة المطالبات");
            }
            $accountBean = $accountData['data'][0];
            foreach ($claimsReuslt['data'] as &$c) {
                if ($c['ledger_account_id'] != $accountBean['id']) {
                    $v = null;
                    continue;
                }
            }

            // fill extra info
            foreach ($claimsReuslt['data'] as &$claim) {

                // get the items and inject them 
                $paClaimItemFilter = new stdClass();
                $paClaimItemFilter->filter = ["claim_id" => $claim['id']];
                $paClaimItemFilter->filter = json_encode($paClaimItemFilter->filter);
                //$items = $this->_fps->searchPaClaimItems($paClaimItemFilter, $_SESSION['user_id']);
                $items = ['data'=>[] , 'found_rows'=>0];
                $num_of_waybills = $items['found_rows'];

                foreach ($items['data'] as $item) {
                    $requested_freight = json_decode($item['requested_freight']);
                    $claim['amount'] += $requested_freight->net_amount;
                }
                $claim['amount'] = number_format($claim['amount'], 3);
                $claim['num_of_waybills'] = $num_of_waybills;


                // get claim month
                if ($num_of_waybills > 0) {
                    $itemDetails = json_decode($items['data'][0]['details']);
                    $claimMonth = date("m", strtotime($itemDetails->loading_date));
                }

                // get the payee_reference name and claim month
                if (gettype($claim['payee_reference']) == "string") {
                    $payee_reference = json_decode($claim['payee_reference']);
                    $pa_project_id = $payee_reference->reference_value;
                }
                $paProjectFilter = [["key" => "id", "val" => $pa_project_id]];
                $paProjectReuslt = $this->_paRouteWageCore->searchPaProject($paProjectFilter, 1, 0, $_SESSION['user_id']);
                if ($paProjectReuslt->data[0]->name)
                    $claim['payee_reference_name'] = $paProjectReuslt->data[0]->name . ' - ' . 'عن شهر ' . $claimMonth;
                else
                    $claim['payee_reference_name'] = "-";
            }

            $dataResult = [];
            foreach ($claimsReuslt['data'] as $d) {
                if ($d) {
                    $dataResult[] = $d;
                }
            }

            $voucherResult['data'] = $dataResult;
            $voucherResult['found_rows'] = sizeOf($dataResult);

            parent::response($claimsReuslt);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- get single payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getPaClaimItem()
    {
        try {
            $result =  $this->_fps->getPaClaimItem($this->_request->id, $_SESSION["user_id"]);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- get multi payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchPaClaimItems()
    {
        try {
            $result =  $this->_fps->searchPaClaimItems($this->_request, $_SESSION["user_id"]);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // -------------- create payment agent advance payment claim ----------------- //
    // --------------------------------------------------------------------------- //
    public function createPaAdvancePaymentClaim()
    {
        try {

            DBConnection::startTransaction();

            // get user params
            $data = new stdClass();
            $data->pa_id = $_SESSION['pa_id'];
            $data->reference = new stdClass();
            $data->reference->reference_code = $this->_request->reference_code;
            $data->reference->reference_value = $this->_request->ref_value;
            $data->advance_payment_amount = $this->_request->advance_payment_amount;
            $data->pa_project_id = $this->_request->pa_project_id;
            $data->bond_number = $this->_request->bond_number;
            $data->notes = $this->_request->notes;
            $recipient_name = $this->_request->recipient_name ? $this->_request->recipient_name : "";
            $notes = $this->_request->notes;
            $selected_account_box = $this->_request->selected_account_box;

            // TODO: multi claim for the same bond flag, should be stored in pa_project
            // if the flag is true then allow it here , else throw exception

            // validate if the the same bond number has NEW claim 
            $filter = [];
            $filter['reference_code'] = "BOND_NUMBER";
            $filter['reference_value'] = $this->_request->ref_value;
            $filter['pa_project_id'] = $this->_request->pa_project_id;
            $filter['status'] = "NEW";
            $paClaimItemFilter = new stdClass();
            $paClaimItemFilter->filter = json_encode($filter);
            $paClaimItemFilter->pa_id = $_SESSION['pa_id'];
            $claims = $this->_fps->searchPaClaim($paClaimItemFilter, $_SESSION['user_id']);
            if ($claims['found_rows'] > 0) {
                throw new Exception("لا تستطيع المتابعة ، الإرسالية لديها سلفة غير مسددة");
            }

            // call fps system to append item to claim
            $pa_claim_id = $this->_fps->createPaAdvancePaymentClaim($data, $_SESSION["user_id"]);

            // get the cash downpayment trx template
            $pa_project_id = $this->_request->pa_project_id;
            $paProjectBean = $this->_paRouteWageCore->getBasicPaProject($pa_project_id, $_SESSION['user_id']);
            $trx_templates = $paProjectBean->trx_template;
            foreach ($trx_templates as $template) {
                if ($template->code == 'DOWNPAYMENT') {
                    $trx_template = $template->template;
                }
            }

            // prepare the sourceAccountBean
            $sourceAccountBean = $this->_fps->getAccountBasic($selected_account_box, $_SESSION['user_id']);

            // generate the trx (freight amounts + commission + notes to be logged)
            $frieght = null;
            $item = [];
            $item['tn'] = $this->_request->ref_value;
            $item['driver_name'] = $this->_request->recipient_name;
            $payment = new stdClass();
            $payment->value = $this->_request->advance_payment_amount;
            $trx = $this->_voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $payment, $frieght, $item);

            // create voucher
            $voucherData = new stdClass();
            $voucher_amount = 0;
            foreach ($trx as $trx_row) {
                if ($trx_row['source_account']) {
                    $voucher_amount = $trx_row['amount'];
                }
            }
            if ($voucher_amount == 0) {
                throw new Exception("لا تستطيع المتابعة قيمة أمر الصرف غير صحيحة");
            }

            // authority object
            $authority = new stdClass();
            $authority->source_account_id = $sourceAccountBean['id'];
            $authority->source_sub_id = $sourceAccountBean['sub_id'];
            $voucherData->authority = $authority;

            // destination object
            $destination = new stdClass();
            $destination->user_id =  $this->_request->recipient_user_id;
            $destination->company_id =  null;   // TODO: in case the recipients is a company
            $destination->is_beneficiary = 1;
            $voucherData->voucher_destination[] = $destination;

            // jv_template array
            $jv_template = [];
            $jv_template['code'] = "CASH_DOWNPAYMENT";
            $jv_note = new stdClass();
            $jv_note->notes = $notes;
            $jv_note->text = "jv_note";
            $jv_template['jv_note'] = $jv_note;
            $jv_template['trx_template'] = $trx;

            $voucher_note = new stdClass();
            $voucher_note->text = $jv_note;
            $jv_template['voucher_note'] = $voucher_note;

            $voucherData->jv_template = $jv_template;
            $voucherData->amount = $voucher_amount;
            $voucherData->payment_method_code = "CASH"; //TODO

            $voucherData->recipient_name = $recipient_name;
            $voucherData->pa_id = $_SESSION['pa_id'];

            $voucherData->integration_details = new stdClass();
            $voucherData->integration_details->activity = [];
            $voucherData->integration_details->claim_details = new stdClass();
            $voucherData->integration_details->claim_details->id = $pa_claim_id;

            // create voucher
            $voucher_id = $this->_fps->createVoucher($voucherData, $_SESSION['user_id']);


            if (!is_numeric($voucher_id)) {
                throw new Exception("خطأ في اضافة أمر الصرف");
            }

            // process voucher to insert the jv trx
            $processVoucherData = new stdClass();
            $processVoucherData->voucher_id = $voucher_id;
            $r = $this->_fps->processVoucherTrx($processVoucherData, $_SESSION['user_id']);

            // return result to user
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['VOUCHER_ID'] = $voucher_id;
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // --------------------- get multi payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function appendItemToClaim()
    {
        try {

            DBConnection::startTransaction();

            // get user params
            $pa_project_id = $this->_request->ref_value;
            $selected_account_box = $this->_request->selected_account_box;
            $late_fine = $this->_request->late_fine;

            // get needed objects
            $paProjectBean = $this->_paRouteWageCore->getBasicPaProject($pa_project_id, $_SESSION['user_id']);

            // prepare claim item data
            $data = new stdClass();
            $data->pa_id = $_SESSION['pa_id'];
            $data->reference = new stdClass();
            $data->reference->reference_code = "PA_PROJECT";
            $data->reference->reference_value = $this->_request->ref_value;            
            $data->claim_amount = $this->_request->claim_amount;
            $data->company_name = $_SESSION['company_name'];
            $data->destination_id = $this->_request->destination_id;
            $data->discharge_date = $this->_request->discharge_date;
            $data->loading_date = $this->_request->loading_date;
            $data->arrival_date = $this->_request->arrival_date;
            $data->origin_id = $this->_request->origin_id;
            $data->tn = $this->_request->tn;
            $data->ct_id = $this->_request->ct_id;
            $data->ref_num = $this->_request->ref_num;
            $data->cargo_name = $this->_request->cargo_name;
            $data->item_loading_weight = $this->_request->item_loading_weight;
            $data->item_discharge_weight = $this->_request->item_discharge_weight;
            $data->item_loading_date = $this->_request->item_loading_date;
            $data->item_discharge_date = $this->_request->item_discharge_date;
            $data->item_discharge_arrive_date = $this->_request->item_discharge_arrive_date;
            $data->destination_id = $this->_request->destination_id;
            $data->destination_name = $this->_request->destination_name;
            $data->origin_name = $this->_request->origin_name;
            $data->requested_freight = $this->_request->requested_freight;
            $data->recipient_name = $this->_request->recipient_name ? $this->_request->recipient_name : "";
            $data->pa_project_id = $pa_project_id;
            $data->pa_project_name = $paProjectBean->name;

            $recipient_nn = $this->_request->recipient_nn ? $this->_request->recipient_nn : "";
            $recipient_user_id = $this->_request->recipient_user_id ? $this->_request->recipient_user_id : null;
            $other_fine_amount = $this->_request->other_fine_amount ? $this->_request->other_fine_amount : null;
            $other_fine_note = $this->_request->other_fine_note ? $this->_request->other_fine_note : null;
            $data->claim_amount = "To be defined in fps from trx template";


            // get pa route wage
            $routeWage = $this->_paRouteWageCore->searchPaRouteWageForFreight(
                $pa_project_id,
                $_SESSION['pa_id'],
                $this->_request->origin_id,
                $this->_request->destination_id,
                $this->_request->loading_date,
                $_SESSION['user_id']
            );

            // calculate freight
            $waybillBean = new stdClass();
            $waybillBean->document = new stdClass();
            $waybillBean->document->freight = null;
            $waybillBean->document->tender = new stdClass();
            $waybillBean->document->tender->id = null;
            $waybillBean->document->negotiable_instructios = new stdClass();
            $waybillBean->document->negotiable_instructios->route = new stdClass();
            $waybillBean->document->negotiable_instructios->route->destination = new stdClass();
            $waybillBean->document->negotiable_instructios->route->destination->id = $this->_request->destination_id;
            $frieght = $this->_paymentCore->calculateFreight($waybillBean, $this->_request->item_discharge_weight, $this->_request->item_loading_weight, $routeWage, null);
            $frieght = $frieght->amount;

            // calculate late_fine if exists            
            if ($late_fine) {
                $frieght->late_fine = $late_fine;
                $frieght->total_fine += $late_fine;
                $frieght->net_amount = $frieght->net_amount - $late_fine;
            }
          
            // calculate other fines if exists
            if ($other_fine_amount) {
                $frieght->other_fine_amount = $other_fine_amount;
                $frieght->total_fine += $other_fine_amount;
                $frieght->net_amount = $frieght->net_amount - $other_fine_amount;
            }

            // calculate advance payment
            $claim_advance_payment_value = $this->_paymentCore->calculateClaimAdvancePayment($this->_request->ref_num, $_SESSION['pa_id'], $_SESSION['user_id']);
            $frieght->total_advance_payment = $frieght->total_advance_payment + $claim_advance_payment_value;
            $frieght->net_amount = $frieght->net_amount - $claim_advance_payment_value;

            // get the "WAYBILL_COMPLETE" trx template from the pa_project
            $trx_templates = $paProjectBean->trx_template;
            foreach ($trx_templates as $template) {
                if ($template->code == 'WAYBILL_COMPLETE') {
                    $trx_template = $template->template;
                }
            }
            if(!$trx_template){
                throw new Exception("Error , no WAYBILL_COMPLETE trx template was found for this project");                
            }

            // prepare the sourceAccountBean 
            $sourceAccountBean = $this->_fps->getAccountBasic($selected_account_box, $_SESSION['user_id']);

            // generate the voucher trx (freight amounts + commission + notes to be logged)
            $item = [];
            $item['tn'] = $data->tn;
            $item['ct_id'] = $data->ct_id;
            $item['origin_id'] = $data->origin_id;
            $item['cargo_name'] = $data->cargo_name;
            $item['claim_type'] = "AR_claim";
            $item['origin_name'] = $data->origin_name;
            $item['loading_date'] = $data->loading_date;
            $item['policy_number'] = $data->policy_number;
            $item['destination_id'] = $data->destination_id;
            $item['discharge_date'] = $data->discharge_date;
            $item['loading_weight'] = $data->loading_weight;
            $item['destination_name'] = $data->destination_name;
            $item['discharge_weight'] = $data->discharge_weight;
            $item['recipient_name'] = $data->recipient_name;
            $item['pa_project_id'] = $data->pa_project_id;
            $item['pa_project_name'] = $data->pa_project_name;
            $trx = $this->_voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $paProjectBean->details->payment, $frieght, $item);
 
            // create voucher
            $voucherData = new stdClass();
            
            // authority object
            $authority = new stdClass();
            $authority->source_account_id = $sourceAccountBean['id'];
            $authority->source_sub_id = $sourceAccountBean['sub_id'];
            $voucherData->authority = $authority;

            // destination object
            $destination = new stdClass();
            $destination->user_id =  $this->_request->recipient_user_id;
            $destination->company_id =  null;   // TODO: in case the recipients is a company
            $destination->is_beneficiary = 1;
            $voucherData->voucher_destination[] = $destination;

            // jv_template array
            $jv_template = [];
            $jv_template['code'] = "WAYBILL_COMPLETE";
            $jv_note = new stdClass();
            $jv_note_string = $trx[0]->trx_note->text;
            $tn = $item['tn'];
            $loading_weight = $frieght->loading_weight;
            $discharge_weight = $frieght->discharge_weight;
            $cargo_name = $item['cargo_name'];
            $origin_name = $item['origin_name'];
            $destination_name = $item['destination_name'];
            $jv_note_string = " مستحقات رحلة الشاحنة $tn ، وزن التحميل: $loading_weight - التفريغ: $discharge_weight ، الحمولة: $cargo_name ، المسار: $origin_name - $destination_name ";
            $jv_note->text = "jv_note";
            $jv_template['jv_note'] = $jv_note_string;
            $jv_template['trx_template'] = $trx;

            $voucher_note = new stdClass();
            $voucher_note->text = $jv_note_string;
            $jv_template['voucher_note'] = $voucher_note;
 
            $voucherData->jv_template = $jv_template;
            $voucherData->payment_method_code = strtoupper($sourceAccountBean['payment_channel'][0]);
            $voucherData->recipient_name = $this->_request->recipient_name;
            $voucherData->recipient_user_id = $recipient_user_id;
            $voucherData->recipient_nn = $recipient_nn;
            $voucherData->pa_id = $_SESSION['pa_id'];

            // add claim integration details
            $voucherData->integration_details = new stdClass();
            $voucherData->integration_details->claim_item = $data;
 
            // create voucher
            $voucher_id = $this->_fps->createVoucher($voucherData, $_SESSION['user_id']);
            if (!is_numeric($voucher_id)) {
                throw new Exception("خطأ في اضافة أمر الصرف");
            }
            // $voucher_id = 2140057553;
 
            // process voucher to insert the jv trx in case the payment method of the source account is cash
            if($voucherData->payment_method_code == "CASH"){
                $processVoucherData = new stdClass();
                $processVoucherData->voucher_id = $voucher_id;
                $this->_fps->processVoucherTrx($processVoucherData, $_SESSION['user_id']);
            }


            // close the advance claim if exists
            //$this->_paymentCore->closeClaimAdvancePayment($this->_request->ref_num, $_SESSION['pa_id'], $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return result to user
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['VOUCHER_ID'] = $voucher_id;
            $Result['PA_PROJECT_ID'] = $data->pa_project_id;
            //$Result['CLAIM_ITEM_ID'] = $processResult['pa_claim_item_id'];
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);

        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }



    // --------------------------------------------------------------------------- //
    // --------------------- get multi payment agent claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchPaAvailableClaims()
    {
        try {

            $data = new stdClass();
            $data->pa_id = $_SESSION['pa_id'];

            $result =  $this->_fps->searchPaAvailableClaims($data, $_SESSION["user_id"]);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- change pa claim status  --------------------- //
    // --------------------------------------------------------------------------- //
    public function changePaClaimStatus()
    {
        try {

            $data = new stdClass();
            $data->claim_id = $this->_request->claim_id;
            $data->new_status = $this->_request->new_status;
            $this->_fps->changePaClaimStatus($data, $_SESSION["user_id"]);

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';

            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- change pa claim item status from new to inactive  ------------------------ //
    // --------------------------------------------------------------------------- //
    public function changePaClaimItemStatus()
    {
        try {
            $data = new stdClass();
            $data->item_id = $this->_request->item_id;
            $data->new_status = $this->_request->new_status;
            $this->_fps->changePaClaimItemStatus($data, $_SESSION["user_id"]);

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';

            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------------- //
    // ------------------ Generate trx temaplate to be used in pa project ---------------------------------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    public function generateVoucherTemplate()
    {
        $q = 'select 
                code,
                name,
                description,
                CAST(`amount_calculation_method` AS CHAR CHARSET UTF8) AS amount_calculation_method ,
                CAST(`trx_templates` AS CHAR CHARSET UTF8) AS trx_templates,
                CAST(`commission` AS CHAR CHARSET UTF8 ) as commission,
                status
                from voucher_type
            ';
        $result = DBConnection::runDatabaseQuery($q);
        $res = [];

        foreach ($result as  $value) {
            $code = $value->code;
            $name  = $value->name;
            $value->trx_templates = json_decode($value->trx_templates);
            foreach ($value->trx_templates as  $temp) {
                foreach (get_object_vars($temp->template) as $key => $account) {
                    $caption = $account->caption;
                    $data = new stdClass();
                    $data->filter = ["tree_type" => $account->allowed_account, "status" => "ACTIVE"];
                    $data->filter = json_encode($data->filter);
                    $acc = $this->_fps->searchAccount($data, $_SESSION["user_id"]);
                    $array[$key] = [];
                    $test = [];

                    foreach ($acc["data"] as $subAcc) {
                        $newObj = new stdClass();
                        $newObj->label = $subAcc["name"];
                        $newObj->value = $subAcc["sub_id"];
                        $test[] =  $newObj;
                        $array[$key]["caption"] = $caption;
                        $array[$key]["type"] = $key;
                    }
                    $array[$key]["list"] = $test;
                    $final = new stdClass();
                    $final->code = $code;
                    $final->name = $name;
                    $final->trx =  $array;
                }
                $res[] = $final;
            }
        }
        parent::response($res);
    }


    // --------------------------------------------------------------------------- //
    // --------------------- changeItemVoucherStatus  ------------------------ //
    // --------------------------------------------------------------------------- //
    public function changeItemVoucherStatus()
    {
        try {
            $item_id = $this->_request->item_id;
            $note  = $this->_request->remarks;
            $new_status = "INACTIVE";
            DBConnection::startTransaction();
            $paClaimItemFilter = new stdClass();
            $paClaimItemFilter->filter = ["id" => $item_id];
            $paClaimItemFilter->filter = json_encode($paClaimItemFilter->filter);
            $items = $this->_fps->searchPaClaimItems($paClaimItemFilter,  $_SESSION['user_id']);
            $voucher_id = $items['data'][0]['voucher_id'];
            $total_advance_payment = json_decode($items["data"][0]['requested_freight'])->total_advance_payment;
            // get voucher
            $filter = ['id' => $voucher_id];
            $data = new stdClass();
            $data->filter = json_encode($filter);
            $voucherResult = $this->_fps->searchVouchers($data,  $_SESSION['user_id']);
            // fetch jv_id 
            $jv_id = $voucherResult["data"][0]["jv_id"];
            if ($total_advance_payment > 0) {
                throw new Exception("لا تستطيع حذف الوصل ,بسبب وجود سداد سلفة على الشاحنة");
            }
            //prep item bean
            $itemBean = new stdClass();
            $itemBean->item_id = $item_id;
            $itemBean->new_status = $new_status;
            // change item status
            $this->_fps->changePaClaimItemStatus($itemBean, $_SESSION["user_id"]);
            //prep voucher bean
            $voucherBean = new stdClass();
            $voucherBean->voucher_id = $voucher_id;
            $voucherBean->new_status = $new_status;
            // change voucher status
            $this->_fps->changeVoucherStatus($voucherBean, $_SESSION["user_id"]);
            $jv_data = new stdClass();
            $jv_data->jv_id = $jv_id;
            $jv_data->note = $note;
            $this->_fps->undoJV($jv_data, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }
}

new PaClaims_interface();
