<?php

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/config.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../../core/voucher/voucher_core.php");
require_once (dirname(__FILE__)."/../../core/account/account_core.php");
require_once (dirname(__FILE__)."/../../core/notes/add_notes_core.php");
require_once (dirname(__FILE__)."/../../core/taskQueues/taskQueues_core.php");
require_once (dirname(__FILE__)."/../../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../../core/tender/tender_core.php");


class Zain_Cash {    
 
    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for MG-Registrar System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken(){

        // TODO : call database to get this token
        return "5Ju2KWu7LLK5nY9GnnvUcQWrknR8sMLj7gXYnSkwpLgKKpQsjzsVHCLFkygZqfKq";

    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------ start the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function processVoucherTrx($voucher_id, $notes, $user_id){

        $voucherCore = new VoucherCore();
        $addNoteCore = new Add_notes_core();
        $tenderCore = new TenderCore();
        $waybillCore = new WaybillCore();

        // get the wallet_id of the voucher
        $voucherBean = $voucherCore->getVoucherBasic($voucher_id,$user_id);
        if($voucherBean->trx_template->ref_code == "WAYBILL" || $voucherBean->trx_template->ref_code == "WAYBILL_COMPLETE" ){
            $waybill_id = $voucherBean->trx_template->ref_id;
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
            $tender_id = $waybillBean->tender_id;        
            $man = $tenderCore->getTenderManifest($tender_id, 0);
            $wallet_id = $man['freight']['payment_method']['wallet_id'];
        }else{
            // get wallet_id from voucher
            $wallet_id = $voucherBean->trx_template->payment->wallet_id;
        }

        if(!$wallet_id){
            throw new Exception("wallet_id is not defined");            
        }

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"processTrx", 
            'private_key'=> md5($voucher_id),
            'wallet_id' => $wallet_id,
            'note' => $notes
        );

        // call the remote endpoint        
        try{            
            $response = $this->curl($url,$fields);

            $response = $response['RESULT'];
            
            $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
            $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];

            if(strtoupper($response['ErrorObj']['ErrorCode']) == "SUCCESS"){
                // update voucher
                $new_act = new stdClass();
                $new_act->ref_id = $response['RefID'];
                $new_act->code = "تم ارسال الطلب لنظام زين كاش , الرقم المرجعي : " . $response['RefID'];
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;
                $voucherBean->integration_details = $integration_details;
               
                $voucherCore->updateVoucherInfo($voucherBean , $voucher_id, 0);

                // change status to CLOSED
                $voucherCore->changeStatus($voucher_id,'CLOSED',0);

                // create JCB task
                $taskQueuesCore = new TaskQueuesCore();
                $taskQueuesCore->createCompleteZainCashTask($voucher_id, $response['RefID'],1,120);
            }
            else {
                throw new Exception("Error Processing Trx", 999);                
            }
        }
        catch(Exception $e){
            if($e->getCode() == 999){

                $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                $new_act = new stdClass();
                $new_act->code = "Error in Zain Cash Server, please contact support - " . $e->getMessage();
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;
                $voucherBean->integration_details = $integration_details;
                $voucherCore->updateVoucherInfo($voucherBean , $voucher_id, 0);

                $voucherCore->changeStatus($voucher_id, "INCOMPLETE" ,0);

            }else{

                // in case the response is timeout based exception , create watcher                
                $accountCore = new AccountCore();
                $voucherBean = $voucherCore->getVoucherBasic($voucher_id,0);
                $target_account = $voucherBean->trx_template->payment->target_account;
                if(!$target_account){
                    $target_account = $voucherBean->trx_template->target_account;
                }

                // create watcher
                $url = "api.minagate.com/pushTask";
                $data = ["private_key" =>  md5($voucher_id) , "voucher_id" => $voucher_id , "attempt" => 1 , "target_account" => $target_account];
                $fields = array(
                    'method'=>"pushTaskQueue",
                    'name' => $target_account  ,
                    'delay_seconds' => 60,
                    'data' => json_encode($data),
                    'handlerName' => "zainCashRequestHandler",
                    'queueName' => "zainCash-watcher",
                );
                $response = callcurl($url,$fields);
            }
        }
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------ check the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function checkVoucherTrx($private_key,$wallet_id){


        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"checkTrxResult", 
            'private_key'=> $private_key,
            'wallet_id'=> $wallet_id
        );
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        if($response['ERRORCODE'] != 200){
            throw new Exception($response['ERRORMSG'],999);
        }
        return $response;

    }


    // ----------------------------------------------------------------------------------- //
    // ------------------ get corportate transactions for financial reports -------------- //
    // ----------------------------------------------------------------------------------- //
    public function getCorpTransactions($wallet_id, $fromTime , $toTime , $mobile="" , $ref_id=""){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"getCorpTransactions", 
            'from_time'=> $fromTime,
            'to_time'=> $toTime,
            'mobile'=>$mobile,
            'ref_id'=>$ref_id,
            'wallet_id'=>$wallet_id
        );
 
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;

    }


    // ----------------------------------------------------------------------------------- //
    // ------------------ get corportate transactions for financial reports -------------- //
    // ----------------------------------------------------------------------------------- //
    public function getCorpSOATrx($wallet_id, $fromTime , $toTime , $mobile="" , $ref_id="", $user_id){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"getCorpSOATrx", 
            'from_time'=> $fromTime,
            'to_time'=> $toTime,
            'mobile'=>$mobile,
            'ref_id'=>$ref_id,
            'wallet_id'=>$wallet_id
        );

        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        // log into zc table
        try{
            $sql = "INSERT INTO `waybill`.`zc_transaction_log` (`ref_id`, `wallet_id`, `from_time`, `to_time`, `mobile`, `source`, `user_id`, `response`) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $param = [$ref_id, $wallet_id, $fromTime , $toTime, $mobile , "getCorpSOATrx", $user_id, json_encode($response,JSON_UNESCAPED_UNICODE)];
            $result = DBConnection::runBindDatabaseQuery($sql,$param);
        }catch(Exception $e){}


        return $response;

    }

    
    // ------------------------------------------------------------------------------------------ //
    // ------------------ check the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function getTransactions($wallet_id, $fromTime , $toTime , $mobile=null , $ref_id=null , $source="", $user_id=null){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"getTransactions", 
            'from_time'=> $fromTime,
            'to_time'=> $toTime,
            'mobile'=>$mobile,
            'ref_id'=>$ref_id,
            'wallet_id'=>$wallet_id
        );
        
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        // log into zc table
        try{
            $sql = "INSERT INTO `waybill`.`zc_transaction_log` (`ref_id`, `wallet_id`, `from_time`, `to_time`, `mobile`, `source`, `user_id`, `response`) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $param = [$ref_id, $wallet_id, $fromTime , $toTime, $mobile , $source, $user_id, json_encode($response)];
            $result = DBConnection::runBindDatabaseQuery($sql,$param);
        }catch(Exception $e){}


        return $response;
    }
    

    // ------------------------------------------------------------------------------------------ //
    // ------------------ check the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function getBalance($wallet_id){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"getBalance",
            'wallet_id' => $wallet_id
        );
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------ check the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function getUserWallet($mobile){

        $mobile = str_replace("+","",$mobile);
        $url = Config::$zain_cash_base_url . '/face';
 
        $fields = array(
            'method'=>"getUserWallet",
            'mobile'=>$mobile
        );

        // call the remote endpoint        
        $response = $this->curl($url,$fields);
 
        return $response;
    }

    // -------------------------------------------------------------- //
    // ------------------ search user wallet database  -------------- //
    // -------------------------------------------------------------- //
    public function searchUserWallet($phone, $create_date_from, $create_date_to){

        $mobile = str_replace("+","",$phone);
        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"searchUserWallet",
            'phone'=>$phone,
            'create_date_from'=>$create_date_from,
            'create_date_to'=>$create_date_to
        );

        // call the remote endpoint
        $response = $this->curl($url,$fields);

        return $response;
    }


    // ------------------------------------------------------------------- //
    // ------------------ transfer 1 fills to certain user  -------------- //
    // ------------------------------------------------------------------- //
    public function transferOneFills($mobile){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"transferOneFills",
            'mobile'=>$mobile
        );
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------ check the process of voucher trx using zain cash service -------------- //
    // ------------------------------------------------------------------------------------------ //
    public function updateUserWallet($ref_id , $status, $notes="-"){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"updateUserWallet",
            'ref_id'=>$ref_id,
            'status'=>$status,
            'trx_notes'=>$notes
        );
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;
    }

    
    // ------------------------------------------------------------------- //
    // ------------------ get list of inactive user wallets -------------- //
    // ------------------------------------------------------------------- //
    public function getInactiveUserWallets(){

        $url = Config::$zain_cash_base_url . '/face';
        $fields = array(
            'method'=>"getInactiveUserWallets"
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields);

        return $response;
    }



    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url,$fields){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'PUBLIC-KEY: '. $this->getIntegrationToken()
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch) , curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);

        if($http_code != 200){
            throw new Exception("Error Processing Request - http code: ". $http_code, 1);
        }

        $response = json_decode($result,1);
        if($response){
            return $response;
        }else{
            return $result;
        }
    }
 
}
