<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/DBR/dbr_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");

require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/FPS.php");


class Poll
{
    private $_waybillCore;
    private $_tenderCore;
    private $_DBRCore;
    private $_userCore;
    private $_fps;
    private $_queueCore;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_waybillCore = new WaybillCore();
        $this->_tenderCore = new TenderCore();
        $this->_userCore = new UserCore();
        $this->_DBRCore = new DBR_Core;
        $this->_fps = new FPS;
        $this->_queueCore = new QueueCore;
    }
    

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for MG-Registrar System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {

        // TODO : call database to get this token
        return "G4PJxPdzpeLdUdPnsbhDjMxnFSd4JHaBQEMebXKhN96VjcJnMTKgvVYatsbdj2wr";
    }

    // ---------------------------------------------------------------------- //
    // ----------------- search for certain polls ------------------------------- //
    // ---------------------------------------------------------------------- //
    public function getPoll($poll_id)
    {

        //  call remote system
        $url = Config::$poll_base_url . '/poll/' . $poll_id;
        $response = $this->curl($url,$fields, 'GET');

        return $response;
    }


    // ---------------------------------------------------------------------- //
    // ----------------- search for all polls ------------------------------- //
    // ---------------------------------------------------------------------- //
    public function searchPolls($pollFilter, $limit, $offset)
    {

        // prepare arguments
        $fields = array(
            'filters' => $pollFilter,
            'limit' => $limit,
            'offset' => $offset
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }

    // ---------------------------------------------------------------------- //
    // ----------------- search for user polls ------------------------------- //
    // ---------------------------------------------------------------------- //
    public function getUserPolls($pollFilter, $limit, $offset, $user_id)
    {

        // prepare arguments
        $fields = array(
            'filters' => $pollFilter,
            'limit' => $limit,
            'offset' => $offset,
            'user_id' => $user_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }

    // --------------------------------------------------------------------------- //
    // ----------------- Get page key for certain poll and recipient ------------- //
    // --------------------------------------------------------------------------- //
    public function getPageKey($pageFilter, $user_id)
    {
        // prepare arguments
        $fields = array(
            'filters' => $pageFilter,
            'user_id' => $user_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/recipient';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }
    


    // ---------------------------------------------------------------------- //
    // ----------------- search for user polls ------------------------------- //
    // ---------------------------------------------------------------------- //
    public function getActivePollsForUser($pollFilter, $limit, $offset, $user_id)
    {

        // prepare arguments
        $fields = array(
            'filters' => $pollFilter,
            'limit' => $limit,
            'offset' => $offset,
            'user_id' => $user_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/users_polls';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }


    // ------------------------------------------------- //
    // --------------- create new poll ----------------- //
    // ------------------------------------------------- //
    public function createPoll($pollBean)
    {

        if(gettype($pollBean) == 'array'){
            $pollBean['title'] = $pollBean['details']['attributes']['title'];
        }else{
            $pollBean->title = $pollBean->details->attributes->title;
        }
        

        //  call remote system
        $url = Config::$poll_base_url . '/poll/create';
        $response = $this->curl($url, $pollBean, 'POST');

        return $response['data']['id'];
    }


    // ------------------------------------------------- //
    // --------------- appendRecipientToPoll ----------------- //
    // ------------------------------------------------- //
    public function appendRecipientToPoll($poll_id, $recipients)
    {


        // prepare arguments
        $fields = array(
            'poll_id' => $poll_id,
            'recipients' => $recipients
        );

        //  call remote system
        $url = Config::$poll_base_url . '/recipient/create_batch';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'POST');

        if($response['data'])
            return $response['data']['id'];
        else
            return $response['message'];
    }


    // ------------------------------------------------------------------------------- //
    // -------------------- log activity to a certain recipient poll ----------------- //
    // ------------------------------------------------------------------------------- //
    public function logActivity($recipient_id, $message, $activity_type = "REMOTE_INFO")
    {

        // prepare arguments
        $fields = array(
            'id' => $recipient_id,
            'activity_body' => $message,
            'activity_type' => $activity_type
        );

        //  call remote system
        $url = Config::$poll_base_url . '/recipient/add_activity';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'POST');

        return $response['data']['id'];
    }


    // ------------------------------------------------------------------------------- //
    // -------------------- log activity to a certain poll by user ----------------- //
    // ------------------------------------------------------------------------------- //
    public function logPollByUserActivity($poll_id, $message, $user_id)
    {

        // prepare arguments
        $fields = array(
            'poll_id' => $poll_id,
            'activity_body' => $message,
            'activity_type' => 'REMOTE_INFO',
            'user_id' => $user_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/recipient/add_activity';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'POST');

        return $response['data']['id'];
    }



    // ---------------------------------------------------------------------- //
    // ----------------- check active poll for certain user ----------------- //
    // ---------------------------------------------------------------------- //
    public function checkPoll($user_id)
    {

        // prepare arguments
        $filters = new stdClass();
        $filters->status = 'ACTIVE';
        $fields = array(
            'user_id' => $user_id,
            'filter' => $filters
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/next_poll_for_user';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }


    // -------------------------------------------------------- //
    // ----------------- publish certain poll ----------------- //
    // --------------------------------------------------------- //
    public function publishPoll($poll_id)
    {

        // prepare arguments
        $fields = array(
            'poll_id' => $poll_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/publish';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'POST');

        return $response;
    }


    // ------------------------------------------------------ //
    // ----------------- close certain poll ----------------- //
    // ------------------------------------------------------ //
    public function closePoll($poll_id)
    {

        // prepare arguments
        $fields = array(
            'poll_id' => $poll_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/close';
        $url .= '?' . http_build_query($fields);

        $response = $this->curl($url, $fields, 'POST');

        return $response;
    }


    // -------------------------------------------------------- //
    // ----------------- answer certain poll ----------------- //
    // --------------------------------------------------------- //
    public function answerPoll($poll_id, $answers, $user_id)
    {

        // prepare arguments
        $fields = array(
            'poll_id' => $poll_id,
            'answers' => $answers,
            'user_id' => $user_id
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/answer';
        $url .= '?' . http_build_query($fields);
 
        $response = $this->curl($url, $fields, 'POST');

        return $response;
    }


    // ---------------------------------------------------------------------- //
    // ----------------- search for all polls ------------------------------- //
    // ---------------------------------------------------------------------- //
    public function getPollsForTenderOrder($pollFilter)
    {

        // prepare arguments
        $fields = array(
            'filters' => json_encode($pollFilter),
        );

        //  call remote system
        $url = Config::$poll_base_url . '/poll/report';
        $url .= '?' . http_build_query($fields);
        $response = $this->curl($url, $fields, 'GET');

        return $response;
    }


    public function getPollStatus($tender_order_id)
    {

        // init objects
        $waybillOrderCore = new WaybillOrderCore();

        // Get Polls ids
        $waybillOrders = $waybillOrderCore->searchWaybillOrder([["key" => "tender_order_id", "val" => $tender_order_id]], 1000, 0, $_SESSION['user_id'])->data;

        $pollIds = [];
        foreach ($waybillOrders as $waybillOrder) {
            if ($waybillOrder->poll_id)
                $pollIds[] = intval($waybillOrder->poll_id);
        }
        // Prepare filters
        $filters = new stdClass();
        $filters->poll_id = $pollIds;
        // get polls for certain date
        $pollBean = $this->getPollsForTenderOrder($filters);
        // if there is no polls return
        if ($pollBean == '[]') {
            return;
        }

        // get polls ids, user_ids, and beans
        $poll_ids = [];
        $polls = array();
        $user_ids = [];
        foreach ($pollBean as $poll_details) {
            $polls[$poll_details['poll_id']] = $poll_details;
            $poll_ids[] = $poll_details['poll_id'];
            $user_ids[] = $poll_details['user_id'];
        }

        // search for waybill orders
        $poll_ids = implode(',', $poll_ids);
        $waybill_orders_query = "
            select
                w.poll_id,
                w.id,
                w.contact_name,
                w.contact_phone,
                w.tn,
                w.status,
                w.queue_id,
                r.user,
                r.dur
                from waybill_order_view as w
                inner join waybill_order_01_report as r
                on
                w.id = r.id
            where
                w.tender_order_id = $tender_order_id
        ";
        $waybill_order_list = DBConnection::runDatabaseQuery($waybill_orders_query);
        // search users HB
        $user_ids = implode(',', $user_ids);
        $sqlQuery = "select cast( hb as char charset utf8) as hb , user_id from user_hb where user_id in ($user_ids)";
        $heartBeat =  DBConnection::runDatabaseQuery($sqlQuery);
        $users_hb = array();
        foreach ($heartBeat as $user) {
            if ($user->hb !== '{}') {
                $users_hb[$user->user_id] = json_decode($user->hb)[0];
            }
        }

        // collect data from polls and waybill_orders together
        $waybill_orders_result = [];
        foreach ($waybill_order_list  as $k =>  $waybill_order) {
            $id = $waybill_order->poll_id;
            $temp = new stdClass();
            $temp->id = $waybill_order->id;
            $temp->contact_name = ($waybill_order->contact_name != 'null' ? $waybill_order->contact_name : '');
            $temp->tn = $waybill_order->tn;
            $temp->status = $waybill_order->status;
            $temp->contact_phone = ($waybill_order->contact_phone != 'null' ? $waybill_order->contact_phone : '');
            $temp->notification_sent = ($polls[$id]['notification_sent'] ? 'نعم' : 'لا');
            $temp->sms_sent = $polls[$id]['sms_sent'] ? 'نعم' : 'لا';

            if (!$polls[$id]) {
                $waybill_order->user = "employee";
            }

            if (in_array($waybill_order->tn, ["NULL", "null", false, null]) && in_array($waybill_order->status, ["APPROVED", "CLOSED"])) {
                $temp->answer_method = 'عجز';
            } elseif ($waybill_order->user == 'cc') {
                $temp->answer_method = 'اتصال الي';
            } else if ($waybill_order->user == 'mobile') {
                if (!$waybill_order->queue_id) {
                    $temp->answer_method = "portal";
                } elseif ($polls[$id]['answered_on_browser']) {
                    $temp->answer_method = 'sms';
                } else {
                    $temp->answer_method = 'تطبيق';
                }
            } else {
                $temp->answer_method =  'موظف اتصال';
            }
            $temp->duration = $waybill_order->dur ? gmdate('H:i:s', $waybill_order->dur) : '';
            $temp->viewed_on_mobile = $polls[$id]['viewed_on_mobile'] ? 'نعم' : 'لا';
            $temp->viewed_on_browser = $polls[$id]['viewed_on_browser'] ? 'نعم' : 'لا';
            $temp->app_version = $users_hb[$polls[$id]['user_id']]->app_version;
            $temp->poll_id = $id;
            array_push($waybill_orders_result, $temp);
        }

        return $waybill_orders_result;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 40);
        curl_setopt($ch, CURLOPT_ENCODING, "");
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields, JSON_UNESCAPED_UNICODE));
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type:application/json',
            'key: ' . $this->getIntegrationToken()
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }



    // ---------------------------------------------------------------------------------------- //
    // -------------------- Generate task to create new Poll of downpayment  ------------------ //
    // ---------------------------------------------------------------------------------------- //
    public function createDownpaymentPollTask($w_id){

        // create poll task
        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->createDownpaymentPollTask($w_id, 0);

    }

    // ------------------------------------------------------------------------------------ //
    // -------------------- Generate Poll of downpayment with recipients ------------------ //
    // -------------------- value: can be waybill_id or queue_id -------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function generateDownPaymentPoll($value , $source = "waybill")
    {
        // import other objects
        $truckOwnerCore = new TruckOwnerCore();

         // get needed info from waybill
        if($source == "waybill"){

            $waybill_id = $value;
            $waybillFilter = [['key' => 'id', 'val' => $waybill_id]];
            $waybill = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, 0)->data[0];
            $tn =  $waybill->tn;

        }else if($source == "queue"){

            $queue_id = $value;
            $queueFilter = [['key' => 'id', 'val' => $value]];
            $queueResult = $this->_queueCore->searchQueue($queueFilter, 1, 0,0);
            $tn =  $queueResult->data[0]->tn;
        }
 

        // validate if the truck meets the requirments to create new downpayment pull
        $this->validateDownpaymentPreRequestsForCreate($tn);
 
        // get tenderTruck info
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderSearchFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => "11"],
            ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
        $financial_manager_owner_id = $tenderTruckResult->data[0]->financial_manager_owner_id;

        // get the DBR value
        $DBR_amount = $this->_DBRCore->calculateWaybillDBR($tn, 11)["dbr_value"];

        // get financial manager phone
        $truckOwnerSearchFilter = [['key' => 'id', 'val' => $financial_manager_owner_id]];
        $truckOwnerBean = $truckOwnerCore->searchTruckOwner($truckOwnerSearchFilter, 1000, 0, 0);
        $phone_array = json_decode($truckOwnerBean->data[0]->phone_array);
        $truck_owner_phone = $phone_array[0]->phone;

        // search for all drivers on this truck in the last 6 months
        $date = date('Y-m-d h:m:s', strtotime("-6 month"));
        $last_six_month_filter = [
            ['key' => "create_date", 'val' => $date, 'op' => 'date greater than'],
            ['key' => "tn", 'val' => $tn, "op" => "="]
        ];
        $waybills = $this->_waybillCore->searchWaybills($last_six_month_filter, 1000, 0, 0)->data;
        $drivers_phones = [];
        $drivers = [];
        foreach ($waybills as $key => $value) {
            $doc = json_decode($value->document);
            $carr = $doc->carrier[0];
            $driver = $carr->driver;
            $driver_phone = $driver->phone;
            if ($driver_phone != $truck_owner_phone) {
                if (!in_array($driver_phone, $drivers_phones)) {
                    $drivers_phones[] = $driver_phone;
                    $drivers[] = $driver;
                }
            }
        }

        // check if the truck has service of downpayment in order to create the first message in the poll
        $services = json_decode($tenderTruckResult->data[0]->services);
        $bind_params = [];
        $bind_params['_$_PAYMENT_AMOUNT_$_'] =  $DBR_amount;
        $bind_params['_$_TN_$_'] = $tn;
        $bind_params['_$_WALLET_PHONE_NUMBER_$_'] = $truck_owner_phone;
        $params = new stdClass();
        $params->drivers = $drivers;
        $params->has_down_payment_service = false;
        if ($services != null) {
            foreach ($services as $key => $value) {
                if (strtoupper($value->service_code) == "DOWNPAYMENT") {
                    $params->has_down_payment_service = true;
                }
            }
        }
        $user_id = $truckOwnerBean->data[0]->user_id;
        $params->bind_params = $bind_params;
        $params->u_id = $user_id;
        $params->waybill_id = $waybill_id;
        $params->queue_id = $queue_id;

        // check if user does not have recipients record in the poll , then create a record
        $userBean = $this->_userCore->getUserBasic($user_id, 0);
        $params->notification_token = $userBean->notification_token;
        $params->phone = $userBean->phone;
        $params->recipients_name = $userBean->name;

        // generate json and save it in poll DB
        $poll_id = $this->ProcessPrePaymentPollJson($params);

        // activate the poll
        $this->publishPoll($poll_id);

        // create reminder task
        //$taskQueuesCore = new TaskQueuesCore();
        //$taskQueuesCore->createDownpaymentPollReminderTask(1, $userBean->id, $poll_id, 60);

    }



    // ---------------------------------------------------------------------------------------------------- //
    // the following pre-requests must be met in order to create downpayment poll
    // 1- Truck has DBR > 0
    // 2- Truck has Active FPS account
    // 3- Truck must have financial managaer
    // 4- Truck must have the service: DOWNPAYMENT
    // ---------------------------------------------------------------------------------------------------- //
    public function validateDownpaymentPreRequestsForCreate($tn){
  
        // Step1: calculate the DBR amount to be sent to user, if DBR_amount is 0 , skip everthing
        $DBR_amount = $this->_DBRCore->calculateWaybillDBR($tn, 11)["dbr_value"];
        if ($DBR_amount <= 0) {
            throw new Exception("قيمة DBR للشاحنة أقل من 0");
            return;
        }
       
        // Step2: get the truck fps account
        $ledger_account_id = 590000;

        $data = new stdClass();
        $data->filter = ["id" => $ledger_account_id,
                         "sub_id" => $tn, 
                         "status" => "ACTIVE"];
        $data->filter = json_encode($data->filter);
        $acc = $this->_fps->searchAccount($data, 0);
        if($acc['found_rows'] == 0){
            throw new Exception("لا يوجد حساب فعال للشاحنة" . $tn);
        }

        // Step3: get the finanicial manager owner id
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderSearchFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => "11"],
            ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
        $financial_manager_owner_id = $tenderTruckResult->data[0]->financial_manager_owner_id;
        if (!$financial_manager_owner_id) {
            throw new Exception("لا يوجد مدير مالي للشاحنة على المشروع");
            return;
        }

        // Step 4: get the tender truck service code : DOWNPAYMENT


    }

    // --------------------------------------------------------------------- //
    // -------------------- create new poll -------------------------------- //
    // --------------------------------------------------------------------- //
    public function ProcessPrePaymentPollJson($params)
    {

        $drivers = $params->drivers;
        $u_id = $params->u_id;
        $has_down_payment_service = $params->has_down_payment_service;
        $bind_params = $params->bind_params;
        $waybill_id = $params->waybill_id;
        $queue_id = $params->queue_id;

        $callBack = new stdClass();
        $details_json = new stdClass();
        $details_json->attributes = new stdClass();

        $data = new stdClass();
        $callBack->data = $data;
        $data->method = "createProcessDownpaymentPollAnswerTask";
        $data->user_id = $params->u_id;
        $callBack->type = "answer";
        $callBack->url = Config::$minagate_waybill_base_url . "/fps_voucher";

        $details_json->attributes->callback = [$callBack];
        $details_json->attributes->waybill_id = $waybill_id;
        $details_json->attributes->queue_id = $queue_id;
        $details_json->attributes->title = "إستبيان الدفعة المقدمة ";
        $details_json->attributes->is_dismissible = false;
        $details_json->attributes->expiry_date =   date('Y-m-d h:m:s', strtotime("+6 month"));;
        $details_json->attributes->can_change_answer = false;
        $details_json->attributes->max_retries = "1";
        $details_json->attributes->description = "لديك دفعة مقدمة جاهزة للإستلام";
        $details_json->attributes->notification_title = "الدفعة المقدمة";
        $details_json->attributes->priority = 5;
        $details_json->attributes->scenario = "normalScenario";
        $details_json->attributes->type = "poll";
        $details_json->attributes->sub_type = "DOWNPAYMENT";
        $details_json->questions = [];
        // first Question
        $question_1 = new stdClass();
        $question_1->question_attachment_url = null;
        $question_1->question_id = 0;

        $question_1->question_lable = "عناية ". $params->recipients_name . "\n";

        // if ($has_down_payment_service) {
        //     $question_1->question_lable .= 'لديك أمر حركة للشاحنة رقم : ' . $bind_params['_$_TN_$_'] . ', سيتم تحويل مبلغ   ' . $bind_params['_$_PAYMENT_AMOUNT_$_'] . ' دينار من مستحقاتك بشكل فوري إلى محفظتك الالكترونية (قبل التحميل), على ان يتم صرف فروقات الرحلة بعد التفريغ .';
        // } else {
        $question_1->question_lable .= 'استلم قيمة رحلتك الآن
        بإمكانك استلام مبلغ ' . $bind_params['_$_PAYMENT_AMOUNT_$_'] . ' دينار الآن فورا حيث أن لديك أمر حركة للشاحنة ' . $bind_params['_$_TN_$_'] . '
        تستطيع الإستفادة من الخدمة الآن واستلام مستحقات الرحلة عبر محفظتك الإلكترونية
        سيتم تحويل فروقات الرحلة بعد التفريغ';
        // }
        $question_1->question_type = "single";
        $question_1->validation =  new stdClass();
        $question_1->validation->method =  "none";
        // first Question answers
        $question_1->answers = [];
        // first answer
        $question_1_answer_1 = new stdClass();
        $question_1_answer_1->caption = "نعم أرغب";
        $question_1_answer_1->next_question = 2;
        $question_1_answer_1->value = "1";
        $question_1_answer_1->theme = "primary";
        $question_1->answers[] = $question_1_answer_1;
        //second answer
        $question_1_answer_2 = new stdClass();
        $question_1_answer_2->caption = "لا أرغب";
        $question_1_answer_2->next_question = 1;
        $question_1_answer_2->value = "0";
        $question_1_answer_2->theme = "outline";
        $question_1->answers[] = $question_1_answer_2;
        $details_json->questions[] = $question_1;

        ///////////////////////////////////////////////

        // first scenario  لا أرغب case !!!!
        $question_2 = new stdClass();
        $question_2->question_attachment_url = null;
        $question_2->question_id = 1;
        $question_2->question_lable = ' هل أنت متأكد من عدم الرغبة في استلام الدفعة المقدمة (قبل التحميل) للشاحنة رقم :' . $bind_params['_$_TN_$_'] . ' و قيمتها ' . $bind_params['_$_PAYMENT_AMOUNT_$_'] . ' دينار ';
        $question_2->question_type = "single";
        $question_2->validation =  new stdClass();
        $question_2->validation->method =  "none";
        // first Question answers
        $question_2->answers = [];
        // first answer
        $question_2_answer_1 = new stdClass();
        $question_2_answer_1->caption = "أرغب باستلام المبلغ";
        $question_2_answer_1->next_question = 2;
        $question_2_answer_1->value = "1";
        $question_2_answer_1->theme = "primary";
        $question_2->answers[] = $question_2_answer_1;
        //second answer
        $question_2_answer_2 = new stdClass();
        $question_2_answer_2->caption = "أنا متأكد ولا أرغب باستلام المبلغ";
        $question_2_answer_2->next_question = null;
        $question_2_answer_2->value = "0";
        $question_2_answer_2->theme = "outline";
        $question_2->answers[] = $question_2_answer_2;
        $details_json->questions[] = $question_2;


        // Second scenario  نعم أرغب case !!!!
        $question_3 = new stdClass();
        $question_3->question_attachment_url = null;
        $question_3->question_id = 2;
        $question_3->question_lable = 'المحفظة التي سيتم تحويل مبلغ  ' . $bind_params['_$_PAYMENT_AMOUNT_$_'] . ' عليها هي ' . $bind_params['_$_WALLET_PHONE_NUMBER_$_'] . '';
        $question_3->question_type = "single";
        $question_3->validation =  new stdClass();
        $question_3->validation->method =  "none";
        // first Question answers
        $question_3->answers = [];
        // first answer
        $question_3_answer_2 = new stdClass();
        $question_3_answer_2->caption = "نعم صحيح";
        $question_3_answer_2->next_question =  9;
        $question_3_answer_2->value =  "1";
        $question_3_answer_2->theme = "primary";

        $question_3->answers[] = $question_3_answer_2;
        $details_json->questions[] = $question_3;
        //second answer
        $question_3_answer_1 = new stdClass();
        $question_3_answer_1->caption = "غير صحيح";
        $question_3_answer_1->next_question = 7;
        $question_3_answer_1->value = "0";
        $question_3_answer_1->theme = "outline";
        $question_3->answers[] = $question_3_answer_1;



        // scenario نعم يوجد سائقين على الشاحنة case !!!!
        $question_4 = new stdClass();
        $question_4->question_attachment_url = null;
        $question_4->question_id = 3;
        $question_4->question_lable = 'توفر شركة مدارج خدمة دفع أجر السائق عبر اقتطاع المبلغ من قيمة الدفعة المقدمة (تكلفة هذه الخدمة 2 دينار), هل ترغب بإقتطاع اجرة السائق ؟ ';
        $question_4->question_type = "single";
        $question_4->validation =  new stdClass();
        $question_4->validation->method =  "none";
        // first Question answers
        $question_4->answers = [];
        // first answer
        $question_4_answer_1 = new stdClass();
        $question_4_answer_1->caption = " نعم أرغب";
        $question_4_answer_1->next_question = $drivers != 0 && $drivers != null && sizeof($drivers) > 0 ? 4 : 8;
        $question_4_answer_1->value = "1";
        $question_4->answers[] = $question_4_answer_1;
        //second answer
        $question_4_answer_2 = new stdClass();
        $question_4_answer_2->caption = "لا أرغب";
        $question_4_answer_2->next_question = 9;
        $question_4_answer_2->value = "0";
        $question_4->answers[] = $question_4_answer_2;
        $details_json->questions[] = $question_4;

        // scenario اختر السائق case !!!!
        $question_5 = new stdClass();
        $question_5->question_attachment_url = null;
        $question_5->question_id = 4;
                $question_5->question_lable = 'السائقين المبينة اسمائهم تاليا عملوا على الشاحة رقم : ' . $bind_params['_$_TN_$_'] . ', الرجاء اختيار السائق المراد تحويل المبلغ له ؟ ';
        $question_5->question_type = "single";
        $question_5->validation =  new stdClass();
        $question_5->validation->method =  "none";
        // first Question answers
        $question_5->answers = [];
        foreach ($drivers  as $key => $value) {
            // answers
            $question_5_answer_1 = new stdClass();
            $question_5_answer_1->caption = $value->name;
            $question_5_answer_1->next_question = 5;
            $question_5_answer_1->value = $value->id;
            $question_5->answers[] = $question_5_answer_1;
        }
        $question_5_answer_2 = new stdClass();
        $question_5_answer_2->caption = "سائق أخر";
        $question_5_answer_2->next_question = 6;
        $question_5_answer_2->value = "other";
        $question_5->answers[] = $question_5_answer_2;

        $details_json->questions[] = $question_5;

        // scenario اختر السائق case !!!!
        $question_6 = new stdClass();
        $question_6->question_attachment_url = null;
        $question_6->question_id = 5;
        $question_6->question_lable = ' الرجاء قم بإدخال المبلغ المراد إقتطاعة';
        $question_6->question_type = "free_text";
        $question_6->validation =  new stdClass();
        $question_6->validation->method =  "remote";
        $question_6->validation->endpoint =  "https://api.minagate.com/poll?method=validateDriverWageAnswer";
        $question_6->validation->tn = $bind_params['_$_TN_$_'];
        // first Question answers
        $question_6->answers = [];

        $question_6_answer_2 = new stdClass();
        $question_6_answer_2->caption = "متابعة ";
        $question_6_answer_2->next_question = 10;
        $question_6_answer_2->value = "1";
        $question_6->answers[] = $question_6_answer_2;
        $details_json->questions[] = $question_6;

        // scenario اختر السائق case !!!!
        $question_7 = new stdClass();
        $question_7->question_attachment_url = null;
        $question_7->question_id = 6;
        $question_7->question_lable = 'الرجاء قم بإدخال رقم هاتف السائق المربوط على محفظته الإلكترونية';
        $question_7->question_type = "free_text";
        $question_7->validation =  new stdClass();
        $question_7->validation->method =  "none";
        // first Question answers
        $question_7->answers = [];

        $question_7_answer_2 = new stdClass();
        $question_7_answer_2->caption = "متابعة";
        $question_7_answer_2->next_question = 5;
        $question_7_answer_2->value = "0";
        $question_7->answers[] = $question_7_answer_2;

        $details_json->questions[] = $question_7;



        // scenario برقم المحفظة غير صحيح case !!!!
        $question_8 = new stdClass();
        $question_8->question_attachment_url = null;
        $question_8->question_id = 7;
        $question_8->question_lable = 'نعتذر .. لن يتمكن النظام من تحويل المبلغ لك, الرجاء مراجعة قسم العمليات, وتزويدنا برقم المحفظة الصحيح ';
        $question_8->question_type = "single";
        $question_8->validation =  new stdClass();
        $question_8->validation->method =  "none";
        // Question answers
        $question_8->answers = [];
        // first answer
        $question_8_answer_1 = new stdClass();
        $question_8_answer_1->caption = "إنهاء";
        $question_8_answer_1->next_question = null;
        $question_8_answer_1->value = "0";
        $question_8->answers[] = $question_8_answer_1;

        $question_8_answer_2 = new stdClass();
        $question_8_answer_2->caption = "عودة";
        $question_8_answer_2->next_question = 2;
        $question_8_answer_2->value = "0";
        $question_8->answers[] = $question_8_answer_2;
        $details_json->questions[] = $question_8;

        // scenario نعم يوجد سائقين على الشاحنة case !!!!
        $question_9 = new stdClass();
        $question_9->question_attachment_url = null;
        $question_9->question_id = 8;
                $question_9->question_lable = 'لم يعمل اي سائق غيرك على الشاحنة رقم ' . $bind_params['_$_TN_$_'] . ' خلال اخر 6 شهور , هل ترغب بإقتطاع جزء من المبلغ لسائق جديد ؟   ';
        $question_9->question_type = "single";
        $question_9->validation =  new stdClass();
        $question_9->validation->method =  "none";
        // first Question answers
        $question_9->answers = [];
        // first answer
        $question_9_answer_1 = new stdClass();
        $question_9_answer_1->caption = " انا متأكد و اريد اقتطاع المبلغ ";
        $question_9_answer_1->next_question =  6;
        $question_9_answer_1->value = "1";
        $question_9->answers[] = $question_9_answer_1;
        //second answer
        $question_9_answer_2 = new stdClass();
        $question_9_answer_2->caption = "لا أريد اقتطاع مبلغ ";
        $question_9_answer_2->next_question =  9;
        $question_9_answer_2->value = "0";
        $question_9->answers[] = $question_9_answer_2;
        $details_json->questions[] = $question_9;


        // scenario رسالة نعهد 1  case !!!!
        $question_10 = new stdClass();
        $question_10->question_attachment_url = null;
        $question_10->question_id = 9;
                $question_10->question_lable = ' اقر بأني الشخص المخول بإستلام اجور الشاحنة رقم ' . $bind_params['_$_TN_$_'] . '

        واوافق على إستلام مبلغ الدفعة المقدمة لرحلة الشاحنة .

        وأتعهد بتسليم وصل التحميل بعد انتهاء عملية التفريغ مباشرة  لمكتب شركة مدارج في الزرقاء، واتعهد بتحمل كامل المسؤولية القانونية. ';
        $question_10->question_type = "single";
        $question_10->validation =  new stdClass();
        $question_10->validation->method =  "none";
        // first Question answers
        $question_10->answers = [];

        $question_10_answer_1 = new stdClass();
        $question_10_answer_1->caption = "أتعهد ";
        $question_10_answer_1->next_question = null;
        $question_10_answer_1->value = "1";
        $question_10->answers[] = $question_10_answer_1;
        $details_json->questions[] = $question_10;

        // scenario رسالة نعهد 2  case !!!!
        $question_11 = new stdClass();
        $question_11->question_attachment_url = null;
        $question_11->question_id = 10;
                $question_11->question_lable = ' اقر بأني الشخص المخول بإستلام اجور الشاحنة رقم ' . $bind_params['_$_TN_$_'] . '

        وأوافق على إستلام مبلغ الدفع المقدم لرحلة الشاحنة , مع اقتطاع جزء من المبلغ وتسليمه كأجرة سائق و تحويله على محفظتة الخاصة

        وأتعهد بتسليم وصل التحميل بعد إنتهاء عملية التفريغ مباشرة لمكتب شركة مدارج في الزرقاء، واتعهد بتحمل كامل المسؤولية القانونية. ';
        $question_11->question_type = "single";
        $question_11->validation =  new stdClass();
        $question_11->validation->method =  "none";

        // first Question answers
        $question_11->answers = [];
        $question_11_answer_1 = new stdClass();
        $question_11_answer_1->caption = "أتعهد ";
        $question_11_answer_1->next_question = null;
        $question_11_answer_1->value = "1";
        $question_11->answers[] = $question_11_answer_1;
        $details_json->questions[] = $question_11;

        $details = [];
        $details['details'] = json_encode($details_json, JSON_UNESCAPED_UNICODE);
        $details['type'] = "POLL";
        $details['priority'] = 3;
            $rec = [];
            $rec['bind_params'] = json_encode($bind_params);
            $rec['user_id'] = $u_id;
            $rec['communication_channels'] = [];
            if($params->notification_token){
                $rec['communication_channels'][] = ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $params->notification_token], 'status' => 'ACTIVE', 'priority' => 1];
            }
            if($params->phone){
                $rec['communication_channels'][] = ['channel' => 'SMS', 'details' => ['phone_number' => $params->phone], 'status' => 'ACTIVE', 'priority' => 2];
            }
        
            $details['recipients'][] = $rec;
                
        $poll_id = $this->createPoll($details);
        return $poll_id;
    }
 
    // --------------------------------------------------------------------- //
    // -------------------- create new poll -------------------------------- //
    // --------------------------------------------------------------------- //
    public function GenerateDownPaymentFeedbackPoll($tn, $u_id)
    {

        $socialCore = new socialCore();
        
        
        $tn = $tn ;
        $bind_params = [];
        $bind_params['_$_TN_$_'] = $tn;

        $params = new stdClass();
        $params->bind_params = $bind_params;
        $params->u_id = $u_id;

        $pollFilter = new stdClass();
        $pollFilter = ['sub_type' => "feedback" , 'status' => 'ACTIVE'];
        $filter = json_encode($pollFilter);
        $pollReuslt = $this->searchPolls(
            $filter,
            1000,
            0
        );       
 
        if(gettype($pollReuslt) == "string"){
            $pollReuslt = json_decode($pollReuslt);
        };
        
        if (sizeof($pollReuslt) > 0) {
            $poll_id = $pollReuslt[0]["id"];
        } else {
            $poll_id = $this->GenerateDownPaymentFeedbackPollJson($params);
        }
        $user_id = $u_id;

        // get userBean
        $userBean = $this->_userCore->getUserBasic($user_id, 0);
 
        // check if user does not have recipients record in the poll , then create a record
        $recipients = [];
        $rec['user_id'] = $user_id;
        $rec['bind_params'] = $bind_params;
        $rec['communication_channels'] = [
            ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
            ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2]
        ];
        $recipients[] = $rec;
     
        $this->appendRecipientToPoll($poll_id, $recipients);

        // inform user
        $wall_message_title = null;
        $wall_message_body = null;
        $notification_title = "تقيم الخدمة";
        $notification_message = " نرغب بمعرفة مدى رضاك عن خدمة الدفعة المقدمة، ستجد استبيان التقييم عبر تطبيق مدارج" ;
        $socialCore->informUser($wall_message_title, $wall_message_body, $notification_title, $notification_message, $user_id);


    }


    // --------------------------------------------------------------------- //
    // -------------------- create new poll -------------------------------- //
    // --------------------------------------------------------------------- //
    public function GenerateDownPaymentFeedbackPollJson($params)
    {

        $bind_params = $params->bind_params;
        $u_id = $params->user_id;

        $details_json = new stdClass();
        $details_json->feedback_poll = true;
        $details_json->attributes = new stdClass();
        $details_json->attributes->callback = [];
        $details_json->attributes->sub_type = "feedback";
        $details_json->attributes->title = "إستبيان تقييم الدفعة المقدمة ";
        $details_json->attributes->is_dismissible = false;
        $details_json->attributes->expiry_date =   date('Y-m-d h:m:s', strtotime("+6 month"));;
        $details_json->attributes->can_change_answer = false;
        $details_json->attributes->max_retries = "1";
        $details_json->attributes->description = "تقييم الدفعة المقدمة";
        $details_json->attributes->notification_title = "تقييم الدفعة المقدمة";
        $details_json->attributes->priority = 5;
        $details_json->attributes->scenario = "normalScenario";
        $details_json->attributes->type = "poll";
        $details_json->questions = [];
        // first Question
        $question_1 = new stdClass();
        $question_1->question_attachment_url = null;
        $question_1->question_id = 0;
        $question_1->question_lable = 'من المهم جداً بالنسبة لنا في شركة مدارج تقديم خدمة مثالية للعملاء، بحيث جعلناها أحد القيم الأساسية لدينا. ولمساعدتنا في قياس إلتزامنا بهذه القيمة الرجاء تقييم خدمة الدفع المقدم للشاحنة رقم : _$_TN_$_
        ';
        $question_1->question_type = "single";
        $question_1->validation =  new stdClass();
        $question_1->validation->method =  "none";
        // first Question answers
        $question_1->answers = [];
        // first answer
        $question_1_answer_1 = new stdClass();
        $question_1_answer_1->caption = "ممتاز";
        $question_1_answer_1->next_question = 1;
        $question_1_answer_1->value = 5;
        $question_1_answer_1->theme = "primary";
        $question_1->answers[] = $question_1_answer_1;
        //second answer
        $question_1_answer_2 = new stdClass();
        $question_1_answer_2->caption = "متوسطة";
        $question_1_answer_2->next_question = 2;
        $question_1_answer_2->value = 2.5;
        $question_1_answer_2->theme = "primary";
        $question_1->answers[] = $question_1_answer_2;
        $details_json->questions[] = $question_1;
        //third answer
        $question_1_answer_3 = new stdClass();
        $question_1_answer_3->caption = "سيئة";
        $question_1_answer_3->next_question = 2;
        $question_1_answer_3->value = 0;
        $question_1_answer_3->theme = "primary";
        $question_1->answers[] = $question_1_answer_3;
        ///////////////////////////////////////////////

        // first scenario  جيدة case !!!!
        $question_2 = new stdClass();
        $question_2->question_attachment_url = null;
        $question_2->question_id = 1;
        $question_2->question_lable =
            'شكرا لكم على تقييم الخدمة حيث سيتم الإستفادة من تقييمك لتحسين خدماتنا مستقبلا .

نحن نتطلع إلى العمل معكم في الرحلة القادمة';
        $question_2->question_type = "single";
        $question_2->validation =  new stdClass();
        $question_2->validation->method =  "none";
        // first Question answers
        $question_2->answers = [];
        // first answer
        $question_2_answer_1 = new stdClass();
        $question_2_answer_1->caption = "انهاء";
        $question_2_answer_1->next_question = null;
        $question_2_answer_1->value = 0;
        $question_2_answer_1->theme = "primary";
        $question_2->answers[] = $question_2_answer_1;
        $details_json->questions[] = $question_2;



        // scenario اختر السائق case !!!!
        $question_3 = new stdClass();
        $question_3->question_attachment_url = null;
        $question_3->question_id = 2;
        $question_3->question_lable = 'الرجاء إدخال سبب عدم الرضا عن الخدمة.';
        $question_3->question_type = "free_text";
        $question_3->validation =  new stdClass();
        $question_3->validation->method =  "none";
        // first Question answers
        $question_3->answers = [];

        $question_3_answer_1 = new stdClass();
        $question_3_answer_1->caption = "متابعة";
        $question_3_answer_1->next_question = 1;
        $question_3_answer_1->value = "";
        $question_3->answers[] = $question_3_answer_1;
        $details_json->questions[] = $question_3;


        $user_id = $u_id;

        $details = [];
        $details['details'] = json_encode($details_json, JSON_UNESCAPED_UNICODE );
        $details['type'] = "POLL";
        $details['priority'] = 3;
        $details['recipients']=[];

        $rec = [];
        $rec['bind_params'] = [];
        $rec['user_id'] = 0;
        $rec['communication_channels'] = [];
        $details['recipients'][] = $rec;
 
        $poll_id = $this->createPoll($details);

        // activate it
        $this->publishPoll($poll_id);

        return $poll_id;
    }
}
