<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");


class MG_tracking
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for MG-Registrar System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {

        // TODO : call database to get this token
        return "(C_5v)eb,Hk*CXR**z4[?ZSGTQ7QcdDd";
    }

    // --------------------------------------------------------------------------------- //
    // ------------------ search for all trucks on tracking system --------------------- //
    // --------------------------------------------------------------------------------- //
    public function getLocations($user_ids)
    {

        $url = Config::$minagate_tracking_base_url . '/getLocations';
        $fields = array(
            'user_id' => json_encode($user_ids)
        );

        $location_result = $this->curl($url, $fields, 'POST');
        return $location_result;
    }

    // --------------------------------------------------------------------------------- //
    // ------------------ search for all trucks on tracking system --------------------- //
    // --------------------------------------------------------------------------------- //
    public function getLocations_new($wns)
    {

        $url = Config::$minagate_tracking_base_url . '/getLocations';
        $fields = array(
            'waybill_number' => json_encode($wns)
        );

        $location_result = $this->curl($url, $fields, 'POST');
        return $location_result;
    }


    // --------------------------------------------------------------------------------- //
    // ------------------ search for all trucks on tracking system --------------------- //
    // --------------------------------------------------------------------------------- //
    public function getLocations_landtrip($land_trips)
    {

        $url = Config::$minagate_tracking_base_url . '/getLocations';
        $fields = array(
            'land_trip' => json_encode($land_trips)
        );

        $location_result = $this->curl($url, $fields, 'POST');
        return $location_result;
    }

    // --------------------------------------------------------------------------------- //
    // ------------------ search for all trucks on tracking system --------------------- //
    // --------------------------------------------------------------------------------- //
    public function getTripPath($user_id, $date_from, $date_to, $accuracy = 5000)
    {

        $url = Config::$minagate_tracking_base_url . '/getPath';
        $fields = array(
            'user_id' => $user_id,
            'date_from' => $date_from,
            'date_to' => $date_to,
            'accuracy' => $accuracy
        );

        $location_result = $this->curl($url, $fields, 'POST');
        return $location_result;
    }

    // ----------------------------------------------------------------------------------- //
    // ---------------------- save the location of a certain truck ----------------------- //
    // ----------------------------------------------------------------------------------- //
    public function saveLocations($device_id, $user_id, $locations, $wn, $tn, $lt, $trip_details)
    {

        $url = Config::$minagate_tracking_base_url . '/saveLocations';
        $fields = array(
            'device_id' => $device_id,
            'user_id' => $user_id,
            'locations' => $locations,
            'waybill_number' => $wn,
            'land_trip' => $lt,
            'trip_details' => $trip_details,
            'tn' => $tn
        );

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST');
        dump($response);
        die;
        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'accept: application/json'
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}
