<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/container.php");
class MG_registrar
{

    private $_con;
    public function __construct()
    {
        DBConnection::getInstance();
        $this->_con = new Container();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for MG-Registrar System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {

        // TODO : call database to get this token
        return "wJfSDKrsxr5u8kqdXm6XL2pNWckc4aajkV4N3B8FgB56cmYYc8GuHd4p788JhEEc";
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ Search for grains waybill in minagate-registrat ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function searchGrainsWaybill($tn, $user_id)
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "searchGrnsWbl",
            "filter" => json_encode(["TN" => $tn])
        );
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();


        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);

        if (!$response['truck']) {
            throw new Exception("MG_REGISTRAR.NO_TRUCK_IS_FOUND", 1);
        }
        return $response;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------ Submit new LTRC waybill --------------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function submitLTRCWaybill($waybill_id, $send_SMS, $user_id)
    {

        // init objects
        $waybillCore = new WaybillCore();
        $userCore = new UserCore();
        $tenderCore = new TenderCore();
        $cargoCore = new CargoCore();
        $driverCore = new DriverCore();

        // get the waybill bean
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);
        $tender_id = $waybillBean->document->tender->id;
        $manifestBean = $tenderCore->getTenderManifest($tender_id, 0);
        $cargoBean = $cargoCore->getCargoBasic($waybillBean->document->cargo[0]->cargo_id, 0);
        $driverBean = $driverCore->getDriverBasic($waybillBean->document->carrier[0]->driver->id, 0);
        $driverUserBean = $userCore->getUserBasic($driverBean->user_id, 0);

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/createLtrcWaybill';

        $fields = array(
            'method' => "createLtrcWaybillHandler",
            'tn' => $waybillBean->document->carrier[0]->truck->tn,
            'trn' => $waybillBean->document->carrier[0]->trailer->tn,
            'nn' => $driverUserBean->nn,
            'drvr' => $waybillBean->document->carrier[0]->driver->name,
            'mob' => $manifestBean['ltrc']['contact_number']['number'],
            'nat' => $driverUserBean->nat_code,
            'ct' => $cargoBean->ct_id,
            'wn' => $waybillBean->wn,
            "username" => $manifestBean['ltrc']['user_name'],
            "type" => $manifestBean['ltrc']['waybill_type'],
            "done_by" => $user_id
        );
        $headers = array();
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();
        $headers[] = 'CallBack: ' . Config::$minagate_waybill_base_url . '/waybill/integration';

        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);

        // change the ltrc node in waybill document
        $newWaybill = new stdClass();
        $newWaybill->ltrc = new stdClass();
        $newWaybill->ltrc->docNum = null;
        $newWaybill->ltrc->submit_waybill = false;
        $newWaybill->ltrc->waybill_status = "IN_PROGRESS";
        $newWaybill->ltrc->send_SMS = $send_SMS;
        $newWaybill->ltrc->SMS_TEXT = $manifestBean['ltrc']['SMS_text'];
        $newWaybill->id = $waybill_id;
        $waybillCore->updateWaybill($newWaybill, $waybill_id, $user_id);

        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ Search for truck full data in minagate-registrat --------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getTruckData($tn, $nat, $username)
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "getTruckFullData",
            "tn" => $tn,
            "username" => $username,
            "nat" => $nat
        );

        $headers = array();
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();

        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);

        if (!$response) {
            throw new Exception("MG_REGISTRAR.NO_TRUCK_IS_FOUND", 1);
        }
        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ Search for truck full data in minagate-registrat --------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getPersonName($nn, $id_serial)
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "getPersonName",
            "nn" => $nn,
            "id_serial" => $id_serial
        );

        $headers = array();
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();

        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);

        if (!$response) {
            throw new Exception("MG_REGISTRAR.NO_DATA_IS_FOUND", 1);
        }

        return $response;
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ Search for truck full data in minagate-registrat --------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getGcPermit($tn, $tender_id)
    {

        $tenderCore = new TenderCore();
        $manifestBean = $tenderCore->getTenderManifest($tender_id, 0);

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "getGcPermit",
            "tn" => $tn,
            "username" => $manifestBean['ltrc']['user_name'],
        );

        $headers = array();
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();

        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);

        if (!$response) {
            throw new Exception("MG_REGISTRAR.NO_DATA_IS_FOUND", 1);
        }

        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete base on truck number for SA ---------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function autoCompleteTruckInfoForSA($tn, $user_id)
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "autoCompleteTruckInfoForSA",
            "tn" => $tn
        );
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();
        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);
        return $response;
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete based on container id        ---------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function autoCompleteFromNafContainer($land_trip_id , $cid, $user_id)
    {
        $landTrips = [];

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "autoCompleteFromNafContainer",
            "cid" => $cid
        );
        $headers[] = 'Authorization: ' . $this->getIntegrationToken();
        // call the remote endpoint
        $trips = $this->curl($url, $fields, $headers);

        // search land trip using container id and get the trip start
        $data = new stdClass();
        $data->id = $land_trip_id;
        $landTripBean = $this->_con->getLandTrip($data, $user_id);
        $tripStart = date_create($landTripBean['trip_start']);

        //check if the result has more than 1 column
        if ($trips && sizeof($trips) > 0) {
            foreach ($trips as $trip) {
                $diff = date_diff(date_create(json_decode($trip['result'])->create_date), $tripStart, false);
                $trip['order'] = $diff->days; // to get the newsest trip

                // invert has 2 values 1 means that the first date is bigger than 2nd
                if ($diff->invert == 1) {
                    $landTrips[] = $trip;
                }
            }

            //sort the order
            usort($landTrips, function ($a, $b) {
                return $b['order'] - $a['order'];
            });

            //get the trip with the biggest order
            $landTrip = $landTrips[0];
            return (json_decode($landTrip['result']));
        }
        return null;
    }


    public function getGrnsBulkWbls()
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "getGrnsBulkWbls",
            "status" => "OPEN",
            "user_name" => "ASEZA.327DSP25"
        );

        $headers[] = 'Authorization: ' . $this->getIntegrationToken();
        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);
        return $response;
    }


    public function submitT1Waybill($tn, $trn, $driver_nn, $tc_id)
    {

        //prepare needed info
        $url = Config::$minagate_reg_base_url . '/face';

        $fields = array(
            "method" => "submitT1Waybill",
            "tn" => $tn,
            "trn" => $trn,
            "nn" => $driver_nn,
            "scac" => $tc_id,
            "user_name" => "c71_1"
        );

        $headers[] = 'Authorization: ' . $this->getIntegrationToken();
        // call the remote endpoint
        $response = $this->curl($url, $fields, $headers);
        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $headers)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
            throw new Exception(curl_error($ch));
        }
        curl_close($ch);
        $response = json_decode($result, 1);
        return $response;
    }
}
