<?php

require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/config.php");

class MerchantIntegration{

    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for merchant System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken(){
        return 'Uydc2atHfuX8sWGsEacF94kgcRREa3tA4bVgk6ZjnzuWgagMx7XUbpZSE4CTLtY6';
    }

    
    // ------------------------------------------------------------------------------------------- //
    // ------------------ createCoupon  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createCoupon($coupon_number,$amount,$multi,$from,$to){

        //
        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'coupon_number'=> $coupon_number,
            'method'=>'createCoupon',
            'multi'=>$multi,
            'from'=>$from,
            'to'=>$to,
            'amount'=>$amount
        );
        
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }



    // ------------------------------------------------------------------------------------------- //
    // ------------------ searchCoupon  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchCoupon($data){

        //
        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'offset'=> $data->offset,
            'method'=>'searchCoupon',
            "filter"=>$data->filter,
            "limit"=>$data->limit
        );
        
        $url .= '?' . http_build_query($fields);
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }

     // ------------------------------------------------------------------------------------------- //
    // ------------------ getCoupon  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getCoupon($id){

        //
        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'id'=> $id,
            'method'=>'getCoupon'
        );
        
        $url .= '?' . http_build_query($fields);
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ changeStatus  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changeStatus($new_status,$coupon_id){

        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'new_status'=>$new_status,
            'coupon_id'=>$coupon_id,
            "method"=>'changeStatus'
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ useCoupon  ------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function useCoupon($coupon_id,$details){

        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'coupon_id'=>$coupon_id,
            "method"=>'useCoupon',
            "details"=>$details
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }

     // ------------------------------------------------------------------------------------------- //
    // ------------------ validate Coupon Number  ------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function validateCouponNumber($coupon_number){

        $url = Config::$merchant_base_url ."/coupon";

        $fields = array(
            'coupon_number'=>$coupon_number,
            "method"=>'validateCouponNumber',
        );

        $url .= '?' . http_build_query($fields);
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url,$fields,$method){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if($method =='POST'){
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'integration-token: '. $this->getIntegrationToken()
        ));

        $result = curl_exec($ch);


        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch) , curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);

        if($http_code != 200){
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result,1);
        if($response){
            return $response;
        }else{
            return $result;
        }
    }


}