<?php

require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/config.php");

class CustomerCare {

    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for customer care System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken(){
        return 'zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg';
    }



    // ------------------------------------------------------------------------------------------- //
    // ------------------ create ticket  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createTicket($data , $filters = null, $delayInSeconds = 0){

        $url = Config::$customer_care_base_url ."/ticket/create";

        // filters to send with request in order to find the suitable slot
        if (!$filters || empty($filters)){
            $filters = new stdClass();
            $filters->ticket_type = 'client';
        }

        if(!$filters->type_code){
            $filters->type_code = $data->type_code;
        }

        //note to attach with ticket
        $note = new stdClass();
        $note->title =  $data->title;
        $note->body = $data->body;
        $note->attachments = $data->attachments;
        $note->senderName = $data->senderName;
        $note->method = $data->method;
        $note->integration_token = $data->integration_token;
        $priority = $data->priority;

        $fields = array(
            'data'=>json_encode($note,JSON_UNESCAPED_UNICODE),
            'cb_url'=> Config::$customer_care_callback_base_url,
            'priority'=>$priority,
            'filters'=> json_encode($filters,JSON_UNESCAPED_UNICODE),
            'company_id'=>$data->company_id,
            'user_id'=>$data->user_id,
            'type_code' => $data->type_code
        );

        // add initial delay time in seconds
        // this will make the ticket snoozed as soon as it has been created
        if ($delayInSeconds){
            $fields["snooze_delay"] = $delayInSeconds;
        }

        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }



    // ------------------------------------------------------------------------------------------- //
    // ------------------ search tickets  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchTickets($filter,$page,$limit, $sort="asc"){

        //
        $url = Config::$customer_care_base_url ."/ticket/search";
        $fields = array(
            'filters'=> $filter,
            'page'=>$page,
            'limit'=>$limit,
            'sort' => $sort
        );
        
        $url .= '?' . http_build_query($fields);
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ search tickets  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getTicketsSummary($filter){

        //
        $url = Config::$customer_care_base_url ."/ticket/statusStats";
       $fields = array('filters'=> $filter);
        $url .= '?' . http_build_query($fields);
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');
        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ Change ticket status ------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changeStatus($id,$status,$result=null){

        //
        $url = Config::$customer_care_base_url ."/ticket/changeStatus";
        $fields = array(
            'id'=>$id,
            'status'=>$status,
            'result'=>$result
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ snooz a ticket for some period   ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function snoozTicket($id,$delay){

        //
        $url = Config::$customer_care_base_url ."/ticket/changeStatus";
        $fields = array(
            'id'=>$id,
            'status'=>'SNOOZED',
            'delay'=>$delay
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }

     // ------------------------------------------------------------------------------------------- //
    // ------------------ get ticket  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getTicket($id){
         
        //
        $url = Config::$customer_care_base_url ."/ticket/$id";
 
        // call the remote endpoint
        $response = $this->curl($url,null,'GET');

        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ update tickets info ---------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function updateTicket($id, $filters, $data){

        $url = Config::$customer_care_base_url ."/ticket/update";
        $fields = array(
            'id'=>$id,
            'filters'=>$filters,
            'data'=>$data,
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ search tickets  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function replyToTicket($id,$note){

        $url = Config::$customer_care_base_url ."/ticket/reply";
        $fields = array(
            'id'=>$id,
            'note'=>json_encode($note),
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ search tickets  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function esclateTicket($id,$note,$filters,$priority){

        $url = Config::$customer_care_base_url ."/ticket/escalate";
        $fields = array(
            'id'=>$id,
            'note'=>json_encode($note),
            'priority'=>$priority,
            'filters'=>json_encode($filters)
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }

    // --------------------------------------------------------------------------------- //
    // --------------- get the assigned ticket for the current user  ------------------- // 
    // --------------------------------------------------------------------------------- //
    public function checkTicket($user_id){
 
        $url = Config::$customer_care_base_url ."/ticket/userTicket?user_id=". $user_id;
        $fields = array();
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }


    // ------------------------------------------------------------------------------- //
    // --------------- get list of all slots and its configuration ------------------- // 
    // ------------------------------------------------------------------------------- //
    public function searchSlots($filters=null){

        $url = Config::$customer_care_base_url ."/slot/search";
        if($filters){
            $url .= "?filters=" . $filters;
        }
        $fields = array();

        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }

    // -------------------------------------------------------------------- //
    // --------------- activate/deactivate certian slot ------------------- // 
    // -------------------------------------------------------------------- //
    public function changeSlotStatus($slot_id , $new_status){

        $url = Config::$customer_care_base_url ."/slot/changeStatus";
        $fields = array(
            'id' => $slot_id,
            'status' => $new_status
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');

        return $response;
    }

    // ------------------------------------------------------ //
    // --------------- update slot filter ------------------- // 
    // ------------------------------------------------------ //    
    public function updateSlot($slot_id , $filter){

        $url = Config::$customer_care_base_url ."/slot/update";
        $fields = array(
            'id' => $slot_id,
            'filters' => $filter
        );
 
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');
        return $response;
    }

    // ------------------------------------------------------------- //
    // ----------------to create a call ticket----------------------------//
    // ------------------------------------------------------------- //
    public function createCallTicket($callObj)
    {
        try {

            // request call center init
            $url = Config::$customer_care_base_url . "/ticket/create";
            // filters to send with request
            $filters = new stdClass();
            $filters->ticket_type = $callObj->type;
            $filters->call_mode = $callObj->call_mode;

            $fields = array(
                'data' => json_encode($callObj,JSON_UNESCAPED_UNICODE),
                'cb_url' => Config::$customer_care_callback_base_url,
                'filters' => json_encode($filters,JSON_UNESCAPED_UNICODE),
            );
 
            // call the remote endpoint
            $response = $this->curl($url, $fields, 'POST');
            return $response;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------- //
    // --------------- get list of all roles for slot------------------- //
    // ------------------------------------------------------------------------------- //
    public function getSlotRoles(){

        $url = Config::$customer_care_base_url ."/ticket/roles";
        $fields = array();
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');

        return $response;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url,$fields,$method){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if($method =='POST'){
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: '. $this->getIntegrationToken(),
            'Accept: application/json'
        ));

        $result = curl_exec($ch);


        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch) , curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);

        if($http_code != 200){
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result,1);
        if($response){
            return $response;
        }else{
            return $result;
        }
    }


    // ------------------------------------------------------------------------------- //
    // --------------- get list of all roles for slot------------------- //
    // ------------------------------------------------------------------------------- //
    public function forceClearTickets($slot_id){

        $url = Config::$customer_care_base_url ."/slot/forceClearTickets";
        $fields = array(
            'id' => $slot_id,
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');
        return $response;
    }

     // ------------------------------------------------------------------------------- //
    // --------------- assign ticket for slot----------------------------------------- //
    // ------------------------------------------------------------------------------- //
    public function assignTicketForSlot($ticket_id, $slot_id){

        $url = Config::$customer_care_base_url ."/ticket/forceAssign";
        $fields = array(
            'ticket_id' => $ticket_id,
            'slot_id' => $slot_id
        );
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');
        return $response;
    }

    // ------------------------------------------------------------------------------- //
    // ------------- Get Stats for how did the users for the tickets ----------------- //
    // ------------------------------------------------------------------------------- //
    public function getTicketsUsersStats($ticket_ids){

        $url = Config::$customer_care_base_url ."/ticket/ticketsUsersStats?ids=" . json_encode($ticket_ids);
        $fields = [];
        // call the remote endpoint
        $response = $this->curl($url,$fields,'GET');
        return $response;
    }

    // ------------------------------------------------------------------------------- //
    // ------------- assign tickets to all available slots ----------------- //
    // ------------------------------------------------------------------------------- //
    public function assignAvailableSlots(){

        $url = Config::$customer_care_base_url ."/slot/assignAvailableSlots";
        $fields = [];
        // call the remote endpoint
        $response = $this->curl($url,$fields,'POST');
        return $response;
    }


    

}