<?php

require_once dirname(__FILE__) . "/../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../includes/config.php";

class Container
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {
        return '123';
    }

    // ---------------------------------------------------------------------------- //
    // ------------------ call cURL request to FPS end point ---------------------- //
    // ---------------------------------------------------------------------------- //
    private function curl($url, $fields, $method, $user_id)
    {

        // if ($user_id == 0) {
        //     $user_id = 3;
        // }

        $ch = curl_init();
        $fields->integration_token = $this->getIntegrationToken();
        $fields->session_id = $user_id;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json',
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {

            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            $objRes = json_decode($result);
            if ($objRes->ERRORCODE == 600) {
                throw new Exception($objRes->MESSAGE);
            } else {

                throw new Exception("Error Processing Request : " . $result, 1);
            }
        }

        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }

    // -------------------------------------------------------------------- //
    // --------------------- get account bean + trx ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function getLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "getLandTrip";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    // -------------------------------------------------------------------- //
    // --------------------- get account bean + trx ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function searchLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "searchLandTrip";
        // call the remote endpoint

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    // -------------------------------------------------------------------- //
    // --------------------- change landTrip status ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function changeLandTripStatus($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "changeLandTripStatus";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function closeLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "closeLandTrip";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // -------------------------------------------------------------------- //
    // --------------------- update landTrip bean  --------------------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripBean($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "updateLandTripBean";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // -------------------------------------------------------------------- //
    // --------------------- update landTrip excel form ------------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripContainerExcelForm($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "updateLandTripContainerExcelForm";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripShippingLineDetention($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "updateLandTripShippingLineDetention";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function calculateContainerFreight($data, $user_id)
    {
        $url = Config::$con_url . "/demurrage";
        $data->method = "calculateContainerFreight";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function getShippingLine($data, $user_id)
    {
        $url = Config::$con_url . "/shippingline";
        $data->method = "getShippingLine";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function searchShippingLines($data, $user_id)
    {
        $url = Config::$con_url . "/shippingline";
        $data->method = "searchShippingLines";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ----------------------------------------------------------------------- //
    // ------------------- create new  land trip service in the db ------------ //
    // ------------------------------------------------------------------------ //
    public function createLandTripService($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip_service";
        $data->method = "createLandTripService";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function getDeclarationBasic($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getDeclarationBasic";
        $data->limit = 500;
        $data->offset = 0;
        $response = $this->curl($url, $data, 'POST', $user_id);

        return ($response);
    }

    public function searchDeclarations($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "searchDeclarations";
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function updateDeclaration($data, $user_id)
    {

        $url = Config::$con_url . "/declaration";
        $data->method = "updateDeclaration";
        $data->limit = 500;
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    public function searchJCDs($data, $user_id)
    {
        $url = Config::$con_url . "/jcd";
        $data->method = "searchJCDs";
        $data->limit = 500;

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function getDeclarationProfile($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getDeclarationProfile";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function getJCDPermitBarcode($data, $user_id)
    {
        $url = Config::$con_url . "/jcd";
        $data->method = "getJCDPermitBarcode";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function searchCompanyService($data, $user_id)
    {
        $url = Config::$con_url . "/company_service";
        $data->method = "searchCompanyService";
        $data->limit = 500;

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function getCompanyServiceByCode($data, $user_id)
    {
        $url = Config::$con_url . "/company_service";
        $data->method = "getCompanyServiceByCode";
        $data->limit = 500;

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function addServiceToLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip_service";
        $data->method = "addServiceToLandTrip";

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function availableService($data, $user_id)
    {
        $url = Config::$con_url . "/company_service";
        $data->method = "availableService";
        $data->limit = 500;

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    public function deleteServiceFromLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip_service";
        $data->method = "deleteServiceFromLandTrip";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function countDeclarations($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "countDeclarations";
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function countContainers($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "countContainers";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function clearingAgentsDeclaration($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "clearingAgentsDeclaration";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    public function getChartList($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getChartList";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function countServices($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip_service";
        $data->method = "countServices";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function printBoned($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "printBoned";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function updateCargoDischargeDetails($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "updateCargoDischargeDetails";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    public function printDeclarationsLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "printDeclarationsLandTrip";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function getCustomsCenters($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getCustomsCenters";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function getContainerReport($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getContainerReport";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function renderContainerBonedQR($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "renderContainerBonedQR";

        $response = $this->curl($url, $data, 'POST', 0);

        return $response;
    }

    public function fix_land_trip_service($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip_service";
        $data->method = "fix_land_trip_service";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    public function checkUserDeclaration($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "checkUserDeclaration";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    public function createDeclaration($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "createDeclaration";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }
    public function addCaIdToLandTrips($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "addCaIdToLandTrips";

        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    public function getLandTripReport($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";

        $data->method = "getLandTripReport";
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    public function getLandTripSummary($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getLandTripSummary";

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function getMissingDeliveryBondService($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "getMissingDeliveryBondService";

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }


    public function getDeclarationSummeryReport($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "getDeclarationSummeryReport";

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // @param $end_point, $data ('make sure that data have the method name in it '),$user_id
    public function callContainer($end_point, $data, $user_id)
    {
        if (!isset($data->method)) {
            throw new Exception('method is not provided', 600);
        }
        $url = Config::$con_url . $end_point;

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    public function checkCaForElectronicIntegeration($data, $user_id)
    {
        $url = Config::$con_url . "/declaration";
        $data->method = "checkCaForElectronicIntegeration";

        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }


    public function getCaMonthlyLandTripServiceReport($data, $user_id)
        {
            $url = Config::$con_url . "/landtrip_service";
            $data->method = "getCaMonthlyLandTripServiceReport";
            // dump([$url, $data, $user_id]);die;
            $response = $this->curl($url, $data, 'POST', $user_id);
            return $response;
        }
}
