<?php

require_once dirname(__FILE__) . "/../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../includes/config.php";

class Chart_Engine
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    private function getIntergrationKey(){
        return "zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg";
    }

    // ------------------------------------------------------------------------- //
    // -------------------------- Generate Gauge Chart ------------------------- //
    // ------------------------------------------------------------------------- //
    public function GenerateGaugeChart($amount , $maximum)
    {
        $url = Config::$chart_engine_url;
        $gaugeChartData = [
            "amount" => $amount,
            "maximum_balance" =>  $maximum
        ];
        $payment_method_url = $url . "/GenerateGaugeChart?data=" . json_encode($gaugeChartData);        
        $dashboard_url = $this->curl($payment_method_url, "", "POST");
        return $dashboard_url;
    }

    // ------------------------------------------------------------------------- //
    // -------------------------- Generate Horizantal Stacked BAR Chart ------------------------- //
    // ------------------------------------------------------------------------- //
    public function GenerateHorizantalStackedBarChart($amount , $maximum)
    {
        $url = Config::$chart_engine_url;
        $gaugeChartData = [
            "amount" => $amount,
            "maximum_balance" =>  $maximum
        ];
        $payment_method_url = $url . "/GenerateHorizantalStackedBarChart?data=" . json_encode($gaugeChartData);
        $dashboard_url = $this->curl($payment_method_url, "", "POST");
        return $dashboard_url;
    }



    private function curl($url, $fields, $method)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntergrationKey(),
            'Accept: application/json'
        ));
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}
