<?php

require_once dirname(__FILE__) . "/../../includes/config.php";

class Robot_agent
{
    private $token = "tcgV2ZnuNtrGPXpaaNsBa7Q5mtB4n9QW";

    public function __construct(){

    }
    // ------------------------------------------------------------- //
    // ------------- create LTRC waybill --------------------------- //
    // ------------------------------------------------------------- //
    public function submitLtrcCrudeOilWaybill($tn,$trn,$nn,$tc)
    {
        $url = Config::$Robot_base_url;
        $data = new stdClass();
        $data->method = "submitLtrcCrudeOilWaybill";
        $data->tn = $tn;
        $data->trn = $trn;
        $data->nn = $nn;
        $data->tc = $tc;

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST');

        return $response;
    }

    // ------------------------------------------------------------- //
    // ------------- create LTRC waybill for grains waybill -------- //
    // ------------------------------------------------------------- //
    public function submitLtrcGrainsWaybill($tn, $trn, $nn, $service)
    {
        $url = Config::$Robot_base_url;
        $data = new stdClass();
        $data->method = "submitLtrcGrainsWaybill";
        $data->tn = $tn;
        $data->trn = $trn;
        $data->nn = $nn;
        $data->service = $service;
        
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST');
        return $response;
    }

    // ---------------------------------------------------------------------- //
    // --------- Search for the submit page on gltrc system ----------------- //
    // ---------------------------------------------------------------------- //
    public function getGrainsLtrcPermitNumber($tn)
    {
        $url = Config::$Robot_base_url;
        $data = new stdClass();
        $data->method = "getGrainsLtrcPermitNumber";
        $data->tn = $tn;
      
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST');
        return $response;
    }

    // -------------------------------------------------------------------------------- //
    // ------------------ call cURL request to LTRC end point ------------------------- //
    // -------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {
        $ch = curl_init();
        $fields->integration_token = $this->token;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');

            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));

        }
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}