<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/jppmc.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/social/social_core.php");

require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");


class Jo_Petrol
{
    private $_tenderCore;
    private $_queueCore;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_queueCore = new QueueCore();
        $this->_tenderCore = new TenderCore();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for MG-Registrar System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {

        // TODO : call database to get this token
        return "C9yruGYyJq2WEqzUs7GFWBsRbX5LvcR5Zw9UsYeYjERJdpj9aBzP6MPy8rLXNhcG";
    }


    // ----------------------------------------------------------------------------------------------- //
    // ------------------ insert new waybill into Jo_Petrol system ----------------------------------- //
    // ------------------ ** tested on new API ------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function insertWaybill($waybillBean)
    {
        // get params
        $waybill_id = $waybillBean->id;
        $create_date_obj = date_create(DBConnection::getSystemDate());
        $create_date = date_format($create_date_obj, "m/d/Y");
        $create_time_obj = date_create(DBConnection::getSystemDate());
        $create_time = date_format($create_time_obj, "His");
        $ct_id = $waybillBean->document->cargo[0]->cargo->ct_id;
        $destination_id = $waybillBean->destination_id;
        $tn = $waybillBean->document->carrier[0]->truck->tn;
        $trn = $waybillBean->document->carrier[0]->trailer->tn;
        $driver_nn = $waybillBean->document->carrier[0]->driver->nn;

        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "insertWaybill",
            'waybill_id' => $waybill_id,
            'create_date' => $create_date,
            'create_time' => $create_time,
            'ct_id' => $ct_id,
            'destination_id' => $destination_id,
            'tn' => $tn,
            'trn' => $trn,
            'driver_nn' => $driver_nn
        );



        // call the remote endpoint        
        $response = $this->curl($url, $fields);


        if ($response['ERRORCODE'] != 200) {
            throw new Exception($response['ERRORMSG'], 999);
        }
        return $response;
    }

    // -------------------------------------------------------------------------------- //
    // -------------- get a list of waybills on Jo_Petrol System ---------------------- //
    // -------------- ** tested on new API -------------------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function fetchWaybills($status)
    {

        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "fetchWaybills",
            'status' => $status
        );
        // call the remote endpoint        
        $response = $this->curl($url, $fields);
        return $response;
    }

    // --------------------------------------------------------------------------------------------------- //
    // -------------- Update the status for certain waybill ---------------------------------------------- //
    // -------------- This method is used when the weight is transfered from Jo Petrol successfuly ------- //
    // -------------- ** tested on new API --------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function deleteWaybill($waybill_id)
    {

        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "deleteWaybill",
            'waybill_id' => $waybill_id
        );

        // call the remote endpoint
        $response = $this->curl($url, $fields);
        return $response;
    }


    // --------------------------------------------------------------------------------------------------- //
    // -------------- Update the status for certain waybill ---------------------------------------------- //
    // -------------- This method is used when the weight is transfered from Jo Petrol successfuly ------- //
    // -------------- ** tested on new API --------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function changeWaybillStatus($waybill_id, $new_status)
    {

        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "changeWaybillStatus",
            'waybill_id' => $waybill_id,
            'new_status' => $new_status
        );
        // call the remote endpoint        
        $response = $this->curl($url, $fields);

        if ($response['ERRORCODE'] != 200) {
            throw new Exception($response['ERRORMSG'], 999);
        }
        return $response;
    }

    // ---------------------------------------------------------------------------------------------- //
    // -------------- query on driver status if he is on Black list or not -------------------------- //
    // -------------- ** tested on new API --------------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function QueryOnDriverStatus($nn)
    {

        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "QueryOnDriverStatus",
            'nn' => $nn
        );
        // call the remote endpoint        
        $response = $this->curl($url, $fields);

        // convert data
        if ($response && $response != "null") {
            $response = $this->mapDriverInfo($response);
        } else {
            $response = [];
            $response['status'] = 'INACTIVE';
        }

        return $response;
    }


    // // --------------------------------------------------------------------------------------------------- //
    // // -------------- Update the status for certain waybill ---------------------------------------------- //
    // // -------------- This method is used when the weight is transfered from Jo Petrol successfuly ------- //
    // // --------------------------------------------------------------------------------------------------- //
    // public function saveWaybillClaimNumber($waybill_id, $claim_number)
    // {

    //     $url = Config::$jo_petrol_microservice_base_url . '/face';

    //     $fields = array(
    //         'method' => "saveWaybillClaimNumber",
    //         'waybill_id' => $waybill_id,
    //         'claim_number' => $claim_number
    //     );
    //     // call the remote endpoint
    //     $response = $this->curl($url, $fields);
    //     return $response;
    // }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10000000);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'PUBLIC-KEY: ' . $this->getIntegrationToken()
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request" . $result, 1);
        }

        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }


    // // transfer desil
    // public function transferDeisil($tn, $diesil_amount)
    // {

    //     try {

    //         $jppmc = new JPPMC();
    //         $result = $jppmc->addTruckBalance($tn, "MG1", $diesil_amount);
    //         return $result;
    //     } catch (Exception $e) {
    //         throw new Exception($e->getMessage());
    //     }
    // }


    // // -------------------------------------------------------------------------------------- //
    // // ------------------ check Jo Petrol card balance -------------------------------------- //
    // // -------------------------------------------------------------------------------------- //
    // public function checkCardBalance($tn)
    // {
    //     try {
    //         $jppmc = new JPPMC();
    //         $result = $jppmc->addTruckBalance($tn, "MG5", null);
    //         return $result;
    //     } catch (Exception $e) {
    //         if ($e->getMessage() == "بطاقة الشاحنة غير معرفة!") {
    //             throw new Exception("لم تتم تعبئة الديزل للشاحنة رقم: " . $tn . " بسبب عدم وجود بطاقة");
    //         } else {
    //             throw new Exception("لم تتم تعبئة الديزل للشاحنة رقم: " . $tn . " " . $e->getMessage());
    //         }
    //     }
    // }


    // ---------------------------------------------------------------------------------------- //
    // ----------- get the amount of diesil payment to be paid into card ---------------------- //
    // -----------  total_amount = 350 * Diesel price per liter ------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getDieselPayment($waybill_id, $payment_type)
    {

        if (!$waybill_id) return 0;

        $waybillCore = new WaybillCore();
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);

        if ($payment_type == 'DEISIL_PRE_LOAD') {
            $month = date("m", strtotime($waybillBean->create_date));
            $year = date("y", strtotime($waybillBean->create_date));
        } else if ($payment_type == 'DEISIL_POST_LOAD') {
            $loading_date = $waybillBean->loading_date;
            if (!$loading_date) {
                return 0;
            }
            $month = date("m", strtotime($loading_date));
            $year = date("y", strtotime($loading_date));
        }

        $diesel_price = $this->getDieselPrice($year, $month);
        return $diesel_price[$payment_type];
    }


    public function getDieselPrice($year, $month)
    {

        // 2020 Diesel prices
        if ($year == 20) {
            switch ($month) {
                case 1:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 115.25;
                    break;
                case 2:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 111.75;
                    break;
                case 3:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 94.25;
                    break;
                case 4:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 62.75;
                    break;
                case 5:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 38.25;
                    break;
                case 6:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 43.5;
                    break;
                case 7:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 62.75;
                    break;
                case 8:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 62.75;
                    break;
                case 9:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 68.00;
                    break;
                case 10:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 61.00;
                    break;
                case 11:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 61.00;
                    break;
                case 12:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 64.50;
                    break;
                default:
                    throw new Exception("INVALID LOADING MONTH");
                    break;
            }
        }

        // 2021 Diesel Price
        else if ($year == 21) {
            switch ($month) {
                case 1:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 75.0;
                    break;
                case 2:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 83.75;
                    break;
                case 3:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 94.25;
                    break;
                case 4:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 94.25;
                    break;
                case 5:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 94.25;
                    break;
                case 6:
                    $PRE_LOAD_AMOUNT = 100;
                    $POST_LOAD_AMOUNT = 103;
                    break;
                case 7:case 8:
                case 9:case 10:
                case 11:case 12:
                    $PRE_LOAD_AMOUNT = 0;
                    $POST_LOAD_AMOUNT = 0;
                    break;
                default:
                    throw new Exception("INVALID LOADING MONTH");
                    break;
            }
        }

        $result = [];
        $result['DEISIL_PRE_LOAD'] = $PRE_LOAD_AMOUNT;
        $result['DEISIL_POST_LOAD'] = $POST_LOAD_AMOUNT;
        return $result;
    }


    // // ---------------------------------------------------------------------------------------------------------------- //
    // // ------------ get list of waybills using claim number (claimNumber is Jo_petrol claim number not ours)----------- //
    // // ---------------------------------------------------------------------------------------------------------------- //
    // public function QueryOnClaimNumber($ClaimNumber)
    // {
    //     $url = Config::$jo_petrol_microservice_base_url . '/face';
    //     $fields = array(
    //         'method' => "QueryOnClaimNumber",
    //         'ClaimNumber' => $ClaimNumber
    //     );

    //     // call the remote endpoint
    //     $response = $this->curl($url, $fields);

    //     $result = [];
    //     foreach ($response['data'] as $r) {
    //         $result[] = $this->mapWaybillInfo($r);
    //     }
    //     return $result;
    // }

    // ---------------------------------------------------- //
    // ------------ get waybill info based on id----------- //
    // -------------- ** tested on new API ---------------- //
    // ---------------------------------------------------- //
    public function QueryOnWayBill($waybill_id, $cleanRawData = true)
    {
        $url = Config::$jo_petrol_microservice_base_url . '/face';

        $fields = array(
            'method' => "QueryOnWayBill",
            'waybill_id' => $waybill_id
        );
        // call the remote endpoint
        $response = $this->curl($url, $fields);

        if ($cleanRawData)
            return $this->mapWaybillInfo($response);
        else
            return $response;
    }


    // ----------------------------------------------------------------------- //
    // ------------ get fresh weights again from Jo_petrol system  ----------- //
    // -------------- ** tested on new API ---------------- //
    // ----------------------------------------------------------------------- //
    public function refreshWeights($waybill_id)
    {

        try {
            // get fresh copy of weights
            $newWeights = $this->QueryOnWayBill($waybill_id);


            // get old waybill info from database
            $waybillCore = new WaybillCore();
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
            $cargoBean = $waybillBean->document->cargo[0];

            $original_loading_weight = $cargoBean->weights->loading->net_weight;
            $original_discharge_weight = $cargoBean->weights->discharge->net_weight;

            // get new weights
            $loading_weight = doubleval($newWeights['loading_weight']);
            $loading_weight = doubleval($loading_weight / 1000);

            $discharge_weight = doubleval($newWeights['discharge_weight']);
            $discharge_weight = doubleval($discharge_weight / 1000);

            // add sea water weight
            if ($newWeights['sea_water'] && $newWeights['sea_water'] != "" && $newWeights['sea_water_confirmation'] == "1") {

                $sea_water = doubleval($newWeights['sea_water']);
                $sea_water = doubleval($sea_water / 1000);
                $discharge_weight += doubleval($sea_water);

                if ($discharge_weight > $loading_weight) {
                    $discharge_weight = $loading_weight;
                }

                // update sea water and its confirmation
                $waybillBean->document->integeration_details->jo_petrol->sea_water = $newWeights['sea_water'];
                $waybillBean->document->integeration_details->jo_petrol->sea_water_confirmation = $newWeights['sea_water_confirmation'];
                $waybillCore->updateWeight($waybillBean, 0);
            }

            $loading_time_stamp = $newWeights['loading_date'] . " " . $newWeights['loading_time'];
            $discharge_time_stamp = $newWeights['discharge_gate_out_date'] . " " . $newWeights['discharge_gate_out_time'];

            // in case the loading weight has changed
            if ($loading_weight != "" && $original_loading_weight && $original_loading_weight != $loading_weight) {
                $waybillCore->logActivity(
                    $waybillBean->id,
                    "تغير وزن التحميل - ربط إلكتروني",
                    "وزن التحميل القديم: " . $original_loading_weight . "  - الوزن الجديد : " . $loading_weight . " كغم",
                    "LOAD_CARGO",
                    0
                );

                $cargoBean = $waybillBean->document->cargo[0];
                $cargoBean->weights->loading->net_weight = $loading_weight;
                $cargoBean->weights->loading->time_stamp = $loading_time_stamp;
                $waybillBean->document->cargo[0] = $cargoBean;
                $waybillCore->updateWeight($waybillBean, 0);
            }


            // in case the no discharge weight is saved
            if ($discharge_weight && !$original_discharge_weight || $original_discharge_weight != $discharge_weight) {
                $waybillCore->logActivity(
                    $waybillBean->id,
                    "تثبيت وزن التفريغ - ربط إلكتروني",
                    "وزن التفريغ : " .  $discharge_weight . " كغم",
                    "LOAD_CARGO",
                    0
                );

                $cargoBean = $waybillBean->document->cargo[0];
                $cargoBean->weights->discharge->net_weight = $discharge_weight;
                $cargoBean->weights->discharge->time_stamp = $discharge_time_stamp;
                $waybillBean->document->cargo[0] = $cargoBean;
                $waybillCore->updateWeight($waybillBean, 0);
            }


            // in case the discharge weight has changed
            else if ($discharge_weight && $original_discharge_weight && $original_discharge_weight != $discharge_weight) {
                $waybillCore->logActivity(
                    $waybillBean->id,
                    "تغير وزن التفريغ - ربط إلكتروني",
                    "وزن التفريغ القديم: " . $original_discharge_weight . "  - الوزن الجديد : " . $discharge_weight . " كغم",
                    "LOAD_CARGO",
                    0
                );

                $cargoBean = $waybillBean->document->cargo[0];
                $cargoBean->weights->discharge->net_weight = $discharge_weight;
                $cargoBean->weights->discharge->time_stamp = $discharge_time_stamp;
                $waybillBean->document->cargo[0] = $cargoBean;
                $waybillCore->updateWeight($waybillBean, 0);
            }
            return true;
        } catch (Exception $e) {
            return false;
        }
    }

    public function mapDriverInfo($rawData)
    {
        try {
            $driver = [];
            $driver['black_list_start_date'] = $this->convertToDate($rawData['Prohibited_x0020_Start_x0020_Date']);
            $driver['black_list_end_date'] = $this->convertToDate($rawData['Prohibited_x0020_End_x0020_Date']);
            $driver['reason'] = $rawData['Prohibited_x0020_Reason'];
            $driver['notes'] = $rawData['Prohibited_x0020_Book_x0020_Number'];

            // if the current date is withing start and end , make status = 'ACTIVE'
            $start_ts = strtotime($driver['black_list_start_date']);
            $end_ts = strtotime($driver['black_list_end_date']);
            $user_ts = strtotime(DBConnection::getSystemDate());
            $driver['status'] = (($user_ts >= $start_ts) && ($user_ts <= $end_ts)) ? 'ACTIVE' : 'INACTIVE';
        } catch (Exception $e) {
            $driver = [];
            $driver['status'] = 'INACTIVE';
        }

        return $driver;
    }

    public function mapWaybillInfo($rawData)
    {

        $waybill = [];;
        $waybill['id'] = $rawData['nf55doco'];
        $waybill['tn'] = $rawData['nf55head'];
        $waybill['trn'] = $rawData['nf55trail'];
        $waybill['ct_id'] = $this->reverseCargoTypes($rawData['nf55nitm']);
        $waybill['driver_nn'] = $rawData['nf55drnid'];

        // loading info
        $waybill['loading_tare_weight'] = $rawData['nfbfwt'];
        $waybill['loading_gross_weight'] = $rawData['nfafwt'];
        $waybill['loading_weight'] = $rawData['nfwgtr'];  // net weight
        $waybill['loading_weight_in_liter'] = $rawData['nfstum'];
        $waybill['loading_weight_density'] = $rawData['nfdnty'];
        $waybill['loading_weight_temp'] = $rawData['nftemp'];
        $waybill['loading_date_raw'] = $rawData['nfload'];
        $waybill['loading_time_raw'] = $rawData['nflslt'];
        $waybill['loading_date'] = $this->convertToDate($rawData['nfload']);
        $waybill['loading_time'] = $this->convertToTime($rawData['nflslt']);


        // discharge info
        $waybill['discharge_permit_num'] = $rawData['nfy55dispn'];
        $waybill['discharge_permit_year'] = $rawData['nfy55dsye'];
        $waybill['discharge_gate_in_date'] = $this->convertToDate($rawData['nfy55dend']);
        $waybill['discharge_gate_in_time'] = $this->convertToTime($rawData['nfy55dent']);
        $waybill['discharge_gate_in_time_original'] =  $rawData['nfy55dent'];
        $waybill['discharge_tare_weight'] = $rawData['nf55afwt'];
        $waybill['discharge_gross_weight'] = $rawData['nf55bfwt'];
        $waybill['discharge_weight'] = $rawData['nfawgt'];
        $waybill['sediment_amount'] = $rawData['nfy55rq'];
        $waybill['sea_water'] = $rawData['nfy55wq'];
        $waybill['sea_water_confirmation'] = $rawData['nfy55wflag'];
        $waybill['paid_sea_water'] = $rawData['nfy55pwq'];
        $waybill['discharge_gate_out_date'] = $this->convertToDate($rawData['nfy55dexd']);
        $waybill['discharge_gate_out_date_original'] = $$rawData['nfy55dexd'];

        $waybill['discharge_gate_out_time_original'] = $rawData['nfy55dext'];
        $waybill['discharge_gate_out_time'] = $this->convertToTime($rawData['nfy55dext']);

        // jo petrol waybill info
        $waybill['jo_petrol_policy_num'] = $rawData['nfldnm'];
        $waybill['jo_petrol_status'] = $rawData['nf55status'];
        $waybill['jo_petrol_waybill_date'] = $rawData['nftrdj'];
        $waybill['jo_petrol_waybill_time'] = $rawData['nflalt'];
        $waybill['jo_petrol_claim_number'] = $rawData['nf55cref'];

        return $waybill;
    }

    // ----------------------------------------------------------- //
    // ---------------- cargo types convertion ------------------- //
    // ----------------------------------------------------------- //
    private function reverseCargoTypes($ct)
    {
        $cargoTypes =
            [
                77 => 920301, // نفط خام T1
                45 => 920302, // فيول 
                43 => 920303, // سولار             
                42 => 920304, // بنزين  
                66 => 920305   // افتور 
            ];
        return $cargoTypes[$ct];
    }

    // ------------------------------------------------------------- //
    // ---------------- Date and time convertion ------------------- //
    // ------------------------------------------------------------- //
    private function convertToDate($jDate)
    {
        if ($jDate) {
            $Day = $jDate % 1000;
            $Day = $Day - 1;
            $Year = (($jDate - $Day + 2000000) / 1000) - 100;
            $result =  date('Y-m-d', strtotime($Year . '-1-1' . " + $Day days"));
            return $result;
        } else {
            return "";
        }
    }
    private function convertToTime($time)
    {
        if ($time) {
            return date("H:i:s", strtotime(str_pad($time, 6, "0", STR_PAD_LEFT)));
        } else {
            return "";
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------ get a list of all non crude_oil waybills from Jo petrol system , in order to check if any of these trucks has crude_oil queue ----- //
    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    public function getLoadsData()
    {
        $url = Config::$jo_petrol_microservice_base_url . '/face';
        $fields = array(
            'method' => "GetLoadData"
        );

        // call the remote endpoint
        $response = $this->curl($url, $fields);

        $json_response = json_encode($response);

        //insert data in database
        $params = [$json_response, 'ACTIVE'];
        $query = "INSERT INTO `waybill`.`jo_petrol_loads` (`details`, `status`)  VALUES (?, ?)";
        $result = DBConnection::runBindDatabaseQuery($query, $params);

        // remove received data by api
        $r = $this->removeReceivedLoads($response);
        return $r;
    }

    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    // -------------- When the system finds that a truck has another non crude_oil waybill is done on Jo petrol system and has active queue  ---- //
    // -------------- a punshment of 48 hours pending on tender_truck is applied ---------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    public function applyPunishmentOnTrucks()
    {

        // search for active jo_petrol_loads 
        $query = "select id , CAST(`details` AS CHAR CHARSET UTF8) AS details from `waybill`.`jo_petrol_loads` where id = 1623";
        $recordsResult = DBConnection::runBindDatabaseQuery($query, []);

        foreach ($recordsResult as $patch) {
            $records = json_decode($patch->details);

            foreach ($records as $record) {


                //if the record create_date is less that today, skip it
                $record->create_date =  $this->convertToDate($record->create_date);
                $record_date = date_create($record->create_date);
                $system_date = date_create(DBConnection::getSystemDate());
                $dateDiff = date_diff($record_date,$system_date);
                if($dateDiff->d > 1) continue;
                if($dateDiff->m > 0) continue;
                if($dateDiff->y > 0) continue;

                // // skip Hamzah well
                // 4 = Hamzeh Well
                if($record->destination_number == "4") continue;

                // search in queue 11 if it has a rank
                $queueSearchFilter = [
                    ['key' => 'tn', 'val' => $record->tn],
                    ['key' => 'tender_id', 'val' => 11],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                ];
                $queueResult = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, 0);

                if ($queueResult->found_rows > 0) {

                    // get the tender truck on crude oil
                    $tenderSearchFilter = [
                        ['key' => 'tn', 'val' => $record->tn],
                        ['key' => 'tender_id', 'val' => 11],
                        ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                    ];
                    $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);
                    $tender_truck_bean = $tenderTruckResult->data[0];

                    try {
                        DBConnection::startTransaction();

                        // change status of tender truck to pending
                        if($tender_truck_bean->status == "ACTIVE"){
                            $this->_tenderCore->changeTruckStatus($tender_truck_bean->id, 'PENDING', 0);
                        }

                        if ($queueResult->found_rows > 0) {
                            $queue_bean = $queueResult->data[0];
                            $this->_queueCore->changeStatus($queue_bean->id, "INACTIVE", 0);

                            // Send SMS
                            try{
                                $messageRecipient = $queue_bean->driver_phone;
                                $messageRecipient = convertToInternational($messageRecipient);
                                $messageBody = "$record->tn - تم شطب دور الشاحنة بسبب ازدواجية التحميل";
                                sendSMS($messageRecipient,$messageBody);
                                logHamzeh("send SMS",$messageBody . "-" . $messageRecipient);
                            }catch(Exception $e){}
                        }

                        // search in queue 12
                        $queueSearchFilter2 = [
                            ['key' => 'tn', 'val' => $record->tn],
                            ['key' => 'tender_id', 'val' => 12],
                            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                        ];
                        $queueResult2 = $this->_queueCore->searchQueue($queueSearchFilter2, 1, 0, 0);
                        if($queueResult2->found_rows > 0){
                            $queue_bean2 = $queueResult2->data[0];

                            // change queue 12 to INACTIVE
                            $this->_queueCore->changeStatus($queue_bean2->id, "INACTIVE", 0);
                        }

                        //write remark on tender_truck 11
                        $addNoteCore = new Add_notes_core();
                        $revokeDateEnd = date('Y-m-d H:i', strtotime(DBConnection::getSystemDate() . ' + 2 day'));
                        $addNoteCore->addNotes(
                            'tender_truck',
                            $tender_truck_bean->id,
                            'تم ايقاف عقد تشغيل الشاحنة لمدة يومين بسبب ازدواجية التحميل' . '- سيتم فك الايقاف بتاريخ: ' . $revokeDateEnd,
                            0
                        );
                        // create task to activate the contracts after 2 days
                        $taskQueuesCore = new TaskQueuesCore();
                        $taskQueuesCore->unfreezeDuplicatedLoadersQueue($tender_truck_bean->id);

                        DBConnection::commitTransaction();

                    } catch (Exception $e) {
                        DBConnection::rollBackTransaction();

                        // inform supoervisor
                        $socialCore = new SocialCore();
                        $socialCore->informSupervisor('خطأ في الإزدواجية', $e->getMessage(), $e->getMessage(), 2);
                    }
                }
            }

            // complete the record
            $query = "update `waybill`.`jo_petrol_loads` set status = 'COMPLETE' where id = ?";
            $recordsResult = DBConnection::runBindDatabaseQuery($query, [$patch->id]);

        }
    }

    // ---------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- after the system loads the data from jo petrol system, this method flag the record to be deleted --------------- //
    // ---------------------------------------------------------------------------------------------------------------------------------- //
    private function removeReceivedLoads($data)
    {
        $url = Config::$jo_petrol_microservice_base_url . '/face';

        $dataParam = [];
        foreach ($data as $record) {
            $temp = new stdClass();
            $temp->load_number = $record['load_number'];
            $temp->trip_depot = $record['trip_depot'];
            $dataParam[] = $temp;
        }

        $fields = array(
            'method' => "SentLoads",
            'data' => $dataParam
        );

        // call the remote endpoint
        $response = $this->curl($url, $fields);       
        return $response;
    }
}
