<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
libxml_disable_entity_loader(false);

class Grains
{

    private $url = 'http://194.165.156.202:8082/Service.svc?wsdl';

    // ----------------------------------------------------------------------------------------------- //
    // ------------------ insert new waybill into Jo_Petrol system ----------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function insertAqabaWaybill($waybillBean)
    {

        try {


            libxml_disable_entity_loader(false);

            // init objects
            $driverCore = new DriverCore();
            $truckCore = new TruckCore();

            // get driver bean
            $driver_id = $waybillBean->document->carrier[0]->driver->id;
            $driverBean = $driverCore->getDriverBasic($driver_id, 0);

            // get truck bean
            $truck_id = $waybillBean->document->carrier[0]->truck->id;

            $opts = array(
                'http' => array(
                    'user_agent' => 'PHPSoapClient'
                )
            );
            $context = stream_context_create($opts);
            $soapClientOptions = array(
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                "soap_version" => SOAP_1_1, "trace" => 1,
                'verifypeer' => false,
                'verifyhost' => false
            );

            $client = new SoapClient($this->url, $soapClientOptions);

            $user_param = array(
                'RefNo' => $waybillBean->wn,
                'PermitNo' => $waybillBean->wn,
                'PermitDate' => date_format(date_create($waybillBean->create_date), "Y-m-d"), //"2020-01-01",
                'TruckNo' => $waybillBean->document->carrier[0]->truck->tn,
                'TrailerNo' => $waybillBean->document->carrier[0]->trailer->tn,
                'Location' => 420, //420 صوامع العقبة
                'DeliveryLoc' => $waybillBean->document->negotiable_instructios->route->origin->name,
                'Item' => "0",
                'ExpArrivalDate' => date_format(date_create(DBConnection::getSystemDate()), "Y-m-d"),
                'UoM' => "KG",
                'U_ArrivalTime' => date_format(date_create(DBConnection::getSystemDate()), "Y-m-d"),
                'Destination' => 10184, //10184  وزارة الصناعة
                'DeliveryCompany' => $waybillBean->document->negotiable_instructios->route->destination->name,
                'DeliveryNo' => "0",
                'Driver' => $waybillBean->document->carrier[0]->driver->name,
                'LicenseNo' => $driverBean->license_number ? $driverBean->license_number : 0,
                'DrivLicenseNo' => $driverBean->license_number ? $driverBean->license_number : 0,
                'DrivNailID' => $waybillBean->document->carrier[0]->driver->nn ? $waybillBean->document->carrier[0]->driver->nn : 0
            );

            $service_param = array(
                'objSecurity' => $user_param,
                "OutPut" => NULL,
                "ErrorMsg" => NULL
            );
            $result = $client->HH_Add_Truck($user_param);

            dump($result);die;

            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ get waybill from grains system ----------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function getAqabaWaybillInfo($wn)
    {


        try {
            libxml_disable_entity_loader(false);

            $opts = array(
                'http' => array(
                    'user_agent' => 'PHPSoapClient'
                )
            );
            $context = stream_context_create($opts);
            $soapClientOptions = array(
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                "soap_version" => SOAP_1_1, "trace" => 1,
                'verifypeer' => false,
                'verifyhost' => false
            );

            // $client = new SoapClient($this->url, $soapClientOptions);
            $client = new SoapClient($this->url);

            $user_param = array(
                'PermitNo' => $wn
            );

            $service_param = array(
                'objSecurity' => $user_param,
                "OutPut" => NULL,
                "ErrorMsg" => NULL
            );
            $result = $client->HH_Get_TruckLoading($user_param);
            $result = json_decode($result->HH_Get_TruckLoadingResult);

            if ($result) {
                foreach ($result as $wbl) {
                    if (isset($wbl->WeightExit) && isset($wbl->WeightEmp) && intval($wbl->WeightExit) - intval($wbl->WeightEmp) != 0) {
                        return $wbl;
                    }
                }
            }

            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}
