<?php

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");

class FPS
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {
        return 'Wmhp3PDmnApf53Vv';
    }


    // ************************************************************************************************ //
    // ************************************* ACCOUNT PART ********************************************* //
    // ************************************************************************************************ //

    // ------------------------------------------------------------------------- //
    // ------------------ Search for account on FPS system --------------------- //
    // ------------------------------------------------------------------------- //
    public function testProcess($user_id)
    {

        $url = Config::$fps_url . "/claim";
        $fields = new stdClass();
        $fields->method = "testProcess";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ Search for account on FPS system --------------------- //
    // ------------------------------------------------------------------------- //
    public function getAccountBasic($account_id, $user_id)
    {

        $url = Config::$fps_url . "/account";
        $fields = new stdClass();
        $fields->method = "getAccountBasic";
        $fields->account_id = $account_id;

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ Search for account on FPS system --------------------- //
    // ------------------------------------------------------------------------- //
    public function getCompanyBankAccount($companyBankAccountId, $user_id)
    {

        $url = Config::$fps_url . "/account";
        $fields = new stdClass();
        $fields->method = "getCompanyBankAccount";
        $fields->id = $companyBankAccountId;

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response['data'];
    }

    // ------------------------------------------------------------------------- //
    // ------------------ Search for account on FPS system --------------------- //
    // ------------------------------------------------------------------------- //
    public function searchAccount($fields, $user_id)
    {

        $url = Config::$fps_url . "/account";
        $fields->method = "searchAccount";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response;
    }

    // --------------------------------------------------------------------------//
    // ------------------- Search trx stattment  --------------------------------//
    // --------------------------------------------------------------------------//
    public function searchTrxStatment($fields, $user_id)
    {

        $url = Config::$fps_url . "/account";
        $fields->method = "searchTrxStatment";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response;
    }

    // ---------------------------------------------------------------------- //
    // ------------------ Create a sub account for a certain ledger --------- //
    // ---------------------------------------------------------------------- //
    public function createSubAccount($fields, $user_id)
    {

        $url = Config::$fps_url . "/account";
        $fields->method = "createSubAccount";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response['SUB_ID'];
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummaryForAccount($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialSummaryForAccount";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ----------------------------------------------------------------------------------------------- //
    // ----------------- Search for accounts for TC, PA, CA accounts --------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchCompanyAccounts($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "searchCompanyAccounts";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ----------------------------------------------------------------------------------------------- //
    // ----------------- Search for accounts for TC, PA, CA accounts --------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchCashBoxAccount($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "searchCashBoxAccount";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------- get a list of financial account for any user or company  grouped by type--------------------- //
    // ----------------- params: account_id -------------------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function getFinancialAccounts($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialAccounts";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }


    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: company_id, user_id--------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_scoreCards($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialSummary_scoreCards";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account payables --------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AP($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialSummary_AP";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account receivable ------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AR($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialSummary_AR";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_cashFlow($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getFinancialSummary_cashFlow";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // -------------------------------------------------------------------- //
    // --------------------- get account bean + trx ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function getAccount($data, $user_id)
    {
        $url = Config::$fps_url . "/account";

        $data->method = "getAccount";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for vouchers using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function depositeAssetsBalance($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "depositeAssetsBalance";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    // ------------------------------------------------------------------------ //
    // -------------------move balance between 2 accounts ---------- //
    // ------------------------------------------------------------------------ //
    public function moveBalanceBetweenAccounts($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "moveBalanceBetweenAccounts";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    // -------------------------------------------------------------------------------------------------- //
    // ----------------- get account statment for report "كشف الحسابات" --------------------------------- //
    // ----------------- params: account_id, from_date, to_date, limit ---------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getAccountStatement($data, $limit, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->limit = $limit;
        $data->method = "getAccountStatement";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }



    // ************************************************************************************************ //
    // ************************************* VOUCHER PART ********************************************* //
    // ************************************************************************************************ //

    // -------------------------------------------------------------- //
    // --------------------- get voucher info------------------------- //
    // -------------------------------------------------------------- //
    public function getVoucher($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";

        $data->method = "getVoucher";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for vouchers using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchVouchers($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "searchVouchers";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }

    // --------------------------------------------------------- //
    // ------------------ create voucher  ---------------------- //
    // --------------------------------------------------------- //
    public function createVoucher($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "createVoucher";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }

       // --------------------------------------------------------- //
    // ------------------ insert  voucher  ---------------------- //
    // --------------------------------------------------------- //
    public function insertVoucher($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "insertVoucher";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }

    
    // ------------------------------------------------------------------------- //
    // ------------------ process voucher and complete it ---------------------- //
    // ------------------------------------------------------------------------- //
    public function processVoucherTrx($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "processVoucherTrx";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ get voucher audit report  ---------------------- //
    // ------------------------------------------------------------------------- //
    public function gitVoucherAuditReport($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "gitVoucherAuditReport";
        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);

        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ testZainHandler --------------------- //
    // ------------------------------------------------------------------------- //
    public function testZainHandler($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "testZainHandler";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ testZainHandler --------------------- //
    // ------------------------------------------------------------------------- //
    public function testZainFail($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "testZainFail";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }


    // ------------------------------------------------------------------------ //
    // ------------------ change voucher status to INACTIVE ------------------- //
    // ------------------------------------------------------------------------ //
    public function changeVoucherStatus($data, $user_id)
    {

        $url = Config::$fps_url . "/voucher";

        $data->method = "changeStatus";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // --------------------------------------------------------------------------- //
    // ------------------ get claim info from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function undoJV($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "undoJV";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }



    // ************************************************************************************************ //
    // ************************************* CLAIMS PART ********************************************** //
    // ************************************************************************************************ //

    // --------------------------------------------------------------------------- //
    // ------------------ get claim info from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function getClaim($id, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data = new stdClass();
        $data->id = $id;
        $data->method = "getClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ------------------------------------------------------------------------------- //
    // ------------------ search multi claims info using filter from FPS system ------------------- //
    // ------------------------------------------------------------------------------- //
    public function searchClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "searchClaims";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        if ($response == "[]") {
            $response = [];
            $response['data'] = [];
            $response['found_rows'] = 0;
        }

        return  $response;
    }

    // ------------------------------------------------------------------------------- //
    // ------------------ search multi claims info using filter from FPS system ------------------- //
    // ------------------------------------------------------------------------------- //
    public function searchMGClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "searchMGClaims";
        $data->limit = 999;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        if ($response == "[]") {
            $response = [];
            $response['data'] = [];
            $response['found_rows'] = 0;
        }

        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ search for claim items from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchClaimItems($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "searchClaimItems";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // -----------------------SEE WHY THIS-------------------------------------------------------------------- //
    // ------------------ search  claim items from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchInactiveClaimItems($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "searchInactiveClaimItems";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get certain claim item from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getClaimItem($id, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data = new stdClass();
        $data->id = $id;
        $data->method = "getClaimItem";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ cappend new item to claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function appendItemToClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "appendItemToClaim";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ cappend new item to claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function updateClaimItemApprovedInfo($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "updateClaimItemApprovedInfo";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ cappend new item to claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function updateClaimItemRequestedInfo($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "updateClaimItemRequestedInfo";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ cappend new item to pa claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function appendItemToPaClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "appendItemToPaClaim";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ this is the main function to add any item to FPS claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function payClaimItem($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "payClaimItem";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ------------------------------------------------------------------- //
    // ---------------------  searchPayableClaims ------------------------ //
    // ------------------------------------------------------------------- //
    public function searchPayableClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "searchPayableClaims";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // --------------------------------------------------------------------- //
    // ---------------------  search receivable Claims --------------------- //
    // --------------------------------------------------------------------- //
    public function searchReceivableClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "searchReceivableClaims";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ this is the main function to add any item to FPS claim ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function approveClaimItem($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "approveClaimItem";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------search for available claims in order new item automaticaly ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchAvailableClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "searchAvailableClaims";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------search for available claims in order new item automaticaly ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function testAddItemAfterVoucherSuccess($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";

        $data->method = "testAddItemAfterVoucherSuccess";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "addPaymentToClaim";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToTnClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "addPaymentToTnClaim";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain Truck owner claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToTruckOwnerClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "addPaymentToTruckOwnerClaim";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToReferance($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "addPaymentToReferance";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ change  claim status from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changeClaimStatus($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "changeClaimStatus";
        // call the remote endpoint

        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ change  claim item status from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changeClaimItemStatus($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";

        $data->method = "changeClaimItemStatus";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ create new claim if not exists and create new item if dons`t create new item and append it to the claim from FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createAdvancePaymentClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "createAdvancePaymentClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }


    // -------------------------------------------------------------------------------------------------------------------------------------------------------- //
    // ------------ create new claim if not exists and create new item if dons`t create new item and append it to the claim from FPS system ------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------------------------------- //
    public function createClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "createClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------get how much is still remaining on certain claim --------------- //
    // ---------------------------------------------------------------------------------- //
    public function getClaimRemainingAmount($claim_id, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data = new stdClass();
        $data->method = "getClaimRemainingAmount";
        $data->claim_id = $claim_id;

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------get how much amount on certain claim --------------- //
    // ---------------------------------------------------------------------------------- //
    public function getClaimAmount($claim_id, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data = new stdClass();
        $data->method = "getClaimAmount";
        $data->claim_id = $claim_id;

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }



    // ---------------------------------------------------------------------------- //
    // ------------------ call cURL request to FPS end point ---------------------- //
    // ---------------------------------------------------------------------------- //
    private function curl($url, $fields, $method, $user_id)
    {

        if ($user_id == 0) {
            $user_id = 3;
        }

        $ch = curl_init();
        $fields->integration_token = $this->getIntegrationToken();
        $fields->session_id = $user_id;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }


    // ---------------------------- PA Claim part ----------------------------------

    public function searchPaClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data->method = "searchPaClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ search payment agent claim items for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchPaClaimItems($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data->method = "searchPaClaimItems";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ search payment agent claim items for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchInactivePaClaimItems($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data->method = "searchInactivePaClaimItems";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ get pa claim for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getPaClaim($id, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data = new stdClass();
        $data->id = $id;
        $data->method = "getPaClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get pa claim item for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getPaClaimItem($id, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data = new stdClass();
        $data->id = $id;
        $data->method = "getPaClaimItem";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------search payment agent added claims for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchPaAvailableClaims($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";

        $data->method = "searchPaAvailableClaims";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }
    // ------------------------------------------------------------------------------------------- //
    // ------------------ change payment agent claim status for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changePaClaimStatus($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";

        $data->method = "changePaClaimStatus";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ change payment agent claim item status for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function changePaClaimItemStatus($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";

        $data->method = "changePaClaimItemStatus";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ create new claim if not exists and create new item if dons`t create new item and append it to the claim for Minagate in FPS system ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createPaAdvancePaymentClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/pa_claim";
        $data->method = "createPaAdvancePaymentClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ Create Task to validate zain cash trx with JCB ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function validateWithJCB($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "validateWithJCB";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }


    // ---------------------------------------------------------- //
    // ------------------ Create trx only ------------------- //
    // ------------------------------------------------------ //
    public function createTrx($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "createTrx";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

     // ---------------------------------------------------------- //
    // ------------------ Create trx only ------------------- //
    // ------------------------------------------------------ //
    public function updateClaimDetails($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "updateClaimDetails";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ---------------------------------------------------------- //
    // ------------------ Create trx only ------------------- //
    // ------------------------------------------------------ //
    public function updateClaimTn($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "updateClaimTn";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ---------------------------------------------------------- //
    // ------------------ update claim details ------------------- //
    // ------------------------------------------------------ //
    public function updateClaimItemDetails($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "updateClaimItemDetails";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // --------------------------------------------------------------------------- //
    // ------------------ create cash box log using  FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function createCashBoxLog($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "createCashBoxLog";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }
    // --------------------------------------------------------------------------- //
    // ------------------ get cash box log details from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function getCashBoxLogDetails($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "getCashBoxLogDetails";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    // --------------------------------------------------------------------------- //
    // ------------------ get cash box log details from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function getJvTrx($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "getJvTrx";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }

    

    // --------------------------------------------------------------------------- //
    // ------------------ get cash box log details from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function openCashBoxLog($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "openCashBoxLog";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // --------------------------------------------------------------------------- //
    // ------------------ get cash box log details from FPS system ------------------- //
    // --------------------------------------------------------------------------- //
    public function closeCashBoxLog($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "closeCashBoxLog";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }


    //////////////////////////// fps check integration starts here ////////////////////////////////////////////////////////
    // ------------------------------------------------------------------------ //
    // -------------------search for company details using  search filter from fps system  ---------- //
    // ------------------------------------------------------------------------ //
    public function searchCompanyBankDetails($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "searchCompanyBankDetails";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // ------------------------------------------------------------------------ //
    // ------------------- create new list of checks on fps system  ---------- //
    // ------------------------------------------------------------------------ //
    public function createNewListOfCheck($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "createNewListOfCheck";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // ------------------------------------------------------------------------ //
    // ------------------- crete new check on fps system  ---------- //
    // ------------------------------------------------------------------------ //
    public function createNewCheck($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "createNewCheck";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // ------------------------------------------------------------------------ //
    // ------------------- get singe check from fps system  ---------- //
    // ------------------------------------------------------------------------ //
    public function getCheck($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "getCheck";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // ------------------------------------------------------------------------ //
    // ------------------- search for checks list using  search filter from fps system    ---------------- //
    // ------------------------------------------------------------------------ //
    public function searchChecks($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "searchChecks";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    // ------------------------------------------------------------------------ //
    // ------------------- change check status form fps system  ---------- //
    // ------------------------------------------------------------------------ //
    public function changeCheckStatus($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "changeCheckStatus";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------------------- //
    // ------------------  Reserve check by change its status to Pending ------------------- //
    // ------------------------------------------------------------------------------------- //
    public function aquireCheck($data, $user_id)
    {
        $url = Config::$fps_url . "/check";
        $data->method = "aquireCheck";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------ Start the process of group of vouchers to be paid as checks ----------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function addVouchersToCheck($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "addVouchersToCheck";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ---------------------------------------------------------------------------- //
    // ------------  make claim settelment to PA or company ----------------------- //
    // ---------------------------------------------------------------------------- //
    public function claimSettelment($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "claimSettelment";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }




    // ---------------------------- PA Claim part ----------------------------------
    public function searchCompletedClaimReport($data, $user_id)
    {

        $url = Config::$fps_url . "/claim";
        $data->method = "searchCompletedClaimReport";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ----------------------------------------------------------------------------------- //
    // --------------------- search fore active Claim Report -------------------------- //
    // ----------------------------------------------------------------------------------- //
    public function searchActiveClaimReport($data, $user_id)
    {

        $url = Config::$fps_url . "/claim";
        $data->method = "searchActiveClaimReport";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    //////////////////////////// fps check integration ends here ////////////////////////////////////////////////////////////

    // ------------------------------------------------------------------------------------------- //
    // ------------------ to get all approved items for exporting the voucher  ------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function FpsGetApprovedItemsForPa($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "FpsGetApprovedItemsForPa";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // --------------------------------------------------------------------------------------------- //
    // ----------------------- get voucher trx tremplate based on code------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function getVoucherTypeTemplate($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher";
        $data->method = "getVoucherTypeTemplate";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // --------------------------------------------------------------------------------------------- //
    // ----------------------- get voucher trx tremplate based on code------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function fpsCloseAuditBoxReport($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "fpsCloseAuditBoxReport";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // --------------------------------------------------------------------- //
    // -----------------------  create truck claim ------------------------- //
    // --------------------------------------------------------------------- //
    public function createTruckClaim($data, $user_id)
    {
        $url = Config::$fps_url . "/claim";
        $data->method = "createTruckClaim";

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    // ------------------------------------------------------------------------- //
    // ------------------ process voucher and complete it ---------------------- //
    // ------------------------------------------------------------------------- //
    public function closeWaybillByPaymentAgent($fields, $user_id)
    {

        $url = Config::$fps_url . "/voucher";
        $fields->method = "closeWaybillByPaymentAgent";

        // call the remote endpoint
        $response = $this->curl($url, $fields, 'POST', $user_id);
        return $response;
    }



    // -------------------------------------------------------------- //
    // --------------------- get voucher item info------------------------- //
    // -------------------------------------------------------------- //
    public function getVoucherItem($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher_item";

        $data->method = "getVoucherItem";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return  $response;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for voucher items using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchVoucherItems($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher_item";
        $data->method = "searchVoucherItems";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return $response;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for voucher items using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function createVoucherItem($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher_item";
        $data->method = "createVoucherItem";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
     // ------------------------------------------------------------------------ //
    // -------------------cashbox report -------------- //
    // ------------------------------------------------------------------------ //
    public function cash_box_report($data, $user_id)
    {
        $url = Config::$fps_url . "/account";
        $data->method = "cash_box_report";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

    public function generateVoucherTrx($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher_trx_template";
        $data->method = "generateVoucherTrx";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }
    public function getVoucherTrx($data, $user_id)
    {
        $url = Config::$fps_url . "/voucher_trx_template";
        $data->method = "getVoucherTrx";
        $data->limit = 500;
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);
        return $response;
    }

}
