<?php

require_once dirname(__FILE__) . "/../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../includes/config.php";

class ACT
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    public function getActContainerInfo($ids)
    {

        $url = Config::$ACT_base_url;
        $data = new stdClass();
        $data->method = "getDataFromACT";
        $data->ids = $ids;

        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST');

        return $response;
    }
    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ------------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');

            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));

        }
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}
