<?php


require_once(dirname(__FILE__) . "/Watcher.php");
require_once(dirname(__FILE__) . "/../../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../tender/tender_core.php");

class WaybillWatcher extends Watcher
{

    private $_waybillCore;
    private $_tenderCore;

    public function __construct()
    {
        $this->_waybillCore = new WaybillCore();
        $this->_tenderCore = new TenderCore();
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ------------------ Create New Watcher (task) after n amount of hours ---------------------------------------------- //
    // ------------------ This method creates a task only , the task handler will act and create a ticket ---------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function createWatcher($waybillId, $newStatus)
    {

        $waybillBean = $this->_waybillCore->getWaybillBasic($waybillId,"0");

        // in case the waybill status is NEW or ACTIVE
        switch ($newStatus){
            case "NEW":
                if($waybillBean->tender_id == 15){
                    $delay = 48 * 60 * 60; // 48H
                }else{
                    $delay = 24 * 60 * 60; // 24H
                }

                $taskName = "waybill_id_" . $waybillId . "_status_" . $newStatus . "_" . uniqid();
                $payload = [
                  "object_code" => "WAYBILL",
                  "object_id" => $waybillId,
                  "new_status" => $newStatus
                ];
                $this->createTask($taskName, $payload, $delay);
                break;
        }
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ---------------------------- Create the corresponding action when the wathcer task is done waiting ------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function handleWatcher($waybillId, $newStatus)
    {

        $waybillBean = $this->_waybillCore->getWaybillBasic($waybillId,"0");
        $tender_bean = $this->_tenderCore->getTenderBasic($waybillBean->tender_id,"0");
        $tender_name = $tender_bean->manifest->name;
        $tn = $waybillBean->document->carrier[0]->truck->tn;
        $trn = $waybillBean->document->carrier[0]->trailer->trn;

        // Switch over newStatus
        switch ($newStatus){
            case "ACTIVE":
                // Validate the waybill watcher
                // $validation = $this->validate($waybillId, $newStatus);
                // if (!$validation){
                //     // Create a ticket of type [OBJECT] and type_code [LOADING_DELAY]
                //     $ticket = new stdClass();
                //     $ticket->title = "معاملة تأخر عن التحميل" . "-" . $tender_name;
                //     $ticket->senderName = "مدارج للخدمات اللوجستية";
                //     $ticket->type_code = "WAYBILL_LOADING_DELAY";
                //     $ticket->priority = 3;
                //     $ticket->company_id = 266770;
                //     $ticket->tn = $tn;
                //     $ticket->trn = $trn;
                //     $ticket->body = [
                //         "waybill_id" => $waybillId,
                //         "type_code" => "WAYBILL_LOADING_DELAY",
                //         "tender_id" => $waybillBean->tender_id,
                //     ];
                //     return $this->createTicket($ticket);
                // }
                break;
            case "NEW":
                    // Create a ticket if the waybill has no actions after 24 of creation
                    $validation = $this->validate($waybillId, $newStatus);
                    if (!$validation) {
                        // Create a ticket of type [OBJECT] and type_code [LOADING_DELAY]
                        $ticket = new stdClass();
                        $ticket->title = "معاملة مستند جديد لأكثر من 24 ساعة" . $tender_name;
                        $ticket->senderName = "مدارج للخدمات اللوجستية";
                        $ticket->type_code = "WAYBILL_NO_ACTION";
                        $ticket->priority = 3;
                        $ticket->company_id = 266770;
                        $ticket->tn = $tn;
                        $ticket->trn = $trn;
                        $ticket->body = [
                            "waybill_id" => $waybillId,
                            "tender_id" => $waybillBean->tender_id
                        ];
                        return $this->createTicket($ticket);
                    }
                    break;
        }
    }

    /**
     *@inheritDoc
     */
    public function validate($waybillId, $newStatus)
    {
        // Get waybill bean
        $waybill = $this->_waybillCore->getWaybillBasic($waybillId,"0");

        // Switch over newStatus
        switch ($newStatus){
            case "ACTIVE":
                // check loading_date
                return isset($waybill->loading_date) && !empty($waybill->loading_date);
                break;
            case "NEW":
                // check status
                return strtoupper($waybill->status) !== "NEW";
                break;
        }

        return false;
    }
}