<?php

require_once (dirname(__FILE__)."/../../taskQueues/taskQueues_core.php");
require_once (dirname(__FILE__)."/../../outgoing_integration/customer_care.php");

abstract class Watcher
{
    /**
     * Create a watcher
     * @param string|int $objectId Object ID
     * @param string $newStatus Object new status (ACTION)
     * @return void
     */
    public abstract function createWatcher($objectId, $newStatus);

    /**
     * Handle what the watcher action when executed
     * @param $objectId
     * @param $newStatus
     * @return string
     */
    public abstract function handleWatcher($objectId, $newStatus);

    /**
     * Validate the action which received by the handler if should pass
     * @param string|int $objectId Object ID
     * @param string $newStatus Object new status (ACTION)
     * @return bool true if validator pass
     */
    public abstract function validate($objectId, $newStatus);

    /**
     * Creates GCP Cloud Task for objects watchers
     * @param string $taskName short task name
     * @param array $taskRequestPayload AppEngine request payload
     * @param int $delayInSeconds Task execution delay
     * @throws Exception
     */
    protected function createTask($taskName, $taskRequestPayload, $delayInSeconds){
        (new TaskQueuesCore())->createWatcherTask($taskName, $taskRequestPayload, $delayInSeconds);
    }

    protected function createTicket($data){
        $customerCare = new CustomerCare();
        $filters = new stdClass();
        $filters->ticket_type = 'object';
        return $customerCare->createTicket($data, $filters);
    }
}