<?php

require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/object_watcher_core.php";
class ObjectWatcherInterface extends API
{
    private $_request;
    private $_objectWatcherCore;
    public function __construct(){
        $this->_objectWatcherCore = new ObjectWatcherCore();

        // call the super constructur
        $this->_request = parent::__construct();
        session_start();
        if( !isset($_SESSION['user_id'])){
            $msg = json_encode($_SESSION, JSON_UNESCAPED_UNICODE);
            throw new Exception('No Session!' . $msg);
        }


        $method = $this->_request->method;
        unset($this->_request->method);
        $this->callMethod($method);
    }

    /**
     * Handles the watcher AppEngine request
     * params: { object_code: string, object_id: int|string, new_status: string }
     * @api /object_watcher method=handleWatcher
     */
    public function handleWatcher(){
        // validate params
        $errors = [];
        if (!isset($this->_request->object_code)){
            $errors[] = "object_code of type string is required";
        }
        if (!isset($this->_request->object_id)){
            $errors[] = "object_id of type int|string is required";
        }
        if (!isset($this->_request->new_status)){
            $errors[] = "new_status of type string is required";
        }
        // if any errors throw
        if (!empty($errors)){
            throw new Exception(json_encode($errors));
        }

        $objectCode = strtoupper(trim($this->_request->object_code));
        $objectId = $this->_request->object_id;
        $newStatus = strtoupper(trim($this->_request->new_status));

        $this->_objectWatcherCore->handleWatcher($objectCode, $objectId, $newStatus);

    }

    private function callMethod($methodName){
        // Validate Methods
        if (!isset($methodName)){
            throw new Exception("{method} param is required");
        }
        // Prepare Methods
        $methodName = trim($methodName);
        $methods = [
            "handleWatcher"
        ];
        // Check if the method is allowed
        if (!in_array($methodName, $methods, true)){
            throw new Exception("The method required is not allowed here, got $methodName");
        }
        // Call method
        $this->{$methodName}();
    }
}
new ObjectWatcherInterface();